/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#ifndef CONNECT_H
#define CONNECT_H

#include <oci.h>
#include <string>

using namespace std;

//! This class represents a connection to ORACLE database.
class OCIConnection
{
protected:
	bool	     connected;		// if it is connected or not
	string       errorMess;		// error message

public:
	// OCI connection handles
	OCIEnv*			envhp;  //environment handle - ambiente       
	OCIError*		errhp;	//environment handle - error handle

	OCIServer*		srvhp;	//service context handle - identifica uma conexao com o banco
	OCISvcCtx*		svchp;	//service context handle
	OCISession*		usrhp;	//service context handle - define as permissoes e privilegios dos usuarios 
	OCITrans*		txnhp;	//service context handle - transacao

	OCIStmt*		stmthp;		// environment handle - statement handle

	OCIType*		tdo_geometry; 	//describe the sdo_geometry type 
	OCIType*		tdo_ordinates;  //describe the sdo_ordinates type 
	OCIArray*		ordinates;		//store the ordinates to insert into database (bind)	

public:
	
	//! Connection constructor
	OCIConnection();

	//! Connection destructor
	~OCIConnection() { Disconnect(); }

	//! Connect to ORACLE
	bool Connect(const char* dblink, const char* username, const char* password);

	//! Disconnect to ORACLE
	void Disconnect();

	//! Prepare the statement to be executed
	bool Prepare(const string& stmt);

	//! Bind
	bool BindByPos(int pos, void* value, int size, void* indicator, int type);
	bool BindByName(char* name, void* value, int size, void* indicator, int type);
	bool BindOrdinates();

	//! Append ordinates to be inserted or updated
	bool AppendOrdinates(const double& val);

	//! Locate memory to ordinates 
	bool AllocateObjectOrdinates();

	//! Return query type 
	int	QueryType(void);

	//! Starts a transaction 
	bool TransStart();

	//! Returns a transaction
	bool TransRollback();

	//! Commits a transaction
	bool TransCommit();
	
	//! Execute only commands that do not return rows (INSERT, UPDATE, DELETE, etc)
	bool Execute(const string& stm);
	
	//! Execute only commands that insert or update rows with SDO Objects 
	bool ExecuteSDOSTM(const string& stm);

	//! Check if there is an opened conection
	bool IsConnected() { return connected; }

	//! Check OCI error
	bool CheckError(OCIError* errhp, int status);

	//! Gets the error message
	string getErrorMessage() { return errorMess; }
};

#endif
