#include <TePDIContrast.hpp>
#include <TePDIParameters.hpp>
#include <TePDIUtils.hpp>
#include <TePDIRgbPalette.hpp>

#include <TeRaster.h>
#include <TeDataTypes.h>
#include <TeDecoderTIFF.h>
#include <TeInitRasterDecoders.h>

#include <TePDIAgnostic.hpp>

#include <string>

void TePDIContrastMinMax_test()
{
  TePDIParameters params;

  int contrast_type = TePDIContrast::TePDIContrastMinMax;
  params.SetParameter( "contrast_type", contrast_type );

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );
  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( inRaster,
    outRaster ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "histo_levels", (int)256 );

  TePDIContrast contra;

  PDIAGN_TRUE_OR_THROW( contra.Reset( params ),
    "Invalid Parameters" );

  PDIAGN_TRUE_OR_THROW( contra.Apply(),
    "Apply error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    "TePDIContrastMinMax_test.tif" ), "GeoTIF generation error" );
}


void TePDIContrastLinear_test()
{
  TePDIParameters params;

  int contrast_type = TePDIContrast::TePDIContrastLinear;
  params.SetParameter( "contrast_type", contrast_type );

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );
  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( inRaster,
    outRaster ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "histo_levels", (int)256 );

  params.SetParameter( "min_level", (double)46 );
  params.SetParameter( "max_level", (double)102 );

  TePDIContrast contra;

  PDIAGN_TRUE_OR_THROW( contra.Reset( params ),
    "Invalid Parameters" );

  PDIAGN_TRUE_OR_THROW( contra.Apply(),
    "Apply error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    "TePDIContrastLinear_test.tif" ), "GeoTIF generation error" );
}

void TePDIContrastSquareRoot_test()
{
  TePDIParameters params;

  int contrast_type = TePDIContrast::TePDIContrastSquareRoot;
  params.SetParameter( "contrast_type", contrast_type );

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );
  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( inRaster,
    outRaster ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "histo_levels", (int)256 );

  params.SetParameter( "min_level", (double)46 );
  params.SetParameter( "max_level", (double)102 );

  TePDIContrast contra;

  PDIAGN_TRUE_OR_THROW( contra.Reset( params ),
    "Invalid Parameters" );

  PDIAGN_TRUE_OR_THROW( contra.Apply(),
    "Apply error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    "TePDIContrastSquareRoot_test.tif" ), "GeoTIF generation error" );
}

void TePDIContrastSquare_test()
{
  TePDIParameters params;

  int contrast_type = TePDIContrast::TePDIContrastSquare;
  params.SetParameter( "contrast_type", contrast_type );

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );
  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( inRaster,
    outRaster ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "histo_levels", (int)256 );

  params.SetParameter( "min_level", (double)46 );
  params.SetParameter( "max_level", (double)102 );

  TePDIContrast contra;

  PDIAGN_TRUE_OR_THROW( contra.Reset( params ),
    "Invalid Parameters" );

  PDIAGN_TRUE_OR_THROW( contra.Apply(),
    "Apply error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    "TePDIContrastSquare_test.tif" ), "GeoTIF generation error" );
}

void TePDIContrastLog_test()
{
  TePDIParameters params;

  int contrast_type = TePDIContrast::TePDIContrastLog;
  params.SetParameter( "contrast_type", contrast_type );

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );
  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( inRaster,
    outRaster ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "histo_levels", (int)256 );

  params.SetParameter( "min_level", (double)46 );
  params.SetParameter( "max_level", (double)102 );

  TePDIContrast contra;

  PDIAGN_TRUE_OR_THROW( contra.Reset( params ),
    "Invalid Parameters" );

  PDIAGN_TRUE_OR_THROW( contra.Apply(),
    "Apply error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    "TePDIContrastLog_test.tif" ), "GeoTIF generation error" );
}

void TePDIContrastNegative_test()
{
  TePDIParameters params;

  int contrast_type = TePDIContrast::TePDIContrastNegative;
  params.SetParameter( "contrast_type", contrast_type );

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );
  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( inRaster,
    outRaster ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "histo_levels", (int)256 );

  params.SetParameter( "min_level", (double)46 );
  params.SetParameter( "max_level", (double)102 );

  TePDIContrast contra;

  PDIAGN_TRUE_OR_THROW( contra.Reset( params ),
    "Invalid Parameters" );

  PDIAGN_TRUE_OR_THROW( contra.Apply(),
    "Apply error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    "TePDIContrastNegative_test.tif" ), "GeoTIF generation error" );
}

void TePDIContrastHistEqualizer_test()
{
  TePDIParameters params;

  int contrast_type = TePDIContrast::TePDIContrastHistEqualizer;
  params.SetParameter( "contrast_type", contrast_type );

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );
  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( inRaster,
    outRaster ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "histo_levels", (int)256 );

  params.SetParameter( "min_level", (double)46 );
  params.SetParameter( "max_level", (double)102 );

  TePDIContrast contra;

  PDIAGN_TRUE_OR_THROW( contra.Reset( params ),
    "Invalid Parameters" );

  PDIAGN_TRUE_OR_THROW( contra.Apply(),
    "Apply error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    "TePDIContrastHistEqualizer_test.tif" ), "GeoTIF generation error" );
}

void TePDIContrastSimpleSlicer_test()
{
  TePDIParameters params;

  int contrast_type = TePDIContrast::TePDIContrastSimpleSlicer;
  params.SetParameter( "contrast_type", contrast_type );

  TePDITypes::TePDIRasterPtrType inRaster( new TeRaster(
    std::string( "../resources/cbers_b2_crop.tif" ), 'r' ) );
  PDIAGN_TRUE_OR_THROW( inRaster->init(), "Unable to init inRaster" );
  params.SetParameter( "input_image", inRaster );

  TePDITypes::TePDIRasterPtrType outRaster;
  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeAllocRAMRaster( inRaster,
    outRaster ), "RAM Raster Alloc error" );
  params.SetParameter( "output_image", outRaster );

  std::vector<int> channels;
  channels.push_back( 0 );
  params.SetParameter( "channels", channels );

  params.SetParameter( "histo_levels", (int)( 102 - 47 + 1 ) );

  params.SetParameter( "min_level", (double)47 );
  params.SetParameter( "max_level", (double)102 );

  TePDIRgbPalette::pointer pal =
    TePDIRgbPalette::createLB( 20 );
  params.SetParameter( "rgb_palette", pal );

  TePDIContrast contra;

  PDIAGN_TRUE_OR_THROW( contra.Reset( params ),
    "Invalid Parameters" );

  PDIAGN_TRUE_OR_THROW( contra.Apply(),
    "Apply error" );

  PDIAGN_TRUE_OR_THROW( TePDIUtils::TeRaster2Geotiff( outRaster,
    "TePDIContrastSimpleSlicer_test.tif" ), "GeoTIF generation error" );
}

int main()
{
  PDIAGN_LOGMSG( "Test started." );

  PDIAGN_DEBUG_MODE_CHECK;

  try{
    TeInitRasterDecoders();

    TePDIContrastMinMax_test();
    TePDIContrastLinear_test();
    TePDIContrastSquareRoot_test();
    TePDIContrastSquare_test();
    TePDIContrastLog_test();
    TePDIContrastNegative_test();
    TePDIContrastHistEqualizer_test();
    TePDIContrastSimpleSlicer_test();
  }
  catch(...){
    PDIAGN_LOGERR( "Test Failed.");
    return EXIT_FAILURE;
  }

  PDIAGN_LOGMSG( "Test OK." );
  return EXIT_SUCCESS;
}
