/* 
 * tclAppInit.c --
 *
 *	Provides a default version of the main program and Tcl_AppInit
 *	procedure for Tcl applications (without Tk).
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * Copyright (c) 1994-1997 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) tclAppInit.c 1.20 97/03/24 14:29:43
 */

#ifdef TCL_XT_TEST
#include <X11/Intrinsic.h>
#endif

#include <tcl.h>
#include "tclInt.h"
#include <lber.h>
#include <ldap.h>

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

#ifdef	__cplusplus
extern "C" {
#endif
extern int matherr _ANSI_ARGS_ ((void));
    int (*tclDummyMathPtr) _ANSI_ARGS_ ((void)) = matherr;
#ifdef	__cplusplus
}
#endif

#ifdef TCL_TEST
extern int Tcltest_Init _ANSI_ARGS_ ((Tcl_Interp * interp));
extern int Tclptest_Init _ANSI_ARGS_ ((Tcl_Interp * interp));
extern int Tclobjtest_Init _ANSI_ARGS_ ((Tcl_Interp * interp));
#endif /* TCL_TEST */

#ifdef TCL_XT_TEST
EXTERN int Tclxttest_Init _ANSI_ARGS_ ((Tcl_Interp * interp));
#endif

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tcl_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

int ldcnt = -1;
struct LDAP *ldprime[1024];

int
#ifdef _USING_PROTOTYPES_
main (
    int argc,			/* Number of command-line arguments. */
    char **argv)		/* Values of command-line arguments. */
#else
main (argc, argv)
     int argc;			/* Number of command-line arguments. */
     char **argv;		/* Values of command-line arguments. */
#endif
{
#ifdef TCL_XT_TEST
    XtToolkitInitialize ();
#endif
    Tcl_Main (argc, argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tclldap_Init (interp)
     Tcl_Interp *interp;
{
    if (Tcl_Init (interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#ifdef TCL_TEST
#ifdef TCL_XT_TEST
    if (Tclxttest_Init (interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif
    if (Tcltest_Init (interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    Tcl_StaticPackage (interp, "Tcltest", Tcltest_Init,
	(Tcl_PackageInitProc *) NULL);
    if (Tclobjtest_Init (interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    Tcl_StaticPackage (interp, "Tclobjtest", Tclobjtest_Init,
	(Tcl_PackageInitProc *) NULL);
    if (Tclptest_Init (interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    Tcl_StaticPackage (interp, "Tclptest", Tclptest_Init,
	(Tcl_PackageInitProc *) NULL);
#endif /* TCL_TEST */

    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */

    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */
    Tcl_CreateCommand (interp, "LdapBind", Tcl_LdapBindCmd,
	(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "LdapUnBind", Tcl_LdapUnBindCmd,
	(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "LdapDelete", Tcl_LdapDeleteCmd,
	(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "LdapModRDN", Tcl_LdapModRDNCmd,
	(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "LdapSearch", Tcl_LdapSearchCmd,
	(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "LdapModify", Tcl_LdapModifyCmd,
	(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "LdapAdd", Tcl_LdapModifyCmd,
	(ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

    Tcl_SetVar (interp, "tcl_rcFileName", "~/.tclshrc", TCL_GLOBAL_ONLY);
    return TCL_OK;
}
