/*******************************************************************************

        copyright:      Copyright (c) 2007 Peter Triller. All rights reserved

        license:        BSD style: 513 545 544 513 0LICENSE)

        version:        Initial release: Sept 2007

        authors:        Peter

		Contains the Unicode Data files converted to structs and simple
		accessor functions. This file is generated by a Perl script. All
		necessary changes should be made in the script, not in this file. 

*******************************************************************************/

module tango.text.UnicodeData;

struct UnicodeData {
	
	enum GeneralCategory {
         Lu = 1, //  Letter, Uppercase
        Ll = 1 <<  1, //  Letter, Lowercase
        Lt = 1 <<  2, //  Letter, Titlecase
        Lm = 1 <<  3, //  Letter, Modifier
        Lo = 1 <<  4, //  Letter, Other
        Mn = 1 <<  5, //  Mark, Nonspacing
        Mc = 1 <<  6, //  Mark, Spacing Combining
        Me = 1 <<  7, //  Mark, Enclosing
        Nd = 1 <<  8, //  Number, Decimal Digit
        Nl = 1 <<  9, //  Number, Letter
        No = 1 << 10, //  Number, Other
        Pc = 1 << 11, //  Punctuation, Connector
        Pd = 1 << 12, //  Punctuation, Dash
        Ps = 1 << 13, //  Punctuation, Open
        Pe = 1 << 14, //  Punctuation, Close
        Pi = 1 << 15, //  Punctuation, Initial quote (may behave like Ps or Pe depending on usage)
        Pf = 1 << 16, //  Punctuation, Final quote (may behave like Ps or Pe depending on usage)
        Po = 1 << 17, //  Punctuation, Other
        Sm = 1 << 18, //  Symbol, Math
        Sc = 1 << 19, //  Symbol, Currency
        Sk = 1 << 20, //  Symbol, Modifier
        So = 1 << 21, //  Symbol, Other
        Zs = 1 << 22, //  Separator, Space
        Zl = 1 << 23, //  Separator, Line
        Zp = 1 << 24, //  Separator, Paragraph
        Cc = 1 << 25, //  Other, Control
        Cf = 1 << 26, //  Other, Format
        Cs = 1 << 27, //  Other, Surrogate
        Co = 1 << 28, //  Other, Private Use
        Cn = 1 << 29, //  Other, Not Assigned (no characters in the file have this property)
        SpecialMapping = 1 << 30 // Special Bit for detection of specialMappings
    }
    
    
    enum BidiClass {
        L, //  Left-to-Right
        LRE, //  Left-to-Right Embedding
        LRO, //  Left-to-Right Override
        R, //  Right-to-Left
        AL, //  Right-to-Left Arabic
        RLE, //  Right-to-Left Embedding
        RLO, //  Right-to-Left Override
        PDF, //  Pop Directional Format
        EN, //  European Number
        ES, //  European Number Separator
        ET, //  European Number Terminator
        AN, //  Arabic Number
        CS, //  Common Number Separator
        NSM, //  Non-Spacing Mark
        BN, //  Boundary Neutral
        B, //  Paragraph Separator
        S, //  Segment Separator
        WS, //  Whitespace
        ON //  Other Neutrals
    }
    
    enum DecompositionType {
        None, // Custom type signaling no Decomposition
        Font, //    A font variant (e.g. a blackletter form).
        NoBreak, //    A no-break version of a space or hyphen.
        Initial, //    An initial presentation form (Arabic).
        Medial, //    A medial presentation form (Arabic).
        Final, //    A final presentation form (Arabic).
        Isolated, //    An isolated presentation form (Arabic).
        Circle, //    An encircled form.
        Super, //    A superscript form.
        Sub, //    A subscript form.
        Vertical, //    A vertical layout presentation form.
        Wide, //    A wide (or zenkaku) compatibility character.
        Narrow, //    A narrow (or hankaku) compatibility character.
        Small, //    A small variant form (CNS compatibility).
        Square, //    A CJK squared font variant.
        Fraction, //    A vulgar fraction form.
        Compat //    Otherwise unspecified compatibility character.
    }
    
    enum BidiMirrored {
        Y, // Yes
        N  // No
    }
    
    dchar code;
    
//    char[] name;
    
    GeneralCategory generalCategory;
    
//    short canonicalCombiningClass;
    
    //TODO the defaults are not yet set correctly
    
//    BidiClass bidiClass;
    
    //TODO end
    
//    DecompositionType decompositionType;
    
//    dchar[] decompositionMapping;
    
    
    // TODO Check handling
    
//    int numeric_1;
    
//    int numeric_2;
    
//    double numeric_3;
    
    // TODO end
    
//    BidiMirrored bidiMirrored;
    
//    char[] unicode1Name;
    
//    char [] isoComment;
    
    dchar simpleUpperCaseMapping;
    
    dchar simpleLowerCaseMapping;
    
    dchar simpleTitleCaseMapping;
      
}

struct SpecialCaseData {
    
    dchar code;
    
    dchar[] upperCaseMapping;

    dchar[] lowerCaseMapping;

    dchar[] titleCaseMapping;

}

struct FoldingCaseData {
	
	dchar code;
	
	dchar[] mapping;
	
}

UnicodeData *unicodeData[dchar];

SpecialCaseData *specialCaseData[dchar];

FoldingCaseData *foldingCaseData[dchar];

private {
	UnicodeData internalUnicodeData[] = [
 { code:0x0000
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0000
  ,simpleLowerCaseMapping:0x0000
  ,simpleTitleCaseMapping:0x0000
 },
 { code:0x0001
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0001
  ,simpleLowerCaseMapping:0x0001
  ,simpleTitleCaseMapping:0x0001
 },
 { code:0x0002
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0002
  ,simpleLowerCaseMapping:0x0002
  ,simpleTitleCaseMapping:0x0002
 },
 { code:0x0003
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0003
  ,simpleLowerCaseMapping:0x0003
  ,simpleTitleCaseMapping:0x0003
 },
 { code:0x0004
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0004
  ,simpleLowerCaseMapping:0x0004
  ,simpleTitleCaseMapping:0x0004
 },
 { code:0x0005
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0005
  ,simpleLowerCaseMapping:0x0005
  ,simpleTitleCaseMapping:0x0005
 },
 { code:0x0006
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0006
  ,simpleLowerCaseMapping:0x0006
  ,simpleTitleCaseMapping:0x0006
 },
 { code:0x0007
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0007
  ,simpleLowerCaseMapping:0x0007
  ,simpleTitleCaseMapping:0x0007
 },
 { code:0x0008
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0008
  ,simpleLowerCaseMapping:0x0008
  ,simpleTitleCaseMapping:0x0008
 },
 { code:0x0009
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0009
  ,simpleLowerCaseMapping:0x0009
  ,simpleTitleCaseMapping:0x0009
 },
 { code:0x000A
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x000A
  ,simpleLowerCaseMapping:0x000A
  ,simpleTitleCaseMapping:0x000A
 },
 { code:0x000B
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x000B
  ,simpleLowerCaseMapping:0x000B
  ,simpleTitleCaseMapping:0x000B
 },
 { code:0x000C
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x000C
  ,simpleLowerCaseMapping:0x000C
  ,simpleTitleCaseMapping:0x000C
 },
 { code:0x000D
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x000D
  ,simpleLowerCaseMapping:0x000D
  ,simpleTitleCaseMapping:0x000D
 },
 { code:0x000E
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x000E
  ,simpleLowerCaseMapping:0x000E
  ,simpleTitleCaseMapping:0x000E
 },
 { code:0x000F
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x000F
  ,simpleLowerCaseMapping:0x000F
  ,simpleTitleCaseMapping:0x000F
 },
 { code:0x0010
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0010
  ,simpleLowerCaseMapping:0x0010
  ,simpleTitleCaseMapping:0x0010
 },
 { code:0x0011
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0011
  ,simpleLowerCaseMapping:0x0011
  ,simpleTitleCaseMapping:0x0011
 },
 { code:0x0012
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0012
  ,simpleLowerCaseMapping:0x0012
  ,simpleTitleCaseMapping:0x0012
 },
 { code:0x0013
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0013
  ,simpleLowerCaseMapping:0x0013
  ,simpleTitleCaseMapping:0x0013
 },
 { code:0x0014
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0014
  ,simpleLowerCaseMapping:0x0014
  ,simpleTitleCaseMapping:0x0014
 },
 { code:0x0015
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0015
  ,simpleLowerCaseMapping:0x0015
  ,simpleTitleCaseMapping:0x0015
 },
 { code:0x0016
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0016
  ,simpleLowerCaseMapping:0x0016
  ,simpleTitleCaseMapping:0x0016
 },
 { code:0x0017
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0017
  ,simpleLowerCaseMapping:0x0017
  ,simpleTitleCaseMapping:0x0017
 },
 { code:0x0018
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0018
  ,simpleLowerCaseMapping:0x0018
  ,simpleTitleCaseMapping:0x0018
 },
 { code:0x0019
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0019
  ,simpleLowerCaseMapping:0x0019
  ,simpleTitleCaseMapping:0x0019
 },
 { code:0x001A
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x001A
  ,simpleLowerCaseMapping:0x001A
  ,simpleTitleCaseMapping:0x001A
 },
 { code:0x001B
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x001B
  ,simpleLowerCaseMapping:0x001B
  ,simpleTitleCaseMapping:0x001B
 },
 { code:0x001C
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x001C
  ,simpleLowerCaseMapping:0x001C
  ,simpleTitleCaseMapping:0x001C
 },
 { code:0x001D
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x001D
  ,simpleLowerCaseMapping:0x001D
  ,simpleTitleCaseMapping:0x001D
 },
 { code:0x001E
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x001E
  ,simpleLowerCaseMapping:0x001E
  ,simpleTitleCaseMapping:0x001E
 },
 { code:0x001F
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x001F
  ,simpleLowerCaseMapping:0x001F
  ,simpleTitleCaseMapping:0x001F
 },
 { code:0x0020
  ,generalCategory:UnicodeData.GeneralCategory.Zs
  ,simpleUpperCaseMapping:0x0020
  ,simpleLowerCaseMapping:0x0020
  ,simpleTitleCaseMapping:0x0020
 },
 { code:0x0021
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0021
  ,simpleLowerCaseMapping:0x0021
  ,simpleTitleCaseMapping:0x0021
 },
 { code:0x0022
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0022
  ,simpleLowerCaseMapping:0x0022
  ,simpleTitleCaseMapping:0x0022
 },
 { code:0x0023
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0023
  ,simpleLowerCaseMapping:0x0023
  ,simpleTitleCaseMapping:0x0023
 },
 { code:0x0024
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x0024
  ,simpleLowerCaseMapping:0x0024
  ,simpleTitleCaseMapping:0x0024
 },
 { code:0x0025
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0025
  ,simpleLowerCaseMapping:0x0025
  ,simpleTitleCaseMapping:0x0025
 },
 { code:0x0026
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0026
  ,simpleLowerCaseMapping:0x0026
  ,simpleTitleCaseMapping:0x0026
 },
 { code:0x0027
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0027
  ,simpleLowerCaseMapping:0x0027
  ,simpleTitleCaseMapping:0x0027
 },
 { code:0x0028
  ,generalCategory:UnicodeData.GeneralCategory.Ps
  ,simpleUpperCaseMapping:0x0028
  ,simpleLowerCaseMapping:0x0028
  ,simpleTitleCaseMapping:0x0028
 },
 { code:0x0029
  ,generalCategory:UnicodeData.GeneralCategory.Pe
  ,simpleUpperCaseMapping:0x0029
  ,simpleLowerCaseMapping:0x0029
  ,simpleTitleCaseMapping:0x0029
 },
 { code:0x002A
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x002A
  ,simpleLowerCaseMapping:0x002A
  ,simpleTitleCaseMapping:0x002A
 },
 { code:0x002B
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x002B
  ,simpleLowerCaseMapping:0x002B
  ,simpleTitleCaseMapping:0x002B
 },
 { code:0x002C
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x002C
  ,simpleLowerCaseMapping:0x002C
  ,simpleTitleCaseMapping:0x002C
 },
 { code:0x002D
  ,generalCategory:UnicodeData.GeneralCategory.Pd
  ,simpleUpperCaseMapping:0x002D
  ,simpleLowerCaseMapping:0x002D
  ,simpleTitleCaseMapping:0x002D
 },
 { code:0x002E
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x002E
  ,simpleLowerCaseMapping:0x002E
  ,simpleTitleCaseMapping:0x002E
 },
 { code:0x002F
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x002F
  ,simpleLowerCaseMapping:0x002F
  ,simpleTitleCaseMapping:0x002F
 },
 { code:0x0030
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0030
  ,simpleLowerCaseMapping:0x0030
  ,simpleTitleCaseMapping:0x0030
 },
 { code:0x0031
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0031
  ,simpleLowerCaseMapping:0x0031
  ,simpleTitleCaseMapping:0x0031
 },
 { code:0x0032
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0032
  ,simpleLowerCaseMapping:0x0032
  ,simpleTitleCaseMapping:0x0032
 },
 { code:0x0033
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0033
  ,simpleLowerCaseMapping:0x0033
  ,simpleTitleCaseMapping:0x0033
 },
 { code:0x0034
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0034
  ,simpleLowerCaseMapping:0x0034
  ,simpleTitleCaseMapping:0x0034
 },
 { code:0x0035
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0035
  ,simpleLowerCaseMapping:0x0035
  ,simpleTitleCaseMapping:0x0035
 },
 { code:0x0036
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0036
  ,simpleLowerCaseMapping:0x0036
  ,simpleTitleCaseMapping:0x0036
 },
 { code:0x0037
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0037
  ,simpleLowerCaseMapping:0x0037
  ,simpleTitleCaseMapping:0x0037
 },
 { code:0x0038
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0038
  ,simpleLowerCaseMapping:0x0038
  ,simpleTitleCaseMapping:0x0038
 },
 { code:0x0039
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0039
  ,simpleLowerCaseMapping:0x0039
  ,simpleTitleCaseMapping:0x0039
 },
 { code:0x003A
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x003A
  ,simpleLowerCaseMapping:0x003A
  ,simpleTitleCaseMapping:0x003A
 },
 { code:0x003B
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x003B
  ,simpleLowerCaseMapping:0x003B
  ,simpleTitleCaseMapping:0x003B
 },
 { code:0x003C
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x003C
  ,simpleLowerCaseMapping:0x003C
  ,simpleTitleCaseMapping:0x003C
 },
 { code:0x003D
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x003D
  ,simpleLowerCaseMapping:0x003D
  ,simpleTitleCaseMapping:0x003D
 },
 { code:0x003E
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x003E
  ,simpleLowerCaseMapping:0x003E
  ,simpleTitleCaseMapping:0x003E
 },
 { code:0x003F
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x003F
  ,simpleLowerCaseMapping:0x003F
  ,simpleTitleCaseMapping:0x003F
 },
 { code:0x0040
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0040
  ,simpleLowerCaseMapping:0x0040
  ,simpleTitleCaseMapping:0x0040
 },
 { code:0x0041
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0041
  ,simpleLowerCaseMapping:0x0061
  ,simpleTitleCaseMapping:0x0041
 },
 { code:0x0042
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0042
  ,simpleLowerCaseMapping:0x0062
  ,simpleTitleCaseMapping:0x0042
 },
 { code:0x0043
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0043
  ,simpleLowerCaseMapping:0x0063
  ,simpleTitleCaseMapping:0x0043
 },
 { code:0x0044
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0044
  ,simpleLowerCaseMapping:0x0064
  ,simpleTitleCaseMapping:0x0044
 },
 { code:0x0045
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0045
  ,simpleLowerCaseMapping:0x0065
  ,simpleTitleCaseMapping:0x0045
 },
 { code:0x0046
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0046
  ,simpleLowerCaseMapping:0x0066
  ,simpleTitleCaseMapping:0x0046
 },
 { code:0x0047
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0047
  ,simpleLowerCaseMapping:0x0067
  ,simpleTitleCaseMapping:0x0047
 },
 { code:0x0048
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0048
  ,simpleLowerCaseMapping:0x0068
  ,simpleTitleCaseMapping:0x0048
 },
 { code:0x0049
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0049
  ,simpleLowerCaseMapping:0x0069
  ,simpleTitleCaseMapping:0x0049
 },
 { code:0x004A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x004A
  ,simpleLowerCaseMapping:0x006A
  ,simpleTitleCaseMapping:0x004A
 },
 { code:0x004B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x004B
  ,simpleLowerCaseMapping:0x006B
  ,simpleTitleCaseMapping:0x004B
 },
 { code:0x004C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x004C
  ,simpleLowerCaseMapping:0x006C
  ,simpleTitleCaseMapping:0x004C
 },
 { code:0x004D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x004D
  ,simpleLowerCaseMapping:0x006D
  ,simpleTitleCaseMapping:0x004D
 },
 { code:0x004E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x004E
  ,simpleLowerCaseMapping:0x006E
  ,simpleTitleCaseMapping:0x004E
 },
 { code:0x004F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x004F
  ,simpleLowerCaseMapping:0x006F
  ,simpleTitleCaseMapping:0x004F
 },
 { code:0x0050
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0050
  ,simpleLowerCaseMapping:0x0070
  ,simpleTitleCaseMapping:0x0050
 },
 { code:0x0051
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0051
  ,simpleLowerCaseMapping:0x0071
  ,simpleTitleCaseMapping:0x0051
 },
 { code:0x0052
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0052
  ,simpleLowerCaseMapping:0x0072
  ,simpleTitleCaseMapping:0x0052
 },
 { code:0x0053
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0053
  ,simpleLowerCaseMapping:0x0073
  ,simpleTitleCaseMapping:0x0053
 },
 { code:0x0054
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0054
  ,simpleLowerCaseMapping:0x0074
  ,simpleTitleCaseMapping:0x0054
 },
 { code:0x0055
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0055
  ,simpleLowerCaseMapping:0x0075
  ,simpleTitleCaseMapping:0x0055
 },
 { code:0x0056
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0056
  ,simpleLowerCaseMapping:0x0076
  ,simpleTitleCaseMapping:0x0056
 },
 { code:0x0057
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0057
  ,simpleLowerCaseMapping:0x0077
  ,simpleTitleCaseMapping:0x0057
 },
 { code:0x0058
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0058
  ,simpleLowerCaseMapping:0x0078
  ,simpleTitleCaseMapping:0x0058
 },
 { code:0x0059
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0059
  ,simpleLowerCaseMapping:0x0079
  ,simpleTitleCaseMapping:0x0059
 },
 { code:0x005A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x005A
  ,simpleLowerCaseMapping:0x007A
  ,simpleTitleCaseMapping:0x005A
 },
 { code:0x005B
  ,generalCategory:UnicodeData.GeneralCategory.Ps
  ,simpleUpperCaseMapping:0x005B
  ,simpleLowerCaseMapping:0x005B
  ,simpleTitleCaseMapping:0x005B
 },
 { code:0x005C
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x005C
  ,simpleLowerCaseMapping:0x005C
  ,simpleTitleCaseMapping:0x005C
 },
 { code:0x005D
  ,generalCategory:UnicodeData.GeneralCategory.Pe
  ,simpleUpperCaseMapping:0x005D
  ,simpleLowerCaseMapping:0x005D
  ,simpleTitleCaseMapping:0x005D
 },
 { code:0x005E
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x005E
  ,simpleLowerCaseMapping:0x005E
  ,simpleTitleCaseMapping:0x005E
 },
 { code:0x005F
  ,generalCategory:UnicodeData.GeneralCategory.Pc
  ,simpleUpperCaseMapping:0x005F
  ,simpleLowerCaseMapping:0x005F
  ,simpleTitleCaseMapping:0x005F
 },
 { code:0x0060
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x0060
  ,simpleLowerCaseMapping:0x0060
  ,simpleTitleCaseMapping:0x0060
 },
 { code:0x0061
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0041
  ,simpleLowerCaseMapping:0x0061
  ,simpleTitleCaseMapping:0x0041
 },
 { code:0x0062
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0042
  ,simpleLowerCaseMapping:0x0062
  ,simpleTitleCaseMapping:0x0042
 },
 { code:0x0063
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0043
  ,simpleLowerCaseMapping:0x0063
  ,simpleTitleCaseMapping:0x0043
 },
 { code:0x0064
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0044
  ,simpleLowerCaseMapping:0x0064
  ,simpleTitleCaseMapping:0x0044
 },
 { code:0x0065
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0045
  ,simpleLowerCaseMapping:0x0065
  ,simpleTitleCaseMapping:0x0045
 },
 { code:0x0066
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0046
  ,simpleLowerCaseMapping:0x0066
  ,simpleTitleCaseMapping:0x0046
 },
 { code:0x0067
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0047
  ,simpleLowerCaseMapping:0x0067
  ,simpleTitleCaseMapping:0x0047
 },
 { code:0x0068
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0048
  ,simpleLowerCaseMapping:0x0068
  ,simpleTitleCaseMapping:0x0048
 },
 { code:0x0069
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0049
  ,simpleLowerCaseMapping:0x0069
  ,simpleTitleCaseMapping:0x0049
 },
 { code:0x006A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x004A
  ,simpleLowerCaseMapping:0x006A
  ,simpleTitleCaseMapping:0x004A
 },
 { code:0x006B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x004B
  ,simpleLowerCaseMapping:0x006B
  ,simpleTitleCaseMapping:0x004B
 },
 { code:0x006C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x004C
  ,simpleLowerCaseMapping:0x006C
  ,simpleTitleCaseMapping:0x004C
 },
 { code:0x006D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x004D
  ,simpleLowerCaseMapping:0x006D
  ,simpleTitleCaseMapping:0x004D
 },
 { code:0x006E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x004E
  ,simpleLowerCaseMapping:0x006E
  ,simpleTitleCaseMapping:0x004E
 },
 { code:0x006F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x004F
  ,simpleLowerCaseMapping:0x006F
  ,simpleTitleCaseMapping:0x004F
 },
 { code:0x0070
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0050
  ,simpleLowerCaseMapping:0x0070
  ,simpleTitleCaseMapping:0x0050
 },
 { code:0x0071
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0051
  ,simpleLowerCaseMapping:0x0071
  ,simpleTitleCaseMapping:0x0051
 },
 { code:0x0072
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0052
  ,simpleLowerCaseMapping:0x0072
  ,simpleTitleCaseMapping:0x0052
 },
 { code:0x0073
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0053
  ,simpleLowerCaseMapping:0x0073
  ,simpleTitleCaseMapping:0x0053
 },
 { code:0x0074
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0054
  ,simpleLowerCaseMapping:0x0074
  ,simpleTitleCaseMapping:0x0054
 },
 { code:0x0075
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0055
  ,simpleLowerCaseMapping:0x0075
  ,simpleTitleCaseMapping:0x0055
 },
 { code:0x0076
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0056
  ,simpleLowerCaseMapping:0x0076
  ,simpleTitleCaseMapping:0x0056
 },
 { code:0x0077
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0057
  ,simpleLowerCaseMapping:0x0077
  ,simpleTitleCaseMapping:0x0057
 },
 { code:0x0078
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0058
  ,simpleLowerCaseMapping:0x0078
  ,simpleTitleCaseMapping:0x0058
 },
 { code:0x0079
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0059
  ,simpleLowerCaseMapping:0x0079
  ,simpleTitleCaseMapping:0x0059
 },
 { code:0x007A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x005A
  ,simpleLowerCaseMapping:0x007A
  ,simpleTitleCaseMapping:0x005A
 },
 { code:0x007B
  ,generalCategory:UnicodeData.GeneralCategory.Ps
  ,simpleUpperCaseMapping:0x007B
  ,simpleLowerCaseMapping:0x007B
  ,simpleTitleCaseMapping:0x007B
 },
 { code:0x007C
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x007C
  ,simpleLowerCaseMapping:0x007C
  ,simpleTitleCaseMapping:0x007C
 },
 { code:0x007D
  ,generalCategory:UnicodeData.GeneralCategory.Pe
  ,simpleUpperCaseMapping:0x007D
  ,simpleLowerCaseMapping:0x007D
  ,simpleTitleCaseMapping:0x007D
 },
 { code:0x007E
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x007E
  ,simpleLowerCaseMapping:0x007E
  ,simpleTitleCaseMapping:0x007E
 },
 { code:0x007F
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x007F
  ,simpleLowerCaseMapping:0x007F
  ,simpleTitleCaseMapping:0x007F
 },
 { code:0x0080
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0080
  ,simpleLowerCaseMapping:0x0080
  ,simpleTitleCaseMapping:0x0080
 },
 { code:0x0081
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0081
  ,simpleLowerCaseMapping:0x0081
  ,simpleTitleCaseMapping:0x0081
 },
 { code:0x0082
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0082
  ,simpleLowerCaseMapping:0x0082
  ,simpleTitleCaseMapping:0x0082
 },
 { code:0x0083
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0083
  ,simpleLowerCaseMapping:0x0083
  ,simpleTitleCaseMapping:0x0083
 },
 { code:0x0084
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0084
  ,simpleLowerCaseMapping:0x0084
  ,simpleTitleCaseMapping:0x0084
 },
 { code:0x0085
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0085
  ,simpleLowerCaseMapping:0x0085
  ,simpleTitleCaseMapping:0x0085
 },
 { code:0x0086
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0086
  ,simpleLowerCaseMapping:0x0086
  ,simpleTitleCaseMapping:0x0086
 },
 { code:0x0087
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0087
  ,simpleLowerCaseMapping:0x0087
  ,simpleTitleCaseMapping:0x0087
 },
 { code:0x0088
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0088
  ,simpleLowerCaseMapping:0x0088
  ,simpleTitleCaseMapping:0x0088
 },
 { code:0x0089
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0089
  ,simpleLowerCaseMapping:0x0089
  ,simpleTitleCaseMapping:0x0089
 },
 { code:0x008A
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x008A
  ,simpleLowerCaseMapping:0x008A
  ,simpleTitleCaseMapping:0x008A
 },
 { code:0x008B
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x008B
  ,simpleLowerCaseMapping:0x008B
  ,simpleTitleCaseMapping:0x008B
 },
 { code:0x008C
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x008C
  ,simpleLowerCaseMapping:0x008C
  ,simpleTitleCaseMapping:0x008C
 },
 { code:0x008D
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x008D
  ,simpleLowerCaseMapping:0x008D
  ,simpleTitleCaseMapping:0x008D
 },
 { code:0x008E
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x008E
  ,simpleLowerCaseMapping:0x008E
  ,simpleTitleCaseMapping:0x008E
 },
 { code:0x008F
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x008F
  ,simpleLowerCaseMapping:0x008F
  ,simpleTitleCaseMapping:0x008F
 },
 { code:0x0090
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0090
  ,simpleLowerCaseMapping:0x0090
  ,simpleTitleCaseMapping:0x0090
 },
 { code:0x0091
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0091
  ,simpleLowerCaseMapping:0x0091
  ,simpleTitleCaseMapping:0x0091
 },
 { code:0x0092
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0092
  ,simpleLowerCaseMapping:0x0092
  ,simpleTitleCaseMapping:0x0092
 },
 { code:0x0093
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0093
  ,simpleLowerCaseMapping:0x0093
  ,simpleTitleCaseMapping:0x0093
 },
 { code:0x0094
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0094
  ,simpleLowerCaseMapping:0x0094
  ,simpleTitleCaseMapping:0x0094
 },
 { code:0x0095
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0095
  ,simpleLowerCaseMapping:0x0095
  ,simpleTitleCaseMapping:0x0095
 },
 { code:0x0096
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0096
  ,simpleLowerCaseMapping:0x0096
  ,simpleTitleCaseMapping:0x0096
 },
 { code:0x0097
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0097
  ,simpleLowerCaseMapping:0x0097
  ,simpleTitleCaseMapping:0x0097
 },
 { code:0x0098
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0098
  ,simpleLowerCaseMapping:0x0098
  ,simpleTitleCaseMapping:0x0098
 },
 { code:0x0099
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x0099
  ,simpleLowerCaseMapping:0x0099
  ,simpleTitleCaseMapping:0x0099
 },
 { code:0x009A
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x009A
  ,simpleLowerCaseMapping:0x009A
  ,simpleTitleCaseMapping:0x009A
 },
 { code:0x009B
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x009B
  ,simpleLowerCaseMapping:0x009B
  ,simpleTitleCaseMapping:0x009B
 },
 { code:0x009C
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x009C
  ,simpleLowerCaseMapping:0x009C
  ,simpleTitleCaseMapping:0x009C
 },
 { code:0x009D
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x009D
  ,simpleLowerCaseMapping:0x009D
  ,simpleTitleCaseMapping:0x009D
 },
 { code:0x009E
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x009E
  ,simpleLowerCaseMapping:0x009E
  ,simpleTitleCaseMapping:0x009E
 },
 { code:0x009F
  ,generalCategory:UnicodeData.GeneralCategory.Cc
  ,simpleUpperCaseMapping:0x009F
  ,simpleLowerCaseMapping:0x009F
  ,simpleTitleCaseMapping:0x009F
 },
 { code:0x00A0
  ,generalCategory:UnicodeData.GeneralCategory.Zs
  ,simpleUpperCaseMapping:0x00A0
  ,simpleLowerCaseMapping:0x00A0
  ,simpleTitleCaseMapping:0x00A0
 },
 { code:0x00A1
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x00A1
  ,simpleLowerCaseMapping:0x00A1
  ,simpleTitleCaseMapping:0x00A1
 },
 { code:0x00A2
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x00A2
  ,simpleLowerCaseMapping:0x00A2
  ,simpleTitleCaseMapping:0x00A2
 },
 { code:0x00A3
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x00A3
  ,simpleLowerCaseMapping:0x00A3
  ,simpleTitleCaseMapping:0x00A3
 },
 { code:0x00A4
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x00A4
  ,simpleLowerCaseMapping:0x00A4
  ,simpleTitleCaseMapping:0x00A4
 },
 { code:0x00A5
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x00A5
  ,simpleLowerCaseMapping:0x00A5
  ,simpleTitleCaseMapping:0x00A5
 },
 { code:0x00A6
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x00A6
  ,simpleLowerCaseMapping:0x00A6
  ,simpleTitleCaseMapping:0x00A6
 },
 { code:0x00A7
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x00A7
  ,simpleLowerCaseMapping:0x00A7
  ,simpleTitleCaseMapping:0x00A7
 },
 { code:0x00A8
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x00A8
  ,simpleLowerCaseMapping:0x00A8
  ,simpleTitleCaseMapping:0x00A8
 },
 { code:0x00A9
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x00A9
  ,simpleLowerCaseMapping:0x00A9
  ,simpleTitleCaseMapping:0x00A9
 },
 { code:0x00AA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00AA
  ,simpleLowerCaseMapping:0x00AA
  ,simpleTitleCaseMapping:0x00AA
 },
 { code:0x00AB
  ,generalCategory:UnicodeData.GeneralCategory.Pi
  ,simpleUpperCaseMapping:0x00AB
  ,simpleLowerCaseMapping:0x00AB
  ,simpleTitleCaseMapping:0x00AB
 },
 { code:0x00AC
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x00AC
  ,simpleLowerCaseMapping:0x00AC
  ,simpleTitleCaseMapping:0x00AC
 },
 { code:0x00AD
  ,generalCategory:UnicodeData.GeneralCategory.Cf
  ,simpleUpperCaseMapping:0x00AD
  ,simpleLowerCaseMapping:0x00AD
  ,simpleTitleCaseMapping:0x00AD
 },
 { code:0x00AE
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x00AE
  ,simpleLowerCaseMapping:0x00AE
  ,simpleTitleCaseMapping:0x00AE
 },
 { code:0x00AF
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x00AF
  ,simpleLowerCaseMapping:0x00AF
  ,simpleTitleCaseMapping:0x00AF
 },
 { code:0x00B0
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x00B0
  ,simpleLowerCaseMapping:0x00B0
  ,simpleTitleCaseMapping:0x00B0
 },
 { code:0x00B1
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x00B1
  ,simpleLowerCaseMapping:0x00B1
  ,simpleTitleCaseMapping:0x00B1
 },
 { code:0x00B2
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x00B2
  ,simpleLowerCaseMapping:0x00B2
  ,simpleTitleCaseMapping:0x00B2
 },
 { code:0x00B3
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x00B3
  ,simpleLowerCaseMapping:0x00B3
  ,simpleTitleCaseMapping:0x00B3
 },
 { code:0x00B4
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x00B4
  ,simpleLowerCaseMapping:0x00B4
  ,simpleTitleCaseMapping:0x00B4
 },
 { code:0x00B5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x039C
  ,simpleLowerCaseMapping:0x00B5
  ,simpleTitleCaseMapping:0x039C
 },
 { code:0x00B6
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x00B6
  ,simpleLowerCaseMapping:0x00B6
  ,simpleTitleCaseMapping:0x00B6
 },
 { code:0x00B7
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x00B7
  ,simpleLowerCaseMapping:0x00B7
  ,simpleTitleCaseMapping:0x00B7
 },
 { code:0x00B8
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x00B8
  ,simpleLowerCaseMapping:0x00B8
  ,simpleTitleCaseMapping:0x00B8
 },
 { code:0x00B9
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x00B9
  ,simpleLowerCaseMapping:0x00B9
  ,simpleTitleCaseMapping:0x00B9
 },
 { code:0x00BA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00BA
  ,simpleLowerCaseMapping:0x00BA
  ,simpleTitleCaseMapping:0x00BA
 },
 { code:0x00BB
  ,generalCategory:UnicodeData.GeneralCategory.Pf
  ,simpleUpperCaseMapping:0x00BB
  ,simpleLowerCaseMapping:0x00BB
  ,simpleTitleCaseMapping:0x00BB
 },
 { code:0x00BC
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x00BC
  ,simpleLowerCaseMapping:0x00BC
  ,simpleTitleCaseMapping:0x00BC
 },
 { code:0x00BD
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x00BD
  ,simpleLowerCaseMapping:0x00BD
  ,simpleTitleCaseMapping:0x00BD
 },
 { code:0x00BE
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x00BE
  ,simpleLowerCaseMapping:0x00BE
  ,simpleTitleCaseMapping:0x00BE
 },
 { code:0x00BF
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x00BF
  ,simpleLowerCaseMapping:0x00BF
  ,simpleTitleCaseMapping:0x00BF
 },
 { code:0x00C0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00C0
  ,simpleLowerCaseMapping:0x00E0
  ,simpleTitleCaseMapping:0x00C0
 },
 { code:0x00C1
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00C1
  ,simpleLowerCaseMapping:0x00E1
  ,simpleTitleCaseMapping:0x00C1
 },
 { code:0x00C2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00C2
  ,simpleLowerCaseMapping:0x00E2
  ,simpleTitleCaseMapping:0x00C2
 },
 { code:0x00C3
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00C3
  ,simpleLowerCaseMapping:0x00E3
  ,simpleTitleCaseMapping:0x00C3
 },
 { code:0x00C4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00C4
  ,simpleLowerCaseMapping:0x00E4
  ,simpleTitleCaseMapping:0x00C4
 },
 { code:0x00C5
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00C5
  ,simpleLowerCaseMapping:0x00E5
  ,simpleTitleCaseMapping:0x00C5
 },
 { code:0x00C6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00C6
  ,simpleLowerCaseMapping:0x00E6
  ,simpleTitleCaseMapping:0x00C6
 },
 { code:0x00C7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00C7
  ,simpleLowerCaseMapping:0x00E7
  ,simpleTitleCaseMapping:0x00C7
 },
 { code:0x00C8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00C8
  ,simpleLowerCaseMapping:0x00E8
  ,simpleTitleCaseMapping:0x00C8
 },
 { code:0x00C9
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00C9
  ,simpleLowerCaseMapping:0x00E9
  ,simpleTitleCaseMapping:0x00C9
 },
 { code:0x00CA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00CA
  ,simpleLowerCaseMapping:0x00EA
  ,simpleTitleCaseMapping:0x00CA
 },
 { code:0x00CB
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00CB
  ,simpleLowerCaseMapping:0x00EB
  ,simpleTitleCaseMapping:0x00CB
 },
 { code:0x00CC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00CC
  ,simpleLowerCaseMapping:0x00EC
  ,simpleTitleCaseMapping:0x00CC
 },
 { code:0x00CD
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00CD
  ,simpleLowerCaseMapping:0x00ED
  ,simpleTitleCaseMapping:0x00CD
 },
 { code:0x00CE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00CE
  ,simpleLowerCaseMapping:0x00EE
  ,simpleTitleCaseMapping:0x00CE
 },
 { code:0x00CF
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00CF
  ,simpleLowerCaseMapping:0x00EF
  ,simpleTitleCaseMapping:0x00CF
 },
 { code:0x00D0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00D0
  ,simpleLowerCaseMapping:0x00F0
  ,simpleTitleCaseMapping:0x00D0
 },
 { code:0x00D1
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00D1
  ,simpleLowerCaseMapping:0x00F1
  ,simpleTitleCaseMapping:0x00D1
 },
 { code:0x00D2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00D2
  ,simpleLowerCaseMapping:0x00F2
  ,simpleTitleCaseMapping:0x00D2
 },
 { code:0x00D3
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00D3
  ,simpleLowerCaseMapping:0x00F3
  ,simpleTitleCaseMapping:0x00D3
 },
 { code:0x00D4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00D4
  ,simpleLowerCaseMapping:0x00F4
  ,simpleTitleCaseMapping:0x00D4
 },
 { code:0x00D5
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00D5
  ,simpleLowerCaseMapping:0x00F5
  ,simpleTitleCaseMapping:0x00D5
 },
 { code:0x00D6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00D6
  ,simpleLowerCaseMapping:0x00F6
  ,simpleTitleCaseMapping:0x00D6
 },
 { code:0x00D7
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x00D7
  ,simpleLowerCaseMapping:0x00D7
  ,simpleTitleCaseMapping:0x00D7
 },
 { code:0x00D8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00D8
  ,simpleLowerCaseMapping:0x00F8
  ,simpleTitleCaseMapping:0x00D8
 },
 { code:0x00D9
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00D9
  ,simpleLowerCaseMapping:0x00F9
  ,simpleTitleCaseMapping:0x00D9
 },
 { code:0x00DA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00DA
  ,simpleLowerCaseMapping:0x00FA
  ,simpleTitleCaseMapping:0x00DA
 },
 { code:0x00DB
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00DB
  ,simpleLowerCaseMapping:0x00FB
  ,simpleTitleCaseMapping:0x00DB
 },
 { code:0x00DC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00DC
  ,simpleLowerCaseMapping:0x00FC
  ,simpleTitleCaseMapping:0x00DC
 },
 { code:0x00DD
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00DD
  ,simpleLowerCaseMapping:0x00FD
  ,simpleTitleCaseMapping:0x00DD
 },
 { code:0x00DE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x00DE
  ,simpleLowerCaseMapping:0x00FE
  ,simpleTitleCaseMapping:0x00DE
 },
 { code:0x00DF
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x00DF
  ,simpleLowerCaseMapping:0x00DF
  ,simpleTitleCaseMapping:0x00DF
 },
 { code:0x00E0
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00C0
  ,simpleLowerCaseMapping:0x00E0
  ,simpleTitleCaseMapping:0x00C0
 },
 { code:0x00E1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00C1
  ,simpleLowerCaseMapping:0x00E1
  ,simpleTitleCaseMapping:0x00C1
 },
 { code:0x00E2
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00C2
  ,simpleLowerCaseMapping:0x00E2
  ,simpleTitleCaseMapping:0x00C2
 },
 { code:0x00E3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00C3
  ,simpleLowerCaseMapping:0x00E3
  ,simpleTitleCaseMapping:0x00C3
 },
 { code:0x00E4
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00C4
  ,simpleLowerCaseMapping:0x00E4
  ,simpleTitleCaseMapping:0x00C4
 },
 { code:0x00E5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00C5
  ,simpleLowerCaseMapping:0x00E5
  ,simpleTitleCaseMapping:0x00C5
 },
 { code:0x00E6
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00C6
  ,simpleLowerCaseMapping:0x00E6
  ,simpleTitleCaseMapping:0x00C6
 },
 { code:0x00E7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00C7
  ,simpleLowerCaseMapping:0x00E7
  ,simpleTitleCaseMapping:0x00C7
 },
 { code:0x00E8
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00C8
  ,simpleLowerCaseMapping:0x00E8
  ,simpleTitleCaseMapping:0x00C8
 },
 { code:0x00E9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00C9
  ,simpleLowerCaseMapping:0x00E9
  ,simpleTitleCaseMapping:0x00C9
 },
 { code:0x00EA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00CA
  ,simpleLowerCaseMapping:0x00EA
  ,simpleTitleCaseMapping:0x00CA
 },
 { code:0x00EB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00CB
  ,simpleLowerCaseMapping:0x00EB
  ,simpleTitleCaseMapping:0x00CB
 },
 { code:0x00EC
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00CC
  ,simpleLowerCaseMapping:0x00EC
  ,simpleTitleCaseMapping:0x00CC
 },
 { code:0x00ED
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00CD
  ,simpleLowerCaseMapping:0x00ED
  ,simpleTitleCaseMapping:0x00CD
 },
 { code:0x00EE
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00CE
  ,simpleLowerCaseMapping:0x00EE
  ,simpleTitleCaseMapping:0x00CE
 },
 { code:0x00EF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00CF
  ,simpleLowerCaseMapping:0x00EF
  ,simpleTitleCaseMapping:0x00CF
 },
 { code:0x00F0
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00D0
  ,simpleLowerCaseMapping:0x00F0
  ,simpleTitleCaseMapping:0x00D0
 },
 { code:0x00F1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00D1
  ,simpleLowerCaseMapping:0x00F1
  ,simpleTitleCaseMapping:0x00D1
 },
 { code:0x00F2
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00D2
  ,simpleLowerCaseMapping:0x00F2
  ,simpleTitleCaseMapping:0x00D2
 },
 { code:0x00F3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00D3
  ,simpleLowerCaseMapping:0x00F3
  ,simpleTitleCaseMapping:0x00D3
 },
 { code:0x00F4
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00D4
  ,simpleLowerCaseMapping:0x00F4
  ,simpleTitleCaseMapping:0x00D4
 },
 { code:0x00F5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00D5
  ,simpleLowerCaseMapping:0x00F5
  ,simpleTitleCaseMapping:0x00D5
 },
 { code:0x00F6
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00D6
  ,simpleLowerCaseMapping:0x00F6
  ,simpleTitleCaseMapping:0x00D6
 },
 { code:0x00F7
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x00F7
  ,simpleLowerCaseMapping:0x00F7
  ,simpleTitleCaseMapping:0x00F7
 },
 { code:0x00F8
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00D8
  ,simpleLowerCaseMapping:0x00F8
  ,simpleTitleCaseMapping:0x00D8
 },
 { code:0x00F9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00D9
  ,simpleLowerCaseMapping:0x00F9
  ,simpleTitleCaseMapping:0x00D9
 },
 { code:0x00FA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00DA
  ,simpleLowerCaseMapping:0x00FA
  ,simpleTitleCaseMapping:0x00DA
 },
 { code:0x00FB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00DB
  ,simpleLowerCaseMapping:0x00FB
  ,simpleTitleCaseMapping:0x00DB
 },
 { code:0x00FC
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00DC
  ,simpleLowerCaseMapping:0x00FC
  ,simpleTitleCaseMapping:0x00DC
 },
 { code:0x00FD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00DD
  ,simpleLowerCaseMapping:0x00FD
  ,simpleTitleCaseMapping:0x00DD
 },
 { code:0x00FE
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x00DE
  ,simpleLowerCaseMapping:0x00FE
  ,simpleTitleCaseMapping:0x00DE
 },
 { code:0x00FF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0178
  ,simpleLowerCaseMapping:0x00FF
  ,simpleTitleCaseMapping:0x0178
 },
 { code:0x0100
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0100
  ,simpleLowerCaseMapping:0x0101
  ,simpleTitleCaseMapping:0x0100
 },
 { code:0x0101
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0100
  ,simpleLowerCaseMapping:0x0101
  ,simpleTitleCaseMapping:0x0100
 },
 { code:0x0102
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0102
  ,simpleLowerCaseMapping:0x0103
  ,simpleTitleCaseMapping:0x0102
 },
 { code:0x0103
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0102
  ,simpleLowerCaseMapping:0x0103
  ,simpleTitleCaseMapping:0x0102
 },
 { code:0x0104
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0104
  ,simpleLowerCaseMapping:0x0105
  ,simpleTitleCaseMapping:0x0104
 },
 { code:0x0105
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0104
  ,simpleLowerCaseMapping:0x0105
  ,simpleTitleCaseMapping:0x0104
 },
 { code:0x0106
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0106
  ,simpleLowerCaseMapping:0x0107
  ,simpleTitleCaseMapping:0x0106
 },
 { code:0x0107
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0106
  ,simpleLowerCaseMapping:0x0107
  ,simpleTitleCaseMapping:0x0106
 },
 { code:0x0108
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0108
  ,simpleLowerCaseMapping:0x0109
  ,simpleTitleCaseMapping:0x0108
 },
 { code:0x0109
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0108
  ,simpleLowerCaseMapping:0x0109
  ,simpleTitleCaseMapping:0x0108
 },
 { code:0x010A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x010A
  ,simpleLowerCaseMapping:0x010B
  ,simpleTitleCaseMapping:0x010A
 },
 { code:0x010B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x010A
  ,simpleLowerCaseMapping:0x010B
  ,simpleTitleCaseMapping:0x010A
 },
 { code:0x010C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x010C
  ,simpleLowerCaseMapping:0x010D
  ,simpleTitleCaseMapping:0x010C
 },
 { code:0x010D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x010C
  ,simpleLowerCaseMapping:0x010D
  ,simpleTitleCaseMapping:0x010C
 },
 { code:0x010E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x010E
  ,simpleLowerCaseMapping:0x010F
  ,simpleTitleCaseMapping:0x010E
 },
 { code:0x010F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x010E
  ,simpleLowerCaseMapping:0x010F
  ,simpleTitleCaseMapping:0x010E
 },
 { code:0x0110
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0110
  ,simpleLowerCaseMapping:0x0111
  ,simpleTitleCaseMapping:0x0110
 },
 { code:0x0111
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0110
  ,simpleLowerCaseMapping:0x0111
  ,simpleTitleCaseMapping:0x0110
 },
 { code:0x0112
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0112
  ,simpleLowerCaseMapping:0x0113
  ,simpleTitleCaseMapping:0x0112
 },
 { code:0x0113
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0112
  ,simpleLowerCaseMapping:0x0113
  ,simpleTitleCaseMapping:0x0112
 },
 { code:0x0114
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0114
  ,simpleLowerCaseMapping:0x0115
  ,simpleTitleCaseMapping:0x0114
 },
 { code:0x0115
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0114
  ,simpleLowerCaseMapping:0x0115
  ,simpleTitleCaseMapping:0x0114
 },
 { code:0x0116
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0116
  ,simpleLowerCaseMapping:0x0117
  ,simpleTitleCaseMapping:0x0116
 },
 { code:0x0117
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0116
  ,simpleLowerCaseMapping:0x0117
  ,simpleTitleCaseMapping:0x0116
 },
 { code:0x0118
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0118
  ,simpleLowerCaseMapping:0x0119
  ,simpleTitleCaseMapping:0x0118
 },
 { code:0x0119
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0118
  ,simpleLowerCaseMapping:0x0119
  ,simpleTitleCaseMapping:0x0118
 },
 { code:0x011A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x011A
  ,simpleLowerCaseMapping:0x011B
  ,simpleTitleCaseMapping:0x011A
 },
 { code:0x011B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x011A
  ,simpleLowerCaseMapping:0x011B
  ,simpleTitleCaseMapping:0x011A
 },
 { code:0x011C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x011C
  ,simpleLowerCaseMapping:0x011D
  ,simpleTitleCaseMapping:0x011C
 },
 { code:0x011D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x011C
  ,simpleLowerCaseMapping:0x011D
  ,simpleTitleCaseMapping:0x011C
 },
 { code:0x011E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x011E
  ,simpleLowerCaseMapping:0x011F
  ,simpleTitleCaseMapping:0x011E
 },
 { code:0x011F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x011E
  ,simpleLowerCaseMapping:0x011F
  ,simpleTitleCaseMapping:0x011E
 },
 { code:0x0120
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0120
  ,simpleLowerCaseMapping:0x0121
  ,simpleTitleCaseMapping:0x0120
 },
 { code:0x0121
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0120
  ,simpleLowerCaseMapping:0x0121
  ,simpleTitleCaseMapping:0x0120
 },
 { code:0x0122
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0122
  ,simpleLowerCaseMapping:0x0123
  ,simpleTitleCaseMapping:0x0122
 },
 { code:0x0123
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0122
  ,simpleLowerCaseMapping:0x0123
  ,simpleTitleCaseMapping:0x0122
 },
 { code:0x0124
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0124
  ,simpleLowerCaseMapping:0x0125
  ,simpleTitleCaseMapping:0x0124
 },
 { code:0x0125
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0124
  ,simpleLowerCaseMapping:0x0125
  ,simpleTitleCaseMapping:0x0124
 },
 { code:0x0126
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0126
  ,simpleLowerCaseMapping:0x0127
  ,simpleTitleCaseMapping:0x0126
 },
 { code:0x0127
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0126
  ,simpleLowerCaseMapping:0x0127
  ,simpleTitleCaseMapping:0x0126
 },
 { code:0x0128
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0128
  ,simpleLowerCaseMapping:0x0129
  ,simpleTitleCaseMapping:0x0128
 },
 { code:0x0129
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0128
  ,simpleLowerCaseMapping:0x0129
  ,simpleTitleCaseMapping:0x0128
 },
 { code:0x012A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x012A
  ,simpleLowerCaseMapping:0x012B
  ,simpleTitleCaseMapping:0x012A
 },
 { code:0x012B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x012A
  ,simpleLowerCaseMapping:0x012B
  ,simpleTitleCaseMapping:0x012A
 },
 { code:0x012C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x012C
  ,simpleLowerCaseMapping:0x012D
  ,simpleTitleCaseMapping:0x012C
 },
 { code:0x012D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x012C
  ,simpleLowerCaseMapping:0x012D
  ,simpleTitleCaseMapping:0x012C
 },
 { code:0x012E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x012E
  ,simpleLowerCaseMapping:0x012F
  ,simpleTitleCaseMapping:0x012E
 },
 { code:0x012F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x012E
  ,simpleLowerCaseMapping:0x012F
  ,simpleTitleCaseMapping:0x012E
 },
 { code:0x0130
  ,generalCategory:UnicodeData.GeneralCategory.Lu | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x0130
  ,simpleLowerCaseMapping:0x0069
  ,simpleTitleCaseMapping:0x0130
 },
 { code:0x0131
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0049
  ,simpleLowerCaseMapping:0x0131
  ,simpleTitleCaseMapping:0x0049
 },
 { code:0x0132
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0132
  ,simpleLowerCaseMapping:0x0133
  ,simpleTitleCaseMapping:0x0132
 },
 { code:0x0133
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0132
  ,simpleLowerCaseMapping:0x0133
  ,simpleTitleCaseMapping:0x0132
 },
 { code:0x0134
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0134
  ,simpleLowerCaseMapping:0x0135
  ,simpleTitleCaseMapping:0x0134
 },
 { code:0x0135
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0134
  ,simpleLowerCaseMapping:0x0135
  ,simpleTitleCaseMapping:0x0134
 },
 { code:0x0136
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0136
  ,simpleLowerCaseMapping:0x0137
  ,simpleTitleCaseMapping:0x0136
 },
 { code:0x0137
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0136
  ,simpleLowerCaseMapping:0x0137
  ,simpleTitleCaseMapping:0x0136
 },
 { code:0x0138
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0138
  ,simpleLowerCaseMapping:0x0138
  ,simpleTitleCaseMapping:0x0138
 },
 { code:0x0139
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0139
  ,simpleLowerCaseMapping:0x013A
  ,simpleTitleCaseMapping:0x0139
 },
 { code:0x013A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0139
  ,simpleLowerCaseMapping:0x013A
  ,simpleTitleCaseMapping:0x0139
 },
 { code:0x013B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x013B
  ,simpleLowerCaseMapping:0x013C
  ,simpleTitleCaseMapping:0x013B
 },
 { code:0x013C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x013B
  ,simpleLowerCaseMapping:0x013C
  ,simpleTitleCaseMapping:0x013B
 },
 { code:0x013D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x013D
  ,simpleLowerCaseMapping:0x013E
  ,simpleTitleCaseMapping:0x013D
 },
 { code:0x013E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x013D
  ,simpleLowerCaseMapping:0x013E
  ,simpleTitleCaseMapping:0x013D
 },
 { code:0x013F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x013F
  ,simpleLowerCaseMapping:0x0140
  ,simpleTitleCaseMapping:0x013F
 },
 { code:0x0140
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x013F
  ,simpleLowerCaseMapping:0x0140
  ,simpleTitleCaseMapping:0x013F
 },
 { code:0x0141
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0141
  ,simpleLowerCaseMapping:0x0142
  ,simpleTitleCaseMapping:0x0141
 },
 { code:0x0142
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0141
  ,simpleLowerCaseMapping:0x0142
  ,simpleTitleCaseMapping:0x0141
 },
 { code:0x0143
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0143
  ,simpleLowerCaseMapping:0x0144
  ,simpleTitleCaseMapping:0x0143
 },
 { code:0x0144
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0143
  ,simpleLowerCaseMapping:0x0144
  ,simpleTitleCaseMapping:0x0143
 },
 { code:0x0145
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0145
  ,simpleLowerCaseMapping:0x0146
  ,simpleTitleCaseMapping:0x0145
 },
 { code:0x0146
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0145
  ,simpleLowerCaseMapping:0x0146
  ,simpleTitleCaseMapping:0x0145
 },
 { code:0x0147
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0147
  ,simpleLowerCaseMapping:0x0148
  ,simpleTitleCaseMapping:0x0147
 },
 { code:0x0148
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0147
  ,simpleLowerCaseMapping:0x0148
  ,simpleTitleCaseMapping:0x0147
 },
 { code:0x0149
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x0149
  ,simpleLowerCaseMapping:0x0149
  ,simpleTitleCaseMapping:0x0149
 },
 { code:0x014A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x014A
  ,simpleLowerCaseMapping:0x014B
  ,simpleTitleCaseMapping:0x014A
 },
 { code:0x014B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x014A
  ,simpleLowerCaseMapping:0x014B
  ,simpleTitleCaseMapping:0x014A
 },
 { code:0x014C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x014C
  ,simpleLowerCaseMapping:0x014D
  ,simpleTitleCaseMapping:0x014C
 },
 { code:0x014D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x014C
  ,simpleLowerCaseMapping:0x014D
  ,simpleTitleCaseMapping:0x014C
 },
 { code:0x014E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x014E
  ,simpleLowerCaseMapping:0x014F
  ,simpleTitleCaseMapping:0x014E
 },
 { code:0x014F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x014E
  ,simpleLowerCaseMapping:0x014F
  ,simpleTitleCaseMapping:0x014E
 },
 { code:0x0150
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0150
  ,simpleLowerCaseMapping:0x0151
  ,simpleTitleCaseMapping:0x0150
 },
 { code:0x0151
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0150
  ,simpleLowerCaseMapping:0x0151
  ,simpleTitleCaseMapping:0x0150
 },
 { code:0x0152
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0152
  ,simpleLowerCaseMapping:0x0153
  ,simpleTitleCaseMapping:0x0152
 },
 { code:0x0153
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0152
  ,simpleLowerCaseMapping:0x0153
  ,simpleTitleCaseMapping:0x0152
 },
 { code:0x0154
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0154
  ,simpleLowerCaseMapping:0x0155
  ,simpleTitleCaseMapping:0x0154
 },
 { code:0x0155
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0154
  ,simpleLowerCaseMapping:0x0155
  ,simpleTitleCaseMapping:0x0154
 },
 { code:0x0156
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0156
  ,simpleLowerCaseMapping:0x0157
  ,simpleTitleCaseMapping:0x0156
 },
 { code:0x0157
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0156
  ,simpleLowerCaseMapping:0x0157
  ,simpleTitleCaseMapping:0x0156
 },
 { code:0x0158
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0158
  ,simpleLowerCaseMapping:0x0159
  ,simpleTitleCaseMapping:0x0158
 },
 { code:0x0159
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0158
  ,simpleLowerCaseMapping:0x0159
  ,simpleTitleCaseMapping:0x0158
 },
 { code:0x015A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x015A
  ,simpleLowerCaseMapping:0x015B
  ,simpleTitleCaseMapping:0x015A
 },
 { code:0x015B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x015A
  ,simpleLowerCaseMapping:0x015B
  ,simpleTitleCaseMapping:0x015A
 },
 { code:0x015C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x015C
  ,simpleLowerCaseMapping:0x015D
  ,simpleTitleCaseMapping:0x015C
 },
 { code:0x015D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x015C
  ,simpleLowerCaseMapping:0x015D
  ,simpleTitleCaseMapping:0x015C
 },
 { code:0x015E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x015E
  ,simpleLowerCaseMapping:0x015F
  ,simpleTitleCaseMapping:0x015E
 },
 { code:0x015F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x015E
  ,simpleLowerCaseMapping:0x015F
  ,simpleTitleCaseMapping:0x015E
 },
 { code:0x0160
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0160
  ,simpleLowerCaseMapping:0x0161
  ,simpleTitleCaseMapping:0x0160
 },
 { code:0x0161
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0160
  ,simpleLowerCaseMapping:0x0161
  ,simpleTitleCaseMapping:0x0160
 },
 { code:0x0162
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0162
  ,simpleLowerCaseMapping:0x0163
  ,simpleTitleCaseMapping:0x0162
 },
 { code:0x0163
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0162
  ,simpleLowerCaseMapping:0x0163
  ,simpleTitleCaseMapping:0x0162
 },
 { code:0x0164
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0164
  ,simpleLowerCaseMapping:0x0165
  ,simpleTitleCaseMapping:0x0164
 },
 { code:0x0165
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0164
  ,simpleLowerCaseMapping:0x0165
  ,simpleTitleCaseMapping:0x0164
 },
 { code:0x0166
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0166
  ,simpleLowerCaseMapping:0x0167
  ,simpleTitleCaseMapping:0x0166
 },
 { code:0x0167
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0166
  ,simpleLowerCaseMapping:0x0167
  ,simpleTitleCaseMapping:0x0166
 },
 { code:0x0168
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0168
  ,simpleLowerCaseMapping:0x0169
  ,simpleTitleCaseMapping:0x0168
 },
 { code:0x0169
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0168
  ,simpleLowerCaseMapping:0x0169
  ,simpleTitleCaseMapping:0x0168
 },
 { code:0x016A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x016A
  ,simpleLowerCaseMapping:0x016B
  ,simpleTitleCaseMapping:0x016A
 },
 { code:0x016B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x016A
  ,simpleLowerCaseMapping:0x016B
  ,simpleTitleCaseMapping:0x016A
 },
 { code:0x016C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x016C
  ,simpleLowerCaseMapping:0x016D
  ,simpleTitleCaseMapping:0x016C
 },
 { code:0x016D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x016C
  ,simpleLowerCaseMapping:0x016D
  ,simpleTitleCaseMapping:0x016C
 },
 { code:0x016E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x016E
  ,simpleLowerCaseMapping:0x016F
  ,simpleTitleCaseMapping:0x016E
 },
 { code:0x016F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x016E
  ,simpleLowerCaseMapping:0x016F
  ,simpleTitleCaseMapping:0x016E
 },
 { code:0x0170
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0170
  ,simpleLowerCaseMapping:0x0171
  ,simpleTitleCaseMapping:0x0170
 },
 { code:0x0171
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0170
  ,simpleLowerCaseMapping:0x0171
  ,simpleTitleCaseMapping:0x0170
 },
 { code:0x0172
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0172
  ,simpleLowerCaseMapping:0x0173
  ,simpleTitleCaseMapping:0x0172
 },
 { code:0x0173
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0172
  ,simpleLowerCaseMapping:0x0173
  ,simpleTitleCaseMapping:0x0172
 },
 { code:0x0174
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0174
  ,simpleLowerCaseMapping:0x0175
  ,simpleTitleCaseMapping:0x0174
 },
 { code:0x0175
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0174
  ,simpleLowerCaseMapping:0x0175
  ,simpleTitleCaseMapping:0x0174
 },
 { code:0x0176
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0176
  ,simpleLowerCaseMapping:0x0177
  ,simpleTitleCaseMapping:0x0176
 },
 { code:0x0177
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0176
  ,simpleLowerCaseMapping:0x0177
  ,simpleTitleCaseMapping:0x0176
 },
 { code:0x0178
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0178
  ,simpleLowerCaseMapping:0x00FF
  ,simpleTitleCaseMapping:0x0178
 },
 { code:0x0179
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0179
  ,simpleLowerCaseMapping:0x017A
  ,simpleTitleCaseMapping:0x0179
 },
 { code:0x017A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0179
  ,simpleLowerCaseMapping:0x017A
  ,simpleTitleCaseMapping:0x0179
 },
 { code:0x017B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x017B
  ,simpleLowerCaseMapping:0x017C
  ,simpleTitleCaseMapping:0x017B
 },
 { code:0x017C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x017B
  ,simpleLowerCaseMapping:0x017C
  ,simpleTitleCaseMapping:0x017B
 },
 { code:0x017D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x017D
  ,simpleLowerCaseMapping:0x017E
  ,simpleTitleCaseMapping:0x017D
 },
 { code:0x017E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x017D
  ,simpleLowerCaseMapping:0x017E
  ,simpleTitleCaseMapping:0x017D
 },
 { code:0x017F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0053
  ,simpleLowerCaseMapping:0x017F
  ,simpleTitleCaseMapping:0x0053
 },
 { code:0x0180
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0243
  ,simpleLowerCaseMapping:0x0180
  ,simpleTitleCaseMapping:0x0243
 },
 { code:0x0181
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0181
  ,simpleLowerCaseMapping:0x0253
  ,simpleTitleCaseMapping:0x0181
 },
 { code:0x0182
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0182
  ,simpleLowerCaseMapping:0x0183
  ,simpleTitleCaseMapping:0x0182
 },
 { code:0x0183
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0182
  ,simpleLowerCaseMapping:0x0183
  ,simpleTitleCaseMapping:0x0182
 },
 { code:0x0184
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0184
  ,simpleLowerCaseMapping:0x0185
  ,simpleTitleCaseMapping:0x0184
 },
 { code:0x0185
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0184
  ,simpleLowerCaseMapping:0x0185
  ,simpleTitleCaseMapping:0x0184
 },
 { code:0x0186
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0186
  ,simpleLowerCaseMapping:0x0254
  ,simpleTitleCaseMapping:0x0186
 },
 { code:0x0187
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0187
  ,simpleLowerCaseMapping:0x0188
  ,simpleTitleCaseMapping:0x0187
 },
 { code:0x0188
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0187
  ,simpleLowerCaseMapping:0x0188
  ,simpleTitleCaseMapping:0x0187
 },
 { code:0x0189
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0189
  ,simpleLowerCaseMapping:0x0256
  ,simpleTitleCaseMapping:0x0189
 },
 { code:0x018A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x018A
  ,simpleLowerCaseMapping:0x0257
  ,simpleTitleCaseMapping:0x018A
 },
 { code:0x018B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x018B
  ,simpleLowerCaseMapping:0x018C
  ,simpleTitleCaseMapping:0x018B
 },
 { code:0x018C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x018B
  ,simpleLowerCaseMapping:0x018C
  ,simpleTitleCaseMapping:0x018B
 },
 { code:0x018D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x018D
  ,simpleLowerCaseMapping:0x018D
  ,simpleTitleCaseMapping:0x018D
 },
 { code:0x018E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x018E
  ,simpleLowerCaseMapping:0x01DD
  ,simpleTitleCaseMapping:0x018E
 },
 { code:0x018F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x018F
  ,simpleLowerCaseMapping:0x0259
  ,simpleTitleCaseMapping:0x018F
 },
 { code:0x0190
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0190
  ,simpleLowerCaseMapping:0x025B
  ,simpleTitleCaseMapping:0x0190
 },
 { code:0x0191
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0191
  ,simpleLowerCaseMapping:0x0192
  ,simpleTitleCaseMapping:0x0191
 },
 { code:0x0192
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0191
  ,simpleLowerCaseMapping:0x0192
  ,simpleTitleCaseMapping:0x0191
 },
 { code:0x0193
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0193
  ,simpleLowerCaseMapping:0x0260
  ,simpleTitleCaseMapping:0x0193
 },
 { code:0x0194
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0194
  ,simpleLowerCaseMapping:0x0263
  ,simpleTitleCaseMapping:0x0194
 },
 { code:0x0195
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01F6
  ,simpleLowerCaseMapping:0x0195
  ,simpleTitleCaseMapping:0x01F6
 },
 { code:0x0196
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0196
  ,simpleLowerCaseMapping:0x0269
  ,simpleTitleCaseMapping:0x0196
 },
 { code:0x0197
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0197
  ,simpleLowerCaseMapping:0x0268
  ,simpleTitleCaseMapping:0x0197
 },
 { code:0x0198
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0198
  ,simpleLowerCaseMapping:0x0199
  ,simpleTitleCaseMapping:0x0198
 },
 { code:0x0199
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0198
  ,simpleLowerCaseMapping:0x0199
  ,simpleTitleCaseMapping:0x0198
 },
 { code:0x019A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x023D
  ,simpleLowerCaseMapping:0x019A
  ,simpleTitleCaseMapping:0x023D
 },
 { code:0x019B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x019B
  ,simpleLowerCaseMapping:0x019B
  ,simpleTitleCaseMapping:0x019B
 },
 { code:0x019C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x019C
  ,simpleLowerCaseMapping:0x026F
  ,simpleTitleCaseMapping:0x019C
 },
 { code:0x019D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x019D
  ,simpleLowerCaseMapping:0x0272
  ,simpleTitleCaseMapping:0x019D
 },
 { code:0x019E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0220
  ,simpleLowerCaseMapping:0x019E
  ,simpleTitleCaseMapping:0x0220
 },
 { code:0x019F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x019F
  ,simpleLowerCaseMapping:0x0275
  ,simpleTitleCaseMapping:0x019F
 },
 { code:0x01A0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01A0
  ,simpleLowerCaseMapping:0x01A1
  ,simpleTitleCaseMapping:0x01A0
 },
 { code:0x01A1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01A0
  ,simpleLowerCaseMapping:0x01A1
  ,simpleTitleCaseMapping:0x01A0
 },
 { code:0x01A2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01A2
  ,simpleLowerCaseMapping:0x01A3
  ,simpleTitleCaseMapping:0x01A2
 },
 { code:0x01A3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01A2
  ,simpleLowerCaseMapping:0x01A3
  ,simpleTitleCaseMapping:0x01A2
 },
 { code:0x01A4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01A4
  ,simpleLowerCaseMapping:0x01A5
  ,simpleTitleCaseMapping:0x01A4
 },
 { code:0x01A5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01A4
  ,simpleLowerCaseMapping:0x01A5
  ,simpleTitleCaseMapping:0x01A4
 },
 { code:0x01A6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01A6
  ,simpleLowerCaseMapping:0x0280
  ,simpleTitleCaseMapping:0x01A6
 },
 { code:0x01A7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01A7
  ,simpleLowerCaseMapping:0x01A8
  ,simpleTitleCaseMapping:0x01A7
 },
 { code:0x01A8
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01A7
  ,simpleLowerCaseMapping:0x01A8
  ,simpleTitleCaseMapping:0x01A7
 },
 { code:0x01A9
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01A9
  ,simpleLowerCaseMapping:0x0283
  ,simpleTitleCaseMapping:0x01A9
 },
 { code:0x01AA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01AA
  ,simpleLowerCaseMapping:0x01AA
  ,simpleTitleCaseMapping:0x01AA
 },
 { code:0x01AB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01AB
  ,simpleLowerCaseMapping:0x01AB
  ,simpleTitleCaseMapping:0x01AB
 },
 { code:0x01AC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01AC
  ,simpleLowerCaseMapping:0x01AD
  ,simpleTitleCaseMapping:0x01AC
 },
 { code:0x01AD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01AC
  ,simpleLowerCaseMapping:0x01AD
  ,simpleTitleCaseMapping:0x01AC
 },
 { code:0x01AE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01AE
  ,simpleLowerCaseMapping:0x0288
  ,simpleTitleCaseMapping:0x01AE
 },
 { code:0x01AF
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01AF
  ,simpleLowerCaseMapping:0x01B0
  ,simpleTitleCaseMapping:0x01AF
 },
 { code:0x01B0
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01AF
  ,simpleLowerCaseMapping:0x01B0
  ,simpleTitleCaseMapping:0x01AF
 },
 { code:0x01B1
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01B1
  ,simpleLowerCaseMapping:0x028A
  ,simpleTitleCaseMapping:0x01B1
 },
 { code:0x01B2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01B2
  ,simpleLowerCaseMapping:0x028B
  ,simpleTitleCaseMapping:0x01B2
 },
 { code:0x01B3
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01B3
  ,simpleLowerCaseMapping:0x01B4
  ,simpleTitleCaseMapping:0x01B3
 },
 { code:0x01B4
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01B3
  ,simpleLowerCaseMapping:0x01B4
  ,simpleTitleCaseMapping:0x01B3
 },
 { code:0x01B5
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01B5
  ,simpleLowerCaseMapping:0x01B6
  ,simpleTitleCaseMapping:0x01B5
 },
 { code:0x01B6
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01B5
  ,simpleLowerCaseMapping:0x01B6
  ,simpleTitleCaseMapping:0x01B5
 },
 { code:0x01B7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01B7
  ,simpleLowerCaseMapping:0x0292
  ,simpleTitleCaseMapping:0x01B7
 },
 { code:0x01B8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01B8
  ,simpleLowerCaseMapping:0x01B9
  ,simpleTitleCaseMapping:0x01B8
 },
 { code:0x01B9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01B8
  ,simpleLowerCaseMapping:0x01B9
  ,simpleTitleCaseMapping:0x01B8
 },
 { code:0x01BA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01BA
  ,simpleLowerCaseMapping:0x01BA
  ,simpleTitleCaseMapping:0x01BA
 },
 { code:0x01BB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x01BB
  ,simpleLowerCaseMapping:0x01BB
  ,simpleTitleCaseMapping:0x01BB
 },
 { code:0x01BC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01BC
  ,simpleLowerCaseMapping:0x01BD
  ,simpleTitleCaseMapping:0x01BC
 },
 { code:0x01BD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01BC
  ,simpleLowerCaseMapping:0x01BD
  ,simpleTitleCaseMapping:0x01BC
 },
 { code:0x01BE
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01BE
  ,simpleLowerCaseMapping:0x01BE
  ,simpleTitleCaseMapping:0x01BE
 },
 { code:0x01BF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01F7
  ,simpleLowerCaseMapping:0x01BF
  ,simpleTitleCaseMapping:0x01F7
 },
 { code:0x01C0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x01C0
  ,simpleLowerCaseMapping:0x01C0
  ,simpleTitleCaseMapping:0x01C0
 },
 { code:0x01C1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x01C1
  ,simpleLowerCaseMapping:0x01C1
  ,simpleTitleCaseMapping:0x01C1
 },
 { code:0x01C2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x01C2
  ,simpleLowerCaseMapping:0x01C2
  ,simpleTitleCaseMapping:0x01C2
 },
 { code:0x01C3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x01C3
  ,simpleLowerCaseMapping:0x01C3
  ,simpleTitleCaseMapping:0x01C3
 },
 { code:0x01C4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01C4
  ,simpleLowerCaseMapping:0x01C6
  ,simpleTitleCaseMapping:0x01C5
 },
 { code:0x01C5
  ,generalCategory:UnicodeData.GeneralCategory.Lt
  ,simpleUpperCaseMapping:0x01C4
  ,simpleLowerCaseMapping:0x01C6
  ,simpleTitleCaseMapping:0x01C5
 },
 { code:0x01C6
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01C4
  ,simpleLowerCaseMapping:0x01C6
  ,simpleTitleCaseMapping:0x01C5
 },
 { code:0x01C7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01C7
  ,simpleLowerCaseMapping:0x01C9
  ,simpleTitleCaseMapping:0x01C8
 },
 { code:0x01C8
  ,generalCategory:UnicodeData.GeneralCategory.Lt
  ,simpleUpperCaseMapping:0x01C7
  ,simpleLowerCaseMapping:0x01C9
  ,simpleTitleCaseMapping:0x01C8
 },
 { code:0x01C9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01C7
  ,simpleLowerCaseMapping:0x01C9
  ,simpleTitleCaseMapping:0x01C8
 },
 { code:0x01CA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01CA
  ,simpleLowerCaseMapping:0x01CC
  ,simpleTitleCaseMapping:0x01CB
 },
 { code:0x01CB
  ,generalCategory:UnicodeData.GeneralCategory.Lt
  ,simpleUpperCaseMapping:0x01CA
  ,simpleLowerCaseMapping:0x01CC
  ,simpleTitleCaseMapping:0x01CB
 },
 { code:0x01CC
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01CA
  ,simpleLowerCaseMapping:0x01CC
  ,simpleTitleCaseMapping:0x01CB
 },
 { code:0x01CD
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01CD
  ,simpleLowerCaseMapping:0x01CE
  ,simpleTitleCaseMapping:0x01CD
 },
 { code:0x01CE
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01CD
  ,simpleLowerCaseMapping:0x01CE
  ,simpleTitleCaseMapping:0x01CD
 },
 { code:0x01CF
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01CF
  ,simpleLowerCaseMapping:0x01D0
  ,simpleTitleCaseMapping:0x01CF
 },
 { code:0x01D0
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01CF
  ,simpleLowerCaseMapping:0x01D0
  ,simpleTitleCaseMapping:0x01CF
 },
 { code:0x01D1
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01D1
  ,simpleLowerCaseMapping:0x01D2
  ,simpleTitleCaseMapping:0x01D1
 },
 { code:0x01D2
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01D1
  ,simpleLowerCaseMapping:0x01D2
  ,simpleTitleCaseMapping:0x01D1
 },
 { code:0x01D3
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01D3
  ,simpleLowerCaseMapping:0x01D4
  ,simpleTitleCaseMapping:0x01D3
 },
 { code:0x01D4
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01D3
  ,simpleLowerCaseMapping:0x01D4
  ,simpleTitleCaseMapping:0x01D3
 },
 { code:0x01D5
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01D5
  ,simpleLowerCaseMapping:0x01D6
  ,simpleTitleCaseMapping:0x01D5
 },
 { code:0x01D6
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01D5
  ,simpleLowerCaseMapping:0x01D6
  ,simpleTitleCaseMapping:0x01D5
 },
 { code:0x01D7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01D7
  ,simpleLowerCaseMapping:0x01D8
  ,simpleTitleCaseMapping:0x01D7
 },
 { code:0x01D8
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01D7
  ,simpleLowerCaseMapping:0x01D8
  ,simpleTitleCaseMapping:0x01D7
 },
 { code:0x01D9
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01D9
  ,simpleLowerCaseMapping:0x01DA
  ,simpleTitleCaseMapping:0x01D9
 },
 { code:0x01DA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01D9
  ,simpleLowerCaseMapping:0x01DA
  ,simpleTitleCaseMapping:0x01D9
 },
 { code:0x01DB
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01DB
  ,simpleLowerCaseMapping:0x01DC
  ,simpleTitleCaseMapping:0x01DB
 },
 { code:0x01DC
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01DB
  ,simpleLowerCaseMapping:0x01DC
  ,simpleTitleCaseMapping:0x01DB
 },
 { code:0x01DD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x018E
  ,simpleLowerCaseMapping:0x01DD
  ,simpleTitleCaseMapping:0x018E
 },
 { code:0x01DE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01DE
  ,simpleLowerCaseMapping:0x01DF
  ,simpleTitleCaseMapping:0x01DE
 },
 { code:0x01DF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01DE
  ,simpleLowerCaseMapping:0x01DF
  ,simpleTitleCaseMapping:0x01DE
 },
 { code:0x01E0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01E0
  ,simpleLowerCaseMapping:0x01E1
  ,simpleTitleCaseMapping:0x01E0
 },
 { code:0x01E1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01E0
  ,simpleLowerCaseMapping:0x01E1
  ,simpleTitleCaseMapping:0x01E0
 },
 { code:0x01E2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01E2
  ,simpleLowerCaseMapping:0x01E3
  ,simpleTitleCaseMapping:0x01E2
 },
 { code:0x01E3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01E2
  ,simpleLowerCaseMapping:0x01E3
  ,simpleTitleCaseMapping:0x01E2
 },
 { code:0x01E4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01E4
  ,simpleLowerCaseMapping:0x01E5
  ,simpleTitleCaseMapping:0x01E4
 },
 { code:0x01E5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01E4
  ,simpleLowerCaseMapping:0x01E5
  ,simpleTitleCaseMapping:0x01E4
 },
 { code:0x01E6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01E6
  ,simpleLowerCaseMapping:0x01E7
  ,simpleTitleCaseMapping:0x01E6
 },
 { code:0x01E7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01E6
  ,simpleLowerCaseMapping:0x01E7
  ,simpleTitleCaseMapping:0x01E6
 },
 { code:0x01E8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01E8
  ,simpleLowerCaseMapping:0x01E9
  ,simpleTitleCaseMapping:0x01E8
 },
 { code:0x01E9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01E8
  ,simpleLowerCaseMapping:0x01E9
  ,simpleTitleCaseMapping:0x01E8
 },
 { code:0x01EA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01EA
  ,simpleLowerCaseMapping:0x01EB
  ,simpleTitleCaseMapping:0x01EA
 },
 { code:0x01EB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01EA
  ,simpleLowerCaseMapping:0x01EB
  ,simpleTitleCaseMapping:0x01EA
 },
 { code:0x01EC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01EC
  ,simpleLowerCaseMapping:0x01ED
  ,simpleTitleCaseMapping:0x01EC
 },
 { code:0x01ED
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01EC
  ,simpleLowerCaseMapping:0x01ED
  ,simpleTitleCaseMapping:0x01EC
 },
 { code:0x01EE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01EE
  ,simpleLowerCaseMapping:0x01EF
  ,simpleTitleCaseMapping:0x01EE
 },
 { code:0x01EF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01EE
  ,simpleLowerCaseMapping:0x01EF
  ,simpleTitleCaseMapping:0x01EE
 },
 { code:0x01F0
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x01F0
  ,simpleLowerCaseMapping:0x01F0
  ,simpleTitleCaseMapping:0x01F0
 },
 { code:0x01F1
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01F1
  ,simpleLowerCaseMapping:0x01F3
  ,simpleTitleCaseMapping:0x01F2
 },
 { code:0x01F2
  ,generalCategory:UnicodeData.GeneralCategory.Lt
  ,simpleUpperCaseMapping:0x01F1
  ,simpleLowerCaseMapping:0x01F3
  ,simpleTitleCaseMapping:0x01F2
 },
 { code:0x01F3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01F1
  ,simpleLowerCaseMapping:0x01F3
  ,simpleTitleCaseMapping:0x01F2
 },
 { code:0x01F4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01F4
  ,simpleLowerCaseMapping:0x01F5
  ,simpleTitleCaseMapping:0x01F4
 },
 { code:0x01F5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01F4
  ,simpleLowerCaseMapping:0x01F5
  ,simpleTitleCaseMapping:0x01F4
 },
 { code:0x01F6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01F6
  ,simpleLowerCaseMapping:0x0195
  ,simpleTitleCaseMapping:0x01F6
 },
 { code:0x01F7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01F7
  ,simpleLowerCaseMapping:0x01BF
  ,simpleTitleCaseMapping:0x01F7
 },
 { code:0x01F8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01F8
  ,simpleLowerCaseMapping:0x01F9
  ,simpleTitleCaseMapping:0x01F8
 },
 { code:0x01F9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01F8
  ,simpleLowerCaseMapping:0x01F9
  ,simpleTitleCaseMapping:0x01F8
 },
 { code:0x01FA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01FA
  ,simpleLowerCaseMapping:0x01FB
  ,simpleTitleCaseMapping:0x01FA
 },
 { code:0x01FB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01FA
  ,simpleLowerCaseMapping:0x01FB
  ,simpleTitleCaseMapping:0x01FA
 },
 { code:0x01FC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01FC
  ,simpleLowerCaseMapping:0x01FD
  ,simpleTitleCaseMapping:0x01FC
 },
 { code:0x01FD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01FC
  ,simpleLowerCaseMapping:0x01FD
  ,simpleTitleCaseMapping:0x01FC
 },
 { code:0x01FE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x01FE
  ,simpleLowerCaseMapping:0x01FF
  ,simpleTitleCaseMapping:0x01FE
 },
 { code:0x01FF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01FE
  ,simpleLowerCaseMapping:0x01FF
  ,simpleTitleCaseMapping:0x01FE
 },
 { code:0x0200
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0200
  ,simpleLowerCaseMapping:0x0201
  ,simpleTitleCaseMapping:0x0200
 },
 { code:0x0201
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0200
  ,simpleLowerCaseMapping:0x0201
  ,simpleTitleCaseMapping:0x0200
 },
 { code:0x0202
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0202
  ,simpleLowerCaseMapping:0x0203
  ,simpleTitleCaseMapping:0x0202
 },
 { code:0x0203
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0202
  ,simpleLowerCaseMapping:0x0203
  ,simpleTitleCaseMapping:0x0202
 },
 { code:0x0204
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0204
  ,simpleLowerCaseMapping:0x0205
  ,simpleTitleCaseMapping:0x0204
 },
 { code:0x0205
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0204
  ,simpleLowerCaseMapping:0x0205
  ,simpleTitleCaseMapping:0x0204
 },
 { code:0x0206
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0206
  ,simpleLowerCaseMapping:0x0207
  ,simpleTitleCaseMapping:0x0206
 },
 { code:0x0207
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0206
  ,simpleLowerCaseMapping:0x0207
  ,simpleTitleCaseMapping:0x0206
 },
 { code:0x0208
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0208
  ,simpleLowerCaseMapping:0x0209
  ,simpleTitleCaseMapping:0x0208
 },
 { code:0x0209
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0208
  ,simpleLowerCaseMapping:0x0209
  ,simpleTitleCaseMapping:0x0208
 },
 { code:0x020A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x020A
  ,simpleLowerCaseMapping:0x020B
  ,simpleTitleCaseMapping:0x020A
 },
 { code:0x020B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x020A
  ,simpleLowerCaseMapping:0x020B
  ,simpleTitleCaseMapping:0x020A
 },
 { code:0x020C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x020C
  ,simpleLowerCaseMapping:0x020D
  ,simpleTitleCaseMapping:0x020C
 },
 { code:0x020D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x020C
  ,simpleLowerCaseMapping:0x020D
  ,simpleTitleCaseMapping:0x020C
 },
 { code:0x020E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x020E
  ,simpleLowerCaseMapping:0x020F
  ,simpleTitleCaseMapping:0x020E
 },
 { code:0x020F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x020E
  ,simpleLowerCaseMapping:0x020F
  ,simpleTitleCaseMapping:0x020E
 },
 { code:0x0210
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0210
  ,simpleLowerCaseMapping:0x0211
  ,simpleTitleCaseMapping:0x0210
 },
 { code:0x0211
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0210
  ,simpleLowerCaseMapping:0x0211
  ,simpleTitleCaseMapping:0x0210
 },
 { code:0x0212
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0212
  ,simpleLowerCaseMapping:0x0213
  ,simpleTitleCaseMapping:0x0212
 },
 { code:0x0213
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0212
  ,simpleLowerCaseMapping:0x0213
  ,simpleTitleCaseMapping:0x0212
 },
 { code:0x0214
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0214
  ,simpleLowerCaseMapping:0x0215
  ,simpleTitleCaseMapping:0x0214
 },
 { code:0x0215
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0214
  ,simpleLowerCaseMapping:0x0215
  ,simpleTitleCaseMapping:0x0214
 },
 { code:0x0216
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0216
  ,simpleLowerCaseMapping:0x0217
  ,simpleTitleCaseMapping:0x0216
 },
 { code:0x0217
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0216
  ,simpleLowerCaseMapping:0x0217
  ,simpleTitleCaseMapping:0x0216
 },
 { code:0x0218
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0218
  ,simpleLowerCaseMapping:0x0219
  ,simpleTitleCaseMapping:0x0218
 },
 { code:0x0219
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0218
  ,simpleLowerCaseMapping:0x0219
  ,simpleTitleCaseMapping:0x0218
 },
 { code:0x021A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x021A
  ,simpleLowerCaseMapping:0x021B
  ,simpleTitleCaseMapping:0x021A
 },
 { code:0x021B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x021A
  ,simpleLowerCaseMapping:0x021B
  ,simpleTitleCaseMapping:0x021A
 },
 { code:0x021C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x021C
  ,simpleLowerCaseMapping:0x021D
  ,simpleTitleCaseMapping:0x021C
 },
 { code:0x021D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x021C
  ,simpleLowerCaseMapping:0x021D
  ,simpleTitleCaseMapping:0x021C
 },
 { code:0x021E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x021E
  ,simpleLowerCaseMapping:0x021F
  ,simpleTitleCaseMapping:0x021E
 },
 { code:0x021F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x021E
  ,simpleLowerCaseMapping:0x021F
  ,simpleTitleCaseMapping:0x021E
 },
 { code:0x0220
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0220
  ,simpleLowerCaseMapping:0x019E
  ,simpleTitleCaseMapping:0x0220
 },
 { code:0x0221
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0221
  ,simpleLowerCaseMapping:0x0221
  ,simpleTitleCaseMapping:0x0221
 },
 { code:0x0222
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0222
  ,simpleLowerCaseMapping:0x0223
  ,simpleTitleCaseMapping:0x0222
 },
 { code:0x0223
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0222
  ,simpleLowerCaseMapping:0x0223
  ,simpleTitleCaseMapping:0x0222
 },
 { code:0x0224
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0224
  ,simpleLowerCaseMapping:0x0225
  ,simpleTitleCaseMapping:0x0224
 },
 { code:0x0225
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0224
  ,simpleLowerCaseMapping:0x0225
  ,simpleTitleCaseMapping:0x0224
 },
 { code:0x0226
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0226
  ,simpleLowerCaseMapping:0x0227
  ,simpleTitleCaseMapping:0x0226
 },
 { code:0x0227
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0226
  ,simpleLowerCaseMapping:0x0227
  ,simpleTitleCaseMapping:0x0226
 },
 { code:0x0228
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0228
  ,simpleLowerCaseMapping:0x0229
  ,simpleTitleCaseMapping:0x0228
 },
 { code:0x0229
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0228
  ,simpleLowerCaseMapping:0x0229
  ,simpleTitleCaseMapping:0x0228
 },
 { code:0x022A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x022A
  ,simpleLowerCaseMapping:0x022B
  ,simpleTitleCaseMapping:0x022A
 },
 { code:0x022B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x022A
  ,simpleLowerCaseMapping:0x022B
  ,simpleTitleCaseMapping:0x022A
 },
 { code:0x022C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x022C
  ,simpleLowerCaseMapping:0x022D
  ,simpleTitleCaseMapping:0x022C
 },
 { code:0x022D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x022C
  ,simpleLowerCaseMapping:0x022D
  ,simpleTitleCaseMapping:0x022C
 },
 { code:0x022E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x022E
  ,simpleLowerCaseMapping:0x022F
  ,simpleTitleCaseMapping:0x022E
 },
 { code:0x022F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x022E
  ,simpleLowerCaseMapping:0x022F
  ,simpleTitleCaseMapping:0x022E
 },
 { code:0x0230
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0230
  ,simpleLowerCaseMapping:0x0231
  ,simpleTitleCaseMapping:0x0230
 },
 { code:0x0231
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0230
  ,simpleLowerCaseMapping:0x0231
  ,simpleTitleCaseMapping:0x0230
 },
 { code:0x0232
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0232
  ,simpleLowerCaseMapping:0x0233
  ,simpleTitleCaseMapping:0x0232
 },
 { code:0x0233
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0232
  ,simpleLowerCaseMapping:0x0233
  ,simpleTitleCaseMapping:0x0232
 },
 { code:0x0234
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0234
  ,simpleLowerCaseMapping:0x0234
  ,simpleTitleCaseMapping:0x0234
 },
 { code:0x0235
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0235
  ,simpleLowerCaseMapping:0x0235
  ,simpleTitleCaseMapping:0x0235
 },
 { code:0x0236
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0236
  ,simpleLowerCaseMapping:0x0236
  ,simpleTitleCaseMapping:0x0236
 },
 { code:0x0237
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0237
  ,simpleLowerCaseMapping:0x0237
  ,simpleTitleCaseMapping:0x0237
 },
 { code:0x0238
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0238
  ,simpleLowerCaseMapping:0x0238
  ,simpleTitleCaseMapping:0x0238
 },
 { code:0x0239
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0239
  ,simpleLowerCaseMapping:0x0239
  ,simpleTitleCaseMapping:0x0239
 },
 { code:0x023A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x023A
  ,simpleLowerCaseMapping:0x2C65
  ,simpleTitleCaseMapping:0x023A
 },
 { code:0x023B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x023B
  ,simpleLowerCaseMapping:0x023C
  ,simpleTitleCaseMapping:0x023B
 },
 { code:0x023C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x023B
  ,simpleLowerCaseMapping:0x023C
  ,simpleTitleCaseMapping:0x023B
 },
 { code:0x023D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x023D
  ,simpleLowerCaseMapping:0x019A
  ,simpleTitleCaseMapping:0x023D
 },
 { code:0x023E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x023E
  ,simpleLowerCaseMapping:0x2C66
  ,simpleTitleCaseMapping:0x023E
 },
 { code:0x023F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x023F
  ,simpleLowerCaseMapping:0x023F
  ,simpleTitleCaseMapping:0x023F
 },
 { code:0x0240
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0240
  ,simpleLowerCaseMapping:0x0240
  ,simpleTitleCaseMapping:0x0240
 },
 { code:0x0241
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0241
  ,simpleLowerCaseMapping:0x0242
  ,simpleTitleCaseMapping:0x0241
 },
 { code:0x0242
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0241
  ,simpleLowerCaseMapping:0x0242
  ,simpleTitleCaseMapping:0x0241
 },
 { code:0x0243
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0243
  ,simpleLowerCaseMapping:0x0180
  ,simpleTitleCaseMapping:0x0243
 },
 { code:0x0244
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0244
  ,simpleLowerCaseMapping:0x0289
  ,simpleTitleCaseMapping:0x0244
 },
 { code:0x0245
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0245
  ,simpleLowerCaseMapping:0x028C
  ,simpleTitleCaseMapping:0x0245
 },
 { code:0x0246
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0246
  ,simpleLowerCaseMapping:0x0247
  ,simpleTitleCaseMapping:0x0246
 },
 { code:0x0247
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0246
  ,simpleLowerCaseMapping:0x0247
  ,simpleTitleCaseMapping:0x0246
 },
 { code:0x0248
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0248
  ,simpleLowerCaseMapping:0x0249
  ,simpleTitleCaseMapping:0x0248
 },
 { code:0x0249
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0248
  ,simpleLowerCaseMapping:0x0249
  ,simpleTitleCaseMapping:0x0248
 },
 { code:0x024A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x024A
  ,simpleLowerCaseMapping:0x024B
  ,simpleTitleCaseMapping:0x024A
 },
 { code:0x024B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x024A
  ,simpleLowerCaseMapping:0x024B
  ,simpleTitleCaseMapping:0x024A
 },
 { code:0x024C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x024C
  ,simpleLowerCaseMapping:0x024D
  ,simpleTitleCaseMapping:0x024C
 },
 { code:0x024D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x024C
  ,simpleLowerCaseMapping:0x024D
  ,simpleTitleCaseMapping:0x024C
 },
 { code:0x024E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x024E
  ,simpleLowerCaseMapping:0x024F
  ,simpleTitleCaseMapping:0x024E
 },
 { code:0x024F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x024E
  ,simpleLowerCaseMapping:0x024F
  ,simpleTitleCaseMapping:0x024E
 },
 { code:0x0250
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0250
  ,simpleLowerCaseMapping:0x0250
  ,simpleTitleCaseMapping:0x0250
 },
 { code:0x0251
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0251
  ,simpleLowerCaseMapping:0x0251
  ,simpleTitleCaseMapping:0x0251
 },
 { code:0x0252
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0252
  ,simpleLowerCaseMapping:0x0252
  ,simpleTitleCaseMapping:0x0252
 },
 { code:0x0253
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0181
  ,simpleLowerCaseMapping:0x0253
  ,simpleTitleCaseMapping:0x0181
 },
 { code:0x0254
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0186
  ,simpleLowerCaseMapping:0x0254
  ,simpleTitleCaseMapping:0x0186
 },
 { code:0x0255
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0255
  ,simpleLowerCaseMapping:0x0255
  ,simpleTitleCaseMapping:0x0255
 },
 { code:0x0256
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0189
  ,simpleLowerCaseMapping:0x0256
  ,simpleTitleCaseMapping:0x0189
 },
 { code:0x0257
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x018A
  ,simpleLowerCaseMapping:0x0257
  ,simpleTitleCaseMapping:0x018A
 },
 { code:0x0258
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0258
  ,simpleLowerCaseMapping:0x0258
  ,simpleTitleCaseMapping:0x0258
 },
 { code:0x0259
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x018F
  ,simpleLowerCaseMapping:0x0259
  ,simpleTitleCaseMapping:0x018F
 },
 { code:0x025A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x025A
  ,simpleLowerCaseMapping:0x025A
  ,simpleTitleCaseMapping:0x025A
 },
 { code:0x025B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0190
  ,simpleLowerCaseMapping:0x025B
  ,simpleTitleCaseMapping:0x0190
 },
 { code:0x025C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x025C
  ,simpleLowerCaseMapping:0x025C
  ,simpleTitleCaseMapping:0x025C
 },
 { code:0x025D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x025D
  ,simpleLowerCaseMapping:0x025D
  ,simpleTitleCaseMapping:0x025D
 },
 { code:0x025E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x025E
  ,simpleLowerCaseMapping:0x025E
  ,simpleTitleCaseMapping:0x025E
 },
 { code:0x025F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x025F
  ,simpleLowerCaseMapping:0x025F
  ,simpleTitleCaseMapping:0x025F
 },
 { code:0x0260
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0193
  ,simpleLowerCaseMapping:0x0260
  ,simpleTitleCaseMapping:0x0193
 },
 { code:0x0261
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0261
  ,simpleLowerCaseMapping:0x0261
  ,simpleTitleCaseMapping:0x0261
 },
 { code:0x0262
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0262
  ,simpleLowerCaseMapping:0x0262
  ,simpleTitleCaseMapping:0x0262
 },
 { code:0x0263
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0194
  ,simpleLowerCaseMapping:0x0263
  ,simpleTitleCaseMapping:0x0194
 },
 { code:0x0264
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0264
  ,simpleLowerCaseMapping:0x0264
  ,simpleTitleCaseMapping:0x0264
 },
 { code:0x0265
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0265
  ,simpleLowerCaseMapping:0x0265
  ,simpleTitleCaseMapping:0x0265
 },
 { code:0x0266
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0266
  ,simpleLowerCaseMapping:0x0266
  ,simpleTitleCaseMapping:0x0266
 },
 { code:0x0267
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0267
  ,simpleLowerCaseMapping:0x0267
  ,simpleTitleCaseMapping:0x0267
 },
 { code:0x0268
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0197
  ,simpleLowerCaseMapping:0x0268
  ,simpleTitleCaseMapping:0x0197
 },
 { code:0x0269
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0196
  ,simpleLowerCaseMapping:0x0269
  ,simpleTitleCaseMapping:0x0196
 },
 { code:0x026A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x026A
  ,simpleLowerCaseMapping:0x026A
  ,simpleTitleCaseMapping:0x026A
 },
 { code:0x026B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x2C62
  ,simpleLowerCaseMapping:0x026B
  ,simpleTitleCaseMapping:0x2C62
 },
 { code:0x026C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x026C
  ,simpleLowerCaseMapping:0x026C
  ,simpleTitleCaseMapping:0x026C
 },
 { code:0x026D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x026D
  ,simpleLowerCaseMapping:0x026D
  ,simpleTitleCaseMapping:0x026D
 },
 { code:0x026E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x026E
  ,simpleLowerCaseMapping:0x026E
  ,simpleTitleCaseMapping:0x026E
 },
 { code:0x026F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x019C
  ,simpleLowerCaseMapping:0x026F
  ,simpleTitleCaseMapping:0x019C
 },
 { code:0x0270
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0270
  ,simpleLowerCaseMapping:0x0270
  ,simpleTitleCaseMapping:0x0270
 },
 { code:0x0271
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0271
  ,simpleLowerCaseMapping:0x0271
  ,simpleTitleCaseMapping:0x0271
 },
 { code:0x0272
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x019D
  ,simpleLowerCaseMapping:0x0272
  ,simpleTitleCaseMapping:0x019D
 },
 { code:0x0273
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0273
  ,simpleLowerCaseMapping:0x0273
  ,simpleTitleCaseMapping:0x0273
 },
 { code:0x0274
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0274
  ,simpleLowerCaseMapping:0x0274
  ,simpleTitleCaseMapping:0x0274
 },
 { code:0x0275
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x019F
  ,simpleLowerCaseMapping:0x0275
  ,simpleTitleCaseMapping:0x019F
 },
 { code:0x0276
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0276
  ,simpleLowerCaseMapping:0x0276
  ,simpleTitleCaseMapping:0x0276
 },
 { code:0x0277
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0277
  ,simpleLowerCaseMapping:0x0277
  ,simpleTitleCaseMapping:0x0277
 },
 { code:0x0278
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0278
  ,simpleLowerCaseMapping:0x0278
  ,simpleTitleCaseMapping:0x0278
 },
 { code:0x0279
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0279
  ,simpleLowerCaseMapping:0x0279
  ,simpleTitleCaseMapping:0x0279
 },
 { code:0x027A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x027A
  ,simpleLowerCaseMapping:0x027A
  ,simpleTitleCaseMapping:0x027A
 },
 { code:0x027B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x027B
  ,simpleLowerCaseMapping:0x027B
  ,simpleTitleCaseMapping:0x027B
 },
 { code:0x027C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x027C
  ,simpleLowerCaseMapping:0x027C
  ,simpleTitleCaseMapping:0x027C
 },
 { code:0x027D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x2C64
  ,simpleLowerCaseMapping:0x027D
  ,simpleTitleCaseMapping:0x2C64
 },
 { code:0x027E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x027E
  ,simpleLowerCaseMapping:0x027E
  ,simpleTitleCaseMapping:0x027E
 },
 { code:0x027F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x027F
  ,simpleLowerCaseMapping:0x027F
  ,simpleTitleCaseMapping:0x027F
 },
 { code:0x0280
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01A6
  ,simpleLowerCaseMapping:0x0280
  ,simpleTitleCaseMapping:0x01A6
 },
 { code:0x0281
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0281
  ,simpleLowerCaseMapping:0x0281
  ,simpleTitleCaseMapping:0x0281
 },
 { code:0x0282
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0282
  ,simpleLowerCaseMapping:0x0282
  ,simpleTitleCaseMapping:0x0282
 },
 { code:0x0283
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01A9
  ,simpleLowerCaseMapping:0x0283
  ,simpleTitleCaseMapping:0x01A9
 },
 { code:0x0284
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0284
  ,simpleLowerCaseMapping:0x0284
  ,simpleTitleCaseMapping:0x0284
 },
 { code:0x0285
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0285
  ,simpleLowerCaseMapping:0x0285
  ,simpleTitleCaseMapping:0x0285
 },
 { code:0x0286
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0286
  ,simpleLowerCaseMapping:0x0286
  ,simpleTitleCaseMapping:0x0286
 },
 { code:0x0287
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0287
  ,simpleLowerCaseMapping:0x0287
  ,simpleTitleCaseMapping:0x0287
 },
 { code:0x0288
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01AE
  ,simpleLowerCaseMapping:0x0288
  ,simpleTitleCaseMapping:0x01AE
 },
 { code:0x0289
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0244
  ,simpleLowerCaseMapping:0x0289
  ,simpleTitleCaseMapping:0x0244
 },
 { code:0x028A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01B1
  ,simpleLowerCaseMapping:0x028A
  ,simpleTitleCaseMapping:0x01B1
 },
 { code:0x028B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01B2
  ,simpleLowerCaseMapping:0x028B
  ,simpleTitleCaseMapping:0x01B2
 },
 { code:0x028C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0245
  ,simpleLowerCaseMapping:0x028C
  ,simpleTitleCaseMapping:0x0245
 },
 { code:0x028D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x028D
  ,simpleLowerCaseMapping:0x028D
  ,simpleTitleCaseMapping:0x028D
 },
 { code:0x028E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x028E
  ,simpleLowerCaseMapping:0x028E
  ,simpleTitleCaseMapping:0x028E
 },
 { code:0x028F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x028F
  ,simpleLowerCaseMapping:0x028F
  ,simpleTitleCaseMapping:0x028F
 },
 { code:0x0290
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0290
  ,simpleLowerCaseMapping:0x0290
  ,simpleTitleCaseMapping:0x0290
 },
 { code:0x0291
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0291
  ,simpleLowerCaseMapping:0x0291
  ,simpleTitleCaseMapping:0x0291
 },
 { code:0x0292
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x01B7
  ,simpleLowerCaseMapping:0x0292
  ,simpleTitleCaseMapping:0x01B7
 },
 { code:0x0293
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0293
  ,simpleLowerCaseMapping:0x0293
  ,simpleTitleCaseMapping:0x0293
 },
 { code:0x0294
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0294
  ,simpleLowerCaseMapping:0x0294
  ,simpleTitleCaseMapping:0x0294
 },
 { code:0x0295
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0295
  ,simpleLowerCaseMapping:0x0295
  ,simpleTitleCaseMapping:0x0295
 },
 { code:0x0296
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0296
  ,simpleLowerCaseMapping:0x0296
  ,simpleTitleCaseMapping:0x0296
 },
 { code:0x0297
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0297
  ,simpleLowerCaseMapping:0x0297
  ,simpleTitleCaseMapping:0x0297
 },
 { code:0x0298
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0298
  ,simpleLowerCaseMapping:0x0298
  ,simpleTitleCaseMapping:0x0298
 },
 { code:0x0299
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0299
  ,simpleLowerCaseMapping:0x0299
  ,simpleTitleCaseMapping:0x0299
 },
 { code:0x029A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x029A
  ,simpleLowerCaseMapping:0x029A
  ,simpleTitleCaseMapping:0x029A
 },
 { code:0x029B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x029B
  ,simpleLowerCaseMapping:0x029B
  ,simpleTitleCaseMapping:0x029B
 },
 { code:0x029C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x029C
  ,simpleLowerCaseMapping:0x029C
  ,simpleTitleCaseMapping:0x029C
 },
 { code:0x029D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x029D
  ,simpleLowerCaseMapping:0x029D
  ,simpleTitleCaseMapping:0x029D
 },
 { code:0x029E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x029E
  ,simpleLowerCaseMapping:0x029E
  ,simpleTitleCaseMapping:0x029E
 },
 { code:0x029F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x029F
  ,simpleLowerCaseMapping:0x029F
  ,simpleTitleCaseMapping:0x029F
 },
 { code:0x02A0
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02A0
  ,simpleLowerCaseMapping:0x02A0
  ,simpleTitleCaseMapping:0x02A0
 },
 { code:0x02A1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02A1
  ,simpleLowerCaseMapping:0x02A1
  ,simpleTitleCaseMapping:0x02A1
 },
 { code:0x02A2
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02A2
  ,simpleLowerCaseMapping:0x02A2
  ,simpleTitleCaseMapping:0x02A2
 },
 { code:0x02A3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02A3
  ,simpleLowerCaseMapping:0x02A3
  ,simpleTitleCaseMapping:0x02A3
 },
 { code:0x02A4
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02A4
  ,simpleLowerCaseMapping:0x02A4
  ,simpleTitleCaseMapping:0x02A4
 },
 { code:0x02A5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02A5
  ,simpleLowerCaseMapping:0x02A5
  ,simpleTitleCaseMapping:0x02A5
 },
 { code:0x02A6
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02A6
  ,simpleLowerCaseMapping:0x02A6
  ,simpleTitleCaseMapping:0x02A6
 },
 { code:0x02A7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02A7
  ,simpleLowerCaseMapping:0x02A7
  ,simpleTitleCaseMapping:0x02A7
 },
 { code:0x02A8
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02A8
  ,simpleLowerCaseMapping:0x02A8
  ,simpleTitleCaseMapping:0x02A8
 },
 { code:0x02A9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02A9
  ,simpleLowerCaseMapping:0x02A9
  ,simpleTitleCaseMapping:0x02A9
 },
 { code:0x02AA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02AA
  ,simpleLowerCaseMapping:0x02AA
  ,simpleTitleCaseMapping:0x02AA
 },
 { code:0x02AB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02AB
  ,simpleLowerCaseMapping:0x02AB
  ,simpleTitleCaseMapping:0x02AB
 },
 { code:0x02AC
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02AC
  ,simpleLowerCaseMapping:0x02AC
  ,simpleTitleCaseMapping:0x02AC
 },
 { code:0x02AD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02AD
  ,simpleLowerCaseMapping:0x02AD
  ,simpleTitleCaseMapping:0x02AD
 },
 { code:0x02AE
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02AE
  ,simpleLowerCaseMapping:0x02AE
  ,simpleTitleCaseMapping:0x02AE
 },
 { code:0x02AF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x02AF
  ,simpleLowerCaseMapping:0x02AF
  ,simpleTitleCaseMapping:0x02AF
 },
 { code:0x02B0
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02B0
  ,simpleLowerCaseMapping:0x02B0
  ,simpleTitleCaseMapping:0x02B0
 },
 { code:0x02B1
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02B1
  ,simpleLowerCaseMapping:0x02B1
  ,simpleTitleCaseMapping:0x02B1
 },
 { code:0x02B2
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02B2
  ,simpleLowerCaseMapping:0x02B2
  ,simpleTitleCaseMapping:0x02B2
 },
 { code:0x02B3
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02B3
  ,simpleLowerCaseMapping:0x02B3
  ,simpleTitleCaseMapping:0x02B3
 },
 { code:0x02B4
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02B4
  ,simpleLowerCaseMapping:0x02B4
  ,simpleTitleCaseMapping:0x02B4
 },
 { code:0x02B5
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02B5
  ,simpleLowerCaseMapping:0x02B5
  ,simpleTitleCaseMapping:0x02B5
 },
 { code:0x02B6
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02B6
  ,simpleLowerCaseMapping:0x02B6
  ,simpleTitleCaseMapping:0x02B6
 },
 { code:0x02B7
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02B7
  ,simpleLowerCaseMapping:0x02B7
  ,simpleTitleCaseMapping:0x02B7
 },
 { code:0x02B8
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02B8
  ,simpleLowerCaseMapping:0x02B8
  ,simpleTitleCaseMapping:0x02B8
 },
 { code:0x02B9
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02B9
  ,simpleLowerCaseMapping:0x02B9
  ,simpleTitleCaseMapping:0x02B9
 },
 { code:0x02BA
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02BA
  ,simpleLowerCaseMapping:0x02BA
  ,simpleTitleCaseMapping:0x02BA
 },
 { code:0x02BB
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02BB
  ,simpleLowerCaseMapping:0x02BB
  ,simpleTitleCaseMapping:0x02BB
 },
 { code:0x02BC
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02BC
  ,simpleLowerCaseMapping:0x02BC
  ,simpleTitleCaseMapping:0x02BC
 },
 { code:0x02BD
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02BD
  ,simpleLowerCaseMapping:0x02BD
  ,simpleTitleCaseMapping:0x02BD
 },
 { code:0x02BE
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02BE
  ,simpleLowerCaseMapping:0x02BE
  ,simpleTitleCaseMapping:0x02BE
 },
 { code:0x02BF
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02BF
  ,simpleLowerCaseMapping:0x02BF
  ,simpleTitleCaseMapping:0x02BF
 },
 { code:0x02C0
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02C0
  ,simpleLowerCaseMapping:0x02C0
  ,simpleTitleCaseMapping:0x02C0
 },
 { code:0x02C1
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02C1
  ,simpleLowerCaseMapping:0x02C1
  ,simpleTitleCaseMapping:0x02C1
 },
 { code:0x02C2
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02C2
  ,simpleLowerCaseMapping:0x02C2
  ,simpleTitleCaseMapping:0x02C2
 },
 { code:0x02C3
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02C3
  ,simpleLowerCaseMapping:0x02C3
  ,simpleTitleCaseMapping:0x02C3
 },
 { code:0x02C4
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02C4
  ,simpleLowerCaseMapping:0x02C4
  ,simpleTitleCaseMapping:0x02C4
 },
 { code:0x02C5
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02C5
  ,simpleLowerCaseMapping:0x02C5
  ,simpleTitleCaseMapping:0x02C5
 },
 { code:0x02C6
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02C6
  ,simpleLowerCaseMapping:0x02C6
  ,simpleTitleCaseMapping:0x02C6
 },
 { code:0x02C7
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02C7
  ,simpleLowerCaseMapping:0x02C7
  ,simpleTitleCaseMapping:0x02C7
 },
 { code:0x02C8
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02C8
  ,simpleLowerCaseMapping:0x02C8
  ,simpleTitleCaseMapping:0x02C8
 },
 { code:0x02C9
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02C9
  ,simpleLowerCaseMapping:0x02C9
  ,simpleTitleCaseMapping:0x02C9
 },
 { code:0x02CA
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02CA
  ,simpleLowerCaseMapping:0x02CA
  ,simpleTitleCaseMapping:0x02CA
 },
 { code:0x02CB
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02CB
  ,simpleLowerCaseMapping:0x02CB
  ,simpleTitleCaseMapping:0x02CB
 },
 { code:0x02CC
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02CC
  ,simpleLowerCaseMapping:0x02CC
  ,simpleTitleCaseMapping:0x02CC
 },
 { code:0x02CD
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02CD
  ,simpleLowerCaseMapping:0x02CD
  ,simpleTitleCaseMapping:0x02CD
 },
 { code:0x02CE
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02CE
  ,simpleLowerCaseMapping:0x02CE
  ,simpleTitleCaseMapping:0x02CE
 },
 { code:0x02CF
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02CF
  ,simpleLowerCaseMapping:0x02CF
  ,simpleTitleCaseMapping:0x02CF
 },
 { code:0x02D0
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02D0
  ,simpleLowerCaseMapping:0x02D0
  ,simpleTitleCaseMapping:0x02D0
 },
 { code:0x02D1
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02D1
  ,simpleLowerCaseMapping:0x02D1
  ,simpleTitleCaseMapping:0x02D1
 },
 { code:0x02D2
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02D2
  ,simpleLowerCaseMapping:0x02D2
  ,simpleTitleCaseMapping:0x02D2
 },
 { code:0x02D3
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02D3
  ,simpleLowerCaseMapping:0x02D3
  ,simpleTitleCaseMapping:0x02D3
 },
 { code:0x02D4
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02D4
  ,simpleLowerCaseMapping:0x02D4
  ,simpleTitleCaseMapping:0x02D4
 },
 { code:0x02D5
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02D5
  ,simpleLowerCaseMapping:0x02D5
  ,simpleTitleCaseMapping:0x02D5
 },
 { code:0x02D6
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02D6
  ,simpleLowerCaseMapping:0x02D6
  ,simpleTitleCaseMapping:0x02D6
 },
 { code:0x02D7
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02D7
  ,simpleLowerCaseMapping:0x02D7
  ,simpleTitleCaseMapping:0x02D7
 },
 { code:0x02D8
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02D8
  ,simpleLowerCaseMapping:0x02D8
  ,simpleTitleCaseMapping:0x02D8
 },
 { code:0x02D9
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02D9
  ,simpleLowerCaseMapping:0x02D9
  ,simpleTitleCaseMapping:0x02D9
 },
 { code:0x02DA
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02DA
  ,simpleLowerCaseMapping:0x02DA
  ,simpleTitleCaseMapping:0x02DA
 },
 { code:0x02DB
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02DB
  ,simpleLowerCaseMapping:0x02DB
  ,simpleTitleCaseMapping:0x02DB
 },
 { code:0x02DC
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02DC
  ,simpleLowerCaseMapping:0x02DC
  ,simpleTitleCaseMapping:0x02DC
 },
 { code:0x02DD
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02DD
  ,simpleLowerCaseMapping:0x02DD
  ,simpleTitleCaseMapping:0x02DD
 },
 { code:0x02DE
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02DE
  ,simpleLowerCaseMapping:0x02DE
  ,simpleTitleCaseMapping:0x02DE
 },
 { code:0x02DF
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02DF
  ,simpleLowerCaseMapping:0x02DF
  ,simpleTitleCaseMapping:0x02DF
 },
 { code:0x02E0
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02E0
  ,simpleLowerCaseMapping:0x02E0
  ,simpleTitleCaseMapping:0x02E0
 },
 { code:0x02E1
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02E1
  ,simpleLowerCaseMapping:0x02E1
  ,simpleTitleCaseMapping:0x02E1
 },
 { code:0x02E2
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02E2
  ,simpleLowerCaseMapping:0x02E2
  ,simpleTitleCaseMapping:0x02E2
 },
 { code:0x02E3
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02E3
  ,simpleLowerCaseMapping:0x02E3
  ,simpleTitleCaseMapping:0x02E3
 },
 { code:0x02E4
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02E4
  ,simpleLowerCaseMapping:0x02E4
  ,simpleTitleCaseMapping:0x02E4
 },
 { code:0x02E5
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02E5
  ,simpleLowerCaseMapping:0x02E5
  ,simpleTitleCaseMapping:0x02E5
 },
 { code:0x02E6
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02E6
  ,simpleLowerCaseMapping:0x02E6
  ,simpleTitleCaseMapping:0x02E6
 },
 { code:0x02E7
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02E7
  ,simpleLowerCaseMapping:0x02E7
  ,simpleTitleCaseMapping:0x02E7
 },
 { code:0x02E8
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02E8
  ,simpleLowerCaseMapping:0x02E8
  ,simpleTitleCaseMapping:0x02E8
 },
 { code:0x02E9
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02E9
  ,simpleLowerCaseMapping:0x02E9
  ,simpleTitleCaseMapping:0x02E9
 },
 { code:0x02EA
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02EA
  ,simpleLowerCaseMapping:0x02EA
  ,simpleTitleCaseMapping:0x02EA
 },
 { code:0x02EB
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02EB
  ,simpleLowerCaseMapping:0x02EB
  ,simpleTitleCaseMapping:0x02EB
 },
 { code:0x02EC
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02EC
  ,simpleLowerCaseMapping:0x02EC
  ,simpleTitleCaseMapping:0x02EC
 },
 { code:0x02ED
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02ED
  ,simpleLowerCaseMapping:0x02ED
  ,simpleTitleCaseMapping:0x02ED
 },
 { code:0x02EE
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x02EE
  ,simpleLowerCaseMapping:0x02EE
  ,simpleTitleCaseMapping:0x02EE
 },
 { code:0x02EF
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02EF
  ,simpleLowerCaseMapping:0x02EF
  ,simpleTitleCaseMapping:0x02EF
 },
 { code:0x02F0
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02F0
  ,simpleLowerCaseMapping:0x02F0
  ,simpleTitleCaseMapping:0x02F0
 },
 { code:0x02F1
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02F1
  ,simpleLowerCaseMapping:0x02F1
  ,simpleTitleCaseMapping:0x02F1
 },
 { code:0x02F2
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02F2
  ,simpleLowerCaseMapping:0x02F2
  ,simpleTitleCaseMapping:0x02F2
 },
 { code:0x02F3
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02F3
  ,simpleLowerCaseMapping:0x02F3
  ,simpleTitleCaseMapping:0x02F3
 },
 { code:0x02F4
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02F4
  ,simpleLowerCaseMapping:0x02F4
  ,simpleTitleCaseMapping:0x02F4
 },
 { code:0x02F5
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02F5
  ,simpleLowerCaseMapping:0x02F5
  ,simpleTitleCaseMapping:0x02F5
 },
 { code:0x02F6
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02F6
  ,simpleLowerCaseMapping:0x02F6
  ,simpleTitleCaseMapping:0x02F6
 },
 { code:0x02F7
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02F7
  ,simpleLowerCaseMapping:0x02F7
  ,simpleTitleCaseMapping:0x02F7
 },
 { code:0x02F8
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02F8
  ,simpleLowerCaseMapping:0x02F8
  ,simpleTitleCaseMapping:0x02F8
 },
 { code:0x02F9
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02F9
  ,simpleLowerCaseMapping:0x02F9
  ,simpleTitleCaseMapping:0x02F9
 },
 { code:0x02FA
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02FA
  ,simpleLowerCaseMapping:0x02FA
  ,simpleTitleCaseMapping:0x02FA
 },
 { code:0x02FB
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02FB
  ,simpleLowerCaseMapping:0x02FB
  ,simpleTitleCaseMapping:0x02FB
 },
 { code:0x02FC
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02FC
  ,simpleLowerCaseMapping:0x02FC
  ,simpleTitleCaseMapping:0x02FC
 },
 { code:0x02FD
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02FD
  ,simpleLowerCaseMapping:0x02FD
  ,simpleTitleCaseMapping:0x02FD
 },
 { code:0x02FE
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02FE
  ,simpleLowerCaseMapping:0x02FE
  ,simpleTitleCaseMapping:0x02FE
 },
 { code:0x02FF
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x02FF
  ,simpleLowerCaseMapping:0x02FF
  ,simpleTitleCaseMapping:0x02FF
 },
 { code:0x0300
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0300
  ,simpleLowerCaseMapping:0x0300
  ,simpleTitleCaseMapping:0x0300
 },
 { code:0x0301
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0301
  ,simpleLowerCaseMapping:0x0301
  ,simpleTitleCaseMapping:0x0301
 },
 { code:0x0302
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0302
  ,simpleLowerCaseMapping:0x0302
  ,simpleTitleCaseMapping:0x0302
 },
 { code:0x0303
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0303
  ,simpleLowerCaseMapping:0x0303
  ,simpleTitleCaseMapping:0x0303
 },
 { code:0x0304
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0304
  ,simpleLowerCaseMapping:0x0304
  ,simpleTitleCaseMapping:0x0304
 },
 { code:0x0305
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0305
  ,simpleLowerCaseMapping:0x0305
  ,simpleTitleCaseMapping:0x0305
 },
 { code:0x0306
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0306
  ,simpleLowerCaseMapping:0x0306
  ,simpleTitleCaseMapping:0x0306
 },
 { code:0x0307
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0307
  ,simpleLowerCaseMapping:0x0307
  ,simpleTitleCaseMapping:0x0307
 },
 { code:0x0308
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0308
  ,simpleLowerCaseMapping:0x0308
  ,simpleTitleCaseMapping:0x0308
 },
 { code:0x0309
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0309
  ,simpleLowerCaseMapping:0x0309
  ,simpleTitleCaseMapping:0x0309
 },
 { code:0x030A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x030A
  ,simpleLowerCaseMapping:0x030A
  ,simpleTitleCaseMapping:0x030A
 },
 { code:0x030B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x030B
  ,simpleLowerCaseMapping:0x030B
  ,simpleTitleCaseMapping:0x030B
 },
 { code:0x030C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x030C
  ,simpleLowerCaseMapping:0x030C
  ,simpleTitleCaseMapping:0x030C
 },
 { code:0x030D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x030D
  ,simpleLowerCaseMapping:0x030D
  ,simpleTitleCaseMapping:0x030D
 },
 { code:0x030E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x030E
  ,simpleLowerCaseMapping:0x030E
  ,simpleTitleCaseMapping:0x030E
 },
 { code:0x030F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x030F
  ,simpleLowerCaseMapping:0x030F
  ,simpleTitleCaseMapping:0x030F
 },
 { code:0x0310
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0310
  ,simpleLowerCaseMapping:0x0310
  ,simpleTitleCaseMapping:0x0310
 },
 { code:0x0311
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0311
  ,simpleLowerCaseMapping:0x0311
  ,simpleTitleCaseMapping:0x0311
 },
 { code:0x0312
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0312
  ,simpleLowerCaseMapping:0x0312
  ,simpleTitleCaseMapping:0x0312
 },
 { code:0x0313
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0313
  ,simpleLowerCaseMapping:0x0313
  ,simpleTitleCaseMapping:0x0313
 },
 { code:0x0314
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0314
  ,simpleLowerCaseMapping:0x0314
  ,simpleTitleCaseMapping:0x0314
 },
 { code:0x0315
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0315
  ,simpleLowerCaseMapping:0x0315
  ,simpleTitleCaseMapping:0x0315
 },
 { code:0x0316
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0316
  ,simpleLowerCaseMapping:0x0316
  ,simpleTitleCaseMapping:0x0316
 },
 { code:0x0317
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0317
  ,simpleLowerCaseMapping:0x0317
  ,simpleTitleCaseMapping:0x0317
 },
 { code:0x0318
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0318
  ,simpleLowerCaseMapping:0x0318
  ,simpleTitleCaseMapping:0x0318
 },
 { code:0x0319
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0319
  ,simpleLowerCaseMapping:0x0319
  ,simpleTitleCaseMapping:0x0319
 },
 { code:0x031A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x031A
  ,simpleLowerCaseMapping:0x031A
  ,simpleTitleCaseMapping:0x031A
 },
 { code:0x031B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x031B
  ,simpleLowerCaseMapping:0x031B
  ,simpleTitleCaseMapping:0x031B
 },
 { code:0x031C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x031C
  ,simpleLowerCaseMapping:0x031C
  ,simpleTitleCaseMapping:0x031C
 },
 { code:0x031D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x031D
  ,simpleLowerCaseMapping:0x031D
  ,simpleTitleCaseMapping:0x031D
 },
 { code:0x031E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x031E
  ,simpleLowerCaseMapping:0x031E
  ,simpleTitleCaseMapping:0x031E
 },
 { code:0x031F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x031F
  ,simpleLowerCaseMapping:0x031F
  ,simpleTitleCaseMapping:0x031F
 },
 { code:0x0320
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0320
  ,simpleLowerCaseMapping:0x0320
  ,simpleTitleCaseMapping:0x0320
 },
 { code:0x0321
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0321
  ,simpleLowerCaseMapping:0x0321
  ,simpleTitleCaseMapping:0x0321
 },
 { code:0x0322
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0322
  ,simpleLowerCaseMapping:0x0322
  ,simpleTitleCaseMapping:0x0322
 },
 { code:0x0323
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0323
  ,simpleLowerCaseMapping:0x0323
  ,simpleTitleCaseMapping:0x0323
 },
 { code:0x0324
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0324
  ,simpleLowerCaseMapping:0x0324
  ,simpleTitleCaseMapping:0x0324
 },
 { code:0x0325
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0325
  ,simpleLowerCaseMapping:0x0325
  ,simpleTitleCaseMapping:0x0325
 },
 { code:0x0326
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0326
  ,simpleLowerCaseMapping:0x0326
  ,simpleTitleCaseMapping:0x0326
 },
 { code:0x0327
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0327
  ,simpleLowerCaseMapping:0x0327
  ,simpleTitleCaseMapping:0x0327
 },
 { code:0x0328
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0328
  ,simpleLowerCaseMapping:0x0328
  ,simpleTitleCaseMapping:0x0328
 },
 { code:0x0329
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0329
  ,simpleLowerCaseMapping:0x0329
  ,simpleTitleCaseMapping:0x0329
 },
 { code:0x032A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x032A
  ,simpleLowerCaseMapping:0x032A
  ,simpleTitleCaseMapping:0x032A
 },
 { code:0x032B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x032B
  ,simpleLowerCaseMapping:0x032B
  ,simpleTitleCaseMapping:0x032B
 },
 { code:0x032C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x032C
  ,simpleLowerCaseMapping:0x032C
  ,simpleTitleCaseMapping:0x032C
 },
 { code:0x032D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x032D
  ,simpleLowerCaseMapping:0x032D
  ,simpleTitleCaseMapping:0x032D
 },
 { code:0x032E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x032E
  ,simpleLowerCaseMapping:0x032E
  ,simpleTitleCaseMapping:0x032E
 },
 { code:0x032F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x032F
  ,simpleLowerCaseMapping:0x032F
  ,simpleTitleCaseMapping:0x032F
 },
 { code:0x0330
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0330
  ,simpleLowerCaseMapping:0x0330
  ,simpleTitleCaseMapping:0x0330
 },
 { code:0x0331
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0331
  ,simpleLowerCaseMapping:0x0331
  ,simpleTitleCaseMapping:0x0331
 },
 { code:0x0332
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0332
  ,simpleLowerCaseMapping:0x0332
  ,simpleTitleCaseMapping:0x0332
 },
 { code:0x0333
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0333
  ,simpleLowerCaseMapping:0x0333
  ,simpleTitleCaseMapping:0x0333
 },
 { code:0x0334
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0334
  ,simpleLowerCaseMapping:0x0334
  ,simpleTitleCaseMapping:0x0334
 },
 { code:0x0335
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0335
  ,simpleLowerCaseMapping:0x0335
  ,simpleTitleCaseMapping:0x0335
 },
 { code:0x0336
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0336
  ,simpleLowerCaseMapping:0x0336
  ,simpleTitleCaseMapping:0x0336
 },
 { code:0x0337
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0337
  ,simpleLowerCaseMapping:0x0337
  ,simpleTitleCaseMapping:0x0337
 },
 { code:0x0338
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0338
  ,simpleLowerCaseMapping:0x0338
  ,simpleTitleCaseMapping:0x0338
 },
 { code:0x0339
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0339
  ,simpleLowerCaseMapping:0x0339
  ,simpleTitleCaseMapping:0x0339
 },
 { code:0x033A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x033A
  ,simpleLowerCaseMapping:0x033A
  ,simpleTitleCaseMapping:0x033A
 },
 { code:0x033B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x033B
  ,simpleLowerCaseMapping:0x033B
  ,simpleTitleCaseMapping:0x033B
 },
 { code:0x033C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x033C
  ,simpleLowerCaseMapping:0x033C
  ,simpleTitleCaseMapping:0x033C
 },
 { code:0x033D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x033D
  ,simpleLowerCaseMapping:0x033D
  ,simpleTitleCaseMapping:0x033D
 },
 { code:0x033E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x033E
  ,simpleLowerCaseMapping:0x033E
  ,simpleTitleCaseMapping:0x033E
 },
 { code:0x033F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x033F
  ,simpleLowerCaseMapping:0x033F
  ,simpleTitleCaseMapping:0x033F
 },
 { code:0x0340
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0340
  ,simpleLowerCaseMapping:0x0340
  ,simpleTitleCaseMapping:0x0340
 },
 { code:0x0341
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0341
  ,simpleLowerCaseMapping:0x0341
  ,simpleTitleCaseMapping:0x0341
 },
 { code:0x0342
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0342
  ,simpleLowerCaseMapping:0x0342
  ,simpleTitleCaseMapping:0x0342
 },
 { code:0x0343
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0343
  ,simpleLowerCaseMapping:0x0343
  ,simpleTitleCaseMapping:0x0343
 },
 { code:0x0344
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0344
  ,simpleLowerCaseMapping:0x0344
  ,simpleTitleCaseMapping:0x0344
 },
 { code:0x0345
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0399
  ,simpleLowerCaseMapping:0x0345
  ,simpleTitleCaseMapping:0x0399
 },
 { code:0x0346
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0346
  ,simpleLowerCaseMapping:0x0346
  ,simpleTitleCaseMapping:0x0346
 },
 { code:0x0347
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0347
  ,simpleLowerCaseMapping:0x0347
  ,simpleTitleCaseMapping:0x0347
 },
 { code:0x0348
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0348
  ,simpleLowerCaseMapping:0x0348
  ,simpleTitleCaseMapping:0x0348
 },
 { code:0x0349
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0349
  ,simpleLowerCaseMapping:0x0349
  ,simpleTitleCaseMapping:0x0349
 },
 { code:0x034A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x034A
  ,simpleLowerCaseMapping:0x034A
  ,simpleTitleCaseMapping:0x034A
 },
 { code:0x034B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x034B
  ,simpleLowerCaseMapping:0x034B
  ,simpleTitleCaseMapping:0x034B
 },
 { code:0x034C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x034C
  ,simpleLowerCaseMapping:0x034C
  ,simpleTitleCaseMapping:0x034C
 },
 { code:0x034D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x034D
  ,simpleLowerCaseMapping:0x034D
  ,simpleTitleCaseMapping:0x034D
 },
 { code:0x034E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x034E
  ,simpleLowerCaseMapping:0x034E
  ,simpleTitleCaseMapping:0x034E
 },
 { code:0x034F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x034F
  ,simpleLowerCaseMapping:0x034F
  ,simpleTitleCaseMapping:0x034F
 },
 { code:0x0350
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0350
  ,simpleLowerCaseMapping:0x0350
  ,simpleTitleCaseMapping:0x0350
 },
 { code:0x0351
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0351
  ,simpleLowerCaseMapping:0x0351
  ,simpleTitleCaseMapping:0x0351
 },
 { code:0x0352
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0352
  ,simpleLowerCaseMapping:0x0352
  ,simpleTitleCaseMapping:0x0352
 },
 { code:0x0353
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0353
  ,simpleLowerCaseMapping:0x0353
  ,simpleTitleCaseMapping:0x0353
 },
 { code:0x0354
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0354
  ,simpleLowerCaseMapping:0x0354
  ,simpleTitleCaseMapping:0x0354
 },
 { code:0x0355
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0355
  ,simpleLowerCaseMapping:0x0355
  ,simpleTitleCaseMapping:0x0355
 },
 { code:0x0356
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0356
  ,simpleLowerCaseMapping:0x0356
  ,simpleTitleCaseMapping:0x0356
 },
 { code:0x0357
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0357
  ,simpleLowerCaseMapping:0x0357
  ,simpleTitleCaseMapping:0x0357
 },
 { code:0x0358
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0358
  ,simpleLowerCaseMapping:0x0358
  ,simpleTitleCaseMapping:0x0358
 },
 { code:0x0359
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0359
  ,simpleLowerCaseMapping:0x0359
  ,simpleTitleCaseMapping:0x0359
 },
 { code:0x035A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x035A
  ,simpleLowerCaseMapping:0x035A
  ,simpleTitleCaseMapping:0x035A
 },
 { code:0x035B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x035B
  ,simpleLowerCaseMapping:0x035B
  ,simpleTitleCaseMapping:0x035B
 },
 { code:0x035C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x035C
  ,simpleLowerCaseMapping:0x035C
  ,simpleTitleCaseMapping:0x035C
 },
 { code:0x035D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x035D
  ,simpleLowerCaseMapping:0x035D
  ,simpleTitleCaseMapping:0x035D
 },
 { code:0x035E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x035E
  ,simpleLowerCaseMapping:0x035E
  ,simpleTitleCaseMapping:0x035E
 },
 { code:0x035F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x035F
  ,simpleLowerCaseMapping:0x035F
  ,simpleTitleCaseMapping:0x035F
 },
 { code:0x0360
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0360
  ,simpleLowerCaseMapping:0x0360
  ,simpleTitleCaseMapping:0x0360
 },
 { code:0x0361
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0361
  ,simpleLowerCaseMapping:0x0361
  ,simpleTitleCaseMapping:0x0361
 },
 { code:0x0362
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0362
  ,simpleLowerCaseMapping:0x0362
  ,simpleTitleCaseMapping:0x0362
 },
 { code:0x0363
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0363
  ,simpleLowerCaseMapping:0x0363
  ,simpleTitleCaseMapping:0x0363
 },
 { code:0x0364
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0364
  ,simpleLowerCaseMapping:0x0364
  ,simpleTitleCaseMapping:0x0364
 },
 { code:0x0365
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0365
  ,simpleLowerCaseMapping:0x0365
  ,simpleTitleCaseMapping:0x0365
 },
 { code:0x0366
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0366
  ,simpleLowerCaseMapping:0x0366
  ,simpleTitleCaseMapping:0x0366
 },
 { code:0x0367
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0367
  ,simpleLowerCaseMapping:0x0367
  ,simpleTitleCaseMapping:0x0367
 },
 { code:0x0368
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0368
  ,simpleLowerCaseMapping:0x0368
  ,simpleTitleCaseMapping:0x0368
 },
 { code:0x0369
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0369
  ,simpleLowerCaseMapping:0x0369
  ,simpleTitleCaseMapping:0x0369
 },
 { code:0x036A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x036A
  ,simpleLowerCaseMapping:0x036A
  ,simpleTitleCaseMapping:0x036A
 },
 { code:0x036B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x036B
  ,simpleLowerCaseMapping:0x036B
  ,simpleTitleCaseMapping:0x036B
 },
 { code:0x036C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x036C
  ,simpleLowerCaseMapping:0x036C
  ,simpleTitleCaseMapping:0x036C
 },
 { code:0x036D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x036D
  ,simpleLowerCaseMapping:0x036D
  ,simpleTitleCaseMapping:0x036D
 },
 { code:0x036E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x036E
  ,simpleLowerCaseMapping:0x036E
  ,simpleTitleCaseMapping:0x036E
 },
 { code:0x036F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x036F
  ,simpleLowerCaseMapping:0x036F
  ,simpleTitleCaseMapping:0x036F
 },
 { code:0x0374
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x0374
  ,simpleLowerCaseMapping:0x0374
  ,simpleTitleCaseMapping:0x0374
 },
 { code:0x0375
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x0375
  ,simpleLowerCaseMapping:0x0375
  ,simpleTitleCaseMapping:0x0375
 },
 { code:0x037A
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x037A
  ,simpleLowerCaseMapping:0x037A
  ,simpleTitleCaseMapping:0x037A
 },
 { code:0x037B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03FD
  ,simpleLowerCaseMapping:0x037B
  ,simpleTitleCaseMapping:0x03FD
 },
 { code:0x037C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03FE
  ,simpleLowerCaseMapping:0x037C
  ,simpleTitleCaseMapping:0x03FE
 },
 { code:0x037D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03FF
  ,simpleLowerCaseMapping:0x037D
  ,simpleTitleCaseMapping:0x03FF
 },
 { code:0x037E
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x037E
  ,simpleLowerCaseMapping:0x037E
  ,simpleTitleCaseMapping:0x037E
 },
 { code:0x0384
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x0384
  ,simpleLowerCaseMapping:0x0384
  ,simpleTitleCaseMapping:0x0384
 },
 { code:0x0385
  ,generalCategory:UnicodeData.GeneralCategory.Sk
  ,simpleUpperCaseMapping:0x0385
  ,simpleLowerCaseMapping:0x0385
  ,simpleTitleCaseMapping:0x0385
 },
 { code:0x0386
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0386
  ,simpleLowerCaseMapping:0x03AC
  ,simpleTitleCaseMapping:0x0386
 },
 { code:0x0387
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0387
  ,simpleLowerCaseMapping:0x0387
  ,simpleTitleCaseMapping:0x0387
 },
 { code:0x0388
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0388
  ,simpleLowerCaseMapping:0x03AD
  ,simpleTitleCaseMapping:0x0388
 },
 { code:0x0389
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0389
  ,simpleLowerCaseMapping:0x03AE
  ,simpleTitleCaseMapping:0x0389
 },
 { code:0x038A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x038A
  ,simpleLowerCaseMapping:0x03AF
  ,simpleTitleCaseMapping:0x038A
 },
 { code:0x038C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x038C
  ,simpleLowerCaseMapping:0x03CC
  ,simpleTitleCaseMapping:0x038C
 },
 { code:0x038E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x038E
  ,simpleLowerCaseMapping:0x03CD
  ,simpleTitleCaseMapping:0x038E
 },
 { code:0x038F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x038F
  ,simpleLowerCaseMapping:0x03CE
  ,simpleTitleCaseMapping:0x038F
 },
 { code:0x0390
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x0390
  ,simpleLowerCaseMapping:0x0390
  ,simpleTitleCaseMapping:0x0390
 },
 { code:0x0391
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0391
  ,simpleLowerCaseMapping:0x03B1
  ,simpleTitleCaseMapping:0x0391
 },
 { code:0x0392
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0392
  ,simpleLowerCaseMapping:0x03B2
  ,simpleTitleCaseMapping:0x0392
 },
 { code:0x0393
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0393
  ,simpleLowerCaseMapping:0x03B3
  ,simpleTitleCaseMapping:0x0393
 },
 { code:0x0394
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0394
  ,simpleLowerCaseMapping:0x03B4
  ,simpleTitleCaseMapping:0x0394
 },
 { code:0x0395
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0395
  ,simpleLowerCaseMapping:0x03B5
  ,simpleTitleCaseMapping:0x0395
 },
 { code:0x0396
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0396
  ,simpleLowerCaseMapping:0x03B6
  ,simpleTitleCaseMapping:0x0396
 },
 { code:0x0397
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0397
  ,simpleLowerCaseMapping:0x03B7
  ,simpleTitleCaseMapping:0x0397
 },
 { code:0x0398
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0398
  ,simpleLowerCaseMapping:0x03B8
  ,simpleTitleCaseMapping:0x0398
 },
 { code:0x0399
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0399
  ,simpleLowerCaseMapping:0x03B9
  ,simpleTitleCaseMapping:0x0399
 },
 { code:0x039A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x039A
  ,simpleLowerCaseMapping:0x03BA
  ,simpleTitleCaseMapping:0x039A
 },
 { code:0x039B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x039B
  ,simpleLowerCaseMapping:0x03BB
  ,simpleTitleCaseMapping:0x039B
 },
 { code:0x039C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x039C
  ,simpleLowerCaseMapping:0x03BC
  ,simpleTitleCaseMapping:0x039C
 },
 { code:0x039D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x039D
  ,simpleLowerCaseMapping:0x03BD
  ,simpleTitleCaseMapping:0x039D
 },
 { code:0x039E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x039E
  ,simpleLowerCaseMapping:0x03BE
  ,simpleTitleCaseMapping:0x039E
 },
 { code:0x039F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x039F
  ,simpleLowerCaseMapping:0x03BF
  ,simpleTitleCaseMapping:0x039F
 },
 { code:0x03A0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03A0
  ,simpleLowerCaseMapping:0x03C0
  ,simpleTitleCaseMapping:0x03A0
 },
 { code:0x03A1
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03A1
  ,simpleLowerCaseMapping:0x03C1
  ,simpleTitleCaseMapping:0x03A1
 },
 { code:0x03A3
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03A3
  ,simpleLowerCaseMapping:0x03C3
  ,simpleTitleCaseMapping:0x03A3
 },
 { code:0x03A4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03A4
  ,simpleLowerCaseMapping:0x03C4
  ,simpleTitleCaseMapping:0x03A4
 },
 { code:0x03A5
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03A5
  ,simpleLowerCaseMapping:0x03C5
  ,simpleTitleCaseMapping:0x03A5
 },
 { code:0x03A6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03A6
  ,simpleLowerCaseMapping:0x03C6
  ,simpleTitleCaseMapping:0x03A6
 },
 { code:0x03A7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03A7
  ,simpleLowerCaseMapping:0x03C7
  ,simpleTitleCaseMapping:0x03A7
 },
 { code:0x03A8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03A8
  ,simpleLowerCaseMapping:0x03C8
  ,simpleTitleCaseMapping:0x03A8
 },
 { code:0x03A9
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03A9
  ,simpleLowerCaseMapping:0x03C9
  ,simpleTitleCaseMapping:0x03A9
 },
 { code:0x03AA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03AA
  ,simpleLowerCaseMapping:0x03CA
  ,simpleTitleCaseMapping:0x03AA
 },
 { code:0x03AB
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03AB
  ,simpleLowerCaseMapping:0x03CB
  ,simpleTitleCaseMapping:0x03AB
 },
 { code:0x03AC
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0386
  ,simpleLowerCaseMapping:0x03AC
  ,simpleTitleCaseMapping:0x0386
 },
 { code:0x03AD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0388
  ,simpleLowerCaseMapping:0x03AD
  ,simpleTitleCaseMapping:0x0388
 },
 { code:0x03AE
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0389
  ,simpleLowerCaseMapping:0x03AE
  ,simpleTitleCaseMapping:0x0389
 },
 { code:0x03AF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x038A
  ,simpleLowerCaseMapping:0x03AF
  ,simpleTitleCaseMapping:0x038A
 },
 { code:0x03B0
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x03B0
  ,simpleLowerCaseMapping:0x03B0
  ,simpleTitleCaseMapping:0x03B0
 },
 { code:0x03B1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0391
  ,simpleLowerCaseMapping:0x03B1
  ,simpleTitleCaseMapping:0x0391
 },
 { code:0x03B2
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0392
  ,simpleLowerCaseMapping:0x03B2
  ,simpleTitleCaseMapping:0x0392
 },
 { code:0x03B3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0393
  ,simpleLowerCaseMapping:0x03B3
  ,simpleTitleCaseMapping:0x0393
 },
 { code:0x03B4
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0394
  ,simpleLowerCaseMapping:0x03B4
  ,simpleTitleCaseMapping:0x0394
 },
 { code:0x03B5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0395
  ,simpleLowerCaseMapping:0x03B5
  ,simpleTitleCaseMapping:0x0395
 },
 { code:0x03B6
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0396
  ,simpleLowerCaseMapping:0x03B6
  ,simpleTitleCaseMapping:0x0396
 },
 { code:0x03B7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0397
  ,simpleLowerCaseMapping:0x03B7
  ,simpleTitleCaseMapping:0x0397
 },
 { code:0x03B8
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0398
  ,simpleLowerCaseMapping:0x03B8
  ,simpleTitleCaseMapping:0x0398
 },
 { code:0x03B9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0399
  ,simpleLowerCaseMapping:0x03B9
  ,simpleTitleCaseMapping:0x0399
 },
 { code:0x03BA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x039A
  ,simpleLowerCaseMapping:0x03BA
  ,simpleTitleCaseMapping:0x039A
 },
 { code:0x03BB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x039B
  ,simpleLowerCaseMapping:0x03BB
  ,simpleTitleCaseMapping:0x039B
 },
 { code:0x03BC
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x039C
  ,simpleLowerCaseMapping:0x03BC
  ,simpleTitleCaseMapping:0x039C
 },
 { code:0x03BD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x039D
  ,simpleLowerCaseMapping:0x03BD
  ,simpleTitleCaseMapping:0x039D
 },
 { code:0x03BE
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x039E
  ,simpleLowerCaseMapping:0x03BE
  ,simpleTitleCaseMapping:0x039E
 },
 { code:0x03BF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x039F
  ,simpleLowerCaseMapping:0x03BF
  ,simpleTitleCaseMapping:0x039F
 },
 { code:0x03C0
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A0
  ,simpleLowerCaseMapping:0x03C0
  ,simpleTitleCaseMapping:0x03A0
 },
 { code:0x03C1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A1
  ,simpleLowerCaseMapping:0x03C1
  ,simpleTitleCaseMapping:0x03A1
 },
 { code:0x03C2
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A3
  ,simpleLowerCaseMapping:0x03C2
  ,simpleTitleCaseMapping:0x03A3
 },
 { code:0x03C3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A3
  ,simpleLowerCaseMapping:0x03C3
  ,simpleTitleCaseMapping:0x03A3
 },
 { code:0x03C4
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A4
  ,simpleLowerCaseMapping:0x03C4
  ,simpleTitleCaseMapping:0x03A4
 },
 { code:0x03C5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A5
  ,simpleLowerCaseMapping:0x03C5
  ,simpleTitleCaseMapping:0x03A5
 },
 { code:0x03C6
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A6
  ,simpleLowerCaseMapping:0x03C6
  ,simpleTitleCaseMapping:0x03A6
 },
 { code:0x03C7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A7
  ,simpleLowerCaseMapping:0x03C7
  ,simpleTitleCaseMapping:0x03A7
 },
 { code:0x03C8
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A8
  ,simpleLowerCaseMapping:0x03C8
  ,simpleTitleCaseMapping:0x03A8
 },
 { code:0x03C9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A9
  ,simpleLowerCaseMapping:0x03C9
  ,simpleTitleCaseMapping:0x03A9
 },
 { code:0x03CA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03AA
  ,simpleLowerCaseMapping:0x03CA
  ,simpleTitleCaseMapping:0x03AA
 },
 { code:0x03CB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03AB
  ,simpleLowerCaseMapping:0x03CB
  ,simpleTitleCaseMapping:0x03AB
 },
 { code:0x03CC
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x038C
  ,simpleLowerCaseMapping:0x03CC
  ,simpleTitleCaseMapping:0x038C
 },
 { code:0x03CD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x038E
  ,simpleLowerCaseMapping:0x03CD
  ,simpleTitleCaseMapping:0x038E
 },
 { code:0x03CE
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x038F
  ,simpleLowerCaseMapping:0x03CE
  ,simpleTitleCaseMapping:0x038F
 },
 { code:0x03D0
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0392
  ,simpleLowerCaseMapping:0x03D0
  ,simpleTitleCaseMapping:0x0392
 },
 { code:0x03D1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0398
  ,simpleLowerCaseMapping:0x03D1
  ,simpleTitleCaseMapping:0x0398
 },
 { code:0x03D2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03D2
  ,simpleLowerCaseMapping:0x03D2
  ,simpleTitleCaseMapping:0x03D2
 },
 { code:0x03D3
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03D3
  ,simpleLowerCaseMapping:0x03D3
  ,simpleTitleCaseMapping:0x03D3
 },
 { code:0x03D4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03D4
  ,simpleLowerCaseMapping:0x03D4
  ,simpleTitleCaseMapping:0x03D4
 },
 { code:0x03D5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A6
  ,simpleLowerCaseMapping:0x03D5
  ,simpleTitleCaseMapping:0x03A6
 },
 { code:0x03D6
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A0
  ,simpleLowerCaseMapping:0x03D6
  ,simpleTitleCaseMapping:0x03A0
 },
 { code:0x03D7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03D7
  ,simpleLowerCaseMapping:0x03D7
  ,simpleTitleCaseMapping:0x03D7
 },
 { code:0x03D8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03D8
  ,simpleLowerCaseMapping:0x03D9
  ,simpleTitleCaseMapping:0x03D8
 },
 { code:0x03D9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03D8
  ,simpleLowerCaseMapping:0x03D9
  ,simpleTitleCaseMapping:0x03D8
 },
 { code:0x03DA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03DA
  ,simpleLowerCaseMapping:0x03DB
  ,simpleTitleCaseMapping:0x03DA
 },
 { code:0x03DB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03DA
  ,simpleLowerCaseMapping:0x03DB
  ,simpleTitleCaseMapping:0x03DA
 },
 { code:0x03DC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03DC
  ,simpleLowerCaseMapping:0x03DD
  ,simpleTitleCaseMapping:0x03DC
 },
 { code:0x03DD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03DC
  ,simpleLowerCaseMapping:0x03DD
  ,simpleTitleCaseMapping:0x03DC
 },
 { code:0x03DE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03DE
  ,simpleLowerCaseMapping:0x03DF
  ,simpleTitleCaseMapping:0x03DE
 },
 { code:0x03DF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03DE
  ,simpleLowerCaseMapping:0x03DF
  ,simpleTitleCaseMapping:0x03DE
 },
 { code:0x03E0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03E0
  ,simpleLowerCaseMapping:0x03E1
  ,simpleTitleCaseMapping:0x03E0
 },
 { code:0x03E1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03E0
  ,simpleLowerCaseMapping:0x03E1
  ,simpleTitleCaseMapping:0x03E0
 },
 { code:0x03E2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03E2
  ,simpleLowerCaseMapping:0x03E3
  ,simpleTitleCaseMapping:0x03E2
 },
 { code:0x03E3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03E2
  ,simpleLowerCaseMapping:0x03E3
  ,simpleTitleCaseMapping:0x03E2
 },
 { code:0x03E4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03E4
  ,simpleLowerCaseMapping:0x03E5
  ,simpleTitleCaseMapping:0x03E4
 },
 { code:0x03E5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03E4
  ,simpleLowerCaseMapping:0x03E5
  ,simpleTitleCaseMapping:0x03E4
 },
 { code:0x03E6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03E6
  ,simpleLowerCaseMapping:0x03E7
  ,simpleTitleCaseMapping:0x03E6
 },
 { code:0x03E7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03E6
  ,simpleLowerCaseMapping:0x03E7
  ,simpleTitleCaseMapping:0x03E6
 },
 { code:0x03E8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03E8
  ,simpleLowerCaseMapping:0x03E9
  ,simpleTitleCaseMapping:0x03E8
 },
 { code:0x03E9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03E8
  ,simpleLowerCaseMapping:0x03E9
  ,simpleTitleCaseMapping:0x03E8
 },
 { code:0x03EA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03EA
  ,simpleLowerCaseMapping:0x03EB
  ,simpleTitleCaseMapping:0x03EA
 },
 { code:0x03EB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03EA
  ,simpleLowerCaseMapping:0x03EB
  ,simpleTitleCaseMapping:0x03EA
 },
 { code:0x03EC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03EC
  ,simpleLowerCaseMapping:0x03ED
  ,simpleTitleCaseMapping:0x03EC
 },
 { code:0x03ED
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03EC
  ,simpleLowerCaseMapping:0x03ED
  ,simpleTitleCaseMapping:0x03EC
 },
 { code:0x03EE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03EE
  ,simpleLowerCaseMapping:0x03EF
  ,simpleTitleCaseMapping:0x03EE
 },
 { code:0x03EF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03EE
  ,simpleLowerCaseMapping:0x03EF
  ,simpleTitleCaseMapping:0x03EE
 },
 { code:0x03F0
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x039A
  ,simpleLowerCaseMapping:0x03F0
  ,simpleTitleCaseMapping:0x039A
 },
 { code:0x03F1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03A1
  ,simpleLowerCaseMapping:0x03F1
  ,simpleTitleCaseMapping:0x03A1
 },
 { code:0x03F2
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03F9
  ,simpleLowerCaseMapping:0x03F2
  ,simpleTitleCaseMapping:0x03F9
 },
 { code:0x03F3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03F3
  ,simpleLowerCaseMapping:0x03F3
  ,simpleTitleCaseMapping:0x03F3
 },
 { code:0x03F4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03F4
  ,simpleLowerCaseMapping:0x03B8
  ,simpleTitleCaseMapping:0x03F4
 },
 { code:0x03F5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0395
  ,simpleLowerCaseMapping:0x03F5
  ,simpleTitleCaseMapping:0x0395
 },
 { code:0x03F6
  ,generalCategory:UnicodeData.GeneralCategory.Sm
  ,simpleUpperCaseMapping:0x03F6
  ,simpleLowerCaseMapping:0x03F6
  ,simpleTitleCaseMapping:0x03F6
 },
 { code:0x03F7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03F7
  ,simpleLowerCaseMapping:0x03F8
  ,simpleTitleCaseMapping:0x03F7
 },
 { code:0x03F8
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03F7
  ,simpleLowerCaseMapping:0x03F8
  ,simpleTitleCaseMapping:0x03F7
 },
 { code:0x03F9
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03F9
  ,simpleLowerCaseMapping:0x03F2
  ,simpleTitleCaseMapping:0x03F9
 },
 { code:0x03FA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03FA
  ,simpleLowerCaseMapping:0x03FB
  ,simpleTitleCaseMapping:0x03FA
 },
 { code:0x03FB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03FA
  ,simpleLowerCaseMapping:0x03FB
  ,simpleTitleCaseMapping:0x03FA
 },
 { code:0x03FC
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x03FC
  ,simpleLowerCaseMapping:0x03FC
  ,simpleTitleCaseMapping:0x03FC
 },
 { code:0x03FD
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03FD
  ,simpleLowerCaseMapping:0x037B
  ,simpleTitleCaseMapping:0x03FD
 },
 { code:0x03FE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03FE
  ,simpleLowerCaseMapping:0x037C
  ,simpleTitleCaseMapping:0x03FE
 },
 { code:0x03FF
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x03FF
  ,simpleLowerCaseMapping:0x037D
  ,simpleTitleCaseMapping:0x03FF
 },
 { code:0x0400
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0400
  ,simpleLowerCaseMapping:0x0450
  ,simpleTitleCaseMapping:0x0400
 },
 { code:0x0401
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0401
  ,simpleLowerCaseMapping:0x0451
  ,simpleTitleCaseMapping:0x0401
 },
 { code:0x0402
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0402
  ,simpleLowerCaseMapping:0x0452
  ,simpleTitleCaseMapping:0x0402
 },
 { code:0x0403
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0403
  ,simpleLowerCaseMapping:0x0453
  ,simpleTitleCaseMapping:0x0403
 },
 { code:0x0404
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0404
  ,simpleLowerCaseMapping:0x0454
  ,simpleTitleCaseMapping:0x0404
 },
 { code:0x0405
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0405
  ,simpleLowerCaseMapping:0x0455
  ,simpleTitleCaseMapping:0x0405
 },
 { code:0x0406
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0406
  ,simpleLowerCaseMapping:0x0456
  ,simpleTitleCaseMapping:0x0406
 },
 { code:0x0407
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0407
  ,simpleLowerCaseMapping:0x0457
  ,simpleTitleCaseMapping:0x0407
 },
 { code:0x0408
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0408
  ,simpleLowerCaseMapping:0x0458
  ,simpleTitleCaseMapping:0x0408
 },
 { code:0x0409
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0409
  ,simpleLowerCaseMapping:0x0459
  ,simpleTitleCaseMapping:0x0409
 },
 { code:0x040A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x040A
  ,simpleLowerCaseMapping:0x045A
  ,simpleTitleCaseMapping:0x040A
 },
 { code:0x040B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x040B
  ,simpleLowerCaseMapping:0x045B
  ,simpleTitleCaseMapping:0x040B
 },
 { code:0x040C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x040C
  ,simpleLowerCaseMapping:0x045C
  ,simpleTitleCaseMapping:0x040C
 },
 { code:0x040D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x040D
  ,simpleLowerCaseMapping:0x045D
  ,simpleTitleCaseMapping:0x040D
 },
 { code:0x040E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x040E
  ,simpleLowerCaseMapping:0x045E
  ,simpleTitleCaseMapping:0x040E
 },
 { code:0x040F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x040F
  ,simpleLowerCaseMapping:0x045F
  ,simpleTitleCaseMapping:0x040F
 },
 { code:0x0410
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0410
  ,simpleLowerCaseMapping:0x0430
  ,simpleTitleCaseMapping:0x0410
 },
 { code:0x0411
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0411
  ,simpleLowerCaseMapping:0x0431
  ,simpleTitleCaseMapping:0x0411
 },
 { code:0x0412
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0412
  ,simpleLowerCaseMapping:0x0432
  ,simpleTitleCaseMapping:0x0412
 },
 { code:0x0413
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0413
  ,simpleLowerCaseMapping:0x0433
  ,simpleTitleCaseMapping:0x0413
 },
 { code:0x0414
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0414
  ,simpleLowerCaseMapping:0x0434
  ,simpleTitleCaseMapping:0x0414
 },
 { code:0x0415
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0415
  ,simpleLowerCaseMapping:0x0435
  ,simpleTitleCaseMapping:0x0415
 },
 { code:0x0416
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0416
  ,simpleLowerCaseMapping:0x0436
  ,simpleTitleCaseMapping:0x0416
 },
 { code:0x0417
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0417
  ,simpleLowerCaseMapping:0x0437
  ,simpleTitleCaseMapping:0x0417
 },
 { code:0x0418
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0418
  ,simpleLowerCaseMapping:0x0438
  ,simpleTitleCaseMapping:0x0418
 },
 { code:0x0419
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0419
  ,simpleLowerCaseMapping:0x0439
  ,simpleTitleCaseMapping:0x0419
 },
 { code:0x041A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x041A
  ,simpleLowerCaseMapping:0x043A
  ,simpleTitleCaseMapping:0x041A
 },
 { code:0x041B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x041B
  ,simpleLowerCaseMapping:0x043B
  ,simpleTitleCaseMapping:0x041B
 },
 { code:0x041C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x041C
  ,simpleLowerCaseMapping:0x043C
  ,simpleTitleCaseMapping:0x041C
 },
 { code:0x041D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x041D
  ,simpleLowerCaseMapping:0x043D
  ,simpleTitleCaseMapping:0x041D
 },
 { code:0x041E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x041E
  ,simpleLowerCaseMapping:0x043E
  ,simpleTitleCaseMapping:0x041E
 },
 { code:0x041F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x041F
  ,simpleLowerCaseMapping:0x043F
  ,simpleTitleCaseMapping:0x041F
 },
 { code:0x0420
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0420
  ,simpleLowerCaseMapping:0x0440
  ,simpleTitleCaseMapping:0x0420
 },
 { code:0x0421
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0421
  ,simpleLowerCaseMapping:0x0441
  ,simpleTitleCaseMapping:0x0421
 },
 { code:0x0422
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0422
  ,simpleLowerCaseMapping:0x0442
  ,simpleTitleCaseMapping:0x0422
 },
 { code:0x0423
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0423
  ,simpleLowerCaseMapping:0x0443
  ,simpleTitleCaseMapping:0x0423
 },
 { code:0x0424
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0424
  ,simpleLowerCaseMapping:0x0444
  ,simpleTitleCaseMapping:0x0424
 },
 { code:0x0425
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0425
  ,simpleLowerCaseMapping:0x0445
  ,simpleTitleCaseMapping:0x0425
 },
 { code:0x0426
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0426
  ,simpleLowerCaseMapping:0x0446
  ,simpleTitleCaseMapping:0x0426
 },
 { code:0x0427
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0427
  ,simpleLowerCaseMapping:0x0447
  ,simpleTitleCaseMapping:0x0427
 },
 { code:0x0428
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0428
  ,simpleLowerCaseMapping:0x0448
  ,simpleTitleCaseMapping:0x0428
 },
 { code:0x0429
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0429
  ,simpleLowerCaseMapping:0x0449
  ,simpleTitleCaseMapping:0x0429
 },
 { code:0x042A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x042A
  ,simpleLowerCaseMapping:0x044A
  ,simpleTitleCaseMapping:0x042A
 },
 { code:0x042B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x042B
  ,simpleLowerCaseMapping:0x044B
  ,simpleTitleCaseMapping:0x042B
 },
 { code:0x042C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x042C
  ,simpleLowerCaseMapping:0x044C
  ,simpleTitleCaseMapping:0x042C
 },
 { code:0x042D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x042D
  ,simpleLowerCaseMapping:0x044D
  ,simpleTitleCaseMapping:0x042D
 },
 { code:0x042E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x042E
  ,simpleLowerCaseMapping:0x044E
  ,simpleTitleCaseMapping:0x042E
 },
 { code:0x042F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x042F
  ,simpleLowerCaseMapping:0x044F
  ,simpleTitleCaseMapping:0x042F
 },
 { code:0x0430
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0410
  ,simpleLowerCaseMapping:0x0430
  ,simpleTitleCaseMapping:0x0410
 },
 { code:0x0431
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0411
  ,simpleLowerCaseMapping:0x0431
  ,simpleTitleCaseMapping:0x0411
 },
 { code:0x0432
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0412
  ,simpleLowerCaseMapping:0x0432
  ,simpleTitleCaseMapping:0x0412
 },
 { code:0x0433
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0413
  ,simpleLowerCaseMapping:0x0433
  ,simpleTitleCaseMapping:0x0413
 },
 { code:0x0434
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0414
  ,simpleLowerCaseMapping:0x0434
  ,simpleTitleCaseMapping:0x0414
 },
 { code:0x0435
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0415
  ,simpleLowerCaseMapping:0x0435
  ,simpleTitleCaseMapping:0x0415
 },
 { code:0x0436
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0416
  ,simpleLowerCaseMapping:0x0436
  ,simpleTitleCaseMapping:0x0416
 },
 { code:0x0437
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0417
  ,simpleLowerCaseMapping:0x0437
  ,simpleTitleCaseMapping:0x0417
 },
 { code:0x0438
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0418
  ,simpleLowerCaseMapping:0x0438
  ,simpleTitleCaseMapping:0x0418
 },
 { code:0x0439
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0419
  ,simpleLowerCaseMapping:0x0439
  ,simpleTitleCaseMapping:0x0419
 },
 { code:0x043A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x041A
  ,simpleLowerCaseMapping:0x043A
  ,simpleTitleCaseMapping:0x041A
 },
 { code:0x043B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x041B
  ,simpleLowerCaseMapping:0x043B
  ,simpleTitleCaseMapping:0x041B
 },
 { code:0x043C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x041C
  ,simpleLowerCaseMapping:0x043C
  ,simpleTitleCaseMapping:0x041C
 },
 { code:0x043D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x041D
  ,simpleLowerCaseMapping:0x043D
  ,simpleTitleCaseMapping:0x041D
 },
 { code:0x043E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x041E
  ,simpleLowerCaseMapping:0x043E
  ,simpleTitleCaseMapping:0x041E
 },
 { code:0x043F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x041F
  ,simpleLowerCaseMapping:0x043F
  ,simpleTitleCaseMapping:0x041F
 },
 { code:0x0440
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0420
  ,simpleLowerCaseMapping:0x0440
  ,simpleTitleCaseMapping:0x0420
 },
 { code:0x0441
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0421
  ,simpleLowerCaseMapping:0x0441
  ,simpleTitleCaseMapping:0x0421
 },
 { code:0x0442
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0422
  ,simpleLowerCaseMapping:0x0442
  ,simpleTitleCaseMapping:0x0422
 },
 { code:0x0443
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0423
  ,simpleLowerCaseMapping:0x0443
  ,simpleTitleCaseMapping:0x0423
 },
 { code:0x0444
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0424
  ,simpleLowerCaseMapping:0x0444
  ,simpleTitleCaseMapping:0x0424
 },
 { code:0x0445
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0425
  ,simpleLowerCaseMapping:0x0445
  ,simpleTitleCaseMapping:0x0425
 },
 { code:0x0446
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0426
  ,simpleLowerCaseMapping:0x0446
  ,simpleTitleCaseMapping:0x0426
 },
 { code:0x0447
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0427
  ,simpleLowerCaseMapping:0x0447
  ,simpleTitleCaseMapping:0x0427
 },
 { code:0x0448
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0428
  ,simpleLowerCaseMapping:0x0448
  ,simpleTitleCaseMapping:0x0428
 },
 { code:0x0449
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0429
  ,simpleLowerCaseMapping:0x0449
  ,simpleTitleCaseMapping:0x0429
 },
 { code:0x044A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x042A
  ,simpleLowerCaseMapping:0x044A
  ,simpleTitleCaseMapping:0x042A
 },
 { code:0x044B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x042B
  ,simpleLowerCaseMapping:0x044B
  ,simpleTitleCaseMapping:0x042B
 },
 { code:0x044C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x042C
  ,simpleLowerCaseMapping:0x044C
  ,simpleTitleCaseMapping:0x042C
 },
 { code:0x044D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x042D
  ,simpleLowerCaseMapping:0x044D
  ,simpleTitleCaseMapping:0x042D
 },
 { code:0x044E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x042E
  ,simpleLowerCaseMapping:0x044E
  ,simpleTitleCaseMapping:0x042E
 },
 { code:0x044F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x042F
  ,simpleLowerCaseMapping:0x044F
  ,simpleTitleCaseMapping:0x042F
 },
 { code:0x0450
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0400
  ,simpleLowerCaseMapping:0x0450
  ,simpleTitleCaseMapping:0x0400
 },
 { code:0x0451
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0401
  ,simpleLowerCaseMapping:0x0451
  ,simpleTitleCaseMapping:0x0401
 },
 { code:0x0452
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0402
  ,simpleLowerCaseMapping:0x0452
  ,simpleTitleCaseMapping:0x0402
 },
 { code:0x0453
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0403
  ,simpleLowerCaseMapping:0x0453
  ,simpleTitleCaseMapping:0x0403
 },
 { code:0x0454
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0404
  ,simpleLowerCaseMapping:0x0454
  ,simpleTitleCaseMapping:0x0404
 },
 { code:0x0455
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0405
  ,simpleLowerCaseMapping:0x0455
  ,simpleTitleCaseMapping:0x0405
 },
 { code:0x0456
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0406
  ,simpleLowerCaseMapping:0x0456
  ,simpleTitleCaseMapping:0x0406
 },
 { code:0x0457
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0407
  ,simpleLowerCaseMapping:0x0457
  ,simpleTitleCaseMapping:0x0407
 },
 { code:0x0458
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0408
  ,simpleLowerCaseMapping:0x0458
  ,simpleTitleCaseMapping:0x0408
 },
 { code:0x0459
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0409
  ,simpleLowerCaseMapping:0x0459
  ,simpleTitleCaseMapping:0x0409
 },
 { code:0x045A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x040A
  ,simpleLowerCaseMapping:0x045A
  ,simpleTitleCaseMapping:0x040A
 },
 { code:0x045B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x040B
  ,simpleLowerCaseMapping:0x045B
  ,simpleTitleCaseMapping:0x040B
 },
 { code:0x045C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x040C
  ,simpleLowerCaseMapping:0x045C
  ,simpleTitleCaseMapping:0x040C
 },
 { code:0x045D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x040D
  ,simpleLowerCaseMapping:0x045D
  ,simpleTitleCaseMapping:0x040D
 },
 { code:0x045E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x040E
  ,simpleLowerCaseMapping:0x045E
  ,simpleTitleCaseMapping:0x040E
 },
 { code:0x045F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x040F
  ,simpleLowerCaseMapping:0x045F
  ,simpleTitleCaseMapping:0x040F
 },
 { code:0x0460
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0460
  ,simpleLowerCaseMapping:0x0461
  ,simpleTitleCaseMapping:0x0460
 },
 { code:0x0461
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0460
  ,simpleLowerCaseMapping:0x0461
  ,simpleTitleCaseMapping:0x0460
 },
 { code:0x0462
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0462
  ,simpleLowerCaseMapping:0x0463
  ,simpleTitleCaseMapping:0x0462
 },
 { code:0x0463
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0462
  ,simpleLowerCaseMapping:0x0463
  ,simpleTitleCaseMapping:0x0462
 },
 { code:0x0464
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0464
  ,simpleLowerCaseMapping:0x0465
  ,simpleTitleCaseMapping:0x0464
 },
 { code:0x0465
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0464
  ,simpleLowerCaseMapping:0x0465
  ,simpleTitleCaseMapping:0x0464
 },
 { code:0x0466
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0466
  ,simpleLowerCaseMapping:0x0467
  ,simpleTitleCaseMapping:0x0466
 },
 { code:0x0467
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0466
  ,simpleLowerCaseMapping:0x0467
  ,simpleTitleCaseMapping:0x0466
 },
 { code:0x0468
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0468
  ,simpleLowerCaseMapping:0x0469
  ,simpleTitleCaseMapping:0x0468
 },
 { code:0x0469
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0468
  ,simpleLowerCaseMapping:0x0469
  ,simpleTitleCaseMapping:0x0468
 },
 { code:0x046A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x046A
  ,simpleLowerCaseMapping:0x046B
  ,simpleTitleCaseMapping:0x046A
 },
 { code:0x046B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x046A
  ,simpleLowerCaseMapping:0x046B
  ,simpleTitleCaseMapping:0x046A
 },
 { code:0x046C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x046C
  ,simpleLowerCaseMapping:0x046D
  ,simpleTitleCaseMapping:0x046C
 },
 { code:0x046D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x046C
  ,simpleLowerCaseMapping:0x046D
  ,simpleTitleCaseMapping:0x046C
 },
 { code:0x046E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x046E
  ,simpleLowerCaseMapping:0x046F
  ,simpleTitleCaseMapping:0x046E
 },
 { code:0x046F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x046E
  ,simpleLowerCaseMapping:0x046F
  ,simpleTitleCaseMapping:0x046E
 },
 { code:0x0470
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0470
  ,simpleLowerCaseMapping:0x0471
  ,simpleTitleCaseMapping:0x0470
 },
 { code:0x0471
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0470
  ,simpleLowerCaseMapping:0x0471
  ,simpleTitleCaseMapping:0x0470
 },
 { code:0x0472
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0472
  ,simpleLowerCaseMapping:0x0473
  ,simpleTitleCaseMapping:0x0472
 },
 { code:0x0473
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0472
  ,simpleLowerCaseMapping:0x0473
  ,simpleTitleCaseMapping:0x0472
 },
 { code:0x0474
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0474
  ,simpleLowerCaseMapping:0x0475
  ,simpleTitleCaseMapping:0x0474
 },
 { code:0x0475
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0474
  ,simpleLowerCaseMapping:0x0475
  ,simpleTitleCaseMapping:0x0474
 },
 { code:0x0476
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0476
  ,simpleLowerCaseMapping:0x0477
  ,simpleTitleCaseMapping:0x0476
 },
 { code:0x0477
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0476
  ,simpleLowerCaseMapping:0x0477
  ,simpleTitleCaseMapping:0x0476
 },
 { code:0x0478
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0478
  ,simpleLowerCaseMapping:0x0479
  ,simpleTitleCaseMapping:0x0478
 },
 { code:0x0479
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0478
  ,simpleLowerCaseMapping:0x0479
  ,simpleTitleCaseMapping:0x0478
 },
 { code:0x047A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x047A
  ,simpleLowerCaseMapping:0x047B
  ,simpleTitleCaseMapping:0x047A
 },
 { code:0x047B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x047A
  ,simpleLowerCaseMapping:0x047B
  ,simpleTitleCaseMapping:0x047A
 },
 { code:0x047C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x047C
  ,simpleLowerCaseMapping:0x047D
  ,simpleTitleCaseMapping:0x047C
 },
 { code:0x047D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x047C
  ,simpleLowerCaseMapping:0x047D
  ,simpleTitleCaseMapping:0x047C
 },
 { code:0x047E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x047E
  ,simpleLowerCaseMapping:0x047F
  ,simpleTitleCaseMapping:0x047E
 },
 { code:0x047F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x047E
  ,simpleLowerCaseMapping:0x047F
  ,simpleTitleCaseMapping:0x047E
 },
 { code:0x0480
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0480
  ,simpleLowerCaseMapping:0x0481
  ,simpleTitleCaseMapping:0x0480
 },
 { code:0x0481
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0480
  ,simpleLowerCaseMapping:0x0481
  ,simpleTitleCaseMapping:0x0480
 },
 { code:0x0482
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0482
  ,simpleLowerCaseMapping:0x0482
  ,simpleTitleCaseMapping:0x0482
 },
 { code:0x0483
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0483
  ,simpleLowerCaseMapping:0x0483
  ,simpleTitleCaseMapping:0x0483
 },
 { code:0x0484
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0484
  ,simpleLowerCaseMapping:0x0484
  ,simpleTitleCaseMapping:0x0484
 },
 { code:0x0485
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0485
  ,simpleLowerCaseMapping:0x0485
  ,simpleTitleCaseMapping:0x0485
 },
 { code:0x0486
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0486
  ,simpleLowerCaseMapping:0x0486
  ,simpleTitleCaseMapping:0x0486
 },
 { code:0x0488
  ,generalCategory:UnicodeData.GeneralCategory.Me
  ,simpleUpperCaseMapping:0x0488
  ,simpleLowerCaseMapping:0x0488
  ,simpleTitleCaseMapping:0x0488
 },
 { code:0x0489
  ,generalCategory:UnicodeData.GeneralCategory.Me
  ,simpleUpperCaseMapping:0x0489
  ,simpleLowerCaseMapping:0x0489
  ,simpleTitleCaseMapping:0x0489
 },
 { code:0x048A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x048A
  ,simpleLowerCaseMapping:0x048B
  ,simpleTitleCaseMapping:0x048A
 },
 { code:0x048B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x048A
  ,simpleLowerCaseMapping:0x048B
  ,simpleTitleCaseMapping:0x048A
 },
 { code:0x048C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x048C
  ,simpleLowerCaseMapping:0x048D
  ,simpleTitleCaseMapping:0x048C
 },
 { code:0x048D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x048C
  ,simpleLowerCaseMapping:0x048D
  ,simpleTitleCaseMapping:0x048C
 },
 { code:0x048E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x048E
  ,simpleLowerCaseMapping:0x048F
  ,simpleTitleCaseMapping:0x048E
 },
 { code:0x048F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x048E
  ,simpleLowerCaseMapping:0x048F
  ,simpleTitleCaseMapping:0x048E
 },
 { code:0x0490
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0490
  ,simpleLowerCaseMapping:0x0491
  ,simpleTitleCaseMapping:0x0490
 },
 { code:0x0491
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0490
  ,simpleLowerCaseMapping:0x0491
  ,simpleTitleCaseMapping:0x0490
 },
 { code:0x0492
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0492
  ,simpleLowerCaseMapping:0x0493
  ,simpleTitleCaseMapping:0x0492
 },
 { code:0x0493
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0492
  ,simpleLowerCaseMapping:0x0493
  ,simpleTitleCaseMapping:0x0492
 },
 { code:0x0494
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0494
  ,simpleLowerCaseMapping:0x0495
  ,simpleTitleCaseMapping:0x0494
 },
 { code:0x0495
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0494
  ,simpleLowerCaseMapping:0x0495
  ,simpleTitleCaseMapping:0x0494
 },
 { code:0x0496
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0496
  ,simpleLowerCaseMapping:0x0497
  ,simpleTitleCaseMapping:0x0496
 },
 { code:0x0497
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0496
  ,simpleLowerCaseMapping:0x0497
  ,simpleTitleCaseMapping:0x0496
 },
 { code:0x0498
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0498
  ,simpleLowerCaseMapping:0x0499
  ,simpleTitleCaseMapping:0x0498
 },
 { code:0x0499
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0498
  ,simpleLowerCaseMapping:0x0499
  ,simpleTitleCaseMapping:0x0498
 },
 { code:0x049A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x049A
  ,simpleLowerCaseMapping:0x049B
  ,simpleTitleCaseMapping:0x049A
 },
 { code:0x049B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x049A
  ,simpleLowerCaseMapping:0x049B
  ,simpleTitleCaseMapping:0x049A
 },
 { code:0x049C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x049C
  ,simpleLowerCaseMapping:0x049D
  ,simpleTitleCaseMapping:0x049C
 },
 { code:0x049D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x049C
  ,simpleLowerCaseMapping:0x049D
  ,simpleTitleCaseMapping:0x049C
 },
 { code:0x049E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x049E
  ,simpleLowerCaseMapping:0x049F
  ,simpleTitleCaseMapping:0x049E
 },
 { code:0x049F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x049E
  ,simpleLowerCaseMapping:0x049F
  ,simpleTitleCaseMapping:0x049E
 },
 { code:0x04A0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04A0
  ,simpleLowerCaseMapping:0x04A1
  ,simpleTitleCaseMapping:0x04A0
 },
 { code:0x04A1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04A0
  ,simpleLowerCaseMapping:0x04A1
  ,simpleTitleCaseMapping:0x04A0
 },
 { code:0x04A2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04A2
  ,simpleLowerCaseMapping:0x04A3
  ,simpleTitleCaseMapping:0x04A2
 },
 { code:0x04A3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04A2
  ,simpleLowerCaseMapping:0x04A3
  ,simpleTitleCaseMapping:0x04A2
 },
 { code:0x04A4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04A4
  ,simpleLowerCaseMapping:0x04A5
  ,simpleTitleCaseMapping:0x04A4
 },
 { code:0x04A5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04A4
  ,simpleLowerCaseMapping:0x04A5
  ,simpleTitleCaseMapping:0x04A4
 },
 { code:0x04A6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04A6
  ,simpleLowerCaseMapping:0x04A7
  ,simpleTitleCaseMapping:0x04A6
 },
 { code:0x04A7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04A6
  ,simpleLowerCaseMapping:0x04A7
  ,simpleTitleCaseMapping:0x04A6
 },
 { code:0x04A8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04A8
  ,simpleLowerCaseMapping:0x04A9
  ,simpleTitleCaseMapping:0x04A8
 },
 { code:0x04A9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04A8
  ,simpleLowerCaseMapping:0x04A9
  ,simpleTitleCaseMapping:0x04A8
 },
 { code:0x04AA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04AA
  ,simpleLowerCaseMapping:0x04AB
  ,simpleTitleCaseMapping:0x04AA
 },
 { code:0x04AB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04AA
  ,simpleLowerCaseMapping:0x04AB
  ,simpleTitleCaseMapping:0x04AA
 },
 { code:0x04AC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04AC
  ,simpleLowerCaseMapping:0x04AD
  ,simpleTitleCaseMapping:0x04AC
 },
 { code:0x04AD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04AC
  ,simpleLowerCaseMapping:0x04AD
  ,simpleTitleCaseMapping:0x04AC
 },
 { code:0x04AE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04AE
  ,simpleLowerCaseMapping:0x04AF
  ,simpleTitleCaseMapping:0x04AE
 },
 { code:0x04AF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04AE
  ,simpleLowerCaseMapping:0x04AF
  ,simpleTitleCaseMapping:0x04AE
 },
 { code:0x04B0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04B0
  ,simpleLowerCaseMapping:0x04B1
  ,simpleTitleCaseMapping:0x04B0
 },
 { code:0x04B1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04B0
  ,simpleLowerCaseMapping:0x04B1
  ,simpleTitleCaseMapping:0x04B0
 },
 { code:0x04B2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04B2
  ,simpleLowerCaseMapping:0x04B3
  ,simpleTitleCaseMapping:0x04B2
 },
 { code:0x04B3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04B2
  ,simpleLowerCaseMapping:0x04B3
  ,simpleTitleCaseMapping:0x04B2
 },
 { code:0x04B4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04B4
  ,simpleLowerCaseMapping:0x04B5
  ,simpleTitleCaseMapping:0x04B4
 },
 { code:0x04B5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04B4
  ,simpleLowerCaseMapping:0x04B5
  ,simpleTitleCaseMapping:0x04B4
 },
 { code:0x04B6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04B6
  ,simpleLowerCaseMapping:0x04B7
  ,simpleTitleCaseMapping:0x04B6
 },
 { code:0x04B7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04B6
  ,simpleLowerCaseMapping:0x04B7
  ,simpleTitleCaseMapping:0x04B6
 },
 { code:0x04B8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04B8
  ,simpleLowerCaseMapping:0x04B9
  ,simpleTitleCaseMapping:0x04B8
 },
 { code:0x04B9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04B8
  ,simpleLowerCaseMapping:0x04B9
  ,simpleTitleCaseMapping:0x04B8
 },
 { code:0x04BA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04BA
  ,simpleLowerCaseMapping:0x04BB
  ,simpleTitleCaseMapping:0x04BA
 },
 { code:0x04BB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04BA
  ,simpleLowerCaseMapping:0x04BB
  ,simpleTitleCaseMapping:0x04BA
 },
 { code:0x04BC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04BC
  ,simpleLowerCaseMapping:0x04BD
  ,simpleTitleCaseMapping:0x04BC
 },
 { code:0x04BD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04BC
  ,simpleLowerCaseMapping:0x04BD
  ,simpleTitleCaseMapping:0x04BC
 },
 { code:0x04BE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04BE
  ,simpleLowerCaseMapping:0x04BF
  ,simpleTitleCaseMapping:0x04BE
 },
 { code:0x04BF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04BE
  ,simpleLowerCaseMapping:0x04BF
  ,simpleTitleCaseMapping:0x04BE
 },
 { code:0x04C0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04C0
  ,simpleLowerCaseMapping:0x04CF
  ,simpleTitleCaseMapping:0x04C0
 },
 { code:0x04C1
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04C1
  ,simpleLowerCaseMapping:0x04C2
  ,simpleTitleCaseMapping:0x04C1
 },
 { code:0x04C2
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04C1
  ,simpleLowerCaseMapping:0x04C2
  ,simpleTitleCaseMapping:0x04C1
 },
 { code:0x04C3
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04C3
  ,simpleLowerCaseMapping:0x04C4
  ,simpleTitleCaseMapping:0x04C3
 },
 { code:0x04C4
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04C3
  ,simpleLowerCaseMapping:0x04C4
  ,simpleTitleCaseMapping:0x04C3
 },
 { code:0x04C5
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04C5
  ,simpleLowerCaseMapping:0x04C6
  ,simpleTitleCaseMapping:0x04C5
 },
 { code:0x04C6
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04C5
  ,simpleLowerCaseMapping:0x04C6
  ,simpleTitleCaseMapping:0x04C5
 },
 { code:0x04C7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04C7
  ,simpleLowerCaseMapping:0x04C8
  ,simpleTitleCaseMapping:0x04C7
 },
 { code:0x04C8
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04C7
  ,simpleLowerCaseMapping:0x04C8
  ,simpleTitleCaseMapping:0x04C7
 },
 { code:0x04C9
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04C9
  ,simpleLowerCaseMapping:0x04CA
  ,simpleTitleCaseMapping:0x04C9
 },
 { code:0x04CA
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04C9
  ,simpleLowerCaseMapping:0x04CA
  ,simpleTitleCaseMapping:0x04C9
 },
 { code:0x04CB
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04CB
  ,simpleLowerCaseMapping:0x04CC
  ,simpleTitleCaseMapping:0x04CB
 },
 { code:0x04CC
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04CB
  ,simpleLowerCaseMapping:0x04CC
  ,simpleTitleCaseMapping:0x04CB
 },
 { code:0x04CD
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04CD
  ,simpleLowerCaseMapping:0x04CE
  ,simpleTitleCaseMapping:0x04CD
 },
 { code:0x04CE
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04CD
  ,simpleLowerCaseMapping:0x04CE
  ,simpleTitleCaseMapping:0x04CD
 },
 { code:0x04CF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04C0
  ,simpleLowerCaseMapping:0x04CF
  ,simpleTitleCaseMapping:0x04C0
 },
 { code:0x04D0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04D0
  ,simpleLowerCaseMapping:0x04D1
  ,simpleTitleCaseMapping:0x04D0
 },
 { code:0x04D1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04D0
  ,simpleLowerCaseMapping:0x04D1
  ,simpleTitleCaseMapping:0x04D0
 },
 { code:0x04D2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04D2
  ,simpleLowerCaseMapping:0x04D3
  ,simpleTitleCaseMapping:0x04D2
 },
 { code:0x04D3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04D2
  ,simpleLowerCaseMapping:0x04D3
  ,simpleTitleCaseMapping:0x04D2
 },
 { code:0x04D4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04D4
  ,simpleLowerCaseMapping:0x04D5
  ,simpleTitleCaseMapping:0x04D4
 },
 { code:0x04D5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04D4
  ,simpleLowerCaseMapping:0x04D5
  ,simpleTitleCaseMapping:0x04D4
 },
 { code:0x04D6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04D6
  ,simpleLowerCaseMapping:0x04D7
  ,simpleTitleCaseMapping:0x04D6
 },
 { code:0x04D7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04D6
  ,simpleLowerCaseMapping:0x04D7
  ,simpleTitleCaseMapping:0x04D6
 },
 { code:0x04D8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04D8
  ,simpleLowerCaseMapping:0x04D9
  ,simpleTitleCaseMapping:0x04D8
 },
 { code:0x04D9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04D8
  ,simpleLowerCaseMapping:0x04D9
  ,simpleTitleCaseMapping:0x04D8
 },
 { code:0x04DA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04DA
  ,simpleLowerCaseMapping:0x04DB
  ,simpleTitleCaseMapping:0x04DA
 },
 { code:0x04DB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04DA
  ,simpleLowerCaseMapping:0x04DB
  ,simpleTitleCaseMapping:0x04DA
 },
 { code:0x04DC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04DC
  ,simpleLowerCaseMapping:0x04DD
  ,simpleTitleCaseMapping:0x04DC
 },
 { code:0x04DD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04DC
  ,simpleLowerCaseMapping:0x04DD
  ,simpleTitleCaseMapping:0x04DC
 },
 { code:0x04DE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04DE
  ,simpleLowerCaseMapping:0x04DF
  ,simpleTitleCaseMapping:0x04DE
 },
 { code:0x04DF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04DE
  ,simpleLowerCaseMapping:0x04DF
  ,simpleTitleCaseMapping:0x04DE
 },
 { code:0x04E0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04E0
  ,simpleLowerCaseMapping:0x04E1
  ,simpleTitleCaseMapping:0x04E0
 },
 { code:0x04E1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04E0
  ,simpleLowerCaseMapping:0x04E1
  ,simpleTitleCaseMapping:0x04E0
 },
 { code:0x04E2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04E2
  ,simpleLowerCaseMapping:0x04E3
  ,simpleTitleCaseMapping:0x04E2
 },
 { code:0x04E3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04E2
  ,simpleLowerCaseMapping:0x04E3
  ,simpleTitleCaseMapping:0x04E2
 },
 { code:0x04E4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04E4
  ,simpleLowerCaseMapping:0x04E5
  ,simpleTitleCaseMapping:0x04E4
 },
 { code:0x04E5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04E4
  ,simpleLowerCaseMapping:0x04E5
  ,simpleTitleCaseMapping:0x04E4
 },
 { code:0x04E6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04E6
  ,simpleLowerCaseMapping:0x04E7
  ,simpleTitleCaseMapping:0x04E6
 },
 { code:0x04E7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04E6
  ,simpleLowerCaseMapping:0x04E7
  ,simpleTitleCaseMapping:0x04E6
 },
 { code:0x04E8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04E8
  ,simpleLowerCaseMapping:0x04E9
  ,simpleTitleCaseMapping:0x04E8
 },
 { code:0x04E9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04E8
  ,simpleLowerCaseMapping:0x04E9
  ,simpleTitleCaseMapping:0x04E8
 },
 { code:0x04EA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04EA
  ,simpleLowerCaseMapping:0x04EB
  ,simpleTitleCaseMapping:0x04EA
 },
 { code:0x04EB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04EA
  ,simpleLowerCaseMapping:0x04EB
  ,simpleTitleCaseMapping:0x04EA
 },
 { code:0x04EC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04EC
  ,simpleLowerCaseMapping:0x04ED
  ,simpleTitleCaseMapping:0x04EC
 },
 { code:0x04ED
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04EC
  ,simpleLowerCaseMapping:0x04ED
  ,simpleTitleCaseMapping:0x04EC
 },
 { code:0x04EE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04EE
  ,simpleLowerCaseMapping:0x04EF
  ,simpleTitleCaseMapping:0x04EE
 },
 { code:0x04EF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04EE
  ,simpleLowerCaseMapping:0x04EF
  ,simpleTitleCaseMapping:0x04EE
 },
 { code:0x04F0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04F0
  ,simpleLowerCaseMapping:0x04F1
  ,simpleTitleCaseMapping:0x04F0
 },
 { code:0x04F1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04F0
  ,simpleLowerCaseMapping:0x04F1
  ,simpleTitleCaseMapping:0x04F0
 },
 { code:0x04F2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04F2
  ,simpleLowerCaseMapping:0x04F3
  ,simpleTitleCaseMapping:0x04F2
 },
 { code:0x04F3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04F2
  ,simpleLowerCaseMapping:0x04F3
  ,simpleTitleCaseMapping:0x04F2
 },
 { code:0x04F4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04F4
  ,simpleLowerCaseMapping:0x04F5
  ,simpleTitleCaseMapping:0x04F4
 },
 { code:0x04F5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04F4
  ,simpleLowerCaseMapping:0x04F5
  ,simpleTitleCaseMapping:0x04F4
 },
 { code:0x04F6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04F6
  ,simpleLowerCaseMapping:0x04F7
  ,simpleTitleCaseMapping:0x04F6
 },
 { code:0x04F7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04F6
  ,simpleLowerCaseMapping:0x04F7
  ,simpleTitleCaseMapping:0x04F6
 },
 { code:0x04F8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04F8
  ,simpleLowerCaseMapping:0x04F9
  ,simpleTitleCaseMapping:0x04F8
 },
 { code:0x04F9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04F8
  ,simpleLowerCaseMapping:0x04F9
  ,simpleTitleCaseMapping:0x04F8
 },
 { code:0x04FA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04FA
  ,simpleLowerCaseMapping:0x04FB
  ,simpleTitleCaseMapping:0x04FA
 },
 { code:0x04FB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04FA
  ,simpleLowerCaseMapping:0x04FB
  ,simpleTitleCaseMapping:0x04FA
 },
 { code:0x04FC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04FC
  ,simpleLowerCaseMapping:0x04FD
  ,simpleTitleCaseMapping:0x04FC
 },
 { code:0x04FD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04FC
  ,simpleLowerCaseMapping:0x04FD
  ,simpleTitleCaseMapping:0x04FC
 },
 { code:0x04FE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x04FE
  ,simpleLowerCaseMapping:0x04FF
  ,simpleTitleCaseMapping:0x04FE
 },
 { code:0x04FF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x04FE
  ,simpleLowerCaseMapping:0x04FF
  ,simpleTitleCaseMapping:0x04FE
 },
 { code:0x0500
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0500
  ,simpleLowerCaseMapping:0x0501
  ,simpleTitleCaseMapping:0x0500
 },
 { code:0x0501
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0500
  ,simpleLowerCaseMapping:0x0501
  ,simpleTitleCaseMapping:0x0500
 },
 { code:0x0502
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0502
  ,simpleLowerCaseMapping:0x0503
  ,simpleTitleCaseMapping:0x0502
 },
 { code:0x0503
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0502
  ,simpleLowerCaseMapping:0x0503
  ,simpleTitleCaseMapping:0x0502
 },
 { code:0x0504
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0504
  ,simpleLowerCaseMapping:0x0505
  ,simpleTitleCaseMapping:0x0504
 },
 { code:0x0505
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0504
  ,simpleLowerCaseMapping:0x0505
  ,simpleTitleCaseMapping:0x0504
 },
 { code:0x0506
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0506
  ,simpleLowerCaseMapping:0x0507
  ,simpleTitleCaseMapping:0x0506
 },
 { code:0x0507
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0506
  ,simpleLowerCaseMapping:0x0507
  ,simpleTitleCaseMapping:0x0506
 },
 { code:0x0508
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0508
  ,simpleLowerCaseMapping:0x0509
  ,simpleTitleCaseMapping:0x0508
 },
 { code:0x0509
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0508
  ,simpleLowerCaseMapping:0x0509
  ,simpleTitleCaseMapping:0x0508
 },
 { code:0x050A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x050A
  ,simpleLowerCaseMapping:0x050B
  ,simpleTitleCaseMapping:0x050A
 },
 { code:0x050B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x050A
  ,simpleLowerCaseMapping:0x050B
  ,simpleTitleCaseMapping:0x050A
 },
 { code:0x050C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x050C
  ,simpleLowerCaseMapping:0x050D
  ,simpleTitleCaseMapping:0x050C
 },
 { code:0x050D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x050C
  ,simpleLowerCaseMapping:0x050D
  ,simpleTitleCaseMapping:0x050C
 },
 { code:0x050E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x050E
  ,simpleLowerCaseMapping:0x050F
  ,simpleTitleCaseMapping:0x050E
 },
 { code:0x050F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x050E
  ,simpleLowerCaseMapping:0x050F
  ,simpleTitleCaseMapping:0x050E
 },
 { code:0x0510
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0510
  ,simpleLowerCaseMapping:0x0511
  ,simpleTitleCaseMapping:0x0510
 },
 { code:0x0511
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0510
  ,simpleLowerCaseMapping:0x0511
  ,simpleTitleCaseMapping:0x0510
 },
 { code:0x0512
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0512
  ,simpleLowerCaseMapping:0x0513
  ,simpleTitleCaseMapping:0x0512
 },
 { code:0x0513
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0512
  ,simpleLowerCaseMapping:0x0513
  ,simpleTitleCaseMapping:0x0512
 },
 { code:0x0531
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0531
  ,simpleLowerCaseMapping:0x0561
  ,simpleTitleCaseMapping:0x0531
 },
 { code:0x0532
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0532
  ,simpleLowerCaseMapping:0x0562
  ,simpleTitleCaseMapping:0x0532
 },
 { code:0x0533
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0533
  ,simpleLowerCaseMapping:0x0563
  ,simpleTitleCaseMapping:0x0533
 },
 { code:0x0534
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0534
  ,simpleLowerCaseMapping:0x0564
  ,simpleTitleCaseMapping:0x0534
 },
 { code:0x0535
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0535
  ,simpleLowerCaseMapping:0x0565
  ,simpleTitleCaseMapping:0x0535
 },
 { code:0x0536
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0536
  ,simpleLowerCaseMapping:0x0566
  ,simpleTitleCaseMapping:0x0536
 },
 { code:0x0537
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0537
  ,simpleLowerCaseMapping:0x0567
  ,simpleTitleCaseMapping:0x0537
 },
 { code:0x0538
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0538
  ,simpleLowerCaseMapping:0x0568
  ,simpleTitleCaseMapping:0x0538
 },
 { code:0x0539
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0539
  ,simpleLowerCaseMapping:0x0569
  ,simpleTitleCaseMapping:0x0539
 },
 { code:0x053A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x053A
  ,simpleLowerCaseMapping:0x056A
  ,simpleTitleCaseMapping:0x053A
 },
 { code:0x053B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x053B
  ,simpleLowerCaseMapping:0x056B
  ,simpleTitleCaseMapping:0x053B
 },
 { code:0x053C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x053C
  ,simpleLowerCaseMapping:0x056C
  ,simpleTitleCaseMapping:0x053C
 },
 { code:0x053D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x053D
  ,simpleLowerCaseMapping:0x056D
  ,simpleTitleCaseMapping:0x053D
 },
 { code:0x053E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x053E
  ,simpleLowerCaseMapping:0x056E
  ,simpleTitleCaseMapping:0x053E
 },
 { code:0x053F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x053F
  ,simpleLowerCaseMapping:0x056F
  ,simpleTitleCaseMapping:0x053F
 },
 { code:0x0540
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0540
  ,simpleLowerCaseMapping:0x0570
  ,simpleTitleCaseMapping:0x0540
 },
 { code:0x0541
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0541
  ,simpleLowerCaseMapping:0x0571
  ,simpleTitleCaseMapping:0x0541
 },
 { code:0x0542
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0542
  ,simpleLowerCaseMapping:0x0572
  ,simpleTitleCaseMapping:0x0542
 },
 { code:0x0543
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0543
  ,simpleLowerCaseMapping:0x0573
  ,simpleTitleCaseMapping:0x0543
 },
 { code:0x0544
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0544
  ,simpleLowerCaseMapping:0x0574
  ,simpleTitleCaseMapping:0x0544
 },
 { code:0x0545
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0545
  ,simpleLowerCaseMapping:0x0575
  ,simpleTitleCaseMapping:0x0545
 },
 { code:0x0546
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0546
  ,simpleLowerCaseMapping:0x0576
  ,simpleTitleCaseMapping:0x0546
 },
 { code:0x0547
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0547
  ,simpleLowerCaseMapping:0x0577
  ,simpleTitleCaseMapping:0x0547
 },
 { code:0x0548
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0548
  ,simpleLowerCaseMapping:0x0578
  ,simpleTitleCaseMapping:0x0548
 },
 { code:0x0549
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0549
  ,simpleLowerCaseMapping:0x0579
  ,simpleTitleCaseMapping:0x0549
 },
 { code:0x054A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x054A
  ,simpleLowerCaseMapping:0x057A
  ,simpleTitleCaseMapping:0x054A
 },
 { code:0x054B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x054B
  ,simpleLowerCaseMapping:0x057B
  ,simpleTitleCaseMapping:0x054B
 },
 { code:0x054C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x054C
  ,simpleLowerCaseMapping:0x057C
  ,simpleTitleCaseMapping:0x054C
 },
 { code:0x054D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x054D
  ,simpleLowerCaseMapping:0x057D
  ,simpleTitleCaseMapping:0x054D
 },
 { code:0x054E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x054E
  ,simpleLowerCaseMapping:0x057E
  ,simpleTitleCaseMapping:0x054E
 },
 { code:0x054F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x054F
  ,simpleLowerCaseMapping:0x057F
  ,simpleTitleCaseMapping:0x054F
 },
 { code:0x0550
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0550
  ,simpleLowerCaseMapping:0x0580
  ,simpleTitleCaseMapping:0x0550
 },
 { code:0x0551
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0551
  ,simpleLowerCaseMapping:0x0581
  ,simpleTitleCaseMapping:0x0551
 },
 { code:0x0552
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0552
  ,simpleLowerCaseMapping:0x0582
  ,simpleTitleCaseMapping:0x0552
 },
 { code:0x0553
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0553
  ,simpleLowerCaseMapping:0x0583
  ,simpleTitleCaseMapping:0x0553
 },
 { code:0x0554
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0554
  ,simpleLowerCaseMapping:0x0584
  ,simpleTitleCaseMapping:0x0554
 },
 { code:0x0555
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0555
  ,simpleLowerCaseMapping:0x0585
  ,simpleTitleCaseMapping:0x0555
 },
 { code:0x0556
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x0556
  ,simpleLowerCaseMapping:0x0586
  ,simpleTitleCaseMapping:0x0556
 },
 { code:0x0559
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x0559
  ,simpleLowerCaseMapping:0x0559
  ,simpleTitleCaseMapping:0x0559
 },
 { code:0x055A
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x055A
  ,simpleLowerCaseMapping:0x055A
  ,simpleTitleCaseMapping:0x055A
 },
 { code:0x055B
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x055B
  ,simpleLowerCaseMapping:0x055B
  ,simpleTitleCaseMapping:0x055B
 },
 { code:0x055C
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x055C
  ,simpleLowerCaseMapping:0x055C
  ,simpleTitleCaseMapping:0x055C
 },
 { code:0x055D
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x055D
  ,simpleLowerCaseMapping:0x055D
  ,simpleTitleCaseMapping:0x055D
 },
 { code:0x055E
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x055E
  ,simpleLowerCaseMapping:0x055E
  ,simpleTitleCaseMapping:0x055E
 },
 { code:0x055F
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x055F
  ,simpleLowerCaseMapping:0x055F
  ,simpleTitleCaseMapping:0x055F
 },
 { code:0x0561
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0531
  ,simpleLowerCaseMapping:0x0561
  ,simpleTitleCaseMapping:0x0531
 },
 { code:0x0562
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0532
  ,simpleLowerCaseMapping:0x0562
  ,simpleTitleCaseMapping:0x0532
 },
 { code:0x0563
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0533
  ,simpleLowerCaseMapping:0x0563
  ,simpleTitleCaseMapping:0x0533
 },
 { code:0x0564
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0534
  ,simpleLowerCaseMapping:0x0564
  ,simpleTitleCaseMapping:0x0534
 },
 { code:0x0565
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0535
  ,simpleLowerCaseMapping:0x0565
  ,simpleTitleCaseMapping:0x0535
 },
 { code:0x0566
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0536
  ,simpleLowerCaseMapping:0x0566
  ,simpleTitleCaseMapping:0x0536
 },
 { code:0x0567
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0537
  ,simpleLowerCaseMapping:0x0567
  ,simpleTitleCaseMapping:0x0537
 },
 { code:0x0568
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0538
  ,simpleLowerCaseMapping:0x0568
  ,simpleTitleCaseMapping:0x0538
 },
 { code:0x0569
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0539
  ,simpleLowerCaseMapping:0x0569
  ,simpleTitleCaseMapping:0x0539
 },
 { code:0x056A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x053A
  ,simpleLowerCaseMapping:0x056A
  ,simpleTitleCaseMapping:0x053A
 },
 { code:0x056B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x053B
  ,simpleLowerCaseMapping:0x056B
  ,simpleTitleCaseMapping:0x053B
 },
 { code:0x056C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x053C
  ,simpleLowerCaseMapping:0x056C
  ,simpleTitleCaseMapping:0x053C
 },
 { code:0x056D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x053D
  ,simpleLowerCaseMapping:0x056D
  ,simpleTitleCaseMapping:0x053D
 },
 { code:0x056E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x053E
  ,simpleLowerCaseMapping:0x056E
  ,simpleTitleCaseMapping:0x053E
 },
 { code:0x056F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x053F
  ,simpleLowerCaseMapping:0x056F
  ,simpleTitleCaseMapping:0x053F
 },
 { code:0x0570
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0540
  ,simpleLowerCaseMapping:0x0570
  ,simpleTitleCaseMapping:0x0540
 },
 { code:0x0571
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0541
  ,simpleLowerCaseMapping:0x0571
  ,simpleTitleCaseMapping:0x0541
 },
 { code:0x0572
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0542
  ,simpleLowerCaseMapping:0x0572
  ,simpleTitleCaseMapping:0x0542
 },
 { code:0x0573
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0543
  ,simpleLowerCaseMapping:0x0573
  ,simpleTitleCaseMapping:0x0543
 },
 { code:0x0574
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0544
  ,simpleLowerCaseMapping:0x0574
  ,simpleTitleCaseMapping:0x0544
 },
 { code:0x0575
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0545
  ,simpleLowerCaseMapping:0x0575
  ,simpleTitleCaseMapping:0x0545
 },
 { code:0x0576
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0546
  ,simpleLowerCaseMapping:0x0576
  ,simpleTitleCaseMapping:0x0546
 },
 { code:0x0577
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0547
  ,simpleLowerCaseMapping:0x0577
  ,simpleTitleCaseMapping:0x0547
 },
 { code:0x0578
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0548
  ,simpleLowerCaseMapping:0x0578
  ,simpleTitleCaseMapping:0x0548
 },
 { code:0x0579
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0549
  ,simpleLowerCaseMapping:0x0579
  ,simpleTitleCaseMapping:0x0549
 },
 { code:0x057A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x054A
  ,simpleLowerCaseMapping:0x057A
  ,simpleTitleCaseMapping:0x054A
 },
 { code:0x057B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x054B
  ,simpleLowerCaseMapping:0x057B
  ,simpleTitleCaseMapping:0x054B
 },
 { code:0x057C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x054C
  ,simpleLowerCaseMapping:0x057C
  ,simpleTitleCaseMapping:0x054C
 },
 { code:0x057D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x054D
  ,simpleLowerCaseMapping:0x057D
  ,simpleTitleCaseMapping:0x054D
 },
 { code:0x057E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x054E
  ,simpleLowerCaseMapping:0x057E
  ,simpleTitleCaseMapping:0x054E
 },
 { code:0x057F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x054F
  ,simpleLowerCaseMapping:0x057F
  ,simpleTitleCaseMapping:0x054F
 },
 { code:0x0580
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0550
  ,simpleLowerCaseMapping:0x0580
  ,simpleTitleCaseMapping:0x0550
 },
 { code:0x0581
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0551
  ,simpleLowerCaseMapping:0x0581
  ,simpleTitleCaseMapping:0x0551
 },
 { code:0x0582
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0552
  ,simpleLowerCaseMapping:0x0582
  ,simpleTitleCaseMapping:0x0552
 },
 { code:0x0583
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0553
  ,simpleLowerCaseMapping:0x0583
  ,simpleTitleCaseMapping:0x0553
 },
 { code:0x0584
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0554
  ,simpleLowerCaseMapping:0x0584
  ,simpleTitleCaseMapping:0x0554
 },
 { code:0x0585
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0555
  ,simpleLowerCaseMapping:0x0585
  ,simpleTitleCaseMapping:0x0555
 },
 { code:0x0586
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x0556
  ,simpleLowerCaseMapping:0x0586
  ,simpleTitleCaseMapping:0x0556
 },
 { code:0x0587
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x0587
  ,simpleLowerCaseMapping:0x0587
  ,simpleTitleCaseMapping:0x0587
 },
 { code:0x0589
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0589
  ,simpleLowerCaseMapping:0x0589
  ,simpleTitleCaseMapping:0x0589
 },
 { code:0x058A
  ,generalCategory:UnicodeData.GeneralCategory.Pd
  ,simpleUpperCaseMapping:0x058A
  ,simpleLowerCaseMapping:0x058A
  ,simpleTitleCaseMapping:0x058A
 },
 { code:0x0591
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0591
  ,simpleLowerCaseMapping:0x0591
  ,simpleTitleCaseMapping:0x0591
 },
 { code:0x0592
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0592
  ,simpleLowerCaseMapping:0x0592
  ,simpleTitleCaseMapping:0x0592
 },
 { code:0x0593
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0593
  ,simpleLowerCaseMapping:0x0593
  ,simpleTitleCaseMapping:0x0593
 },
 { code:0x0594
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0594
  ,simpleLowerCaseMapping:0x0594
  ,simpleTitleCaseMapping:0x0594
 },
 { code:0x0595
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0595
  ,simpleLowerCaseMapping:0x0595
  ,simpleTitleCaseMapping:0x0595
 },
 { code:0x0596
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0596
  ,simpleLowerCaseMapping:0x0596
  ,simpleTitleCaseMapping:0x0596
 },
 { code:0x0597
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0597
  ,simpleLowerCaseMapping:0x0597
  ,simpleTitleCaseMapping:0x0597
 },
 { code:0x0598
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0598
  ,simpleLowerCaseMapping:0x0598
  ,simpleTitleCaseMapping:0x0598
 },
 { code:0x0599
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0599
  ,simpleLowerCaseMapping:0x0599
  ,simpleTitleCaseMapping:0x0599
 },
 { code:0x059A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x059A
  ,simpleLowerCaseMapping:0x059A
  ,simpleTitleCaseMapping:0x059A
 },
 { code:0x059B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x059B
  ,simpleLowerCaseMapping:0x059B
  ,simpleTitleCaseMapping:0x059B
 },
 { code:0x059C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x059C
  ,simpleLowerCaseMapping:0x059C
  ,simpleTitleCaseMapping:0x059C
 },
 { code:0x059D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x059D
  ,simpleLowerCaseMapping:0x059D
  ,simpleTitleCaseMapping:0x059D
 },
 { code:0x059E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x059E
  ,simpleLowerCaseMapping:0x059E
  ,simpleTitleCaseMapping:0x059E
 },
 { code:0x059F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x059F
  ,simpleLowerCaseMapping:0x059F
  ,simpleTitleCaseMapping:0x059F
 },
 { code:0x05A0
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05A0
  ,simpleLowerCaseMapping:0x05A0
  ,simpleTitleCaseMapping:0x05A0
 },
 { code:0x05A1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05A1
  ,simpleLowerCaseMapping:0x05A1
  ,simpleTitleCaseMapping:0x05A1
 },
 { code:0x05A2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05A2
  ,simpleLowerCaseMapping:0x05A2
  ,simpleTitleCaseMapping:0x05A2
 },
 { code:0x05A3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05A3
  ,simpleLowerCaseMapping:0x05A3
  ,simpleTitleCaseMapping:0x05A3
 },
 { code:0x05A4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05A4
  ,simpleLowerCaseMapping:0x05A4
  ,simpleTitleCaseMapping:0x05A4
 },
 { code:0x05A5
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05A5
  ,simpleLowerCaseMapping:0x05A5
  ,simpleTitleCaseMapping:0x05A5
 },
 { code:0x05A6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05A6
  ,simpleLowerCaseMapping:0x05A6
  ,simpleTitleCaseMapping:0x05A6
 },
 { code:0x05A7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05A7
  ,simpleLowerCaseMapping:0x05A7
  ,simpleTitleCaseMapping:0x05A7
 },
 { code:0x05A8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05A8
  ,simpleLowerCaseMapping:0x05A8
  ,simpleTitleCaseMapping:0x05A8
 },
 { code:0x05A9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05A9
  ,simpleLowerCaseMapping:0x05A9
  ,simpleTitleCaseMapping:0x05A9
 },
 { code:0x05AA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05AA
  ,simpleLowerCaseMapping:0x05AA
  ,simpleTitleCaseMapping:0x05AA
 },
 { code:0x05AB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05AB
  ,simpleLowerCaseMapping:0x05AB
  ,simpleTitleCaseMapping:0x05AB
 },
 { code:0x05AC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05AC
  ,simpleLowerCaseMapping:0x05AC
  ,simpleTitleCaseMapping:0x05AC
 },
 { code:0x05AD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05AD
  ,simpleLowerCaseMapping:0x05AD
  ,simpleTitleCaseMapping:0x05AD
 },
 { code:0x05AE
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05AE
  ,simpleLowerCaseMapping:0x05AE
  ,simpleTitleCaseMapping:0x05AE
 },
 { code:0x05AF
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05AF
  ,simpleLowerCaseMapping:0x05AF
  ,simpleTitleCaseMapping:0x05AF
 },
 { code:0x05B0
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05B0
  ,simpleLowerCaseMapping:0x05B0
  ,simpleTitleCaseMapping:0x05B0
 },
 { code:0x05B1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05B1
  ,simpleLowerCaseMapping:0x05B1
  ,simpleTitleCaseMapping:0x05B1
 },
 { code:0x05B2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05B2
  ,simpleLowerCaseMapping:0x05B2
  ,simpleTitleCaseMapping:0x05B2
 },
 { code:0x05B3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05B3
  ,simpleLowerCaseMapping:0x05B3
  ,simpleTitleCaseMapping:0x05B3
 },
 { code:0x05B4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05B4
  ,simpleLowerCaseMapping:0x05B4
  ,simpleTitleCaseMapping:0x05B4
 },
 { code:0x05B5
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05B5
  ,simpleLowerCaseMapping:0x05B5
  ,simpleTitleCaseMapping:0x05B5
 },
 { code:0x05B6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05B6
  ,simpleLowerCaseMapping:0x05B6
  ,simpleTitleCaseMapping:0x05B6
 },
 { code:0x05B7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05B7
  ,simpleLowerCaseMapping:0x05B7
  ,simpleTitleCaseMapping:0x05B7
 },
 { code:0x05B8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05B8
  ,simpleLowerCaseMapping:0x05B8
  ,simpleTitleCaseMapping:0x05B8
 },
 { code:0x05B9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05B9
  ,simpleLowerCaseMapping:0x05B9
  ,simpleTitleCaseMapping:0x05B9
 },
 { code:0x05BA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05BA
  ,simpleLowerCaseMapping:0x05BA
  ,simpleTitleCaseMapping:0x05BA
 },
 { code:0x05BB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05BB
  ,simpleLowerCaseMapping:0x05BB
  ,simpleTitleCaseMapping:0x05BB
 },
 { code:0x05BC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05BC
  ,simpleLowerCaseMapping:0x05BC
  ,simpleTitleCaseMapping:0x05BC
 },
 { code:0x05BD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05BD
  ,simpleLowerCaseMapping:0x05BD
  ,simpleTitleCaseMapping:0x05BD
 },
 { code:0x05BE
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x05BE
  ,simpleLowerCaseMapping:0x05BE
  ,simpleTitleCaseMapping:0x05BE
 },
 { code:0x05BF
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05BF
  ,simpleLowerCaseMapping:0x05BF
  ,simpleTitleCaseMapping:0x05BF
 },
 { code:0x05C0
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x05C0
  ,simpleLowerCaseMapping:0x05C0
  ,simpleTitleCaseMapping:0x05C0
 },
 { code:0x05C1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05C1
  ,simpleLowerCaseMapping:0x05C1
  ,simpleTitleCaseMapping:0x05C1
 },
 { code:0x05C2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05C2
  ,simpleLowerCaseMapping:0x05C2
  ,simpleTitleCaseMapping:0x05C2
 },
 { code:0x05C3
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x05C3
  ,simpleLowerCaseMapping:0x05C3
  ,simpleTitleCaseMapping:0x05C3
 },
 { code:0x05C4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05C4
  ,simpleLowerCaseMapping:0x05C4
  ,simpleTitleCaseMapping:0x05C4
 },
 { code:0x05C5
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05C5
  ,simpleLowerCaseMapping:0x05C5
  ,simpleTitleCaseMapping:0x05C5
 },
 { code:0x05C6
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x05C6
  ,simpleLowerCaseMapping:0x05C6
  ,simpleTitleCaseMapping:0x05C6
 },
 { code:0x05C7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x05C7
  ,simpleLowerCaseMapping:0x05C7
  ,simpleTitleCaseMapping:0x05C7
 },
 { code:0x05D0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05D0
  ,simpleLowerCaseMapping:0x05D0
  ,simpleTitleCaseMapping:0x05D0
 },
 { code:0x05D1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05D1
  ,simpleLowerCaseMapping:0x05D1
  ,simpleTitleCaseMapping:0x05D1
 },
 { code:0x05D2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05D2
  ,simpleLowerCaseMapping:0x05D2
  ,simpleTitleCaseMapping:0x05D2
 },
 { code:0x05D3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05D3
  ,simpleLowerCaseMapping:0x05D3
  ,simpleTitleCaseMapping:0x05D3
 },
 { code:0x05D4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05D4
  ,simpleLowerCaseMapping:0x05D4
  ,simpleTitleCaseMapping:0x05D4
 },
 { code:0x05D5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05D5
  ,simpleLowerCaseMapping:0x05D5
  ,simpleTitleCaseMapping:0x05D5
 },
 { code:0x05D6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05D6
  ,simpleLowerCaseMapping:0x05D6
  ,simpleTitleCaseMapping:0x05D6
 },
 { code:0x05D7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05D7
  ,simpleLowerCaseMapping:0x05D7
  ,simpleTitleCaseMapping:0x05D7
 },
 { code:0x05D8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05D8
  ,simpleLowerCaseMapping:0x05D8
  ,simpleTitleCaseMapping:0x05D8
 },
 { code:0x05D9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05D9
  ,simpleLowerCaseMapping:0x05D9
  ,simpleTitleCaseMapping:0x05D9
 },
 { code:0x05DA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05DA
  ,simpleLowerCaseMapping:0x05DA
  ,simpleTitleCaseMapping:0x05DA
 },
 { code:0x05DB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05DB
  ,simpleLowerCaseMapping:0x05DB
  ,simpleTitleCaseMapping:0x05DB
 },
 { code:0x05DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05DC
  ,simpleLowerCaseMapping:0x05DC
  ,simpleTitleCaseMapping:0x05DC
 },
 { code:0x05DD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05DD
  ,simpleLowerCaseMapping:0x05DD
  ,simpleTitleCaseMapping:0x05DD
 },
 { code:0x05DE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05DE
  ,simpleLowerCaseMapping:0x05DE
  ,simpleTitleCaseMapping:0x05DE
 },
 { code:0x05DF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05DF
  ,simpleLowerCaseMapping:0x05DF
  ,simpleTitleCaseMapping:0x05DF
 },
 { code:0x05E0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05E0
  ,simpleLowerCaseMapping:0x05E0
  ,simpleTitleCaseMapping:0x05E0
 },
 { code:0x05E1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05E1
  ,simpleLowerCaseMapping:0x05E1
  ,simpleTitleCaseMapping:0x05E1
 },
 { code:0x05E2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05E2
  ,simpleLowerCaseMapping:0x05E2
  ,simpleTitleCaseMapping:0x05E2
 },
 { code:0x05E3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05E3
  ,simpleLowerCaseMapping:0x05E3
  ,simpleTitleCaseMapping:0x05E3
 },
 { code:0x05E4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05E4
  ,simpleLowerCaseMapping:0x05E4
  ,simpleTitleCaseMapping:0x05E4
 },
 { code:0x05E5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05E5
  ,simpleLowerCaseMapping:0x05E5
  ,simpleTitleCaseMapping:0x05E5
 },
 { code:0x05E6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05E6
  ,simpleLowerCaseMapping:0x05E6
  ,simpleTitleCaseMapping:0x05E6
 },
 { code:0x05E7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05E7
  ,simpleLowerCaseMapping:0x05E7
  ,simpleTitleCaseMapping:0x05E7
 },
 { code:0x05E8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05E8
  ,simpleLowerCaseMapping:0x05E8
  ,simpleTitleCaseMapping:0x05E8
 },
 { code:0x05E9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05E9
  ,simpleLowerCaseMapping:0x05E9
  ,simpleTitleCaseMapping:0x05E9
 },
 { code:0x05EA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05EA
  ,simpleLowerCaseMapping:0x05EA
  ,simpleTitleCaseMapping:0x05EA
 },
 { code:0x05F0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05F0
  ,simpleLowerCaseMapping:0x05F0
  ,simpleTitleCaseMapping:0x05F0
 },
 { code:0x05F1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05F1
  ,simpleLowerCaseMapping:0x05F1
  ,simpleTitleCaseMapping:0x05F1
 },
 { code:0x05F2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x05F2
  ,simpleLowerCaseMapping:0x05F2
  ,simpleTitleCaseMapping:0x05F2
 },
 { code:0x05F3
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x05F3
  ,simpleLowerCaseMapping:0x05F3
  ,simpleTitleCaseMapping:0x05F3
 },
 { code:0x05F4
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x05F4
  ,simpleLowerCaseMapping:0x05F4
  ,simpleTitleCaseMapping:0x05F4
 },
 { code:0x0600
  ,generalCategory:UnicodeData.GeneralCategory.Cf
  ,simpleUpperCaseMapping:0x0600
  ,simpleLowerCaseMapping:0x0600
  ,simpleTitleCaseMapping:0x0600
 },
 { code:0x0601
  ,generalCategory:UnicodeData.GeneralCategory.Cf
  ,simpleUpperCaseMapping:0x0601
  ,simpleLowerCaseMapping:0x0601
  ,simpleTitleCaseMapping:0x0601
 },
 { code:0x0602
  ,generalCategory:UnicodeData.GeneralCategory.Cf
  ,simpleUpperCaseMapping:0x0602
  ,simpleLowerCaseMapping:0x0602
  ,simpleTitleCaseMapping:0x0602
 },
 { code:0x0603
  ,generalCategory:UnicodeData.GeneralCategory.Cf
  ,simpleUpperCaseMapping:0x0603
  ,simpleLowerCaseMapping:0x0603
  ,simpleTitleCaseMapping:0x0603
 },
 { code:0x060B
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x060B
  ,simpleLowerCaseMapping:0x060B
  ,simpleTitleCaseMapping:0x060B
 },
 { code:0x060C
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x060C
  ,simpleLowerCaseMapping:0x060C
  ,simpleTitleCaseMapping:0x060C
 },
 { code:0x060D
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x060D
  ,simpleLowerCaseMapping:0x060D
  ,simpleTitleCaseMapping:0x060D
 },
 { code:0x060E
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x060E
  ,simpleLowerCaseMapping:0x060E
  ,simpleTitleCaseMapping:0x060E
 },
 { code:0x060F
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x060F
  ,simpleLowerCaseMapping:0x060F
  ,simpleTitleCaseMapping:0x060F
 },
 { code:0x0610
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0610
  ,simpleLowerCaseMapping:0x0610
  ,simpleTitleCaseMapping:0x0610
 },
 { code:0x0611
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0611
  ,simpleLowerCaseMapping:0x0611
  ,simpleTitleCaseMapping:0x0611
 },
 { code:0x0612
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0612
  ,simpleLowerCaseMapping:0x0612
  ,simpleTitleCaseMapping:0x0612
 },
 { code:0x0613
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0613
  ,simpleLowerCaseMapping:0x0613
  ,simpleTitleCaseMapping:0x0613
 },
 { code:0x0614
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0614
  ,simpleLowerCaseMapping:0x0614
  ,simpleTitleCaseMapping:0x0614
 },
 { code:0x0615
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0615
  ,simpleLowerCaseMapping:0x0615
  ,simpleTitleCaseMapping:0x0615
 },
 { code:0x061B
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x061B
  ,simpleLowerCaseMapping:0x061B
  ,simpleTitleCaseMapping:0x061B
 },
 { code:0x061E
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x061E
  ,simpleLowerCaseMapping:0x061E
  ,simpleTitleCaseMapping:0x061E
 },
 { code:0x061F
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x061F
  ,simpleLowerCaseMapping:0x061F
  ,simpleTitleCaseMapping:0x061F
 },
 { code:0x0621
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0621
  ,simpleLowerCaseMapping:0x0621
  ,simpleTitleCaseMapping:0x0621
 },
 { code:0x0622
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0622
  ,simpleLowerCaseMapping:0x0622
  ,simpleTitleCaseMapping:0x0622
 },
 { code:0x0623
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0623
  ,simpleLowerCaseMapping:0x0623
  ,simpleTitleCaseMapping:0x0623
 },
 { code:0x0624
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0624
  ,simpleLowerCaseMapping:0x0624
  ,simpleTitleCaseMapping:0x0624
 },
 { code:0x0625
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0625
  ,simpleLowerCaseMapping:0x0625
  ,simpleTitleCaseMapping:0x0625
 },
 { code:0x0626
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0626
  ,simpleLowerCaseMapping:0x0626
  ,simpleTitleCaseMapping:0x0626
 },
 { code:0x0627
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0627
  ,simpleLowerCaseMapping:0x0627
  ,simpleTitleCaseMapping:0x0627
 },
 { code:0x0628
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0628
  ,simpleLowerCaseMapping:0x0628
  ,simpleTitleCaseMapping:0x0628
 },
 { code:0x0629
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0629
  ,simpleLowerCaseMapping:0x0629
  ,simpleTitleCaseMapping:0x0629
 },
 { code:0x062A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x062A
  ,simpleLowerCaseMapping:0x062A
  ,simpleTitleCaseMapping:0x062A
 },
 { code:0x062B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x062B
  ,simpleLowerCaseMapping:0x062B
  ,simpleTitleCaseMapping:0x062B
 },
 { code:0x062C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x062C
  ,simpleLowerCaseMapping:0x062C
  ,simpleTitleCaseMapping:0x062C
 },
 { code:0x062D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x062D
  ,simpleLowerCaseMapping:0x062D
  ,simpleTitleCaseMapping:0x062D
 },
 { code:0x062E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x062E
  ,simpleLowerCaseMapping:0x062E
  ,simpleTitleCaseMapping:0x062E
 },
 { code:0x062F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x062F
  ,simpleLowerCaseMapping:0x062F
  ,simpleTitleCaseMapping:0x062F
 },
 { code:0x0630
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0630
  ,simpleLowerCaseMapping:0x0630
  ,simpleTitleCaseMapping:0x0630
 },
 { code:0x0631
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0631
  ,simpleLowerCaseMapping:0x0631
  ,simpleTitleCaseMapping:0x0631
 },
 { code:0x0632
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0632
  ,simpleLowerCaseMapping:0x0632
  ,simpleTitleCaseMapping:0x0632
 },
 { code:0x0633
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0633
  ,simpleLowerCaseMapping:0x0633
  ,simpleTitleCaseMapping:0x0633
 },
 { code:0x0634
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0634
  ,simpleLowerCaseMapping:0x0634
  ,simpleTitleCaseMapping:0x0634
 },
 { code:0x0635
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0635
  ,simpleLowerCaseMapping:0x0635
  ,simpleTitleCaseMapping:0x0635
 },
 { code:0x0636
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0636
  ,simpleLowerCaseMapping:0x0636
  ,simpleTitleCaseMapping:0x0636
 },
 { code:0x0637
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0637
  ,simpleLowerCaseMapping:0x0637
  ,simpleTitleCaseMapping:0x0637
 },
 { code:0x0638
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0638
  ,simpleLowerCaseMapping:0x0638
  ,simpleTitleCaseMapping:0x0638
 },
 { code:0x0639
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0639
  ,simpleLowerCaseMapping:0x0639
  ,simpleTitleCaseMapping:0x0639
 },
 { code:0x063A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x063A
  ,simpleLowerCaseMapping:0x063A
  ,simpleTitleCaseMapping:0x063A
 },
 { code:0x0640
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x0640
  ,simpleLowerCaseMapping:0x0640
  ,simpleTitleCaseMapping:0x0640
 },
 { code:0x0641
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0641
  ,simpleLowerCaseMapping:0x0641
  ,simpleTitleCaseMapping:0x0641
 },
 { code:0x0642
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0642
  ,simpleLowerCaseMapping:0x0642
  ,simpleTitleCaseMapping:0x0642
 },
 { code:0x0643
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0643
  ,simpleLowerCaseMapping:0x0643
  ,simpleTitleCaseMapping:0x0643
 },
 { code:0x0644
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0644
  ,simpleLowerCaseMapping:0x0644
  ,simpleTitleCaseMapping:0x0644
 },
 { code:0x0645
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0645
  ,simpleLowerCaseMapping:0x0645
  ,simpleTitleCaseMapping:0x0645
 },
 { code:0x0646
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0646
  ,simpleLowerCaseMapping:0x0646
  ,simpleTitleCaseMapping:0x0646
 },
 { code:0x0647
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0647
  ,simpleLowerCaseMapping:0x0647
  ,simpleTitleCaseMapping:0x0647
 },
 { code:0x0648
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0648
  ,simpleLowerCaseMapping:0x0648
  ,simpleTitleCaseMapping:0x0648
 },
 { code:0x0649
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0649
  ,simpleLowerCaseMapping:0x0649
  ,simpleTitleCaseMapping:0x0649
 },
 { code:0x064A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x064A
  ,simpleLowerCaseMapping:0x064A
  ,simpleTitleCaseMapping:0x064A
 },
 { code:0x064B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x064B
  ,simpleLowerCaseMapping:0x064B
  ,simpleTitleCaseMapping:0x064B
 },
 { code:0x064C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x064C
  ,simpleLowerCaseMapping:0x064C
  ,simpleTitleCaseMapping:0x064C
 },
 { code:0x064D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x064D
  ,simpleLowerCaseMapping:0x064D
  ,simpleTitleCaseMapping:0x064D
 },
 { code:0x064E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x064E
  ,simpleLowerCaseMapping:0x064E
  ,simpleTitleCaseMapping:0x064E
 },
 { code:0x064F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x064F
  ,simpleLowerCaseMapping:0x064F
  ,simpleTitleCaseMapping:0x064F
 },
 { code:0x0650
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0650
  ,simpleLowerCaseMapping:0x0650
  ,simpleTitleCaseMapping:0x0650
 },
 { code:0x0651
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0651
  ,simpleLowerCaseMapping:0x0651
  ,simpleTitleCaseMapping:0x0651
 },
 { code:0x0652
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0652
  ,simpleLowerCaseMapping:0x0652
  ,simpleTitleCaseMapping:0x0652
 },
 { code:0x0653
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0653
  ,simpleLowerCaseMapping:0x0653
  ,simpleTitleCaseMapping:0x0653
 },
 { code:0x0654
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0654
  ,simpleLowerCaseMapping:0x0654
  ,simpleTitleCaseMapping:0x0654
 },
 { code:0x0655
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0655
  ,simpleLowerCaseMapping:0x0655
  ,simpleTitleCaseMapping:0x0655
 },
 { code:0x0656
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0656
  ,simpleLowerCaseMapping:0x0656
  ,simpleTitleCaseMapping:0x0656
 },
 { code:0x0657
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0657
  ,simpleLowerCaseMapping:0x0657
  ,simpleTitleCaseMapping:0x0657
 },
 { code:0x0658
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0658
  ,simpleLowerCaseMapping:0x0658
  ,simpleTitleCaseMapping:0x0658
 },
 { code:0x0659
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0659
  ,simpleLowerCaseMapping:0x0659
  ,simpleTitleCaseMapping:0x0659
 },
 { code:0x065A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x065A
  ,simpleLowerCaseMapping:0x065A
  ,simpleTitleCaseMapping:0x065A
 },
 { code:0x065B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x065B
  ,simpleLowerCaseMapping:0x065B
  ,simpleTitleCaseMapping:0x065B
 },
 { code:0x065C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x065C
  ,simpleLowerCaseMapping:0x065C
  ,simpleTitleCaseMapping:0x065C
 },
 { code:0x065D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x065D
  ,simpleLowerCaseMapping:0x065D
  ,simpleTitleCaseMapping:0x065D
 },
 { code:0x065E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x065E
  ,simpleLowerCaseMapping:0x065E
  ,simpleTitleCaseMapping:0x065E
 },
 { code:0x0660
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0660
  ,simpleLowerCaseMapping:0x0660
  ,simpleTitleCaseMapping:0x0660
 },
 { code:0x0661
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0661
  ,simpleLowerCaseMapping:0x0661
  ,simpleTitleCaseMapping:0x0661
 },
 { code:0x0662
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0662
  ,simpleLowerCaseMapping:0x0662
  ,simpleTitleCaseMapping:0x0662
 },
 { code:0x0663
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0663
  ,simpleLowerCaseMapping:0x0663
  ,simpleTitleCaseMapping:0x0663
 },
 { code:0x0664
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0664
  ,simpleLowerCaseMapping:0x0664
  ,simpleTitleCaseMapping:0x0664
 },
 { code:0x0665
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0665
  ,simpleLowerCaseMapping:0x0665
  ,simpleTitleCaseMapping:0x0665
 },
 { code:0x0666
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0666
  ,simpleLowerCaseMapping:0x0666
  ,simpleTitleCaseMapping:0x0666
 },
 { code:0x0667
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0667
  ,simpleLowerCaseMapping:0x0667
  ,simpleTitleCaseMapping:0x0667
 },
 { code:0x0668
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0668
  ,simpleLowerCaseMapping:0x0668
  ,simpleTitleCaseMapping:0x0668
 },
 { code:0x0669
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0669
  ,simpleLowerCaseMapping:0x0669
  ,simpleTitleCaseMapping:0x0669
 },
 { code:0x066A
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x066A
  ,simpleLowerCaseMapping:0x066A
  ,simpleTitleCaseMapping:0x066A
 },
 { code:0x066B
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x066B
  ,simpleLowerCaseMapping:0x066B
  ,simpleTitleCaseMapping:0x066B
 },
 { code:0x066C
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x066C
  ,simpleLowerCaseMapping:0x066C
  ,simpleTitleCaseMapping:0x066C
 },
 { code:0x066D
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x066D
  ,simpleLowerCaseMapping:0x066D
  ,simpleTitleCaseMapping:0x066D
 },
 { code:0x066E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x066E
  ,simpleLowerCaseMapping:0x066E
  ,simpleTitleCaseMapping:0x066E
 },
 { code:0x066F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x066F
  ,simpleLowerCaseMapping:0x066F
  ,simpleTitleCaseMapping:0x066F
 },
 { code:0x0670
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0670
  ,simpleLowerCaseMapping:0x0670
  ,simpleTitleCaseMapping:0x0670
 },
 { code:0x0671
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0671
  ,simpleLowerCaseMapping:0x0671
  ,simpleTitleCaseMapping:0x0671
 },
 { code:0x0672
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0672
  ,simpleLowerCaseMapping:0x0672
  ,simpleTitleCaseMapping:0x0672
 },
 { code:0x0673
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0673
  ,simpleLowerCaseMapping:0x0673
  ,simpleTitleCaseMapping:0x0673
 },
 { code:0x0674
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0674
  ,simpleLowerCaseMapping:0x0674
  ,simpleTitleCaseMapping:0x0674
 },
 { code:0x0675
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0675
  ,simpleLowerCaseMapping:0x0675
  ,simpleTitleCaseMapping:0x0675
 },
 { code:0x0676
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0676
  ,simpleLowerCaseMapping:0x0676
  ,simpleTitleCaseMapping:0x0676
 },
 { code:0x0677
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0677
  ,simpleLowerCaseMapping:0x0677
  ,simpleTitleCaseMapping:0x0677
 },
 { code:0x0678
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0678
  ,simpleLowerCaseMapping:0x0678
  ,simpleTitleCaseMapping:0x0678
 },
 { code:0x0679
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0679
  ,simpleLowerCaseMapping:0x0679
  ,simpleTitleCaseMapping:0x0679
 },
 { code:0x067A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x067A
  ,simpleLowerCaseMapping:0x067A
  ,simpleTitleCaseMapping:0x067A
 },
 { code:0x067B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x067B
  ,simpleLowerCaseMapping:0x067B
  ,simpleTitleCaseMapping:0x067B
 },
 { code:0x067C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x067C
  ,simpleLowerCaseMapping:0x067C
  ,simpleTitleCaseMapping:0x067C
 },
 { code:0x067D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x067D
  ,simpleLowerCaseMapping:0x067D
  ,simpleTitleCaseMapping:0x067D
 },
 { code:0x067E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x067E
  ,simpleLowerCaseMapping:0x067E
  ,simpleTitleCaseMapping:0x067E
 },
 { code:0x067F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x067F
  ,simpleLowerCaseMapping:0x067F
  ,simpleTitleCaseMapping:0x067F
 },
 { code:0x0680
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0680
  ,simpleLowerCaseMapping:0x0680
  ,simpleTitleCaseMapping:0x0680
 },
 { code:0x0681
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0681
  ,simpleLowerCaseMapping:0x0681
  ,simpleTitleCaseMapping:0x0681
 },
 { code:0x0682
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0682
  ,simpleLowerCaseMapping:0x0682
  ,simpleTitleCaseMapping:0x0682
 },
 { code:0x0683
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0683
  ,simpleLowerCaseMapping:0x0683
  ,simpleTitleCaseMapping:0x0683
 },
 { code:0x0684
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0684
  ,simpleLowerCaseMapping:0x0684
  ,simpleTitleCaseMapping:0x0684
 },
 { code:0x0685
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0685
  ,simpleLowerCaseMapping:0x0685
  ,simpleTitleCaseMapping:0x0685
 },
 { code:0x0686
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0686
  ,simpleLowerCaseMapping:0x0686
  ,simpleTitleCaseMapping:0x0686
 },
 { code:0x0687
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0687
  ,simpleLowerCaseMapping:0x0687
  ,simpleTitleCaseMapping:0x0687
 },
 { code:0x0688
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0688
  ,simpleLowerCaseMapping:0x0688
  ,simpleTitleCaseMapping:0x0688
 },
 { code:0x0689
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0689
  ,simpleLowerCaseMapping:0x0689
  ,simpleTitleCaseMapping:0x0689
 },
 { code:0x068A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x068A
  ,simpleLowerCaseMapping:0x068A
  ,simpleTitleCaseMapping:0x068A
 },
 { code:0x068B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x068B
  ,simpleLowerCaseMapping:0x068B
  ,simpleTitleCaseMapping:0x068B
 },
 { code:0x068C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x068C
  ,simpleLowerCaseMapping:0x068C
  ,simpleTitleCaseMapping:0x068C
 },
 { code:0x068D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x068D
  ,simpleLowerCaseMapping:0x068D
  ,simpleTitleCaseMapping:0x068D
 },
 { code:0x068E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x068E
  ,simpleLowerCaseMapping:0x068E
  ,simpleTitleCaseMapping:0x068E
 },
 { code:0x068F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x068F
  ,simpleLowerCaseMapping:0x068F
  ,simpleTitleCaseMapping:0x068F
 },
 { code:0x0690
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0690
  ,simpleLowerCaseMapping:0x0690
  ,simpleTitleCaseMapping:0x0690
 },
 { code:0x0691
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0691
  ,simpleLowerCaseMapping:0x0691
  ,simpleTitleCaseMapping:0x0691
 },
 { code:0x0692
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0692
  ,simpleLowerCaseMapping:0x0692
  ,simpleTitleCaseMapping:0x0692
 },
 { code:0x0693
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0693
  ,simpleLowerCaseMapping:0x0693
  ,simpleTitleCaseMapping:0x0693
 },
 { code:0x0694
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0694
  ,simpleLowerCaseMapping:0x0694
  ,simpleTitleCaseMapping:0x0694
 },
 { code:0x0695
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0695
  ,simpleLowerCaseMapping:0x0695
  ,simpleTitleCaseMapping:0x0695
 },
 { code:0x0696
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0696
  ,simpleLowerCaseMapping:0x0696
  ,simpleTitleCaseMapping:0x0696
 },
 { code:0x0697
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0697
  ,simpleLowerCaseMapping:0x0697
  ,simpleTitleCaseMapping:0x0697
 },
 { code:0x0698
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0698
  ,simpleLowerCaseMapping:0x0698
  ,simpleTitleCaseMapping:0x0698
 },
 { code:0x0699
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0699
  ,simpleLowerCaseMapping:0x0699
  ,simpleTitleCaseMapping:0x0699
 },
 { code:0x069A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x069A
  ,simpleLowerCaseMapping:0x069A
  ,simpleTitleCaseMapping:0x069A
 },
 { code:0x069B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x069B
  ,simpleLowerCaseMapping:0x069B
  ,simpleTitleCaseMapping:0x069B
 },
 { code:0x069C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x069C
  ,simpleLowerCaseMapping:0x069C
  ,simpleTitleCaseMapping:0x069C
 },
 { code:0x069D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x069D
  ,simpleLowerCaseMapping:0x069D
  ,simpleTitleCaseMapping:0x069D
 },
 { code:0x069E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x069E
  ,simpleLowerCaseMapping:0x069E
  ,simpleTitleCaseMapping:0x069E
 },
 { code:0x069F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x069F
  ,simpleLowerCaseMapping:0x069F
  ,simpleTitleCaseMapping:0x069F
 },
 { code:0x06A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06A0
  ,simpleLowerCaseMapping:0x06A0
  ,simpleTitleCaseMapping:0x06A0
 },
 { code:0x06A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06A1
  ,simpleLowerCaseMapping:0x06A1
  ,simpleTitleCaseMapping:0x06A1
 },
 { code:0x06A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06A2
  ,simpleLowerCaseMapping:0x06A2
  ,simpleTitleCaseMapping:0x06A2
 },
 { code:0x06A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06A3
  ,simpleLowerCaseMapping:0x06A3
  ,simpleTitleCaseMapping:0x06A3
 },
 { code:0x06A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06A4
  ,simpleLowerCaseMapping:0x06A4
  ,simpleTitleCaseMapping:0x06A4
 },
 { code:0x06A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06A5
  ,simpleLowerCaseMapping:0x06A5
  ,simpleTitleCaseMapping:0x06A5
 },
 { code:0x06A6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06A6
  ,simpleLowerCaseMapping:0x06A6
  ,simpleTitleCaseMapping:0x06A6
 },
 { code:0x06A7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06A7
  ,simpleLowerCaseMapping:0x06A7
  ,simpleTitleCaseMapping:0x06A7
 },
 { code:0x06A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06A8
  ,simpleLowerCaseMapping:0x06A8
  ,simpleTitleCaseMapping:0x06A8
 },
 { code:0x06A9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06A9
  ,simpleLowerCaseMapping:0x06A9
  ,simpleTitleCaseMapping:0x06A9
 },
 { code:0x06AA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06AA
  ,simpleLowerCaseMapping:0x06AA
  ,simpleTitleCaseMapping:0x06AA
 },
 { code:0x06AB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06AB
  ,simpleLowerCaseMapping:0x06AB
  ,simpleTitleCaseMapping:0x06AB
 },
 { code:0x06AC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06AC
  ,simpleLowerCaseMapping:0x06AC
  ,simpleTitleCaseMapping:0x06AC
 },
 { code:0x06AD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06AD
  ,simpleLowerCaseMapping:0x06AD
  ,simpleTitleCaseMapping:0x06AD
 },
 { code:0x06AE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06AE
  ,simpleLowerCaseMapping:0x06AE
  ,simpleTitleCaseMapping:0x06AE
 },
 { code:0x06AF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06AF
  ,simpleLowerCaseMapping:0x06AF
  ,simpleTitleCaseMapping:0x06AF
 },
 { code:0x06B0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06B0
  ,simpleLowerCaseMapping:0x06B0
  ,simpleTitleCaseMapping:0x06B0
 },
 { code:0x06B1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06B1
  ,simpleLowerCaseMapping:0x06B1
  ,simpleTitleCaseMapping:0x06B1
 },
 { code:0x06B2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06B2
  ,simpleLowerCaseMapping:0x06B2
  ,simpleTitleCaseMapping:0x06B2
 },
 { code:0x06B3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06B3
  ,simpleLowerCaseMapping:0x06B3
  ,simpleTitleCaseMapping:0x06B3
 },
 { code:0x06B4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06B4
  ,simpleLowerCaseMapping:0x06B4
  ,simpleTitleCaseMapping:0x06B4
 },
 { code:0x06B5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06B5
  ,simpleLowerCaseMapping:0x06B5
  ,simpleTitleCaseMapping:0x06B5
 },
 { code:0x06B6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06B6
  ,simpleLowerCaseMapping:0x06B6
  ,simpleTitleCaseMapping:0x06B6
 },
 { code:0x06B7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06B7
  ,simpleLowerCaseMapping:0x06B7
  ,simpleTitleCaseMapping:0x06B7
 },
 { code:0x06B8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06B8
  ,simpleLowerCaseMapping:0x06B8
  ,simpleTitleCaseMapping:0x06B8
 },
 { code:0x06B9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06B9
  ,simpleLowerCaseMapping:0x06B9
  ,simpleTitleCaseMapping:0x06B9
 },
 { code:0x06BA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06BA
  ,simpleLowerCaseMapping:0x06BA
  ,simpleTitleCaseMapping:0x06BA
 },
 { code:0x06BB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06BB
  ,simpleLowerCaseMapping:0x06BB
  ,simpleTitleCaseMapping:0x06BB
 },
 { code:0x06BC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06BC
  ,simpleLowerCaseMapping:0x06BC
  ,simpleTitleCaseMapping:0x06BC
 },
 { code:0x06BD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06BD
  ,simpleLowerCaseMapping:0x06BD
  ,simpleTitleCaseMapping:0x06BD
 },
 { code:0x06BE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06BE
  ,simpleLowerCaseMapping:0x06BE
  ,simpleTitleCaseMapping:0x06BE
 },
 { code:0x06BF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06BF
  ,simpleLowerCaseMapping:0x06BF
  ,simpleTitleCaseMapping:0x06BF
 },
 { code:0x06C0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06C0
  ,simpleLowerCaseMapping:0x06C0
  ,simpleTitleCaseMapping:0x06C0
 },
 { code:0x06C1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06C1
  ,simpleLowerCaseMapping:0x06C1
  ,simpleTitleCaseMapping:0x06C1
 },
 { code:0x06C2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06C2
  ,simpleLowerCaseMapping:0x06C2
  ,simpleTitleCaseMapping:0x06C2
 },
 { code:0x06C3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06C3
  ,simpleLowerCaseMapping:0x06C3
  ,simpleTitleCaseMapping:0x06C3
 },
 { code:0x06C4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06C4
  ,simpleLowerCaseMapping:0x06C4
  ,simpleTitleCaseMapping:0x06C4
 },
 { code:0x06C5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06C5
  ,simpleLowerCaseMapping:0x06C5
  ,simpleTitleCaseMapping:0x06C5
 },
 { code:0x06C6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06C6
  ,simpleLowerCaseMapping:0x06C6
  ,simpleTitleCaseMapping:0x06C6
 },
 { code:0x06C7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06C7
  ,simpleLowerCaseMapping:0x06C7
  ,simpleTitleCaseMapping:0x06C7
 },
 { code:0x06C8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06C8
  ,simpleLowerCaseMapping:0x06C8
  ,simpleTitleCaseMapping:0x06C8
 },
 { code:0x06C9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06C9
  ,simpleLowerCaseMapping:0x06C9
  ,simpleTitleCaseMapping:0x06C9
 },
 { code:0x06CA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06CA
  ,simpleLowerCaseMapping:0x06CA
  ,simpleTitleCaseMapping:0x06CA
 },
 { code:0x06CB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06CB
  ,simpleLowerCaseMapping:0x06CB
  ,simpleTitleCaseMapping:0x06CB
 },
 { code:0x06CC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06CC
  ,simpleLowerCaseMapping:0x06CC
  ,simpleTitleCaseMapping:0x06CC
 },
 { code:0x06CD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06CD
  ,simpleLowerCaseMapping:0x06CD
  ,simpleTitleCaseMapping:0x06CD
 },
 { code:0x06CE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06CE
  ,simpleLowerCaseMapping:0x06CE
  ,simpleTitleCaseMapping:0x06CE
 },
 { code:0x06CF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06CF
  ,simpleLowerCaseMapping:0x06CF
  ,simpleTitleCaseMapping:0x06CF
 },
 { code:0x06D0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06D0
  ,simpleLowerCaseMapping:0x06D0
  ,simpleTitleCaseMapping:0x06D0
 },
 { code:0x06D1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06D1
  ,simpleLowerCaseMapping:0x06D1
  ,simpleTitleCaseMapping:0x06D1
 },
 { code:0x06D2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06D2
  ,simpleLowerCaseMapping:0x06D2
  ,simpleTitleCaseMapping:0x06D2
 },
 { code:0x06D3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06D3
  ,simpleLowerCaseMapping:0x06D3
  ,simpleTitleCaseMapping:0x06D3
 },
 { code:0x06D4
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x06D4
  ,simpleLowerCaseMapping:0x06D4
  ,simpleTitleCaseMapping:0x06D4
 },
 { code:0x06D5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06D5
  ,simpleLowerCaseMapping:0x06D5
  ,simpleTitleCaseMapping:0x06D5
 },
 { code:0x06D6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06D6
  ,simpleLowerCaseMapping:0x06D6
  ,simpleTitleCaseMapping:0x06D6
 },
 { code:0x06D7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06D7
  ,simpleLowerCaseMapping:0x06D7
  ,simpleTitleCaseMapping:0x06D7
 },
 { code:0x06D8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06D8
  ,simpleLowerCaseMapping:0x06D8
  ,simpleTitleCaseMapping:0x06D8
 },
 { code:0x06D9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06D9
  ,simpleLowerCaseMapping:0x06D9
  ,simpleTitleCaseMapping:0x06D9
 },
 { code:0x06DA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06DA
  ,simpleLowerCaseMapping:0x06DA
  ,simpleTitleCaseMapping:0x06DA
 },
 { code:0x06DB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06DB
  ,simpleLowerCaseMapping:0x06DB
  ,simpleTitleCaseMapping:0x06DB
 },
 { code:0x06DC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06DC
  ,simpleLowerCaseMapping:0x06DC
  ,simpleTitleCaseMapping:0x06DC
 },
 { code:0x06DD
  ,generalCategory:UnicodeData.GeneralCategory.Cf
  ,simpleUpperCaseMapping:0x06DD
  ,simpleLowerCaseMapping:0x06DD
  ,simpleTitleCaseMapping:0x06DD
 },
 { code:0x06DE
  ,generalCategory:UnicodeData.GeneralCategory.Me
  ,simpleUpperCaseMapping:0x06DE
  ,simpleLowerCaseMapping:0x06DE
  ,simpleTitleCaseMapping:0x06DE
 },
 { code:0x06DF
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06DF
  ,simpleLowerCaseMapping:0x06DF
  ,simpleTitleCaseMapping:0x06DF
 },
 { code:0x06E0
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06E0
  ,simpleLowerCaseMapping:0x06E0
  ,simpleTitleCaseMapping:0x06E0
 },
 { code:0x06E1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06E1
  ,simpleLowerCaseMapping:0x06E1
  ,simpleTitleCaseMapping:0x06E1
 },
 { code:0x06E2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06E2
  ,simpleLowerCaseMapping:0x06E2
  ,simpleTitleCaseMapping:0x06E2
 },
 { code:0x06E3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06E3
  ,simpleLowerCaseMapping:0x06E3
  ,simpleTitleCaseMapping:0x06E3
 },
 { code:0x06E4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06E4
  ,simpleLowerCaseMapping:0x06E4
  ,simpleTitleCaseMapping:0x06E4
 },
 { code:0x06E5
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x06E5
  ,simpleLowerCaseMapping:0x06E5
  ,simpleTitleCaseMapping:0x06E5
 },
 { code:0x06E6
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x06E6
  ,simpleLowerCaseMapping:0x06E6
  ,simpleTitleCaseMapping:0x06E6
 },
 { code:0x06E7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06E7
  ,simpleLowerCaseMapping:0x06E7
  ,simpleTitleCaseMapping:0x06E7
 },
 { code:0x06E8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06E8
  ,simpleLowerCaseMapping:0x06E8
  ,simpleTitleCaseMapping:0x06E8
 },
 { code:0x06E9
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x06E9
  ,simpleLowerCaseMapping:0x06E9
  ,simpleTitleCaseMapping:0x06E9
 },
 { code:0x06EA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06EA
  ,simpleLowerCaseMapping:0x06EA
  ,simpleTitleCaseMapping:0x06EA
 },
 { code:0x06EB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06EB
  ,simpleLowerCaseMapping:0x06EB
  ,simpleTitleCaseMapping:0x06EB
 },
 { code:0x06EC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06EC
  ,simpleLowerCaseMapping:0x06EC
  ,simpleTitleCaseMapping:0x06EC
 },
 { code:0x06ED
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x06ED
  ,simpleLowerCaseMapping:0x06ED
  ,simpleTitleCaseMapping:0x06ED
 },
 { code:0x06EE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06EE
  ,simpleLowerCaseMapping:0x06EE
  ,simpleTitleCaseMapping:0x06EE
 },
 { code:0x06EF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06EF
  ,simpleLowerCaseMapping:0x06EF
  ,simpleTitleCaseMapping:0x06EF
 },
 { code:0x06F0
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x06F0
  ,simpleLowerCaseMapping:0x06F0
  ,simpleTitleCaseMapping:0x06F0
 },
 { code:0x06F1
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x06F1
  ,simpleLowerCaseMapping:0x06F1
  ,simpleTitleCaseMapping:0x06F1
 },
 { code:0x06F2
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x06F2
  ,simpleLowerCaseMapping:0x06F2
  ,simpleTitleCaseMapping:0x06F2
 },
 { code:0x06F3
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x06F3
  ,simpleLowerCaseMapping:0x06F3
  ,simpleTitleCaseMapping:0x06F3
 },
 { code:0x06F4
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x06F4
  ,simpleLowerCaseMapping:0x06F4
  ,simpleTitleCaseMapping:0x06F4
 },
 { code:0x06F5
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x06F5
  ,simpleLowerCaseMapping:0x06F5
  ,simpleTitleCaseMapping:0x06F5
 },
 { code:0x06F6
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x06F6
  ,simpleLowerCaseMapping:0x06F6
  ,simpleTitleCaseMapping:0x06F6
 },
 { code:0x06F7
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x06F7
  ,simpleLowerCaseMapping:0x06F7
  ,simpleTitleCaseMapping:0x06F7
 },
 { code:0x06F8
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x06F8
  ,simpleLowerCaseMapping:0x06F8
  ,simpleTitleCaseMapping:0x06F8
 },
 { code:0x06F9
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x06F9
  ,simpleLowerCaseMapping:0x06F9
  ,simpleTitleCaseMapping:0x06F9
 },
 { code:0x06FA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06FA
  ,simpleLowerCaseMapping:0x06FA
  ,simpleTitleCaseMapping:0x06FA
 },
 { code:0x06FB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06FB
  ,simpleLowerCaseMapping:0x06FB
  ,simpleTitleCaseMapping:0x06FB
 },
 { code:0x06FC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06FC
  ,simpleLowerCaseMapping:0x06FC
  ,simpleTitleCaseMapping:0x06FC
 },
 { code:0x06FD
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x06FD
  ,simpleLowerCaseMapping:0x06FD
  ,simpleTitleCaseMapping:0x06FD
 },
 { code:0x06FE
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x06FE
  ,simpleLowerCaseMapping:0x06FE
  ,simpleTitleCaseMapping:0x06FE
 },
 { code:0x06FF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x06FF
  ,simpleLowerCaseMapping:0x06FF
  ,simpleTitleCaseMapping:0x06FF
 },
 { code:0x0700
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0700
  ,simpleLowerCaseMapping:0x0700
  ,simpleTitleCaseMapping:0x0700
 },
 { code:0x0701
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0701
  ,simpleLowerCaseMapping:0x0701
  ,simpleTitleCaseMapping:0x0701
 },
 { code:0x0702
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0702
  ,simpleLowerCaseMapping:0x0702
  ,simpleTitleCaseMapping:0x0702
 },
 { code:0x0703
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0703
  ,simpleLowerCaseMapping:0x0703
  ,simpleTitleCaseMapping:0x0703
 },
 { code:0x0704
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0704
  ,simpleLowerCaseMapping:0x0704
  ,simpleTitleCaseMapping:0x0704
 },
 { code:0x0705
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0705
  ,simpleLowerCaseMapping:0x0705
  ,simpleTitleCaseMapping:0x0705
 },
 { code:0x0706
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0706
  ,simpleLowerCaseMapping:0x0706
  ,simpleTitleCaseMapping:0x0706
 },
 { code:0x0707
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0707
  ,simpleLowerCaseMapping:0x0707
  ,simpleTitleCaseMapping:0x0707
 },
 { code:0x0708
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0708
  ,simpleLowerCaseMapping:0x0708
  ,simpleTitleCaseMapping:0x0708
 },
 { code:0x0709
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0709
  ,simpleLowerCaseMapping:0x0709
  ,simpleTitleCaseMapping:0x0709
 },
 { code:0x070A
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x070A
  ,simpleLowerCaseMapping:0x070A
  ,simpleTitleCaseMapping:0x070A
 },
 { code:0x070B
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x070B
  ,simpleLowerCaseMapping:0x070B
  ,simpleTitleCaseMapping:0x070B
 },
 { code:0x070C
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x070C
  ,simpleLowerCaseMapping:0x070C
  ,simpleTitleCaseMapping:0x070C
 },
 { code:0x070D
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x070D
  ,simpleLowerCaseMapping:0x070D
  ,simpleTitleCaseMapping:0x070D
 },
 { code:0x070F
  ,generalCategory:UnicodeData.GeneralCategory.Cf
  ,simpleUpperCaseMapping:0x070F
  ,simpleLowerCaseMapping:0x070F
  ,simpleTitleCaseMapping:0x070F
 },
 { code:0x0710
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0710
  ,simpleLowerCaseMapping:0x0710
  ,simpleTitleCaseMapping:0x0710
 },
 { code:0x0711
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0711
  ,simpleLowerCaseMapping:0x0711
  ,simpleTitleCaseMapping:0x0711
 },
 { code:0x0712
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0712
  ,simpleLowerCaseMapping:0x0712
  ,simpleTitleCaseMapping:0x0712
 },
 { code:0x0713
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0713
  ,simpleLowerCaseMapping:0x0713
  ,simpleTitleCaseMapping:0x0713
 },
 { code:0x0714
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0714
  ,simpleLowerCaseMapping:0x0714
  ,simpleTitleCaseMapping:0x0714
 },
 { code:0x0715
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0715
  ,simpleLowerCaseMapping:0x0715
  ,simpleTitleCaseMapping:0x0715
 },
 { code:0x0716
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0716
  ,simpleLowerCaseMapping:0x0716
  ,simpleTitleCaseMapping:0x0716
 },
 { code:0x0717
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0717
  ,simpleLowerCaseMapping:0x0717
  ,simpleTitleCaseMapping:0x0717
 },
 { code:0x0718
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0718
  ,simpleLowerCaseMapping:0x0718
  ,simpleTitleCaseMapping:0x0718
 },
 { code:0x0719
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0719
  ,simpleLowerCaseMapping:0x0719
  ,simpleTitleCaseMapping:0x0719
 },
 { code:0x071A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x071A
  ,simpleLowerCaseMapping:0x071A
  ,simpleTitleCaseMapping:0x071A
 },
 { code:0x071B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x071B
  ,simpleLowerCaseMapping:0x071B
  ,simpleTitleCaseMapping:0x071B
 },
 { code:0x071C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x071C
  ,simpleLowerCaseMapping:0x071C
  ,simpleTitleCaseMapping:0x071C
 },
 { code:0x071D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x071D
  ,simpleLowerCaseMapping:0x071D
  ,simpleTitleCaseMapping:0x071D
 },
 { code:0x071E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x071E
  ,simpleLowerCaseMapping:0x071E
  ,simpleTitleCaseMapping:0x071E
 },
 { code:0x071F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x071F
  ,simpleLowerCaseMapping:0x071F
  ,simpleTitleCaseMapping:0x071F
 },
 { code:0x0720
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0720
  ,simpleLowerCaseMapping:0x0720
  ,simpleTitleCaseMapping:0x0720
 },
 { code:0x0721
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0721
  ,simpleLowerCaseMapping:0x0721
  ,simpleTitleCaseMapping:0x0721
 },
 { code:0x0722
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0722
  ,simpleLowerCaseMapping:0x0722
  ,simpleTitleCaseMapping:0x0722
 },
 { code:0x0723
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0723
  ,simpleLowerCaseMapping:0x0723
  ,simpleTitleCaseMapping:0x0723
 },
 { code:0x0724
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0724
  ,simpleLowerCaseMapping:0x0724
  ,simpleTitleCaseMapping:0x0724
 },
 { code:0x0725
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0725
  ,simpleLowerCaseMapping:0x0725
  ,simpleTitleCaseMapping:0x0725
 },
 { code:0x0726
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0726
  ,simpleLowerCaseMapping:0x0726
  ,simpleTitleCaseMapping:0x0726
 },
 { code:0x0727
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0727
  ,simpleLowerCaseMapping:0x0727
  ,simpleTitleCaseMapping:0x0727
 },
 { code:0x0728
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0728
  ,simpleLowerCaseMapping:0x0728
  ,simpleTitleCaseMapping:0x0728
 },
 { code:0x0729
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0729
  ,simpleLowerCaseMapping:0x0729
  ,simpleTitleCaseMapping:0x0729
 },
 { code:0x072A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x072A
  ,simpleLowerCaseMapping:0x072A
  ,simpleTitleCaseMapping:0x072A
 },
 { code:0x072B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x072B
  ,simpleLowerCaseMapping:0x072B
  ,simpleTitleCaseMapping:0x072B
 },
 { code:0x072C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x072C
  ,simpleLowerCaseMapping:0x072C
  ,simpleTitleCaseMapping:0x072C
 },
 { code:0x072D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x072D
  ,simpleLowerCaseMapping:0x072D
  ,simpleTitleCaseMapping:0x072D
 },
 { code:0x072E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x072E
  ,simpleLowerCaseMapping:0x072E
  ,simpleTitleCaseMapping:0x072E
 },
 { code:0x072F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x072F
  ,simpleLowerCaseMapping:0x072F
  ,simpleTitleCaseMapping:0x072F
 },
 { code:0x0730
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0730
  ,simpleLowerCaseMapping:0x0730
  ,simpleTitleCaseMapping:0x0730
 },
 { code:0x0731
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0731
  ,simpleLowerCaseMapping:0x0731
  ,simpleTitleCaseMapping:0x0731
 },
 { code:0x0732
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0732
  ,simpleLowerCaseMapping:0x0732
  ,simpleTitleCaseMapping:0x0732
 },
 { code:0x0733
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0733
  ,simpleLowerCaseMapping:0x0733
  ,simpleTitleCaseMapping:0x0733
 },
 { code:0x0734
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0734
  ,simpleLowerCaseMapping:0x0734
  ,simpleTitleCaseMapping:0x0734
 },
 { code:0x0735
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0735
  ,simpleLowerCaseMapping:0x0735
  ,simpleTitleCaseMapping:0x0735
 },
 { code:0x0736
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0736
  ,simpleLowerCaseMapping:0x0736
  ,simpleTitleCaseMapping:0x0736
 },
 { code:0x0737
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0737
  ,simpleLowerCaseMapping:0x0737
  ,simpleTitleCaseMapping:0x0737
 },
 { code:0x0738
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0738
  ,simpleLowerCaseMapping:0x0738
  ,simpleTitleCaseMapping:0x0738
 },
 { code:0x0739
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0739
  ,simpleLowerCaseMapping:0x0739
  ,simpleTitleCaseMapping:0x0739
 },
 { code:0x073A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x073A
  ,simpleLowerCaseMapping:0x073A
  ,simpleTitleCaseMapping:0x073A
 },
 { code:0x073B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x073B
  ,simpleLowerCaseMapping:0x073B
  ,simpleTitleCaseMapping:0x073B
 },
 { code:0x073C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x073C
  ,simpleLowerCaseMapping:0x073C
  ,simpleTitleCaseMapping:0x073C
 },
 { code:0x073D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x073D
  ,simpleLowerCaseMapping:0x073D
  ,simpleTitleCaseMapping:0x073D
 },
 { code:0x073E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x073E
  ,simpleLowerCaseMapping:0x073E
  ,simpleTitleCaseMapping:0x073E
 },
 { code:0x073F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x073F
  ,simpleLowerCaseMapping:0x073F
  ,simpleTitleCaseMapping:0x073F
 },
 { code:0x0740
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0740
  ,simpleLowerCaseMapping:0x0740
  ,simpleTitleCaseMapping:0x0740
 },
 { code:0x0741
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0741
  ,simpleLowerCaseMapping:0x0741
  ,simpleTitleCaseMapping:0x0741
 },
 { code:0x0742
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0742
  ,simpleLowerCaseMapping:0x0742
  ,simpleTitleCaseMapping:0x0742
 },
 { code:0x0743
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0743
  ,simpleLowerCaseMapping:0x0743
  ,simpleTitleCaseMapping:0x0743
 },
 { code:0x0744
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0744
  ,simpleLowerCaseMapping:0x0744
  ,simpleTitleCaseMapping:0x0744
 },
 { code:0x0745
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0745
  ,simpleLowerCaseMapping:0x0745
  ,simpleTitleCaseMapping:0x0745
 },
 { code:0x0746
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0746
  ,simpleLowerCaseMapping:0x0746
  ,simpleTitleCaseMapping:0x0746
 },
 { code:0x0747
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0747
  ,simpleLowerCaseMapping:0x0747
  ,simpleTitleCaseMapping:0x0747
 },
 { code:0x0748
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0748
  ,simpleLowerCaseMapping:0x0748
  ,simpleTitleCaseMapping:0x0748
 },
 { code:0x0749
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0749
  ,simpleLowerCaseMapping:0x0749
  ,simpleTitleCaseMapping:0x0749
 },
 { code:0x074A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x074A
  ,simpleLowerCaseMapping:0x074A
  ,simpleTitleCaseMapping:0x074A
 },
 { code:0x074D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x074D
  ,simpleLowerCaseMapping:0x074D
  ,simpleTitleCaseMapping:0x074D
 },
 { code:0x074E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x074E
  ,simpleLowerCaseMapping:0x074E
  ,simpleTitleCaseMapping:0x074E
 },
 { code:0x074F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x074F
  ,simpleLowerCaseMapping:0x074F
  ,simpleTitleCaseMapping:0x074F
 },
 { code:0x0750
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0750
  ,simpleLowerCaseMapping:0x0750
  ,simpleTitleCaseMapping:0x0750
 },
 { code:0x0751
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0751
  ,simpleLowerCaseMapping:0x0751
  ,simpleTitleCaseMapping:0x0751
 },
 { code:0x0752
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0752
  ,simpleLowerCaseMapping:0x0752
  ,simpleTitleCaseMapping:0x0752
 },
 { code:0x0753
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0753
  ,simpleLowerCaseMapping:0x0753
  ,simpleTitleCaseMapping:0x0753
 },
 { code:0x0754
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0754
  ,simpleLowerCaseMapping:0x0754
  ,simpleTitleCaseMapping:0x0754
 },
 { code:0x0755
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0755
  ,simpleLowerCaseMapping:0x0755
  ,simpleTitleCaseMapping:0x0755
 },
 { code:0x0756
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0756
  ,simpleLowerCaseMapping:0x0756
  ,simpleTitleCaseMapping:0x0756
 },
 { code:0x0757
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0757
  ,simpleLowerCaseMapping:0x0757
  ,simpleTitleCaseMapping:0x0757
 },
 { code:0x0758
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0758
  ,simpleLowerCaseMapping:0x0758
  ,simpleTitleCaseMapping:0x0758
 },
 { code:0x0759
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0759
  ,simpleLowerCaseMapping:0x0759
  ,simpleTitleCaseMapping:0x0759
 },
 { code:0x075A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x075A
  ,simpleLowerCaseMapping:0x075A
  ,simpleTitleCaseMapping:0x075A
 },
 { code:0x075B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x075B
  ,simpleLowerCaseMapping:0x075B
  ,simpleTitleCaseMapping:0x075B
 },
 { code:0x075C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x075C
  ,simpleLowerCaseMapping:0x075C
  ,simpleTitleCaseMapping:0x075C
 },
 { code:0x075D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x075D
  ,simpleLowerCaseMapping:0x075D
  ,simpleTitleCaseMapping:0x075D
 },
 { code:0x075E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x075E
  ,simpleLowerCaseMapping:0x075E
  ,simpleTitleCaseMapping:0x075E
 },
 { code:0x075F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x075F
  ,simpleLowerCaseMapping:0x075F
  ,simpleTitleCaseMapping:0x075F
 },
 { code:0x0760
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0760
  ,simpleLowerCaseMapping:0x0760
  ,simpleTitleCaseMapping:0x0760
 },
 { code:0x0761
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0761
  ,simpleLowerCaseMapping:0x0761
  ,simpleTitleCaseMapping:0x0761
 },
 { code:0x0762
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0762
  ,simpleLowerCaseMapping:0x0762
  ,simpleTitleCaseMapping:0x0762
 },
 { code:0x0763
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0763
  ,simpleLowerCaseMapping:0x0763
  ,simpleTitleCaseMapping:0x0763
 },
 { code:0x0764
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0764
  ,simpleLowerCaseMapping:0x0764
  ,simpleTitleCaseMapping:0x0764
 },
 { code:0x0765
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0765
  ,simpleLowerCaseMapping:0x0765
  ,simpleTitleCaseMapping:0x0765
 },
 { code:0x0766
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0766
  ,simpleLowerCaseMapping:0x0766
  ,simpleTitleCaseMapping:0x0766
 },
 { code:0x0767
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0767
  ,simpleLowerCaseMapping:0x0767
  ,simpleTitleCaseMapping:0x0767
 },
 { code:0x0768
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0768
  ,simpleLowerCaseMapping:0x0768
  ,simpleTitleCaseMapping:0x0768
 },
 { code:0x0769
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0769
  ,simpleLowerCaseMapping:0x0769
  ,simpleTitleCaseMapping:0x0769
 },
 { code:0x076A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x076A
  ,simpleLowerCaseMapping:0x076A
  ,simpleTitleCaseMapping:0x076A
 },
 { code:0x076B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x076B
  ,simpleLowerCaseMapping:0x076B
  ,simpleTitleCaseMapping:0x076B
 },
 { code:0x076C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x076C
  ,simpleLowerCaseMapping:0x076C
  ,simpleTitleCaseMapping:0x076C
 },
 { code:0x076D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x076D
  ,simpleLowerCaseMapping:0x076D
  ,simpleTitleCaseMapping:0x076D
 },
 { code:0x0780
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0780
  ,simpleLowerCaseMapping:0x0780
  ,simpleTitleCaseMapping:0x0780
 },
 { code:0x0781
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0781
  ,simpleLowerCaseMapping:0x0781
  ,simpleTitleCaseMapping:0x0781
 },
 { code:0x0782
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0782
  ,simpleLowerCaseMapping:0x0782
  ,simpleTitleCaseMapping:0x0782
 },
 { code:0x0783
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0783
  ,simpleLowerCaseMapping:0x0783
  ,simpleTitleCaseMapping:0x0783
 },
 { code:0x0784
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0784
  ,simpleLowerCaseMapping:0x0784
  ,simpleTitleCaseMapping:0x0784
 },
 { code:0x0785
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0785
  ,simpleLowerCaseMapping:0x0785
  ,simpleTitleCaseMapping:0x0785
 },
 { code:0x0786
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0786
  ,simpleLowerCaseMapping:0x0786
  ,simpleTitleCaseMapping:0x0786
 },
 { code:0x0787
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0787
  ,simpleLowerCaseMapping:0x0787
  ,simpleTitleCaseMapping:0x0787
 },
 { code:0x0788
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0788
  ,simpleLowerCaseMapping:0x0788
  ,simpleTitleCaseMapping:0x0788
 },
 { code:0x0789
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0789
  ,simpleLowerCaseMapping:0x0789
  ,simpleTitleCaseMapping:0x0789
 },
 { code:0x078A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x078A
  ,simpleLowerCaseMapping:0x078A
  ,simpleTitleCaseMapping:0x078A
 },
 { code:0x078B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x078B
  ,simpleLowerCaseMapping:0x078B
  ,simpleTitleCaseMapping:0x078B
 },
 { code:0x078C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x078C
  ,simpleLowerCaseMapping:0x078C
  ,simpleTitleCaseMapping:0x078C
 },
 { code:0x078D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x078D
  ,simpleLowerCaseMapping:0x078D
  ,simpleTitleCaseMapping:0x078D
 },
 { code:0x078E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x078E
  ,simpleLowerCaseMapping:0x078E
  ,simpleTitleCaseMapping:0x078E
 },
 { code:0x078F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x078F
  ,simpleLowerCaseMapping:0x078F
  ,simpleTitleCaseMapping:0x078F
 },
 { code:0x0790
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0790
  ,simpleLowerCaseMapping:0x0790
  ,simpleTitleCaseMapping:0x0790
 },
 { code:0x0791
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0791
  ,simpleLowerCaseMapping:0x0791
  ,simpleTitleCaseMapping:0x0791
 },
 { code:0x0792
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0792
  ,simpleLowerCaseMapping:0x0792
  ,simpleTitleCaseMapping:0x0792
 },
 { code:0x0793
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0793
  ,simpleLowerCaseMapping:0x0793
  ,simpleTitleCaseMapping:0x0793
 },
 { code:0x0794
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0794
  ,simpleLowerCaseMapping:0x0794
  ,simpleTitleCaseMapping:0x0794
 },
 { code:0x0795
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0795
  ,simpleLowerCaseMapping:0x0795
  ,simpleTitleCaseMapping:0x0795
 },
 { code:0x0796
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0796
  ,simpleLowerCaseMapping:0x0796
  ,simpleTitleCaseMapping:0x0796
 },
 { code:0x0797
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0797
  ,simpleLowerCaseMapping:0x0797
  ,simpleTitleCaseMapping:0x0797
 },
 { code:0x0798
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0798
  ,simpleLowerCaseMapping:0x0798
  ,simpleTitleCaseMapping:0x0798
 },
 { code:0x0799
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0799
  ,simpleLowerCaseMapping:0x0799
  ,simpleTitleCaseMapping:0x0799
 },
 { code:0x079A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x079A
  ,simpleLowerCaseMapping:0x079A
  ,simpleTitleCaseMapping:0x079A
 },
 { code:0x079B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x079B
  ,simpleLowerCaseMapping:0x079B
  ,simpleTitleCaseMapping:0x079B
 },
 { code:0x079C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x079C
  ,simpleLowerCaseMapping:0x079C
  ,simpleTitleCaseMapping:0x079C
 },
 { code:0x079D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x079D
  ,simpleLowerCaseMapping:0x079D
  ,simpleTitleCaseMapping:0x079D
 },
 { code:0x079E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x079E
  ,simpleLowerCaseMapping:0x079E
  ,simpleTitleCaseMapping:0x079E
 },
 { code:0x079F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x079F
  ,simpleLowerCaseMapping:0x079F
  ,simpleTitleCaseMapping:0x079F
 },
 { code:0x07A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07A0
  ,simpleLowerCaseMapping:0x07A0
  ,simpleTitleCaseMapping:0x07A0
 },
 { code:0x07A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07A1
  ,simpleLowerCaseMapping:0x07A1
  ,simpleTitleCaseMapping:0x07A1
 },
 { code:0x07A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07A2
  ,simpleLowerCaseMapping:0x07A2
  ,simpleTitleCaseMapping:0x07A2
 },
 { code:0x07A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07A3
  ,simpleLowerCaseMapping:0x07A3
  ,simpleTitleCaseMapping:0x07A3
 },
 { code:0x07A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07A4
  ,simpleLowerCaseMapping:0x07A4
  ,simpleTitleCaseMapping:0x07A4
 },
 { code:0x07A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07A5
  ,simpleLowerCaseMapping:0x07A5
  ,simpleTitleCaseMapping:0x07A5
 },
 { code:0x07A6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07A6
  ,simpleLowerCaseMapping:0x07A6
  ,simpleTitleCaseMapping:0x07A6
 },
 { code:0x07A7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07A7
  ,simpleLowerCaseMapping:0x07A7
  ,simpleTitleCaseMapping:0x07A7
 },
 { code:0x07A8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07A8
  ,simpleLowerCaseMapping:0x07A8
  ,simpleTitleCaseMapping:0x07A8
 },
 { code:0x07A9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07A9
  ,simpleLowerCaseMapping:0x07A9
  ,simpleTitleCaseMapping:0x07A9
 },
 { code:0x07AA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07AA
  ,simpleLowerCaseMapping:0x07AA
  ,simpleTitleCaseMapping:0x07AA
 },
 { code:0x07AB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07AB
  ,simpleLowerCaseMapping:0x07AB
  ,simpleTitleCaseMapping:0x07AB
 },
 { code:0x07AC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07AC
  ,simpleLowerCaseMapping:0x07AC
  ,simpleTitleCaseMapping:0x07AC
 },
 { code:0x07AD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07AD
  ,simpleLowerCaseMapping:0x07AD
  ,simpleTitleCaseMapping:0x07AD
 },
 { code:0x07AE
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07AE
  ,simpleLowerCaseMapping:0x07AE
  ,simpleTitleCaseMapping:0x07AE
 },
 { code:0x07AF
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07AF
  ,simpleLowerCaseMapping:0x07AF
  ,simpleTitleCaseMapping:0x07AF
 },
 { code:0x07B0
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07B0
  ,simpleLowerCaseMapping:0x07B0
  ,simpleTitleCaseMapping:0x07B0
 },
 { code:0x07B1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07B1
  ,simpleLowerCaseMapping:0x07B1
  ,simpleTitleCaseMapping:0x07B1
 },
 { code:0x07C0
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x07C0
  ,simpleLowerCaseMapping:0x07C0
  ,simpleTitleCaseMapping:0x07C0
 },
 { code:0x07C1
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x07C1
  ,simpleLowerCaseMapping:0x07C1
  ,simpleTitleCaseMapping:0x07C1
 },
 { code:0x07C2
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x07C2
  ,simpleLowerCaseMapping:0x07C2
  ,simpleTitleCaseMapping:0x07C2
 },
 { code:0x07C3
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x07C3
  ,simpleLowerCaseMapping:0x07C3
  ,simpleTitleCaseMapping:0x07C3
 },
 { code:0x07C4
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x07C4
  ,simpleLowerCaseMapping:0x07C4
  ,simpleTitleCaseMapping:0x07C4
 },
 { code:0x07C5
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x07C5
  ,simpleLowerCaseMapping:0x07C5
  ,simpleTitleCaseMapping:0x07C5
 },
 { code:0x07C6
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x07C6
  ,simpleLowerCaseMapping:0x07C6
  ,simpleTitleCaseMapping:0x07C6
 },
 { code:0x07C7
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x07C7
  ,simpleLowerCaseMapping:0x07C7
  ,simpleTitleCaseMapping:0x07C7
 },
 { code:0x07C8
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x07C8
  ,simpleLowerCaseMapping:0x07C8
  ,simpleTitleCaseMapping:0x07C8
 },
 { code:0x07C9
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x07C9
  ,simpleLowerCaseMapping:0x07C9
  ,simpleTitleCaseMapping:0x07C9
 },
 { code:0x07CA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07CA
  ,simpleLowerCaseMapping:0x07CA
  ,simpleTitleCaseMapping:0x07CA
 },
 { code:0x07CB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07CB
  ,simpleLowerCaseMapping:0x07CB
  ,simpleTitleCaseMapping:0x07CB
 },
 { code:0x07CC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07CC
  ,simpleLowerCaseMapping:0x07CC
  ,simpleTitleCaseMapping:0x07CC
 },
 { code:0x07CD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07CD
  ,simpleLowerCaseMapping:0x07CD
  ,simpleTitleCaseMapping:0x07CD
 },
 { code:0x07CE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07CE
  ,simpleLowerCaseMapping:0x07CE
  ,simpleTitleCaseMapping:0x07CE
 },
 { code:0x07CF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07CF
  ,simpleLowerCaseMapping:0x07CF
  ,simpleTitleCaseMapping:0x07CF
 },
 { code:0x07D0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07D0
  ,simpleLowerCaseMapping:0x07D0
  ,simpleTitleCaseMapping:0x07D0
 },
 { code:0x07D1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07D1
  ,simpleLowerCaseMapping:0x07D1
  ,simpleTitleCaseMapping:0x07D1
 },
 { code:0x07D2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07D2
  ,simpleLowerCaseMapping:0x07D2
  ,simpleTitleCaseMapping:0x07D2
 },
 { code:0x07D3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07D3
  ,simpleLowerCaseMapping:0x07D3
  ,simpleTitleCaseMapping:0x07D3
 },
 { code:0x07D4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07D4
  ,simpleLowerCaseMapping:0x07D4
  ,simpleTitleCaseMapping:0x07D4
 },
 { code:0x07D5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07D5
  ,simpleLowerCaseMapping:0x07D5
  ,simpleTitleCaseMapping:0x07D5
 },
 { code:0x07D6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07D6
  ,simpleLowerCaseMapping:0x07D6
  ,simpleTitleCaseMapping:0x07D6
 },
 { code:0x07D7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07D7
  ,simpleLowerCaseMapping:0x07D7
  ,simpleTitleCaseMapping:0x07D7
 },
 { code:0x07D8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07D8
  ,simpleLowerCaseMapping:0x07D8
  ,simpleTitleCaseMapping:0x07D8
 },
 { code:0x07D9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07D9
  ,simpleLowerCaseMapping:0x07D9
  ,simpleTitleCaseMapping:0x07D9
 },
 { code:0x07DA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07DA
  ,simpleLowerCaseMapping:0x07DA
  ,simpleTitleCaseMapping:0x07DA
 },
 { code:0x07DB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07DB
  ,simpleLowerCaseMapping:0x07DB
  ,simpleTitleCaseMapping:0x07DB
 },
 { code:0x07DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07DC
  ,simpleLowerCaseMapping:0x07DC
  ,simpleTitleCaseMapping:0x07DC
 },
 { code:0x07DD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07DD
  ,simpleLowerCaseMapping:0x07DD
  ,simpleTitleCaseMapping:0x07DD
 },
 { code:0x07DE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07DE
  ,simpleLowerCaseMapping:0x07DE
  ,simpleTitleCaseMapping:0x07DE
 },
 { code:0x07DF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07DF
  ,simpleLowerCaseMapping:0x07DF
  ,simpleTitleCaseMapping:0x07DF
 },
 { code:0x07E0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07E0
  ,simpleLowerCaseMapping:0x07E0
  ,simpleTitleCaseMapping:0x07E0
 },
 { code:0x07E1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07E1
  ,simpleLowerCaseMapping:0x07E1
  ,simpleTitleCaseMapping:0x07E1
 },
 { code:0x07E2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07E2
  ,simpleLowerCaseMapping:0x07E2
  ,simpleTitleCaseMapping:0x07E2
 },
 { code:0x07E3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07E3
  ,simpleLowerCaseMapping:0x07E3
  ,simpleTitleCaseMapping:0x07E3
 },
 { code:0x07E4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07E4
  ,simpleLowerCaseMapping:0x07E4
  ,simpleTitleCaseMapping:0x07E4
 },
 { code:0x07E5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07E5
  ,simpleLowerCaseMapping:0x07E5
  ,simpleTitleCaseMapping:0x07E5
 },
 { code:0x07E6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07E6
  ,simpleLowerCaseMapping:0x07E6
  ,simpleTitleCaseMapping:0x07E6
 },
 { code:0x07E7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07E7
  ,simpleLowerCaseMapping:0x07E7
  ,simpleTitleCaseMapping:0x07E7
 },
 { code:0x07E8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07E8
  ,simpleLowerCaseMapping:0x07E8
  ,simpleTitleCaseMapping:0x07E8
 },
 { code:0x07E9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07E9
  ,simpleLowerCaseMapping:0x07E9
  ,simpleTitleCaseMapping:0x07E9
 },
 { code:0x07EA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x07EA
  ,simpleLowerCaseMapping:0x07EA
  ,simpleTitleCaseMapping:0x07EA
 },
 { code:0x07EB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07EB
  ,simpleLowerCaseMapping:0x07EB
  ,simpleTitleCaseMapping:0x07EB
 },
 { code:0x07EC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07EC
  ,simpleLowerCaseMapping:0x07EC
  ,simpleTitleCaseMapping:0x07EC
 },
 { code:0x07ED
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07ED
  ,simpleLowerCaseMapping:0x07ED
  ,simpleTitleCaseMapping:0x07ED
 },
 { code:0x07EE
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07EE
  ,simpleLowerCaseMapping:0x07EE
  ,simpleTitleCaseMapping:0x07EE
 },
 { code:0x07EF
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07EF
  ,simpleLowerCaseMapping:0x07EF
  ,simpleTitleCaseMapping:0x07EF
 },
 { code:0x07F0
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07F0
  ,simpleLowerCaseMapping:0x07F0
  ,simpleTitleCaseMapping:0x07F0
 },
 { code:0x07F1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07F1
  ,simpleLowerCaseMapping:0x07F1
  ,simpleTitleCaseMapping:0x07F1
 },
 { code:0x07F2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07F2
  ,simpleLowerCaseMapping:0x07F2
  ,simpleTitleCaseMapping:0x07F2
 },
 { code:0x07F3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x07F3
  ,simpleLowerCaseMapping:0x07F3
  ,simpleTitleCaseMapping:0x07F3
 },
 { code:0x07F4
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x07F4
  ,simpleLowerCaseMapping:0x07F4
  ,simpleTitleCaseMapping:0x07F4
 },
 { code:0x07F5
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x07F5
  ,simpleLowerCaseMapping:0x07F5
  ,simpleTitleCaseMapping:0x07F5
 },
 { code:0x07F6
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x07F6
  ,simpleLowerCaseMapping:0x07F6
  ,simpleTitleCaseMapping:0x07F6
 },
 { code:0x07F7
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x07F7
  ,simpleLowerCaseMapping:0x07F7
  ,simpleTitleCaseMapping:0x07F7
 },
 { code:0x07F8
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x07F8
  ,simpleLowerCaseMapping:0x07F8
  ,simpleTitleCaseMapping:0x07F8
 },
 { code:0x07F9
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x07F9
  ,simpleLowerCaseMapping:0x07F9
  ,simpleTitleCaseMapping:0x07F9
 },
 { code:0x07FA
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x07FA
  ,simpleLowerCaseMapping:0x07FA
  ,simpleTitleCaseMapping:0x07FA
 },
 { code:0x0901
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0901
  ,simpleLowerCaseMapping:0x0901
  ,simpleTitleCaseMapping:0x0901
 },
 { code:0x0902
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0902
  ,simpleLowerCaseMapping:0x0902
  ,simpleTitleCaseMapping:0x0902
 },
 { code:0x0903
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0903
  ,simpleLowerCaseMapping:0x0903
  ,simpleTitleCaseMapping:0x0903
 },
 { code:0x0904
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0904
  ,simpleLowerCaseMapping:0x0904
  ,simpleTitleCaseMapping:0x0904
 },
 { code:0x0905
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0905
  ,simpleLowerCaseMapping:0x0905
  ,simpleTitleCaseMapping:0x0905
 },
 { code:0x0906
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0906
  ,simpleLowerCaseMapping:0x0906
  ,simpleTitleCaseMapping:0x0906
 },
 { code:0x0907
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0907
  ,simpleLowerCaseMapping:0x0907
  ,simpleTitleCaseMapping:0x0907
 },
 { code:0x0908
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0908
  ,simpleLowerCaseMapping:0x0908
  ,simpleTitleCaseMapping:0x0908
 },
 { code:0x0909
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0909
  ,simpleLowerCaseMapping:0x0909
  ,simpleTitleCaseMapping:0x0909
 },
 { code:0x090A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x090A
  ,simpleLowerCaseMapping:0x090A
  ,simpleTitleCaseMapping:0x090A
 },
 { code:0x090B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x090B
  ,simpleLowerCaseMapping:0x090B
  ,simpleTitleCaseMapping:0x090B
 },
 { code:0x090C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x090C
  ,simpleLowerCaseMapping:0x090C
  ,simpleTitleCaseMapping:0x090C
 },
 { code:0x090D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x090D
  ,simpleLowerCaseMapping:0x090D
  ,simpleTitleCaseMapping:0x090D
 },
 { code:0x090E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x090E
  ,simpleLowerCaseMapping:0x090E
  ,simpleTitleCaseMapping:0x090E
 },
 { code:0x090F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x090F
  ,simpleLowerCaseMapping:0x090F
  ,simpleTitleCaseMapping:0x090F
 },
 { code:0x0910
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0910
  ,simpleLowerCaseMapping:0x0910
  ,simpleTitleCaseMapping:0x0910
 },
 { code:0x0911
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0911
  ,simpleLowerCaseMapping:0x0911
  ,simpleTitleCaseMapping:0x0911
 },
 { code:0x0912
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0912
  ,simpleLowerCaseMapping:0x0912
  ,simpleTitleCaseMapping:0x0912
 },
 { code:0x0913
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0913
  ,simpleLowerCaseMapping:0x0913
  ,simpleTitleCaseMapping:0x0913
 },
 { code:0x0914
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0914
  ,simpleLowerCaseMapping:0x0914
  ,simpleTitleCaseMapping:0x0914
 },
 { code:0x0915
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0915
  ,simpleLowerCaseMapping:0x0915
  ,simpleTitleCaseMapping:0x0915
 },
 { code:0x0916
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0916
  ,simpleLowerCaseMapping:0x0916
  ,simpleTitleCaseMapping:0x0916
 },
 { code:0x0917
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0917
  ,simpleLowerCaseMapping:0x0917
  ,simpleTitleCaseMapping:0x0917
 },
 { code:0x0918
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0918
  ,simpleLowerCaseMapping:0x0918
  ,simpleTitleCaseMapping:0x0918
 },
 { code:0x0919
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0919
  ,simpleLowerCaseMapping:0x0919
  ,simpleTitleCaseMapping:0x0919
 },
 { code:0x091A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x091A
  ,simpleLowerCaseMapping:0x091A
  ,simpleTitleCaseMapping:0x091A
 },
 { code:0x091B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x091B
  ,simpleLowerCaseMapping:0x091B
  ,simpleTitleCaseMapping:0x091B
 },
 { code:0x091C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x091C
  ,simpleLowerCaseMapping:0x091C
  ,simpleTitleCaseMapping:0x091C
 },
 { code:0x091D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x091D
  ,simpleLowerCaseMapping:0x091D
  ,simpleTitleCaseMapping:0x091D
 },
 { code:0x091E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x091E
  ,simpleLowerCaseMapping:0x091E
  ,simpleTitleCaseMapping:0x091E
 },
 { code:0x091F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x091F
  ,simpleLowerCaseMapping:0x091F
  ,simpleTitleCaseMapping:0x091F
 },
 { code:0x0920
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0920
  ,simpleLowerCaseMapping:0x0920
  ,simpleTitleCaseMapping:0x0920
 },
 { code:0x0921
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0921
  ,simpleLowerCaseMapping:0x0921
  ,simpleTitleCaseMapping:0x0921
 },
 { code:0x0922
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0922
  ,simpleLowerCaseMapping:0x0922
  ,simpleTitleCaseMapping:0x0922
 },
 { code:0x0923
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0923
  ,simpleLowerCaseMapping:0x0923
  ,simpleTitleCaseMapping:0x0923
 },
 { code:0x0924
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0924
  ,simpleLowerCaseMapping:0x0924
  ,simpleTitleCaseMapping:0x0924
 },
 { code:0x0925
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0925
  ,simpleLowerCaseMapping:0x0925
  ,simpleTitleCaseMapping:0x0925
 },
 { code:0x0926
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0926
  ,simpleLowerCaseMapping:0x0926
  ,simpleTitleCaseMapping:0x0926
 },
 { code:0x0927
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0927
  ,simpleLowerCaseMapping:0x0927
  ,simpleTitleCaseMapping:0x0927
 },
 { code:0x0928
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0928
  ,simpleLowerCaseMapping:0x0928
  ,simpleTitleCaseMapping:0x0928
 },
 { code:0x0929
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0929
  ,simpleLowerCaseMapping:0x0929
  ,simpleTitleCaseMapping:0x0929
 },
 { code:0x092A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x092A
  ,simpleLowerCaseMapping:0x092A
  ,simpleTitleCaseMapping:0x092A
 },
 { code:0x092B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x092B
  ,simpleLowerCaseMapping:0x092B
  ,simpleTitleCaseMapping:0x092B
 },
 { code:0x092C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x092C
  ,simpleLowerCaseMapping:0x092C
  ,simpleTitleCaseMapping:0x092C
 },
 { code:0x092D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x092D
  ,simpleLowerCaseMapping:0x092D
  ,simpleTitleCaseMapping:0x092D
 },
 { code:0x092E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x092E
  ,simpleLowerCaseMapping:0x092E
  ,simpleTitleCaseMapping:0x092E
 },
 { code:0x092F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x092F
  ,simpleLowerCaseMapping:0x092F
  ,simpleTitleCaseMapping:0x092F
 },
 { code:0x0930
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0930
  ,simpleLowerCaseMapping:0x0930
  ,simpleTitleCaseMapping:0x0930
 },
 { code:0x0931
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0931
  ,simpleLowerCaseMapping:0x0931
  ,simpleTitleCaseMapping:0x0931
 },
 { code:0x0932
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0932
  ,simpleLowerCaseMapping:0x0932
  ,simpleTitleCaseMapping:0x0932
 },
 { code:0x0933
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0933
  ,simpleLowerCaseMapping:0x0933
  ,simpleTitleCaseMapping:0x0933
 },
 { code:0x0934
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0934
  ,simpleLowerCaseMapping:0x0934
  ,simpleTitleCaseMapping:0x0934
 },
 { code:0x0935
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0935
  ,simpleLowerCaseMapping:0x0935
  ,simpleTitleCaseMapping:0x0935
 },
 { code:0x0936
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0936
  ,simpleLowerCaseMapping:0x0936
  ,simpleTitleCaseMapping:0x0936
 },
 { code:0x0937
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0937
  ,simpleLowerCaseMapping:0x0937
  ,simpleTitleCaseMapping:0x0937
 },
 { code:0x0938
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0938
  ,simpleLowerCaseMapping:0x0938
  ,simpleTitleCaseMapping:0x0938
 },
 { code:0x0939
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0939
  ,simpleLowerCaseMapping:0x0939
  ,simpleTitleCaseMapping:0x0939
 },
 { code:0x093C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x093C
  ,simpleLowerCaseMapping:0x093C
  ,simpleTitleCaseMapping:0x093C
 },
 { code:0x093D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x093D
  ,simpleLowerCaseMapping:0x093D
  ,simpleTitleCaseMapping:0x093D
 },
 { code:0x093E
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x093E
  ,simpleLowerCaseMapping:0x093E
  ,simpleTitleCaseMapping:0x093E
 },
 { code:0x093F
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x093F
  ,simpleLowerCaseMapping:0x093F
  ,simpleTitleCaseMapping:0x093F
 },
 { code:0x0940
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0940
  ,simpleLowerCaseMapping:0x0940
  ,simpleTitleCaseMapping:0x0940
 },
 { code:0x0941
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0941
  ,simpleLowerCaseMapping:0x0941
  ,simpleTitleCaseMapping:0x0941
 },
 { code:0x0942
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0942
  ,simpleLowerCaseMapping:0x0942
  ,simpleTitleCaseMapping:0x0942
 },
 { code:0x0943
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0943
  ,simpleLowerCaseMapping:0x0943
  ,simpleTitleCaseMapping:0x0943
 },
 { code:0x0944
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0944
  ,simpleLowerCaseMapping:0x0944
  ,simpleTitleCaseMapping:0x0944
 },
 { code:0x0945
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0945
  ,simpleLowerCaseMapping:0x0945
  ,simpleTitleCaseMapping:0x0945
 },
 { code:0x0946
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0946
  ,simpleLowerCaseMapping:0x0946
  ,simpleTitleCaseMapping:0x0946
 },
 { code:0x0947
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0947
  ,simpleLowerCaseMapping:0x0947
  ,simpleTitleCaseMapping:0x0947
 },
 { code:0x0948
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0948
  ,simpleLowerCaseMapping:0x0948
  ,simpleTitleCaseMapping:0x0948
 },
 { code:0x0949
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0949
  ,simpleLowerCaseMapping:0x0949
  ,simpleTitleCaseMapping:0x0949
 },
 { code:0x094A
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x094A
  ,simpleLowerCaseMapping:0x094A
  ,simpleTitleCaseMapping:0x094A
 },
 { code:0x094B
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x094B
  ,simpleLowerCaseMapping:0x094B
  ,simpleTitleCaseMapping:0x094B
 },
 { code:0x094C
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x094C
  ,simpleLowerCaseMapping:0x094C
  ,simpleTitleCaseMapping:0x094C
 },
 { code:0x094D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x094D
  ,simpleLowerCaseMapping:0x094D
  ,simpleTitleCaseMapping:0x094D
 },
 { code:0x0950
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0950
  ,simpleLowerCaseMapping:0x0950
  ,simpleTitleCaseMapping:0x0950
 },
 { code:0x0951
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0951
  ,simpleLowerCaseMapping:0x0951
  ,simpleTitleCaseMapping:0x0951
 },
 { code:0x0952
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0952
  ,simpleLowerCaseMapping:0x0952
  ,simpleTitleCaseMapping:0x0952
 },
 { code:0x0953
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0953
  ,simpleLowerCaseMapping:0x0953
  ,simpleTitleCaseMapping:0x0953
 },
 { code:0x0954
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0954
  ,simpleLowerCaseMapping:0x0954
  ,simpleTitleCaseMapping:0x0954
 },
 { code:0x0958
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0958
  ,simpleLowerCaseMapping:0x0958
  ,simpleTitleCaseMapping:0x0958
 },
 { code:0x0959
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0959
  ,simpleLowerCaseMapping:0x0959
  ,simpleTitleCaseMapping:0x0959
 },
 { code:0x095A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x095A
  ,simpleLowerCaseMapping:0x095A
  ,simpleTitleCaseMapping:0x095A
 },
 { code:0x095B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x095B
  ,simpleLowerCaseMapping:0x095B
  ,simpleTitleCaseMapping:0x095B
 },
 { code:0x095C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x095C
  ,simpleLowerCaseMapping:0x095C
  ,simpleTitleCaseMapping:0x095C
 },
 { code:0x095D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x095D
  ,simpleLowerCaseMapping:0x095D
  ,simpleTitleCaseMapping:0x095D
 },
 { code:0x095E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x095E
  ,simpleLowerCaseMapping:0x095E
  ,simpleTitleCaseMapping:0x095E
 },
 { code:0x095F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x095F
  ,simpleLowerCaseMapping:0x095F
  ,simpleTitleCaseMapping:0x095F
 },
 { code:0x0960
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0960
  ,simpleLowerCaseMapping:0x0960
  ,simpleTitleCaseMapping:0x0960
 },
 { code:0x0961
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0961
  ,simpleLowerCaseMapping:0x0961
  ,simpleTitleCaseMapping:0x0961
 },
 { code:0x0962
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0962
  ,simpleLowerCaseMapping:0x0962
  ,simpleTitleCaseMapping:0x0962
 },
 { code:0x0963
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0963
  ,simpleLowerCaseMapping:0x0963
  ,simpleTitleCaseMapping:0x0963
 },
 { code:0x0964
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0964
  ,simpleLowerCaseMapping:0x0964
  ,simpleTitleCaseMapping:0x0964
 },
 { code:0x0965
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0965
  ,simpleLowerCaseMapping:0x0965
  ,simpleTitleCaseMapping:0x0965
 },
 { code:0x0966
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0966
  ,simpleLowerCaseMapping:0x0966
  ,simpleTitleCaseMapping:0x0966
 },
 { code:0x0967
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0967
  ,simpleLowerCaseMapping:0x0967
  ,simpleTitleCaseMapping:0x0967
 },
 { code:0x0968
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0968
  ,simpleLowerCaseMapping:0x0968
  ,simpleTitleCaseMapping:0x0968
 },
 { code:0x0969
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0969
  ,simpleLowerCaseMapping:0x0969
  ,simpleTitleCaseMapping:0x0969
 },
 { code:0x096A
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x096A
  ,simpleLowerCaseMapping:0x096A
  ,simpleTitleCaseMapping:0x096A
 },
 { code:0x096B
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x096B
  ,simpleLowerCaseMapping:0x096B
  ,simpleTitleCaseMapping:0x096B
 },
 { code:0x096C
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x096C
  ,simpleLowerCaseMapping:0x096C
  ,simpleTitleCaseMapping:0x096C
 },
 { code:0x096D
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x096D
  ,simpleLowerCaseMapping:0x096D
  ,simpleTitleCaseMapping:0x096D
 },
 { code:0x096E
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x096E
  ,simpleLowerCaseMapping:0x096E
  ,simpleTitleCaseMapping:0x096E
 },
 { code:0x096F
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x096F
  ,simpleLowerCaseMapping:0x096F
  ,simpleTitleCaseMapping:0x096F
 },
 { code:0x0970
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0970
  ,simpleLowerCaseMapping:0x0970
  ,simpleTitleCaseMapping:0x0970
 },
 { code:0x097B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x097B
  ,simpleLowerCaseMapping:0x097B
  ,simpleTitleCaseMapping:0x097B
 },
 { code:0x097C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x097C
  ,simpleLowerCaseMapping:0x097C
  ,simpleTitleCaseMapping:0x097C
 },
 { code:0x097D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x097D
  ,simpleLowerCaseMapping:0x097D
  ,simpleTitleCaseMapping:0x097D
 },
 { code:0x097E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x097E
  ,simpleLowerCaseMapping:0x097E
  ,simpleTitleCaseMapping:0x097E
 },
 { code:0x097F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x097F
  ,simpleLowerCaseMapping:0x097F
  ,simpleTitleCaseMapping:0x097F
 },
 { code:0x0981
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0981
  ,simpleLowerCaseMapping:0x0981
  ,simpleTitleCaseMapping:0x0981
 },
 { code:0x0982
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0982
  ,simpleLowerCaseMapping:0x0982
  ,simpleTitleCaseMapping:0x0982
 },
 { code:0x0983
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0983
  ,simpleLowerCaseMapping:0x0983
  ,simpleTitleCaseMapping:0x0983
 },
 { code:0x0985
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0985
  ,simpleLowerCaseMapping:0x0985
  ,simpleTitleCaseMapping:0x0985
 },
 { code:0x0986
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0986
  ,simpleLowerCaseMapping:0x0986
  ,simpleTitleCaseMapping:0x0986
 },
 { code:0x0987
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0987
  ,simpleLowerCaseMapping:0x0987
  ,simpleTitleCaseMapping:0x0987
 },
 { code:0x0988
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0988
  ,simpleLowerCaseMapping:0x0988
  ,simpleTitleCaseMapping:0x0988
 },
 { code:0x0989
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0989
  ,simpleLowerCaseMapping:0x0989
  ,simpleTitleCaseMapping:0x0989
 },
 { code:0x098A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x098A
  ,simpleLowerCaseMapping:0x098A
  ,simpleTitleCaseMapping:0x098A
 },
 { code:0x098B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x098B
  ,simpleLowerCaseMapping:0x098B
  ,simpleTitleCaseMapping:0x098B
 },
 { code:0x098C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x098C
  ,simpleLowerCaseMapping:0x098C
  ,simpleTitleCaseMapping:0x098C
 },
 { code:0x098F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x098F
  ,simpleLowerCaseMapping:0x098F
  ,simpleTitleCaseMapping:0x098F
 },
 { code:0x0990
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0990
  ,simpleLowerCaseMapping:0x0990
  ,simpleTitleCaseMapping:0x0990
 },
 { code:0x0993
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0993
  ,simpleLowerCaseMapping:0x0993
  ,simpleTitleCaseMapping:0x0993
 },
 { code:0x0994
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0994
  ,simpleLowerCaseMapping:0x0994
  ,simpleTitleCaseMapping:0x0994
 },
 { code:0x0995
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0995
  ,simpleLowerCaseMapping:0x0995
  ,simpleTitleCaseMapping:0x0995
 },
 { code:0x0996
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0996
  ,simpleLowerCaseMapping:0x0996
  ,simpleTitleCaseMapping:0x0996
 },
 { code:0x0997
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0997
  ,simpleLowerCaseMapping:0x0997
  ,simpleTitleCaseMapping:0x0997
 },
 { code:0x0998
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0998
  ,simpleLowerCaseMapping:0x0998
  ,simpleTitleCaseMapping:0x0998
 },
 { code:0x0999
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0999
  ,simpleLowerCaseMapping:0x0999
  ,simpleTitleCaseMapping:0x0999
 },
 { code:0x099A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x099A
  ,simpleLowerCaseMapping:0x099A
  ,simpleTitleCaseMapping:0x099A
 },
 { code:0x099B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x099B
  ,simpleLowerCaseMapping:0x099B
  ,simpleTitleCaseMapping:0x099B
 },
 { code:0x099C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x099C
  ,simpleLowerCaseMapping:0x099C
  ,simpleTitleCaseMapping:0x099C
 },
 { code:0x099D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x099D
  ,simpleLowerCaseMapping:0x099D
  ,simpleTitleCaseMapping:0x099D
 },
 { code:0x099E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x099E
  ,simpleLowerCaseMapping:0x099E
  ,simpleTitleCaseMapping:0x099E
 },
 { code:0x099F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x099F
  ,simpleLowerCaseMapping:0x099F
  ,simpleTitleCaseMapping:0x099F
 },
 { code:0x09A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09A0
  ,simpleLowerCaseMapping:0x09A0
  ,simpleTitleCaseMapping:0x09A0
 },
 { code:0x09A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09A1
  ,simpleLowerCaseMapping:0x09A1
  ,simpleTitleCaseMapping:0x09A1
 },
 { code:0x09A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09A2
  ,simpleLowerCaseMapping:0x09A2
  ,simpleTitleCaseMapping:0x09A2
 },
 { code:0x09A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09A3
  ,simpleLowerCaseMapping:0x09A3
  ,simpleTitleCaseMapping:0x09A3
 },
 { code:0x09A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09A4
  ,simpleLowerCaseMapping:0x09A4
  ,simpleTitleCaseMapping:0x09A4
 },
 { code:0x09A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09A5
  ,simpleLowerCaseMapping:0x09A5
  ,simpleTitleCaseMapping:0x09A5
 },
 { code:0x09A6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09A6
  ,simpleLowerCaseMapping:0x09A6
  ,simpleTitleCaseMapping:0x09A6
 },
 { code:0x09A7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09A7
  ,simpleLowerCaseMapping:0x09A7
  ,simpleTitleCaseMapping:0x09A7
 },
 { code:0x09A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09A8
  ,simpleLowerCaseMapping:0x09A8
  ,simpleTitleCaseMapping:0x09A8
 },
 { code:0x09AA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09AA
  ,simpleLowerCaseMapping:0x09AA
  ,simpleTitleCaseMapping:0x09AA
 },
 { code:0x09AB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09AB
  ,simpleLowerCaseMapping:0x09AB
  ,simpleTitleCaseMapping:0x09AB
 },
 { code:0x09AC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09AC
  ,simpleLowerCaseMapping:0x09AC
  ,simpleTitleCaseMapping:0x09AC
 },
 { code:0x09AD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09AD
  ,simpleLowerCaseMapping:0x09AD
  ,simpleTitleCaseMapping:0x09AD
 },
 { code:0x09AE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09AE
  ,simpleLowerCaseMapping:0x09AE
  ,simpleTitleCaseMapping:0x09AE
 },
 { code:0x09AF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09AF
  ,simpleLowerCaseMapping:0x09AF
  ,simpleTitleCaseMapping:0x09AF
 },
 { code:0x09B0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09B0
  ,simpleLowerCaseMapping:0x09B0
  ,simpleTitleCaseMapping:0x09B0
 },
 { code:0x09B2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09B2
  ,simpleLowerCaseMapping:0x09B2
  ,simpleTitleCaseMapping:0x09B2
 },
 { code:0x09B6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09B6
  ,simpleLowerCaseMapping:0x09B6
  ,simpleTitleCaseMapping:0x09B6
 },
 { code:0x09B7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09B7
  ,simpleLowerCaseMapping:0x09B7
  ,simpleTitleCaseMapping:0x09B7
 },
 { code:0x09B8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09B8
  ,simpleLowerCaseMapping:0x09B8
  ,simpleTitleCaseMapping:0x09B8
 },
 { code:0x09B9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09B9
  ,simpleLowerCaseMapping:0x09B9
  ,simpleTitleCaseMapping:0x09B9
 },
 { code:0x09BC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x09BC
  ,simpleLowerCaseMapping:0x09BC
  ,simpleTitleCaseMapping:0x09BC
 },
 { code:0x09BD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09BD
  ,simpleLowerCaseMapping:0x09BD
  ,simpleTitleCaseMapping:0x09BD
 },
 { code:0x09BE
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x09BE
  ,simpleLowerCaseMapping:0x09BE
  ,simpleTitleCaseMapping:0x09BE
 },
 { code:0x09BF
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x09BF
  ,simpleLowerCaseMapping:0x09BF
  ,simpleTitleCaseMapping:0x09BF
 },
 { code:0x09C0
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x09C0
  ,simpleLowerCaseMapping:0x09C0
  ,simpleTitleCaseMapping:0x09C0
 },
 { code:0x09C1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x09C1
  ,simpleLowerCaseMapping:0x09C1
  ,simpleTitleCaseMapping:0x09C1
 },
 { code:0x09C2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x09C2
  ,simpleLowerCaseMapping:0x09C2
  ,simpleTitleCaseMapping:0x09C2
 },
 { code:0x09C3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x09C3
  ,simpleLowerCaseMapping:0x09C3
  ,simpleTitleCaseMapping:0x09C3
 },
 { code:0x09C4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x09C4
  ,simpleLowerCaseMapping:0x09C4
  ,simpleTitleCaseMapping:0x09C4
 },
 { code:0x09C7
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x09C7
  ,simpleLowerCaseMapping:0x09C7
  ,simpleTitleCaseMapping:0x09C7
 },
 { code:0x09C8
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x09C8
  ,simpleLowerCaseMapping:0x09C8
  ,simpleTitleCaseMapping:0x09C8
 },
 { code:0x09CB
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x09CB
  ,simpleLowerCaseMapping:0x09CB
  ,simpleTitleCaseMapping:0x09CB
 },
 { code:0x09CC
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x09CC
  ,simpleLowerCaseMapping:0x09CC
  ,simpleTitleCaseMapping:0x09CC
 },
 { code:0x09CD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x09CD
  ,simpleLowerCaseMapping:0x09CD
  ,simpleTitleCaseMapping:0x09CD
 },
 { code:0x09CE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09CE
  ,simpleLowerCaseMapping:0x09CE
  ,simpleTitleCaseMapping:0x09CE
 },
 { code:0x09D7
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x09D7
  ,simpleLowerCaseMapping:0x09D7
  ,simpleTitleCaseMapping:0x09D7
 },
 { code:0x09DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09DC
  ,simpleLowerCaseMapping:0x09DC
  ,simpleTitleCaseMapping:0x09DC
 },
 { code:0x09DD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09DD
  ,simpleLowerCaseMapping:0x09DD
  ,simpleTitleCaseMapping:0x09DD
 },
 { code:0x09DF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09DF
  ,simpleLowerCaseMapping:0x09DF
  ,simpleTitleCaseMapping:0x09DF
 },
 { code:0x09E0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09E0
  ,simpleLowerCaseMapping:0x09E0
  ,simpleTitleCaseMapping:0x09E0
 },
 { code:0x09E1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09E1
  ,simpleLowerCaseMapping:0x09E1
  ,simpleTitleCaseMapping:0x09E1
 },
 { code:0x09E2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x09E2
  ,simpleLowerCaseMapping:0x09E2
  ,simpleTitleCaseMapping:0x09E2
 },
 { code:0x09E3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x09E3
  ,simpleLowerCaseMapping:0x09E3
  ,simpleTitleCaseMapping:0x09E3
 },
 { code:0x09E6
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x09E6
  ,simpleLowerCaseMapping:0x09E6
  ,simpleTitleCaseMapping:0x09E6
 },
 { code:0x09E7
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x09E7
  ,simpleLowerCaseMapping:0x09E7
  ,simpleTitleCaseMapping:0x09E7
 },
 { code:0x09E8
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x09E8
  ,simpleLowerCaseMapping:0x09E8
  ,simpleTitleCaseMapping:0x09E8
 },
 { code:0x09E9
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x09E9
  ,simpleLowerCaseMapping:0x09E9
  ,simpleTitleCaseMapping:0x09E9
 },
 { code:0x09EA
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x09EA
  ,simpleLowerCaseMapping:0x09EA
  ,simpleTitleCaseMapping:0x09EA
 },
 { code:0x09EB
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x09EB
  ,simpleLowerCaseMapping:0x09EB
  ,simpleTitleCaseMapping:0x09EB
 },
 { code:0x09EC
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x09EC
  ,simpleLowerCaseMapping:0x09EC
  ,simpleTitleCaseMapping:0x09EC
 },
 { code:0x09ED
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x09ED
  ,simpleLowerCaseMapping:0x09ED
  ,simpleTitleCaseMapping:0x09ED
 },
 { code:0x09EE
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x09EE
  ,simpleLowerCaseMapping:0x09EE
  ,simpleTitleCaseMapping:0x09EE
 },
 { code:0x09EF
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x09EF
  ,simpleLowerCaseMapping:0x09EF
  ,simpleTitleCaseMapping:0x09EF
 },
 { code:0x09F0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09F0
  ,simpleLowerCaseMapping:0x09F0
  ,simpleTitleCaseMapping:0x09F0
 },
 { code:0x09F1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x09F1
  ,simpleLowerCaseMapping:0x09F1
  ,simpleTitleCaseMapping:0x09F1
 },
 { code:0x09F2
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x09F2
  ,simpleLowerCaseMapping:0x09F2
  ,simpleTitleCaseMapping:0x09F2
 },
 { code:0x09F3
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x09F3
  ,simpleLowerCaseMapping:0x09F3
  ,simpleTitleCaseMapping:0x09F3
 },
 { code:0x09F4
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x09F4
  ,simpleLowerCaseMapping:0x09F4
  ,simpleTitleCaseMapping:0x09F4
 },
 { code:0x09F5
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x09F5
  ,simpleLowerCaseMapping:0x09F5
  ,simpleTitleCaseMapping:0x09F5
 },
 { code:0x09F6
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x09F6
  ,simpleLowerCaseMapping:0x09F6
  ,simpleTitleCaseMapping:0x09F6
 },
 { code:0x09F7
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x09F7
  ,simpleLowerCaseMapping:0x09F7
  ,simpleTitleCaseMapping:0x09F7
 },
 { code:0x09F8
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x09F8
  ,simpleLowerCaseMapping:0x09F8
  ,simpleTitleCaseMapping:0x09F8
 },
 { code:0x09F9
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x09F9
  ,simpleLowerCaseMapping:0x09F9
  ,simpleTitleCaseMapping:0x09F9
 },
 { code:0x09FA
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x09FA
  ,simpleLowerCaseMapping:0x09FA
  ,simpleTitleCaseMapping:0x09FA
 },
 { code:0x0A01
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A01
  ,simpleLowerCaseMapping:0x0A01
  ,simpleTitleCaseMapping:0x0A01
 },
 { code:0x0A02
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A02
  ,simpleLowerCaseMapping:0x0A02
  ,simpleTitleCaseMapping:0x0A02
 },
 { code:0x0A03
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0A03
  ,simpleLowerCaseMapping:0x0A03
  ,simpleTitleCaseMapping:0x0A03
 },
 { code:0x0A05
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A05
  ,simpleLowerCaseMapping:0x0A05
  ,simpleTitleCaseMapping:0x0A05
 },
 { code:0x0A06
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A06
  ,simpleLowerCaseMapping:0x0A06
  ,simpleTitleCaseMapping:0x0A06
 },
 { code:0x0A07
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A07
  ,simpleLowerCaseMapping:0x0A07
  ,simpleTitleCaseMapping:0x0A07
 },
 { code:0x0A08
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A08
  ,simpleLowerCaseMapping:0x0A08
  ,simpleTitleCaseMapping:0x0A08
 },
 { code:0x0A09
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A09
  ,simpleLowerCaseMapping:0x0A09
  ,simpleTitleCaseMapping:0x0A09
 },
 { code:0x0A0A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A0A
  ,simpleLowerCaseMapping:0x0A0A
  ,simpleTitleCaseMapping:0x0A0A
 },
 { code:0x0A0F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A0F
  ,simpleLowerCaseMapping:0x0A0F
  ,simpleTitleCaseMapping:0x0A0F
 },
 { code:0x0A10
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A10
  ,simpleLowerCaseMapping:0x0A10
  ,simpleTitleCaseMapping:0x0A10
 },
 { code:0x0A13
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A13
  ,simpleLowerCaseMapping:0x0A13
  ,simpleTitleCaseMapping:0x0A13
 },
 { code:0x0A14
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A14
  ,simpleLowerCaseMapping:0x0A14
  ,simpleTitleCaseMapping:0x0A14
 },
 { code:0x0A15
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A15
  ,simpleLowerCaseMapping:0x0A15
  ,simpleTitleCaseMapping:0x0A15
 },
 { code:0x0A16
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A16
  ,simpleLowerCaseMapping:0x0A16
  ,simpleTitleCaseMapping:0x0A16
 },
 { code:0x0A17
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A17
  ,simpleLowerCaseMapping:0x0A17
  ,simpleTitleCaseMapping:0x0A17
 },
 { code:0x0A18
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A18
  ,simpleLowerCaseMapping:0x0A18
  ,simpleTitleCaseMapping:0x0A18
 },
 { code:0x0A19
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A19
  ,simpleLowerCaseMapping:0x0A19
  ,simpleTitleCaseMapping:0x0A19
 },
 { code:0x0A1A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A1A
  ,simpleLowerCaseMapping:0x0A1A
  ,simpleTitleCaseMapping:0x0A1A
 },
 { code:0x0A1B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A1B
  ,simpleLowerCaseMapping:0x0A1B
  ,simpleTitleCaseMapping:0x0A1B
 },
 { code:0x0A1C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A1C
  ,simpleLowerCaseMapping:0x0A1C
  ,simpleTitleCaseMapping:0x0A1C
 },
 { code:0x0A1D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A1D
  ,simpleLowerCaseMapping:0x0A1D
  ,simpleTitleCaseMapping:0x0A1D
 },
 { code:0x0A1E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A1E
  ,simpleLowerCaseMapping:0x0A1E
  ,simpleTitleCaseMapping:0x0A1E
 },
 { code:0x0A1F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A1F
  ,simpleLowerCaseMapping:0x0A1F
  ,simpleTitleCaseMapping:0x0A1F
 },
 { code:0x0A20
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A20
  ,simpleLowerCaseMapping:0x0A20
  ,simpleTitleCaseMapping:0x0A20
 },
 { code:0x0A21
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A21
  ,simpleLowerCaseMapping:0x0A21
  ,simpleTitleCaseMapping:0x0A21
 },
 { code:0x0A22
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A22
  ,simpleLowerCaseMapping:0x0A22
  ,simpleTitleCaseMapping:0x0A22
 },
 { code:0x0A23
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A23
  ,simpleLowerCaseMapping:0x0A23
  ,simpleTitleCaseMapping:0x0A23
 },
 { code:0x0A24
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A24
  ,simpleLowerCaseMapping:0x0A24
  ,simpleTitleCaseMapping:0x0A24
 },
 { code:0x0A25
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A25
  ,simpleLowerCaseMapping:0x0A25
  ,simpleTitleCaseMapping:0x0A25
 },
 { code:0x0A26
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A26
  ,simpleLowerCaseMapping:0x0A26
  ,simpleTitleCaseMapping:0x0A26
 },
 { code:0x0A27
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A27
  ,simpleLowerCaseMapping:0x0A27
  ,simpleTitleCaseMapping:0x0A27
 },
 { code:0x0A28
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A28
  ,simpleLowerCaseMapping:0x0A28
  ,simpleTitleCaseMapping:0x0A28
 },
 { code:0x0A2A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A2A
  ,simpleLowerCaseMapping:0x0A2A
  ,simpleTitleCaseMapping:0x0A2A
 },
 { code:0x0A2B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A2B
  ,simpleLowerCaseMapping:0x0A2B
  ,simpleTitleCaseMapping:0x0A2B
 },
 { code:0x0A2C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A2C
  ,simpleLowerCaseMapping:0x0A2C
  ,simpleTitleCaseMapping:0x0A2C
 },
 { code:0x0A2D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A2D
  ,simpleLowerCaseMapping:0x0A2D
  ,simpleTitleCaseMapping:0x0A2D
 },
 { code:0x0A2E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A2E
  ,simpleLowerCaseMapping:0x0A2E
  ,simpleTitleCaseMapping:0x0A2E
 },
 { code:0x0A2F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A2F
  ,simpleLowerCaseMapping:0x0A2F
  ,simpleTitleCaseMapping:0x0A2F
 },
 { code:0x0A30
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A30
  ,simpleLowerCaseMapping:0x0A30
  ,simpleTitleCaseMapping:0x0A30
 },
 { code:0x0A32
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A32
  ,simpleLowerCaseMapping:0x0A32
  ,simpleTitleCaseMapping:0x0A32
 },
 { code:0x0A33
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A33
  ,simpleLowerCaseMapping:0x0A33
  ,simpleTitleCaseMapping:0x0A33
 },
 { code:0x0A35
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A35
  ,simpleLowerCaseMapping:0x0A35
  ,simpleTitleCaseMapping:0x0A35
 },
 { code:0x0A36
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A36
  ,simpleLowerCaseMapping:0x0A36
  ,simpleTitleCaseMapping:0x0A36
 },
 { code:0x0A38
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A38
  ,simpleLowerCaseMapping:0x0A38
  ,simpleTitleCaseMapping:0x0A38
 },
 { code:0x0A39
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A39
  ,simpleLowerCaseMapping:0x0A39
  ,simpleTitleCaseMapping:0x0A39
 },
 { code:0x0A3C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A3C
  ,simpleLowerCaseMapping:0x0A3C
  ,simpleTitleCaseMapping:0x0A3C
 },
 { code:0x0A3E
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0A3E
  ,simpleLowerCaseMapping:0x0A3E
  ,simpleTitleCaseMapping:0x0A3E
 },
 { code:0x0A3F
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0A3F
  ,simpleLowerCaseMapping:0x0A3F
  ,simpleTitleCaseMapping:0x0A3F
 },
 { code:0x0A40
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0A40
  ,simpleLowerCaseMapping:0x0A40
  ,simpleTitleCaseMapping:0x0A40
 },
 { code:0x0A41
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A41
  ,simpleLowerCaseMapping:0x0A41
  ,simpleTitleCaseMapping:0x0A41
 },
 { code:0x0A42
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A42
  ,simpleLowerCaseMapping:0x0A42
  ,simpleTitleCaseMapping:0x0A42
 },
 { code:0x0A47
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A47
  ,simpleLowerCaseMapping:0x0A47
  ,simpleTitleCaseMapping:0x0A47
 },
 { code:0x0A48
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A48
  ,simpleLowerCaseMapping:0x0A48
  ,simpleTitleCaseMapping:0x0A48
 },
 { code:0x0A4B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A4B
  ,simpleLowerCaseMapping:0x0A4B
  ,simpleTitleCaseMapping:0x0A4B
 },
 { code:0x0A4C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A4C
  ,simpleLowerCaseMapping:0x0A4C
  ,simpleTitleCaseMapping:0x0A4C
 },
 { code:0x0A4D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A4D
  ,simpleLowerCaseMapping:0x0A4D
  ,simpleTitleCaseMapping:0x0A4D
 },
 { code:0x0A59
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A59
  ,simpleLowerCaseMapping:0x0A59
  ,simpleTitleCaseMapping:0x0A59
 },
 { code:0x0A5A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A5A
  ,simpleLowerCaseMapping:0x0A5A
  ,simpleTitleCaseMapping:0x0A5A
 },
 { code:0x0A5B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A5B
  ,simpleLowerCaseMapping:0x0A5B
  ,simpleTitleCaseMapping:0x0A5B
 },
 { code:0x0A5C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A5C
  ,simpleLowerCaseMapping:0x0A5C
  ,simpleTitleCaseMapping:0x0A5C
 },
 { code:0x0A5E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A5E
  ,simpleLowerCaseMapping:0x0A5E
  ,simpleTitleCaseMapping:0x0A5E
 },
 { code:0x0A66
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0A66
  ,simpleLowerCaseMapping:0x0A66
  ,simpleTitleCaseMapping:0x0A66
 },
 { code:0x0A67
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0A67
  ,simpleLowerCaseMapping:0x0A67
  ,simpleTitleCaseMapping:0x0A67
 },
 { code:0x0A68
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0A68
  ,simpleLowerCaseMapping:0x0A68
  ,simpleTitleCaseMapping:0x0A68
 },
 { code:0x0A69
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0A69
  ,simpleLowerCaseMapping:0x0A69
  ,simpleTitleCaseMapping:0x0A69
 },
 { code:0x0A6A
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0A6A
  ,simpleLowerCaseMapping:0x0A6A
  ,simpleTitleCaseMapping:0x0A6A
 },
 { code:0x0A6B
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0A6B
  ,simpleLowerCaseMapping:0x0A6B
  ,simpleTitleCaseMapping:0x0A6B
 },
 { code:0x0A6C
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0A6C
  ,simpleLowerCaseMapping:0x0A6C
  ,simpleTitleCaseMapping:0x0A6C
 },
 { code:0x0A6D
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0A6D
  ,simpleLowerCaseMapping:0x0A6D
  ,simpleTitleCaseMapping:0x0A6D
 },
 { code:0x0A6E
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0A6E
  ,simpleLowerCaseMapping:0x0A6E
  ,simpleTitleCaseMapping:0x0A6E
 },
 { code:0x0A6F
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0A6F
  ,simpleLowerCaseMapping:0x0A6F
  ,simpleTitleCaseMapping:0x0A6F
 },
 { code:0x0A70
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A70
  ,simpleLowerCaseMapping:0x0A70
  ,simpleTitleCaseMapping:0x0A70
 },
 { code:0x0A71
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A71
  ,simpleLowerCaseMapping:0x0A71
  ,simpleTitleCaseMapping:0x0A71
 },
 { code:0x0A72
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A72
  ,simpleLowerCaseMapping:0x0A72
  ,simpleTitleCaseMapping:0x0A72
 },
 { code:0x0A73
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A73
  ,simpleLowerCaseMapping:0x0A73
  ,simpleTitleCaseMapping:0x0A73
 },
 { code:0x0A74
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A74
  ,simpleLowerCaseMapping:0x0A74
  ,simpleTitleCaseMapping:0x0A74
 },
 { code:0x0A81
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A81
  ,simpleLowerCaseMapping:0x0A81
  ,simpleTitleCaseMapping:0x0A81
 },
 { code:0x0A82
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0A82
  ,simpleLowerCaseMapping:0x0A82
  ,simpleTitleCaseMapping:0x0A82
 },
 { code:0x0A83
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0A83
  ,simpleLowerCaseMapping:0x0A83
  ,simpleTitleCaseMapping:0x0A83
 },
 { code:0x0A85
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A85
  ,simpleLowerCaseMapping:0x0A85
  ,simpleTitleCaseMapping:0x0A85
 },
 { code:0x0A86
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A86
  ,simpleLowerCaseMapping:0x0A86
  ,simpleTitleCaseMapping:0x0A86
 },
 { code:0x0A87
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A87
  ,simpleLowerCaseMapping:0x0A87
  ,simpleTitleCaseMapping:0x0A87
 },
 { code:0x0A88
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A88
  ,simpleLowerCaseMapping:0x0A88
  ,simpleTitleCaseMapping:0x0A88
 },
 { code:0x0A89
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A89
  ,simpleLowerCaseMapping:0x0A89
  ,simpleTitleCaseMapping:0x0A89
 },
 { code:0x0A8A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A8A
  ,simpleLowerCaseMapping:0x0A8A
  ,simpleTitleCaseMapping:0x0A8A
 },
 { code:0x0A8B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A8B
  ,simpleLowerCaseMapping:0x0A8B
  ,simpleTitleCaseMapping:0x0A8B
 },
 { code:0x0A8C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A8C
  ,simpleLowerCaseMapping:0x0A8C
  ,simpleTitleCaseMapping:0x0A8C
 },
 { code:0x0A8D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A8D
  ,simpleLowerCaseMapping:0x0A8D
  ,simpleTitleCaseMapping:0x0A8D
 },
 { code:0x0A8F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A8F
  ,simpleLowerCaseMapping:0x0A8F
  ,simpleTitleCaseMapping:0x0A8F
 },
 { code:0x0A90
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A90
  ,simpleLowerCaseMapping:0x0A90
  ,simpleTitleCaseMapping:0x0A90
 },
 { code:0x0A91
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A91
  ,simpleLowerCaseMapping:0x0A91
  ,simpleTitleCaseMapping:0x0A91
 },
 { code:0x0A93
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A93
  ,simpleLowerCaseMapping:0x0A93
  ,simpleTitleCaseMapping:0x0A93
 },
 { code:0x0A94
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A94
  ,simpleLowerCaseMapping:0x0A94
  ,simpleTitleCaseMapping:0x0A94
 },
 { code:0x0A95
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A95
  ,simpleLowerCaseMapping:0x0A95
  ,simpleTitleCaseMapping:0x0A95
 },
 { code:0x0A96
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A96
  ,simpleLowerCaseMapping:0x0A96
  ,simpleTitleCaseMapping:0x0A96
 },
 { code:0x0A97
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A97
  ,simpleLowerCaseMapping:0x0A97
  ,simpleTitleCaseMapping:0x0A97
 },
 { code:0x0A98
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A98
  ,simpleLowerCaseMapping:0x0A98
  ,simpleTitleCaseMapping:0x0A98
 },
 { code:0x0A99
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A99
  ,simpleLowerCaseMapping:0x0A99
  ,simpleTitleCaseMapping:0x0A99
 },
 { code:0x0A9A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A9A
  ,simpleLowerCaseMapping:0x0A9A
  ,simpleTitleCaseMapping:0x0A9A
 },
 { code:0x0A9B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A9B
  ,simpleLowerCaseMapping:0x0A9B
  ,simpleTitleCaseMapping:0x0A9B
 },
 { code:0x0A9C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A9C
  ,simpleLowerCaseMapping:0x0A9C
  ,simpleTitleCaseMapping:0x0A9C
 },
 { code:0x0A9D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A9D
  ,simpleLowerCaseMapping:0x0A9D
  ,simpleTitleCaseMapping:0x0A9D
 },
 { code:0x0A9E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A9E
  ,simpleLowerCaseMapping:0x0A9E
  ,simpleTitleCaseMapping:0x0A9E
 },
 { code:0x0A9F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0A9F
  ,simpleLowerCaseMapping:0x0A9F
  ,simpleTitleCaseMapping:0x0A9F
 },
 { code:0x0AA0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AA0
  ,simpleLowerCaseMapping:0x0AA0
  ,simpleTitleCaseMapping:0x0AA0
 },
 { code:0x0AA1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AA1
  ,simpleLowerCaseMapping:0x0AA1
  ,simpleTitleCaseMapping:0x0AA1
 },
 { code:0x0AA2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AA2
  ,simpleLowerCaseMapping:0x0AA2
  ,simpleTitleCaseMapping:0x0AA2
 },
 { code:0x0AA3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AA3
  ,simpleLowerCaseMapping:0x0AA3
  ,simpleTitleCaseMapping:0x0AA3
 },
 { code:0x0AA4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AA4
  ,simpleLowerCaseMapping:0x0AA4
  ,simpleTitleCaseMapping:0x0AA4
 },
 { code:0x0AA5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AA5
  ,simpleLowerCaseMapping:0x0AA5
  ,simpleTitleCaseMapping:0x0AA5
 },
 { code:0x0AA6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AA6
  ,simpleLowerCaseMapping:0x0AA6
  ,simpleTitleCaseMapping:0x0AA6
 },
 { code:0x0AA7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AA7
  ,simpleLowerCaseMapping:0x0AA7
  ,simpleTitleCaseMapping:0x0AA7
 },
 { code:0x0AA8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AA8
  ,simpleLowerCaseMapping:0x0AA8
  ,simpleTitleCaseMapping:0x0AA8
 },
 { code:0x0AAA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AAA
  ,simpleLowerCaseMapping:0x0AAA
  ,simpleTitleCaseMapping:0x0AAA
 },
 { code:0x0AAB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AAB
  ,simpleLowerCaseMapping:0x0AAB
  ,simpleTitleCaseMapping:0x0AAB
 },
 { code:0x0AAC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AAC
  ,simpleLowerCaseMapping:0x0AAC
  ,simpleTitleCaseMapping:0x0AAC
 },
 { code:0x0AAD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AAD
  ,simpleLowerCaseMapping:0x0AAD
  ,simpleTitleCaseMapping:0x0AAD
 },
 { code:0x0AAE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AAE
  ,simpleLowerCaseMapping:0x0AAE
  ,simpleTitleCaseMapping:0x0AAE
 },
 { code:0x0AAF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AAF
  ,simpleLowerCaseMapping:0x0AAF
  ,simpleTitleCaseMapping:0x0AAF
 },
 { code:0x0AB0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AB0
  ,simpleLowerCaseMapping:0x0AB0
  ,simpleTitleCaseMapping:0x0AB0
 },
 { code:0x0AB2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AB2
  ,simpleLowerCaseMapping:0x0AB2
  ,simpleTitleCaseMapping:0x0AB2
 },
 { code:0x0AB3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AB3
  ,simpleLowerCaseMapping:0x0AB3
  ,simpleTitleCaseMapping:0x0AB3
 },
 { code:0x0AB5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AB5
  ,simpleLowerCaseMapping:0x0AB5
  ,simpleTitleCaseMapping:0x0AB5
 },
 { code:0x0AB6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AB6
  ,simpleLowerCaseMapping:0x0AB6
  ,simpleTitleCaseMapping:0x0AB6
 },
 { code:0x0AB7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AB7
  ,simpleLowerCaseMapping:0x0AB7
  ,simpleTitleCaseMapping:0x0AB7
 },
 { code:0x0AB8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AB8
  ,simpleLowerCaseMapping:0x0AB8
  ,simpleTitleCaseMapping:0x0AB8
 },
 { code:0x0AB9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AB9
  ,simpleLowerCaseMapping:0x0AB9
  ,simpleTitleCaseMapping:0x0AB9
 },
 { code:0x0ABC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0ABC
  ,simpleLowerCaseMapping:0x0ABC
  ,simpleTitleCaseMapping:0x0ABC
 },
 { code:0x0ABD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0ABD
  ,simpleLowerCaseMapping:0x0ABD
  ,simpleTitleCaseMapping:0x0ABD
 },
 { code:0x0ABE
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0ABE
  ,simpleLowerCaseMapping:0x0ABE
  ,simpleTitleCaseMapping:0x0ABE
 },
 { code:0x0ABF
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0ABF
  ,simpleLowerCaseMapping:0x0ABF
  ,simpleTitleCaseMapping:0x0ABF
 },
 { code:0x0AC0
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0AC0
  ,simpleLowerCaseMapping:0x0AC0
  ,simpleTitleCaseMapping:0x0AC0
 },
 { code:0x0AC1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0AC1
  ,simpleLowerCaseMapping:0x0AC1
  ,simpleTitleCaseMapping:0x0AC1
 },
 { code:0x0AC2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0AC2
  ,simpleLowerCaseMapping:0x0AC2
  ,simpleTitleCaseMapping:0x0AC2
 },
 { code:0x0AC3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0AC3
  ,simpleLowerCaseMapping:0x0AC3
  ,simpleTitleCaseMapping:0x0AC3
 },
 { code:0x0AC4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0AC4
  ,simpleLowerCaseMapping:0x0AC4
  ,simpleTitleCaseMapping:0x0AC4
 },
 { code:0x0AC5
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0AC5
  ,simpleLowerCaseMapping:0x0AC5
  ,simpleTitleCaseMapping:0x0AC5
 },
 { code:0x0AC7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0AC7
  ,simpleLowerCaseMapping:0x0AC7
  ,simpleTitleCaseMapping:0x0AC7
 },
 { code:0x0AC8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0AC8
  ,simpleLowerCaseMapping:0x0AC8
  ,simpleTitleCaseMapping:0x0AC8
 },
 { code:0x0AC9
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0AC9
  ,simpleLowerCaseMapping:0x0AC9
  ,simpleTitleCaseMapping:0x0AC9
 },
 { code:0x0ACB
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0ACB
  ,simpleLowerCaseMapping:0x0ACB
  ,simpleTitleCaseMapping:0x0ACB
 },
 { code:0x0ACC
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0ACC
  ,simpleLowerCaseMapping:0x0ACC
  ,simpleTitleCaseMapping:0x0ACC
 },
 { code:0x0ACD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0ACD
  ,simpleLowerCaseMapping:0x0ACD
  ,simpleTitleCaseMapping:0x0ACD
 },
 { code:0x0AD0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AD0
  ,simpleLowerCaseMapping:0x0AD0
  ,simpleTitleCaseMapping:0x0AD0
 },
 { code:0x0AE0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AE0
  ,simpleLowerCaseMapping:0x0AE0
  ,simpleTitleCaseMapping:0x0AE0
 },
 { code:0x0AE1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0AE1
  ,simpleLowerCaseMapping:0x0AE1
  ,simpleTitleCaseMapping:0x0AE1
 },
 { code:0x0AE2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0AE2
  ,simpleLowerCaseMapping:0x0AE2
  ,simpleTitleCaseMapping:0x0AE2
 },
 { code:0x0AE3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0AE3
  ,simpleLowerCaseMapping:0x0AE3
  ,simpleTitleCaseMapping:0x0AE3
 },
 { code:0x0AE6
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0AE6
  ,simpleLowerCaseMapping:0x0AE6
  ,simpleTitleCaseMapping:0x0AE6
 },
 { code:0x0AE7
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0AE7
  ,simpleLowerCaseMapping:0x0AE7
  ,simpleTitleCaseMapping:0x0AE7
 },
 { code:0x0AE8
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0AE8
  ,simpleLowerCaseMapping:0x0AE8
  ,simpleTitleCaseMapping:0x0AE8
 },
 { code:0x0AE9
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0AE9
  ,simpleLowerCaseMapping:0x0AE9
  ,simpleTitleCaseMapping:0x0AE9
 },
 { code:0x0AEA
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0AEA
  ,simpleLowerCaseMapping:0x0AEA
  ,simpleTitleCaseMapping:0x0AEA
 },
 { code:0x0AEB
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0AEB
  ,simpleLowerCaseMapping:0x0AEB
  ,simpleTitleCaseMapping:0x0AEB
 },
 { code:0x0AEC
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0AEC
  ,simpleLowerCaseMapping:0x0AEC
  ,simpleTitleCaseMapping:0x0AEC
 },
 { code:0x0AED
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0AED
  ,simpleLowerCaseMapping:0x0AED
  ,simpleTitleCaseMapping:0x0AED
 },
 { code:0x0AEE
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0AEE
  ,simpleLowerCaseMapping:0x0AEE
  ,simpleTitleCaseMapping:0x0AEE
 },
 { code:0x0AEF
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0AEF
  ,simpleLowerCaseMapping:0x0AEF
  ,simpleTitleCaseMapping:0x0AEF
 },
 { code:0x0AF1
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x0AF1
  ,simpleLowerCaseMapping:0x0AF1
  ,simpleTitleCaseMapping:0x0AF1
 },
 { code:0x0B01
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0B01
  ,simpleLowerCaseMapping:0x0B01
  ,simpleTitleCaseMapping:0x0B01
 },
 { code:0x0B02
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0B02
  ,simpleLowerCaseMapping:0x0B02
  ,simpleTitleCaseMapping:0x0B02
 },
 { code:0x0B03
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0B03
  ,simpleLowerCaseMapping:0x0B03
  ,simpleTitleCaseMapping:0x0B03
 },
 { code:0x0B05
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B05
  ,simpleLowerCaseMapping:0x0B05
  ,simpleTitleCaseMapping:0x0B05
 },
 { code:0x0B06
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B06
  ,simpleLowerCaseMapping:0x0B06
  ,simpleTitleCaseMapping:0x0B06
 },
 { code:0x0B07
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B07
  ,simpleLowerCaseMapping:0x0B07
  ,simpleTitleCaseMapping:0x0B07
 },
 { code:0x0B08
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B08
  ,simpleLowerCaseMapping:0x0B08
  ,simpleTitleCaseMapping:0x0B08
 },
 { code:0x0B09
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B09
  ,simpleLowerCaseMapping:0x0B09
  ,simpleTitleCaseMapping:0x0B09
 },
 { code:0x0B0A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B0A
  ,simpleLowerCaseMapping:0x0B0A
  ,simpleTitleCaseMapping:0x0B0A
 },
 { code:0x0B0B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B0B
  ,simpleLowerCaseMapping:0x0B0B
  ,simpleTitleCaseMapping:0x0B0B
 },
 { code:0x0B0C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B0C
  ,simpleLowerCaseMapping:0x0B0C
  ,simpleTitleCaseMapping:0x0B0C
 },
 { code:0x0B0F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B0F
  ,simpleLowerCaseMapping:0x0B0F
  ,simpleTitleCaseMapping:0x0B0F
 },
 { code:0x0B10
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B10
  ,simpleLowerCaseMapping:0x0B10
  ,simpleTitleCaseMapping:0x0B10
 },
 { code:0x0B13
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B13
  ,simpleLowerCaseMapping:0x0B13
  ,simpleTitleCaseMapping:0x0B13
 },
 { code:0x0B14
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B14
  ,simpleLowerCaseMapping:0x0B14
  ,simpleTitleCaseMapping:0x0B14
 },
 { code:0x0B15
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B15
  ,simpleLowerCaseMapping:0x0B15
  ,simpleTitleCaseMapping:0x0B15
 },
 { code:0x0B16
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B16
  ,simpleLowerCaseMapping:0x0B16
  ,simpleTitleCaseMapping:0x0B16
 },
 { code:0x0B17
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B17
  ,simpleLowerCaseMapping:0x0B17
  ,simpleTitleCaseMapping:0x0B17
 },
 { code:0x0B18
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B18
  ,simpleLowerCaseMapping:0x0B18
  ,simpleTitleCaseMapping:0x0B18
 },
 { code:0x0B19
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B19
  ,simpleLowerCaseMapping:0x0B19
  ,simpleTitleCaseMapping:0x0B19
 },
 { code:0x0B1A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B1A
  ,simpleLowerCaseMapping:0x0B1A
  ,simpleTitleCaseMapping:0x0B1A
 },
 { code:0x0B1B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B1B
  ,simpleLowerCaseMapping:0x0B1B
  ,simpleTitleCaseMapping:0x0B1B
 },
 { code:0x0B1C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B1C
  ,simpleLowerCaseMapping:0x0B1C
  ,simpleTitleCaseMapping:0x0B1C
 },
 { code:0x0B1D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B1D
  ,simpleLowerCaseMapping:0x0B1D
  ,simpleTitleCaseMapping:0x0B1D
 },
 { code:0x0B1E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B1E
  ,simpleLowerCaseMapping:0x0B1E
  ,simpleTitleCaseMapping:0x0B1E
 },
 { code:0x0B1F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B1F
  ,simpleLowerCaseMapping:0x0B1F
  ,simpleTitleCaseMapping:0x0B1F
 },
 { code:0x0B20
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B20
  ,simpleLowerCaseMapping:0x0B20
  ,simpleTitleCaseMapping:0x0B20
 },
 { code:0x0B21
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B21
  ,simpleLowerCaseMapping:0x0B21
  ,simpleTitleCaseMapping:0x0B21
 },
 { code:0x0B22
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B22
  ,simpleLowerCaseMapping:0x0B22
  ,simpleTitleCaseMapping:0x0B22
 },
 { code:0x0B23
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B23
  ,simpleLowerCaseMapping:0x0B23
  ,simpleTitleCaseMapping:0x0B23
 },
 { code:0x0B24
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B24
  ,simpleLowerCaseMapping:0x0B24
  ,simpleTitleCaseMapping:0x0B24
 },
 { code:0x0B25
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B25
  ,simpleLowerCaseMapping:0x0B25
  ,simpleTitleCaseMapping:0x0B25
 },
 { code:0x0B26
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B26
  ,simpleLowerCaseMapping:0x0B26
  ,simpleTitleCaseMapping:0x0B26
 },
 { code:0x0B27
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B27
  ,simpleLowerCaseMapping:0x0B27
  ,simpleTitleCaseMapping:0x0B27
 },
 { code:0x0B28
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B28
  ,simpleLowerCaseMapping:0x0B28
  ,simpleTitleCaseMapping:0x0B28
 },
 { code:0x0B2A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B2A
  ,simpleLowerCaseMapping:0x0B2A
  ,simpleTitleCaseMapping:0x0B2A
 },
 { code:0x0B2B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B2B
  ,simpleLowerCaseMapping:0x0B2B
  ,simpleTitleCaseMapping:0x0B2B
 },
 { code:0x0B2C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B2C
  ,simpleLowerCaseMapping:0x0B2C
  ,simpleTitleCaseMapping:0x0B2C
 },
 { code:0x0B2D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B2D
  ,simpleLowerCaseMapping:0x0B2D
  ,simpleTitleCaseMapping:0x0B2D
 },
 { code:0x0B2E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B2E
  ,simpleLowerCaseMapping:0x0B2E
  ,simpleTitleCaseMapping:0x0B2E
 },
 { code:0x0B2F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B2F
  ,simpleLowerCaseMapping:0x0B2F
  ,simpleTitleCaseMapping:0x0B2F
 },
 { code:0x0B30
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B30
  ,simpleLowerCaseMapping:0x0B30
  ,simpleTitleCaseMapping:0x0B30
 },
 { code:0x0B32
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B32
  ,simpleLowerCaseMapping:0x0B32
  ,simpleTitleCaseMapping:0x0B32
 },
 { code:0x0B33
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B33
  ,simpleLowerCaseMapping:0x0B33
  ,simpleTitleCaseMapping:0x0B33
 },
 { code:0x0B35
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B35
  ,simpleLowerCaseMapping:0x0B35
  ,simpleTitleCaseMapping:0x0B35
 },
 { code:0x0B36
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B36
  ,simpleLowerCaseMapping:0x0B36
  ,simpleTitleCaseMapping:0x0B36
 },
 { code:0x0B37
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B37
  ,simpleLowerCaseMapping:0x0B37
  ,simpleTitleCaseMapping:0x0B37
 },
 { code:0x0B38
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B38
  ,simpleLowerCaseMapping:0x0B38
  ,simpleTitleCaseMapping:0x0B38
 },
 { code:0x0B39
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B39
  ,simpleLowerCaseMapping:0x0B39
  ,simpleTitleCaseMapping:0x0B39
 },
 { code:0x0B3C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0B3C
  ,simpleLowerCaseMapping:0x0B3C
  ,simpleTitleCaseMapping:0x0B3C
 },
 { code:0x0B3D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B3D
  ,simpleLowerCaseMapping:0x0B3D
  ,simpleTitleCaseMapping:0x0B3D
 },
 { code:0x0B3E
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0B3E
  ,simpleLowerCaseMapping:0x0B3E
  ,simpleTitleCaseMapping:0x0B3E
 },
 { code:0x0B3F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0B3F
  ,simpleLowerCaseMapping:0x0B3F
  ,simpleTitleCaseMapping:0x0B3F
 },
 { code:0x0B40
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0B40
  ,simpleLowerCaseMapping:0x0B40
  ,simpleTitleCaseMapping:0x0B40
 },
 { code:0x0B41
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0B41
  ,simpleLowerCaseMapping:0x0B41
  ,simpleTitleCaseMapping:0x0B41
 },
 { code:0x0B42
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0B42
  ,simpleLowerCaseMapping:0x0B42
  ,simpleTitleCaseMapping:0x0B42
 },
 { code:0x0B43
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0B43
  ,simpleLowerCaseMapping:0x0B43
  ,simpleTitleCaseMapping:0x0B43
 },
 { code:0x0B47
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0B47
  ,simpleLowerCaseMapping:0x0B47
  ,simpleTitleCaseMapping:0x0B47
 },
 { code:0x0B48
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0B48
  ,simpleLowerCaseMapping:0x0B48
  ,simpleTitleCaseMapping:0x0B48
 },
 { code:0x0B4B
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0B4B
  ,simpleLowerCaseMapping:0x0B4B
  ,simpleTitleCaseMapping:0x0B4B
 },
 { code:0x0B4C
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0B4C
  ,simpleLowerCaseMapping:0x0B4C
  ,simpleTitleCaseMapping:0x0B4C
 },
 { code:0x0B4D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0B4D
  ,simpleLowerCaseMapping:0x0B4D
  ,simpleTitleCaseMapping:0x0B4D
 },
 { code:0x0B56
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0B56
  ,simpleLowerCaseMapping:0x0B56
  ,simpleTitleCaseMapping:0x0B56
 },
 { code:0x0B57
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0B57
  ,simpleLowerCaseMapping:0x0B57
  ,simpleTitleCaseMapping:0x0B57
 },
 { code:0x0B5C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B5C
  ,simpleLowerCaseMapping:0x0B5C
  ,simpleTitleCaseMapping:0x0B5C
 },
 { code:0x0B5D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B5D
  ,simpleLowerCaseMapping:0x0B5D
  ,simpleTitleCaseMapping:0x0B5D
 },
 { code:0x0B5F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B5F
  ,simpleLowerCaseMapping:0x0B5F
  ,simpleTitleCaseMapping:0x0B5F
 },
 { code:0x0B60
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B60
  ,simpleLowerCaseMapping:0x0B60
  ,simpleTitleCaseMapping:0x0B60
 },
 { code:0x0B61
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B61
  ,simpleLowerCaseMapping:0x0B61
  ,simpleTitleCaseMapping:0x0B61
 },
 { code:0x0B66
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0B66
  ,simpleLowerCaseMapping:0x0B66
  ,simpleTitleCaseMapping:0x0B66
 },
 { code:0x0B67
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0B67
  ,simpleLowerCaseMapping:0x0B67
  ,simpleTitleCaseMapping:0x0B67
 },
 { code:0x0B68
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0B68
  ,simpleLowerCaseMapping:0x0B68
  ,simpleTitleCaseMapping:0x0B68
 },
 { code:0x0B69
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0B69
  ,simpleLowerCaseMapping:0x0B69
  ,simpleTitleCaseMapping:0x0B69
 },
 { code:0x0B6A
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0B6A
  ,simpleLowerCaseMapping:0x0B6A
  ,simpleTitleCaseMapping:0x0B6A
 },
 { code:0x0B6B
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0B6B
  ,simpleLowerCaseMapping:0x0B6B
  ,simpleTitleCaseMapping:0x0B6B
 },
 { code:0x0B6C
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0B6C
  ,simpleLowerCaseMapping:0x0B6C
  ,simpleTitleCaseMapping:0x0B6C
 },
 { code:0x0B6D
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0B6D
  ,simpleLowerCaseMapping:0x0B6D
  ,simpleTitleCaseMapping:0x0B6D
 },
 { code:0x0B6E
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0B6E
  ,simpleLowerCaseMapping:0x0B6E
  ,simpleTitleCaseMapping:0x0B6E
 },
 { code:0x0B6F
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0B6F
  ,simpleLowerCaseMapping:0x0B6F
  ,simpleTitleCaseMapping:0x0B6F
 },
 { code:0x0B70
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0B70
  ,simpleLowerCaseMapping:0x0B70
  ,simpleTitleCaseMapping:0x0B70
 },
 { code:0x0B71
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B71
  ,simpleLowerCaseMapping:0x0B71
  ,simpleTitleCaseMapping:0x0B71
 },
 { code:0x0B82
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0B82
  ,simpleLowerCaseMapping:0x0B82
  ,simpleTitleCaseMapping:0x0B82
 },
 { code:0x0B83
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B83
  ,simpleLowerCaseMapping:0x0B83
  ,simpleTitleCaseMapping:0x0B83
 },
 { code:0x0B85
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B85
  ,simpleLowerCaseMapping:0x0B85
  ,simpleTitleCaseMapping:0x0B85
 },
 { code:0x0B86
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B86
  ,simpleLowerCaseMapping:0x0B86
  ,simpleTitleCaseMapping:0x0B86
 },
 { code:0x0B87
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B87
  ,simpleLowerCaseMapping:0x0B87
  ,simpleTitleCaseMapping:0x0B87
 },
 { code:0x0B88
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B88
  ,simpleLowerCaseMapping:0x0B88
  ,simpleTitleCaseMapping:0x0B88
 },
 { code:0x0B89
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B89
  ,simpleLowerCaseMapping:0x0B89
  ,simpleTitleCaseMapping:0x0B89
 },
 { code:0x0B8A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B8A
  ,simpleLowerCaseMapping:0x0B8A
  ,simpleTitleCaseMapping:0x0B8A
 },
 { code:0x0B8E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B8E
  ,simpleLowerCaseMapping:0x0B8E
  ,simpleTitleCaseMapping:0x0B8E
 },
 { code:0x0B8F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B8F
  ,simpleLowerCaseMapping:0x0B8F
  ,simpleTitleCaseMapping:0x0B8F
 },
 { code:0x0B90
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B90
  ,simpleLowerCaseMapping:0x0B90
  ,simpleTitleCaseMapping:0x0B90
 },
 { code:0x0B92
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B92
  ,simpleLowerCaseMapping:0x0B92
  ,simpleTitleCaseMapping:0x0B92
 },
 { code:0x0B93
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B93
  ,simpleLowerCaseMapping:0x0B93
  ,simpleTitleCaseMapping:0x0B93
 },
 { code:0x0B94
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B94
  ,simpleLowerCaseMapping:0x0B94
  ,simpleTitleCaseMapping:0x0B94
 },
 { code:0x0B95
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B95
  ,simpleLowerCaseMapping:0x0B95
  ,simpleTitleCaseMapping:0x0B95
 },
 { code:0x0B99
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B99
  ,simpleLowerCaseMapping:0x0B99
  ,simpleTitleCaseMapping:0x0B99
 },
 { code:0x0B9A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B9A
  ,simpleLowerCaseMapping:0x0B9A
  ,simpleTitleCaseMapping:0x0B9A
 },
 { code:0x0B9C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B9C
  ,simpleLowerCaseMapping:0x0B9C
  ,simpleTitleCaseMapping:0x0B9C
 },
 { code:0x0B9E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B9E
  ,simpleLowerCaseMapping:0x0B9E
  ,simpleTitleCaseMapping:0x0B9E
 },
 { code:0x0B9F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0B9F
  ,simpleLowerCaseMapping:0x0B9F
  ,simpleTitleCaseMapping:0x0B9F
 },
 { code:0x0BA3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BA3
  ,simpleLowerCaseMapping:0x0BA3
  ,simpleTitleCaseMapping:0x0BA3
 },
 { code:0x0BA4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BA4
  ,simpleLowerCaseMapping:0x0BA4
  ,simpleTitleCaseMapping:0x0BA4
 },
 { code:0x0BA8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BA8
  ,simpleLowerCaseMapping:0x0BA8
  ,simpleTitleCaseMapping:0x0BA8
 },
 { code:0x0BA9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BA9
  ,simpleLowerCaseMapping:0x0BA9
  ,simpleTitleCaseMapping:0x0BA9
 },
 { code:0x0BAA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BAA
  ,simpleLowerCaseMapping:0x0BAA
  ,simpleTitleCaseMapping:0x0BAA
 },
 { code:0x0BAE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BAE
  ,simpleLowerCaseMapping:0x0BAE
  ,simpleTitleCaseMapping:0x0BAE
 },
 { code:0x0BAF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BAF
  ,simpleLowerCaseMapping:0x0BAF
  ,simpleTitleCaseMapping:0x0BAF
 },
 { code:0x0BB0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BB0
  ,simpleLowerCaseMapping:0x0BB0
  ,simpleTitleCaseMapping:0x0BB0
 },
 { code:0x0BB1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BB1
  ,simpleLowerCaseMapping:0x0BB1
  ,simpleTitleCaseMapping:0x0BB1
 },
 { code:0x0BB2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BB2
  ,simpleLowerCaseMapping:0x0BB2
  ,simpleTitleCaseMapping:0x0BB2
 },
 { code:0x0BB3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BB3
  ,simpleLowerCaseMapping:0x0BB3
  ,simpleTitleCaseMapping:0x0BB3
 },
 { code:0x0BB4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BB4
  ,simpleLowerCaseMapping:0x0BB4
  ,simpleTitleCaseMapping:0x0BB4
 },
 { code:0x0BB5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BB5
  ,simpleLowerCaseMapping:0x0BB5
  ,simpleTitleCaseMapping:0x0BB5
 },
 { code:0x0BB6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BB6
  ,simpleLowerCaseMapping:0x0BB6
  ,simpleTitleCaseMapping:0x0BB6
 },
 { code:0x0BB7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BB7
  ,simpleLowerCaseMapping:0x0BB7
  ,simpleTitleCaseMapping:0x0BB7
 },
 { code:0x0BB8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BB8
  ,simpleLowerCaseMapping:0x0BB8
  ,simpleTitleCaseMapping:0x0BB8
 },
 { code:0x0BB9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0BB9
  ,simpleLowerCaseMapping:0x0BB9
  ,simpleTitleCaseMapping:0x0BB9
 },
 { code:0x0BBE
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BBE
  ,simpleLowerCaseMapping:0x0BBE
  ,simpleTitleCaseMapping:0x0BBE
 },
 { code:0x0BBF
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BBF
  ,simpleLowerCaseMapping:0x0BBF
  ,simpleTitleCaseMapping:0x0BBF
 },
 { code:0x0BC0
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0BC0
  ,simpleLowerCaseMapping:0x0BC0
  ,simpleTitleCaseMapping:0x0BC0
 },
 { code:0x0BC1
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BC1
  ,simpleLowerCaseMapping:0x0BC1
  ,simpleTitleCaseMapping:0x0BC1
 },
 { code:0x0BC2
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BC2
  ,simpleLowerCaseMapping:0x0BC2
  ,simpleTitleCaseMapping:0x0BC2
 },
 { code:0x0BC6
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BC6
  ,simpleLowerCaseMapping:0x0BC6
  ,simpleTitleCaseMapping:0x0BC6
 },
 { code:0x0BC7
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BC7
  ,simpleLowerCaseMapping:0x0BC7
  ,simpleTitleCaseMapping:0x0BC7
 },
 { code:0x0BC8
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BC8
  ,simpleLowerCaseMapping:0x0BC8
  ,simpleTitleCaseMapping:0x0BC8
 },
 { code:0x0BCA
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BCA
  ,simpleLowerCaseMapping:0x0BCA
  ,simpleTitleCaseMapping:0x0BCA
 },
 { code:0x0BCB
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BCB
  ,simpleLowerCaseMapping:0x0BCB
  ,simpleTitleCaseMapping:0x0BCB
 },
 { code:0x0BCC
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BCC
  ,simpleLowerCaseMapping:0x0BCC
  ,simpleTitleCaseMapping:0x0BCC
 },
 { code:0x0BCD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0BCD
  ,simpleLowerCaseMapping:0x0BCD
  ,simpleTitleCaseMapping:0x0BCD
 },
 { code:0x0BD7
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0BD7
  ,simpleLowerCaseMapping:0x0BD7
  ,simpleTitleCaseMapping:0x0BD7
 },
 { code:0x0BE6
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0BE6
  ,simpleLowerCaseMapping:0x0BE6
  ,simpleTitleCaseMapping:0x0BE6
 },
 { code:0x0BE7
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0BE7
  ,simpleLowerCaseMapping:0x0BE7
  ,simpleTitleCaseMapping:0x0BE7
 },
 { code:0x0BE8
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0BE8
  ,simpleLowerCaseMapping:0x0BE8
  ,simpleTitleCaseMapping:0x0BE8
 },
 { code:0x0BE9
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0BE9
  ,simpleLowerCaseMapping:0x0BE9
  ,simpleTitleCaseMapping:0x0BE9
 },
 { code:0x0BEA
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0BEA
  ,simpleLowerCaseMapping:0x0BEA
  ,simpleTitleCaseMapping:0x0BEA
 },
 { code:0x0BEB
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0BEB
  ,simpleLowerCaseMapping:0x0BEB
  ,simpleTitleCaseMapping:0x0BEB
 },
 { code:0x0BEC
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0BEC
  ,simpleLowerCaseMapping:0x0BEC
  ,simpleTitleCaseMapping:0x0BEC
 },
 { code:0x0BED
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0BED
  ,simpleLowerCaseMapping:0x0BED
  ,simpleTitleCaseMapping:0x0BED
 },
 { code:0x0BEE
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0BEE
  ,simpleLowerCaseMapping:0x0BEE
  ,simpleTitleCaseMapping:0x0BEE
 },
 { code:0x0BEF
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0BEF
  ,simpleLowerCaseMapping:0x0BEF
  ,simpleTitleCaseMapping:0x0BEF
 },
 { code:0x0BF0
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0BF0
  ,simpleLowerCaseMapping:0x0BF0
  ,simpleTitleCaseMapping:0x0BF0
 },
 { code:0x0BF1
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0BF1
  ,simpleLowerCaseMapping:0x0BF1
  ,simpleTitleCaseMapping:0x0BF1
 },
 { code:0x0BF2
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0BF2
  ,simpleLowerCaseMapping:0x0BF2
  ,simpleTitleCaseMapping:0x0BF2
 },
 { code:0x0BF3
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0BF3
  ,simpleLowerCaseMapping:0x0BF3
  ,simpleTitleCaseMapping:0x0BF3
 },
 { code:0x0BF4
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0BF4
  ,simpleLowerCaseMapping:0x0BF4
  ,simpleTitleCaseMapping:0x0BF4
 },
 { code:0x0BF5
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0BF5
  ,simpleLowerCaseMapping:0x0BF5
  ,simpleTitleCaseMapping:0x0BF5
 },
 { code:0x0BF6
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0BF6
  ,simpleLowerCaseMapping:0x0BF6
  ,simpleTitleCaseMapping:0x0BF6
 },
 { code:0x0BF7
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0BF7
  ,simpleLowerCaseMapping:0x0BF7
  ,simpleTitleCaseMapping:0x0BF7
 },
 { code:0x0BF8
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0BF8
  ,simpleLowerCaseMapping:0x0BF8
  ,simpleTitleCaseMapping:0x0BF8
 },
 { code:0x0BF9
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x0BF9
  ,simpleLowerCaseMapping:0x0BF9
  ,simpleTitleCaseMapping:0x0BF9
 },
 { code:0x0BFA
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0BFA
  ,simpleLowerCaseMapping:0x0BFA
  ,simpleTitleCaseMapping:0x0BFA
 },
 { code:0x0C01
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0C01
  ,simpleLowerCaseMapping:0x0C01
  ,simpleTitleCaseMapping:0x0C01
 },
 { code:0x0C02
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0C02
  ,simpleLowerCaseMapping:0x0C02
  ,simpleTitleCaseMapping:0x0C02
 },
 { code:0x0C03
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0C03
  ,simpleLowerCaseMapping:0x0C03
  ,simpleTitleCaseMapping:0x0C03
 },
 { code:0x0C05
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C05
  ,simpleLowerCaseMapping:0x0C05
  ,simpleTitleCaseMapping:0x0C05
 },
 { code:0x0C06
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C06
  ,simpleLowerCaseMapping:0x0C06
  ,simpleTitleCaseMapping:0x0C06
 },
 { code:0x0C07
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C07
  ,simpleLowerCaseMapping:0x0C07
  ,simpleTitleCaseMapping:0x0C07
 },
 { code:0x0C08
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C08
  ,simpleLowerCaseMapping:0x0C08
  ,simpleTitleCaseMapping:0x0C08
 },
 { code:0x0C09
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C09
  ,simpleLowerCaseMapping:0x0C09
  ,simpleTitleCaseMapping:0x0C09
 },
 { code:0x0C0A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C0A
  ,simpleLowerCaseMapping:0x0C0A
  ,simpleTitleCaseMapping:0x0C0A
 },
 { code:0x0C0B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C0B
  ,simpleLowerCaseMapping:0x0C0B
  ,simpleTitleCaseMapping:0x0C0B
 },
 { code:0x0C0C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C0C
  ,simpleLowerCaseMapping:0x0C0C
  ,simpleTitleCaseMapping:0x0C0C
 },
 { code:0x0C0E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C0E
  ,simpleLowerCaseMapping:0x0C0E
  ,simpleTitleCaseMapping:0x0C0E
 },
 { code:0x0C0F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C0F
  ,simpleLowerCaseMapping:0x0C0F
  ,simpleTitleCaseMapping:0x0C0F
 },
 { code:0x0C10
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C10
  ,simpleLowerCaseMapping:0x0C10
  ,simpleTitleCaseMapping:0x0C10
 },
 { code:0x0C12
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C12
  ,simpleLowerCaseMapping:0x0C12
  ,simpleTitleCaseMapping:0x0C12
 },
 { code:0x0C13
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C13
  ,simpleLowerCaseMapping:0x0C13
  ,simpleTitleCaseMapping:0x0C13
 },
 { code:0x0C14
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C14
  ,simpleLowerCaseMapping:0x0C14
  ,simpleTitleCaseMapping:0x0C14
 },
 { code:0x0C15
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C15
  ,simpleLowerCaseMapping:0x0C15
  ,simpleTitleCaseMapping:0x0C15
 },
 { code:0x0C16
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C16
  ,simpleLowerCaseMapping:0x0C16
  ,simpleTitleCaseMapping:0x0C16
 },
 { code:0x0C17
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C17
  ,simpleLowerCaseMapping:0x0C17
  ,simpleTitleCaseMapping:0x0C17
 },
 { code:0x0C18
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C18
  ,simpleLowerCaseMapping:0x0C18
  ,simpleTitleCaseMapping:0x0C18
 },
 { code:0x0C19
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C19
  ,simpleLowerCaseMapping:0x0C19
  ,simpleTitleCaseMapping:0x0C19
 },
 { code:0x0C1A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C1A
  ,simpleLowerCaseMapping:0x0C1A
  ,simpleTitleCaseMapping:0x0C1A
 },
 { code:0x0C1B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C1B
  ,simpleLowerCaseMapping:0x0C1B
  ,simpleTitleCaseMapping:0x0C1B
 },
 { code:0x0C1C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C1C
  ,simpleLowerCaseMapping:0x0C1C
  ,simpleTitleCaseMapping:0x0C1C
 },
 { code:0x0C1D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C1D
  ,simpleLowerCaseMapping:0x0C1D
  ,simpleTitleCaseMapping:0x0C1D
 },
 { code:0x0C1E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C1E
  ,simpleLowerCaseMapping:0x0C1E
  ,simpleTitleCaseMapping:0x0C1E
 },
 { code:0x0C1F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C1F
  ,simpleLowerCaseMapping:0x0C1F
  ,simpleTitleCaseMapping:0x0C1F
 },
 { code:0x0C20
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C20
  ,simpleLowerCaseMapping:0x0C20
  ,simpleTitleCaseMapping:0x0C20
 },
 { code:0x0C21
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C21
  ,simpleLowerCaseMapping:0x0C21
  ,simpleTitleCaseMapping:0x0C21
 },
 { code:0x0C22
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C22
  ,simpleLowerCaseMapping:0x0C22
  ,simpleTitleCaseMapping:0x0C22
 },
 { code:0x0C23
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C23
  ,simpleLowerCaseMapping:0x0C23
  ,simpleTitleCaseMapping:0x0C23
 },
 { code:0x0C24
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C24
  ,simpleLowerCaseMapping:0x0C24
  ,simpleTitleCaseMapping:0x0C24
 },
 { code:0x0C25
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C25
  ,simpleLowerCaseMapping:0x0C25
  ,simpleTitleCaseMapping:0x0C25
 },
 { code:0x0C26
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C26
  ,simpleLowerCaseMapping:0x0C26
  ,simpleTitleCaseMapping:0x0C26
 },
 { code:0x0C27
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C27
  ,simpleLowerCaseMapping:0x0C27
  ,simpleTitleCaseMapping:0x0C27
 },
 { code:0x0C28
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C28
  ,simpleLowerCaseMapping:0x0C28
  ,simpleTitleCaseMapping:0x0C28
 },
 { code:0x0C2A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C2A
  ,simpleLowerCaseMapping:0x0C2A
  ,simpleTitleCaseMapping:0x0C2A
 },
 { code:0x0C2B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C2B
  ,simpleLowerCaseMapping:0x0C2B
  ,simpleTitleCaseMapping:0x0C2B
 },
 { code:0x0C2C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C2C
  ,simpleLowerCaseMapping:0x0C2C
  ,simpleTitleCaseMapping:0x0C2C
 },
 { code:0x0C2D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C2D
  ,simpleLowerCaseMapping:0x0C2D
  ,simpleTitleCaseMapping:0x0C2D
 },
 { code:0x0C2E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C2E
  ,simpleLowerCaseMapping:0x0C2E
  ,simpleTitleCaseMapping:0x0C2E
 },
 { code:0x0C2F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C2F
  ,simpleLowerCaseMapping:0x0C2F
  ,simpleTitleCaseMapping:0x0C2F
 },
 { code:0x0C30
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C30
  ,simpleLowerCaseMapping:0x0C30
  ,simpleTitleCaseMapping:0x0C30
 },
 { code:0x0C31
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C31
  ,simpleLowerCaseMapping:0x0C31
  ,simpleTitleCaseMapping:0x0C31
 },
 { code:0x0C32
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C32
  ,simpleLowerCaseMapping:0x0C32
  ,simpleTitleCaseMapping:0x0C32
 },
 { code:0x0C33
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C33
  ,simpleLowerCaseMapping:0x0C33
  ,simpleTitleCaseMapping:0x0C33
 },
 { code:0x0C35
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C35
  ,simpleLowerCaseMapping:0x0C35
  ,simpleTitleCaseMapping:0x0C35
 },
 { code:0x0C36
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C36
  ,simpleLowerCaseMapping:0x0C36
  ,simpleTitleCaseMapping:0x0C36
 },
 { code:0x0C37
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C37
  ,simpleLowerCaseMapping:0x0C37
  ,simpleTitleCaseMapping:0x0C37
 },
 { code:0x0C38
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C38
  ,simpleLowerCaseMapping:0x0C38
  ,simpleTitleCaseMapping:0x0C38
 },
 { code:0x0C39
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C39
  ,simpleLowerCaseMapping:0x0C39
  ,simpleTitleCaseMapping:0x0C39
 },
 { code:0x0C3E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C3E
  ,simpleLowerCaseMapping:0x0C3E
  ,simpleTitleCaseMapping:0x0C3E
 },
 { code:0x0C3F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C3F
  ,simpleLowerCaseMapping:0x0C3F
  ,simpleTitleCaseMapping:0x0C3F
 },
 { code:0x0C40
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C40
  ,simpleLowerCaseMapping:0x0C40
  ,simpleTitleCaseMapping:0x0C40
 },
 { code:0x0C41
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0C41
  ,simpleLowerCaseMapping:0x0C41
  ,simpleTitleCaseMapping:0x0C41
 },
 { code:0x0C42
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0C42
  ,simpleLowerCaseMapping:0x0C42
  ,simpleTitleCaseMapping:0x0C42
 },
 { code:0x0C43
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0C43
  ,simpleLowerCaseMapping:0x0C43
  ,simpleTitleCaseMapping:0x0C43
 },
 { code:0x0C44
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0C44
  ,simpleLowerCaseMapping:0x0C44
  ,simpleTitleCaseMapping:0x0C44
 },
 { code:0x0C46
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C46
  ,simpleLowerCaseMapping:0x0C46
  ,simpleTitleCaseMapping:0x0C46
 },
 { code:0x0C47
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C47
  ,simpleLowerCaseMapping:0x0C47
  ,simpleTitleCaseMapping:0x0C47
 },
 { code:0x0C48
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C48
  ,simpleLowerCaseMapping:0x0C48
  ,simpleTitleCaseMapping:0x0C48
 },
 { code:0x0C4A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C4A
  ,simpleLowerCaseMapping:0x0C4A
  ,simpleTitleCaseMapping:0x0C4A
 },
 { code:0x0C4B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C4B
  ,simpleLowerCaseMapping:0x0C4B
  ,simpleTitleCaseMapping:0x0C4B
 },
 { code:0x0C4C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C4C
  ,simpleLowerCaseMapping:0x0C4C
  ,simpleTitleCaseMapping:0x0C4C
 },
 { code:0x0C4D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C4D
  ,simpleLowerCaseMapping:0x0C4D
  ,simpleTitleCaseMapping:0x0C4D
 },
 { code:0x0C55
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C55
  ,simpleLowerCaseMapping:0x0C55
  ,simpleTitleCaseMapping:0x0C55
 },
 { code:0x0C56
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0C56
  ,simpleLowerCaseMapping:0x0C56
  ,simpleTitleCaseMapping:0x0C56
 },
 { code:0x0C60
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C60
  ,simpleLowerCaseMapping:0x0C60
  ,simpleTitleCaseMapping:0x0C60
 },
 { code:0x0C61
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C61
  ,simpleLowerCaseMapping:0x0C61
  ,simpleTitleCaseMapping:0x0C61
 },
 { code:0x0C66
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0C66
  ,simpleLowerCaseMapping:0x0C66
  ,simpleTitleCaseMapping:0x0C66
 },
 { code:0x0C67
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0C67
  ,simpleLowerCaseMapping:0x0C67
  ,simpleTitleCaseMapping:0x0C67
 },
 { code:0x0C68
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0C68
  ,simpleLowerCaseMapping:0x0C68
  ,simpleTitleCaseMapping:0x0C68
 },
 { code:0x0C69
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0C69
  ,simpleLowerCaseMapping:0x0C69
  ,simpleTitleCaseMapping:0x0C69
 },
 { code:0x0C6A
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0C6A
  ,simpleLowerCaseMapping:0x0C6A
  ,simpleTitleCaseMapping:0x0C6A
 },
 { code:0x0C6B
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0C6B
  ,simpleLowerCaseMapping:0x0C6B
  ,simpleTitleCaseMapping:0x0C6B
 },
 { code:0x0C6C
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0C6C
  ,simpleLowerCaseMapping:0x0C6C
  ,simpleTitleCaseMapping:0x0C6C
 },
 { code:0x0C6D
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0C6D
  ,simpleLowerCaseMapping:0x0C6D
  ,simpleTitleCaseMapping:0x0C6D
 },
 { code:0x0C6E
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0C6E
  ,simpleLowerCaseMapping:0x0C6E
  ,simpleTitleCaseMapping:0x0C6E
 },
 { code:0x0C6F
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0C6F
  ,simpleLowerCaseMapping:0x0C6F
  ,simpleTitleCaseMapping:0x0C6F
 },
 { code:0x0C82
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0C82
  ,simpleLowerCaseMapping:0x0C82
  ,simpleTitleCaseMapping:0x0C82
 },
 { code:0x0C83
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0C83
  ,simpleLowerCaseMapping:0x0C83
  ,simpleTitleCaseMapping:0x0C83
 },
 { code:0x0C85
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C85
  ,simpleLowerCaseMapping:0x0C85
  ,simpleTitleCaseMapping:0x0C85
 },
 { code:0x0C86
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C86
  ,simpleLowerCaseMapping:0x0C86
  ,simpleTitleCaseMapping:0x0C86
 },
 { code:0x0C87
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C87
  ,simpleLowerCaseMapping:0x0C87
  ,simpleTitleCaseMapping:0x0C87
 },
 { code:0x0C88
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C88
  ,simpleLowerCaseMapping:0x0C88
  ,simpleTitleCaseMapping:0x0C88
 },
 { code:0x0C89
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C89
  ,simpleLowerCaseMapping:0x0C89
  ,simpleTitleCaseMapping:0x0C89
 },
 { code:0x0C8A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C8A
  ,simpleLowerCaseMapping:0x0C8A
  ,simpleTitleCaseMapping:0x0C8A
 },
 { code:0x0C8B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C8B
  ,simpleLowerCaseMapping:0x0C8B
  ,simpleTitleCaseMapping:0x0C8B
 },
 { code:0x0C8C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C8C
  ,simpleLowerCaseMapping:0x0C8C
  ,simpleTitleCaseMapping:0x0C8C
 },
 { code:0x0C8E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C8E
  ,simpleLowerCaseMapping:0x0C8E
  ,simpleTitleCaseMapping:0x0C8E
 },
 { code:0x0C8F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C8F
  ,simpleLowerCaseMapping:0x0C8F
  ,simpleTitleCaseMapping:0x0C8F
 },
 { code:0x0C90
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C90
  ,simpleLowerCaseMapping:0x0C90
  ,simpleTitleCaseMapping:0x0C90
 },
 { code:0x0C92
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C92
  ,simpleLowerCaseMapping:0x0C92
  ,simpleTitleCaseMapping:0x0C92
 },
 { code:0x0C93
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C93
  ,simpleLowerCaseMapping:0x0C93
  ,simpleTitleCaseMapping:0x0C93
 },
 { code:0x0C94
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C94
  ,simpleLowerCaseMapping:0x0C94
  ,simpleTitleCaseMapping:0x0C94
 },
 { code:0x0C95
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C95
  ,simpleLowerCaseMapping:0x0C95
  ,simpleTitleCaseMapping:0x0C95
 },
 { code:0x0C96
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C96
  ,simpleLowerCaseMapping:0x0C96
  ,simpleTitleCaseMapping:0x0C96
 },
 { code:0x0C97
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C97
  ,simpleLowerCaseMapping:0x0C97
  ,simpleTitleCaseMapping:0x0C97
 },
 { code:0x0C98
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C98
  ,simpleLowerCaseMapping:0x0C98
  ,simpleTitleCaseMapping:0x0C98
 },
 { code:0x0C99
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C99
  ,simpleLowerCaseMapping:0x0C99
  ,simpleTitleCaseMapping:0x0C99
 },
 { code:0x0C9A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C9A
  ,simpleLowerCaseMapping:0x0C9A
  ,simpleTitleCaseMapping:0x0C9A
 },
 { code:0x0C9B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C9B
  ,simpleLowerCaseMapping:0x0C9B
  ,simpleTitleCaseMapping:0x0C9B
 },
 { code:0x0C9C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C9C
  ,simpleLowerCaseMapping:0x0C9C
  ,simpleTitleCaseMapping:0x0C9C
 },
 { code:0x0C9D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C9D
  ,simpleLowerCaseMapping:0x0C9D
  ,simpleTitleCaseMapping:0x0C9D
 },
 { code:0x0C9E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C9E
  ,simpleLowerCaseMapping:0x0C9E
  ,simpleTitleCaseMapping:0x0C9E
 },
 { code:0x0C9F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0C9F
  ,simpleLowerCaseMapping:0x0C9F
  ,simpleTitleCaseMapping:0x0C9F
 },
 { code:0x0CA0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CA0
  ,simpleLowerCaseMapping:0x0CA0
  ,simpleTitleCaseMapping:0x0CA0
 },
 { code:0x0CA1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CA1
  ,simpleLowerCaseMapping:0x0CA1
  ,simpleTitleCaseMapping:0x0CA1
 },
 { code:0x0CA2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CA2
  ,simpleLowerCaseMapping:0x0CA2
  ,simpleTitleCaseMapping:0x0CA2
 },
 { code:0x0CA3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CA3
  ,simpleLowerCaseMapping:0x0CA3
  ,simpleTitleCaseMapping:0x0CA3
 },
 { code:0x0CA4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CA4
  ,simpleLowerCaseMapping:0x0CA4
  ,simpleTitleCaseMapping:0x0CA4
 },
 { code:0x0CA5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CA5
  ,simpleLowerCaseMapping:0x0CA5
  ,simpleTitleCaseMapping:0x0CA5
 },
 { code:0x0CA6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CA6
  ,simpleLowerCaseMapping:0x0CA6
  ,simpleTitleCaseMapping:0x0CA6
 },
 { code:0x0CA7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CA7
  ,simpleLowerCaseMapping:0x0CA7
  ,simpleTitleCaseMapping:0x0CA7
 },
 { code:0x0CA8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CA8
  ,simpleLowerCaseMapping:0x0CA8
  ,simpleTitleCaseMapping:0x0CA8
 },
 { code:0x0CAA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CAA
  ,simpleLowerCaseMapping:0x0CAA
  ,simpleTitleCaseMapping:0x0CAA
 },
 { code:0x0CAB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CAB
  ,simpleLowerCaseMapping:0x0CAB
  ,simpleTitleCaseMapping:0x0CAB
 },
 { code:0x0CAC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CAC
  ,simpleLowerCaseMapping:0x0CAC
  ,simpleTitleCaseMapping:0x0CAC
 },
 { code:0x0CAD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CAD
  ,simpleLowerCaseMapping:0x0CAD
  ,simpleTitleCaseMapping:0x0CAD
 },
 { code:0x0CAE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CAE
  ,simpleLowerCaseMapping:0x0CAE
  ,simpleTitleCaseMapping:0x0CAE
 },
 { code:0x0CAF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CAF
  ,simpleLowerCaseMapping:0x0CAF
  ,simpleTitleCaseMapping:0x0CAF
 },
 { code:0x0CB0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CB0
  ,simpleLowerCaseMapping:0x0CB0
  ,simpleTitleCaseMapping:0x0CB0
 },
 { code:0x0CB1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CB1
  ,simpleLowerCaseMapping:0x0CB1
  ,simpleTitleCaseMapping:0x0CB1
 },
 { code:0x0CB2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CB2
  ,simpleLowerCaseMapping:0x0CB2
  ,simpleTitleCaseMapping:0x0CB2
 },
 { code:0x0CB3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CB3
  ,simpleLowerCaseMapping:0x0CB3
  ,simpleTitleCaseMapping:0x0CB3
 },
 { code:0x0CB5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CB5
  ,simpleLowerCaseMapping:0x0CB5
  ,simpleTitleCaseMapping:0x0CB5
 },
 { code:0x0CB6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CB6
  ,simpleLowerCaseMapping:0x0CB6
  ,simpleTitleCaseMapping:0x0CB6
 },
 { code:0x0CB7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CB7
  ,simpleLowerCaseMapping:0x0CB7
  ,simpleTitleCaseMapping:0x0CB7
 },
 { code:0x0CB8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CB8
  ,simpleLowerCaseMapping:0x0CB8
  ,simpleTitleCaseMapping:0x0CB8
 },
 { code:0x0CB9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CB9
  ,simpleLowerCaseMapping:0x0CB9
  ,simpleTitleCaseMapping:0x0CB9
 },
 { code:0x0CBC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0CBC
  ,simpleLowerCaseMapping:0x0CBC
  ,simpleTitleCaseMapping:0x0CBC
 },
 { code:0x0CBD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CBD
  ,simpleLowerCaseMapping:0x0CBD
  ,simpleTitleCaseMapping:0x0CBD
 },
 { code:0x0CBE
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CBE
  ,simpleLowerCaseMapping:0x0CBE
  ,simpleTitleCaseMapping:0x0CBE
 },
 { code:0x0CBF
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0CBF
  ,simpleLowerCaseMapping:0x0CBF
  ,simpleTitleCaseMapping:0x0CBF
 },
 { code:0x0CC0
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CC0
  ,simpleLowerCaseMapping:0x0CC0
  ,simpleTitleCaseMapping:0x0CC0
 },
 { code:0x0CC1
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CC1
  ,simpleLowerCaseMapping:0x0CC1
  ,simpleTitleCaseMapping:0x0CC1
 },
 { code:0x0CC2
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CC2
  ,simpleLowerCaseMapping:0x0CC2
  ,simpleTitleCaseMapping:0x0CC2
 },
 { code:0x0CC3
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CC3
  ,simpleLowerCaseMapping:0x0CC3
  ,simpleTitleCaseMapping:0x0CC3
 },
 { code:0x0CC4
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CC4
  ,simpleLowerCaseMapping:0x0CC4
  ,simpleTitleCaseMapping:0x0CC4
 },
 { code:0x0CC6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0CC6
  ,simpleLowerCaseMapping:0x0CC6
  ,simpleTitleCaseMapping:0x0CC6
 },
 { code:0x0CC7
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CC7
  ,simpleLowerCaseMapping:0x0CC7
  ,simpleTitleCaseMapping:0x0CC7
 },
 { code:0x0CC8
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CC8
  ,simpleLowerCaseMapping:0x0CC8
  ,simpleTitleCaseMapping:0x0CC8
 },
 { code:0x0CCA
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CCA
  ,simpleLowerCaseMapping:0x0CCA
  ,simpleTitleCaseMapping:0x0CCA
 },
 { code:0x0CCB
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CCB
  ,simpleLowerCaseMapping:0x0CCB
  ,simpleTitleCaseMapping:0x0CCB
 },
 { code:0x0CCC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0CCC
  ,simpleLowerCaseMapping:0x0CCC
  ,simpleTitleCaseMapping:0x0CCC
 },
 { code:0x0CCD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0CCD
  ,simpleLowerCaseMapping:0x0CCD
  ,simpleTitleCaseMapping:0x0CCD
 },
 { code:0x0CD5
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CD5
  ,simpleLowerCaseMapping:0x0CD5
  ,simpleTitleCaseMapping:0x0CD5
 },
 { code:0x0CD6
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0CD6
  ,simpleLowerCaseMapping:0x0CD6
  ,simpleTitleCaseMapping:0x0CD6
 },
 { code:0x0CDE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CDE
  ,simpleLowerCaseMapping:0x0CDE
  ,simpleTitleCaseMapping:0x0CDE
 },
 { code:0x0CE0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CE0
  ,simpleLowerCaseMapping:0x0CE0
  ,simpleTitleCaseMapping:0x0CE0
 },
 { code:0x0CE1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0CE1
  ,simpleLowerCaseMapping:0x0CE1
  ,simpleTitleCaseMapping:0x0CE1
 },
 { code:0x0CE2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0CE2
  ,simpleLowerCaseMapping:0x0CE2
  ,simpleTitleCaseMapping:0x0CE2
 },
 { code:0x0CE3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0CE3
  ,simpleLowerCaseMapping:0x0CE3
  ,simpleTitleCaseMapping:0x0CE3
 },
 { code:0x0CE6
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0CE6
  ,simpleLowerCaseMapping:0x0CE6
  ,simpleTitleCaseMapping:0x0CE6
 },
 { code:0x0CE7
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0CE7
  ,simpleLowerCaseMapping:0x0CE7
  ,simpleTitleCaseMapping:0x0CE7
 },
 { code:0x0CE8
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0CE8
  ,simpleLowerCaseMapping:0x0CE8
  ,simpleTitleCaseMapping:0x0CE8
 },
 { code:0x0CE9
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0CE9
  ,simpleLowerCaseMapping:0x0CE9
  ,simpleTitleCaseMapping:0x0CE9
 },
 { code:0x0CEA
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0CEA
  ,simpleLowerCaseMapping:0x0CEA
  ,simpleTitleCaseMapping:0x0CEA
 },
 { code:0x0CEB
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0CEB
  ,simpleLowerCaseMapping:0x0CEB
  ,simpleTitleCaseMapping:0x0CEB
 },
 { code:0x0CEC
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0CEC
  ,simpleLowerCaseMapping:0x0CEC
  ,simpleTitleCaseMapping:0x0CEC
 },
 { code:0x0CED
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0CED
  ,simpleLowerCaseMapping:0x0CED
  ,simpleTitleCaseMapping:0x0CED
 },
 { code:0x0CEE
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0CEE
  ,simpleLowerCaseMapping:0x0CEE
  ,simpleTitleCaseMapping:0x0CEE
 },
 { code:0x0CEF
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0CEF
  ,simpleLowerCaseMapping:0x0CEF
  ,simpleTitleCaseMapping:0x0CEF
 },
 { code:0x0CF1
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0CF1
  ,simpleLowerCaseMapping:0x0CF1
  ,simpleTitleCaseMapping:0x0CF1
 },
 { code:0x0CF2
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0CF2
  ,simpleLowerCaseMapping:0x0CF2
  ,simpleTitleCaseMapping:0x0CF2
 },
 { code:0x0D02
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D02
  ,simpleLowerCaseMapping:0x0D02
  ,simpleTitleCaseMapping:0x0D02
 },
 { code:0x0D03
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D03
  ,simpleLowerCaseMapping:0x0D03
  ,simpleTitleCaseMapping:0x0D03
 },
 { code:0x0D05
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D05
  ,simpleLowerCaseMapping:0x0D05
  ,simpleTitleCaseMapping:0x0D05
 },
 { code:0x0D06
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D06
  ,simpleLowerCaseMapping:0x0D06
  ,simpleTitleCaseMapping:0x0D06
 },
 { code:0x0D07
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D07
  ,simpleLowerCaseMapping:0x0D07
  ,simpleTitleCaseMapping:0x0D07
 },
 { code:0x0D08
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D08
  ,simpleLowerCaseMapping:0x0D08
  ,simpleTitleCaseMapping:0x0D08
 },
 { code:0x0D09
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D09
  ,simpleLowerCaseMapping:0x0D09
  ,simpleTitleCaseMapping:0x0D09
 },
 { code:0x0D0A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D0A
  ,simpleLowerCaseMapping:0x0D0A
  ,simpleTitleCaseMapping:0x0D0A
 },
 { code:0x0D0B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D0B
  ,simpleLowerCaseMapping:0x0D0B
  ,simpleTitleCaseMapping:0x0D0B
 },
 { code:0x0D0C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D0C
  ,simpleLowerCaseMapping:0x0D0C
  ,simpleTitleCaseMapping:0x0D0C
 },
 { code:0x0D0E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D0E
  ,simpleLowerCaseMapping:0x0D0E
  ,simpleTitleCaseMapping:0x0D0E
 },
 { code:0x0D0F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D0F
  ,simpleLowerCaseMapping:0x0D0F
  ,simpleTitleCaseMapping:0x0D0F
 },
 { code:0x0D10
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D10
  ,simpleLowerCaseMapping:0x0D10
  ,simpleTitleCaseMapping:0x0D10
 },
 { code:0x0D12
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D12
  ,simpleLowerCaseMapping:0x0D12
  ,simpleTitleCaseMapping:0x0D12
 },
 { code:0x0D13
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D13
  ,simpleLowerCaseMapping:0x0D13
  ,simpleTitleCaseMapping:0x0D13
 },
 { code:0x0D14
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D14
  ,simpleLowerCaseMapping:0x0D14
  ,simpleTitleCaseMapping:0x0D14
 },
 { code:0x0D15
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D15
  ,simpleLowerCaseMapping:0x0D15
  ,simpleTitleCaseMapping:0x0D15
 },
 { code:0x0D16
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D16
  ,simpleLowerCaseMapping:0x0D16
  ,simpleTitleCaseMapping:0x0D16
 },
 { code:0x0D17
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D17
  ,simpleLowerCaseMapping:0x0D17
  ,simpleTitleCaseMapping:0x0D17
 },
 { code:0x0D18
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D18
  ,simpleLowerCaseMapping:0x0D18
  ,simpleTitleCaseMapping:0x0D18
 },
 { code:0x0D19
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D19
  ,simpleLowerCaseMapping:0x0D19
  ,simpleTitleCaseMapping:0x0D19
 },
 { code:0x0D1A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D1A
  ,simpleLowerCaseMapping:0x0D1A
  ,simpleTitleCaseMapping:0x0D1A
 },
 { code:0x0D1B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D1B
  ,simpleLowerCaseMapping:0x0D1B
  ,simpleTitleCaseMapping:0x0D1B
 },
 { code:0x0D1C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D1C
  ,simpleLowerCaseMapping:0x0D1C
  ,simpleTitleCaseMapping:0x0D1C
 },
 { code:0x0D1D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D1D
  ,simpleLowerCaseMapping:0x0D1D
  ,simpleTitleCaseMapping:0x0D1D
 },
 { code:0x0D1E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D1E
  ,simpleLowerCaseMapping:0x0D1E
  ,simpleTitleCaseMapping:0x0D1E
 },
 { code:0x0D1F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D1F
  ,simpleLowerCaseMapping:0x0D1F
  ,simpleTitleCaseMapping:0x0D1F
 },
 { code:0x0D20
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D20
  ,simpleLowerCaseMapping:0x0D20
  ,simpleTitleCaseMapping:0x0D20
 },
 { code:0x0D21
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D21
  ,simpleLowerCaseMapping:0x0D21
  ,simpleTitleCaseMapping:0x0D21
 },
 { code:0x0D22
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D22
  ,simpleLowerCaseMapping:0x0D22
  ,simpleTitleCaseMapping:0x0D22
 },
 { code:0x0D23
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D23
  ,simpleLowerCaseMapping:0x0D23
  ,simpleTitleCaseMapping:0x0D23
 },
 { code:0x0D24
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D24
  ,simpleLowerCaseMapping:0x0D24
  ,simpleTitleCaseMapping:0x0D24
 },
 { code:0x0D25
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D25
  ,simpleLowerCaseMapping:0x0D25
  ,simpleTitleCaseMapping:0x0D25
 },
 { code:0x0D26
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D26
  ,simpleLowerCaseMapping:0x0D26
  ,simpleTitleCaseMapping:0x0D26
 },
 { code:0x0D27
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D27
  ,simpleLowerCaseMapping:0x0D27
  ,simpleTitleCaseMapping:0x0D27
 },
 { code:0x0D28
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D28
  ,simpleLowerCaseMapping:0x0D28
  ,simpleTitleCaseMapping:0x0D28
 },
 { code:0x0D2A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D2A
  ,simpleLowerCaseMapping:0x0D2A
  ,simpleTitleCaseMapping:0x0D2A
 },
 { code:0x0D2B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D2B
  ,simpleLowerCaseMapping:0x0D2B
  ,simpleTitleCaseMapping:0x0D2B
 },
 { code:0x0D2C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D2C
  ,simpleLowerCaseMapping:0x0D2C
  ,simpleTitleCaseMapping:0x0D2C
 },
 { code:0x0D2D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D2D
  ,simpleLowerCaseMapping:0x0D2D
  ,simpleTitleCaseMapping:0x0D2D
 },
 { code:0x0D2E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D2E
  ,simpleLowerCaseMapping:0x0D2E
  ,simpleTitleCaseMapping:0x0D2E
 },
 { code:0x0D2F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D2F
  ,simpleLowerCaseMapping:0x0D2F
  ,simpleTitleCaseMapping:0x0D2F
 },
 { code:0x0D30
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D30
  ,simpleLowerCaseMapping:0x0D30
  ,simpleTitleCaseMapping:0x0D30
 },
 { code:0x0D31
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D31
  ,simpleLowerCaseMapping:0x0D31
  ,simpleTitleCaseMapping:0x0D31
 },
 { code:0x0D32
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D32
  ,simpleLowerCaseMapping:0x0D32
  ,simpleTitleCaseMapping:0x0D32
 },
 { code:0x0D33
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D33
  ,simpleLowerCaseMapping:0x0D33
  ,simpleTitleCaseMapping:0x0D33
 },
 { code:0x0D34
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D34
  ,simpleLowerCaseMapping:0x0D34
  ,simpleTitleCaseMapping:0x0D34
 },
 { code:0x0D35
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D35
  ,simpleLowerCaseMapping:0x0D35
  ,simpleTitleCaseMapping:0x0D35
 },
 { code:0x0D36
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D36
  ,simpleLowerCaseMapping:0x0D36
  ,simpleTitleCaseMapping:0x0D36
 },
 { code:0x0D37
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D37
  ,simpleLowerCaseMapping:0x0D37
  ,simpleTitleCaseMapping:0x0D37
 },
 { code:0x0D38
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D38
  ,simpleLowerCaseMapping:0x0D38
  ,simpleTitleCaseMapping:0x0D38
 },
 { code:0x0D39
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D39
  ,simpleLowerCaseMapping:0x0D39
  ,simpleTitleCaseMapping:0x0D39
 },
 { code:0x0D3E
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D3E
  ,simpleLowerCaseMapping:0x0D3E
  ,simpleTitleCaseMapping:0x0D3E
 },
 { code:0x0D3F
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D3F
  ,simpleLowerCaseMapping:0x0D3F
  ,simpleTitleCaseMapping:0x0D3F
 },
 { code:0x0D40
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D40
  ,simpleLowerCaseMapping:0x0D40
  ,simpleTitleCaseMapping:0x0D40
 },
 { code:0x0D41
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0D41
  ,simpleLowerCaseMapping:0x0D41
  ,simpleTitleCaseMapping:0x0D41
 },
 { code:0x0D42
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0D42
  ,simpleLowerCaseMapping:0x0D42
  ,simpleTitleCaseMapping:0x0D42
 },
 { code:0x0D43
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0D43
  ,simpleLowerCaseMapping:0x0D43
  ,simpleTitleCaseMapping:0x0D43
 },
 { code:0x0D46
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D46
  ,simpleLowerCaseMapping:0x0D46
  ,simpleTitleCaseMapping:0x0D46
 },
 { code:0x0D47
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D47
  ,simpleLowerCaseMapping:0x0D47
  ,simpleTitleCaseMapping:0x0D47
 },
 { code:0x0D48
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D48
  ,simpleLowerCaseMapping:0x0D48
  ,simpleTitleCaseMapping:0x0D48
 },
 { code:0x0D4A
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D4A
  ,simpleLowerCaseMapping:0x0D4A
  ,simpleTitleCaseMapping:0x0D4A
 },
 { code:0x0D4B
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D4B
  ,simpleLowerCaseMapping:0x0D4B
  ,simpleTitleCaseMapping:0x0D4B
 },
 { code:0x0D4C
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D4C
  ,simpleLowerCaseMapping:0x0D4C
  ,simpleTitleCaseMapping:0x0D4C
 },
 { code:0x0D4D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0D4D
  ,simpleLowerCaseMapping:0x0D4D
  ,simpleTitleCaseMapping:0x0D4D
 },
 { code:0x0D57
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D57
  ,simpleLowerCaseMapping:0x0D57
  ,simpleTitleCaseMapping:0x0D57
 },
 { code:0x0D60
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D60
  ,simpleLowerCaseMapping:0x0D60
  ,simpleTitleCaseMapping:0x0D60
 },
 { code:0x0D61
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D61
  ,simpleLowerCaseMapping:0x0D61
  ,simpleTitleCaseMapping:0x0D61
 },
 { code:0x0D66
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0D66
  ,simpleLowerCaseMapping:0x0D66
  ,simpleTitleCaseMapping:0x0D66
 },
 { code:0x0D67
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0D67
  ,simpleLowerCaseMapping:0x0D67
  ,simpleTitleCaseMapping:0x0D67
 },
 { code:0x0D68
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0D68
  ,simpleLowerCaseMapping:0x0D68
  ,simpleTitleCaseMapping:0x0D68
 },
 { code:0x0D69
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0D69
  ,simpleLowerCaseMapping:0x0D69
  ,simpleTitleCaseMapping:0x0D69
 },
 { code:0x0D6A
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0D6A
  ,simpleLowerCaseMapping:0x0D6A
  ,simpleTitleCaseMapping:0x0D6A
 },
 { code:0x0D6B
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0D6B
  ,simpleLowerCaseMapping:0x0D6B
  ,simpleTitleCaseMapping:0x0D6B
 },
 { code:0x0D6C
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0D6C
  ,simpleLowerCaseMapping:0x0D6C
  ,simpleTitleCaseMapping:0x0D6C
 },
 { code:0x0D6D
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0D6D
  ,simpleLowerCaseMapping:0x0D6D
  ,simpleTitleCaseMapping:0x0D6D
 },
 { code:0x0D6E
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0D6E
  ,simpleLowerCaseMapping:0x0D6E
  ,simpleTitleCaseMapping:0x0D6E
 },
 { code:0x0D6F
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0D6F
  ,simpleLowerCaseMapping:0x0D6F
  ,simpleTitleCaseMapping:0x0D6F
 },
 { code:0x0D82
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D82
  ,simpleLowerCaseMapping:0x0D82
  ,simpleTitleCaseMapping:0x0D82
 },
 { code:0x0D83
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0D83
  ,simpleLowerCaseMapping:0x0D83
  ,simpleTitleCaseMapping:0x0D83
 },
 { code:0x0D85
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D85
  ,simpleLowerCaseMapping:0x0D85
  ,simpleTitleCaseMapping:0x0D85
 },
 { code:0x0D86
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D86
  ,simpleLowerCaseMapping:0x0D86
  ,simpleTitleCaseMapping:0x0D86
 },
 { code:0x0D87
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D87
  ,simpleLowerCaseMapping:0x0D87
  ,simpleTitleCaseMapping:0x0D87
 },
 { code:0x0D88
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D88
  ,simpleLowerCaseMapping:0x0D88
  ,simpleTitleCaseMapping:0x0D88
 },
 { code:0x0D89
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D89
  ,simpleLowerCaseMapping:0x0D89
  ,simpleTitleCaseMapping:0x0D89
 },
 { code:0x0D8A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D8A
  ,simpleLowerCaseMapping:0x0D8A
  ,simpleTitleCaseMapping:0x0D8A
 },
 { code:0x0D8B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D8B
  ,simpleLowerCaseMapping:0x0D8B
  ,simpleTitleCaseMapping:0x0D8B
 },
 { code:0x0D8C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D8C
  ,simpleLowerCaseMapping:0x0D8C
  ,simpleTitleCaseMapping:0x0D8C
 },
 { code:0x0D8D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D8D
  ,simpleLowerCaseMapping:0x0D8D
  ,simpleTitleCaseMapping:0x0D8D
 },
 { code:0x0D8E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D8E
  ,simpleLowerCaseMapping:0x0D8E
  ,simpleTitleCaseMapping:0x0D8E
 },
 { code:0x0D8F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D8F
  ,simpleLowerCaseMapping:0x0D8F
  ,simpleTitleCaseMapping:0x0D8F
 },
 { code:0x0D90
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D90
  ,simpleLowerCaseMapping:0x0D90
  ,simpleTitleCaseMapping:0x0D90
 },
 { code:0x0D91
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D91
  ,simpleLowerCaseMapping:0x0D91
  ,simpleTitleCaseMapping:0x0D91
 },
 { code:0x0D92
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D92
  ,simpleLowerCaseMapping:0x0D92
  ,simpleTitleCaseMapping:0x0D92
 },
 { code:0x0D93
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D93
  ,simpleLowerCaseMapping:0x0D93
  ,simpleTitleCaseMapping:0x0D93
 },
 { code:0x0D94
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D94
  ,simpleLowerCaseMapping:0x0D94
  ,simpleTitleCaseMapping:0x0D94
 },
 { code:0x0D95
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D95
  ,simpleLowerCaseMapping:0x0D95
  ,simpleTitleCaseMapping:0x0D95
 },
 { code:0x0D96
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D96
  ,simpleLowerCaseMapping:0x0D96
  ,simpleTitleCaseMapping:0x0D96
 },
 { code:0x0D9A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D9A
  ,simpleLowerCaseMapping:0x0D9A
  ,simpleTitleCaseMapping:0x0D9A
 },
 { code:0x0D9B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D9B
  ,simpleLowerCaseMapping:0x0D9B
  ,simpleTitleCaseMapping:0x0D9B
 },
 { code:0x0D9C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D9C
  ,simpleLowerCaseMapping:0x0D9C
  ,simpleTitleCaseMapping:0x0D9C
 },
 { code:0x0D9D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D9D
  ,simpleLowerCaseMapping:0x0D9D
  ,simpleTitleCaseMapping:0x0D9D
 },
 { code:0x0D9E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D9E
  ,simpleLowerCaseMapping:0x0D9E
  ,simpleTitleCaseMapping:0x0D9E
 },
 { code:0x0D9F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0D9F
  ,simpleLowerCaseMapping:0x0D9F
  ,simpleTitleCaseMapping:0x0D9F
 },
 { code:0x0DA0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DA0
  ,simpleLowerCaseMapping:0x0DA0
  ,simpleTitleCaseMapping:0x0DA0
 },
 { code:0x0DA1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DA1
  ,simpleLowerCaseMapping:0x0DA1
  ,simpleTitleCaseMapping:0x0DA1
 },
 { code:0x0DA2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DA2
  ,simpleLowerCaseMapping:0x0DA2
  ,simpleTitleCaseMapping:0x0DA2
 },
 { code:0x0DA3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DA3
  ,simpleLowerCaseMapping:0x0DA3
  ,simpleTitleCaseMapping:0x0DA3
 },
 { code:0x0DA4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DA4
  ,simpleLowerCaseMapping:0x0DA4
  ,simpleTitleCaseMapping:0x0DA4
 },
 { code:0x0DA5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DA5
  ,simpleLowerCaseMapping:0x0DA5
  ,simpleTitleCaseMapping:0x0DA5
 },
 { code:0x0DA6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DA6
  ,simpleLowerCaseMapping:0x0DA6
  ,simpleTitleCaseMapping:0x0DA6
 },
 { code:0x0DA7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DA7
  ,simpleLowerCaseMapping:0x0DA7
  ,simpleTitleCaseMapping:0x0DA7
 },
 { code:0x0DA8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DA8
  ,simpleLowerCaseMapping:0x0DA8
  ,simpleTitleCaseMapping:0x0DA8
 },
 { code:0x0DA9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DA9
  ,simpleLowerCaseMapping:0x0DA9
  ,simpleTitleCaseMapping:0x0DA9
 },
 { code:0x0DAA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DAA
  ,simpleLowerCaseMapping:0x0DAA
  ,simpleTitleCaseMapping:0x0DAA
 },
 { code:0x0DAB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DAB
  ,simpleLowerCaseMapping:0x0DAB
  ,simpleTitleCaseMapping:0x0DAB
 },
 { code:0x0DAC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DAC
  ,simpleLowerCaseMapping:0x0DAC
  ,simpleTitleCaseMapping:0x0DAC
 },
 { code:0x0DAD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DAD
  ,simpleLowerCaseMapping:0x0DAD
  ,simpleTitleCaseMapping:0x0DAD
 },
 { code:0x0DAE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DAE
  ,simpleLowerCaseMapping:0x0DAE
  ,simpleTitleCaseMapping:0x0DAE
 },
 { code:0x0DAF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DAF
  ,simpleLowerCaseMapping:0x0DAF
  ,simpleTitleCaseMapping:0x0DAF
 },
 { code:0x0DB0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DB0
  ,simpleLowerCaseMapping:0x0DB0
  ,simpleTitleCaseMapping:0x0DB0
 },
 { code:0x0DB1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DB1
  ,simpleLowerCaseMapping:0x0DB1
  ,simpleTitleCaseMapping:0x0DB1
 },
 { code:0x0DB3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DB3
  ,simpleLowerCaseMapping:0x0DB3
  ,simpleTitleCaseMapping:0x0DB3
 },
 { code:0x0DB4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DB4
  ,simpleLowerCaseMapping:0x0DB4
  ,simpleTitleCaseMapping:0x0DB4
 },
 { code:0x0DB5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DB5
  ,simpleLowerCaseMapping:0x0DB5
  ,simpleTitleCaseMapping:0x0DB5
 },
 { code:0x0DB6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DB6
  ,simpleLowerCaseMapping:0x0DB6
  ,simpleTitleCaseMapping:0x0DB6
 },
 { code:0x0DB7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DB7
  ,simpleLowerCaseMapping:0x0DB7
  ,simpleTitleCaseMapping:0x0DB7
 },
 { code:0x0DB8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DB8
  ,simpleLowerCaseMapping:0x0DB8
  ,simpleTitleCaseMapping:0x0DB8
 },
 { code:0x0DB9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DB9
  ,simpleLowerCaseMapping:0x0DB9
  ,simpleTitleCaseMapping:0x0DB9
 },
 { code:0x0DBA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DBA
  ,simpleLowerCaseMapping:0x0DBA
  ,simpleTitleCaseMapping:0x0DBA
 },
 { code:0x0DBB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DBB
  ,simpleLowerCaseMapping:0x0DBB
  ,simpleTitleCaseMapping:0x0DBB
 },
 { code:0x0DBD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DBD
  ,simpleLowerCaseMapping:0x0DBD
  ,simpleTitleCaseMapping:0x0DBD
 },
 { code:0x0DC0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DC0
  ,simpleLowerCaseMapping:0x0DC0
  ,simpleTitleCaseMapping:0x0DC0
 },
 { code:0x0DC1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DC1
  ,simpleLowerCaseMapping:0x0DC1
  ,simpleTitleCaseMapping:0x0DC1
 },
 { code:0x0DC2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DC2
  ,simpleLowerCaseMapping:0x0DC2
  ,simpleTitleCaseMapping:0x0DC2
 },
 { code:0x0DC3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DC3
  ,simpleLowerCaseMapping:0x0DC3
  ,simpleTitleCaseMapping:0x0DC3
 },
 { code:0x0DC4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DC4
  ,simpleLowerCaseMapping:0x0DC4
  ,simpleTitleCaseMapping:0x0DC4
 },
 { code:0x0DC5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DC5
  ,simpleLowerCaseMapping:0x0DC5
  ,simpleTitleCaseMapping:0x0DC5
 },
 { code:0x0DC6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0DC6
  ,simpleLowerCaseMapping:0x0DC6
  ,simpleTitleCaseMapping:0x0DC6
 },
 { code:0x0DCA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0DCA
  ,simpleLowerCaseMapping:0x0DCA
  ,simpleTitleCaseMapping:0x0DCA
 },
 { code:0x0DCF
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DCF
  ,simpleLowerCaseMapping:0x0DCF
  ,simpleTitleCaseMapping:0x0DCF
 },
 { code:0x0DD0
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DD0
  ,simpleLowerCaseMapping:0x0DD0
  ,simpleTitleCaseMapping:0x0DD0
 },
 { code:0x0DD1
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DD1
  ,simpleLowerCaseMapping:0x0DD1
  ,simpleTitleCaseMapping:0x0DD1
 },
 { code:0x0DD2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0DD2
  ,simpleLowerCaseMapping:0x0DD2
  ,simpleTitleCaseMapping:0x0DD2
 },
 { code:0x0DD3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0DD3
  ,simpleLowerCaseMapping:0x0DD3
  ,simpleTitleCaseMapping:0x0DD3
 },
 { code:0x0DD4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0DD4
  ,simpleLowerCaseMapping:0x0DD4
  ,simpleTitleCaseMapping:0x0DD4
 },
 { code:0x0DD6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0DD6
  ,simpleLowerCaseMapping:0x0DD6
  ,simpleTitleCaseMapping:0x0DD6
 },
 { code:0x0DD8
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DD8
  ,simpleLowerCaseMapping:0x0DD8
  ,simpleTitleCaseMapping:0x0DD8
 },
 { code:0x0DD9
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DD9
  ,simpleLowerCaseMapping:0x0DD9
  ,simpleTitleCaseMapping:0x0DD9
 },
 { code:0x0DDA
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DDA
  ,simpleLowerCaseMapping:0x0DDA
  ,simpleTitleCaseMapping:0x0DDA
 },
 { code:0x0DDB
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DDB
  ,simpleLowerCaseMapping:0x0DDB
  ,simpleTitleCaseMapping:0x0DDB
 },
 { code:0x0DDC
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DDC
  ,simpleLowerCaseMapping:0x0DDC
  ,simpleTitleCaseMapping:0x0DDC
 },
 { code:0x0DDD
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DDD
  ,simpleLowerCaseMapping:0x0DDD
  ,simpleTitleCaseMapping:0x0DDD
 },
 { code:0x0DDE
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DDE
  ,simpleLowerCaseMapping:0x0DDE
  ,simpleTitleCaseMapping:0x0DDE
 },
 { code:0x0DDF
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DDF
  ,simpleLowerCaseMapping:0x0DDF
  ,simpleTitleCaseMapping:0x0DDF
 },
 { code:0x0DF2
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DF2
  ,simpleLowerCaseMapping:0x0DF2
  ,simpleTitleCaseMapping:0x0DF2
 },
 { code:0x0DF3
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0DF3
  ,simpleLowerCaseMapping:0x0DF3
  ,simpleTitleCaseMapping:0x0DF3
 },
 { code:0x0DF4
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0DF4
  ,simpleLowerCaseMapping:0x0DF4
  ,simpleTitleCaseMapping:0x0DF4
 },
 { code:0x0E01
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E01
  ,simpleLowerCaseMapping:0x0E01
  ,simpleTitleCaseMapping:0x0E01
 },
 { code:0x0E02
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E02
  ,simpleLowerCaseMapping:0x0E02
  ,simpleTitleCaseMapping:0x0E02
 },
 { code:0x0E03
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E03
  ,simpleLowerCaseMapping:0x0E03
  ,simpleTitleCaseMapping:0x0E03
 },
 { code:0x0E04
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E04
  ,simpleLowerCaseMapping:0x0E04
  ,simpleTitleCaseMapping:0x0E04
 },
 { code:0x0E05
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E05
  ,simpleLowerCaseMapping:0x0E05
  ,simpleTitleCaseMapping:0x0E05
 },
 { code:0x0E06
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E06
  ,simpleLowerCaseMapping:0x0E06
  ,simpleTitleCaseMapping:0x0E06
 },
 { code:0x0E07
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E07
  ,simpleLowerCaseMapping:0x0E07
  ,simpleTitleCaseMapping:0x0E07
 },
 { code:0x0E08
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E08
  ,simpleLowerCaseMapping:0x0E08
  ,simpleTitleCaseMapping:0x0E08
 },
 { code:0x0E09
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E09
  ,simpleLowerCaseMapping:0x0E09
  ,simpleTitleCaseMapping:0x0E09
 },
 { code:0x0E0A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E0A
  ,simpleLowerCaseMapping:0x0E0A
  ,simpleTitleCaseMapping:0x0E0A
 },
 { code:0x0E0B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E0B
  ,simpleLowerCaseMapping:0x0E0B
  ,simpleTitleCaseMapping:0x0E0B
 },
 { code:0x0E0C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E0C
  ,simpleLowerCaseMapping:0x0E0C
  ,simpleTitleCaseMapping:0x0E0C
 },
 { code:0x0E0D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E0D
  ,simpleLowerCaseMapping:0x0E0D
  ,simpleTitleCaseMapping:0x0E0D
 },
 { code:0x0E0E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E0E
  ,simpleLowerCaseMapping:0x0E0E
  ,simpleTitleCaseMapping:0x0E0E
 },
 { code:0x0E0F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E0F
  ,simpleLowerCaseMapping:0x0E0F
  ,simpleTitleCaseMapping:0x0E0F
 },
 { code:0x0E10
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E10
  ,simpleLowerCaseMapping:0x0E10
  ,simpleTitleCaseMapping:0x0E10
 },
 { code:0x0E11
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E11
  ,simpleLowerCaseMapping:0x0E11
  ,simpleTitleCaseMapping:0x0E11
 },
 { code:0x0E12
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E12
  ,simpleLowerCaseMapping:0x0E12
  ,simpleTitleCaseMapping:0x0E12
 },
 { code:0x0E13
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E13
  ,simpleLowerCaseMapping:0x0E13
  ,simpleTitleCaseMapping:0x0E13
 },
 { code:0x0E14
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E14
  ,simpleLowerCaseMapping:0x0E14
  ,simpleTitleCaseMapping:0x0E14
 },
 { code:0x0E15
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E15
  ,simpleLowerCaseMapping:0x0E15
  ,simpleTitleCaseMapping:0x0E15
 },
 { code:0x0E16
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E16
  ,simpleLowerCaseMapping:0x0E16
  ,simpleTitleCaseMapping:0x0E16
 },
 { code:0x0E17
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E17
  ,simpleLowerCaseMapping:0x0E17
  ,simpleTitleCaseMapping:0x0E17
 },
 { code:0x0E18
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E18
  ,simpleLowerCaseMapping:0x0E18
  ,simpleTitleCaseMapping:0x0E18
 },
 { code:0x0E19
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E19
  ,simpleLowerCaseMapping:0x0E19
  ,simpleTitleCaseMapping:0x0E19
 },
 { code:0x0E1A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E1A
  ,simpleLowerCaseMapping:0x0E1A
  ,simpleTitleCaseMapping:0x0E1A
 },
 { code:0x0E1B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E1B
  ,simpleLowerCaseMapping:0x0E1B
  ,simpleTitleCaseMapping:0x0E1B
 },
 { code:0x0E1C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E1C
  ,simpleLowerCaseMapping:0x0E1C
  ,simpleTitleCaseMapping:0x0E1C
 },
 { code:0x0E1D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E1D
  ,simpleLowerCaseMapping:0x0E1D
  ,simpleTitleCaseMapping:0x0E1D
 },
 { code:0x0E1E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E1E
  ,simpleLowerCaseMapping:0x0E1E
  ,simpleTitleCaseMapping:0x0E1E
 },
 { code:0x0E1F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E1F
  ,simpleLowerCaseMapping:0x0E1F
  ,simpleTitleCaseMapping:0x0E1F
 },
 { code:0x0E20
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E20
  ,simpleLowerCaseMapping:0x0E20
  ,simpleTitleCaseMapping:0x0E20
 },
 { code:0x0E21
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E21
  ,simpleLowerCaseMapping:0x0E21
  ,simpleTitleCaseMapping:0x0E21
 },
 { code:0x0E22
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E22
  ,simpleLowerCaseMapping:0x0E22
  ,simpleTitleCaseMapping:0x0E22
 },
 { code:0x0E23
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E23
  ,simpleLowerCaseMapping:0x0E23
  ,simpleTitleCaseMapping:0x0E23
 },
 { code:0x0E24
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E24
  ,simpleLowerCaseMapping:0x0E24
  ,simpleTitleCaseMapping:0x0E24
 },
 { code:0x0E25
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E25
  ,simpleLowerCaseMapping:0x0E25
  ,simpleTitleCaseMapping:0x0E25
 },
 { code:0x0E26
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E26
  ,simpleLowerCaseMapping:0x0E26
  ,simpleTitleCaseMapping:0x0E26
 },
 { code:0x0E27
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E27
  ,simpleLowerCaseMapping:0x0E27
  ,simpleTitleCaseMapping:0x0E27
 },
 { code:0x0E28
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E28
  ,simpleLowerCaseMapping:0x0E28
  ,simpleTitleCaseMapping:0x0E28
 },
 { code:0x0E29
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E29
  ,simpleLowerCaseMapping:0x0E29
  ,simpleTitleCaseMapping:0x0E29
 },
 { code:0x0E2A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E2A
  ,simpleLowerCaseMapping:0x0E2A
  ,simpleTitleCaseMapping:0x0E2A
 },
 { code:0x0E2B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E2B
  ,simpleLowerCaseMapping:0x0E2B
  ,simpleTitleCaseMapping:0x0E2B
 },
 { code:0x0E2C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E2C
  ,simpleLowerCaseMapping:0x0E2C
  ,simpleTitleCaseMapping:0x0E2C
 },
 { code:0x0E2D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E2D
  ,simpleLowerCaseMapping:0x0E2D
  ,simpleTitleCaseMapping:0x0E2D
 },
 { code:0x0E2E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E2E
  ,simpleLowerCaseMapping:0x0E2E
  ,simpleTitleCaseMapping:0x0E2E
 },
 { code:0x0E2F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E2F
  ,simpleLowerCaseMapping:0x0E2F
  ,simpleTitleCaseMapping:0x0E2F
 },
 { code:0x0E30
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E30
  ,simpleLowerCaseMapping:0x0E30
  ,simpleTitleCaseMapping:0x0E30
 },
 { code:0x0E31
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E31
  ,simpleLowerCaseMapping:0x0E31
  ,simpleTitleCaseMapping:0x0E31
 },
 { code:0x0E32
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E32
  ,simpleLowerCaseMapping:0x0E32
  ,simpleTitleCaseMapping:0x0E32
 },
 { code:0x0E33
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E33
  ,simpleLowerCaseMapping:0x0E33
  ,simpleTitleCaseMapping:0x0E33
 },
 { code:0x0E34
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E34
  ,simpleLowerCaseMapping:0x0E34
  ,simpleTitleCaseMapping:0x0E34
 },
 { code:0x0E35
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E35
  ,simpleLowerCaseMapping:0x0E35
  ,simpleTitleCaseMapping:0x0E35
 },
 { code:0x0E36
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E36
  ,simpleLowerCaseMapping:0x0E36
  ,simpleTitleCaseMapping:0x0E36
 },
 { code:0x0E37
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E37
  ,simpleLowerCaseMapping:0x0E37
  ,simpleTitleCaseMapping:0x0E37
 },
 { code:0x0E38
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E38
  ,simpleLowerCaseMapping:0x0E38
  ,simpleTitleCaseMapping:0x0E38
 },
 { code:0x0E39
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E39
  ,simpleLowerCaseMapping:0x0E39
  ,simpleTitleCaseMapping:0x0E39
 },
 { code:0x0E3A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E3A
  ,simpleLowerCaseMapping:0x0E3A
  ,simpleTitleCaseMapping:0x0E3A
 },
 { code:0x0E3F
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x0E3F
  ,simpleLowerCaseMapping:0x0E3F
  ,simpleTitleCaseMapping:0x0E3F
 },
 { code:0x0E40
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E40
  ,simpleLowerCaseMapping:0x0E40
  ,simpleTitleCaseMapping:0x0E40
 },
 { code:0x0E41
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E41
  ,simpleLowerCaseMapping:0x0E41
  ,simpleTitleCaseMapping:0x0E41
 },
 { code:0x0E42
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E42
  ,simpleLowerCaseMapping:0x0E42
  ,simpleTitleCaseMapping:0x0E42
 },
 { code:0x0E43
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E43
  ,simpleLowerCaseMapping:0x0E43
  ,simpleTitleCaseMapping:0x0E43
 },
 { code:0x0E44
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E44
  ,simpleLowerCaseMapping:0x0E44
  ,simpleTitleCaseMapping:0x0E44
 },
 { code:0x0E45
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E45
  ,simpleLowerCaseMapping:0x0E45
  ,simpleTitleCaseMapping:0x0E45
 },
 { code:0x0E46
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x0E46
  ,simpleLowerCaseMapping:0x0E46
  ,simpleTitleCaseMapping:0x0E46
 },
 { code:0x0E47
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E47
  ,simpleLowerCaseMapping:0x0E47
  ,simpleTitleCaseMapping:0x0E47
 },
 { code:0x0E48
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E48
  ,simpleLowerCaseMapping:0x0E48
  ,simpleTitleCaseMapping:0x0E48
 },
 { code:0x0E49
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E49
  ,simpleLowerCaseMapping:0x0E49
  ,simpleTitleCaseMapping:0x0E49
 },
 { code:0x0E4A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E4A
  ,simpleLowerCaseMapping:0x0E4A
  ,simpleTitleCaseMapping:0x0E4A
 },
 { code:0x0E4B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E4B
  ,simpleLowerCaseMapping:0x0E4B
  ,simpleTitleCaseMapping:0x0E4B
 },
 { code:0x0E4C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E4C
  ,simpleLowerCaseMapping:0x0E4C
  ,simpleTitleCaseMapping:0x0E4C
 },
 { code:0x0E4D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E4D
  ,simpleLowerCaseMapping:0x0E4D
  ,simpleTitleCaseMapping:0x0E4D
 },
 { code:0x0E4E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0E4E
  ,simpleLowerCaseMapping:0x0E4E
  ,simpleTitleCaseMapping:0x0E4E
 },
 { code:0x0E4F
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0E4F
  ,simpleLowerCaseMapping:0x0E4F
  ,simpleTitleCaseMapping:0x0E4F
 },
 { code:0x0E50
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0E50
  ,simpleLowerCaseMapping:0x0E50
  ,simpleTitleCaseMapping:0x0E50
 },
 { code:0x0E51
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0E51
  ,simpleLowerCaseMapping:0x0E51
  ,simpleTitleCaseMapping:0x0E51
 },
 { code:0x0E52
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0E52
  ,simpleLowerCaseMapping:0x0E52
  ,simpleTitleCaseMapping:0x0E52
 },
 { code:0x0E53
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0E53
  ,simpleLowerCaseMapping:0x0E53
  ,simpleTitleCaseMapping:0x0E53
 },
 { code:0x0E54
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0E54
  ,simpleLowerCaseMapping:0x0E54
  ,simpleTitleCaseMapping:0x0E54
 },
 { code:0x0E55
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0E55
  ,simpleLowerCaseMapping:0x0E55
  ,simpleTitleCaseMapping:0x0E55
 },
 { code:0x0E56
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0E56
  ,simpleLowerCaseMapping:0x0E56
  ,simpleTitleCaseMapping:0x0E56
 },
 { code:0x0E57
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0E57
  ,simpleLowerCaseMapping:0x0E57
  ,simpleTitleCaseMapping:0x0E57
 },
 { code:0x0E58
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0E58
  ,simpleLowerCaseMapping:0x0E58
  ,simpleTitleCaseMapping:0x0E58
 },
 { code:0x0E59
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0E59
  ,simpleLowerCaseMapping:0x0E59
  ,simpleTitleCaseMapping:0x0E59
 },
 { code:0x0E5A
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0E5A
  ,simpleLowerCaseMapping:0x0E5A
  ,simpleTitleCaseMapping:0x0E5A
 },
 { code:0x0E5B
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0E5B
  ,simpleLowerCaseMapping:0x0E5B
  ,simpleTitleCaseMapping:0x0E5B
 },
 { code:0x0E81
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E81
  ,simpleLowerCaseMapping:0x0E81
  ,simpleTitleCaseMapping:0x0E81
 },
 { code:0x0E82
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E82
  ,simpleLowerCaseMapping:0x0E82
  ,simpleTitleCaseMapping:0x0E82
 },
 { code:0x0E84
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E84
  ,simpleLowerCaseMapping:0x0E84
  ,simpleTitleCaseMapping:0x0E84
 },
 { code:0x0E87
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E87
  ,simpleLowerCaseMapping:0x0E87
  ,simpleTitleCaseMapping:0x0E87
 },
 { code:0x0E88
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E88
  ,simpleLowerCaseMapping:0x0E88
  ,simpleTitleCaseMapping:0x0E88
 },
 { code:0x0E8A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E8A
  ,simpleLowerCaseMapping:0x0E8A
  ,simpleTitleCaseMapping:0x0E8A
 },
 { code:0x0E8D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E8D
  ,simpleLowerCaseMapping:0x0E8D
  ,simpleTitleCaseMapping:0x0E8D
 },
 { code:0x0E94
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E94
  ,simpleLowerCaseMapping:0x0E94
  ,simpleTitleCaseMapping:0x0E94
 },
 { code:0x0E95
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E95
  ,simpleLowerCaseMapping:0x0E95
  ,simpleTitleCaseMapping:0x0E95
 },
 { code:0x0E96
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E96
  ,simpleLowerCaseMapping:0x0E96
  ,simpleTitleCaseMapping:0x0E96
 },
 { code:0x0E97
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E97
  ,simpleLowerCaseMapping:0x0E97
  ,simpleTitleCaseMapping:0x0E97
 },
 { code:0x0E99
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E99
  ,simpleLowerCaseMapping:0x0E99
  ,simpleTitleCaseMapping:0x0E99
 },
 { code:0x0E9A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E9A
  ,simpleLowerCaseMapping:0x0E9A
  ,simpleTitleCaseMapping:0x0E9A
 },
 { code:0x0E9B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E9B
  ,simpleLowerCaseMapping:0x0E9B
  ,simpleTitleCaseMapping:0x0E9B
 },
 { code:0x0E9C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E9C
  ,simpleLowerCaseMapping:0x0E9C
  ,simpleTitleCaseMapping:0x0E9C
 },
 { code:0x0E9D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E9D
  ,simpleLowerCaseMapping:0x0E9D
  ,simpleTitleCaseMapping:0x0E9D
 },
 { code:0x0E9E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E9E
  ,simpleLowerCaseMapping:0x0E9E
  ,simpleTitleCaseMapping:0x0E9E
 },
 { code:0x0E9F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0E9F
  ,simpleLowerCaseMapping:0x0E9F
  ,simpleTitleCaseMapping:0x0E9F
 },
 { code:0x0EA1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EA1
  ,simpleLowerCaseMapping:0x0EA1
  ,simpleTitleCaseMapping:0x0EA1
 },
 { code:0x0EA2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EA2
  ,simpleLowerCaseMapping:0x0EA2
  ,simpleTitleCaseMapping:0x0EA2
 },
 { code:0x0EA3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EA3
  ,simpleLowerCaseMapping:0x0EA3
  ,simpleTitleCaseMapping:0x0EA3
 },
 { code:0x0EA5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EA5
  ,simpleLowerCaseMapping:0x0EA5
  ,simpleTitleCaseMapping:0x0EA5
 },
 { code:0x0EA7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EA7
  ,simpleLowerCaseMapping:0x0EA7
  ,simpleTitleCaseMapping:0x0EA7
 },
 { code:0x0EAA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EAA
  ,simpleLowerCaseMapping:0x0EAA
  ,simpleTitleCaseMapping:0x0EAA
 },
 { code:0x0EAB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EAB
  ,simpleLowerCaseMapping:0x0EAB
  ,simpleTitleCaseMapping:0x0EAB
 },
 { code:0x0EAD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EAD
  ,simpleLowerCaseMapping:0x0EAD
  ,simpleTitleCaseMapping:0x0EAD
 },
 { code:0x0EAE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EAE
  ,simpleLowerCaseMapping:0x0EAE
  ,simpleTitleCaseMapping:0x0EAE
 },
 { code:0x0EAF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EAF
  ,simpleLowerCaseMapping:0x0EAF
  ,simpleTitleCaseMapping:0x0EAF
 },
 { code:0x0EB0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EB0
  ,simpleLowerCaseMapping:0x0EB0
  ,simpleTitleCaseMapping:0x0EB0
 },
 { code:0x0EB1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EB1
  ,simpleLowerCaseMapping:0x0EB1
  ,simpleTitleCaseMapping:0x0EB1
 },
 { code:0x0EB2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EB2
  ,simpleLowerCaseMapping:0x0EB2
  ,simpleTitleCaseMapping:0x0EB2
 },
 { code:0x0EB3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EB3
  ,simpleLowerCaseMapping:0x0EB3
  ,simpleTitleCaseMapping:0x0EB3
 },
 { code:0x0EB4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EB4
  ,simpleLowerCaseMapping:0x0EB4
  ,simpleTitleCaseMapping:0x0EB4
 },
 { code:0x0EB5
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EB5
  ,simpleLowerCaseMapping:0x0EB5
  ,simpleTitleCaseMapping:0x0EB5
 },
 { code:0x0EB6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EB6
  ,simpleLowerCaseMapping:0x0EB6
  ,simpleTitleCaseMapping:0x0EB6
 },
 { code:0x0EB7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EB7
  ,simpleLowerCaseMapping:0x0EB7
  ,simpleTitleCaseMapping:0x0EB7
 },
 { code:0x0EB8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EB8
  ,simpleLowerCaseMapping:0x0EB8
  ,simpleTitleCaseMapping:0x0EB8
 },
 { code:0x0EB9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EB9
  ,simpleLowerCaseMapping:0x0EB9
  ,simpleTitleCaseMapping:0x0EB9
 },
 { code:0x0EBB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EBB
  ,simpleLowerCaseMapping:0x0EBB
  ,simpleTitleCaseMapping:0x0EBB
 },
 { code:0x0EBC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EBC
  ,simpleLowerCaseMapping:0x0EBC
  ,simpleTitleCaseMapping:0x0EBC
 },
 { code:0x0EBD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EBD
  ,simpleLowerCaseMapping:0x0EBD
  ,simpleTitleCaseMapping:0x0EBD
 },
 { code:0x0EC0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EC0
  ,simpleLowerCaseMapping:0x0EC0
  ,simpleTitleCaseMapping:0x0EC0
 },
 { code:0x0EC1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EC1
  ,simpleLowerCaseMapping:0x0EC1
  ,simpleTitleCaseMapping:0x0EC1
 },
 { code:0x0EC2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EC2
  ,simpleLowerCaseMapping:0x0EC2
  ,simpleTitleCaseMapping:0x0EC2
 },
 { code:0x0EC3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EC3
  ,simpleLowerCaseMapping:0x0EC3
  ,simpleTitleCaseMapping:0x0EC3
 },
 { code:0x0EC4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EC4
  ,simpleLowerCaseMapping:0x0EC4
  ,simpleTitleCaseMapping:0x0EC4
 },
 { code:0x0EC6
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x0EC6
  ,simpleLowerCaseMapping:0x0EC6
  ,simpleTitleCaseMapping:0x0EC6
 },
 { code:0x0EC8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EC8
  ,simpleLowerCaseMapping:0x0EC8
  ,simpleTitleCaseMapping:0x0EC8
 },
 { code:0x0EC9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0EC9
  ,simpleLowerCaseMapping:0x0EC9
  ,simpleTitleCaseMapping:0x0EC9
 },
 { code:0x0ECA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0ECA
  ,simpleLowerCaseMapping:0x0ECA
  ,simpleTitleCaseMapping:0x0ECA
 },
 { code:0x0ECB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0ECB
  ,simpleLowerCaseMapping:0x0ECB
  ,simpleTitleCaseMapping:0x0ECB
 },
 { code:0x0ECC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0ECC
  ,simpleLowerCaseMapping:0x0ECC
  ,simpleTitleCaseMapping:0x0ECC
 },
 { code:0x0ECD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0ECD
  ,simpleLowerCaseMapping:0x0ECD
  ,simpleTitleCaseMapping:0x0ECD
 },
 { code:0x0ED0
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0ED0
  ,simpleLowerCaseMapping:0x0ED0
  ,simpleTitleCaseMapping:0x0ED0
 },
 { code:0x0ED1
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0ED1
  ,simpleLowerCaseMapping:0x0ED1
  ,simpleTitleCaseMapping:0x0ED1
 },
 { code:0x0ED2
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0ED2
  ,simpleLowerCaseMapping:0x0ED2
  ,simpleTitleCaseMapping:0x0ED2
 },
 { code:0x0ED3
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0ED3
  ,simpleLowerCaseMapping:0x0ED3
  ,simpleTitleCaseMapping:0x0ED3
 },
 { code:0x0ED4
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0ED4
  ,simpleLowerCaseMapping:0x0ED4
  ,simpleTitleCaseMapping:0x0ED4
 },
 { code:0x0ED5
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0ED5
  ,simpleLowerCaseMapping:0x0ED5
  ,simpleTitleCaseMapping:0x0ED5
 },
 { code:0x0ED6
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0ED6
  ,simpleLowerCaseMapping:0x0ED6
  ,simpleTitleCaseMapping:0x0ED6
 },
 { code:0x0ED7
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0ED7
  ,simpleLowerCaseMapping:0x0ED7
  ,simpleTitleCaseMapping:0x0ED7
 },
 { code:0x0ED8
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0ED8
  ,simpleLowerCaseMapping:0x0ED8
  ,simpleTitleCaseMapping:0x0ED8
 },
 { code:0x0ED9
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0ED9
  ,simpleLowerCaseMapping:0x0ED9
  ,simpleTitleCaseMapping:0x0ED9
 },
 { code:0x0EDC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EDC
  ,simpleLowerCaseMapping:0x0EDC
  ,simpleTitleCaseMapping:0x0EDC
 },
 { code:0x0EDD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0EDD
  ,simpleLowerCaseMapping:0x0EDD
  ,simpleTitleCaseMapping:0x0EDD
 },
 { code:0x0F00
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F00
  ,simpleLowerCaseMapping:0x0F00
  ,simpleTitleCaseMapping:0x0F00
 },
 { code:0x0F01
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F01
  ,simpleLowerCaseMapping:0x0F01
  ,simpleTitleCaseMapping:0x0F01
 },
 { code:0x0F02
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F02
  ,simpleLowerCaseMapping:0x0F02
  ,simpleTitleCaseMapping:0x0F02
 },
 { code:0x0F03
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F03
  ,simpleLowerCaseMapping:0x0F03
  ,simpleTitleCaseMapping:0x0F03
 },
 { code:0x0F04
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F04
  ,simpleLowerCaseMapping:0x0F04
  ,simpleTitleCaseMapping:0x0F04
 },
 { code:0x0F05
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F05
  ,simpleLowerCaseMapping:0x0F05
  ,simpleTitleCaseMapping:0x0F05
 },
 { code:0x0F06
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F06
  ,simpleLowerCaseMapping:0x0F06
  ,simpleTitleCaseMapping:0x0F06
 },
 { code:0x0F07
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F07
  ,simpleLowerCaseMapping:0x0F07
  ,simpleTitleCaseMapping:0x0F07
 },
 { code:0x0F08
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F08
  ,simpleLowerCaseMapping:0x0F08
  ,simpleTitleCaseMapping:0x0F08
 },
 { code:0x0F09
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F09
  ,simpleLowerCaseMapping:0x0F09
  ,simpleTitleCaseMapping:0x0F09
 },
 { code:0x0F0A
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F0A
  ,simpleLowerCaseMapping:0x0F0A
  ,simpleTitleCaseMapping:0x0F0A
 },
 { code:0x0F0B
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F0B
  ,simpleLowerCaseMapping:0x0F0B
  ,simpleTitleCaseMapping:0x0F0B
 },
 { code:0x0F0C
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F0C
  ,simpleLowerCaseMapping:0x0F0C
  ,simpleTitleCaseMapping:0x0F0C
 },
 { code:0x0F0D
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F0D
  ,simpleLowerCaseMapping:0x0F0D
  ,simpleTitleCaseMapping:0x0F0D
 },
 { code:0x0F0E
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F0E
  ,simpleLowerCaseMapping:0x0F0E
  ,simpleTitleCaseMapping:0x0F0E
 },
 { code:0x0F0F
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F0F
  ,simpleLowerCaseMapping:0x0F0F
  ,simpleTitleCaseMapping:0x0F0F
 },
 { code:0x0F10
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F10
  ,simpleLowerCaseMapping:0x0F10
  ,simpleTitleCaseMapping:0x0F10
 },
 { code:0x0F11
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F11
  ,simpleLowerCaseMapping:0x0F11
  ,simpleTitleCaseMapping:0x0F11
 },
 { code:0x0F12
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F12
  ,simpleLowerCaseMapping:0x0F12
  ,simpleTitleCaseMapping:0x0F12
 },
 { code:0x0F13
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F13
  ,simpleLowerCaseMapping:0x0F13
  ,simpleTitleCaseMapping:0x0F13
 },
 { code:0x0F14
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F14
  ,simpleLowerCaseMapping:0x0F14
  ,simpleTitleCaseMapping:0x0F14
 },
 { code:0x0F15
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F15
  ,simpleLowerCaseMapping:0x0F15
  ,simpleTitleCaseMapping:0x0F15
 },
 { code:0x0F16
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F16
  ,simpleLowerCaseMapping:0x0F16
  ,simpleTitleCaseMapping:0x0F16
 },
 { code:0x0F17
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F17
  ,simpleLowerCaseMapping:0x0F17
  ,simpleTitleCaseMapping:0x0F17
 },
 { code:0x0F18
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F18
  ,simpleLowerCaseMapping:0x0F18
  ,simpleTitleCaseMapping:0x0F18
 },
 { code:0x0F19
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F19
  ,simpleLowerCaseMapping:0x0F19
  ,simpleTitleCaseMapping:0x0F19
 },
 { code:0x0F1A
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F1A
  ,simpleLowerCaseMapping:0x0F1A
  ,simpleTitleCaseMapping:0x0F1A
 },
 { code:0x0F1B
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F1B
  ,simpleLowerCaseMapping:0x0F1B
  ,simpleTitleCaseMapping:0x0F1B
 },
 { code:0x0F1C
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F1C
  ,simpleLowerCaseMapping:0x0F1C
  ,simpleTitleCaseMapping:0x0F1C
 },
 { code:0x0F1D
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F1D
  ,simpleLowerCaseMapping:0x0F1D
  ,simpleTitleCaseMapping:0x0F1D
 },
 { code:0x0F1E
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F1E
  ,simpleLowerCaseMapping:0x0F1E
  ,simpleTitleCaseMapping:0x0F1E
 },
 { code:0x0F1F
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F1F
  ,simpleLowerCaseMapping:0x0F1F
  ,simpleTitleCaseMapping:0x0F1F
 },
 { code:0x0F20
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0F20
  ,simpleLowerCaseMapping:0x0F20
  ,simpleTitleCaseMapping:0x0F20
 },
 { code:0x0F21
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0F21
  ,simpleLowerCaseMapping:0x0F21
  ,simpleTitleCaseMapping:0x0F21
 },
 { code:0x0F22
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0F22
  ,simpleLowerCaseMapping:0x0F22
  ,simpleTitleCaseMapping:0x0F22
 },
 { code:0x0F23
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0F23
  ,simpleLowerCaseMapping:0x0F23
  ,simpleTitleCaseMapping:0x0F23
 },
 { code:0x0F24
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0F24
  ,simpleLowerCaseMapping:0x0F24
  ,simpleTitleCaseMapping:0x0F24
 },
 { code:0x0F25
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0F25
  ,simpleLowerCaseMapping:0x0F25
  ,simpleTitleCaseMapping:0x0F25
 },
 { code:0x0F26
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0F26
  ,simpleLowerCaseMapping:0x0F26
  ,simpleTitleCaseMapping:0x0F26
 },
 { code:0x0F27
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0F27
  ,simpleLowerCaseMapping:0x0F27
  ,simpleTitleCaseMapping:0x0F27
 },
 { code:0x0F28
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0F28
  ,simpleLowerCaseMapping:0x0F28
  ,simpleTitleCaseMapping:0x0F28
 },
 { code:0x0F29
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x0F29
  ,simpleLowerCaseMapping:0x0F29
  ,simpleTitleCaseMapping:0x0F29
 },
 { code:0x0F2A
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0F2A
  ,simpleLowerCaseMapping:0x0F2A
  ,simpleTitleCaseMapping:0x0F2A
 },
 { code:0x0F2B
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0F2B
  ,simpleLowerCaseMapping:0x0F2B
  ,simpleTitleCaseMapping:0x0F2B
 },
 { code:0x0F2C
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0F2C
  ,simpleLowerCaseMapping:0x0F2C
  ,simpleTitleCaseMapping:0x0F2C
 },
 { code:0x0F2D
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0F2D
  ,simpleLowerCaseMapping:0x0F2D
  ,simpleTitleCaseMapping:0x0F2D
 },
 { code:0x0F2E
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0F2E
  ,simpleLowerCaseMapping:0x0F2E
  ,simpleTitleCaseMapping:0x0F2E
 },
 { code:0x0F2F
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0F2F
  ,simpleLowerCaseMapping:0x0F2F
  ,simpleTitleCaseMapping:0x0F2F
 },
 { code:0x0F30
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0F30
  ,simpleLowerCaseMapping:0x0F30
  ,simpleTitleCaseMapping:0x0F30
 },
 { code:0x0F31
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0F31
  ,simpleLowerCaseMapping:0x0F31
  ,simpleTitleCaseMapping:0x0F31
 },
 { code:0x0F32
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0F32
  ,simpleLowerCaseMapping:0x0F32
  ,simpleTitleCaseMapping:0x0F32
 },
 { code:0x0F33
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x0F33
  ,simpleLowerCaseMapping:0x0F33
  ,simpleTitleCaseMapping:0x0F33
 },
 { code:0x0F34
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F34
  ,simpleLowerCaseMapping:0x0F34
  ,simpleTitleCaseMapping:0x0F34
 },
 { code:0x0F35
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F35
  ,simpleLowerCaseMapping:0x0F35
  ,simpleTitleCaseMapping:0x0F35
 },
 { code:0x0F36
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F36
  ,simpleLowerCaseMapping:0x0F36
  ,simpleTitleCaseMapping:0x0F36
 },
 { code:0x0F37
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F37
  ,simpleLowerCaseMapping:0x0F37
  ,simpleTitleCaseMapping:0x0F37
 },
 { code:0x0F38
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0F38
  ,simpleLowerCaseMapping:0x0F38
  ,simpleTitleCaseMapping:0x0F38
 },
 { code:0x0F39
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F39
  ,simpleLowerCaseMapping:0x0F39
  ,simpleTitleCaseMapping:0x0F39
 },
 { code:0x0F3A
  ,generalCategory:UnicodeData.GeneralCategory.Ps
  ,simpleUpperCaseMapping:0x0F3A
  ,simpleLowerCaseMapping:0x0F3A
  ,simpleTitleCaseMapping:0x0F3A
 },
 { code:0x0F3B
  ,generalCategory:UnicodeData.GeneralCategory.Pe
  ,simpleUpperCaseMapping:0x0F3B
  ,simpleLowerCaseMapping:0x0F3B
  ,simpleTitleCaseMapping:0x0F3B
 },
 { code:0x0F3C
  ,generalCategory:UnicodeData.GeneralCategory.Ps
  ,simpleUpperCaseMapping:0x0F3C
  ,simpleLowerCaseMapping:0x0F3C
  ,simpleTitleCaseMapping:0x0F3C
 },
 { code:0x0F3D
  ,generalCategory:UnicodeData.GeneralCategory.Pe
  ,simpleUpperCaseMapping:0x0F3D
  ,simpleLowerCaseMapping:0x0F3D
  ,simpleTitleCaseMapping:0x0F3D
 },
 { code:0x0F3E
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0F3E
  ,simpleLowerCaseMapping:0x0F3E
  ,simpleTitleCaseMapping:0x0F3E
 },
 { code:0x0F3F
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0F3F
  ,simpleLowerCaseMapping:0x0F3F
  ,simpleTitleCaseMapping:0x0F3F
 },
 { code:0x0F40
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F40
  ,simpleLowerCaseMapping:0x0F40
  ,simpleTitleCaseMapping:0x0F40
 },
 { code:0x0F41
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F41
  ,simpleLowerCaseMapping:0x0F41
  ,simpleTitleCaseMapping:0x0F41
 },
 { code:0x0F42
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F42
  ,simpleLowerCaseMapping:0x0F42
  ,simpleTitleCaseMapping:0x0F42
 },
 { code:0x0F43
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F43
  ,simpleLowerCaseMapping:0x0F43
  ,simpleTitleCaseMapping:0x0F43
 },
 { code:0x0F44
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F44
  ,simpleLowerCaseMapping:0x0F44
  ,simpleTitleCaseMapping:0x0F44
 },
 { code:0x0F45
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F45
  ,simpleLowerCaseMapping:0x0F45
  ,simpleTitleCaseMapping:0x0F45
 },
 { code:0x0F46
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F46
  ,simpleLowerCaseMapping:0x0F46
  ,simpleTitleCaseMapping:0x0F46
 },
 { code:0x0F47
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F47
  ,simpleLowerCaseMapping:0x0F47
  ,simpleTitleCaseMapping:0x0F47
 },
 { code:0x0F49
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F49
  ,simpleLowerCaseMapping:0x0F49
  ,simpleTitleCaseMapping:0x0F49
 },
 { code:0x0F4A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F4A
  ,simpleLowerCaseMapping:0x0F4A
  ,simpleTitleCaseMapping:0x0F4A
 },
 { code:0x0F4B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F4B
  ,simpleLowerCaseMapping:0x0F4B
  ,simpleTitleCaseMapping:0x0F4B
 },
 { code:0x0F4C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F4C
  ,simpleLowerCaseMapping:0x0F4C
  ,simpleTitleCaseMapping:0x0F4C
 },
 { code:0x0F4D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F4D
  ,simpleLowerCaseMapping:0x0F4D
  ,simpleTitleCaseMapping:0x0F4D
 },
 { code:0x0F4E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F4E
  ,simpleLowerCaseMapping:0x0F4E
  ,simpleTitleCaseMapping:0x0F4E
 },
 { code:0x0F4F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F4F
  ,simpleLowerCaseMapping:0x0F4F
  ,simpleTitleCaseMapping:0x0F4F
 },
 { code:0x0F50
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F50
  ,simpleLowerCaseMapping:0x0F50
  ,simpleTitleCaseMapping:0x0F50
 },
 { code:0x0F51
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F51
  ,simpleLowerCaseMapping:0x0F51
  ,simpleTitleCaseMapping:0x0F51
 },
 { code:0x0F52
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F52
  ,simpleLowerCaseMapping:0x0F52
  ,simpleTitleCaseMapping:0x0F52
 },
 { code:0x0F53
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F53
  ,simpleLowerCaseMapping:0x0F53
  ,simpleTitleCaseMapping:0x0F53
 },
 { code:0x0F54
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F54
  ,simpleLowerCaseMapping:0x0F54
  ,simpleTitleCaseMapping:0x0F54
 },
 { code:0x0F55
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F55
  ,simpleLowerCaseMapping:0x0F55
  ,simpleTitleCaseMapping:0x0F55
 },
 { code:0x0F56
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F56
  ,simpleLowerCaseMapping:0x0F56
  ,simpleTitleCaseMapping:0x0F56
 },
 { code:0x0F57
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F57
  ,simpleLowerCaseMapping:0x0F57
  ,simpleTitleCaseMapping:0x0F57
 },
 { code:0x0F58
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F58
  ,simpleLowerCaseMapping:0x0F58
  ,simpleTitleCaseMapping:0x0F58
 },
 { code:0x0F59
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F59
  ,simpleLowerCaseMapping:0x0F59
  ,simpleTitleCaseMapping:0x0F59
 },
 { code:0x0F5A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F5A
  ,simpleLowerCaseMapping:0x0F5A
  ,simpleTitleCaseMapping:0x0F5A
 },
 { code:0x0F5B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F5B
  ,simpleLowerCaseMapping:0x0F5B
  ,simpleTitleCaseMapping:0x0F5B
 },
 { code:0x0F5C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F5C
  ,simpleLowerCaseMapping:0x0F5C
  ,simpleTitleCaseMapping:0x0F5C
 },
 { code:0x0F5D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F5D
  ,simpleLowerCaseMapping:0x0F5D
  ,simpleTitleCaseMapping:0x0F5D
 },
 { code:0x0F5E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F5E
  ,simpleLowerCaseMapping:0x0F5E
  ,simpleTitleCaseMapping:0x0F5E
 },
 { code:0x0F5F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F5F
  ,simpleLowerCaseMapping:0x0F5F
  ,simpleTitleCaseMapping:0x0F5F
 },
 { code:0x0F60
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F60
  ,simpleLowerCaseMapping:0x0F60
  ,simpleTitleCaseMapping:0x0F60
 },
 { code:0x0F61
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F61
  ,simpleLowerCaseMapping:0x0F61
  ,simpleTitleCaseMapping:0x0F61
 },
 { code:0x0F62
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F62
  ,simpleLowerCaseMapping:0x0F62
  ,simpleTitleCaseMapping:0x0F62
 },
 { code:0x0F63
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F63
  ,simpleLowerCaseMapping:0x0F63
  ,simpleTitleCaseMapping:0x0F63
 },
 { code:0x0F64
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F64
  ,simpleLowerCaseMapping:0x0F64
  ,simpleTitleCaseMapping:0x0F64
 },
 { code:0x0F65
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F65
  ,simpleLowerCaseMapping:0x0F65
  ,simpleTitleCaseMapping:0x0F65
 },
 { code:0x0F66
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F66
  ,simpleLowerCaseMapping:0x0F66
  ,simpleTitleCaseMapping:0x0F66
 },
 { code:0x0F67
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F67
  ,simpleLowerCaseMapping:0x0F67
  ,simpleTitleCaseMapping:0x0F67
 },
 { code:0x0F68
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F68
  ,simpleLowerCaseMapping:0x0F68
  ,simpleTitleCaseMapping:0x0F68
 },
 { code:0x0F69
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F69
  ,simpleLowerCaseMapping:0x0F69
  ,simpleTitleCaseMapping:0x0F69
 },
 { code:0x0F6A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F6A
  ,simpleLowerCaseMapping:0x0F6A
  ,simpleTitleCaseMapping:0x0F6A
 },
 { code:0x0F71
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F71
  ,simpleLowerCaseMapping:0x0F71
  ,simpleTitleCaseMapping:0x0F71
 },
 { code:0x0F72
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F72
  ,simpleLowerCaseMapping:0x0F72
  ,simpleTitleCaseMapping:0x0F72
 },
 { code:0x0F73
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F73
  ,simpleLowerCaseMapping:0x0F73
  ,simpleTitleCaseMapping:0x0F73
 },
 { code:0x0F74
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F74
  ,simpleLowerCaseMapping:0x0F74
  ,simpleTitleCaseMapping:0x0F74
 },
 { code:0x0F75
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F75
  ,simpleLowerCaseMapping:0x0F75
  ,simpleTitleCaseMapping:0x0F75
 },
 { code:0x0F76
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F76
  ,simpleLowerCaseMapping:0x0F76
  ,simpleTitleCaseMapping:0x0F76
 },
 { code:0x0F77
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F77
  ,simpleLowerCaseMapping:0x0F77
  ,simpleTitleCaseMapping:0x0F77
 },
 { code:0x0F78
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F78
  ,simpleLowerCaseMapping:0x0F78
  ,simpleTitleCaseMapping:0x0F78
 },
 { code:0x0F79
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F79
  ,simpleLowerCaseMapping:0x0F79
  ,simpleTitleCaseMapping:0x0F79
 },
 { code:0x0F7A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F7A
  ,simpleLowerCaseMapping:0x0F7A
  ,simpleTitleCaseMapping:0x0F7A
 },
 { code:0x0F7B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F7B
  ,simpleLowerCaseMapping:0x0F7B
  ,simpleTitleCaseMapping:0x0F7B
 },
 { code:0x0F7C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F7C
  ,simpleLowerCaseMapping:0x0F7C
  ,simpleTitleCaseMapping:0x0F7C
 },
 { code:0x0F7D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F7D
  ,simpleLowerCaseMapping:0x0F7D
  ,simpleTitleCaseMapping:0x0F7D
 },
 { code:0x0F7E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F7E
  ,simpleLowerCaseMapping:0x0F7E
  ,simpleTitleCaseMapping:0x0F7E
 },
 { code:0x0F7F
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x0F7F
  ,simpleLowerCaseMapping:0x0F7F
  ,simpleTitleCaseMapping:0x0F7F
 },
 { code:0x0F80
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F80
  ,simpleLowerCaseMapping:0x0F80
  ,simpleTitleCaseMapping:0x0F80
 },
 { code:0x0F81
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F81
  ,simpleLowerCaseMapping:0x0F81
  ,simpleTitleCaseMapping:0x0F81
 },
 { code:0x0F82
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F82
  ,simpleLowerCaseMapping:0x0F82
  ,simpleTitleCaseMapping:0x0F82
 },
 { code:0x0F83
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F83
  ,simpleLowerCaseMapping:0x0F83
  ,simpleTitleCaseMapping:0x0F83
 },
 { code:0x0F84
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F84
  ,simpleLowerCaseMapping:0x0F84
  ,simpleTitleCaseMapping:0x0F84
 },
 { code:0x0F85
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0F85
  ,simpleLowerCaseMapping:0x0F85
  ,simpleTitleCaseMapping:0x0F85
 },
 { code:0x0F86
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F86
  ,simpleLowerCaseMapping:0x0F86
  ,simpleTitleCaseMapping:0x0F86
 },
 { code:0x0F87
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F87
  ,simpleLowerCaseMapping:0x0F87
  ,simpleTitleCaseMapping:0x0F87
 },
 { code:0x0F88
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F88
  ,simpleLowerCaseMapping:0x0F88
  ,simpleTitleCaseMapping:0x0F88
 },
 { code:0x0F89
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F89
  ,simpleLowerCaseMapping:0x0F89
  ,simpleTitleCaseMapping:0x0F89
 },
 { code:0x0F8A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F8A
  ,simpleLowerCaseMapping:0x0F8A
  ,simpleTitleCaseMapping:0x0F8A
 },
 { code:0x0F8B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x0F8B
  ,simpleLowerCaseMapping:0x0F8B
  ,simpleTitleCaseMapping:0x0F8B
 },
 { code:0x0F90
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F90
  ,simpleLowerCaseMapping:0x0F90
  ,simpleTitleCaseMapping:0x0F90
 },
 { code:0x0F91
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F91
  ,simpleLowerCaseMapping:0x0F91
  ,simpleTitleCaseMapping:0x0F91
 },
 { code:0x0F92
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F92
  ,simpleLowerCaseMapping:0x0F92
  ,simpleTitleCaseMapping:0x0F92
 },
 { code:0x0F93
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F93
  ,simpleLowerCaseMapping:0x0F93
  ,simpleTitleCaseMapping:0x0F93
 },
 { code:0x0F94
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F94
  ,simpleLowerCaseMapping:0x0F94
  ,simpleTitleCaseMapping:0x0F94
 },
 { code:0x0F95
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F95
  ,simpleLowerCaseMapping:0x0F95
  ,simpleTitleCaseMapping:0x0F95
 },
 { code:0x0F96
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F96
  ,simpleLowerCaseMapping:0x0F96
  ,simpleTitleCaseMapping:0x0F96
 },
 { code:0x0F97
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F97
  ,simpleLowerCaseMapping:0x0F97
  ,simpleTitleCaseMapping:0x0F97
 },
 { code:0x0F99
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F99
  ,simpleLowerCaseMapping:0x0F99
  ,simpleTitleCaseMapping:0x0F99
 },
 { code:0x0F9A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F9A
  ,simpleLowerCaseMapping:0x0F9A
  ,simpleTitleCaseMapping:0x0F9A
 },
 { code:0x0F9B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F9B
  ,simpleLowerCaseMapping:0x0F9B
  ,simpleTitleCaseMapping:0x0F9B
 },
 { code:0x0F9C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F9C
  ,simpleLowerCaseMapping:0x0F9C
  ,simpleTitleCaseMapping:0x0F9C
 },
 { code:0x0F9D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F9D
  ,simpleLowerCaseMapping:0x0F9D
  ,simpleTitleCaseMapping:0x0F9D
 },
 { code:0x0F9E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F9E
  ,simpleLowerCaseMapping:0x0F9E
  ,simpleTitleCaseMapping:0x0F9E
 },
 { code:0x0F9F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0F9F
  ,simpleLowerCaseMapping:0x0F9F
  ,simpleTitleCaseMapping:0x0F9F
 },
 { code:0x0FA0
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FA0
  ,simpleLowerCaseMapping:0x0FA0
  ,simpleTitleCaseMapping:0x0FA0
 },
 { code:0x0FA1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FA1
  ,simpleLowerCaseMapping:0x0FA1
  ,simpleTitleCaseMapping:0x0FA1
 },
 { code:0x0FA2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FA2
  ,simpleLowerCaseMapping:0x0FA2
  ,simpleTitleCaseMapping:0x0FA2
 },
 { code:0x0FA3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FA3
  ,simpleLowerCaseMapping:0x0FA3
  ,simpleTitleCaseMapping:0x0FA3
 },
 { code:0x0FA4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FA4
  ,simpleLowerCaseMapping:0x0FA4
  ,simpleTitleCaseMapping:0x0FA4
 },
 { code:0x0FA5
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FA5
  ,simpleLowerCaseMapping:0x0FA5
  ,simpleTitleCaseMapping:0x0FA5
 },
 { code:0x0FA6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FA6
  ,simpleLowerCaseMapping:0x0FA6
  ,simpleTitleCaseMapping:0x0FA6
 },
 { code:0x0FA7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FA7
  ,simpleLowerCaseMapping:0x0FA7
  ,simpleTitleCaseMapping:0x0FA7
 },
 { code:0x0FA8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FA8
  ,simpleLowerCaseMapping:0x0FA8
  ,simpleTitleCaseMapping:0x0FA8
 },
 { code:0x0FA9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FA9
  ,simpleLowerCaseMapping:0x0FA9
  ,simpleTitleCaseMapping:0x0FA9
 },
 { code:0x0FAA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FAA
  ,simpleLowerCaseMapping:0x0FAA
  ,simpleTitleCaseMapping:0x0FAA
 },
 { code:0x0FAB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FAB
  ,simpleLowerCaseMapping:0x0FAB
  ,simpleTitleCaseMapping:0x0FAB
 },
 { code:0x0FAC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FAC
  ,simpleLowerCaseMapping:0x0FAC
  ,simpleTitleCaseMapping:0x0FAC
 },
 { code:0x0FAD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FAD
  ,simpleLowerCaseMapping:0x0FAD
  ,simpleTitleCaseMapping:0x0FAD
 },
 { code:0x0FAE
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FAE
  ,simpleLowerCaseMapping:0x0FAE
  ,simpleTitleCaseMapping:0x0FAE
 },
 { code:0x0FAF
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FAF
  ,simpleLowerCaseMapping:0x0FAF
  ,simpleTitleCaseMapping:0x0FAF
 },
 { code:0x0FB0
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FB0
  ,simpleLowerCaseMapping:0x0FB0
  ,simpleTitleCaseMapping:0x0FB0
 },
 { code:0x0FB1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FB1
  ,simpleLowerCaseMapping:0x0FB1
  ,simpleTitleCaseMapping:0x0FB1
 },
 { code:0x0FB2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FB2
  ,simpleLowerCaseMapping:0x0FB2
  ,simpleTitleCaseMapping:0x0FB2
 },
 { code:0x0FB3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FB3
  ,simpleLowerCaseMapping:0x0FB3
  ,simpleTitleCaseMapping:0x0FB3
 },
 { code:0x0FB4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FB4
  ,simpleLowerCaseMapping:0x0FB4
  ,simpleTitleCaseMapping:0x0FB4
 },
 { code:0x0FB5
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FB5
  ,simpleLowerCaseMapping:0x0FB5
  ,simpleTitleCaseMapping:0x0FB5
 },
 { code:0x0FB6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FB6
  ,simpleLowerCaseMapping:0x0FB6
  ,simpleTitleCaseMapping:0x0FB6
 },
 { code:0x0FB7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FB7
  ,simpleLowerCaseMapping:0x0FB7
  ,simpleTitleCaseMapping:0x0FB7
 },
 { code:0x0FB8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FB8
  ,simpleLowerCaseMapping:0x0FB8
  ,simpleTitleCaseMapping:0x0FB8
 },
 { code:0x0FB9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FB9
  ,simpleLowerCaseMapping:0x0FB9
  ,simpleTitleCaseMapping:0x0FB9
 },
 { code:0x0FBA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FBA
  ,simpleLowerCaseMapping:0x0FBA
  ,simpleTitleCaseMapping:0x0FBA
 },
 { code:0x0FBB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FBB
  ,simpleLowerCaseMapping:0x0FBB
  ,simpleTitleCaseMapping:0x0FBB
 },
 { code:0x0FBC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FBC
  ,simpleLowerCaseMapping:0x0FBC
  ,simpleTitleCaseMapping:0x0FBC
 },
 { code:0x0FBE
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FBE
  ,simpleLowerCaseMapping:0x0FBE
  ,simpleTitleCaseMapping:0x0FBE
 },
 { code:0x0FBF
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FBF
  ,simpleLowerCaseMapping:0x0FBF
  ,simpleTitleCaseMapping:0x0FBF
 },
 { code:0x0FC0
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FC0
  ,simpleLowerCaseMapping:0x0FC0
  ,simpleTitleCaseMapping:0x0FC0
 },
 { code:0x0FC1
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FC1
  ,simpleLowerCaseMapping:0x0FC1
  ,simpleTitleCaseMapping:0x0FC1
 },
 { code:0x0FC2
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FC2
  ,simpleLowerCaseMapping:0x0FC2
  ,simpleTitleCaseMapping:0x0FC2
 },
 { code:0x0FC3
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FC3
  ,simpleLowerCaseMapping:0x0FC3
  ,simpleTitleCaseMapping:0x0FC3
 },
 { code:0x0FC4
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FC4
  ,simpleLowerCaseMapping:0x0FC4
  ,simpleTitleCaseMapping:0x0FC4
 },
 { code:0x0FC5
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FC5
  ,simpleLowerCaseMapping:0x0FC5
  ,simpleTitleCaseMapping:0x0FC5
 },
 { code:0x0FC6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x0FC6
  ,simpleLowerCaseMapping:0x0FC6
  ,simpleTitleCaseMapping:0x0FC6
 },
 { code:0x0FC7
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FC7
  ,simpleLowerCaseMapping:0x0FC7
  ,simpleTitleCaseMapping:0x0FC7
 },
 { code:0x0FC8
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FC8
  ,simpleLowerCaseMapping:0x0FC8
  ,simpleTitleCaseMapping:0x0FC8
 },
 { code:0x0FC9
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FC9
  ,simpleLowerCaseMapping:0x0FC9
  ,simpleTitleCaseMapping:0x0FC9
 },
 { code:0x0FCA
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FCA
  ,simpleLowerCaseMapping:0x0FCA
  ,simpleTitleCaseMapping:0x0FCA
 },
 { code:0x0FCB
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FCB
  ,simpleLowerCaseMapping:0x0FCB
  ,simpleTitleCaseMapping:0x0FCB
 },
 { code:0x0FCC
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FCC
  ,simpleLowerCaseMapping:0x0FCC
  ,simpleTitleCaseMapping:0x0FCC
 },
 { code:0x0FCF
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x0FCF
  ,simpleLowerCaseMapping:0x0FCF
  ,simpleTitleCaseMapping:0x0FCF
 },
 { code:0x0FD0
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0FD0
  ,simpleLowerCaseMapping:0x0FD0
  ,simpleTitleCaseMapping:0x0FD0
 },
 { code:0x0FD1
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x0FD1
  ,simpleLowerCaseMapping:0x0FD1
  ,simpleTitleCaseMapping:0x0FD1
 },
 { code:0x1000
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1000
  ,simpleLowerCaseMapping:0x1000
  ,simpleTitleCaseMapping:0x1000
 },
 { code:0x1001
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1001
  ,simpleLowerCaseMapping:0x1001
  ,simpleTitleCaseMapping:0x1001
 },
 { code:0x1002
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1002
  ,simpleLowerCaseMapping:0x1002
  ,simpleTitleCaseMapping:0x1002
 },
 { code:0x1003
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1003
  ,simpleLowerCaseMapping:0x1003
  ,simpleTitleCaseMapping:0x1003
 },
 { code:0x1004
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1004
  ,simpleLowerCaseMapping:0x1004
  ,simpleTitleCaseMapping:0x1004
 },
 { code:0x1005
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1005
  ,simpleLowerCaseMapping:0x1005
  ,simpleTitleCaseMapping:0x1005
 },
 { code:0x1006
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1006
  ,simpleLowerCaseMapping:0x1006
  ,simpleTitleCaseMapping:0x1006
 },
 { code:0x1007
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1007
  ,simpleLowerCaseMapping:0x1007
  ,simpleTitleCaseMapping:0x1007
 },
 { code:0x1008
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1008
  ,simpleLowerCaseMapping:0x1008
  ,simpleTitleCaseMapping:0x1008
 },
 { code:0x1009
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1009
  ,simpleLowerCaseMapping:0x1009
  ,simpleTitleCaseMapping:0x1009
 },
 { code:0x100A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x100A
  ,simpleLowerCaseMapping:0x100A
  ,simpleTitleCaseMapping:0x100A
 },
 { code:0x100B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x100B
  ,simpleLowerCaseMapping:0x100B
  ,simpleTitleCaseMapping:0x100B
 },
 { code:0x100C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x100C
  ,simpleLowerCaseMapping:0x100C
  ,simpleTitleCaseMapping:0x100C
 },
 { code:0x100D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x100D
  ,simpleLowerCaseMapping:0x100D
  ,simpleTitleCaseMapping:0x100D
 },
 { code:0x100E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x100E
  ,simpleLowerCaseMapping:0x100E
  ,simpleTitleCaseMapping:0x100E
 },
 { code:0x100F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x100F
  ,simpleLowerCaseMapping:0x100F
  ,simpleTitleCaseMapping:0x100F
 },
 { code:0x1010
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1010
  ,simpleLowerCaseMapping:0x1010
  ,simpleTitleCaseMapping:0x1010
 },
 { code:0x1011
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1011
  ,simpleLowerCaseMapping:0x1011
  ,simpleTitleCaseMapping:0x1011
 },
 { code:0x1012
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1012
  ,simpleLowerCaseMapping:0x1012
  ,simpleTitleCaseMapping:0x1012
 },
 { code:0x1013
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1013
  ,simpleLowerCaseMapping:0x1013
  ,simpleTitleCaseMapping:0x1013
 },
 { code:0x1014
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1014
  ,simpleLowerCaseMapping:0x1014
  ,simpleTitleCaseMapping:0x1014
 },
 { code:0x1015
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1015
  ,simpleLowerCaseMapping:0x1015
  ,simpleTitleCaseMapping:0x1015
 },
 { code:0x1016
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1016
  ,simpleLowerCaseMapping:0x1016
  ,simpleTitleCaseMapping:0x1016
 },
 { code:0x1017
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1017
  ,simpleLowerCaseMapping:0x1017
  ,simpleTitleCaseMapping:0x1017
 },
 { code:0x1018
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1018
  ,simpleLowerCaseMapping:0x1018
  ,simpleTitleCaseMapping:0x1018
 },
 { code:0x1019
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1019
  ,simpleLowerCaseMapping:0x1019
  ,simpleTitleCaseMapping:0x1019
 },
 { code:0x101A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x101A
  ,simpleLowerCaseMapping:0x101A
  ,simpleTitleCaseMapping:0x101A
 },
 { code:0x101B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x101B
  ,simpleLowerCaseMapping:0x101B
  ,simpleTitleCaseMapping:0x101B
 },
 { code:0x101C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x101C
  ,simpleLowerCaseMapping:0x101C
  ,simpleTitleCaseMapping:0x101C
 },
 { code:0x101D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x101D
  ,simpleLowerCaseMapping:0x101D
  ,simpleTitleCaseMapping:0x101D
 },
 { code:0x101E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x101E
  ,simpleLowerCaseMapping:0x101E
  ,simpleTitleCaseMapping:0x101E
 },
 { code:0x101F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x101F
  ,simpleLowerCaseMapping:0x101F
  ,simpleTitleCaseMapping:0x101F
 },
 { code:0x1020
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1020
  ,simpleLowerCaseMapping:0x1020
  ,simpleTitleCaseMapping:0x1020
 },
 { code:0x1021
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1021
  ,simpleLowerCaseMapping:0x1021
  ,simpleTitleCaseMapping:0x1021
 },
 { code:0x1023
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1023
  ,simpleLowerCaseMapping:0x1023
  ,simpleTitleCaseMapping:0x1023
 },
 { code:0x1024
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1024
  ,simpleLowerCaseMapping:0x1024
  ,simpleTitleCaseMapping:0x1024
 },
 { code:0x1025
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1025
  ,simpleLowerCaseMapping:0x1025
  ,simpleTitleCaseMapping:0x1025
 },
 { code:0x1026
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1026
  ,simpleLowerCaseMapping:0x1026
  ,simpleTitleCaseMapping:0x1026
 },
 { code:0x1027
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1027
  ,simpleLowerCaseMapping:0x1027
  ,simpleTitleCaseMapping:0x1027
 },
 { code:0x1029
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1029
  ,simpleLowerCaseMapping:0x1029
  ,simpleTitleCaseMapping:0x1029
 },
 { code:0x102A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x102A
  ,simpleLowerCaseMapping:0x102A
  ,simpleTitleCaseMapping:0x102A
 },
 { code:0x102C
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x102C
  ,simpleLowerCaseMapping:0x102C
  ,simpleTitleCaseMapping:0x102C
 },
 { code:0x102D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x102D
  ,simpleLowerCaseMapping:0x102D
  ,simpleTitleCaseMapping:0x102D
 },
 { code:0x102E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x102E
  ,simpleLowerCaseMapping:0x102E
  ,simpleTitleCaseMapping:0x102E
 },
 { code:0x102F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x102F
  ,simpleLowerCaseMapping:0x102F
  ,simpleTitleCaseMapping:0x102F
 },
 { code:0x1030
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1030
  ,simpleLowerCaseMapping:0x1030
  ,simpleTitleCaseMapping:0x1030
 },
 { code:0x1031
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1031
  ,simpleLowerCaseMapping:0x1031
  ,simpleTitleCaseMapping:0x1031
 },
 { code:0x1032
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1032
  ,simpleLowerCaseMapping:0x1032
  ,simpleTitleCaseMapping:0x1032
 },
 { code:0x1036
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1036
  ,simpleLowerCaseMapping:0x1036
  ,simpleTitleCaseMapping:0x1036
 },
 { code:0x1037
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1037
  ,simpleLowerCaseMapping:0x1037
  ,simpleTitleCaseMapping:0x1037
 },
 { code:0x1038
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1038
  ,simpleLowerCaseMapping:0x1038
  ,simpleTitleCaseMapping:0x1038
 },
 { code:0x1039
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1039
  ,simpleLowerCaseMapping:0x1039
  ,simpleTitleCaseMapping:0x1039
 },
 { code:0x1040
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1040
  ,simpleLowerCaseMapping:0x1040
  ,simpleTitleCaseMapping:0x1040
 },
 { code:0x1041
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1041
  ,simpleLowerCaseMapping:0x1041
  ,simpleTitleCaseMapping:0x1041
 },
 { code:0x1042
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1042
  ,simpleLowerCaseMapping:0x1042
  ,simpleTitleCaseMapping:0x1042
 },
 { code:0x1043
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1043
  ,simpleLowerCaseMapping:0x1043
  ,simpleTitleCaseMapping:0x1043
 },
 { code:0x1044
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1044
  ,simpleLowerCaseMapping:0x1044
  ,simpleTitleCaseMapping:0x1044
 },
 { code:0x1045
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1045
  ,simpleLowerCaseMapping:0x1045
  ,simpleTitleCaseMapping:0x1045
 },
 { code:0x1046
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1046
  ,simpleLowerCaseMapping:0x1046
  ,simpleTitleCaseMapping:0x1046
 },
 { code:0x1047
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1047
  ,simpleLowerCaseMapping:0x1047
  ,simpleTitleCaseMapping:0x1047
 },
 { code:0x1048
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1048
  ,simpleLowerCaseMapping:0x1048
  ,simpleTitleCaseMapping:0x1048
 },
 { code:0x1049
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1049
  ,simpleLowerCaseMapping:0x1049
  ,simpleTitleCaseMapping:0x1049
 },
 { code:0x104A
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x104A
  ,simpleLowerCaseMapping:0x104A
  ,simpleTitleCaseMapping:0x104A
 },
 { code:0x104B
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x104B
  ,simpleLowerCaseMapping:0x104B
  ,simpleTitleCaseMapping:0x104B
 },
 { code:0x104C
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x104C
  ,simpleLowerCaseMapping:0x104C
  ,simpleTitleCaseMapping:0x104C
 },
 { code:0x104D
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x104D
  ,simpleLowerCaseMapping:0x104D
  ,simpleTitleCaseMapping:0x104D
 },
 { code:0x104E
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x104E
  ,simpleLowerCaseMapping:0x104E
  ,simpleTitleCaseMapping:0x104E
 },
 { code:0x104F
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x104F
  ,simpleLowerCaseMapping:0x104F
  ,simpleTitleCaseMapping:0x104F
 },
 { code:0x1050
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1050
  ,simpleLowerCaseMapping:0x1050
  ,simpleTitleCaseMapping:0x1050
 },
 { code:0x1051
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1051
  ,simpleLowerCaseMapping:0x1051
  ,simpleTitleCaseMapping:0x1051
 },
 { code:0x1052
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1052
  ,simpleLowerCaseMapping:0x1052
  ,simpleTitleCaseMapping:0x1052
 },
 { code:0x1053
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1053
  ,simpleLowerCaseMapping:0x1053
  ,simpleTitleCaseMapping:0x1053
 },
 { code:0x1054
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1054
  ,simpleLowerCaseMapping:0x1054
  ,simpleTitleCaseMapping:0x1054
 },
 { code:0x1055
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1055
  ,simpleLowerCaseMapping:0x1055
  ,simpleTitleCaseMapping:0x1055
 },
 { code:0x1056
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1056
  ,simpleLowerCaseMapping:0x1056
  ,simpleTitleCaseMapping:0x1056
 },
 { code:0x1057
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1057
  ,simpleLowerCaseMapping:0x1057
  ,simpleTitleCaseMapping:0x1057
 },
 { code:0x1058
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1058
  ,simpleLowerCaseMapping:0x1058
  ,simpleTitleCaseMapping:0x1058
 },
 { code:0x1059
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1059
  ,simpleLowerCaseMapping:0x1059
  ,simpleTitleCaseMapping:0x1059
 },
 { code:0x10A0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10A0
  ,simpleLowerCaseMapping:0x2D00
  ,simpleTitleCaseMapping:0x10A0
 },
 { code:0x10A1
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10A1
  ,simpleLowerCaseMapping:0x2D01
  ,simpleTitleCaseMapping:0x10A1
 },
 { code:0x10A2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10A2
  ,simpleLowerCaseMapping:0x2D02
  ,simpleTitleCaseMapping:0x10A2
 },
 { code:0x10A3
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10A3
  ,simpleLowerCaseMapping:0x2D03
  ,simpleTitleCaseMapping:0x10A3
 },
 { code:0x10A4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10A4
  ,simpleLowerCaseMapping:0x2D04
  ,simpleTitleCaseMapping:0x10A4
 },
 { code:0x10A5
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10A5
  ,simpleLowerCaseMapping:0x2D05
  ,simpleTitleCaseMapping:0x10A5
 },
 { code:0x10A6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10A6
  ,simpleLowerCaseMapping:0x2D06
  ,simpleTitleCaseMapping:0x10A6
 },
 { code:0x10A7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10A7
  ,simpleLowerCaseMapping:0x2D07
  ,simpleTitleCaseMapping:0x10A7
 },
 { code:0x10A8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10A8
  ,simpleLowerCaseMapping:0x2D08
  ,simpleTitleCaseMapping:0x10A8
 },
 { code:0x10A9
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10A9
  ,simpleLowerCaseMapping:0x2D09
  ,simpleTitleCaseMapping:0x10A9
 },
 { code:0x10AA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10AA
  ,simpleLowerCaseMapping:0x2D0A
  ,simpleTitleCaseMapping:0x10AA
 },
 { code:0x10AB
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10AB
  ,simpleLowerCaseMapping:0x2D0B
  ,simpleTitleCaseMapping:0x10AB
 },
 { code:0x10AC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10AC
  ,simpleLowerCaseMapping:0x2D0C
  ,simpleTitleCaseMapping:0x10AC
 },
 { code:0x10AD
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10AD
  ,simpleLowerCaseMapping:0x2D0D
  ,simpleTitleCaseMapping:0x10AD
 },
 { code:0x10AE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10AE
  ,simpleLowerCaseMapping:0x2D0E
  ,simpleTitleCaseMapping:0x10AE
 },
 { code:0x10AF
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10AF
  ,simpleLowerCaseMapping:0x2D0F
  ,simpleTitleCaseMapping:0x10AF
 },
 { code:0x10B0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10B0
  ,simpleLowerCaseMapping:0x2D10
  ,simpleTitleCaseMapping:0x10B0
 },
 { code:0x10B1
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10B1
  ,simpleLowerCaseMapping:0x2D11
  ,simpleTitleCaseMapping:0x10B1
 },
 { code:0x10B2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10B2
  ,simpleLowerCaseMapping:0x2D12
  ,simpleTitleCaseMapping:0x10B2
 },
 { code:0x10B3
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10B3
  ,simpleLowerCaseMapping:0x2D13
  ,simpleTitleCaseMapping:0x10B3
 },
 { code:0x10B4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10B4
  ,simpleLowerCaseMapping:0x2D14
  ,simpleTitleCaseMapping:0x10B4
 },
 { code:0x10B5
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10B5
  ,simpleLowerCaseMapping:0x2D15
  ,simpleTitleCaseMapping:0x10B5
 },
 { code:0x10B6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10B6
  ,simpleLowerCaseMapping:0x2D16
  ,simpleTitleCaseMapping:0x10B6
 },
 { code:0x10B7
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10B7
  ,simpleLowerCaseMapping:0x2D17
  ,simpleTitleCaseMapping:0x10B7
 },
 { code:0x10B8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10B8
  ,simpleLowerCaseMapping:0x2D18
  ,simpleTitleCaseMapping:0x10B8
 },
 { code:0x10B9
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10B9
  ,simpleLowerCaseMapping:0x2D19
  ,simpleTitleCaseMapping:0x10B9
 },
 { code:0x10BA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10BA
  ,simpleLowerCaseMapping:0x2D1A
  ,simpleTitleCaseMapping:0x10BA
 },
 { code:0x10BB
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10BB
  ,simpleLowerCaseMapping:0x2D1B
  ,simpleTitleCaseMapping:0x10BB
 },
 { code:0x10BC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10BC
  ,simpleLowerCaseMapping:0x2D1C
  ,simpleTitleCaseMapping:0x10BC
 },
 { code:0x10BD
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10BD
  ,simpleLowerCaseMapping:0x2D1D
  ,simpleTitleCaseMapping:0x10BD
 },
 { code:0x10BE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10BE
  ,simpleLowerCaseMapping:0x2D1E
  ,simpleTitleCaseMapping:0x10BE
 },
 { code:0x10BF
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10BF
  ,simpleLowerCaseMapping:0x2D1F
  ,simpleTitleCaseMapping:0x10BF
 },
 { code:0x10C0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10C0
  ,simpleLowerCaseMapping:0x2D20
  ,simpleTitleCaseMapping:0x10C0
 },
 { code:0x10C1
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10C1
  ,simpleLowerCaseMapping:0x2D21
  ,simpleTitleCaseMapping:0x10C1
 },
 { code:0x10C2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10C2
  ,simpleLowerCaseMapping:0x2D22
  ,simpleTitleCaseMapping:0x10C2
 },
 { code:0x10C3
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10C3
  ,simpleLowerCaseMapping:0x2D23
  ,simpleTitleCaseMapping:0x10C3
 },
 { code:0x10C4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10C4
  ,simpleLowerCaseMapping:0x2D24
  ,simpleTitleCaseMapping:0x10C4
 },
 { code:0x10C5
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x10C5
  ,simpleLowerCaseMapping:0x2D25
  ,simpleTitleCaseMapping:0x10C5
 },
 { code:0x10D0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10D0
  ,simpleLowerCaseMapping:0x10D0
  ,simpleTitleCaseMapping:0x10D0
 },
 { code:0x10D1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10D1
  ,simpleLowerCaseMapping:0x10D1
  ,simpleTitleCaseMapping:0x10D1
 },
 { code:0x10D2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10D2
  ,simpleLowerCaseMapping:0x10D2
  ,simpleTitleCaseMapping:0x10D2
 },
 { code:0x10D3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10D3
  ,simpleLowerCaseMapping:0x10D3
  ,simpleTitleCaseMapping:0x10D3
 },
 { code:0x10D4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10D4
  ,simpleLowerCaseMapping:0x10D4
  ,simpleTitleCaseMapping:0x10D4
 },
 { code:0x10D5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10D5
  ,simpleLowerCaseMapping:0x10D5
  ,simpleTitleCaseMapping:0x10D5
 },
 { code:0x10D6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10D6
  ,simpleLowerCaseMapping:0x10D6
  ,simpleTitleCaseMapping:0x10D6
 },
 { code:0x10D7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10D7
  ,simpleLowerCaseMapping:0x10D7
  ,simpleTitleCaseMapping:0x10D7
 },
 { code:0x10D8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10D8
  ,simpleLowerCaseMapping:0x10D8
  ,simpleTitleCaseMapping:0x10D8
 },
 { code:0x10D9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10D9
  ,simpleLowerCaseMapping:0x10D9
  ,simpleTitleCaseMapping:0x10D9
 },
 { code:0x10DA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10DA
  ,simpleLowerCaseMapping:0x10DA
  ,simpleTitleCaseMapping:0x10DA
 },
 { code:0x10DB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10DB
  ,simpleLowerCaseMapping:0x10DB
  ,simpleTitleCaseMapping:0x10DB
 },
 { code:0x10DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10DC
  ,simpleLowerCaseMapping:0x10DC
  ,simpleTitleCaseMapping:0x10DC
 },
 { code:0x10DD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10DD
  ,simpleLowerCaseMapping:0x10DD
  ,simpleTitleCaseMapping:0x10DD
 },
 { code:0x10DE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10DE
  ,simpleLowerCaseMapping:0x10DE
  ,simpleTitleCaseMapping:0x10DE
 },
 { code:0x10DF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10DF
  ,simpleLowerCaseMapping:0x10DF
  ,simpleTitleCaseMapping:0x10DF
 },
 { code:0x10E0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10E0
  ,simpleLowerCaseMapping:0x10E0
  ,simpleTitleCaseMapping:0x10E0
 },
 { code:0x10E1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10E1
  ,simpleLowerCaseMapping:0x10E1
  ,simpleTitleCaseMapping:0x10E1
 },
 { code:0x10E2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10E2
  ,simpleLowerCaseMapping:0x10E2
  ,simpleTitleCaseMapping:0x10E2
 },
 { code:0x10E3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10E3
  ,simpleLowerCaseMapping:0x10E3
  ,simpleTitleCaseMapping:0x10E3
 },
 { code:0x10E4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10E4
  ,simpleLowerCaseMapping:0x10E4
  ,simpleTitleCaseMapping:0x10E4
 },
 { code:0x10E5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10E5
  ,simpleLowerCaseMapping:0x10E5
  ,simpleTitleCaseMapping:0x10E5
 },
 { code:0x10E6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10E6
  ,simpleLowerCaseMapping:0x10E6
  ,simpleTitleCaseMapping:0x10E6
 },
 { code:0x10E7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10E7
  ,simpleLowerCaseMapping:0x10E7
  ,simpleTitleCaseMapping:0x10E7
 },
 { code:0x10E8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10E8
  ,simpleLowerCaseMapping:0x10E8
  ,simpleTitleCaseMapping:0x10E8
 },
 { code:0x10E9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10E9
  ,simpleLowerCaseMapping:0x10E9
  ,simpleTitleCaseMapping:0x10E9
 },
 { code:0x10EA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10EA
  ,simpleLowerCaseMapping:0x10EA
  ,simpleTitleCaseMapping:0x10EA
 },
 { code:0x10EB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10EB
  ,simpleLowerCaseMapping:0x10EB
  ,simpleTitleCaseMapping:0x10EB
 },
 { code:0x10EC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10EC
  ,simpleLowerCaseMapping:0x10EC
  ,simpleTitleCaseMapping:0x10EC
 },
 { code:0x10ED
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10ED
  ,simpleLowerCaseMapping:0x10ED
  ,simpleTitleCaseMapping:0x10ED
 },
 { code:0x10EE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10EE
  ,simpleLowerCaseMapping:0x10EE
  ,simpleTitleCaseMapping:0x10EE
 },
 { code:0x10EF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10EF
  ,simpleLowerCaseMapping:0x10EF
  ,simpleTitleCaseMapping:0x10EF
 },
 { code:0x10F0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10F0
  ,simpleLowerCaseMapping:0x10F0
  ,simpleTitleCaseMapping:0x10F0
 },
 { code:0x10F1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10F1
  ,simpleLowerCaseMapping:0x10F1
  ,simpleTitleCaseMapping:0x10F1
 },
 { code:0x10F2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10F2
  ,simpleLowerCaseMapping:0x10F2
  ,simpleTitleCaseMapping:0x10F2
 },
 { code:0x10F3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10F3
  ,simpleLowerCaseMapping:0x10F3
  ,simpleTitleCaseMapping:0x10F3
 },
 { code:0x10F4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10F4
  ,simpleLowerCaseMapping:0x10F4
  ,simpleTitleCaseMapping:0x10F4
 },
 { code:0x10F5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10F5
  ,simpleLowerCaseMapping:0x10F5
  ,simpleTitleCaseMapping:0x10F5
 },
 { code:0x10F6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10F6
  ,simpleLowerCaseMapping:0x10F6
  ,simpleTitleCaseMapping:0x10F6
 },
 { code:0x10F7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10F7
  ,simpleLowerCaseMapping:0x10F7
  ,simpleTitleCaseMapping:0x10F7
 },
 { code:0x10F8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10F8
  ,simpleLowerCaseMapping:0x10F8
  ,simpleTitleCaseMapping:0x10F8
 },
 { code:0x10F9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10F9
  ,simpleLowerCaseMapping:0x10F9
  ,simpleTitleCaseMapping:0x10F9
 },
 { code:0x10FA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x10FA
  ,simpleLowerCaseMapping:0x10FA
  ,simpleTitleCaseMapping:0x10FA
 },
 { code:0x10FB
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x10FB
  ,simpleLowerCaseMapping:0x10FB
  ,simpleTitleCaseMapping:0x10FB
 },
 { code:0x10FC
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x10FC
  ,simpleLowerCaseMapping:0x10FC
  ,simpleTitleCaseMapping:0x10FC
 },
 { code:0x1100
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1100
  ,simpleLowerCaseMapping:0x1100
  ,simpleTitleCaseMapping:0x1100
 },
 { code:0x1101
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1101
  ,simpleLowerCaseMapping:0x1101
  ,simpleTitleCaseMapping:0x1101
 },
 { code:0x1102
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1102
  ,simpleLowerCaseMapping:0x1102
  ,simpleTitleCaseMapping:0x1102
 },
 { code:0x1103
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1103
  ,simpleLowerCaseMapping:0x1103
  ,simpleTitleCaseMapping:0x1103
 },
 { code:0x1104
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1104
  ,simpleLowerCaseMapping:0x1104
  ,simpleTitleCaseMapping:0x1104
 },
 { code:0x1105
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1105
  ,simpleLowerCaseMapping:0x1105
  ,simpleTitleCaseMapping:0x1105
 },
 { code:0x1106
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1106
  ,simpleLowerCaseMapping:0x1106
  ,simpleTitleCaseMapping:0x1106
 },
 { code:0x1107
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1107
  ,simpleLowerCaseMapping:0x1107
  ,simpleTitleCaseMapping:0x1107
 },
 { code:0x1108
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1108
  ,simpleLowerCaseMapping:0x1108
  ,simpleTitleCaseMapping:0x1108
 },
 { code:0x1109
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1109
  ,simpleLowerCaseMapping:0x1109
  ,simpleTitleCaseMapping:0x1109
 },
 { code:0x110A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x110A
  ,simpleLowerCaseMapping:0x110A
  ,simpleTitleCaseMapping:0x110A
 },
 { code:0x110B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x110B
  ,simpleLowerCaseMapping:0x110B
  ,simpleTitleCaseMapping:0x110B
 },
 { code:0x110C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x110C
  ,simpleLowerCaseMapping:0x110C
  ,simpleTitleCaseMapping:0x110C
 },
 { code:0x110D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x110D
  ,simpleLowerCaseMapping:0x110D
  ,simpleTitleCaseMapping:0x110D
 },
 { code:0x110E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x110E
  ,simpleLowerCaseMapping:0x110E
  ,simpleTitleCaseMapping:0x110E
 },
 { code:0x110F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x110F
  ,simpleLowerCaseMapping:0x110F
  ,simpleTitleCaseMapping:0x110F
 },
 { code:0x1110
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1110
  ,simpleLowerCaseMapping:0x1110
  ,simpleTitleCaseMapping:0x1110
 },
 { code:0x1111
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1111
  ,simpleLowerCaseMapping:0x1111
  ,simpleTitleCaseMapping:0x1111
 },
 { code:0x1112
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1112
  ,simpleLowerCaseMapping:0x1112
  ,simpleTitleCaseMapping:0x1112
 },
 { code:0x1113
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1113
  ,simpleLowerCaseMapping:0x1113
  ,simpleTitleCaseMapping:0x1113
 },
 { code:0x1114
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1114
  ,simpleLowerCaseMapping:0x1114
  ,simpleTitleCaseMapping:0x1114
 },
 { code:0x1115
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1115
  ,simpleLowerCaseMapping:0x1115
  ,simpleTitleCaseMapping:0x1115
 },
 { code:0x1116
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1116
  ,simpleLowerCaseMapping:0x1116
  ,simpleTitleCaseMapping:0x1116
 },
 { code:0x1117
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1117
  ,simpleLowerCaseMapping:0x1117
  ,simpleTitleCaseMapping:0x1117
 },
 { code:0x1118
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1118
  ,simpleLowerCaseMapping:0x1118
  ,simpleTitleCaseMapping:0x1118
 },
 { code:0x1119
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1119
  ,simpleLowerCaseMapping:0x1119
  ,simpleTitleCaseMapping:0x1119
 },
 { code:0x111A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x111A
  ,simpleLowerCaseMapping:0x111A
  ,simpleTitleCaseMapping:0x111A
 },
 { code:0x111B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x111B
  ,simpleLowerCaseMapping:0x111B
  ,simpleTitleCaseMapping:0x111B
 },
 { code:0x111C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x111C
  ,simpleLowerCaseMapping:0x111C
  ,simpleTitleCaseMapping:0x111C
 },
 { code:0x111D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x111D
  ,simpleLowerCaseMapping:0x111D
  ,simpleTitleCaseMapping:0x111D
 },
 { code:0x111E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x111E
  ,simpleLowerCaseMapping:0x111E
  ,simpleTitleCaseMapping:0x111E
 },
 { code:0x111F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x111F
  ,simpleLowerCaseMapping:0x111F
  ,simpleTitleCaseMapping:0x111F
 },
 { code:0x1120
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1120
  ,simpleLowerCaseMapping:0x1120
  ,simpleTitleCaseMapping:0x1120
 },
 { code:0x1121
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1121
  ,simpleLowerCaseMapping:0x1121
  ,simpleTitleCaseMapping:0x1121
 },
 { code:0x1122
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1122
  ,simpleLowerCaseMapping:0x1122
  ,simpleTitleCaseMapping:0x1122
 },
 { code:0x1123
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1123
  ,simpleLowerCaseMapping:0x1123
  ,simpleTitleCaseMapping:0x1123
 },
 { code:0x1124
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1124
  ,simpleLowerCaseMapping:0x1124
  ,simpleTitleCaseMapping:0x1124
 },
 { code:0x1125
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1125
  ,simpleLowerCaseMapping:0x1125
  ,simpleTitleCaseMapping:0x1125
 },
 { code:0x1126
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1126
  ,simpleLowerCaseMapping:0x1126
  ,simpleTitleCaseMapping:0x1126
 },
 { code:0x1127
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1127
  ,simpleLowerCaseMapping:0x1127
  ,simpleTitleCaseMapping:0x1127
 },
 { code:0x1128
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1128
  ,simpleLowerCaseMapping:0x1128
  ,simpleTitleCaseMapping:0x1128
 },
 { code:0x1129
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1129
  ,simpleLowerCaseMapping:0x1129
  ,simpleTitleCaseMapping:0x1129
 },
 { code:0x112A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x112A
  ,simpleLowerCaseMapping:0x112A
  ,simpleTitleCaseMapping:0x112A
 },
 { code:0x112B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x112B
  ,simpleLowerCaseMapping:0x112B
  ,simpleTitleCaseMapping:0x112B
 },
 { code:0x112C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x112C
  ,simpleLowerCaseMapping:0x112C
  ,simpleTitleCaseMapping:0x112C
 },
 { code:0x112D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x112D
  ,simpleLowerCaseMapping:0x112D
  ,simpleTitleCaseMapping:0x112D
 },
 { code:0x112E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x112E
  ,simpleLowerCaseMapping:0x112E
  ,simpleTitleCaseMapping:0x112E
 },
 { code:0x112F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x112F
  ,simpleLowerCaseMapping:0x112F
  ,simpleTitleCaseMapping:0x112F
 },
 { code:0x1130
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1130
  ,simpleLowerCaseMapping:0x1130
  ,simpleTitleCaseMapping:0x1130
 },
 { code:0x1131
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1131
  ,simpleLowerCaseMapping:0x1131
  ,simpleTitleCaseMapping:0x1131
 },
 { code:0x1132
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1132
  ,simpleLowerCaseMapping:0x1132
  ,simpleTitleCaseMapping:0x1132
 },
 { code:0x1133
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1133
  ,simpleLowerCaseMapping:0x1133
  ,simpleTitleCaseMapping:0x1133
 },
 { code:0x1134
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1134
  ,simpleLowerCaseMapping:0x1134
  ,simpleTitleCaseMapping:0x1134
 },
 { code:0x1135
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1135
  ,simpleLowerCaseMapping:0x1135
  ,simpleTitleCaseMapping:0x1135
 },
 { code:0x1136
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1136
  ,simpleLowerCaseMapping:0x1136
  ,simpleTitleCaseMapping:0x1136
 },
 { code:0x1137
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1137
  ,simpleLowerCaseMapping:0x1137
  ,simpleTitleCaseMapping:0x1137
 },
 { code:0x1138
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1138
  ,simpleLowerCaseMapping:0x1138
  ,simpleTitleCaseMapping:0x1138
 },
 { code:0x1139
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1139
  ,simpleLowerCaseMapping:0x1139
  ,simpleTitleCaseMapping:0x1139
 },
 { code:0x113A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x113A
  ,simpleLowerCaseMapping:0x113A
  ,simpleTitleCaseMapping:0x113A
 },
 { code:0x113B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x113B
  ,simpleLowerCaseMapping:0x113B
  ,simpleTitleCaseMapping:0x113B
 },
 { code:0x113C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x113C
  ,simpleLowerCaseMapping:0x113C
  ,simpleTitleCaseMapping:0x113C
 },
 { code:0x113D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x113D
  ,simpleLowerCaseMapping:0x113D
  ,simpleTitleCaseMapping:0x113D
 },
 { code:0x113E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x113E
  ,simpleLowerCaseMapping:0x113E
  ,simpleTitleCaseMapping:0x113E
 },
 { code:0x113F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x113F
  ,simpleLowerCaseMapping:0x113F
  ,simpleTitleCaseMapping:0x113F
 },
 { code:0x1140
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1140
  ,simpleLowerCaseMapping:0x1140
  ,simpleTitleCaseMapping:0x1140
 },
 { code:0x1141
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1141
  ,simpleLowerCaseMapping:0x1141
  ,simpleTitleCaseMapping:0x1141
 },
 { code:0x1142
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1142
  ,simpleLowerCaseMapping:0x1142
  ,simpleTitleCaseMapping:0x1142
 },
 { code:0x1143
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1143
  ,simpleLowerCaseMapping:0x1143
  ,simpleTitleCaseMapping:0x1143
 },
 { code:0x1144
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1144
  ,simpleLowerCaseMapping:0x1144
  ,simpleTitleCaseMapping:0x1144
 },
 { code:0x1145
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1145
  ,simpleLowerCaseMapping:0x1145
  ,simpleTitleCaseMapping:0x1145
 },
 { code:0x1146
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1146
  ,simpleLowerCaseMapping:0x1146
  ,simpleTitleCaseMapping:0x1146
 },
 { code:0x1147
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1147
  ,simpleLowerCaseMapping:0x1147
  ,simpleTitleCaseMapping:0x1147
 },
 { code:0x1148
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1148
  ,simpleLowerCaseMapping:0x1148
  ,simpleTitleCaseMapping:0x1148
 },
 { code:0x1149
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1149
  ,simpleLowerCaseMapping:0x1149
  ,simpleTitleCaseMapping:0x1149
 },
 { code:0x114A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x114A
  ,simpleLowerCaseMapping:0x114A
  ,simpleTitleCaseMapping:0x114A
 },
 { code:0x114B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x114B
  ,simpleLowerCaseMapping:0x114B
  ,simpleTitleCaseMapping:0x114B
 },
 { code:0x114C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x114C
  ,simpleLowerCaseMapping:0x114C
  ,simpleTitleCaseMapping:0x114C
 },
 { code:0x114D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x114D
  ,simpleLowerCaseMapping:0x114D
  ,simpleTitleCaseMapping:0x114D
 },
 { code:0x114E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x114E
  ,simpleLowerCaseMapping:0x114E
  ,simpleTitleCaseMapping:0x114E
 },
 { code:0x114F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x114F
  ,simpleLowerCaseMapping:0x114F
  ,simpleTitleCaseMapping:0x114F
 },
 { code:0x1150
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1150
  ,simpleLowerCaseMapping:0x1150
  ,simpleTitleCaseMapping:0x1150
 },
 { code:0x1151
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1151
  ,simpleLowerCaseMapping:0x1151
  ,simpleTitleCaseMapping:0x1151
 },
 { code:0x1152
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1152
  ,simpleLowerCaseMapping:0x1152
  ,simpleTitleCaseMapping:0x1152
 },
 { code:0x1153
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1153
  ,simpleLowerCaseMapping:0x1153
  ,simpleTitleCaseMapping:0x1153
 },
 { code:0x1154
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1154
  ,simpleLowerCaseMapping:0x1154
  ,simpleTitleCaseMapping:0x1154
 },
 { code:0x1155
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1155
  ,simpleLowerCaseMapping:0x1155
  ,simpleTitleCaseMapping:0x1155
 },
 { code:0x1156
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1156
  ,simpleLowerCaseMapping:0x1156
  ,simpleTitleCaseMapping:0x1156
 },
 { code:0x1157
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1157
  ,simpleLowerCaseMapping:0x1157
  ,simpleTitleCaseMapping:0x1157
 },
 { code:0x1158
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1158
  ,simpleLowerCaseMapping:0x1158
  ,simpleTitleCaseMapping:0x1158
 },
 { code:0x1159
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1159
  ,simpleLowerCaseMapping:0x1159
  ,simpleTitleCaseMapping:0x1159
 },
 { code:0x115F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x115F
  ,simpleLowerCaseMapping:0x115F
  ,simpleTitleCaseMapping:0x115F
 },
 { code:0x1160
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1160
  ,simpleLowerCaseMapping:0x1160
  ,simpleTitleCaseMapping:0x1160
 },
 { code:0x1161
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1161
  ,simpleLowerCaseMapping:0x1161
  ,simpleTitleCaseMapping:0x1161
 },
 { code:0x1162
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1162
  ,simpleLowerCaseMapping:0x1162
  ,simpleTitleCaseMapping:0x1162
 },
 { code:0x1163
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1163
  ,simpleLowerCaseMapping:0x1163
  ,simpleTitleCaseMapping:0x1163
 },
 { code:0x1164
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1164
  ,simpleLowerCaseMapping:0x1164
  ,simpleTitleCaseMapping:0x1164
 },
 { code:0x1165
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1165
  ,simpleLowerCaseMapping:0x1165
  ,simpleTitleCaseMapping:0x1165
 },
 { code:0x1166
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1166
  ,simpleLowerCaseMapping:0x1166
  ,simpleTitleCaseMapping:0x1166
 },
 { code:0x1167
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1167
  ,simpleLowerCaseMapping:0x1167
  ,simpleTitleCaseMapping:0x1167
 },
 { code:0x1168
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1168
  ,simpleLowerCaseMapping:0x1168
  ,simpleTitleCaseMapping:0x1168
 },
 { code:0x1169
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1169
  ,simpleLowerCaseMapping:0x1169
  ,simpleTitleCaseMapping:0x1169
 },
 { code:0x116A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x116A
  ,simpleLowerCaseMapping:0x116A
  ,simpleTitleCaseMapping:0x116A
 },
 { code:0x116B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x116B
  ,simpleLowerCaseMapping:0x116B
  ,simpleTitleCaseMapping:0x116B
 },
 { code:0x116C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x116C
  ,simpleLowerCaseMapping:0x116C
  ,simpleTitleCaseMapping:0x116C
 },
 { code:0x116D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x116D
  ,simpleLowerCaseMapping:0x116D
  ,simpleTitleCaseMapping:0x116D
 },
 { code:0x116E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x116E
  ,simpleLowerCaseMapping:0x116E
  ,simpleTitleCaseMapping:0x116E
 },
 { code:0x116F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x116F
  ,simpleLowerCaseMapping:0x116F
  ,simpleTitleCaseMapping:0x116F
 },
 { code:0x1170
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1170
  ,simpleLowerCaseMapping:0x1170
  ,simpleTitleCaseMapping:0x1170
 },
 { code:0x1171
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1171
  ,simpleLowerCaseMapping:0x1171
  ,simpleTitleCaseMapping:0x1171
 },
 { code:0x1172
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1172
  ,simpleLowerCaseMapping:0x1172
  ,simpleTitleCaseMapping:0x1172
 },
 { code:0x1173
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1173
  ,simpleLowerCaseMapping:0x1173
  ,simpleTitleCaseMapping:0x1173
 },
 { code:0x1174
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1174
  ,simpleLowerCaseMapping:0x1174
  ,simpleTitleCaseMapping:0x1174
 },
 { code:0x1175
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1175
  ,simpleLowerCaseMapping:0x1175
  ,simpleTitleCaseMapping:0x1175
 },
 { code:0x1176
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1176
  ,simpleLowerCaseMapping:0x1176
  ,simpleTitleCaseMapping:0x1176
 },
 { code:0x1177
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1177
  ,simpleLowerCaseMapping:0x1177
  ,simpleTitleCaseMapping:0x1177
 },
 { code:0x1178
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1178
  ,simpleLowerCaseMapping:0x1178
  ,simpleTitleCaseMapping:0x1178
 },
 { code:0x1179
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1179
  ,simpleLowerCaseMapping:0x1179
  ,simpleTitleCaseMapping:0x1179
 },
 { code:0x117A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x117A
  ,simpleLowerCaseMapping:0x117A
  ,simpleTitleCaseMapping:0x117A
 },
 { code:0x117B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x117B
  ,simpleLowerCaseMapping:0x117B
  ,simpleTitleCaseMapping:0x117B
 },
 { code:0x117C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x117C
  ,simpleLowerCaseMapping:0x117C
  ,simpleTitleCaseMapping:0x117C
 },
 { code:0x117D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x117D
  ,simpleLowerCaseMapping:0x117D
  ,simpleTitleCaseMapping:0x117D
 },
 { code:0x117E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x117E
  ,simpleLowerCaseMapping:0x117E
  ,simpleTitleCaseMapping:0x117E
 },
 { code:0x117F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x117F
  ,simpleLowerCaseMapping:0x117F
  ,simpleTitleCaseMapping:0x117F
 },
 { code:0x1180
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1180
  ,simpleLowerCaseMapping:0x1180
  ,simpleTitleCaseMapping:0x1180
 },
 { code:0x1181
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1181
  ,simpleLowerCaseMapping:0x1181
  ,simpleTitleCaseMapping:0x1181
 },
 { code:0x1182
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1182
  ,simpleLowerCaseMapping:0x1182
  ,simpleTitleCaseMapping:0x1182
 },
 { code:0x1183
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1183
  ,simpleLowerCaseMapping:0x1183
  ,simpleTitleCaseMapping:0x1183
 },
 { code:0x1184
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1184
  ,simpleLowerCaseMapping:0x1184
  ,simpleTitleCaseMapping:0x1184
 },
 { code:0x1185
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1185
  ,simpleLowerCaseMapping:0x1185
  ,simpleTitleCaseMapping:0x1185
 },
 { code:0x1186
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1186
  ,simpleLowerCaseMapping:0x1186
  ,simpleTitleCaseMapping:0x1186
 },
 { code:0x1187
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1187
  ,simpleLowerCaseMapping:0x1187
  ,simpleTitleCaseMapping:0x1187
 },
 { code:0x1188
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1188
  ,simpleLowerCaseMapping:0x1188
  ,simpleTitleCaseMapping:0x1188
 },
 { code:0x1189
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1189
  ,simpleLowerCaseMapping:0x1189
  ,simpleTitleCaseMapping:0x1189
 },
 { code:0x118A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x118A
  ,simpleLowerCaseMapping:0x118A
  ,simpleTitleCaseMapping:0x118A
 },
 { code:0x118B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x118B
  ,simpleLowerCaseMapping:0x118B
  ,simpleTitleCaseMapping:0x118B
 },
 { code:0x118C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x118C
  ,simpleLowerCaseMapping:0x118C
  ,simpleTitleCaseMapping:0x118C
 },
 { code:0x118D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x118D
  ,simpleLowerCaseMapping:0x118D
  ,simpleTitleCaseMapping:0x118D
 },
 { code:0x118E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x118E
  ,simpleLowerCaseMapping:0x118E
  ,simpleTitleCaseMapping:0x118E
 },
 { code:0x118F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x118F
  ,simpleLowerCaseMapping:0x118F
  ,simpleTitleCaseMapping:0x118F
 },
 { code:0x1190
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1190
  ,simpleLowerCaseMapping:0x1190
  ,simpleTitleCaseMapping:0x1190
 },
 { code:0x1191
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1191
  ,simpleLowerCaseMapping:0x1191
  ,simpleTitleCaseMapping:0x1191
 },
 { code:0x1192
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1192
  ,simpleLowerCaseMapping:0x1192
  ,simpleTitleCaseMapping:0x1192
 },
 { code:0x1193
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1193
  ,simpleLowerCaseMapping:0x1193
  ,simpleTitleCaseMapping:0x1193
 },
 { code:0x1194
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1194
  ,simpleLowerCaseMapping:0x1194
  ,simpleTitleCaseMapping:0x1194
 },
 { code:0x1195
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1195
  ,simpleLowerCaseMapping:0x1195
  ,simpleTitleCaseMapping:0x1195
 },
 { code:0x1196
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1196
  ,simpleLowerCaseMapping:0x1196
  ,simpleTitleCaseMapping:0x1196
 },
 { code:0x1197
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1197
  ,simpleLowerCaseMapping:0x1197
  ,simpleTitleCaseMapping:0x1197
 },
 { code:0x1198
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1198
  ,simpleLowerCaseMapping:0x1198
  ,simpleTitleCaseMapping:0x1198
 },
 { code:0x1199
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1199
  ,simpleLowerCaseMapping:0x1199
  ,simpleTitleCaseMapping:0x1199
 },
 { code:0x119A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x119A
  ,simpleLowerCaseMapping:0x119A
  ,simpleTitleCaseMapping:0x119A
 },
 { code:0x119B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x119B
  ,simpleLowerCaseMapping:0x119B
  ,simpleTitleCaseMapping:0x119B
 },
 { code:0x119C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x119C
  ,simpleLowerCaseMapping:0x119C
  ,simpleTitleCaseMapping:0x119C
 },
 { code:0x119D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x119D
  ,simpleLowerCaseMapping:0x119D
  ,simpleTitleCaseMapping:0x119D
 },
 { code:0x119E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x119E
  ,simpleLowerCaseMapping:0x119E
  ,simpleTitleCaseMapping:0x119E
 },
 { code:0x119F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x119F
  ,simpleLowerCaseMapping:0x119F
  ,simpleTitleCaseMapping:0x119F
 },
 { code:0x11A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11A0
  ,simpleLowerCaseMapping:0x11A0
  ,simpleTitleCaseMapping:0x11A0
 },
 { code:0x11A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11A1
  ,simpleLowerCaseMapping:0x11A1
  ,simpleTitleCaseMapping:0x11A1
 },
 { code:0x11A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11A2
  ,simpleLowerCaseMapping:0x11A2
  ,simpleTitleCaseMapping:0x11A2
 },
 { code:0x11A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11A8
  ,simpleLowerCaseMapping:0x11A8
  ,simpleTitleCaseMapping:0x11A8
 },
 { code:0x11A9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11A9
  ,simpleLowerCaseMapping:0x11A9
  ,simpleTitleCaseMapping:0x11A9
 },
 { code:0x11AA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11AA
  ,simpleLowerCaseMapping:0x11AA
  ,simpleTitleCaseMapping:0x11AA
 },
 { code:0x11AB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11AB
  ,simpleLowerCaseMapping:0x11AB
  ,simpleTitleCaseMapping:0x11AB
 },
 { code:0x11AC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11AC
  ,simpleLowerCaseMapping:0x11AC
  ,simpleTitleCaseMapping:0x11AC
 },
 { code:0x11AD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11AD
  ,simpleLowerCaseMapping:0x11AD
  ,simpleTitleCaseMapping:0x11AD
 },
 { code:0x11AE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11AE
  ,simpleLowerCaseMapping:0x11AE
  ,simpleTitleCaseMapping:0x11AE
 },
 { code:0x11AF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11AF
  ,simpleLowerCaseMapping:0x11AF
  ,simpleTitleCaseMapping:0x11AF
 },
 { code:0x11B0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11B0
  ,simpleLowerCaseMapping:0x11B0
  ,simpleTitleCaseMapping:0x11B0
 },
 { code:0x11B1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11B1
  ,simpleLowerCaseMapping:0x11B1
  ,simpleTitleCaseMapping:0x11B1
 },
 { code:0x11B2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11B2
  ,simpleLowerCaseMapping:0x11B2
  ,simpleTitleCaseMapping:0x11B2
 },
 { code:0x11B3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11B3
  ,simpleLowerCaseMapping:0x11B3
  ,simpleTitleCaseMapping:0x11B3
 },
 { code:0x11B4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11B4
  ,simpleLowerCaseMapping:0x11B4
  ,simpleTitleCaseMapping:0x11B4
 },
 { code:0x11B5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11B5
  ,simpleLowerCaseMapping:0x11B5
  ,simpleTitleCaseMapping:0x11B5
 },
 { code:0x11B6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11B6
  ,simpleLowerCaseMapping:0x11B6
  ,simpleTitleCaseMapping:0x11B6
 },
 { code:0x11B7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11B7
  ,simpleLowerCaseMapping:0x11B7
  ,simpleTitleCaseMapping:0x11B7
 },
 { code:0x11B8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11B8
  ,simpleLowerCaseMapping:0x11B8
  ,simpleTitleCaseMapping:0x11B8
 },
 { code:0x11B9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11B9
  ,simpleLowerCaseMapping:0x11B9
  ,simpleTitleCaseMapping:0x11B9
 },
 { code:0x11BA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11BA
  ,simpleLowerCaseMapping:0x11BA
  ,simpleTitleCaseMapping:0x11BA
 },
 { code:0x11BB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11BB
  ,simpleLowerCaseMapping:0x11BB
  ,simpleTitleCaseMapping:0x11BB
 },
 { code:0x11BC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11BC
  ,simpleLowerCaseMapping:0x11BC
  ,simpleTitleCaseMapping:0x11BC
 },
 { code:0x11BD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11BD
  ,simpleLowerCaseMapping:0x11BD
  ,simpleTitleCaseMapping:0x11BD
 },
 { code:0x11BE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11BE
  ,simpleLowerCaseMapping:0x11BE
  ,simpleTitleCaseMapping:0x11BE
 },
 { code:0x11BF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11BF
  ,simpleLowerCaseMapping:0x11BF
  ,simpleTitleCaseMapping:0x11BF
 },
 { code:0x11C0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11C0
  ,simpleLowerCaseMapping:0x11C0
  ,simpleTitleCaseMapping:0x11C0
 },
 { code:0x11C1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11C1
  ,simpleLowerCaseMapping:0x11C1
  ,simpleTitleCaseMapping:0x11C1
 },
 { code:0x11C2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11C2
  ,simpleLowerCaseMapping:0x11C2
  ,simpleTitleCaseMapping:0x11C2
 },
 { code:0x11C3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11C3
  ,simpleLowerCaseMapping:0x11C3
  ,simpleTitleCaseMapping:0x11C3
 },
 { code:0x11C4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11C4
  ,simpleLowerCaseMapping:0x11C4
  ,simpleTitleCaseMapping:0x11C4
 },
 { code:0x11C5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11C5
  ,simpleLowerCaseMapping:0x11C5
  ,simpleTitleCaseMapping:0x11C5
 },
 { code:0x11C6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11C6
  ,simpleLowerCaseMapping:0x11C6
  ,simpleTitleCaseMapping:0x11C6
 },
 { code:0x11C7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11C7
  ,simpleLowerCaseMapping:0x11C7
  ,simpleTitleCaseMapping:0x11C7
 },
 { code:0x11C8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11C8
  ,simpleLowerCaseMapping:0x11C8
  ,simpleTitleCaseMapping:0x11C8
 },
 { code:0x11C9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11C9
  ,simpleLowerCaseMapping:0x11C9
  ,simpleTitleCaseMapping:0x11C9
 },
 { code:0x11CA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11CA
  ,simpleLowerCaseMapping:0x11CA
  ,simpleTitleCaseMapping:0x11CA
 },
 { code:0x11CB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11CB
  ,simpleLowerCaseMapping:0x11CB
  ,simpleTitleCaseMapping:0x11CB
 },
 { code:0x11CC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11CC
  ,simpleLowerCaseMapping:0x11CC
  ,simpleTitleCaseMapping:0x11CC
 },
 { code:0x11CD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11CD
  ,simpleLowerCaseMapping:0x11CD
  ,simpleTitleCaseMapping:0x11CD
 },
 { code:0x11CE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11CE
  ,simpleLowerCaseMapping:0x11CE
  ,simpleTitleCaseMapping:0x11CE
 },
 { code:0x11CF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11CF
  ,simpleLowerCaseMapping:0x11CF
  ,simpleTitleCaseMapping:0x11CF
 },
 { code:0x11D0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11D0
  ,simpleLowerCaseMapping:0x11D0
  ,simpleTitleCaseMapping:0x11D0
 },
 { code:0x11D1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11D1
  ,simpleLowerCaseMapping:0x11D1
  ,simpleTitleCaseMapping:0x11D1
 },
 { code:0x11D2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11D2
  ,simpleLowerCaseMapping:0x11D2
  ,simpleTitleCaseMapping:0x11D2
 },
 { code:0x11D3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11D3
  ,simpleLowerCaseMapping:0x11D3
  ,simpleTitleCaseMapping:0x11D3
 },
 { code:0x11D4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11D4
  ,simpleLowerCaseMapping:0x11D4
  ,simpleTitleCaseMapping:0x11D4
 },
 { code:0x11D5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11D5
  ,simpleLowerCaseMapping:0x11D5
  ,simpleTitleCaseMapping:0x11D5
 },
 { code:0x11D6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11D6
  ,simpleLowerCaseMapping:0x11D6
  ,simpleTitleCaseMapping:0x11D6
 },
 { code:0x11D7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11D7
  ,simpleLowerCaseMapping:0x11D7
  ,simpleTitleCaseMapping:0x11D7
 },
 { code:0x11D8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11D8
  ,simpleLowerCaseMapping:0x11D8
  ,simpleTitleCaseMapping:0x11D8
 },
 { code:0x11D9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11D9
  ,simpleLowerCaseMapping:0x11D9
  ,simpleTitleCaseMapping:0x11D9
 },
 { code:0x11DA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11DA
  ,simpleLowerCaseMapping:0x11DA
  ,simpleTitleCaseMapping:0x11DA
 },
 { code:0x11DB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11DB
  ,simpleLowerCaseMapping:0x11DB
  ,simpleTitleCaseMapping:0x11DB
 },
 { code:0x11DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11DC
  ,simpleLowerCaseMapping:0x11DC
  ,simpleTitleCaseMapping:0x11DC
 },
 { code:0x11DD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11DD
  ,simpleLowerCaseMapping:0x11DD
  ,simpleTitleCaseMapping:0x11DD
 },
 { code:0x11DE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11DE
  ,simpleLowerCaseMapping:0x11DE
  ,simpleTitleCaseMapping:0x11DE
 },
 { code:0x11DF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11DF
  ,simpleLowerCaseMapping:0x11DF
  ,simpleTitleCaseMapping:0x11DF
 },
 { code:0x11E0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11E0
  ,simpleLowerCaseMapping:0x11E0
  ,simpleTitleCaseMapping:0x11E0
 },
 { code:0x11E1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11E1
  ,simpleLowerCaseMapping:0x11E1
  ,simpleTitleCaseMapping:0x11E1
 },
 { code:0x11E2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11E2
  ,simpleLowerCaseMapping:0x11E2
  ,simpleTitleCaseMapping:0x11E2
 },
 { code:0x11E3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11E3
  ,simpleLowerCaseMapping:0x11E3
  ,simpleTitleCaseMapping:0x11E3
 },
 { code:0x11E4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11E4
  ,simpleLowerCaseMapping:0x11E4
  ,simpleTitleCaseMapping:0x11E4
 },
 { code:0x11E5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11E5
  ,simpleLowerCaseMapping:0x11E5
  ,simpleTitleCaseMapping:0x11E5
 },
 { code:0x11E6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11E6
  ,simpleLowerCaseMapping:0x11E6
  ,simpleTitleCaseMapping:0x11E6
 },
 { code:0x11E7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11E7
  ,simpleLowerCaseMapping:0x11E7
  ,simpleTitleCaseMapping:0x11E7
 },
 { code:0x11E8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11E8
  ,simpleLowerCaseMapping:0x11E8
  ,simpleTitleCaseMapping:0x11E8
 },
 { code:0x11E9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11E9
  ,simpleLowerCaseMapping:0x11E9
  ,simpleTitleCaseMapping:0x11E9
 },
 { code:0x11EA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11EA
  ,simpleLowerCaseMapping:0x11EA
  ,simpleTitleCaseMapping:0x11EA
 },
 { code:0x11EB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11EB
  ,simpleLowerCaseMapping:0x11EB
  ,simpleTitleCaseMapping:0x11EB
 },
 { code:0x11EC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11EC
  ,simpleLowerCaseMapping:0x11EC
  ,simpleTitleCaseMapping:0x11EC
 },
 { code:0x11ED
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11ED
  ,simpleLowerCaseMapping:0x11ED
  ,simpleTitleCaseMapping:0x11ED
 },
 { code:0x11EE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11EE
  ,simpleLowerCaseMapping:0x11EE
  ,simpleTitleCaseMapping:0x11EE
 },
 { code:0x11EF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11EF
  ,simpleLowerCaseMapping:0x11EF
  ,simpleTitleCaseMapping:0x11EF
 },
 { code:0x11F0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11F0
  ,simpleLowerCaseMapping:0x11F0
  ,simpleTitleCaseMapping:0x11F0
 },
 { code:0x11F1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11F1
  ,simpleLowerCaseMapping:0x11F1
  ,simpleTitleCaseMapping:0x11F1
 },
 { code:0x11F2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11F2
  ,simpleLowerCaseMapping:0x11F2
  ,simpleTitleCaseMapping:0x11F2
 },
 { code:0x11F3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11F3
  ,simpleLowerCaseMapping:0x11F3
  ,simpleTitleCaseMapping:0x11F3
 },
 { code:0x11F4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11F4
  ,simpleLowerCaseMapping:0x11F4
  ,simpleTitleCaseMapping:0x11F4
 },
 { code:0x11F5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11F5
  ,simpleLowerCaseMapping:0x11F5
  ,simpleTitleCaseMapping:0x11F5
 },
 { code:0x11F6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11F6
  ,simpleLowerCaseMapping:0x11F6
  ,simpleTitleCaseMapping:0x11F6
 },
 { code:0x11F7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11F7
  ,simpleLowerCaseMapping:0x11F7
  ,simpleTitleCaseMapping:0x11F7
 },
 { code:0x11F8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11F8
  ,simpleLowerCaseMapping:0x11F8
  ,simpleTitleCaseMapping:0x11F8
 },
 { code:0x11F9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x11F9
  ,simpleLowerCaseMapping:0x11F9
  ,simpleTitleCaseMapping:0x11F9
 },
 { code:0x1200
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1200
  ,simpleLowerCaseMapping:0x1200
  ,simpleTitleCaseMapping:0x1200
 },
 { code:0x1201
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1201
  ,simpleLowerCaseMapping:0x1201
  ,simpleTitleCaseMapping:0x1201
 },
 { code:0x1202
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1202
  ,simpleLowerCaseMapping:0x1202
  ,simpleTitleCaseMapping:0x1202
 },
 { code:0x1203
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1203
  ,simpleLowerCaseMapping:0x1203
  ,simpleTitleCaseMapping:0x1203
 },
 { code:0x1204
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1204
  ,simpleLowerCaseMapping:0x1204
  ,simpleTitleCaseMapping:0x1204
 },
 { code:0x1205
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1205
  ,simpleLowerCaseMapping:0x1205
  ,simpleTitleCaseMapping:0x1205
 },
 { code:0x1206
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1206
  ,simpleLowerCaseMapping:0x1206
  ,simpleTitleCaseMapping:0x1206
 },
 { code:0x1207
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1207
  ,simpleLowerCaseMapping:0x1207
  ,simpleTitleCaseMapping:0x1207
 },
 { code:0x1208
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1208
  ,simpleLowerCaseMapping:0x1208
  ,simpleTitleCaseMapping:0x1208
 },
 { code:0x1209
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1209
  ,simpleLowerCaseMapping:0x1209
  ,simpleTitleCaseMapping:0x1209
 },
 { code:0x120A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x120A
  ,simpleLowerCaseMapping:0x120A
  ,simpleTitleCaseMapping:0x120A
 },
 { code:0x120B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x120B
  ,simpleLowerCaseMapping:0x120B
  ,simpleTitleCaseMapping:0x120B
 },
 { code:0x120C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x120C
  ,simpleLowerCaseMapping:0x120C
  ,simpleTitleCaseMapping:0x120C
 },
 { code:0x120D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x120D
  ,simpleLowerCaseMapping:0x120D
  ,simpleTitleCaseMapping:0x120D
 },
 { code:0x120E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x120E
  ,simpleLowerCaseMapping:0x120E
  ,simpleTitleCaseMapping:0x120E
 },
 { code:0x120F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x120F
  ,simpleLowerCaseMapping:0x120F
  ,simpleTitleCaseMapping:0x120F
 },
 { code:0x1210
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1210
  ,simpleLowerCaseMapping:0x1210
  ,simpleTitleCaseMapping:0x1210
 },
 { code:0x1211
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1211
  ,simpleLowerCaseMapping:0x1211
  ,simpleTitleCaseMapping:0x1211
 },
 { code:0x1212
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1212
  ,simpleLowerCaseMapping:0x1212
  ,simpleTitleCaseMapping:0x1212
 },
 { code:0x1213
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1213
  ,simpleLowerCaseMapping:0x1213
  ,simpleTitleCaseMapping:0x1213
 },
 { code:0x1214
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1214
  ,simpleLowerCaseMapping:0x1214
  ,simpleTitleCaseMapping:0x1214
 },
 { code:0x1215
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1215
  ,simpleLowerCaseMapping:0x1215
  ,simpleTitleCaseMapping:0x1215
 },
 { code:0x1216
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1216
  ,simpleLowerCaseMapping:0x1216
  ,simpleTitleCaseMapping:0x1216
 },
 { code:0x1217
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1217
  ,simpleLowerCaseMapping:0x1217
  ,simpleTitleCaseMapping:0x1217
 },
 { code:0x1218
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1218
  ,simpleLowerCaseMapping:0x1218
  ,simpleTitleCaseMapping:0x1218
 },
 { code:0x1219
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1219
  ,simpleLowerCaseMapping:0x1219
  ,simpleTitleCaseMapping:0x1219
 },
 { code:0x121A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x121A
  ,simpleLowerCaseMapping:0x121A
  ,simpleTitleCaseMapping:0x121A
 },
 { code:0x121B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x121B
  ,simpleLowerCaseMapping:0x121B
  ,simpleTitleCaseMapping:0x121B
 },
 { code:0x121C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x121C
  ,simpleLowerCaseMapping:0x121C
  ,simpleTitleCaseMapping:0x121C
 },
 { code:0x121D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x121D
  ,simpleLowerCaseMapping:0x121D
  ,simpleTitleCaseMapping:0x121D
 },
 { code:0x121E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x121E
  ,simpleLowerCaseMapping:0x121E
  ,simpleTitleCaseMapping:0x121E
 },
 { code:0x121F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x121F
  ,simpleLowerCaseMapping:0x121F
  ,simpleTitleCaseMapping:0x121F
 },
 { code:0x1220
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1220
  ,simpleLowerCaseMapping:0x1220
  ,simpleTitleCaseMapping:0x1220
 },
 { code:0x1221
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1221
  ,simpleLowerCaseMapping:0x1221
  ,simpleTitleCaseMapping:0x1221
 },
 { code:0x1222
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1222
  ,simpleLowerCaseMapping:0x1222
  ,simpleTitleCaseMapping:0x1222
 },
 { code:0x1223
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1223
  ,simpleLowerCaseMapping:0x1223
  ,simpleTitleCaseMapping:0x1223
 },
 { code:0x1224
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1224
  ,simpleLowerCaseMapping:0x1224
  ,simpleTitleCaseMapping:0x1224
 },
 { code:0x1225
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1225
  ,simpleLowerCaseMapping:0x1225
  ,simpleTitleCaseMapping:0x1225
 },
 { code:0x1226
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1226
  ,simpleLowerCaseMapping:0x1226
  ,simpleTitleCaseMapping:0x1226
 },
 { code:0x1227
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1227
  ,simpleLowerCaseMapping:0x1227
  ,simpleTitleCaseMapping:0x1227
 },
 { code:0x1228
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1228
  ,simpleLowerCaseMapping:0x1228
  ,simpleTitleCaseMapping:0x1228
 },
 { code:0x1229
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1229
  ,simpleLowerCaseMapping:0x1229
  ,simpleTitleCaseMapping:0x1229
 },
 { code:0x122A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x122A
  ,simpleLowerCaseMapping:0x122A
  ,simpleTitleCaseMapping:0x122A
 },
 { code:0x122B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x122B
  ,simpleLowerCaseMapping:0x122B
  ,simpleTitleCaseMapping:0x122B
 },
 { code:0x122C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x122C
  ,simpleLowerCaseMapping:0x122C
  ,simpleTitleCaseMapping:0x122C
 },
 { code:0x122D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x122D
  ,simpleLowerCaseMapping:0x122D
  ,simpleTitleCaseMapping:0x122D
 },
 { code:0x122E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x122E
  ,simpleLowerCaseMapping:0x122E
  ,simpleTitleCaseMapping:0x122E
 },
 { code:0x122F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x122F
  ,simpleLowerCaseMapping:0x122F
  ,simpleTitleCaseMapping:0x122F
 },
 { code:0x1230
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1230
  ,simpleLowerCaseMapping:0x1230
  ,simpleTitleCaseMapping:0x1230
 },
 { code:0x1231
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1231
  ,simpleLowerCaseMapping:0x1231
  ,simpleTitleCaseMapping:0x1231
 },
 { code:0x1232
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1232
  ,simpleLowerCaseMapping:0x1232
  ,simpleTitleCaseMapping:0x1232
 },
 { code:0x1233
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1233
  ,simpleLowerCaseMapping:0x1233
  ,simpleTitleCaseMapping:0x1233
 },
 { code:0x1234
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1234
  ,simpleLowerCaseMapping:0x1234
  ,simpleTitleCaseMapping:0x1234
 },
 { code:0x1235
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1235
  ,simpleLowerCaseMapping:0x1235
  ,simpleTitleCaseMapping:0x1235
 },
 { code:0x1236
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1236
  ,simpleLowerCaseMapping:0x1236
  ,simpleTitleCaseMapping:0x1236
 },
 { code:0x1237
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1237
  ,simpleLowerCaseMapping:0x1237
  ,simpleTitleCaseMapping:0x1237
 },
 { code:0x1238
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1238
  ,simpleLowerCaseMapping:0x1238
  ,simpleTitleCaseMapping:0x1238
 },
 { code:0x1239
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1239
  ,simpleLowerCaseMapping:0x1239
  ,simpleTitleCaseMapping:0x1239
 },
 { code:0x123A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x123A
  ,simpleLowerCaseMapping:0x123A
  ,simpleTitleCaseMapping:0x123A
 },
 { code:0x123B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x123B
  ,simpleLowerCaseMapping:0x123B
  ,simpleTitleCaseMapping:0x123B
 },
 { code:0x123C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x123C
  ,simpleLowerCaseMapping:0x123C
  ,simpleTitleCaseMapping:0x123C
 },
 { code:0x123D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x123D
  ,simpleLowerCaseMapping:0x123D
  ,simpleTitleCaseMapping:0x123D
 },
 { code:0x123E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x123E
  ,simpleLowerCaseMapping:0x123E
  ,simpleTitleCaseMapping:0x123E
 },
 { code:0x123F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x123F
  ,simpleLowerCaseMapping:0x123F
  ,simpleTitleCaseMapping:0x123F
 },
 { code:0x1240
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1240
  ,simpleLowerCaseMapping:0x1240
  ,simpleTitleCaseMapping:0x1240
 },
 { code:0x1241
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1241
  ,simpleLowerCaseMapping:0x1241
  ,simpleTitleCaseMapping:0x1241
 },
 { code:0x1242
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1242
  ,simpleLowerCaseMapping:0x1242
  ,simpleTitleCaseMapping:0x1242
 },
 { code:0x1243
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1243
  ,simpleLowerCaseMapping:0x1243
  ,simpleTitleCaseMapping:0x1243
 },
 { code:0x1244
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1244
  ,simpleLowerCaseMapping:0x1244
  ,simpleTitleCaseMapping:0x1244
 },
 { code:0x1245
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1245
  ,simpleLowerCaseMapping:0x1245
  ,simpleTitleCaseMapping:0x1245
 },
 { code:0x1246
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1246
  ,simpleLowerCaseMapping:0x1246
  ,simpleTitleCaseMapping:0x1246
 },
 { code:0x1247
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1247
  ,simpleLowerCaseMapping:0x1247
  ,simpleTitleCaseMapping:0x1247
 },
 { code:0x1248
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1248
  ,simpleLowerCaseMapping:0x1248
  ,simpleTitleCaseMapping:0x1248
 },
 { code:0x124A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x124A
  ,simpleLowerCaseMapping:0x124A
  ,simpleTitleCaseMapping:0x124A
 },
 { code:0x124B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x124B
  ,simpleLowerCaseMapping:0x124B
  ,simpleTitleCaseMapping:0x124B
 },
 { code:0x124C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x124C
  ,simpleLowerCaseMapping:0x124C
  ,simpleTitleCaseMapping:0x124C
 },
 { code:0x124D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x124D
  ,simpleLowerCaseMapping:0x124D
  ,simpleTitleCaseMapping:0x124D
 },
 { code:0x1250
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1250
  ,simpleLowerCaseMapping:0x1250
  ,simpleTitleCaseMapping:0x1250
 },
 { code:0x1251
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1251
  ,simpleLowerCaseMapping:0x1251
  ,simpleTitleCaseMapping:0x1251
 },
 { code:0x1252
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1252
  ,simpleLowerCaseMapping:0x1252
  ,simpleTitleCaseMapping:0x1252
 },
 { code:0x1253
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1253
  ,simpleLowerCaseMapping:0x1253
  ,simpleTitleCaseMapping:0x1253
 },
 { code:0x1254
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1254
  ,simpleLowerCaseMapping:0x1254
  ,simpleTitleCaseMapping:0x1254
 },
 { code:0x1255
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1255
  ,simpleLowerCaseMapping:0x1255
  ,simpleTitleCaseMapping:0x1255
 },
 { code:0x1256
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1256
  ,simpleLowerCaseMapping:0x1256
  ,simpleTitleCaseMapping:0x1256
 },
 { code:0x1258
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1258
  ,simpleLowerCaseMapping:0x1258
  ,simpleTitleCaseMapping:0x1258
 },
 { code:0x125A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x125A
  ,simpleLowerCaseMapping:0x125A
  ,simpleTitleCaseMapping:0x125A
 },
 { code:0x125B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x125B
  ,simpleLowerCaseMapping:0x125B
  ,simpleTitleCaseMapping:0x125B
 },
 { code:0x125C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x125C
  ,simpleLowerCaseMapping:0x125C
  ,simpleTitleCaseMapping:0x125C
 },
 { code:0x125D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x125D
  ,simpleLowerCaseMapping:0x125D
  ,simpleTitleCaseMapping:0x125D
 },
 { code:0x1260
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1260
  ,simpleLowerCaseMapping:0x1260
  ,simpleTitleCaseMapping:0x1260
 },
 { code:0x1261
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1261
  ,simpleLowerCaseMapping:0x1261
  ,simpleTitleCaseMapping:0x1261
 },
 { code:0x1262
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1262
  ,simpleLowerCaseMapping:0x1262
  ,simpleTitleCaseMapping:0x1262
 },
 { code:0x1263
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1263
  ,simpleLowerCaseMapping:0x1263
  ,simpleTitleCaseMapping:0x1263
 },
 { code:0x1264
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1264
  ,simpleLowerCaseMapping:0x1264
  ,simpleTitleCaseMapping:0x1264
 },
 { code:0x1265
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1265
  ,simpleLowerCaseMapping:0x1265
  ,simpleTitleCaseMapping:0x1265
 },
 { code:0x1266
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1266
  ,simpleLowerCaseMapping:0x1266
  ,simpleTitleCaseMapping:0x1266
 },
 { code:0x1267
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1267
  ,simpleLowerCaseMapping:0x1267
  ,simpleTitleCaseMapping:0x1267
 },
 { code:0x1268
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1268
  ,simpleLowerCaseMapping:0x1268
  ,simpleTitleCaseMapping:0x1268
 },
 { code:0x1269
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1269
  ,simpleLowerCaseMapping:0x1269
  ,simpleTitleCaseMapping:0x1269
 },
 { code:0x126A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x126A
  ,simpleLowerCaseMapping:0x126A
  ,simpleTitleCaseMapping:0x126A
 },
 { code:0x126B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x126B
  ,simpleLowerCaseMapping:0x126B
  ,simpleTitleCaseMapping:0x126B
 },
 { code:0x126C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x126C
  ,simpleLowerCaseMapping:0x126C
  ,simpleTitleCaseMapping:0x126C
 },
 { code:0x126D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x126D
  ,simpleLowerCaseMapping:0x126D
  ,simpleTitleCaseMapping:0x126D
 },
 { code:0x126E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x126E
  ,simpleLowerCaseMapping:0x126E
  ,simpleTitleCaseMapping:0x126E
 },
 { code:0x126F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x126F
  ,simpleLowerCaseMapping:0x126F
  ,simpleTitleCaseMapping:0x126F
 },
 { code:0x1270
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1270
  ,simpleLowerCaseMapping:0x1270
  ,simpleTitleCaseMapping:0x1270
 },
 { code:0x1271
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1271
  ,simpleLowerCaseMapping:0x1271
  ,simpleTitleCaseMapping:0x1271
 },
 { code:0x1272
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1272
  ,simpleLowerCaseMapping:0x1272
  ,simpleTitleCaseMapping:0x1272
 },
 { code:0x1273
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1273
  ,simpleLowerCaseMapping:0x1273
  ,simpleTitleCaseMapping:0x1273
 },
 { code:0x1274
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1274
  ,simpleLowerCaseMapping:0x1274
  ,simpleTitleCaseMapping:0x1274
 },
 { code:0x1275
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1275
  ,simpleLowerCaseMapping:0x1275
  ,simpleTitleCaseMapping:0x1275
 },
 { code:0x1276
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1276
  ,simpleLowerCaseMapping:0x1276
  ,simpleTitleCaseMapping:0x1276
 },
 { code:0x1277
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1277
  ,simpleLowerCaseMapping:0x1277
  ,simpleTitleCaseMapping:0x1277
 },
 { code:0x1278
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1278
  ,simpleLowerCaseMapping:0x1278
  ,simpleTitleCaseMapping:0x1278
 },
 { code:0x1279
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1279
  ,simpleLowerCaseMapping:0x1279
  ,simpleTitleCaseMapping:0x1279
 },
 { code:0x127A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x127A
  ,simpleLowerCaseMapping:0x127A
  ,simpleTitleCaseMapping:0x127A
 },
 { code:0x127B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x127B
  ,simpleLowerCaseMapping:0x127B
  ,simpleTitleCaseMapping:0x127B
 },
 { code:0x127C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x127C
  ,simpleLowerCaseMapping:0x127C
  ,simpleTitleCaseMapping:0x127C
 },
 { code:0x127D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x127D
  ,simpleLowerCaseMapping:0x127D
  ,simpleTitleCaseMapping:0x127D
 },
 { code:0x127E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x127E
  ,simpleLowerCaseMapping:0x127E
  ,simpleTitleCaseMapping:0x127E
 },
 { code:0x127F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x127F
  ,simpleLowerCaseMapping:0x127F
  ,simpleTitleCaseMapping:0x127F
 },
 { code:0x1280
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1280
  ,simpleLowerCaseMapping:0x1280
  ,simpleTitleCaseMapping:0x1280
 },
 { code:0x1281
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1281
  ,simpleLowerCaseMapping:0x1281
  ,simpleTitleCaseMapping:0x1281
 },
 { code:0x1282
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1282
  ,simpleLowerCaseMapping:0x1282
  ,simpleTitleCaseMapping:0x1282
 },
 { code:0x1283
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1283
  ,simpleLowerCaseMapping:0x1283
  ,simpleTitleCaseMapping:0x1283
 },
 { code:0x1284
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1284
  ,simpleLowerCaseMapping:0x1284
  ,simpleTitleCaseMapping:0x1284
 },
 { code:0x1285
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1285
  ,simpleLowerCaseMapping:0x1285
  ,simpleTitleCaseMapping:0x1285
 },
 { code:0x1286
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1286
  ,simpleLowerCaseMapping:0x1286
  ,simpleTitleCaseMapping:0x1286
 },
 { code:0x1287
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1287
  ,simpleLowerCaseMapping:0x1287
  ,simpleTitleCaseMapping:0x1287
 },
 { code:0x1288
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1288
  ,simpleLowerCaseMapping:0x1288
  ,simpleTitleCaseMapping:0x1288
 },
 { code:0x128A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x128A
  ,simpleLowerCaseMapping:0x128A
  ,simpleTitleCaseMapping:0x128A
 },
 { code:0x128B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x128B
  ,simpleLowerCaseMapping:0x128B
  ,simpleTitleCaseMapping:0x128B
 },
 { code:0x128C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x128C
  ,simpleLowerCaseMapping:0x128C
  ,simpleTitleCaseMapping:0x128C
 },
 { code:0x128D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x128D
  ,simpleLowerCaseMapping:0x128D
  ,simpleTitleCaseMapping:0x128D
 },
 { code:0x1290
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1290
  ,simpleLowerCaseMapping:0x1290
  ,simpleTitleCaseMapping:0x1290
 },
 { code:0x1291
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1291
  ,simpleLowerCaseMapping:0x1291
  ,simpleTitleCaseMapping:0x1291
 },
 { code:0x1292
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1292
  ,simpleLowerCaseMapping:0x1292
  ,simpleTitleCaseMapping:0x1292
 },
 { code:0x1293
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1293
  ,simpleLowerCaseMapping:0x1293
  ,simpleTitleCaseMapping:0x1293
 },
 { code:0x1294
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1294
  ,simpleLowerCaseMapping:0x1294
  ,simpleTitleCaseMapping:0x1294
 },
 { code:0x1295
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1295
  ,simpleLowerCaseMapping:0x1295
  ,simpleTitleCaseMapping:0x1295
 },
 { code:0x1296
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1296
  ,simpleLowerCaseMapping:0x1296
  ,simpleTitleCaseMapping:0x1296
 },
 { code:0x1297
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1297
  ,simpleLowerCaseMapping:0x1297
  ,simpleTitleCaseMapping:0x1297
 },
 { code:0x1298
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1298
  ,simpleLowerCaseMapping:0x1298
  ,simpleTitleCaseMapping:0x1298
 },
 { code:0x1299
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1299
  ,simpleLowerCaseMapping:0x1299
  ,simpleTitleCaseMapping:0x1299
 },
 { code:0x129A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x129A
  ,simpleLowerCaseMapping:0x129A
  ,simpleTitleCaseMapping:0x129A
 },
 { code:0x129B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x129B
  ,simpleLowerCaseMapping:0x129B
  ,simpleTitleCaseMapping:0x129B
 },
 { code:0x129C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x129C
  ,simpleLowerCaseMapping:0x129C
  ,simpleTitleCaseMapping:0x129C
 },
 { code:0x129D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x129D
  ,simpleLowerCaseMapping:0x129D
  ,simpleTitleCaseMapping:0x129D
 },
 { code:0x129E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x129E
  ,simpleLowerCaseMapping:0x129E
  ,simpleTitleCaseMapping:0x129E
 },
 { code:0x129F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x129F
  ,simpleLowerCaseMapping:0x129F
  ,simpleTitleCaseMapping:0x129F
 },
 { code:0x12A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12A0
  ,simpleLowerCaseMapping:0x12A0
  ,simpleTitleCaseMapping:0x12A0
 },
 { code:0x12A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12A1
  ,simpleLowerCaseMapping:0x12A1
  ,simpleTitleCaseMapping:0x12A1
 },
 { code:0x12A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12A2
  ,simpleLowerCaseMapping:0x12A2
  ,simpleTitleCaseMapping:0x12A2
 },
 { code:0x12A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12A3
  ,simpleLowerCaseMapping:0x12A3
  ,simpleTitleCaseMapping:0x12A3
 },
 { code:0x12A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12A4
  ,simpleLowerCaseMapping:0x12A4
  ,simpleTitleCaseMapping:0x12A4
 },
 { code:0x12A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12A5
  ,simpleLowerCaseMapping:0x12A5
  ,simpleTitleCaseMapping:0x12A5
 },
 { code:0x12A6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12A6
  ,simpleLowerCaseMapping:0x12A6
  ,simpleTitleCaseMapping:0x12A6
 },
 { code:0x12A7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12A7
  ,simpleLowerCaseMapping:0x12A7
  ,simpleTitleCaseMapping:0x12A7
 },
 { code:0x12A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12A8
  ,simpleLowerCaseMapping:0x12A8
  ,simpleTitleCaseMapping:0x12A8
 },
 { code:0x12A9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12A9
  ,simpleLowerCaseMapping:0x12A9
  ,simpleTitleCaseMapping:0x12A9
 },
 { code:0x12AA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12AA
  ,simpleLowerCaseMapping:0x12AA
  ,simpleTitleCaseMapping:0x12AA
 },
 { code:0x12AB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12AB
  ,simpleLowerCaseMapping:0x12AB
  ,simpleTitleCaseMapping:0x12AB
 },
 { code:0x12AC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12AC
  ,simpleLowerCaseMapping:0x12AC
  ,simpleTitleCaseMapping:0x12AC
 },
 { code:0x12AD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12AD
  ,simpleLowerCaseMapping:0x12AD
  ,simpleTitleCaseMapping:0x12AD
 },
 { code:0x12AE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12AE
  ,simpleLowerCaseMapping:0x12AE
  ,simpleTitleCaseMapping:0x12AE
 },
 { code:0x12AF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12AF
  ,simpleLowerCaseMapping:0x12AF
  ,simpleTitleCaseMapping:0x12AF
 },
 { code:0x12B0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12B0
  ,simpleLowerCaseMapping:0x12B0
  ,simpleTitleCaseMapping:0x12B0
 },
 { code:0x12B2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12B2
  ,simpleLowerCaseMapping:0x12B2
  ,simpleTitleCaseMapping:0x12B2
 },
 { code:0x12B3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12B3
  ,simpleLowerCaseMapping:0x12B3
  ,simpleTitleCaseMapping:0x12B3
 },
 { code:0x12B4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12B4
  ,simpleLowerCaseMapping:0x12B4
  ,simpleTitleCaseMapping:0x12B4
 },
 { code:0x12B5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12B5
  ,simpleLowerCaseMapping:0x12B5
  ,simpleTitleCaseMapping:0x12B5
 },
 { code:0x12B8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12B8
  ,simpleLowerCaseMapping:0x12B8
  ,simpleTitleCaseMapping:0x12B8
 },
 { code:0x12B9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12B9
  ,simpleLowerCaseMapping:0x12B9
  ,simpleTitleCaseMapping:0x12B9
 },
 { code:0x12BA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12BA
  ,simpleLowerCaseMapping:0x12BA
  ,simpleTitleCaseMapping:0x12BA
 },
 { code:0x12BB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12BB
  ,simpleLowerCaseMapping:0x12BB
  ,simpleTitleCaseMapping:0x12BB
 },
 { code:0x12BC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12BC
  ,simpleLowerCaseMapping:0x12BC
  ,simpleTitleCaseMapping:0x12BC
 },
 { code:0x12BD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12BD
  ,simpleLowerCaseMapping:0x12BD
  ,simpleTitleCaseMapping:0x12BD
 },
 { code:0x12BE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12BE
  ,simpleLowerCaseMapping:0x12BE
  ,simpleTitleCaseMapping:0x12BE
 },
 { code:0x12C0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12C0
  ,simpleLowerCaseMapping:0x12C0
  ,simpleTitleCaseMapping:0x12C0
 },
 { code:0x12C2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12C2
  ,simpleLowerCaseMapping:0x12C2
  ,simpleTitleCaseMapping:0x12C2
 },
 { code:0x12C3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12C3
  ,simpleLowerCaseMapping:0x12C3
  ,simpleTitleCaseMapping:0x12C3
 },
 { code:0x12C4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12C4
  ,simpleLowerCaseMapping:0x12C4
  ,simpleTitleCaseMapping:0x12C4
 },
 { code:0x12C5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12C5
  ,simpleLowerCaseMapping:0x12C5
  ,simpleTitleCaseMapping:0x12C5
 },
 { code:0x12C8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12C8
  ,simpleLowerCaseMapping:0x12C8
  ,simpleTitleCaseMapping:0x12C8
 },
 { code:0x12C9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12C9
  ,simpleLowerCaseMapping:0x12C9
  ,simpleTitleCaseMapping:0x12C9
 },
 { code:0x12CA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12CA
  ,simpleLowerCaseMapping:0x12CA
  ,simpleTitleCaseMapping:0x12CA
 },
 { code:0x12CB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12CB
  ,simpleLowerCaseMapping:0x12CB
  ,simpleTitleCaseMapping:0x12CB
 },
 { code:0x12CC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12CC
  ,simpleLowerCaseMapping:0x12CC
  ,simpleTitleCaseMapping:0x12CC
 },
 { code:0x12CD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12CD
  ,simpleLowerCaseMapping:0x12CD
  ,simpleTitleCaseMapping:0x12CD
 },
 { code:0x12CE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12CE
  ,simpleLowerCaseMapping:0x12CE
  ,simpleTitleCaseMapping:0x12CE
 },
 { code:0x12CF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12CF
  ,simpleLowerCaseMapping:0x12CF
  ,simpleTitleCaseMapping:0x12CF
 },
 { code:0x12D0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12D0
  ,simpleLowerCaseMapping:0x12D0
  ,simpleTitleCaseMapping:0x12D0
 },
 { code:0x12D1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12D1
  ,simpleLowerCaseMapping:0x12D1
  ,simpleTitleCaseMapping:0x12D1
 },
 { code:0x12D2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12D2
  ,simpleLowerCaseMapping:0x12D2
  ,simpleTitleCaseMapping:0x12D2
 },
 { code:0x12D3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12D3
  ,simpleLowerCaseMapping:0x12D3
  ,simpleTitleCaseMapping:0x12D3
 },
 { code:0x12D4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12D4
  ,simpleLowerCaseMapping:0x12D4
  ,simpleTitleCaseMapping:0x12D4
 },
 { code:0x12D5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12D5
  ,simpleLowerCaseMapping:0x12D5
  ,simpleTitleCaseMapping:0x12D5
 },
 { code:0x12D6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12D6
  ,simpleLowerCaseMapping:0x12D6
  ,simpleTitleCaseMapping:0x12D6
 },
 { code:0x12D8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12D8
  ,simpleLowerCaseMapping:0x12D8
  ,simpleTitleCaseMapping:0x12D8
 },
 { code:0x12D9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12D9
  ,simpleLowerCaseMapping:0x12D9
  ,simpleTitleCaseMapping:0x12D9
 },
 { code:0x12DA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12DA
  ,simpleLowerCaseMapping:0x12DA
  ,simpleTitleCaseMapping:0x12DA
 },
 { code:0x12DB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12DB
  ,simpleLowerCaseMapping:0x12DB
  ,simpleTitleCaseMapping:0x12DB
 },
 { code:0x12DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12DC
  ,simpleLowerCaseMapping:0x12DC
  ,simpleTitleCaseMapping:0x12DC
 },
 { code:0x12DD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12DD
  ,simpleLowerCaseMapping:0x12DD
  ,simpleTitleCaseMapping:0x12DD
 },
 { code:0x12DE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12DE
  ,simpleLowerCaseMapping:0x12DE
  ,simpleTitleCaseMapping:0x12DE
 },
 { code:0x12DF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12DF
  ,simpleLowerCaseMapping:0x12DF
  ,simpleTitleCaseMapping:0x12DF
 },
 { code:0x12E0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12E0
  ,simpleLowerCaseMapping:0x12E0
  ,simpleTitleCaseMapping:0x12E0
 },
 { code:0x12E1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12E1
  ,simpleLowerCaseMapping:0x12E1
  ,simpleTitleCaseMapping:0x12E1
 },
 { code:0x12E2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12E2
  ,simpleLowerCaseMapping:0x12E2
  ,simpleTitleCaseMapping:0x12E2
 },
 { code:0x12E3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12E3
  ,simpleLowerCaseMapping:0x12E3
  ,simpleTitleCaseMapping:0x12E3
 },
 { code:0x12E4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12E4
  ,simpleLowerCaseMapping:0x12E4
  ,simpleTitleCaseMapping:0x12E4
 },
 { code:0x12E5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12E5
  ,simpleLowerCaseMapping:0x12E5
  ,simpleTitleCaseMapping:0x12E5
 },
 { code:0x12E6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12E6
  ,simpleLowerCaseMapping:0x12E6
  ,simpleTitleCaseMapping:0x12E6
 },
 { code:0x12E7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12E7
  ,simpleLowerCaseMapping:0x12E7
  ,simpleTitleCaseMapping:0x12E7
 },
 { code:0x12E8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12E8
  ,simpleLowerCaseMapping:0x12E8
  ,simpleTitleCaseMapping:0x12E8
 },
 { code:0x12E9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12E9
  ,simpleLowerCaseMapping:0x12E9
  ,simpleTitleCaseMapping:0x12E9
 },
 { code:0x12EA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12EA
  ,simpleLowerCaseMapping:0x12EA
  ,simpleTitleCaseMapping:0x12EA
 },
 { code:0x12EB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12EB
  ,simpleLowerCaseMapping:0x12EB
  ,simpleTitleCaseMapping:0x12EB
 },
 { code:0x12EC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12EC
  ,simpleLowerCaseMapping:0x12EC
  ,simpleTitleCaseMapping:0x12EC
 },
 { code:0x12ED
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12ED
  ,simpleLowerCaseMapping:0x12ED
  ,simpleTitleCaseMapping:0x12ED
 },
 { code:0x12EE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12EE
  ,simpleLowerCaseMapping:0x12EE
  ,simpleTitleCaseMapping:0x12EE
 },
 { code:0x12EF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12EF
  ,simpleLowerCaseMapping:0x12EF
  ,simpleTitleCaseMapping:0x12EF
 },
 { code:0x12F0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12F0
  ,simpleLowerCaseMapping:0x12F0
  ,simpleTitleCaseMapping:0x12F0
 },
 { code:0x12F1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12F1
  ,simpleLowerCaseMapping:0x12F1
  ,simpleTitleCaseMapping:0x12F1
 },
 { code:0x12F2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12F2
  ,simpleLowerCaseMapping:0x12F2
  ,simpleTitleCaseMapping:0x12F2
 },
 { code:0x12F3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12F3
  ,simpleLowerCaseMapping:0x12F3
  ,simpleTitleCaseMapping:0x12F3
 },
 { code:0x12F4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12F4
  ,simpleLowerCaseMapping:0x12F4
  ,simpleTitleCaseMapping:0x12F4
 },
 { code:0x12F5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12F5
  ,simpleLowerCaseMapping:0x12F5
  ,simpleTitleCaseMapping:0x12F5
 },
 { code:0x12F6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12F6
  ,simpleLowerCaseMapping:0x12F6
  ,simpleTitleCaseMapping:0x12F6
 },
 { code:0x12F7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12F7
  ,simpleLowerCaseMapping:0x12F7
  ,simpleTitleCaseMapping:0x12F7
 },
 { code:0x12F8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12F8
  ,simpleLowerCaseMapping:0x12F8
  ,simpleTitleCaseMapping:0x12F8
 },
 { code:0x12F9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12F9
  ,simpleLowerCaseMapping:0x12F9
  ,simpleTitleCaseMapping:0x12F9
 },
 { code:0x12FA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12FA
  ,simpleLowerCaseMapping:0x12FA
  ,simpleTitleCaseMapping:0x12FA
 },
 { code:0x12FB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12FB
  ,simpleLowerCaseMapping:0x12FB
  ,simpleTitleCaseMapping:0x12FB
 },
 { code:0x12FC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12FC
  ,simpleLowerCaseMapping:0x12FC
  ,simpleTitleCaseMapping:0x12FC
 },
 { code:0x12FD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12FD
  ,simpleLowerCaseMapping:0x12FD
  ,simpleTitleCaseMapping:0x12FD
 },
 { code:0x12FE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12FE
  ,simpleLowerCaseMapping:0x12FE
  ,simpleTitleCaseMapping:0x12FE
 },
 { code:0x12FF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x12FF
  ,simpleLowerCaseMapping:0x12FF
  ,simpleTitleCaseMapping:0x12FF
 },
 { code:0x1300
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1300
  ,simpleLowerCaseMapping:0x1300
  ,simpleTitleCaseMapping:0x1300
 },
 { code:0x1301
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1301
  ,simpleLowerCaseMapping:0x1301
  ,simpleTitleCaseMapping:0x1301
 },
 { code:0x1302
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1302
  ,simpleLowerCaseMapping:0x1302
  ,simpleTitleCaseMapping:0x1302
 },
 { code:0x1303
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1303
  ,simpleLowerCaseMapping:0x1303
  ,simpleTitleCaseMapping:0x1303
 },
 { code:0x1304
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1304
  ,simpleLowerCaseMapping:0x1304
  ,simpleTitleCaseMapping:0x1304
 },
 { code:0x1305
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1305
  ,simpleLowerCaseMapping:0x1305
  ,simpleTitleCaseMapping:0x1305
 },
 { code:0x1306
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1306
  ,simpleLowerCaseMapping:0x1306
  ,simpleTitleCaseMapping:0x1306
 },
 { code:0x1307
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1307
  ,simpleLowerCaseMapping:0x1307
  ,simpleTitleCaseMapping:0x1307
 },
 { code:0x1308
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1308
  ,simpleLowerCaseMapping:0x1308
  ,simpleTitleCaseMapping:0x1308
 },
 { code:0x1309
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1309
  ,simpleLowerCaseMapping:0x1309
  ,simpleTitleCaseMapping:0x1309
 },
 { code:0x130A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x130A
  ,simpleLowerCaseMapping:0x130A
  ,simpleTitleCaseMapping:0x130A
 },
 { code:0x130B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x130B
  ,simpleLowerCaseMapping:0x130B
  ,simpleTitleCaseMapping:0x130B
 },
 { code:0x130C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x130C
  ,simpleLowerCaseMapping:0x130C
  ,simpleTitleCaseMapping:0x130C
 },
 { code:0x130D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x130D
  ,simpleLowerCaseMapping:0x130D
  ,simpleTitleCaseMapping:0x130D
 },
 { code:0x130E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x130E
  ,simpleLowerCaseMapping:0x130E
  ,simpleTitleCaseMapping:0x130E
 },
 { code:0x130F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x130F
  ,simpleLowerCaseMapping:0x130F
  ,simpleTitleCaseMapping:0x130F
 },
 { code:0x1310
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1310
  ,simpleLowerCaseMapping:0x1310
  ,simpleTitleCaseMapping:0x1310
 },
 { code:0x1312
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1312
  ,simpleLowerCaseMapping:0x1312
  ,simpleTitleCaseMapping:0x1312
 },
 { code:0x1313
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1313
  ,simpleLowerCaseMapping:0x1313
  ,simpleTitleCaseMapping:0x1313
 },
 { code:0x1314
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1314
  ,simpleLowerCaseMapping:0x1314
  ,simpleTitleCaseMapping:0x1314
 },
 { code:0x1315
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1315
  ,simpleLowerCaseMapping:0x1315
  ,simpleTitleCaseMapping:0x1315
 },
 { code:0x1318
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1318
  ,simpleLowerCaseMapping:0x1318
  ,simpleTitleCaseMapping:0x1318
 },
 { code:0x1319
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1319
  ,simpleLowerCaseMapping:0x1319
  ,simpleTitleCaseMapping:0x1319
 },
 { code:0x131A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x131A
  ,simpleLowerCaseMapping:0x131A
  ,simpleTitleCaseMapping:0x131A
 },
 { code:0x131B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x131B
  ,simpleLowerCaseMapping:0x131B
  ,simpleTitleCaseMapping:0x131B
 },
 { code:0x131C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x131C
  ,simpleLowerCaseMapping:0x131C
  ,simpleTitleCaseMapping:0x131C
 },
 { code:0x131D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x131D
  ,simpleLowerCaseMapping:0x131D
  ,simpleTitleCaseMapping:0x131D
 },
 { code:0x131E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x131E
  ,simpleLowerCaseMapping:0x131E
  ,simpleTitleCaseMapping:0x131E
 },
 { code:0x131F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x131F
  ,simpleLowerCaseMapping:0x131F
  ,simpleTitleCaseMapping:0x131F
 },
 { code:0x1320
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1320
  ,simpleLowerCaseMapping:0x1320
  ,simpleTitleCaseMapping:0x1320
 },
 { code:0x1321
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1321
  ,simpleLowerCaseMapping:0x1321
  ,simpleTitleCaseMapping:0x1321
 },
 { code:0x1322
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1322
  ,simpleLowerCaseMapping:0x1322
  ,simpleTitleCaseMapping:0x1322
 },
 { code:0x1323
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1323
  ,simpleLowerCaseMapping:0x1323
  ,simpleTitleCaseMapping:0x1323
 },
 { code:0x1324
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1324
  ,simpleLowerCaseMapping:0x1324
  ,simpleTitleCaseMapping:0x1324
 },
 { code:0x1325
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1325
  ,simpleLowerCaseMapping:0x1325
  ,simpleTitleCaseMapping:0x1325
 },
 { code:0x1326
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1326
  ,simpleLowerCaseMapping:0x1326
  ,simpleTitleCaseMapping:0x1326
 },
 { code:0x1327
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1327
  ,simpleLowerCaseMapping:0x1327
  ,simpleTitleCaseMapping:0x1327
 },
 { code:0x1328
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1328
  ,simpleLowerCaseMapping:0x1328
  ,simpleTitleCaseMapping:0x1328
 },
 { code:0x1329
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1329
  ,simpleLowerCaseMapping:0x1329
  ,simpleTitleCaseMapping:0x1329
 },
 { code:0x132A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x132A
  ,simpleLowerCaseMapping:0x132A
  ,simpleTitleCaseMapping:0x132A
 },
 { code:0x132B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x132B
  ,simpleLowerCaseMapping:0x132B
  ,simpleTitleCaseMapping:0x132B
 },
 { code:0x132C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x132C
  ,simpleLowerCaseMapping:0x132C
  ,simpleTitleCaseMapping:0x132C
 },
 { code:0x132D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x132D
  ,simpleLowerCaseMapping:0x132D
  ,simpleTitleCaseMapping:0x132D
 },
 { code:0x132E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x132E
  ,simpleLowerCaseMapping:0x132E
  ,simpleTitleCaseMapping:0x132E
 },
 { code:0x132F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x132F
  ,simpleLowerCaseMapping:0x132F
  ,simpleTitleCaseMapping:0x132F
 },
 { code:0x1330
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1330
  ,simpleLowerCaseMapping:0x1330
  ,simpleTitleCaseMapping:0x1330
 },
 { code:0x1331
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1331
  ,simpleLowerCaseMapping:0x1331
  ,simpleTitleCaseMapping:0x1331
 },
 { code:0x1332
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1332
  ,simpleLowerCaseMapping:0x1332
  ,simpleTitleCaseMapping:0x1332
 },
 { code:0x1333
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1333
  ,simpleLowerCaseMapping:0x1333
  ,simpleTitleCaseMapping:0x1333
 },
 { code:0x1334
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1334
  ,simpleLowerCaseMapping:0x1334
  ,simpleTitleCaseMapping:0x1334
 },
 { code:0x1335
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1335
  ,simpleLowerCaseMapping:0x1335
  ,simpleTitleCaseMapping:0x1335
 },
 { code:0x1336
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1336
  ,simpleLowerCaseMapping:0x1336
  ,simpleTitleCaseMapping:0x1336
 },
 { code:0x1337
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1337
  ,simpleLowerCaseMapping:0x1337
  ,simpleTitleCaseMapping:0x1337
 },
 { code:0x1338
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1338
  ,simpleLowerCaseMapping:0x1338
  ,simpleTitleCaseMapping:0x1338
 },
 { code:0x1339
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1339
  ,simpleLowerCaseMapping:0x1339
  ,simpleTitleCaseMapping:0x1339
 },
 { code:0x133A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x133A
  ,simpleLowerCaseMapping:0x133A
  ,simpleTitleCaseMapping:0x133A
 },
 { code:0x133B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x133B
  ,simpleLowerCaseMapping:0x133B
  ,simpleTitleCaseMapping:0x133B
 },
 { code:0x133C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x133C
  ,simpleLowerCaseMapping:0x133C
  ,simpleTitleCaseMapping:0x133C
 },
 { code:0x133D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x133D
  ,simpleLowerCaseMapping:0x133D
  ,simpleTitleCaseMapping:0x133D
 },
 { code:0x133E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x133E
  ,simpleLowerCaseMapping:0x133E
  ,simpleTitleCaseMapping:0x133E
 },
 { code:0x133F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x133F
  ,simpleLowerCaseMapping:0x133F
  ,simpleTitleCaseMapping:0x133F
 },
 { code:0x1340
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1340
  ,simpleLowerCaseMapping:0x1340
  ,simpleTitleCaseMapping:0x1340
 },
 { code:0x1341
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1341
  ,simpleLowerCaseMapping:0x1341
  ,simpleTitleCaseMapping:0x1341
 },
 { code:0x1342
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1342
  ,simpleLowerCaseMapping:0x1342
  ,simpleTitleCaseMapping:0x1342
 },
 { code:0x1343
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1343
  ,simpleLowerCaseMapping:0x1343
  ,simpleTitleCaseMapping:0x1343
 },
 { code:0x1344
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1344
  ,simpleLowerCaseMapping:0x1344
  ,simpleTitleCaseMapping:0x1344
 },
 { code:0x1345
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1345
  ,simpleLowerCaseMapping:0x1345
  ,simpleTitleCaseMapping:0x1345
 },
 { code:0x1346
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1346
  ,simpleLowerCaseMapping:0x1346
  ,simpleTitleCaseMapping:0x1346
 },
 { code:0x1347
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1347
  ,simpleLowerCaseMapping:0x1347
  ,simpleTitleCaseMapping:0x1347
 },
 { code:0x1348
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1348
  ,simpleLowerCaseMapping:0x1348
  ,simpleTitleCaseMapping:0x1348
 },
 { code:0x1349
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1349
  ,simpleLowerCaseMapping:0x1349
  ,simpleTitleCaseMapping:0x1349
 },
 { code:0x134A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x134A
  ,simpleLowerCaseMapping:0x134A
  ,simpleTitleCaseMapping:0x134A
 },
 { code:0x134B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x134B
  ,simpleLowerCaseMapping:0x134B
  ,simpleTitleCaseMapping:0x134B
 },
 { code:0x134C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x134C
  ,simpleLowerCaseMapping:0x134C
  ,simpleTitleCaseMapping:0x134C
 },
 { code:0x134D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x134D
  ,simpleLowerCaseMapping:0x134D
  ,simpleTitleCaseMapping:0x134D
 },
 { code:0x134E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x134E
  ,simpleLowerCaseMapping:0x134E
  ,simpleTitleCaseMapping:0x134E
 },
 { code:0x134F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x134F
  ,simpleLowerCaseMapping:0x134F
  ,simpleTitleCaseMapping:0x134F
 },
 { code:0x1350
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1350
  ,simpleLowerCaseMapping:0x1350
  ,simpleTitleCaseMapping:0x1350
 },
 { code:0x1351
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1351
  ,simpleLowerCaseMapping:0x1351
  ,simpleTitleCaseMapping:0x1351
 },
 { code:0x1352
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1352
  ,simpleLowerCaseMapping:0x1352
  ,simpleTitleCaseMapping:0x1352
 },
 { code:0x1353
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1353
  ,simpleLowerCaseMapping:0x1353
  ,simpleTitleCaseMapping:0x1353
 },
 { code:0x1354
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1354
  ,simpleLowerCaseMapping:0x1354
  ,simpleTitleCaseMapping:0x1354
 },
 { code:0x1355
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1355
  ,simpleLowerCaseMapping:0x1355
  ,simpleTitleCaseMapping:0x1355
 },
 { code:0x1356
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1356
  ,simpleLowerCaseMapping:0x1356
  ,simpleTitleCaseMapping:0x1356
 },
 { code:0x1357
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1357
  ,simpleLowerCaseMapping:0x1357
  ,simpleTitleCaseMapping:0x1357
 },
 { code:0x1358
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1358
  ,simpleLowerCaseMapping:0x1358
  ,simpleTitleCaseMapping:0x1358
 },
 { code:0x1359
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1359
  ,simpleLowerCaseMapping:0x1359
  ,simpleTitleCaseMapping:0x1359
 },
 { code:0x135A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x135A
  ,simpleLowerCaseMapping:0x135A
  ,simpleTitleCaseMapping:0x135A
 },
 { code:0x135F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x135F
  ,simpleLowerCaseMapping:0x135F
  ,simpleTitleCaseMapping:0x135F
 },
 { code:0x1360
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1360
  ,simpleLowerCaseMapping:0x1360
  ,simpleTitleCaseMapping:0x1360
 },
 { code:0x1361
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1361
  ,simpleLowerCaseMapping:0x1361
  ,simpleTitleCaseMapping:0x1361
 },
 { code:0x1362
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1362
  ,simpleLowerCaseMapping:0x1362
  ,simpleTitleCaseMapping:0x1362
 },
 { code:0x1363
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1363
  ,simpleLowerCaseMapping:0x1363
  ,simpleTitleCaseMapping:0x1363
 },
 { code:0x1364
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1364
  ,simpleLowerCaseMapping:0x1364
  ,simpleTitleCaseMapping:0x1364
 },
 { code:0x1365
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1365
  ,simpleLowerCaseMapping:0x1365
  ,simpleTitleCaseMapping:0x1365
 },
 { code:0x1366
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1366
  ,simpleLowerCaseMapping:0x1366
  ,simpleTitleCaseMapping:0x1366
 },
 { code:0x1367
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1367
  ,simpleLowerCaseMapping:0x1367
  ,simpleTitleCaseMapping:0x1367
 },
 { code:0x1368
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1368
  ,simpleLowerCaseMapping:0x1368
  ,simpleTitleCaseMapping:0x1368
 },
 { code:0x1369
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1369
  ,simpleLowerCaseMapping:0x1369
  ,simpleTitleCaseMapping:0x1369
 },
 { code:0x136A
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x136A
  ,simpleLowerCaseMapping:0x136A
  ,simpleTitleCaseMapping:0x136A
 },
 { code:0x136B
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x136B
  ,simpleLowerCaseMapping:0x136B
  ,simpleTitleCaseMapping:0x136B
 },
 { code:0x136C
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x136C
  ,simpleLowerCaseMapping:0x136C
  ,simpleTitleCaseMapping:0x136C
 },
 { code:0x136D
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x136D
  ,simpleLowerCaseMapping:0x136D
  ,simpleTitleCaseMapping:0x136D
 },
 { code:0x136E
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x136E
  ,simpleLowerCaseMapping:0x136E
  ,simpleTitleCaseMapping:0x136E
 },
 { code:0x136F
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x136F
  ,simpleLowerCaseMapping:0x136F
  ,simpleTitleCaseMapping:0x136F
 },
 { code:0x1370
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1370
  ,simpleLowerCaseMapping:0x1370
  ,simpleTitleCaseMapping:0x1370
 },
 { code:0x1371
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1371
  ,simpleLowerCaseMapping:0x1371
  ,simpleTitleCaseMapping:0x1371
 },
 { code:0x1372
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1372
  ,simpleLowerCaseMapping:0x1372
  ,simpleTitleCaseMapping:0x1372
 },
 { code:0x1373
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1373
  ,simpleLowerCaseMapping:0x1373
  ,simpleTitleCaseMapping:0x1373
 },
 { code:0x1374
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1374
  ,simpleLowerCaseMapping:0x1374
  ,simpleTitleCaseMapping:0x1374
 },
 { code:0x1375
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1375
  ,simpleLowerCaseMapping:0x1375
  ,simpleTitleCaseMapping:0x1375
 },
 { code:0x1376
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1376
  ,simpleLowerCaseMapping:0x1376
  ,simpleTitleCaseMapping:0x1376
 },
 { code:0x1377
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1377
  ,simpleLowerCaseMapping:0x1377
  ,simpleTitleCaseMapping:0x1377
 },
 { code:0x1378
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1378
  ,simpleLowerCaseMapping:0x1378
  ,simpleTitleCaseMapping:0x1378
 },
 { code:0x1379
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x1379
  ,simpleLowerCaseMapping:0x1379
  ,simpleTitleCaseMapping:0x1379
 },
 { code:0x137A
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x137A
  ,simpleLowerCaseMapping:0x137A
  ,simpleTitleCaseMapping:0x137A
 },
 { code:0x137B
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x137B
  ,simpleLowerCaseMapping:0x137B
  ,simpleTitleCaseMapping:0x137B
 },
 { code:0x137C
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x137C
  ,simpleLowerCaseMapping:0x137C
  ,simpleTitleCaseMapping:0x137C
 },
 { code:0x1380
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1380
  ,simpleLowerCaseMapping:0x1380
  ,simpleTitleCaseMapping:0x1380
 },
 { code:0x1381
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1381
  ,simpleLowerCaseMapping:0x1381
  ,simpleTitleCaseMapping:0x1381
 },
 { code:0x1382
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1382
  ,simpleLowerCaseMapping:0x1382
  ,simpleTitleCaseMapping:0x1382
 },
 { code:0x1383
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1383
  ,simpleLowerCaseMapping:0x1383
  ,simpleTitleCaseMapping:0x1383
 },
 { code:0x1384
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1384
  ,simpleLowerCaseMapping:0x1384
  ,simpleTitleCaseMapping:0x1384
 },
 { code:0x1385
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1385
  ,simpleLowerCaseMapping:0x1385
  ,simpleTitleCaseMapping:0x1385
 },
 { code:0x1386
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1386
  ,simpleLowerCaseMapping:0x1386
  ,simpleTitleCaseMapping:0x1386
 },
 { code:0x1387
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1387
  ,simpleLowerCaseMapping:0x1387
  ,simpleTitleCaseMapping:0x1387
 },
 { code:0x1388
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1388
  ,simpleLowerCaseMapping:0x1388
  ,simpleTitleCaseMapping:0x1388
 },
 { code:0x1389
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1389
  ,simpleLowerCaseMapping:0x1389
  ,simpleTitleCaseMapping:0x1389
 },
 { code:0x138A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x138A
  ,simpleLowerCaseMapping:0x138A
  ,simpleTitleCaseMapping:0x138A
 },
 { code:0x138B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x138B
  ,simpleLowerCaseMapping:0x138B
  ,simpleTitleCaseMapping:0x138B
 },
 { code:0x138C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x138C
  ,simpleLowerCaseMapping:0x138C
  ,simpleTitleCaseMapping:0x138C
 },
 { code:0x138D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x138D
  ,simpleLowerCaseMapping:0x138D
  ,simpleTitleCaseMapping:0x138D
 },
 { code:0x138E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x138E
  ,simpleLowerCaseMapping:0x138E
  ,simpleTitleCaseMapping:0x138E
 },
 { code:0x138F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x138F
  ,simpleLowerCaseMapping:0x138F
  ,simpleTitleCaseMapping:0x138F
 },
 { code:0x1390
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1390
  ,simpleLowerCaseMapping:0x1390
  ,simpleTitleCaseMapping:0x1390
 },
 { code:0x1391
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1391
  ,simpleLowerCaseMapping:0x1391
  ,simpleTitleCaseMapping:0x1391
 },
 { code:0x1392
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1392
  ,simpleLowerCaseMapping:0x1392
  ,simpleTitleCaseMapping:0x1392
 },
 { code:0x1393
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1393
  ,simpleLowerCaseMapping:0x1393
  ,simpleTitleCaseMapping:0x1393
 },
 { code:0x1394
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1394
  ,simpleLowerCaseMapping:0x1394
  ,simpleTitleCaseMapping:0x1394
 },
 { code:0x1395
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1395
  ,simpleLowerCaseMapping:0x1395
  ,simpleTitleCaseMapping:0x1395
 },
 { code:0x1396
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1396
  ,simpleLowerCaseMapping:0x1396
  ,simpleTitleCaseMapping:0x1396
 },
 { code:0x1397
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1397
  ,simpleLowerCaseMapping:0x1397
  ,simpleTitleCaseMapping:0x1397
 },
 { code:0x1398
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1398
  ,simpleLowerCaseMapping:0x1398
  ,simpleTitleCaseMapping:0x1398
 },
 { code:0x1399
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1399
  ,simpleLowerCaseMapping:0x1399
  ,simpleTitleCaseMapping:0x1399
 },
 { code:0x13A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13A0
  ,simpleLowerCaseMapping:0x13A0
  ,simpleTitleCaseMapping:0x13A0
 },
 { code:0x13A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13A1
  ,simpleLowerCaseMapping:0x13A1
  ,simpleTitleCaseMapping:0x13A1
 },
 { code:0x13A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13A2
  ,simpleLowerCaseMapping:0x13A2
  ,simpleTitleCaseMapping:0x13A2
 },
 { code:0x13A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13A3
  ,simpleLowerCaseMapping:0x13A3
  ,simpleTitleCaseMapping:0x13A3
 },
 { code:0x13A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13A4
  ,simpleLowerCaseMapping:0x13A4
  ,simpleTitleCaseMapping:0x13A4
 },
 { code:0x13A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13A5
  ,simpleLowerCaseMapping:0x13A5
  ,simpleTitleCaseMapping:0x13A5
 },
 { code:0x13A6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13A6
  ,simpleLowerCaseMapping:0x13A6
  ,simpleTitleCaseMapping:0x13A6
 },
 { code:0x13A7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13A7
  ,simpleLowerCaseMapping:0x13A7
  ,simpleTitleCaseMapping:0x13A7
 },
 { code:0x13A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13A8
  ,simpleLowerCaseMapping:0x13A8
  ,simpleTitleCaseMapping:0x13A8
 },
 { code:0x13A9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13A9
  ,simpleLowerCaseMapping:0x13A9
  ,simpleTitleCaseMapping:0x13A9
 },
 { code:0x13AA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13AA
  ,simpleLowerCaseMapping:0x13AA
  ,simpleTitleCaseMapping:0x13AA
 },
 { code:0x13AB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13AB
  ,simpleLowerCaseMapping:0x13AB
  ,simpleTitleCaseMapping:0x13AB
 },
 { code:0x13AC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13AC
  ,simpleLowerCaseMapping:0x13AC
  ,simpleTitleCaseMapping:0x13AC
 },
 { code:0x13AD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13AD
  ,simpleLowerCaseMapping:0x13AD
  ,simpleTitleCaseMapping:0x13AD
 },
 { code:0x13AE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13AE
  ,simpleLowerCaseMapping:0x13AE
  ,simpleTitleCaseMapping:0x13AE
 },
 { code:0x13AF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13AF
  ,simpleLowerCaseMapping:0x13AF
  ,simpleTitleCaseMapping:0x13AF
 },
 { code:0x13B0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13B0
  ,simpleLowerCaseMapping:0x13B0
  ,simpleTitleCaseMapping:0x13B0
 },
 { code:0x13B1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13B1
  ,simpleLowerCaseMapping:0x13B1
  ,simpleTitleCaseMapping:0x13B1
 },
 { code:0x13B2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13B2
  ,simpleLowerCaseMapping:0x13B2
  ,simpleTitleCaseMapping:0x13B2
 },
 { code:0x13B3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13B3
  ,simpleLowerCaseMapping:0x13B3
  ,simpleTitleCaseMapping:0x13B3
 },
 { code:0x13B4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13B4
  ,simpleLowerCaseMapping:0x13B4
  ,simpleTitleCaseMapping:0x13B4
 },
 { code:0x13B5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13B5
  ,simpleLowerCaseMapping:0x13B5
  ,simpleTitleCaseMapping:0x13B5
 },
 { code:0x13B6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13B6
  ,simpleLowerCaseMapping:0x13B6
  ,simpleTitleCaseMapping:0x13B6
 },
 { code:0x13B7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13B7
  ,simpleLowerCaseMapping:0x13B7
  ,simpleTitleCaseMapping:0x13B7
 },
 { code:0x13B8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13B8
  ,simpleLowerCaseMapping:0x13B8
  ,simpleTitleCaseMapping:0x13B8
 },
 { code:0x13B9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13B9
  ,simpleLowerCaseMapping:0x13B9
  ,simpleTitleCaseMapping:0x13B9
 },
 { code:0x13BA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13BA
  ,simpleLowerCaseMapping:0x13BA
  ,simpleTitleCaseMapping:0x13BA
 },
 { code:0x13BB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13BB
  ,simpleLowerCaseMapping:0x13BB
  ,simpleTitleCaseMapping:0x13BB
 },
 { code:0x13BC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13BC
  ,simpleLowerCaseMapping:0x13BC
  ,simpleTitleCaseMapping:0x13BC
 },
 { code:0x13BD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13BD
  ,simpleLowerCaseMapping:0x13BD
  ,simpleTitleCaseMapping:0x13BD
 },
 { code:0x13BE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13BE
  ,simpleLowerCaseMapping:0x13BE
  ,simpleTitleCaseMapping:0x13BE
 },
 { code:0x13BF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13BF
  ,simpleLowerCaseMapping:0x13BF
  ,simpleTitleCaseMapping:0x13BF
 },
 { code:0x13C0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13C0
  ,simpleLowerCaseMapping:0x13C0
  ,simpleTitleCaseMapping:0x13C0
 },
 { code:0x13C1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13C1
  ,simpleLowerCaseMapping:0x13C1
  ,simpleTitleCaseMapping:0x13C1
 },
 { code:0x13C2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13C2
  ,simpleLowerCaseMapping:0x13C2
  ,simpleTitleCaseMapping:0x13C2
 },
 { code:0x13C3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13C3
  ,simpleLowerCaseMapping:0x13C3
  ,simpleTitleCaseMapping:0x13C3
 },
 { code:0x13C4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13C4
  ,simpleLowerCaseMapping:0x13C4
  ,simpleTitleCaseMapping:0x13C4
 },
 { code:0x13C5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13C5
  ,simpleLowerCaseMapping:0x13C5
  ,simpleTitleCaseMapping:0x13C5
 },
 { code:0x13C6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13C6
  ,simpleLowerCaseMapping:0x13C6
  ,simpleTitleCaseMapping:0x13C6
 },
 { code:0x13C7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13C7
  ,simpleLowerCaseMapping:0x13C7
  ,simpleTitleCaseMapping:0x13C7
 },
 { code:0x13C8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13C8
  ,simpleLowerCaseMapping:0x13C8
  ,simpleTitleCaseMapping:0x13C8
 },
 { code:0x13C9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13C9
  ,simpleLowerCaseMapping:0x13C9
  ,simpleTitleCaseMapping:0x13C9
 },
 { code:0x13CA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13CA
  ,simpleLowerCaseMapping:0x13CA
  ,simpleTitleCaseMapping:0x13CA
 },
 { code:0x13CB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13CB
  ,simpleLowerCaseMapping:0x13CB
  ,simpleTitleCaseMapping:0x13CB
 },
 { code:0x13CC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13CC
  ,simpleLowerCaseMapping:0x13CC
  ,simpleTitleCaseMapping:0x13CC
 },
 { code:0x13CD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13CD
  ,simpleLowerCaseMapping:0x13CD
  ,simpleTitleCaseMapping:0x13CD
 },
 { code:0x13CE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13CE
  ,simpleLowerCaseMapping:0x13CE
  ,simpleTitleCaseMapping:0x13CE
 },
 { code:0x13CF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13CF
  ,simpleLowerCaseMapping:0x13CF
  ,simpleTitleCaseMapping:0x13CF
 },
 { code:0x13D0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13D0
  ,simpleLowerCaseMapping:0x13D0
  ,simpleTitleCaseMapping:0x13D0
 },
 { code:0x13D1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13D1
  ,simpleLowerCaseMapping:0x13D1
  ,simpleTitleCaseMapping:0x13D1
 },
 { code:0x13D2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13D2
  ,simpleLowerCaseMapping:0x13D2
  ,simpleTitleCaseMapping:0x13D2
 },
 { code:0x13D3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13D3
  ,simpleLowerCaseMapping:0x13D3
  ,simpleTitleCaseMapping:0x13D3
 },
 { code:0x13D4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13D4
  ,simpleLowerCaseMapping:0x13D4
  ,simpleTitleCaseMapping:0x13D4
 },
 { code:0x13D5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13D5
  ,simpleLowerCaseMapping:0x13D5
  ,simpleTitleCaseMapping:0x13D5
 },
 { code:0x13D6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13D6
  ,simpleLowerCaseMapping:0x13D6
  ,simpleTitleCaseMapping:0x13D6
 },
 { code:0x13D7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13D7
  ,simpleLowerCaseMapping:0x13D7
  ,simpleTitleCaseMapping:0x13D7
 },
 { code:0x13D8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13D8
  ,simpleLowerCaseMapping:0x13D8
  ,simpleTitleCaseMapping:0x13D8
 },
 { code:0x13D9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13D9
  ,simpleLowerCaseMapping:0x13D9
  ,simpleTitleCaseMapping:0x13D9
 },
 { code:0x13DA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13DA
  ,simpleLowerCaseMapping:0x13DA
  ,simpleTitleCaseMapping:0x13DA
 },
 { code:0x13DB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13DB
  ,simpleLowerCaseMapping:0x13DB
  ,simpleTitleCaseMapping:0x13DB
 },
 { code:0x13DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13DC
  ,simpleLowerCaseMapping:0x13DC
  ,simpleTitleCaseMapping:0x13DC
 },
 { code:0x13DD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13DD
  ,simpleLowerCaseMapping:0x13DD
  ,simpleTitleCaseMapping:0x13DD
 },
 { code:0x13DE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13DE
  ,simpleLowerCaseMapping:0x13DE
  ,simpleTitleCaseMapping:0x13DE
 },
 { code:0x13DF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13DF
  ,simpleLowerCaseMapping:0x13DF
  ,simpleTitleCaseMapping:0x13DF
 },
 { code:0x13E0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13E0
  ,simpleLowerCaseMapping:0x13E0
  ,simpleTitleCaseMapping:0x13E0
 },
 { code:0x13E1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13E1
  ,simpleLowerCaseMapping:0x13E1
  ,simpleTitleCaseMapping:0x13E1
 },
 { code:0x13E2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13E2
  ,simpleLowerCaseMapping:0x13E2
  ,simpleTitleCaseMapping:0x13E2
 },
 { code:0x13E3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13E3
  ,simpleLowerCaseMapping:0x13E3
  ,simpleTitleCaseMapping:0x13E3
 },
 { code:0x13E4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13E4
  ,simpleLowerCaseMapping:0x13E4
  ,simpleTitleCaseMapping:0x13E4
 },
 { code:0x13E5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13E5
  ,simpleLowerCaseMapping:0x13E5
  ,simpleTitleCaseMapping:0x13E5
 },
 { code:0x13E6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13E6
  ,simpleLowerCaseMapping:0x13E6
  ,simpleTitleCaseMapping:0x13E6
 },
 { code:0x13E7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13E7
  ,simpleLowerCaseMapping:0x13E7
  ,simpleTitleCaseMapping:0x13E7
 },
 { code:0x13E8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13E8
  ,simpleLowerCaseMapping:0x13E8
  ,simpleTitleCaseMapping:0x13E8
 },
 { code:0x13E9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13E9
  ,simpleLowerCaseMapping:0x13E9
  ,simpleTitleCaseMapping:0x13E9
 },
 { code:0x13EA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13EA
  ,simpleLowerCaseMapping:0x13EA
  ,simpleTitleCaseMapping:0x13EA
 },
 { code:0x13EB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13EB
  ,simpleLowerCaseMapping:0x13EB
  ,simpleTitleCaseMapping:0x13EB
 },
 { code:0x13EC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13EC
  ,simpleLowerCaseMapping:0x13EC
  ,simpleTitleCaseMapping:0x13EC
 },
 { code:0x13ED
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13ED
  ,simpleLowerCaseMapping:0x13ED
  ,simpleTitleCaseMapping:0x13ED
 },
 { code:0x13EE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13EE
  ,simpleLowerCaseMapping:0x13EE
  ,simpleTitleCaseMapping:0x13EE
 },
 { code:0x13EF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13EF
  ,simpleLowerCaseMapping:0x13EF
  ,simpleTitleCaseMapping:0x13EF
 },
 { code:0x13F0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13F0
  ,simpleLowerCaseMapping:0x13F0
  ,simpleTitleCaseMapping:0x13F0
 },
 { code:0x13F1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13F1
  ,simpleLowerCaseMapping:0x13F1
  ,simpleTitleCaseMapping:0x13F1
 },
 { code:0x13F2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13F2
  ,simpleLowerCaseMapping:0x13F2
  ,simpleTitleCaseMapping:0x13F2
 },
 { code:0x13F3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13F3
  ,simpleLowerCaseMapping:0x13F3
  ,simpleTitleCaseMapping:0x13F3
 },
 { code:0x13F4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x13F4
  ,simpleLowerCaseMapping:0x13F4
  ,simpleTitleCaseMapping:0x13F4
 },
 { code:0x1401
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1401
  ,simpleLowerCaseMapping:0x1401
  ,simpleTitleCaseMapping:0x1401
 },
 { code:0x1402
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1402
  ,simpleLowerCaseMapping:0x1402
  ,simpleTitleCaseMapping:0x1402
 },
 { code:0x1403
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1403
  ,simpleLowerCaseMapping:0x1403
  ,simpleTitleCaseMapping:0x1403
 },
 { code:0x1404
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1404
  ,simpleLowerCaseMapping:0x1404
  ,simpleTitleCaseMapping:0x1404
 },
 { code:0x1405
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1405
  ,simpleLowerCaseMapping:0x1405
  ,simpleTitleCaseMapping:0x1405
 },
 { code:0x1406
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1406
  ,simpleLowerCaseMapping:0x1406
  ,simpleTitleCaseMapping:0x1406
 },
 { code:0x1407
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1407
  ,simpleLowerCaseMapping:0x1407
  ,simpleTitleCaseMapping:0x1407
 },
 { code:0x1408
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1408
  ,simpleLowerCaseMapping:0x1408
  ,simpleTitleCaseMapping:0x1408
 },
 { code:0x1409
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1409
  ,simpleLowerCaseMapping:0x1409
  ,simpleTitleCaseMapping:0x1409
 },
 { code:0x140A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x140A
  ,simpleLowerCaseMapping:0x140A
  ,simpleTitleCaseMapping:0x140A
 },
 { code:0x140B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x140B
  ,simpleLowerCaseMapping:0x140B
  ,simpleTitleCaseMapping:0x140B
 },
 { code:0x140C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x140C
  ,simpleLowerCaseMapping:0x140C
  ,simpleTitleCaseMapping:0x140C
 },
 { code:0x140D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x140D
  ,simpleLowerCaseMapping:0x140D
  ,simpleTitleCaseMapping:0x140D
 },
 { code:0x140E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x140E
  ,simpleLowerCaseMapping:0x140E
  ,simpleTitleCaseMapping:0x140E
 },
 { code:0x140F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x140F
  ,simpleLowerCaseMapping:0x140F
  ,simpleTitleCaseMapping:0x140F
 },
 { code:0x1410
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1410
  ,simpleLowerCaseMapping:0x1410
  ,simpleTitleCaseMapping:0x1410
 },
 { code:0x1411
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1411
  ,simpleLowerCaseMapping:0x1411
  ,simpleTitleCaseMapping:0x1411
 },
 { code:0x1412
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1412
  ,simpleLowerCaseMapping:0x1412
  ,simpleTitleCaseMapping:0x1412
 },
 { code:0x1413
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1413
  ,simpleLowerCaseMapping:0x1413
  ,simpleTitleCaseMapping:0x1413
 },
 { code:0x1414
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1414
  ,simpleLowerCaseMapping:0x1414
  ,simpleTitleCaseMapping:0x1414
 },
 { code:0x1415
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1415
  ,simpleLowerCaseMapping:0x1415
  ,simpleTitleCaseMapping:0x1415
 },
 { code:0x1416
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1416
  ,simpleLowerCaseMapping:0x1416
  ,simpleTitleCaseMapping:0x1416
 },
 { code:0x1417
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1417
  ,simpleLowerCaseMapping:0x1417
  ,simpleTitleCaseMapping:0x1417
 },
 { code:0x1418
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1418
  ,simpleLowerCaseMapping:0x1418
  ,simpleTitleCaseMapping:0x1418
 },
 { code:0x1419
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1419
  ,simpleLowerCaseMapping:0x1419
  ,simpleTitleCaseMapping:0x1419
 },
 { code:0x141A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x141A
  ,simpleLowerCaseMapping:0x141A
  ,simpleTitleCaseMapping:0x141A
 },
 { code:0x141B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x141B
  ,simpleLowerCaseMapping:0x141B
  ,simpleTitleCaseMapping:0x141B
 },
 { code:0x141C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x141C
  ,simpleLowerCaseMapping:0x141C
  ,simpleTitleCaseMapping:0x141C
 },
 { code:0x141D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x141D
  ,simpleLowerCaseMapping:0x141D
  ,simpleTitleCaseMapping:0x141D
 },
 { code:0x141E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x141E
  ,simpleLowerCaseMapping:0x141E
  ,simpleTitleCaseMapping:0x141E
 },
 { code:0x141F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x141F
  ,simpleLowerCaseMapping:0x141F
  ,simpleTitleCaseMapping:0x141F
 },
 { code:0x1420
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1420
  ,simpleLowerCaseMapping:0x1420
  ,simpleTitleCaseMapping:0x1420
 },
 { code:0x1421
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1421
  ,simpleLowerCaseMapping:0x1421
  ,simpleTitleCaseMapping:0x1421
 },
 { code:0x1422
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1422
  ,simpleLowerCaseMapping:0x1422
  ,simpleTitleCaseMapping:0x1422
 },
 { code:0x1423
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1423
  ,simpleLowerCaseMapping:0x1423
  ,simpleTitleCaseMapping:0x1423
 },
 { code:0x1424
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1424
  ,simpleLowerCaseMapping:0x1424
  ,simpleTitleCaseMapping:0x1424
 },
 { code:0x1425
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1425
  ,simpleLowerCaseMapping:0x1425
  ,simpleTitleCaseMapping:0x1425
 },
 { code:0x1426
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1426
  ,simpleLowerCaseMapping:0x1426
  ,simpleTitleCaseMapping:0x1426
 },
 { code:0x1427
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1427
  ,simpleLowerCaseMapping:0x1427
  ,simpleTitleCaseMapping:0x1427
 },
 { code:0x1428
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1428
  ,simpleLowerCaseMapping:0x1428
  ,simpleTitleCaseMapping:0x1428
 },
 { code:0x1429
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1429
  ,simpleLowerCaseMapping:0x1429
  ,simpleTitleCaseMapping:0x1429
 },
 { code:0x142A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x142A
  ,simpleLowerCaseMapping:0x142A
  ,simpleTitleCaseMapping:0x142A
 },
 { code:0x142B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x142B
  ,simpleLowerCaseMapping:0x142B
  ,simpleTitleCaseMapping:0x142B
 },
 { code:0x142C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x142C
  ,simpleLowerCaseMapping:0x142C
  ,simpleTitleCaseMapping:0x142C
 },
 { code:0x142D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x142D
  ,simpleLowerCaseMapping:0x142D
  ,simpleTitleCaseMapping:0x142D
 },
 { code:0x142E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x142E
  ,simpleLowerCaseMapping:0x142E
  ,simpleTitleCaseMapping:0x142E
 },
 { code:0x142F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x142F
  ,simpleLowerCaseMapping:0x142F
  ,simpleTitleCaseMapping:0x142F
 },
 { code:0x1430
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1430
  ,simpleLowerCaseMapping:0x1430
  ,simpleTitleCaseMapping:0x1430
 },
 { code:0x1431
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1431
  ,simpleLowerCaseMapping:0x1431
  ,simpleTitleCaseMapping:0x1431
 },
 { code:0x1432
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1432
  ,simpleLowerCaseMapping:0x1432
  ,simpleTitleCaseMapping:0x1432
 },
 { code:0x1433
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1433
  ,simpleLowerCaseMapping:0x1433
  ,simpleTitleCaseMapping:0x1433
 },
 { code:0x1434
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1434
  ,simpleLowerCaseMapping:0x1434
  ,simpleTitleCaseMapping:0x1434
 },
 { code:0x1435
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1435
  ,simpleLowerCaseMapping:0x1435
  ,simpleTitleCaseMapping:0x1435
 },
 { code:0x1436
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1436
  ,simpleLowerCaseMapping:0x1436
  ,simpleTitleCaseMapping:0x1436
 },
 { code:0x1437
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1437
  ,simpleLowerCaseMapping:0x1437
  ,simpleTitleCaseMapping:0x1437
 },
 { code:0x1438
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1438
  ,simpleLowerCaseMapping:0x1438
  ,simpleTitleCaseMapping:0x1438
 },
 { code:0x1439
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1439
  ,simpleLowerCaseMapping:0x1439
  ,simpleTitleCaseMapping:0x1439
 },
 { code:0x143A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x143A
  ,simpleLowerCaseMapping:0x143A
  ,simpleTitleCaseMapping:0x143A
 },
 { code:0x143B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x143B
  ,simpleLowerCaseMapping:0x143B
  ,simpleTitleCaseMapping:0x143B
 },
 { code:0x143C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x143C
  ,simpleLowerCaseMapping:0x143C
  ,simpleTitleCaseMapping:0x143C
 },
 { code:0x143D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x143D
  ,simpleLowerCaseMapping:0x143D
  ,simpleTitleCaseMapping:0x143D
 },
 { code:0x143E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x143E
  ,simpleLowerCaseMapping:0x143E
  ,simpleTitleCaseMapping:0x143E
 },
 { code:0x143F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x143F
  ,simpleLowerCaseMapping:0x143F
  ,simpleTitleCaseMapping:0x143F
 },
 { code:0x1440
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1440
  ,simpleLowerCaseMapping:0x1440
  ,simpleTitleCaseMapping:0x1440
 },
 { code:0x1441
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1441
  ,simpleLowerCaseMapping:0x1441
  ,simpleTitleCaseMapping:0x1441
 },
 { code:0x1442
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1442
  ,simpleLowerCaseMapping:0x1442
  ,simpleTitleCaseMapping:0x1442
 },
 { code:0x1443
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1443
  ,simpleLowerCaseMapping:0x1443
  ,simpleTitleCaseMapping:0x1443
 },
 { code:0x1444
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1444
  ,simpleLowerCaseMapping:0x1444
  ,simpleTitleCaseMapping:0x1444
 },
 { code:0x1445
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1445
  ,simpleLowerCaseMapping:0x1445
  ,simpleTitleCaseMapping:0x1445
 },
 { code:0x1446
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1446
  ,simpleLowerCaseMapping:0x1446
  ,simpleTitleCaseMapping:0x1446
 },
 { code:0x1447
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1447
  ,simpleLowerCaseMapping:0x1447
  ,simpleTitleCaseMapping:0x1447
 },
 { code:0x1448
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1448
  ,simpleLowerCaseMapping:0x1448
  ,simpleTitleCaseMapping:0x1448
 },
 { code:0x1449
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1449
  ,simpleLowerCaseMapping:0x1449
  ,simpleTitleCaseMapping:0x1449
 },
 { code:0x144A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x144A
  ,simpleLowerCaseMapping:0x144A
  ,simpleTitleCaseMapping:0x144A
 },
 { code:0x144B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x144B
  ,simpleLowerCaseMapping:0x144B
  ,simpleTitleCaseMapping:0x144B
 },
 { code:0x144C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x144C
  ,simpleLowerCaseMapping:0x144C
  ,simpleTitleCaseMapping:0x144C
 },
 { code:0x144D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x144D
  ,simpleLowerCaseMapping:0x144D
  ,simpleTitleCaseMapping:0x144D
 },
 { code:0x144E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x144E
  ,simpleLowerCaseMapping:0x144E
  ,simpleTitleCaseMapping:0x144E
 },
 { code:0x144F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x144F
  ,simpleLowerCaseMapping:0x144F
  ,simpleTitleCaseMapping:0x144F
 },
 { code:0x1450
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1450
  ,simpleLowerCaseMapping:0x1450
  ,simpleTitleCaseMapping:0x1450
 },
 { code:0x1451
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1451
  ,simpleLowerCaseMapping:0x1451
  ,simpleTitleCaseMapping:0x1451
 },
 { code:0x1452
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1452
  ,simpleLowerCaseMapping:0x1452
  ,simpleTitleCaseMapping:0x1452
 },
 { code:0x1453
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1453
  ,simpleLowerCaseMapping:0x1453
  ,simpleTitleCaseMapping:0x1453
 },
 { code:0x1454
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1454
  ,simpleLowerCaseMapping:0x1454
  ,simpleTitleCaseMapping:0x1454
 },
 { code:0x1455
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1455
  ,simpleLowerCaseMapping:0x1455
  ,simpleTitleCaseMapping:0x1455
 },
 { code:0x1456
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1456
  ,simpleLowerCaseMapping:0x1456
  ,simpleTitleCaseMapping:0x1456
 },
 { code:0x1457
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1457
  ,simpleLowerCaseMapping:0x1457
  ,simpleTitleCaseMapping:0x1457
 },
 { code:0x1458
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1458
  ,simpleLowerCaseMapping:0x1458
  ,simpleTitleCaseMapping:0x1458
 },
 { code:0x1459
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1459
  ,simpleLowerCaseMapping:0x1459
  ,simpleTitleCaseMapping:0x1459
 },
 { code:0x145A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x145A
  ,simpleLowerCaseMapping:0x145A
  ,simpleTitleCaseMapping:0x145A
 },
 { code:0x145B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x145B
  ,simpleLowerCaseMapping:0x145B
  ,simpleTitleCaseMapping:0x145B
 },
 { code:0x145C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x145C
  ,simpleLowerCaseMapping:0x145C
  ,simpleTitleCaseMapping:0x145C
 },
 { code:0x145D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x145D
  ,simpleLowerCaseMapping:0x145D
  ,simpleTitleCaseMapping:0x145D
 },
 { code:0x145E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x145E
  ,simpleLowerCaseMapping:0x145E
  ,simpleTitleCaseMapping:0x145E
 },
 { code:0x145F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x145F
  ,simpleLowerCaseMapping:0x145F
  ,simpleTitleCaseMapping:0x145F
 },
 { code:0x1460
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1460
  ,simpleLowerCaseMapping:0x1460
  ,simpleTitleCaseMapping:0x1460
 },
 { code:0x1461
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1461
  ,simpleLowerCaseMapping:0x1461
  ,simpleTitleCaseMapping:0x1461
 },
 { code:0x1462
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1462
  ,simpleLowerCaseMapping:0x1462
  ,simpleTitleCaseMapping:0x1462
 },
 { code:0x1463
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1463
  ,simpleLowerCaseMapping:0x1463
  ,simpleTitleCaseMapping:0x1463
 },
 { code:0x1464
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1464
  ,simpleLowerCaseMapping:0x1464
  ,simpleTitleCaseMapping:0x1464
 },
 { code:0x1465
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1465
  ,simpleLowerCaseMapping:0x1465
  ,simpleTitleCaseMapping:0x1465
 },
 { code:0x1466
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1466
  ,simpleLowerCaseMapping:0x1466
  ,simpleTitleCaseMapping:0x1466
 },
 { code:0x1467
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1467
  ,simpleLowerCaseMapping:0x1467
  ,simpleTitleCaseMapping:0x1467
 },
 { code:0x1468
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1468
  ,simpleLowerCaseMapping:0x1468
  ,simpleTitleCaseMapping:0x1468
 },
 { code:0x1469
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1469
  ,simpleLowerCaseMapping:0x1469
  ,simpleTitleCaseMapping:0x1469
 },
 { code:0x146A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x146A
  ,simpleLowerCaseMapping:0x146A
  ,simpleTitleCaseMapping:0x146A
 },
 { code:0x146B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x146B
  ,simpleLowerCaseMapping:0x146B
  ,simpleTitleCaseMapping:0x146B
 },
 { code:0x146C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x146C
  ,simpleLowerCaseMapping:0x146C
  ,simpleTitleCaseMapping:0x146C
 },
 { code:0x146D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x146D
  ,simpleLowerCaseMapping:0x146D
  ,simpleTitleCaseMapping:0x146D
 },
 { code:0x146E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x146E
  ,simpleLowerCaseMapping:0x146E
  ,simpleTitleCaseMapping:0x146E
 },
 { code:0x146F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x146F
  ,simpleLowerCaseMapping:0x146F
  ,simpleTitleCaseMapping:0x146F
 },
 { code:0x1470
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1470
  ,simpleLowerCaseMapping:0x1470
  ,simpleTitleCaseMapping:0x1470
 },
 { code:0x1471
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1471
  ,simpleLowerCaseMapping:0x1471
  ,simpleTitleCaseMapping:0x1471
 },
 { code:0x1472
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1472
  ,simpleLowerCaseMapping:0x1472
  ,simpleTitleCaseMapping:0x1472
 },
 { code:0x1473
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1473
  ,simpleLowerCaseMapping:0x1473
  ,simpleTitleCaseMapping:0x1473
 },
 { code:0x1474
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1474
  ,simpleLowerCaseMapping:0x1474
  ,simpleTitleCaseMapping:0x1474
 },
 { code:0x1475
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1475
  ,simpleLowerCaseMapping:0x1475
  ,simpleTitleCaseMapping:0x1475
 },
 { code:0x1476
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1476
  ,simpleLowerCaseMapping:0x1476
  ,simpleTitleCaseMapping:0x1476
 },
 { code:0x1477
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1477
  ,simpleLowerCaseMapping:0x1477
  ,simpleTitleCaseMapping:0x1477
 },
 { code:0x1478
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1478
  ,simpleLowerCaseMapping:0x1478
  ,simpleTitleCaseMapping:0x1478
 },
 { code:0x1479
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1479
  ,simpleLowerCaseMapping:0x1479
  ,simpleTitleCaseMapping:0x1479
 },
 { code:0x147A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x147A
  ,simpleLowerCaseMapping:0x147A
  ,simpleTitleCaseMapping:0x147A
 },
 { code:0x147B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x147B
  ,simpleLowerCaseMapping:0x147B
  ,simpleTitleCaseMapping:0x147B
 },
 { code:0x147C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x147C
  ,simpleLowerCaseMapping:0x147C
  ,simpleTitleCaseMapping:0x147C
 },
 { code:0x147D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x147D
  ,simpleLowerCaseMapping:0x147D
  ,simpleTitleCaseMapping:0x147D
 },
 { code:0x147E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x147E
  ,simpleLowerCaseMapping:0x147E
  ,simpleTitleCaseMapping:0x147E
 },
 { code:0x147F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x147F
  ,simpleLowerCaseMapping:0x147F
  ,simpleTitleCaseMapping:0x147F
 },
 { code:0x1480
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1480
  ,simpleLowerCaseMapping:0x1480
  ,simpleTitleCaseMapping:0x1480
 },
 { code:0x1481
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1481
  ,simpleLowerCaseMapping:0x1481
  ,simpleTitleCaseMapping:0x1481
 },
 { code:0x1482
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1482
  ,simpleLowerCaseMapping:0x1482
  ,simpleTitleCaseMapping:0x1482
 },
 { code:0x1483
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1483
  ,simpleLowerCaseMapping:0x1483
  ,simpleTitleCaseMapping:0x1483
 },
 { code:0x1484
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1484
  ,simpleLowerCaseMapping:0x1484
  ,simpleTitleCaseMapping:0x1484
 },
 { code:0x1485
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1485
  ,simpleLowerCaseMapping:0x1485
  ,simpleTitleCaseMapping:0x1485
 },
 { code:0x1486
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1486
  ,simpleLowerCaseMapping:0x1486
  ,simpleTitleCaseMapping:0x1486
 },
 { code:0x1487
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1487
  ,simpleLowerCaseMapping:0x1487
  ,simpleTitleCaseMapping:0x1487
 },
 { code:0x1488
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1488
  ,simpleLowerCaseMapping:0x1488
  ,simpleTitleCaseMapping:0x1488
 },
 { code:0x1489
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1489
  ,simpleLowerCaseMapping:0x1489
  ,simpleTitleCaseMapping:0x1489
 },
 { code:0x148A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x148A
  ,simpleLowerCaseMapping:0x148A
  ,simpleTitleCaseMapping:0x148A
 },
 { code:0x148B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x148B
  ,simpleLowerCaseMapping:0x148B
  ,simpleTitleCaseMapping:0x148B
 },
 { code:0x148C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x148C
  ,simpleLowerCaseMapping:0x148C
  ,simpleTitleCaseMapping:0x148C
 },
 { code:0x148D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x148D
  ,simpleLowerCaseMapping:0x148D
  ,simpleTitleCaseMapping:0x148D
 },
 { code:0x148E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x148E
  ,simpleLowerCaseMapping:0x148E
  ,simpleTitleCaseMapping:0x148E
 },
 { code:0x148F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x148F
  ,simpleLowerCaseMapping:0x148F
  ,simpleTitleCaseMapping:0x148F
 },
 { code:0x1490
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1490
  ,simpleLowerCaseMapping:0x1490
  ,simpleTitleCaseMapping:0x1490
 },
 { code:0x1491
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1491
  ,simpleLowerCaseMapping:0x1491
  ,simpleTitleCaseMapping:0x1491
 },
 { code:0x1492
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1492
  ,simpleLowerCaseMapping:0x1492
  ,simpleTitleCaseMapping:0x1492
 },
 { code:0x1493
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1493
  ,simpleLowerCaseMapping:0x1493
  ,simpleTitleCaseMapping:0x1493
 },
 { code:0x1494
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1494
  ,simpleLowerCaseMapping:0x1494
  ,simpleTitleCaseMapping:0x1494
 },
 { code:0x1495
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1495
  ,simpleLowerCaseMapping:0x1495
  ,simpleTitleCaseMapping:0x1495
 },
 { code:0x1496
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1496
  ,simpleLowerCaseMapping:0x1496
  ,simpleTitleCaseMapping:0x1496
 },
 { code:0x1497
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1497
  ,simpleLowerCaseMapping:0x1497
  ,simpleTitleCaseMapping:0x1497
 },
 { code:0x1498
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1498
  ,simpleLowerCaseMapping:0x1498
  ,simpleTitleCaseMapping:0x1498
 },
 { code:0x1499
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1499
  ,simpleLowerCaseMapping:0x1499
  ,simpleTitleCaseMapping:0x1499
 },
 { code:0x149A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x149A
  ,simpleLowerCaseMapping:0x149A
  ,simpleTitleCaseMapping:0x149A
 },
 { code:0x149B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x149B
  ,simpleLowerCaseMapping:0x149B
  ,simpleTitleCaseMapping:0x149B
 },
 { code:0x149C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x149C
  ,simpleLowerCaseMapping:0x149C
  ,simpleTitleCaseMapping:0x149C
 },
 { code:0x149D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x149D
  ,simpleLowerCaseMapping:0x149D
  ,simpleTitleCaseMapping:0x149D
 },
 { code:0x149E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x149E
  ,simpleLowerCaseMapping:0x149E
  ,simpleTitleCaseMapping:0x149E
 },
 { code:0x149F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x149F
  ,simpleLowerCaseMapping:0x149F
  ,simpleTitleCaseMapping:0x149F
 },
 { code:0x14A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14A0
  ,simpleLowerCaseMapping:0x14A0
  ,simpleTitleCaseMapping:0x14A0
 },
 { code:0x14A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14A1
  ,simpleLowerCaseMapping:0x14A1
  ,simpleTitleCaseMapping:0x14A1
 },
 { code:0x14A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14A2
  ,simpleLowerCaseMapping:0x14A2
  ,simpleTitleCaseMapping:0x14A2
 },
 { code:0x14A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14A3
  ,simpleLowerCaseMapping:0x14A3
  ,simpleTitleCaseMapping:0x14A3
 },
 { code:0x14A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14A4
  ,simpleLowerCaseMapping:0x14A4
  ,simpleTitleCaseMapping:0x14A4
 },
 { code:0x14A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14A5
  ,simpleLowerCaseMapping:0x14A5
  ,simpleTitleCaseMapping:0x14A5
 },
 { code:0x14A6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14A6
  ,simpleLowerCaseMapping:0x14A6
  ,simpleTitleCaseMapping:0x14A6
 },
 { code:0x14A7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14A7
  ,simpleLowerCaseMapping:0x14A7
  ,simpleTitleCaseMapping:0x14A7
 },
 { code:0x14A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14A8
  ,simpleLowerCaseMapping:0x14A8
  ,simpleTitleCaseMapping:0x14A8
 },
 { code:0x14A9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14A9
  ,simpleLowerCaseMapping:0x14A9
  ,simpleTitleCaseMapping:0x14A9
 },
 { code:0x14AA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14AA
  ,simpleLowerCaseMapping:0x14AA
  ,simpleTitleCaseMapping:0x14AA
 },
 { code:0x14AB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14AB
  ,simpleLowerCaseMapping:0x14AB
  ,simpleTitleCaseMapping:0x14AB
 },
 { code:0x14AC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14AC
  ,simpleLowerCaseMapping:0x14AC
  ,simpleTitleCaseMapping:0x14AC
 },
 { code:0x14AD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14AD
  ,simpleLowerCaseMapping:0x14AD
  ,simpleTitleCaseMapping:0x14AD
 },
 { code:0x14AE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14AE
  ,simpleLowerCaseMapping:0x14AE
  ,simpleTitleCaseMapping:0x14AE
 },
 { code:0x14AF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14AF
  ,simpleLowerCaseMapping:0x14AF
  ,simpleTitleCaseMapping:0x14AF
 },
 { code:0x14B0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14B0
  ,simpleLowerCaseMapping:0x14B0
  ,simpleTitleCaseMapping:0x14B0
 },
 { code:0x14B1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14B1
  ,simpleLowerCaseMapping:0x14B1
  ,simpleTitleCaseMapping:0x14B1
 },
 { code:0x14B2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14B2
  ,simpleLowerCaseMapping:0x14B2
  ,simpleTitleCaseMapping:0x14B2
 },
 { code:0x14B3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14B3
  ,simpleLowerCaseMapping:0x14B3
  ,simpleTitleCaseMapping:0x14B3
 },
 { code:0x14B4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14B4
  ,simpleLowerCaseMapping:0x14B4
  ,simpleTitleCaseMapping:0x14B4
 },
 { code:0x14B5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14B5
  ,simpleLowerCaseMapping:0x14B5
  ,simpleTitleCaseMapping:0x14B5
 },
 { code:0x14B6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14B6
  ,simpleLowerCaseMapping:0x14B6
  ,simpleTitleCaseMapping:0x14B6
 },
 { code:0x14B7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14B7
  ,simpleLowerCaseMapping:0x14B7
  ,simpleTitleCaseMapping:0x14B7
 },
 { code:0x14B8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14B8
  ,simpleLowerCaseMapping:0x14B8
  ,simpleTitleCaseMapping:0x14B8
 },
 { code:0x14B9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14B9
  ,simpleLowerCaseMapping:0x14B9
  ,simpleTitleCaseMapping:0x14B9
 },
 { code:0x14BA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14BA
  ,simpleLowerCaseMapping:0x14BA
  ,simpleTitleCaseMapping:0x14BA
 },
 { code:0x14BB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14BB
  ,simpleLowerCaseMapping:0x14BB
  ,simpleTitleCaseMapping:0x14BB
 },
 { code:0x14BC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14BC
  ,simpleLowerCaseMapping:0x14BC
  ,simpleTitleCaseMapping:0x14BC
 },
 { code:0x14BD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14BD
  ,simpleLowerCaseMapping:0x14BD
  ,simpleTitleCaseMapping:0x14BD
 },
 { code:0x14BE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14BE
  ,simpleLowerCaseMapping:0x14BE
  ,simpleTitleCaseMapping:0x14BE
 },
 { code:0x14BF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14BF
  ,simpleLowerCaseMapping:0x14BF
  ,simpleTitleCaseMapping:0x14BF
 },
 { code:0x14C0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14C0
  ,simpleLowerCaseMapping:0x14C0
  ,simpleTitleCaseMapping:0x14C0
 },
 { code:0x14C1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14C1
  ,simpleLowerCaseMapping:0x14C1
  ,simpleTitleCaseMapping:0x14C1
 },
 { code:0x14C2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14C2
  ,simpleLowerCaseMapping:0x14C2
  ,simpleTitleCaseMapping:0x14C2
 },
 { code:0x14C3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14C3
  ,simpleLowerCaseMapping:0x14C3
  ,simpleTitleCaseMapping:0x14C3
 },
 { code:0x14C4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14C4
  ,simpleLowerCaseMapping:0x14C4
  ,simpleTitleCaseMapping:0x14C4
 },
 { code:0x14C5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14C5
  ,simpleLowerCaseMapping:0x14C5
  ,simpleTitleCaseMapping:0x14C5
 },
 { code:0x14C6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14C6
  ,simpleLowerCaseMapping:0x14C6
  ,simpleTitleCaseMapping:0x14C6
 },
 { code:0x14C7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14C7
  ,simpleLowerCaseMapping:0x14C7
  ,simpleTitleCaseMapping:0x14C7
 },
 { code:0x14C8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14C8
  ,simpleLowerCaseMapping:0x14C8
  ,simpleTitleCaseMapping:0x14C8
 },
 { code:0x14C9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14C9
  ,simpleLowerCaseMapping:0x14C9
  ,simpleTitleCaseMapping:0x14C9
 },
 { code:0x14CA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14CA
  ,simpleLowerCaseMapping:0x14CA
  ,simpleTitleCaseMapping:0x14CA
 },
 { code:0x14CB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14CB
  ,simpleLowerCaseMapping:0x14CB
  ,simpleTitleCaseMapping:0x14CB
 },
 { code:0x14CC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14CC
  ,simpleLowerCaseMapping:0x14CC
  ,simpleTitleCaseMapping:0x14CC
 },
 { code:0x14CD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14CD
  ,simpleLowerCaseMapping:0x14CD
  ,simpleTitleCaseMapping:0x14CD
 },
 { code:0x14CE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14CE
  ,simpleLowerCaseMapping:0x14CE
  ,simpleTitleCaseMapping:0x14CE
 },
 { code:0x14CF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14CF
  ,simpleLowerCaseMapping:0x14CF
  ,simpleTitleCaseMapping:0x14CF
 },
 { code:0x14D0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14D0
  ,simpleLowerCaseMapping:0x14D0
  ,simpleTitleCaseMapping:0x14D0
 },
 { code:0x14D1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14D1
  ,simpleLowerCaseMapping:0x14D1
  ,simpleTitleCaseMapping:0x14D1
 },
 { code:0x14D2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14D2
  ,simpleLowerCaseMapping:0x14D2
  ,simpleTitleCaseMapping:0x14D2
 },
 { code:0x14D3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14D3
  ,simpleLowerCaseMapping:0x14D3
  ,simpleTitleCaseMapping:0x14D3
 },
 { code:0x14D4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14D4
  ,simpleLowerCaseMapping:0x14D4
  ,simpleTitleCaseMapping:0x14D4
 },
 { code:0x14D5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14D5
  ,simpleLowerCaseMapping:0x14D5
  ,simpleTitleCaseMapping:0x14D5
 },
 { code:0x14D6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14D6
  ,simpleLowerCaseMapping:0x14D6
  ,simpleTitleCaseMapping:0x14D6
 },
 { code:0x14D7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14D7
  ,simpleLowerCaseMapping:0x14D7
  ,simpleTitleCaseMapping:0x14D7
 },
 { code:0x14D8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14D8
  ,simpleLowerCaseMapping:0x14D8
  ,simpleTitleCaseMapping:0x14D8
 },
 { code:0x14D9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14D9
  ,simpleLowerCaseMapping:0x14D9
  ,simpleTitleCaseMapping:0x14D9
 },
 { code:0x14DA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14DA
  ,simpleLowerCaseMapping:0x14DA
  ,simpleTitleCaseMapping:0x14DA
 },
 { code:0x14DB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14DB
  ,simpleLowerCaseMapping:0x14DB
  ,simpleTitleCaseMapping:0x14DB
 },
 { code:0x14DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14DC
  ,simpleLowerCaseMapping:0x14DC
  ,simpleTitleCaseMapping:0x14DC
 },
 { code:0x14DD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14DD
  ,simpleLowerCaseMapping:0x14DD
  ,simpleTitleCaseMapping:0x14DD
 },
 { code:0x14DE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14DE
  ,simpleLowerCaseMapping:0x14DE
  ,simpleTitleCaseMapping:0x14DE
 },
 { code:0x14DF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14DF
  ,simpleLowerCaseMapping:0x14DF
  ,simpleTitleCaseMapping:0x14DF
 },
 { code:0x14E0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14E0
  ,simpleLowerCaseMapping:0x14E0
  ,simpleTitleCaseMapping:0x14E0
 },
 { code:0x14E1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14E1
  ,simpleLowerCaseMapping:0x14E1
  ,simpleTitleCaseMapping:0x14E1
 },
 { code:0x14E2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14E2
  ,simpleLowerCaseMapping:0x14E2
  ,simpleTitleCaseMapping:0x14E2
 },
 { code:0x14E3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14E3
  ,simpleLowerCaseMapping:0x14E3
  ,simpleTitleCaseMapping:0x14E3
 },
 { code:0x14E4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14E4
  ,simpleLowerCaseMapping:0x14E4
  ,simpleTitleCaseMapping:0x14E4
 },
 { code:0x14E5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14E5
  ,simpleLowerCaseMapping:0x14E5
  ,simpleTitleCaseMapping:0x14E5
 },
 { code:0x14E6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14E6
  ,simpleLowerCaseMapping:0x14E6
  ,simpleTitleCaseMapping:0x14E6
 },
 { code:0x14E7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14E7
  ,simpleLowerCaseMapping:0x14E7
  ,simpleTitleCaseMapping:0x14E7
 },
 { code:0x14E8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14E8
  ,simpleLowerCaseMapping:0x14E8
  ,simpleTitleCaseMapping:0x14E8
 },
 { code:0x14E9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14E9
  ,simpleLowerCaseMapping:0x14E9
  ,simpleTitleCaseMapping:0x14E9
 },
 { code:0x14EA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14EA
  ,simpleLowerCaseMapping:0x14EA
  ,simpleTitleCaseMapping:0x14EA
 },
 { code:0x14EB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14EB
  ,simpleLowerCaseMapping:0x14EB
  ,simpleTitleCaseMapping:0x14EB
 },
 { code:0x14EC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14EC
  ,simpleLowerCaseMapping:0x14EC
  ,simpleTitleCaseMapping:0x14EC
 },
 { code:0x14ED
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14ED
  ,simpleLowerCaseMapping:0x14ED
  ,simpleTitleCaseMapping:0x14ED
 },
 { code:0x14EE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14EE
  ,simpleLowerCaseMapping:0x14EE
  ,simpleTitleCaseMapping:0x14EE
 },
 { code:0x14EF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14EF
  ,simpleLowerCaseMapping:0x14EF
  ,simpleTitleCaseMapping:0x14EF
 },
 { code:0x14F0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14F0
  ,simpleLowerCaseMapping:0x14F0
  ,simpleTitleCaseMapping:0x14F0
 },
 { code:0x14F1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14F1
  ,simpleLowerCaseMapping:0x14F1
  ,simpleTitleCaseMapping:0x14F1
 },
 { code:0x14F2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14F2
  ,simpleLowerCaseMapping:0x14F2
  ,simpleTitleCaseMapping:0x14F2
 },
 { code:0x14F3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14F3
  ,simpleLowerCaseMapping:0x14F3
  ,simpleTitleCaseMapping:0x14F3
 },
 { code:0x14F4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14F4
  ,simpleLowerCaseMapping:0x14F4
  ,simpleTitleCaseMapping:0x14F4
 },
 { code:0x14F5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14F5
  ,simpleLowerCaseMapping:0x14F5
  ,simpleTitleCaseMapping:0x14F5
 },
 { code:0x14F6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14F6
  ,simpleLowerCaseMapping:0x14F6
  ,simpleTitleCaseMapping:0x14F6
 },
 { code:0x14F7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14F7
  ,simpleLowerCaseMapping:0x14F7
  ,simpleTitleCaseMapping:0x14F7
 },
 { code:0x14F8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14F8
  ,simpleLowerCaseMapping:0x14F8
  ,simpleTitleCaseMapping:0x14F8
 },
 { code:0x14F9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14F9
  ,simpleLowerCaseMapping:0x14F9
  ,simpleTitleCaseMapping:0x14F9
 },
 { code:0x14FA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14FA
  ,simpleLowerCaseMapping:0x14FA
  ,simpleTitleCaseMapping:0x14FA
 },
 { code:0x14FB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14FB
  ,simpleLowerCaseMapping:0x14FB
  ,simpleTitleCaseMapping:0x14FB
 },
 { code:0x14FC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14FC
  ,simpleLowerCaseMapping:0x14FC
  ,simpleTitleCaseMapping:0x14FC
 },
 { code:0x14FD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14FD
  ,simpleLowerCaseMapping:0x14FD
  ,simpleTitleCaseMapping:0x14FD
 },
 { code:0x14FE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14FE
  ,simpleLowerCaseMapping:0x14FE
  ,simpleTitleCaseMapping:0x14FE
 },
 { code:0x14FF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x14FF
  ,simpleLowerCaseMapping:0x14FF
  ,simpleTitleCaseMapping:0x14FF
 },
 { code:0x1500
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1500
  ,simpleLowerCaseMapping:0x1500
  ,simpleTitleCaseMapping:0x1500
 },
 { code:0x1501
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1501
  ,simpleLowerCaseMapping:0x1501
  ,simpleTitleCaseMapping:0x1501
 },
 { code:0x1502
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1502
  ,simpleLowerCaseMapping:0x1502
  ,simpleTitleCaseMapping:0x1502
 },
 { code:0x1503
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1503
  ,simpleLowerCaseMapping:0x1503
  ,simpleTitleCaseMapping:0x1503
 },
 { code:0x1504
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1504
  ,simpleLowerCaseMapping:0x1504
  ,simpleTitleCaseMapping:0x1504
 },
 { code:0x1505
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1505
  ,simpleLowerCaseMapping:0x1505
  ,simpleTitleCaseMapping:0x1505
 },
 { code:0x1506
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1506
  ,simpleLowerCaseMapping:0x1506
  ,simpleTitleCaseMapping:0x1506
 },
 { code:0x1507
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1507
  ,simpleLowerCaseMapping:0x1507
  ,simpleTitleCaseMapping:0x1507
 },
 { code:0x1508
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1508
  ,simpleLowerCaseMapping:0x1508
  ,simpleTitleCaseMapping:0x1508
 },
 { code:0x1509
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1509
  ,simpleLowerCaseMapping:0x1509
  ,simpleTitleCaseMapping:0x1509
 },
 { code:0x150A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x150A
  ,simpleLowerCaseMapping:0x150A
  ,simpleTitleCaseMapping:0x150A
 },
 { code:0x150B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x150B
  ,simpleLowerCaseMapping:0x150B
  ,simpleTitleCaseMapping:0x150B
 },
 { code:0x150C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x150C
  ,simpleLowerCaseMapping:0x150C
  ,simpleTitleCaseMapping:0x150C
 },
 { code:0x150D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x150D
  ,simpleLowerCaseMapping:0x150D
  ,simpleTitleCaseMapping:0x150D
 },
 { code:0x150E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x150E
  ,simpleLowerCaseMapping:0x150E
  ,simpleTitleCaseMapping:0x150E
 },
 { code:0x150F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x150F
  ,simpleLowerCaseMapping:0x150F
  ,simpleTitleCaseMapping:0x150F
 },
 { code:0x1510
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1510
  ,simpleLowerCaseMapping:0x1510
  ,simpleTitleCaseMapping:0x1510
 },
 { code:0x1511
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1511
  ,simpleLowerCaseMapping:0x1511
  ,simpleTitleCaseMapping:0x1511
 },
 { code:0x1512
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1512
  ,simpleLowerCaseMapping:0x1512
  ,simpleTitleCaseMapping:0x1512
 },
 { code:0x1513
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1513
  ,simpleLowerCaseMapping:0x1513
  ,simpleTitleCaseMapping:0x1513
 },
 { code:0x1514
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1514
  ,simpleLowerCaseMapping:0x1514
  ,simpleTitleCaseMapping:0x1514
 },
 { code:0x1515
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1515
  ,simpleLowerCaseMapping:0x1515
  ,simpleTitleCaseMapping:0x1515
 },
 { code:0x1516
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1516
  ,simpleLowerCaseMapping:0x1516
  ,simpleTitleCaseMapping:0x1516
 },
 { code:0x1517
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1517
  ,simpleLowerCaseMapping:0x1517
  ,simpleTitleCaseMapping:0x1517
 },
 { code:0x1518
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1518
  ,simpleLowerCaseMapping:0x1518
  ,simpleTitleCaseMapping:0x1518
 },
 { code:0x1519
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1519
  ,simpleLowerCaseMapping:0x1519
  ,simpleTitleCaseMapping:0x1519
 },
 { code:0x151A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x151A
  ,simpleLowerCaseMapping:0x151A
  ,simpleTitleCaseMapping:0x151A
 },
 { code:0x151B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x151B
  ,simpleLowerCaseMapping:0x151B
  ,simpleTitleCaseMapping:0x151B
 },
 { code:0x151C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x151C
  ,simpleLowerCaseMapping:0x151C
  ,simpleTitleCaseMapping:0x151C
 },
 { code:0x151D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x151D
  ,simpleLowerCaseMapping:0x151D
  ,simpleTitleCaseMapping:0x151D
 },
 { code:0x151E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x151E
  ,simpleLowerCaseMapping:0x151E
  ,simpleTitleCaseMapping:0x151E
 },
 { code:0x151F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x151F
  ,simpleLowerCaseMapping:0x151F
  ,simpleTitleCaseMapping:0x151F
 },
 { code:0x1520
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1520
  ,simpleLowerCaseMapping:0x1520
  ,simpleTitleCaseMapping:0x1520
 },
 { code:0x1521
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1521
  ,simpleLowerCaseMapping:0x1521
  ,simpleTitleCaseMapping:0x1521
 },
 { code:0x1522
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1522
  ,simpleLowerCaseMapping:0x1522
  ,simpleTitleCaseMapping:0x1522
 },
 { code:0x1523
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1523
  ,simpleLowerCaseMapping:0x1523
  ,simpleTitleCaseMapping:0x1523
 },
 { code:0x1524
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1524
  ,simpleLowerCaseMapping:0x1524
  ,simpleTitleCaseMapping:0x1524
 },
 { code:0x1525
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1525
  ,simpleLowerCaseMapping:0x1525
  ,simpleTitleCaseMapping:0x1525
 },
 { code:0x1526
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1526
  ,simpleLowerCaseMapping:0x1526
  ,simpleTitleCaseMapping:0x1526
 },
 { code:0x1527
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1527
  ,simpleLowerCaseMapping:0x1527
  ,simpleTitleCaseMapping:0x1527
 },
 { code:0x1528
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1528
  ,simpleLowerCaseMapping:0x1528
  ,simpleTitleCaseMapping:0x1528
 },
 { code:0x1529
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1529
  ,simpleLowerCaseMapping:0x1529
  ,simpleTitleCaseMapping:0x1529
 },
 { code:0x152A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x152A
  ,simpleLowerCaseMapping:0x152A
  ,simpleTitleCaseMapping:0x152A
 },
 { code:0x152B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x152B
  ,simpleLowerCaseMapping:0x152B
  ,simpleTitleCaseMapping:0x152B
 },
 { code:0x152C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x152C
  ,simpleLowerCaseMapping:0x152C
  ,simpleTitleCaseMapping:0x152C
 },
 { code:0x152D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x152D
  ,simpleLowerCaseMapping:0x152D
  ,simpleTitleCaseMapping:0x152D
 },
 { code:0x152E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x152E
  ,simpleLowerCaseMapping:0x152E
  ,simpleTitleCaseMapping:0x152E
 },
 { code:0x152F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x152F
  ,simpleLowerCaseMapping:0x152F
  ,simpleTitleCaseMapping:0x152F
 },
 { code:0x1530
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1530
  ,simpleLowerCaseMapping:0x1530
  ,simpleTitleCaseMapping:0x1530
 },
 { code:0x1531
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1531
  ,simpleLowerCaseMapping:0x1531
  ,simpleTitleCaseMapping:0x1531
 },
 { code:0x1532
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1532
  ,simpleLowerCaseMapping:0x1532
  ,simpleTitleCaseMapping:0x1532
 },
 { code:0x1533
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1533
  ,simpleLowerCaseMapping:0x1533
  ,simpleTitleCaseMapping:0x1533
 },
 { code:0x1534
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1534
  ,simpleLowerCaseMapping:0x1534
  ,simpleTitleCaseMapping:0x1534
 },
 { code:0x1535
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1535
  ,simpleLowerCaseMapping:0x1535
  ,simpleTitleCaseMapping:0x1535
 },
 { code:0x1536
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1536
  ,simpleLowerCaseMapping:0x1536
  ,simpleTitleCaseMapping:0x1536
 },
 { code:0x1537
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1537
  ,simpleLowerCaseMapping:0x1537
  ,simpleTitleCaseMapping:0x1537
 },
 { code:0x1538
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1538
  ,simpleLowerCaseMapping:0x1538
  ,simpleTitleCaseMapping:0x1538
 },
 { code:0x1539
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1539
  ,simpleLowerCaseMapping:0x1539
  ,simpleTitleCaseMapping:0x1539
 },
 { code:0x153A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x153A
  ,simpleLowerCaseMapping:0x153A
  ,simpleTitleCaseMapping:0x153A
 },
 { code:0x153B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x153B
  ,simpleLowerCaseMapping:0x153B
  ,simpleTitleCaseMapping:0x153B
 },
 { code:0x153C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x153C
  ,simpleLowerCaseMapping:0x153C
  ,simpleTitleCaseMapping:0x153C
 },
 { code:0x153D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x153D
  ,simpleLowerCaseMapping:0x153D
  ,simpleTitleCaseMapping:0x153D
 },
 { code:0x153E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x153E
  ,simpleLowerCaseMapping:0x153E
  ,simpleTitleCaseMapping:0x153E
 },
 { code:0x153F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x153F
  ,simpleLowerCaseMapping:0x153F
  ,simpleTitleCaseMapping:0x153F
 },
 { code:0x1540
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1540
  ,simpleLowerCaseMapping:0x1540
  ,simpleTitleCaseMapping:0x1540
 },
 { code:0x1541
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1541
  ,simpleLowerCaseMapping:0x1541
  ,simpleTitleCaseMapping:0x1541
 },
 { code:0x1542
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1542
  ,simpleLowerCaseMapping:0x1542
  ,simpleTitleCaseMapping:0x1542
 },
 { code:0x1543
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1543
  ,simpleLowerCaseMapping:0x1543
  ,simpleTitleCaseMapping:0x1543
 },
 { code:0x1544
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1544
  ,simpleLowerCaseMapping:0x1544
  ,simpleTitleCaseMapping:0x1544
 },
 { code:0x1545
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1545
  ,simpleLowerCaseMapping:0x1545
  ,simpleTitleCaseMapping:0x1545
 },
 { code:0x1546
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1546
  ,simpleLowerCaseMapping:0x1546
  ,simpleTitleCaseMapping:0x1546
 },
 { code:0x1547
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1547
  ,simpleLowerCaseMapping:0x1547
  ,simpleTitleCaseMapping:0x1547
 },
 { code:0x1548
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1548
  ,simpleLowerCaseMapping:0x1548
  ,simpleTitleCaseMapping:0x1548
 },
 { code:0x1549
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1549
  ,simpleLowerCaseMapping:0x1549
  ,simpleTitleCaseMapping:0x1549
 },
 { code:0x154A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x154A
  ,simpleLowerCaseMapping:0x154A
  ,simpleTitleCaseMapping:0x154A
 },
 { code:0x154B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x154B
  ,simpleLowerCaseMapping:0x154B
  ,simpleTitleCaseMapping:0x154B
 },
 { code:0x154C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x154C
  ,simpleLowerCaseMapping:0x154C
  ,simpleTitleCaseMapping:0x154C
 },
 { code:0x154D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x154D
  ,simpleLowerCaseMapping:0x154D
  ,simpleTitleCaseMapping:0x154D
 },
 { code:0x154E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x154E
  ,simpleLowerCaseMapping:0x154E
  ,simpleTitleCaseMapping:0x154E
 },
 { code:0x154F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x154F
  ,simpleLowerCaseMapping:0x154F
  ,simpleTitleCaseMapping:0x154F
 },
 { code:0x1550
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1550
  ,simpleLowerCaseMapping:0x1550
  ,simpleTitleCaseMapping:0x1550
 },
 { code:0x1551
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1551
  ,simpleLowerCaseMapping:0x1551
  ,simpleTitleCaseMapping:0x1551
 },
 { code:0x1552
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1552
  ,simpleLowerCaseMapping:0x1552
  ,simpleTitleCaseMapping:0x1552
 },
 { code:0x1553
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1553
  ,simpleLowerCaseMapping:0x1553
  ,simpleTitleCaseMapping:0x1553
 },
 { code:0x1554
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1554
  ,simpleLowerCaseMapping:0x1554
  ,simpleTitleCaseMapping:0x1554
 },
 { code:0x1555
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1555
  ,simpleLowerCaseMapping:0x1555
  ,simpleTitleCaseMapping:0x1555
 },
 { code:0x1556
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1556
  ,simpleLowerCaseMapping:0x1556
  ,simpleTitleCaseMapping:0x1556
 },
 { code:0x1557
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1557
  ,simpleLowerCaseMapping:0x1557
  ,simpleTitleCaseMapping:0x1557
 },
 { code:0x1558
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1558
  ,simpleLowerCaseMapping:0x1558
  ,simpleTitleCaseMapping:0x1558
 },
 { code:0x1559
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1559
  ,simpleLowerCaseMapping:0x1559
  ,simpleTitleCaseMapping:0x1559
 },
 { code:0x155A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x155A
  ,simpleLowerCaseMapping:0x155A
  ,simpleTitleCaseMapping:0x155A
 },
 { code:0x155B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x155B
  ,simpleLowerCaseMapping:0x155B
  ,simpleTitleCaseMapping:0x155B
 },
 { code:0x155C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x155C
  ,simpleLowerCaseMapping:0x155C
  ,simpleTitleCaseMapping:0x155C
 },
 { code:0x155D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x155D
  ,simpleLowerCaseMapping:0x155D
  ,simpleTitleCaseMapping:0x155D
 },
 { code:0x155E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x155E
  ,simpleLowerCaseMapping:0x155E
  ,simpleTitleCaseMapping:0x155E
 },
 { code:0x155F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x155F
  ,simpleLowerCaseMapping:0x155F
  ,simpleTitleCaseMapping:0x155F
 },
 { code:0x1560
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1560
  ,simpleLowerCaseMapping:0x1560
  ,simpleTitleCaseMapping:0x1560
 },
 { code:0x1561
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1561
  ,simpleLowerCaseMapping:0x1561
  ,simpleTitleCaseMapping:0x1561
 },
 { code:0x1562
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1562
  ,simpleLowerCaseMapping:0x1562
  ,simpleTitleCaseMapping:0x1562
 },
 { code:0x1563
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1563
  ,simpleLowerCaseMapping:0x1563
  ,simpleTitleCaseMapping:0x1563
 },
 { code:0x1564
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1564
  ,simpleLowerCaseMapping:0x1564
  ,simpleTitleCaseMapping:0x1564
 },
 { code:0x1565
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1565
  ,simpleLowerCaseMapping:0x1565
  ,simpleTitleCaseMapping:0x1565
 },
 { code:0x1566
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1566
  ,simpleLowerCaseMapping:0x1566
  ,simpleTitleCaseMapping:0x1566
 },
 { code:0x1567
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1567
  ,simpleLowerCaseMapping:0x1567
  ,simpleTitleCaseMapping:0x1567
 },
 { code:0x1568
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1568
  ,simpleLowerCaseMapping:0x1568
  ,simpleTitleCaseMapping:0x1568
 },
 { code:0x1569
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1569
  ,simpleLowerCaseMapping:0x1569
  ,simpleTitleCaseMapping:0x1569
 },
 { code:0x156A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x156A
  ,simpleLowerCaseMapping:0x156A
  ,simpleTitleCaseMapping:0x156A
 },
 { code:0x156B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x156B
  ,simpleLowerCaseMapping:0x156B
  ,simpleTitleCaseMapping:0x156B
 },
 { code:0x156C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x156C
  ,simpleLowerCaseMapping:0x156C
  ,simpleTitleCaseMapping:0x156C
 },
 { code:0x156D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x156D
  ,simpleLowerCaseMapping:0x156D
  ,simpleTitleCaseMapping:0x156D
 },
 { code:0x156E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x156E
  ,simpleLowerCaseMapping:0x156E
  ,simpleTitleCaseMapping:0x156E
 },
 { code:0x156F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x156F
  ,simpleLowerCaseMapping:0x156F
  ,simpleTitleCaseMapping:0x156F
 },
 { code:0x1570
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1570
  ,simpleLowerCaseMapping:0x1570
  ,simpleTitleCaseMapping:0x1570
 },
 { code:0x1571
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1571
  ,simpleLowerCaseMapping:0x1571
  ,simpleTitleCaseMapping:0x1571
 },
 { code:0x1572
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1572
  ,simpleLowerCaseMapping:0x1572
  ,simpleTitleCaseMapping:0x1572
 },
 { code:0x1573
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1573
  ,simpleLowerCaseMapping:0x1573
  ,simpleTitleCaseMapping:0x1573
 },
 { code:0x1574
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1574
  ,simpleLowerCaseMapping:0x1574
  ,simpleTitleCaseMapping:0x1574
 },
 { code:0x1575
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1575
  ,simpleLowerCaseMapping:0x1575
  ,simpleTitleCaseMapping:0x1575
 },
 { code:0x1576
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1576
  ,simpleLowerCaseMapping:0x1576
  ,simpleTitleCaseMapping:0x1576
 },
 { code:0x1577
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1577
  ,simpleLowerCaseMapping:0x1577
  ,simpleTitleCaseMapping:0x1577
 },
 { code:0x1578
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1578
  ,simpleLowerCaseMapping:0x1578
  ,simpleTitleCaseMapping:0x1578
 },
 { code:0x1579
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1579
  ,simpleLowerCaseMapping:0x1579
  ,simpleTitleCaseMapping:0x1579
 },
 { code:0x157A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x157A
  ,simpleLowerCaseMapping:0x157A
  ,simpleTitleCaseMapping:0x157A
 },
 { code:0x157B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x157B
  ,simpleLowerCaseMapping:0x157B
  ,simpleTitleCaseMapping:0x157B
 },
 { code:0x157C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x157C
  ,simpleLowerCaseMapping:0x157C
  ,simpleTitleCaseMapping:0x157C
 },
 { code:0x157D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x157D
  ,simpleLowerCaseMapping:0x157D
  ,simpleTitleCaseMapping:0x157D
 },
 { code:0x157E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x157E
  ,simpleLowerCaseMapping:0x157E
  ,simpleTitleCaseMapping:0x157E
 },
 { code:0x157F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x157F
  ,simpleLowerCaseMapping:0x157F
  ,simpleTitleCaseMapping:0x157F
 },
 { code:0x1580
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1580
  ,simpleLowerCaseMapping:0x1580
  ,simpleTitleCaseMapping:0x1580
 },
 { code:0x1581
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1581
  ,simpleLowerCaseMapping:0x1581
  ,simpleTitleCaseMapping:0x1581
 },
 { code:0x1582
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1582
  ,simpleLowerCaseMapping:0x1582
  ,simpleTitleCaseMapping:0x1582
 },
 { code:0x1583
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1583
  ,simpleLowerCaseMapping:0x1583
  ,simpleTitleCaseMapping:0x1583
 },
 { code:0x1584
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1584
  ,simpleLowerCaseMapping:0x1584
  ,simpleTitleCaseMapping:0x1584
 },
 { code:0x1585
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1585
  ,simpleLowerCaseMapping:0x1585
  ,simpleTitleCaseMapping:0x1585
 },
 { code:0x1586
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1586
  ,simpleLowerCaseMapping:0x1586
  ,simpleTitleCaseMapping:0x1586
 },
 { code:0x1587
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1587
  ,simpleLowerCaseMapping:0x1587
  ,simpleTitleCaseMapping:0x1587
 },
 { code:0x1588
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1588
  ,simpleLowerCaseMapping:0x1588
  ,simpleTitleCaseMapping:0x1588
 },
 { code:0x1589
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1589
  ,simpleLowerCaseMapping:0x1589
  ,simpleTitleCaseMapping:0x1589
 },
 { code:0x158A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x158A
  ,simpleLowerCaseMapping:0x158A
  ,simpleTitleCaseMapping:0x158A
 },
 { code:0x158B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x158B
  ,simpleLowerCaseMapping:0x158B
  ,simpleTitleCaseMapping:0x158B
 },
 { code:0x158C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x158C
  ,simpleLowerCaseMapping:0x158C
  ,simpleTitleCaseMapping:0x158C
 },
 { code:0x158D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x158D
  ,simpleLowerCaseMapping:0x158D
  ,simpleTitleCaseMapping:0x158D
 },
 { code:0x158E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x158E
  ,simpleLowerCaseMapping:0x158E
  ,simpleTitleCaseMapping:0x158E
 },
 { code:0x158F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x158F
  ,simpleLowerCaseMapping:0x158F
  ,simpleTitleCaseMapping:0x158F
 },
 { code:0x1590
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1590
  ,simpleLowerCaseMapping:0x1590
  ,simpleTitleCaseMapping:0x1590
 },
 { code:0x1591
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1591
  ,simpleLowerCaseMapping:0x1591
  ,simpleTitleCaseMapping:0x1591
 },
 { code:0x1592
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1592
  ,simpleLowerCaseMapping:0x1592
  ,simpleTitleCaseMapping:0x1592
 },
 { code:0x1593
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1593
  ,simpleLowerCaseMapping:0x1593
  ,simpleTitleCaseMapping:0x1593
 },
 { code:0x1594
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1594
  ,simpleLowerCaseMapping:0x1594
  ,simpleTitleCaseMapping:0x1594
 },
 { code:0x1595
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1595
  ,simpleLowerCaseMapping:0x1595
  ,simpleTitleCaseMapping:0x1595
 },
 { code:0x1596
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1596
  ,simpleLowerCaseMapping:0x1596
  ,simpleTitleCaseMapping:0x1596
 },
 { code:0x1597
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1597
  ,simpleLowerCaseMapping:0x1597
  ,simpleTitleCaseMapping:0x1597
 },
 { code:0x1598
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1598
  ,simpleLowerCaseMapping:0x1598
  ,simpleTitleCaseMapping:0x1598
 },
 { code:0x1599
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1599
  ,simpleLowerCaseMapping:0x1599
  ,simpleTitleCaseMapping:0x1599
 },
 { code:0x159A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x159A
  ,simpleLowerCaseMapping:0x159A
  ,simpleTitleCaseMapping:0x159A
 },
 { code:0x159B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x159B
  ,simpleLowerCaseMapping:0x159B
  ,simpleTitleCaseMapping:0x159B
 },
 { code:0x159C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x159C
  ,simpleLowerCaseMapping:0x159C
  ,simpleTitleCaseMapping:0x159C
 },
 { code:0x159D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x159D
  ,simpleLowerCaseMapping:0x159D
  ,simpleTitleCaseMapping:0x159D
 },
 { code:0x159E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x159E
  ,simpleLowerCaseMapping:0x159E
  ,simpleTitleCaseMapping:0x159E
 },
 { code:0x159F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x159F
  ,simpleLowerCaseMapping:0x159F
  ,simpleTitleCaseMapping:0x159F
 },
 { code:0x15A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15A0
  ,simpleLowerCaseMapping:0x15A0
  ,simpleTitleCaseMapping:0x15A0
 },
 { code:0x15A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15A1
  ,simpleLowerCaseMapping:0x15A1
  ,simpleTitleCaseMapping:0x15A1
 },
 { code:0x15A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15A2
  ,simpleLowerCaseMapping:0x15A2
  ,simpleTitleCaseMapping:0x15A2
 },
 { code:0x15A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15A3
  ,simpleLowerCaseMapping:0x15A3
  ,simpleTitleCaseMapping:0x15A3
 },
 { code:0x15A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15A4
  ,simpleLowerCaseMapping:0x15A4
  ,simpleTitleCaseMapping:0x15A4
 },
 { code:0x15A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15A5
  ,simpleLowerCaseMapping:0x15A5
  ,simpleTitleCaseMapping:0x15A5
 },
 { code:0x15A6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15A6
  ,simpleLowerCaseMapping:0x15A6
  ,simpleTitleCaseMapping:0x15A6
 },
 { code:0x15A7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15A7
  ,simpleLowerCaseMapping:0x15A7
  ,simpleTitleCaseMapping:0x15A7
 },
 { code:0x15A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15A8
  ,simpleLowerCaseMapping:0x15A8
  ,simpleTitleCaseMapping:0x15A8
 },
 { code:0x15A9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15A9
  ,simpleLowerCaseMapping:0x15A9
  ,simpleTitleCaseMapping:0x15A9
 },
 { code:0x15AA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15AA
  ,simpleLowerCaseMapping:0x15AA
  ,simpleTitleCaseMapping:0x15AA
 },
 { code:0x15AB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15AB
  ,simpleLowerCaseMapping:0x15AB
  ,simpleTitleCaseMapping:0x15AB
 },
 { code:0x15AC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15AC
  ,simpleLowerCaseMapping:0x15AC
  ,simpleTitleCaseMapping:0x15AC
 },
 { code:0x15AD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15AD
  ,simpleLowerCaseMapping:0x15AD
  ,simpleTitleCaseMapping:0x15AD
 },
 { code:0x15AE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15AE
  ,simpleLowerCaseMapping:0x15AE
  ,simpleTitleCaseMapping:0x15AE
 },
 { code:0x15AF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15AF
  ,simpleLowerCaseMapping:0x15AF
  ,simpleTitleCaseMapping:0x15AF
 },
 { code:0x15B0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15B0
  ,simpleLowerCaseMapping:0x15B0
  ,simpleTitleCaseMapping:0x15B0
 },
 { code:0x15B1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15B1
  ,simpleLowerCaseMapping:0x15B1
  ,simpleTitleCaseMapping:0x15B1
 },
 { code:0x15B2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15B2
  ,simpleLowerCaseMapping:0x15B2
  ,simpleTitleCaseMapping:0x15B2
 },
 { code:0x15B3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15B3
  ,simpleLowerCaseMapping:0x15B3
  ,simpleTitleCaseMapping:0x15B3
 },
 { code:0x15B4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15B4
  ,simpleLowerCaseMapping:0x15B4
  ,simpleTitleCaseMapping:0x15B4
 },
 { code:0x15B5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15B5
  ,simpleLowerCaseMapping:0x15B5
  ,simpleTitleCaseMapping:0x15B5
 },
 { code:0x15B6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15B6
  ,simpleLowerCaseMapping:0x15B6
  ,simpleTitleCaseMapping:0x15B6
 },
 { code:0x15B7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15B7
  ,simpleLowerCaseMapping:0x15B7
  ,simpleTitleCaseMapping:0x15B7
 },
 { code:0x15B8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15B8
  ,simpleLowerCaseMapping:0x15B8
  ,simpleTitleCaseMapping:0x15B8
 },
 { code:0x15B9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15B9
  ,simpleLowerCaseMapping:0x15B9
  ,simpleTitleCaseMapping:0x15B9
 },
 { code:0x15BA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15BA
  ,simpleLowerCaseMapping:0x15BA
  ,simpleTitleCaseMapping:0x15BA
 },
 { code:0x15BB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15BB
  ,simpleLowerCaseMapping:0x15BB
  ,simpleTitleCaseMapping:0x15BB
 },
 { code:0x15BC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15BC
  ,simpleLowerCaseMapping:0x15BC
  ,simpleTitleCaseMapping:0x15BC
 },
 { code:0x15BD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15BD
  ,simpleLowerCaseMapping:0x15BD
  ,simpleTitleCaseMapping:0x15BD
 },
 { code:0x15BE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15BE
  ,simpleLowerCaseMapping:0x15BE
  ,simpleTitleCaseMapping:0x15BE
 },
 { code:0x15BF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15BF
  ,simpleLowerCaseMapping:0x15BF
  ,simpleTitleCaseMapping:0x15BF
 },
 { code:0x15C0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15C0
  ,simpleLowerCaseMapping:0x15C0
  ,simpleTitleCaseMapping:0x15C0
 },
 { code:0x15C1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15C1
  ,simpleLowerCaseMapping:0x15C1
  ,simpleTitleCaseMapping:0x15C1
 },
 { code:0x15C2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15C2
  ,simpleLowerCaseMapping:0x15C2
  ,simpleTitleCaseMapping:0x15C2
 },
 { code:0x15C3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15C3
  ,simpleLowerCaseMapping:0x15C3
  ,simpleTitleCaseMapping:0x15C3
 },
 { code:0x15C4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15C4
  ,simpleLowerCaseMapping:0x15C4
  ,simpleTitleCaseMapping:0x15C4
 },
 { code:0x15C5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15C5
  ,simpleLowerCaseMapping:0x15C5
  ,simpleTitleCaseMapping:0x15C5
 },
 { code:0x15C6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15C6
  ,simpleLowerCaseMapping:0x15C6
  ,simpleTitleCaseMapping:0x15C6
 },
 { code:0x15C7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15C7
  ,simpleLowerCaseMapping:0x15C7
  ,simpleTitleCaseMapping:0x15C7
 },
 { code:0x15C8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15C8
  ,simpleLowerCaseMapping:0x15C8
  ,simpleTitleCaseMapping:0x15C8
 },
 { code:0x15C9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15C9
  ,simpleLowerCaseMapping:0x15C9
  ,simpleTitleCaseMapping:0x15C9
 },
 { code:0x15CA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15CA
  ,simpleLowerCaseMapping:0x15CA
  ,simpleTitleCaseMapping:0x15CA
 },
 { code:0x15CB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15CB
  ,simpleLowerCaseMapping:0x15CB
  ,simpleTitleCaseMapping:0x15CB
 },
 { code:0x15CC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15CC
  ,simpleLowerCaseMapping:0x15CC
  ,simpleTitleCaseMapping:0x15CC
 },
 { code:0x15CD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15CD
  ,simpleLowerCaseMapping:0x15CD
  ,simpleTitleCaseMapping:0x15CD
 },
 { code:0x15CE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15CE
  ,simpleLowerCaseMapping:0x15CE
  ,simpleTitleCaseMapping:0x15CE
 },
 { code:0x15CF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15CF
  ,simpleLowerCaseMapping:0x15CF
  ,simpleTitleCaseMapping:0x15CF
 },
 { code:0x15D0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15D0
  ,simpleLowerCaseMapping:0x15D0
  ,simpleTitleCaseMapping:0x15D0
 },
 { code:0x15D1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15D1
  ,simpleLowerCaseMapping:0x15D1
  ,simpleTitleCaseMapping:0x15D1
 },
 { code:0x15D2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15D2
  ,simpleLowerCaseMapping:0x15D2
  ,simpleTitleCaseMapping:0x15D2
 },
 { code:0x15D3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15D3
  ,simpleLowerCaseMapping:0x15D3
  ,simpleTitleCaseMapping:0x15D3
 },
 { code:0x15D4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15D4
  ,simpleLowerCaseMapping:0x15D4
  ,simpleTitleCaseMapping:0x15D4
 },
 { code:0x15D5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15D5
  ,simpleLowerCaseMapping:0x15D5
  ,simpleTitleCaseMapping:0x15D5
 },
 { code:0x15D6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15D6
  ,simpleLowerCaseMapping:0x15D6
  ,simpleTitleCaseMapping:0x15D6
 },
 { code:0x15D7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15D7
  ,simpleLowerCaseMapping:0x15D7
  ,simpleTitleCaseMapping:0x15D7
 },
 { code:0x15D8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15D8
  ,simpleLowerCaseMapping:0x15D8
  ,simpleTitleCaseMapping:0x15D8
 },
 { code:0x15D9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15D9
  ,simpleLowerCaseMapping:0x15D9
  ,simpleTitleCaseMapping:0x15D9
 },
 { code:0x15DA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15DA
  ,simpleLowerCaseMapping:0x15DA
  ,simpleTitleCaseMapping:0x15DA
 },
 { code:0x15DB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15DB
  ,simpleLowerCaseMapping:0x15DB
  ,simpleTitleCaseMapping:0x15DB
 },
 { code:0x15DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15DC
  ,simpleLowerCaseMapping:0x15DC
  ,simpleTitleCaseMapping:0x15DC
 },
 { code:0x15DD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15DD
  ,simpleLowerCaseMapping:0x15DD
  ,simpleTitleCaseMapping:0x15DD
 },
 { code:0x15DE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15DE
  ,simpleLowerCaseMapping:0x15DE
  ,simpleTitleCaseMapping:0x15DE
 },
 { code:0x15DF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15DF
  ,simpleLowerCaseMapping:0x15DF
  ,simpleTitleCaseMapping:0x15DF
 },
 { code:0x15E0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15E0
  ,simpleLowerCaseMapping:0x15E0
  ,simpleTitleCaseMapping:0x15E0
 },
 { code:0x15E1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15E1
  ,simpleLowerCaseMapping:0x15E1
  ,simpleTitleCaseMapping:0x15E1
 },
 { code:0x15E2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15E2
  ,simpleLowerCaseMapping:0x15E2
  ,simpleTitleCaseMapping:0x15E2
 },
 { code:0x15E3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15E3
  ,simpleLowerCaseMapping:0x15E3
  ,simpleTitleCaseMapping:0x15E3
 },
 { code:0x15E4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15E4
  ,simpleLowerCaseMapping:0x15E4
  ,simpleTitleCaseMapping:0x15E4
 },
 { code:0x15E5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15E5
  ,simpleLowerCaseMapping:0x15E5
  ,simpleTitleCaseMapping:0x15E5
 },
 { code:0x15E6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15E6
  ,simpleLowerCaseMapping:0x15E6
  ,simpleTitleCaseMapping:0x15E6
 },
 { code:0x15E7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15E7
  ,simpleLowerCaseMapping:0x15E7
  ,simpleTitleCaseMapping:0x15E7
 },
 { code:0x15E8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15E8
  ,simpleLowerCaseMapping:0x15E8
  ,simpleTitleCaseMapping:0x15E8
 },
 { code:0x15E9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15E9
  ,simpleLowerCaseMapping:0x15E9
  ,simpleTitleCaseMapping:0x15E9
 },
 { code:0x15EA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15EA
  ,simpleLowerCaseMapping:0x15EA
  ,simpleTitleCaseMapping:0x15EA
 },
 { code:0x15EB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15EB
  ,simpleLowerCaseMapping:0x15EB
  ,simpleTitleCaseMapping:0x15EB
 },
 { code:0x15EC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15EC
  ,simpleLowerCaseMapping:0x15EC
  ,simpleTitleCaseMapping:0x15EC
 },
 { code:0x15ED
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15ED
  ,simpleLowerCaseMapping:0x15ED
  ,simpleTitleCaseMapping:0x15ED
 },
 { code:0x15EE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15EE
  ,simpleLowerCaseMapping:0x15EE
  ,simpleTitleCaseMapping:0x15EE
 },
 { code:0x15EF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15EF
  ,simpleLowerCaseMapping:0x15EF
  ,simpleTitleCaseMapping:0x15EF
 },
 { code:0x15F0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15F0
  ,simpleLowerCaseMapping:0x15F0
  ,simpleTitleCaseMapping:0x15F0
 },
 { code:0x15F1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15F1
  ,simpleLowerCaseMapping:0x15F1
  ,simpleTitleCaseMapping:0x15F1
 },
 { code:0x15F2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15F2
  ,simpleLowerCaseMapping:0x15F2
  ,simpleTitleCaseMapping:0x15F2
 },
 { code:0x15F3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15F3
  ,simpleLowerCaseMapping:0x15F3
  ,simpleTitleCaseMapping:0x15F3
 },
 { code:0x15F4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15F4
  ,simpleLowerCaseMapping:0x15F4
  ,simpleTitleCaseMapping:0x15F4
 },
 { code:0x15F5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15F5
  ,simpleLowerCaseMapping:0x15F5
  ,simpleTitleCaseMapping:0x15F5
 },
 { code:0x15F6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15F6
  ,simpleLowerCaseMapping:0x15F6
  ,simpleTitleCaseMapping:0x15F6
 },
 { code:0x15F7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15F7
  ,simpleLowerCaseMapping:0x15F7
  ,simpleTitleCaseMapping:0x15F7
 },
 { code:0x15F8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15F8
  ,simpleLowerCaseMapping:0x15F8
  ,simpleTitleCaseMapping:0x15F8
 },
 { code:0x15F9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15F9
  ,simpleLowerCaseMapping:0x15F9
  ,simpleTitleCaseMapping:0x15F9
 },
 { code:0x15FA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15FA
  ,simpleLowerCaseMapping:0x15FA
  ,simpleTitleCaseMapping:0x15FA
 },
 { code:0x15FB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15FB
  ,simpleLowerCaseMapping:0x15FB
  ,simpleTitleCaseMapping:0x15FB
 },
 { code:0x15FC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15FC
  ,simpleLowerCaseMapping:0x15FC
  ,simpleTitleCaseMapping:0x15FC
 },
 { code:0x15FD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15FD
  ,simpleLowerCaseMapping:0x15FD
  ,simpleTitleCaseMapping:0x15FD
 },
 { code:0x15FE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15FE
  ,simpleLowerCaseMapping:0x15FE
  ,simpleTitleCaseMapping:0x15FE
 },
 { code:0x15FF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x15FF
  ,simpleLowerCaseMapping:0x15FF
  ,simpleTitleCaseMapping:0x15FF
 },
 { code:0x1600
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1600
  ,simpleLowerCaseMapping:0x1600
  ,simpleTitleCaseMapping:0x1600
 },
 { code:0x1601
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1601
  ,simpleLowerCaseMapping:0x1601
  ,simpleTitleCaseMapping:0x1601
 },
 { code:0x1602
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1602
  ,simpleLowerCaseMapping:0x1602
  ,simpleTitleCaseMapping:0x1602
 },
 { code:0x1603
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1603
  ,simpleLowerCaseMapping:0x1603
  ,simpleTitleCaseMapping:0x1603
 },
 { code:0x1604
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1604
  ,simpleLowerCaseMapping:0x1604
  ,simpleTitleCaseMapping:0x1604
 },
 { code:0x1605
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1605
  ,simpleLowerCaseMapping:0x1605
  ,simpleTitleCaseMapping:0x1605
 },
 { code:0x1606
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1606
  ,simpleLowerCaseMapping:0x1606
  ,simpleTitleCaseMapping:0x1606
 },
 { code:0x1607
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1607
  ,simpleLowerCaseMapping:0x1607
  ,simpleTitleCaseMapping:0x1607
 },
 { code:0x1608
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1608
  ,simpleLowerCaseMapping:0x1608
  ,simpleTitleCaseMapping:0x1608
 },
 { code:0x1609
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1609
  ,simpleLowerCaseMapping:0x1609
  ,simpleTitleCaseMapping:0x1609
 },
 { code:0x160A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x160A
  ,simpleLowerCaseMapping:0x160A
  ,simpleTitleCaseMapping:0x160A
 },
 { code:0x160B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x160B
  ,simpleLowerCaseMapping:0x160B
  ,simpleTitleCaseMapping:0x160B
 },
 { code:0x160C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x160C
  ,simpleLowerCaseMapping:0x160C
  ,simpleTitleCaseMapping:0x160C
 },
 { code:0x160D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x160D
  ,simpleLowerCaseMapping:0x160D
  ,simpleTitleCaseMapping:0x160D
 },
 { code:0x160E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x160E
  ,simpleLowerCaseMapping:0x160E
  ,simpleTitleCaseMapping:0x160E
 },
 { code:0x160F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x160F
  ,simpleLowerCaseMapping:0x160F
  ,simpleTitleCaseMapping:0x160F
 },
 { code:0x1610
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1610
  ,simpleLowerCaseMapping:0x1610
  ,simpleTitleCaseMapping:0x1610
 },
 { code:0x1611
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1611
  ,simpleLowerCaseMapping:0x1611
  ,simpleTitleCaseMapping:0x1611
 },
 { code:0x1612
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1612
  ,simpleLowerCaseMapping:0x1612
  ,simpleTitleCaseMapping:0x1612
 },
 { code:0x1613
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1613
  ,simpleLowerCaseMapping:0x1613
  ,simpleTitleCaseMapping:0x1613
 },
 { code:0x1614
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1614
  ,simpleLowerCaseMapping:0x1614
  ,simpleTitleCaseMapping:0x1614
 },
 { code:0x1615
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1615
  ,simpleLowerCaseMapping:0x1615
  ,simpleTitleCaseMapping:0x1615
 },
 { code:0x1616
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1616
  ,simpleLowerCaseMapping:0x1616
  ,simpleTitleCaseMapping:0x1616
 },
 { code:0x1617
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1617
  ,simpleLowerCaseMapping:0x1617
  ,simpleTitleCaseMapping:0x1617
 },
 { code:0x1618
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1618
  ,simpleLowerCaseMapping:0x1618
  ,simpleTitleCaseMapping:0x1618
 },
 { code:0x1619
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1619
  ,simpleLowerCaseMapping:0x1619
  ,simpleTitleCaseMapping:0x1619
 },
 { code:0x161A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x161A
  ,simpleLowerCaseMapping:0x161A
  ,simpleTitleCaseMapping:0x161A
 },
 { code:0x161B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x161B
  ,simpleLowerCaseMapping:0x161B
  ,simpleTitleCaseMapping:0x161B
 },
 { code:0x161C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x161C
  ,simpleLowerCaseMapping:0x161C
  ,simpleTitleCaseMapping:0x161C
 },
 { code:0x161D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x161D
  ,simpleLowerCaseMapping:0x161D
  ,simpleTitleCaseMapping:0x161D
 },
 { code:0x161E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x161E
  ,simpleLowerCaseMapping:0x161E
  ,simpleTitleCaseMapping:0x161E
 },
 { code:0x161F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x161F
  ,simpleLowerCaseMapping:0x161F
  ,simpleTitleCaseMapping:0x161F
 },
 { code:0x1620
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1620
  ,simpleLowerCaseMapping:0x1620
  ,simpleTitleCaseMapping:0x1620
 },
 { code:0x1621
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1621
  ,simpleLowerCaseMapping:0x1621
  ,simpleTitleCaseMapping:0x1621
 },
 { code:0x1622
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1622
  ,simpleLowerCaseMapping:0x1622
  ,simpleTitleCaseMapping:0x1622
 },
 { code:0x1623
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1623
  ,simpleLowerCaseMapping:0x1623
  ,simpleTitleCaseMapping:0x1623
 },
 { code:0x1624
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1624
  ,simpleLowerCaseMapping:0x1624
  ,simpleTitleCaseMapping:0x1624
 },
 { code:0x1625
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1625
  ,simpleLowerCaseMapping:0x1625
  ,simpleTitleCaseMapping:0x1625
 },
 { code:0x1626
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1626
  ,simpleLowerCaseMapping:0x1626
  ,simpleTitleCaseMapping:0x1626
 },
 { code:0x1627
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1627
  ,simpleLowerCaseMapping:0x1627
  ,simpleTitleCaseMapping:0x1627
 },
 { code:0x1628
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1628
  ,simpleLowerCaseMapping:0x1628
  ,simpleTitleCaseMapping:0x1628
 },
 { code:0x1629
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1629
  ,simpleLowerCaseMapping:0x1629
  ,simpleTitleCaseMapping:0x1629
 },
 { code:0x162A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x162A
  ,simpleLowerCaseMapping:0x162A
  ,simpleTitleCaseMapping:0x162A
 },
 { code:0x162B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x162B
  ,simpleLowerCaseMapping:0x162B
  ,simpleTitleCaseMapping:0x162B
 },
 { code:0x162C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x162C
  ,simpleLowerCaseMapping:0x162C
  ,simpleTitleCaseMapping:0x162C
 },
 { code:0x162D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x162D
  ,simpleLowerCaseMapping:0x162D
  ,simpleTitleCaseMapping:0x162D
 },
 { code:0x162E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x162E
  ,simpleLowerCaseMapping:0x162E
  ,simpleTitleCaseMapping:0x162E
 },
 { code:0x162F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x162F
  ,simpleLowerCaseMapping:0x162F
  ,simpleTitleCaseMapping:0x162F
 },
 { code:0x1630
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1630
  ,simpleLowerCaseMapping:0x1630
  ,simpleTitleCaseMapping:0x1630
 },
 { code:0x1631
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1631
  ,simpleLowerCaseMapping:0x1631
  ,simpleTitleCaseMapping:0x1631
 },
 { code:0x1632
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1632
  ,simpleLowerCaseMapping:0x1632
  ,simpleTitleCaseMapping:0x1632
 },
 { code:0x1633
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1633
  ,simpleLowerCaseMapping:0x1633
  ,simpleTitleCaseMapping:0x1633
 },
 { code:0x1634
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1634
  ,simpleLowerCaseMapping:0x1634
  ,simpleTitleCaseMapping:0x1634
 },
 { code:0x1635
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1635
  ,simpleLowerCaseMapping:0x1635
  ,simpleTitleCaseMapping:0x1635
 },
 { code:0x1636
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1636
  ,simpleLowerCaseMapping:0x1636
  ,simpleTitleCaseMapping:0x1636
 },
 { code:0x1637
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1637
  ,simpleLowerCaseMapping:0x1637
  ,simpleTitleCaseMapping:0x1637
 },
 { code:0x1638
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1638
  ,simpleLowerCaseMapping:0x1638
  ,simpleTitleCaseMapping:0x1638
 },
 { code:0x1639
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1639
  ,simpleLowerCaseMapping:0x1639
  ,simpleTitleCaseMapping:0x1639
 },
 { code:0x163A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x163A
  ,simpleLowerCaseMapping:0x163A
  ,simpleTitleCaseMapping:0x163A
 },
 { code:0x163B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x163B
  ,simpleLowerCaseMapping:0x163B
  ,simpleTitleCaseMapping:0x163B
 },
 { code:0x163C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x163C
  ,simpleLowerCaseMapping:0x163C
  ,simpleTitleCaseMapping:0x163C
 },
 { code:0x163D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x163D
  ,simpleLowerCaseMapping:0x163D
  ,simpleTitleCaseMapping:0x163D
 },
 { code:0x163E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x163E
  ,simpleLowerCaseMapping:0x163E
  ,simpleTitleCaseMapping:0x163E
 },
 { code:0x163F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x163F
  ,simpleLowerCaseMapping:0x163F
  ,simpleTitleCaseMapping:0x163F
 },
 { code:0x1640
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1640
  ,simpleLowerCaseMapping:0x1640
  ,simpleTitleCaseMapping:0x1640
 },
 { code:0x1641
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1641
  ,simpleLowerCaseMapping:0x1641
  ,simpleTitleCaseMapping:0x1641
 },
 { code:0x1642
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1642
  ,simpleLowerCaseMapping:0x1642
  ,simpleTitleCaseMapping:0x1642
 },
 { code:0x1643
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1643
  ,simpleLowerCaseMapping:0x1643
  ,simpleTitleCaseMapping:0x1643
 },
 { code:0x1644
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1644
  ,simpleLowerCaseMapping:0x1644
  ,simpleTitleCaseMapping:0x1644
 },
 { code:0x1645
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1645
  ,simpleLowerCaseMapping:0x1645
  ,simpleTitleCaseMapping:0x1645
 },
 { code:0x1646
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1646
  ,simpleLowerCaseMapping:0x1646
  ,simpleTitleCaseMapping:0x1646
 },
 { code:0x1647
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1647
  ,simpleLowerCaseMapping:0x1647
  ,simpleTitleCaseMapping:0x1647
 },
 { code:0x1648
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1648
  ,simpleLowerCaseMapping:0x1648
  ,simpleTitleCaseMapping:0x1648
 },
 { code:0x1649
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1649
  ,simpleLowerCaseMapping:0x1649
  ,simpleTitleCaseMapping:0x1649
 },
 { code:0x164A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x164A
  ,simpleLowerCaseMapping:0x164A
  ,simpleTitleCaseMapping:0x164A
 },
 { code:0x164B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x164B
  ,simpleLowerCaseMapping:0x164B
  ,simpleTitleCaseMapping:0x164B
 },
 { code:0x164C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x164C
  ,simpleLowerCaseMapping:0x164C
  ,simpleTitleCaseMapping:0x164C
 },
 { code:0x164D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x164D
  ,simpleLowerCaseMapping:0x164D
  ,simpleTitleCaseMapping:0x164D
 },
 { code:0x164E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x164E
  ,simpleLowerCaseMapping:0x164E
  ,simpleTitleCaseMapping:0x164E
 },
 { code:0x164F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x164F
  ,simpleLowerCaseMapping:0x164F
  ,simpleTitleCaseMapping:0x164F
 },
 { code:0x1650
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1650
  ,simpleLowerCaseMapping:0x1650
  ,simpleTitleCaseMapping:0x1650
 },
 { code:0x1651
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1651
  ,simpleLowerCaseMapping:0x1651
  ,simpleTitleCaseMapping:0x1651
 },
 { code:0x1652
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1652
  ,simpleLowerCaseMapping:0x1652
  ,simpleTitleCaseMapping:0x1652
 },
 { code:0x1653
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1653
  ,simpleLowerCaseMapping:0x1653
  ,simpleTitleCaseMapping:0x1653
 },
 { code:0x1654
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1654
  ,simpleLowerCaseMapping:0x1654
  ,simpleTitleCaseMapping:0x1654
 },
 { code:0x1655
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1655
  ,simpleLowerCaseMapping:0x1655
  ,simpleTitleCaseMapping:0x1655
 },
 { code:0x1656
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1656
  ,simpleLowerCaseMapping:0x1656
  ,simpleTitleCaseMapping:0x1656
 },
 { code:0x1657
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1657
  ,simpleLowerCaseMapping:0x1657
  ,simpleTitleCaseMapping:0x1657
 },
 { code:0x1658
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1658
  ,simpleLowerCaseMapping:0x1658
  ,simpleTitleCaseMapping:0x1658
 },
 { code:0x1659
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1659
  ,simpleLowerCaseMapping:0x1659
  ,simpleTitleCaseMapping:0x1659
 },
 { code:0x165A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x165A
  ,simpleLowerCaseMapping:0x165A
  ,simpleTitleCaseMapping:0x165A
 },
 { code:0x165B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x165B
  ,simpleLowerCaseMapping:0x165B
  ,simpleTitleCaseMapping:0x165B
 },
 { code:0x165C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x165C
  ,simpleLowerCaseMapping:0x165C
  ,simpleTitleCaseMapping:0x165C
 },
 { code:0x165D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x165D
  ,simpleLowerCaseMapping:0x165D
  ,simpleTitleCaseMapping:0x165D
 },
 { code:0x165E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x165E
  ,simpleLowerCaseMapping:0x165E
  ,simpleTitleCaseMapping:0x165E
 },
 { code:0x165F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x165F
  ,simpleLowerCaseMapping:0x165F
  ,simpleTitleCaseMapping:0x165F
 },
 { code:0x1660
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1660
  ,simpleLowerCaseMapping:0x1660
  ,simpleTitleCaseMapping:0x1660
 },
 { code:0x1661
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1661
  ,simpleLowerCaseMapping:0x1661
  ,simpleTitleCaseMapping:0x1661
 },
 { code:0x1662
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1662
  ,simpleLowerCaseMapping:0x1662
  ,simpleTitleCaseMapping:0x1662
 },
 { code:0x1663
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1663
  ,simpleLowerCaseMapping:0x1663
  ,simpleTitleCaseMapping:0x1663
 },
 { code:0x1664
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1664
  ,simpleLowerCaseMapping:0x1664
  ,simpleTitleCaseMapping:0x1664
 },
 { code:0x1665
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1665
  ,simpleLowerCaseMapping:0x1665
  ,simpleTitleCaseMapping:0x1665
 },
 { code:0x1666
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1666
  ,simpleLowerCaseMapping:0x1666
  ,simpleTitleCaseMapping:0x1666
 },
 { code:0x1667
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1667
  ,simpleLowerCaseMapping:0x1667
  ,simpleTitleCaseMapping:0x1667
 },
 { code:0x1668
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1668
  ,simpleLowerCaseMapping:0x1668
  ,simpleTitleCaseMapping:0x1668
 },
 { code:0x1669
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1669
  ,simpleLowerCaseMapping:0x1669
  ,simpleTitleCaseMapping:0x1669
 },
 { code:0x166A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x166A
  ,simpleLowerCaseMapping:0x166A
  ,simpleTitleCaseMapping:0x166A
 },
 { code:0x166B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x166B
  ,simpleLowerCaseMapping:0x166B
  ,simpleTitleCaseMapping:0x166B
 },
 { code:0x166C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x166C
  ,simpleLowerCaseMapping:0x166C
  ,simpleTitleCaseMapping:0x166C
 },
 { code:0x166D
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x166D
  ,simpleLowerCaseMapping:0x166D
  ,simpleTitleCaseMapping:0x166D
 },
 { code:0x166E
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x166E
  ,simpleLowerCaseMapping:0x166E
  ,simpleTitleCaseMapping:0x166E
 },
 { code:0x166F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x166F
  ,simpleLowerCaseMapping:0x166F
  ,simpleTitleCaseMapping:0x166F
 },
 { code:0x1670
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1670
  ,simpleLowerCaseMapping:0x1670
  ,simpleTitleCaseMapping:0x1670
 },
 { code:0x1671
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1671
  ,simpleLowerCaseMapping:0x1671
  ,simpleTitleCaseMapping:0x1671
 },
 { code:0x1672
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1672
  ,simpleLowerCaseMapping:0x1672
  ,simpleTitleCaseMapping:0x1672
 },
 { code:0x1673
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1673
  ,simpleLowerCaseMapping:0x1673
  ,simpleTitleCaseMapping:0x1673
 },
 { code:0x1674
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1674
  ,simpleLowerCaseMapping:0x1674
  ,simpleTitleCaseMapping:0x1674
 },
 { code:0x1675
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1675
  ,simpleLowerCaseMapping:0x1675
  ,simpleTitleCaseMapping:0x1675
 },
 { code:0x1676
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1676
  ,simpleLowerCaseMapping:0x1676
  ,simpleTitleCaseMapping:0x1676
 },
 { code:0x1680
  ,generalCategory:UnicodeData.GeneralCategory.Zs
  ,simpleUpperCaseMapping:0x1680
  ,simpleLowerCaseMapping:0x1680
  ,simpleTitleCaseMapping:0x1680
 },
 { code:0x1681
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1681
  ,simpleLowerCaseMapping:0x1681
  ,simpleTitleCaseMapping:0x1681
 },
 { code:0x1682
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1682
  ,simpleLowerCaseMapping:0x1682
  ,simpleTitleCaseMapping:0x1682
 },
 { code:0x1683
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1683
  ,simpleLowerCaseMapping:0x1683
  ,simpleTitleCaseMapping:0x1683
 },
 { code:0x1684
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1684
  ,simpleLowerCaseMapping:0x1684
  ,simpleTitleCaseMapping:0x1684
 },
 { code:0x1685
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1685
  ,simpleLowerCaseMapping:0x1685
  ,simpleTitleCaseMapping:0x1685
 },
 { code:0x1686
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1686
  ,simpleLowerCaseMapping:0x1686
  ,simpleTitleCaseMapping:0x1686
 },
 { code:0x1687
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1687
  ,simpleLowerCaseMapping:0x1687
  ,simpleTitleCaseMapping:0x1687
 },
 { code:0x1688
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1688
  ,simpleLowerCaseMapping:0x1688
  ,simpleTitleCaseMapping:0x1688
 },
 { code:0x1689
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1689
  ,simpleLowerCaseMapping:0x1689
  ,simpleTitleCaseMapping:0x1689
 },
 { code:0x168A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x168A
  ,simpleLowerCaseMapping:0x168A
  ,simpleTitleCaseMapping:0x168A
 },
 { code:0x168B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x168B
  ,simpleLowerCaseMapping:0x168B
  ,simpleTitleCaseMapping:0x168B
 },
 { code:0x168C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x168C
  ,simpleLowerCaseMapping:0x168C
  ,simpleTitleCaseMapping:0x168C
 },
 { code:0x168D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x168D
  ,simpleLowerCaseMapping:0x168D
  ,simpleTitleCaseMapping:0x168D
 },
 { code:0x168E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x168E
  ,simpleLowerCaseMapping:0x168E
  ,simpleTitleCaseMapping:0x168E
 },
 { code:0x168F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x168F
  ,simpleLowerCaseMapping:0x168F
  ,simpleTitleCaseMapping:0x168F
 },
 { code:0x1690
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1690
  ,simpleLowerCaseMapping:0x1690
  ,simpleTitleCaseMapping:0x1690
 },
 { code:0x1691
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1691
  ,simpleLowerCaseMapping:0x1691
  ,simpleTitleCaseMapping:0x1691
 },
 { code:0x1692
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1692
  ,simpleLowerCaseMapping:0x1692
  ,simpleTitleCaseMapping:0x1692
 },
 { code:0x1693
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1693
  ,simpleLowerCaseMapping:0x1693
  ,simpleTitleCaseMapping:0x1693
 },
 { code:0x1694
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1694
  ,simpleLowerCaseMapping:0x1694
  ,simpleTitleCaseMapping:0x1694
 },
 { code:0x1695
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1695
  ,simpleLowerCaseMapping:0x1695
  ,simpleTitleCaseMapping:0x1695
 },
 { code:0x1696
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1696
  ,simpleLowerCaseMapping:0x1696
  ,simpleTitleCaseMapping:0x1696
 },
 { code:0x1697
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1697
  ,simpleLowerCaseMapping:0x1697
  ,simpleTitleCaseMapping:0x1697
 },
 { code:0x1698
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1698
  ,simpleLowerCaseMapping:0x1698
  ,simpleTitleCaseMapping:0x1698
 },
 { code:0x1699
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1699
  ,simpleLowerCaseMapping:0x1699
  ,simpleTitleCaseMapping:0x1699
 },
 { code:0x169A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x169A
  ,simpleLowerCaseMapping:0x169A
  ,simpleTitleCaseMapping:0x169A
 },
 { code:0x169B
  ,generalCategory:UnicodeData.GeneralCategory.Ps
  ,simpleUpperCaseMapping:0x169B
  ,simpleLowerCaseMapping:0x169B
  ,simpleTitleCaseMapping:0x169B
 },
 { code:0x169C
  ,generalCategory:UnicodeData.GeneralCategory.Pe
  ,simpleUpperCaseMapping:0x169C
  ,simpleLowerCaseMapping:0x169C
  ,simpleTitleCaseMapping:0x169C
 },
 { code:0x16A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16A0
  ,simpleLowerCaseMapping:0x16A0
  ,simpleTitleCaseMapping:0x16A0
 },
 { code:0x16A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16A1
  ,simpleLowerCaseMapping:0x16A1
  ,simpleTitleCaseMapping:0x16A1
 },
 { code:0x16A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16A2
  ,simpleLowerCaseMapping:0x16A2
  ,simpleTitleCaseMapping:0x16A2
 },
 { code:0x16A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16A3
  ,simpleLowerCaseMapping:0x16A3
  ,simpleTitleCaseMapping:0x16A3
 },
 { code:0x16A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16A4
  ,simpleLowerCaseMapping:0x16A4
  ,simpleTitleCaseMapping:0x16A4
 },
 { code:0x16A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16A5
  ,simpleLowerCaseMapping:0x16A5
  ,simpleTitleCaseMapping:0x16A5
 },
 { code:0x16A6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16A6
  ,simpleLowerCaseMapping:0x16A6
  ,simpleTitleCaseMapping:0x16A6
 },
 { code:0x16A7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16A7
  ,simpleLowerCaseMapping:0x16A7
  ,simpleTitleCaseMapping:0x16A7
 },
 { code:0x16A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16A8
  ,simpleLowerCaseMapping:0x16A8
  ,simpleTitleCaseMapping:0x16A8
 },
 { code:0x16A9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16A9
  ,simpleLowerCaseMapping:0x16A9
  ,simpleTitleCaseMapping:0x16A9
 },
 { code:0x16AA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16AA
  ,simpleLowerCaseMapping:0x16AA
  ,simpleTitleCaseMapping:0x16AA
 },
 { code:0x16AB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16AB
  ,simpleLowerCaseMapping:0x16AB
  ,simpleTitleCaseMapping:0x16AB
 },
 { code:0x16AC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16AC
  ,simpleLowerCaseMapping:0x16AC
  ,simpleTitleCaseMapping:0x16AC
 },
 { code:0x16AD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16AD
  ,simpleLowerCaseMapping:0x16AD
  ,simpleTitleCaseMapping:0x16AD
 },
 { code:0x16AE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16AE
  ,simpleLowerCaseMapping:0x16AE
  ,simpleTitleCaseMapping:0x16AE
 },
 { code:0x16AF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16AF
  ,simpleLowerCaseMapping:0x16AF
  ,simpleTitleCaseMapping:0x16AF
 },
 { code:0x16B0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16B0
  ,simpleLowerCaseMapping:0x16B0
  ,simpleTitleCaseMapping:0x16B0
 },
 { code:0x16B1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16B1
  ,simpleLowerCaseMapping:0x16B1
  ,simpleTitleCaseMapping:0x16B1
 },
 { code:0x16B2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16B2
  ,simpleLowerCaseMapping:0x16B2
  ,simpleTitleCaseMapping:0x16B2
 },
 { code:0x16B3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16B3
  ,simpleLowerCaseMapping:0x16B3
  ,simpleTitleCaseMapping:0x16B3
 },
 { code:0x16B4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16B4
  ,simpleLowerCaseMapping:0x16B4
  ,simpleTitleCaseMapping:0x16B4
 },
 { code:0x16B5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16B5
  ,simpleLowerCaseMapping:0x16B5
  ,simpleTitleCaseMapping:0x16B5
 },
 { code:0x16B6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16B6
  ,simpleLowerCaseMapping:0x16B6
  ,simpleTitleCaseMapping:0x16B6
 },
 { code:0x16B7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16B7
  ,simpleLowerCaseMapping:0x16B7
  ,simpleTitleCaseMapping:0x16B7
 },
 { code:0x16B8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16B8
  ,simpleLowerCaseMapping:0x16B8
  ,simpleTitleCaseMapping:0x16B8
 },
 { code:0x16B9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16B9
  ,simpleLowerCaseMapping:0x16B9
  ,simpleTitleCaseMapping:0x16B9
 },
 { code:0x16BA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16BA
  ,simpleLowerCaseMapping:0x16BA
  ,simpleTitleCaseMapping:0x16BA
 },
 { code:0x16BB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16BB
  ,simpleLowerCaseMapping:0x16BB
  ,simpleTitleCaseMapping:0x16BB
 },
 { code:0x16BC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16BC
  ,simpleLowerCaseMapping:0x16BC
  ,simpleTitleCaseMapping:0x16BC
 },
 { code:0x16BD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16BD
  ,simpleLowerCaseMapping:0x16BD
  ,simpleTitleCaseMapping:0x16BD
 },
 { code:0x16BE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16BE
  ,simpleLowerCaseMapping:0x16BE
  ,simpleTitleCaseMapping:0x16BE
 },
 { code:0x16BF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16BF
  ,simpleLowerCaseMapping:0x16BF
  ,simpleTitleCaseMapping:0x16BF
 },
 { code:0x16C0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16C0
  ,simpleLowerCaseMapping:0x16C0
  ,simpleTitleCaseMapping:0x16C0
 },
 { code:0x16C1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16C1
  ,simpleLowerCaseMapping:0x16C1
  ,simpleTitleCaseMapping:0x16C1
 },
 { code:0x16C2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16C2
  ,simpleLowerCaseMapping:0x16C2
  ,simpleTitleCaseMapping:0x16C2
 },
 { code:0x16C3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16C3
  ,simpleLowerCaseMapping:0x16C3
  ,simpleTitleCaseMapping:0x16C3
 },
 { code:0x16C4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16C4
  ,simpleLowerCaseMapping:0x16C4
  ,simpleTitleCaseMapping:0x16C4
 },
 { code:0x16C5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16C5
  ,simpleLowerCaseMapping:0x16C5
  ,simpleTitleCaseMapping:0x16C5
 },
 { code:0x16C6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16C6
  ,simpleLowerCaseMapping:0x16C6
  ,simpleTitleCaseMapping:0x16C6
 },
 { code:0x16C7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16C7
  ,simpleLowerCaseMapping:0x16C7
  ,simpleTitleCaseMapping:0x16C7
 },
 { code:0x16C8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16C8
  ,simpleLowerCaseMapping:0x16C8
  ,simpleTitleCaseMapping:0x16C8
 },
 { code:0x16C9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16C9
  ,simpleLowerCaseMapping:0x16C9
  ,simpleTitleCaseMapping:0x16C9
 },
 { code:0x16CA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16CA
  ,simpleLowerCaseMapping:0x16CA
  ,simpleTitleCaseMapping:0x16CA
 },
 { code:0x16CB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16CB
  ,simpleLowerCaseMapping:0x16CB
  ,simpleTitleCaseMapping:0x16CB
 },
 { code:0x16CC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16CC
  ,simpleLowerCaseMapping:0x16CC
  ,simpleTitleCaseMapping:0x16CC
 },
 { code:0x16CD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16CD
  ,simpleLowerCaseMapping:0x16CD
  ,simpleTitleCaseMapping:0x16CD
 },
 { code:0x16CE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16CE
  ,simpleLowerCaseMapping:0x16CE
  ,simpleTitleCaseMapping:0x16CE
 },
 { code:0x16CF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16CF
  ,simpleLowerCaseMapping:0x16CF
  ,simpleTitleCaseMapping:0x16CF
 },
 { code:0x16D0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16D0
  ,simpleLowerCaseMapping:0x16D0
  ,simpleTitleCaseMapping:0x16D0
 },
 { code:0x16D1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16D1
  ,simpleLowerCaseMapping:0x16D1
  ,simpleTitleCaseMapping:0x16D1
 },
 { code:0x16D2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16D2
  ,simpleLowerCaseMapping:0x16D2
  ,simpleTitleCaseMapping:0x16D2
 },
 { code:0x16D3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16D3
  ,simpleLowerCaseMapping:0x16D3
  ,simpleTitleCaseMapping:0x16D3
 },
 { code:0x16D4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16D4
  ,simpleLowerCaseMapping:0x16D4
  ,simpleTitleCaseMapping:0x16D4
 },
 { code:0x16D5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16D5
  ,simpleLowerCaseMapping:0x16D5
  ,simpleTitleCaseMapping:0x16D5
 },
 { code:0x16D6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16D6
  ,simpleLowerCaseMapping:0x16D6
  ,simpleTitleCaseMapping:0x16D6
 },
 { code:0x16D7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16D7
  ,simpleLowerCaseMapping:0x16D7
  ,simpleTitleCaseMapping:0x16D7
 },
 { code:0x16D8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16D8
  ,simpleLowerCaseMapping:0x16D8
  ,simpleTitleCaseMapping:0x16D8
 },
 { code:0x16D9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16D9
  ,simpleLowerCaseMapping:0x16D9
  ,simpleTitleCaseMapping:0x16D9
 },
 { code:0x16DA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16DA
  ,simpleLowerCaseMapping:0x16DA
  ,simpleTitleCaseMapping:0x16DA
 },
 { code:0x16DB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16DB
  ,simpleLowerCaseMapping:0x16DB
  ,simpleTitleCaseMapping:0x16DB
 },
 { code:0x16DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16DC
  ,simpleLowerCaseMapping:0x16DC
  ,simpleTitleCaseMapping:0x16DC
 },
 { code:0x16DD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16DD
  ,simpleLowerCaseMapping:0x16DD
  ,simpleTitleCaseMapping:0x16DD
 },
 { code:0x16DE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16DE
  ,simpleLowerCaseMapping:0x16DE
  ,simpleTitleCaseMapping:0x16DE
 },
 { code:0x16DF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16DF
  ,simpleLowerCaseMapping:0x16DF
  ,simpleTitleCaseMapping:0x16DF
 },
 { code:0x16E0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16E0
  ,simpleLowerCaseMapping:0x16E0
  ,simpleTitleCaseMapping:0x16E0
 },
 { code:0x16E1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16E1
  ,simpleLowerCaseMapping:0x16E1
  ,simpleTitleCaseMapping:0x16E1
 },
 { code:0x16E2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16E2
  ,simpleLowerCaseMapping:0x16E2
  ,simpleTitleCaseMapping:0x16E2
 },
 { code:0x16E3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16E3
  ,simpleLowerCaseMapping:0x16E3
  ,simpleTitleCaseMapping:0x16E3
 },
 { code:0x16E4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16E4
  ,simpleLowerCaseMapping:0x16E4
  ,simpleTitleCaseMapping:0x16E4
 },
 { code:0x16E5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16E5
  ,simpleLowerCaseMapping:0x16E5
  ,simpleTitleCaseMapping:0x16E5
 },
 { code:0x16E6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16E6
  ,simpleLowerCaseMapping:0x16E6
  ,simpleTitleCaseMapping:0x16E6
 },
 { code:0x16E7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16E7
  ,simpleLowerCaseMapping:0x16E7
  ,simpleTitleCaseMapping:0x16E7
 },
 { code:0x16E8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16E8
  ,simpleLowerCaseMapping:0x16E8
  ,simpleTitleCaseMapping:0x16E8
 },
 { code:0x16E9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16E9
  ,simpleLowerCaseMapping:0x16E9
  ,simpleTitleCaseMapping:0x16E9
 },
 { code:0x16EA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x16EA
  ,simpleLowerCaseMapping:0x16EA
  ,simpleTitleCaseMapping:0x16EA
 },
 { code:0x16EB
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x16EB
  ,simpleLowerCaseMapping:0x16EB
  ,simpleTitleCaseMapping:0x16EB
 },
 { code:0x16EC
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x16EC
  ,simpleLowerCaseMapping:0x16EC
  ,simpleTitleCaseMapping:0x16EC
 },
 { code:0x16ED
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x16ED
  ,simpleLowerCaseMapping:0x16ED
  ,simpleTitleCaseMapping:0x16ED
 },
 { code:0x16EE
  ,generalCategory:UnicodeData.GeneralCategory.Nl
  ,simpleUpperCaseMapping:0x16EE
  ,simpleLowerCaseMapping:0x16EE
  ,simpleTitleCaseMapping:0x16EE
 },
 { code:0x16EF
  ,generalCategory:UnicodeData.GeneralCategory.Nl
  ,simpleUpperCaseMapping:0x16EF
  ,simpleLowerCaseMapping:0x16EF
  ,simpleTitleCaseMapping:0x16EF
 },
 { code:0x16F0
  ,generalCategory:UnicodeData.GeneralCategory.Nl
  ,simpleUpperCaseMapping:0x16F0
  ,simpleLowerCaseMapping:0x16F0
  ,simpleTitleCaseMapping:0x16F0
 },
 { code:0x1700
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1700
  ,simpleLowerCaseMapping:0x1700
  ,simpleTitleCaseMapping:0x1700
 },
 { code:0x1701
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1701
  ,simpleLowerCaseMapping:0x1701
  ,simpleTitleCaseMapping:0x1701
 },
 { code:0x1702
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1702
  ,simpleLowerCaseMapping:0x1702
  ,simpleTitleCaseMapping:0x1702
 },
 { code:0x1703
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1703
  ,simpleLowerCaseMapping:0x1703
  ,simpleTitleCaseMapping:0x1703
 },
 { code:0x1704
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1704
  ,simpleLowerCaseMapping:0x1704
  ,simpleTitleCaseMapping:0x1704
 },
 { code:0x1705
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1705
  ,simpleLowerCaseMapping:0x1705
  ,simpleTitleCaseMapping:0x1705
 },
 { code:0x1706
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1706
  ,simpleLowerCaseMapping:0x1706
  ,simpleTitleCaseMapping:0x1706
 },
 { code:0x1707
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1707
  ,simpleLowerCaseMapping:0x1707
  ,simpleTitleCaseMapping:0x1707
 },
 { code:0x1708
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1708
  ,simpleLowerCaseMapping:0x1708
  ,simpleTitleCaseMapping:0x1708
 },
 { code:0x1709
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1709
  ,simpleLowerCaseMapping:0x1709
  ,simpleTitleCaseMapping:0x1709
 },
 { code:0x170A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x170A
  ,simpleLowerCaseMapping:0x170A
  ,simpleTitleCaseMapping:0x170A
 },
 { code:0x170B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x170B
  ,simpleLowerCaseMapping:0x170B
  ,simpleTitleCaseMapping:0x170B
 },
 { code:0x170C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x170C
  ,simpleLowerCaseMapping:0x170C
  ,simpleTitleCaseMapping:0x170C
 },
 { code:0x170E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x170E
  ,simpleLowerCaseMapping:0x170E
  ,simpleTitleCaseMapping:0x170E
 },
 { code:0x170F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x170F
  ,simpleLowerCaseMapping:0x170F
  ,simpleTitleCaseMapping:0x170F
 },
 { code:0x1710
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1710
  ,simpleLowerCaseMapping:0x1710
  ,simpleTitleCaseMapping:0x1710
 },
 { code:0x1711
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1711
  ,simpleLowerCaseMapping:0x1711
  ,simpleTitleCaseMapping:0x1711
 },
 { code:0x1712
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1712
  ,simpleLowerCaseMapping:0x1712
  ,simpleTitleCaseMapping:0x1712
 },
 { code:0x1713
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1713
  ,simpleLowerCaseMapping:0x1713
  ,simpleTitleCaseMapping:0x1713
 },
 { code:0x1714
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1714
  ,simpleLowerCaseMapping:0x1714
  ,simpleTitleCaseMapping:0x1714
 },
 { code:0x1720
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1720
  ,simpleLowerCaseMapping:0x1720
  ,simpleTitleCaseMapping:0x1720
 },
 { code:0x1721
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1721
  ,simpleLowerCaseMapping:0x1721
  ,simpleTitleCaseMapping:0x1721
 },
 { code:0x1722
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1722
  ,simpleLowerCaseMapping:0x1722
  ,simpleTitleCaseMapping:0x1722
 },
 { code:0x1723
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1723
  ,simpleLowerCaseMapping:0x1723
  ,simpleTitleCaseMapping:0x1723
 },
 { code:0x1724
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1724
  ,simpleLowerCaseMapping:0x1724
  ,simpleTitleCaseMapping:0x1724
 },
 { code:0x1725
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1725
  ,simpleLowerCaseMapping:0x1725
  ,simpleTitleCaseMapping:0x1725
 },
 { code:0x1726
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1726
  ,simpleLowerCaseMapping:0x1726
  ,simpleTitleCaseMapping:0x1726
 },
 { code:0x1727
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1727
  ,simpleLowerCaseMapping:0x1727
  ,simpleTitleCaseMapping:0x1727
 },
 { code:0x1728
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1728
  ,simpleLowerCaseMapping:0x1728
  ,simpleTitleCaseMapping:0x1728
 },
 { code:0x1729
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1729
  ,simpleLowerCaseMapping:0x1729
  ,simpleTitleCaseMapping:0x1729
 },
 { code:0x172A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x172A
  ,simpleLowerCaseMapping:0x172A
  ,simpleTitleCaseMapping:0x172A
 },
 { code:0x172B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x172B
  ,simpleLowerCaseMapping:0x172B
  ,simpleTitleCaseMapping:0x172B
 },
 { code:0x172C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x172C
  ,simpleLowerCaseMapping:0x172C
  ,simpleTitleCaseMapping:0x172C
 },
 { code:0x172D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x172D
  ,simpleLowerCaseMapping:0x172D
  ,simpleTitleCaseMapping:0x172D
 },
 { code:0x172E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x172E
  ,simpleLowerCaseMapping:0x172E
  ,simpleTitleCaseMapping:0x172E
 },
 { code:0x172F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x172F
  ,simpleLowerCaseMapping:0x172F
  ,simpleTitleCaseMapping:0x172F
 },
 { code:0x1730
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1730
  ,simpleLowerCaseMapping:0x1730
  ,simpleTitleCaseMapping:0x1730
 },
 { code:0x1731
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1731
  ,simpleLowerCaseMapping:0x1731
  ,simpleTitleCaseMapping:0x1731
 },
 { code:0x1732
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1732
  ,simpleLowerCaseMapping:0x1732
  ,simpleTitleCaseMapping:0x1732
 },
 { code:0x1733
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1733
  ,simpleLowerCaseMapping:0x1733
  ,simpleTitleCaseMapping:0x1733
 },
 { code:0x1734
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1734
  ,simpleLowerCaseMapping:0x1734
  ,simpleTitleCaseMapping:0x1734
 },
 { code:0x1735
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1735
  ,simpleLowerCaseMapping:0x1735
  ,simpleTitleCaseMapping:0x1735
 },
 { code:0x1736
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1736
  ,simpleLowerCaseMapping:0x1736
  ,simpleTitleCaseMapping:0x1736
 },
 { code:0x1740
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1740
  ,simpleLowerCaseMapping:0x1740
  ,simpleTitleCaseMapping:0x1740
 },
 { code:0x1741
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1741
  ,simpleLowerCaseMapping:0x1741
  ,simpleTitleCaseMapping:0x1741
 },
 { code:0x1742
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1742
  ,simpleLowerCaseMapping:0x1742
  ,simpleTitleCaseMapping:0x1742
 },
 { code:0x1743
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1743
  ,simpleLowerCaseMapping:0x1743
  ,simpleTitleCaseMapping:0x1743
 },
 { code:0x1744
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1744
  ,simpleLowerCaseMapping:0x1744
  ,simpleTitleCaseMapping:0x1744
 },
 { code:0x1745
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1745
  ,simpleLowerCaseMapping:0x1745
  ,simpleTitleCaseMapping:0x1745
 },
 { code:0x1746
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1746
  ,simpleLowerCaseMapping:0x1746
  ,simpleTitleCaseMapping:0x1746
 },
 { code:0x1747
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1747
  ,simpleLowerCaseMapping:0x1747
  ,simpleTitleCaseMapping:0x1747
 },
 { code:0x1748
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1748
  ,simpleLowerCaseMapping:0x1748
  ,simpleTitleCaseMapping:0x1748
 },
 { code:0x1749
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1749
  ,simpleLowerCaseMapping:0x1749
  ,simpleTitleCaseMapping:0x1749
 },
 { code:0x174A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x174A
  ,simpleLowerCaseMapping:0x174A
  ,simpleTitleCaseMapping:0x174A
 },
 { code:0x174B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x174B
  ,simpleLowerCaseMapping:0x174B
  ,simpleTitleCaseMapping:0x174B
 },
 { code:0x174C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x174C
  ,simpleLowerCaseMapping:0x174C
  ,simpleTitleCaseMapping:0x174C
 },
 { code:0x174D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x174D
  ,simpleLowerCaseMapping:0x174D
  ,simpleTitleCaseMapping:0x174D
 },
 { code:0x174E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x174E
  ,simpleLowerCaseMapping:0x174E
  ,simpleTitleCaseMapping:0x174E
 },
 { code:0x174F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x174F
  ,simpleLowerCaseMapping:0x174F
  ,simpleTitleCaseMapping:0x174F
 },
 { code:0x1750
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1750
  ,simpleLowerCaseMapping:0x1750
  ,simpleTitleCaseMapping:0x1750
 },
 { code:0x1751
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1751
  ,simpleLowerCaseMapping:0x1751
  ,simpleTitleCaseMapping:0x1751
 },
 { code:0x1752
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1752
  ,simpleLowerCaseMapping:0x1752
  ,simpleTitleCaseMapping:0x1752
 },
 { code:0x1753
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1753
  ,simpleLowerCaseMapping:0x1753
  ,simpleTitleCaseMapping:0x1753
 },
 { code:0x1760
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1760
  ,simpleLowerCaseMapping:0x1760
  ,simpleTitleCaseMapping:0x1760
 },
 { code:0x1761
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1761
  ,simpleLowerCaseMapping:0x1761
  ,simpleTitleCaseMapping:0x1761
 },
 { code:0x1762
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1762
  ,simpleLowerCaseMapping:0x1762
  ,simpleTitleCaseMapping:0x1762
 },
 { code:0x1763
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1763
  ,simpleLowerCaseMapping:0x1763
  ,simpleTitleCaseMapping:0x1763
 },
 { code:0x1764
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1764
  ,simpleLowerCaseMapping:0x1764
  ,simpleTitleCaseMapping:0x1764
 },
 { code:0x1765
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1765
  ,simpleLowerCaseMapping:0x1765
  ,simpleTitleCaseMapping:0x1765
 },
 { code:0x1766
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1766
  ,simpleLowerCaseMapping:0x1766
  ,simpleTitleCaseMapping:0x1766
 },
 { code:0x1767
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1767
  ,simpleLowerCaseMapping:0x1767
  ,simpleTitleCaseMapping:0x1767
 },
 { code:0x1768
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1768
  ,simpleLowerCaseMapping:0x1768
  ,simpleTitleCaseMapping:0x1768
 },
 { code:0x1769
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1769
  ,simpleLowerCaseMapping:0x1769
  ,simpleTitleCaseMapping:0x1769
 },
 { code:0x176A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x176A
  ,simpleLowerCaseMapping:0x176A
  ,simpleTitleCaseMapping:0x176A
 },
 { code:0x176B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x176B
  ,simpleLowerCaseMapping:0x176B
  ,simpleTitleCaseMapping:0x176B
 },
 { code:0x176C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x176C
  ,simpleLowerCaseMapping:0x176C
  ,simpleTitleCaseMapping:0x176C
 },
 { code:0x176E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x176E
  ,simpleLowerCaseMapping:0x176E
  ,simpleTitleCaseMapping:0x176E
 },
 { code:0x176F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x176F
  ,simpleLowerCaseMapping:0x176F
  ,simpleTitleCaseMapping:0x176F
 },
 { code:0x1770
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1770
  ,simpleLowerCaseMapping:0x1770
  ,simpleTitleCaseMapping:0x1770
 },
 { code:0x1772
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1772
  ,simpleLowerCaseMapping:0x1772
  ,simpleTitleCaseMapping:0x1772
 },
 { code:0x1773
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1773
  ,simpleLowerCaseMapping:0x1773
  ,simpleTitleCaseMapping:0x1773
 },
 { code:0x1780
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1780
  ,simpleLowerCaseMapping:0x1780
  ,simpleTitleCaseMapping:0x1780
 },
 { code:0x1781
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1781
  ,simpleLowerCaseMapping:0x1781
  ,simpleTitleCaseMapping:0x1781
 },
 { code:0x1782
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1782
  ,simpleLowerCaseMapping:0x1782
  ,simpleTitleCaseMapping:0x1782
 },
 { code:0x1783
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1783
  ,simpleLowerCaseMapping:0x1783
  ,simpleTitleCaseMapping:0x1783
 },
 { code:0x1784
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1784
  ,simpleLowerCaseMapping:0x1784
  ,simpleTitleCaseMapping:0x1784
 },
 { code:0x1785
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1785
  ,simpleLowerCaseMapping:0x1785
  ,simpleTitleCaseMapping:0x1785
 },
 { code:0x1786
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1786
  ,simpleLowerCaseMapping:0x1786
  ,simpleTitleCaseMapping:0x1786
 },
 { code:0x1787
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1787
  ,simpleLowerCaseMapping:0x1787
  ,simpleTitleCaseMapping:0x1787
 },
 { code:0x1788
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1788
  ,simpleLowerCaseMapping:0x1788
  ,simpleTitleCaseMapping:0x1788
 },
 { code:0x1789
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1789
  ,simpleLowerCaseMapping:0x1789
  ,simpleTitleCaseMapping:0x1789
 },
 { code:0x178A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x178A
  ,simpleLowerCaseMapping:0x178A
  ,simpleTitleCaseMapping:0x178A
 },
 { code:0x178B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x178B
  ,simpleLowerCaseMapping:0x178B
  ,simpleTitleCaseMapping:0x178B
 },
 { code:0x178C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x178C
  ,simpleLowerCaseMapping:0x178C
  ,simpleTitleCaseMapping:0x178C
 },
 { code:0x178D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x178D
  ,simpleLowerCaseMapping:0x178D
  ,simpleTitleCaseMapping:0x178D
 },
 { code:0x178E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x178E
  ,simpleLowerCaseMapping:0x178E
  ,simpleTitleCaseMapping:0x178E
 },
 { code:0x178F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x178F
  ,simpleLowerCaseMapping:0x178F
  ,simpleTitleCaseMapping:0x178F
 },
 { code:0x1790
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1790
  ,simpleLowerCaseMapping:0x1790
  ,simpleTitleCaseMapping:0x1790
 },
 { code:0x1791
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1791
  ,simpleLowerCaseMapping:0x1791
  ,simpleTitleCaseMapping:0x1791
 },
 { code:0x1792
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1792
  ,simpleLowerCaseMapping:0x1792
  ,simpleTitleCaseMapping:0x1792
 },
 { code:0x1793
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1793
  ,simpleLowerCaseMapping:0x1793
  ,simpleTitleCaseMapping:0x1793
 },
 { code:0x1794
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1794
  ,simpleLowerCaseMapping:0x1794
  ,simpleTitleCaseMapping:0x1794
 },
 { code:0x1795
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1795
  ,simpleLowerCaseMapping:0x1795
  ,simpleTitleCaseMapping:0x1795
 },
 { code:0x1796
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1796
  ,simpleLowerCaseMapping:0x1796
  ,simpleTitleCaseMapping:0x1796
 },
 { code:0x1797
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1797
  ,simpleLowerCaseMapping:0x1797
  ,simpleTitleCaseMapping:0x1797
 },
 { code:0x1798
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1798
  ,simpleLowerCaseMapping:0x1798
  ,simpleTitleCaseMapping:0x1798
 },
 { code:0x1799
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1799
  ,simpleLowerCaseMapping:0x1799
  ,simpleTitleCaseMapping:0x1799
 },
 { code:0x179A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x179A
  ,simpleLowerCaseMapping:0x179A
  ,simpleTitleCaseMapping:0x179A
 },
 { code:0x179B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x179B
  ,simpleLowerCaseMapping:0x179B
  ,simpleTitleCaseMapping:0x179B
 },
 { code:0x179C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x179C
  ,simpleLowerCaseMapping:0x179C
  ,simpleTitleCaseMapping:0x179C
 },
 { code:0x179D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x179D
  ,simpleLowerCaseMapping:0x179D
  ,simpleTitleCaseMapping:0x179D
 },
 { code:0x179E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x179E
  ,simpleLowerCaseMapping:0x179E
  ,simpleTitleCaseMapping:0x179E
 },
 { code:0x179F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x179F
  ,simpleLowerCaseMapping:0x179F
  ,simpleTitleCaseMapping:0x179F
 },
 { code:0x17A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17A0
  ,simpleLowerCaseMapping:0x17A0
  ,simpleTitleCaseMapping:0x17A0
 },
 { code:0x17A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17A1
  ,simpleLowerCaseMapping:0x17A1
  ,simpleTitleCaseMapping:0x17A1
 },
 { code:0x17A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17A2
  ,simpleLowerCaseMapping:0x17A2
  ,simpleTitleCaseMapping:0x17A2
 },
 { code:0x17A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17A3
  ,simpleLowerCaseMapping:0x17A3
  ,simpleTitleCaseMapping:0x17A3
 },
 { code:0x17A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17A4
  ,simpleLowerCaseMapping:0x17A4
  ,simpleTitleCaseMapping:0x17A4
 },
 { code:0x17A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17A5
  ,simpleLowerCaseMapping:0x17A5
  ,simpleTitleCaseMapping:0x17A5
 },
 { code:0x17A6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17A6
  ,simpleLowerCaseMapping:0x17A6
  ,simpleTitleCaseMapping:0x17A6
 },
 { code:0x17A7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17A7
  ,simpleLowerCaseMapping:0x17A7
  ,simpleTitleCaseMapping:0x17A7
 },
 { code:0x17A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17A8
  ,simpleLowerCaseMapping:0x17A8
  ,simpleTitleCaseMapping:0x17A8
 },
 { code:0x17A9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17A9
  ,simpleLowerCaseMapping:0x17A9
  ,simpleTitleCaseMapping:0x17A9
 },
 { code:0x17AA
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17AA
  ,simpleLowerCaseMapping:0x17AA
  ,simpleTitleCaseMapping:0x17AA
 },
 { code:0x17AB
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17AB
  ,simpleLowerCaseMapping:0x17AB
  ,simpleTitleCaseMapping:0x17AB
 },
 { code:0x17AC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17AC
  ,simpleLowerCaseMapping:0x17AC
  ,simpleTitleCaseMapping:0x17AC
 },
 { code:0x17AD
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17AD
  ,simpleLowerCaseMapping:0x17AD
  ,simpleTitleCaseMapping:0x17AD
 },
 { code:0x17AE
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17AE
  ,simpleLowerCaseMapping:0x17AE
  ,simpleTitleCaseMapping:0x17AE
 },
 { code:0x17AF
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17AF
  ,simpleLowerCaseMapping:0x17AF
  ,simpleTitleCaseMapping:0x17AF
 },
 { code:0x17B0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17B0
  ,simpleLowerCaseMapping:0x17B0
  ,simpleTitleCaseMapping:0x17B0
 },
 { code:0x17B1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17B1
  ,simpleLowerCaseMapping:0x17B1
  ,simpleTitleCaseMapping:0x17B1
 },
 { code:0x17B2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17B2
  ,simpleLowerCaseMapping:0x17B2
  ,simpleTitleCaseMapping:0x17B2
 },
 { code:0x17B3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17B3
  ,simpleLowerCaseMapping:0x17B3
  ,simpleTitleCaseMapping:0x17B3
 },
 { code:0x17B4
  ,generalCategory:UnicodeData.GeneralCategory.Cf
  ,simpleUpperCaseMapping:0x17B4
  ,simpleLowerCaseMapping:0x17B4
  ,simpleTitleCaseMapping:0x17B4
 },
 { code:0x17B5
  ,generalCategory:UnicodeData.GeneralCategory.Cf
  ,simpleUpperCaseMapping:0x17B5
  ,simpleLowerCaseMapping:0x17B5
  ,simpleTitleCaseMapping:0x17B5
 },
 { code:0x17B6
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17B6
  ,simpleLowerCaseMapping:0x17B6
  ,simpleTitleCaseMapping:0x17B6
 },
 { code:0x17B7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17B7
  ,simpleLowerCaseMapping:0x17B7
  ,simpleTitleCaseMapping:0x17B7
 },
 { code:0x17B8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17B8
  ,simpleLowerCaseMapping:0x17B8
  ,simpleTitleCaseMapping:0x17B8
 },
 { code:0x17B9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17B9
  ,simpleLowerCaseMapping:0x17B9
  ,simpleTitleCaseMapping:0x17B9
 },
 { code:0x17BA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17BA
  ,simpleLowerCaseMapping:0x17BA
  ,simpleTitleCaseMapping:0x17BA
 },
 { code:0x17BB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17BB
  ,simpleLowerCaseMapping:0x17BB
  ,simpleTitleCaseMapping:0x17BB
 },
 { code:0x17BC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17BC
  ,simpleLowerCaseMapping:0x17BC
  ,simpleTitleCaseMapping:0x17BC
 },
 { code:0x17BD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17BD
  ,simpleLowerCaseMapping:0x17BD
  ,simpleTitleCaseMapping:0x17BD
 },
 { code:0x17BE
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17BE
  ,simpleLowerCaseMapping:0x17BE
  ,simpleTitleCaseMapping:0x17BE
 },
 { code:0x17BF
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17BF
  ,simpleLowerCaseMapping:0x17BF
  ,simpleTitleCaseMapping:0x17BF
 },
 { code:0x17C0
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17C0
  ,simpleLowerCaseMapping:0x17C0
  ,simpleTitleCaseMapping:0x17C0
 },
 { code:0x17C1
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17C1
  ,simpleLowerCaseMapping:0x17C1
  ,simpleTitleCaseMapping:0x17C1
 },
 { code:0x17C2
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17C2
  ,simpleLowerCaseMapping:0x17C2
  ,simpleTitleCaseMapping:0x17C2
 },
 { code:0x17C3
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17C3
  ,simpleLowerCaseMapping:0x17C3
  ,simpleTitleCaseMapping:0x17C3
 },
 { code:0x17C4
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17C4
  ,simpleLowerCaseMapping:0x17C4
  ,simpleTitleCaseMapping:0x17C4
 },
 { code:0x17C5
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17C5
  ,simpleLowerCaseMapping:0x17C5
  ,simpleTitleCaseMapping:0x17C5
 },
 { code:0x17C6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17C6
  ,simpleLowerCaseMapping:0x17C6
  ,simpleTitleCaseMapping:0x17C6
 },
 { code:0x17C7
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17C7
  ,simpleLowerCaseMapping:0x17C7
  ,simpleTitleCaseMapping:0x17C7
 },
 { code:0x17C8
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x17C8
  ,simpleLowerCaseMapping:0x17C8
  ,simpleTitleCaseMapping:0x17C8
 },
 { code:0x17C9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17C9
  ,simpleLowerCaseMapping:0x17C9
  ,simpleTitleCaseMapping:0x17C9
 },
 { code:0x17CA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17CA
  ,simpleLowerCaseMapping:0x17CA
  ,simpleTitleCaseMapping:0x17CA
 },
 { code:0x17CB
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17CB
  ,simpleLowerCaseMapping:0x17CB
  ,simpleTitleCaseMapping:0x17CB
 },
 { code:0x17CC
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17CC
  ,simpleLowerCaseMapping:0x17CC
  ,simpleTitleCaseMapping:0x17CC
 },
 { code:0x17CD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17CD
  ,simpleLowerCaseMapping:0x17CD
  ,simpleTitleCaseMapping:0x17CD
 },
 { code:0x17CE
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17CE
  ,simpleLowerCaseMapping:0x17CE
  ,simpleTitleCaseMapping:0x17CE
 },
 { code:0x17CF
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17CF
  ,simpleLowerCaseMapping:0x17CF
  ,simpleTitleCaseMapping:0x17CF
 },
 { code:0x17D0
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17D0
  ,simpleLowerCaseMapping:0x17D0
  ,simpleTitleCaseMapping:0x17D0
 },
 { code:0x17D1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17D1
  ,simpleLowerCaseMapping:0x17D1
  ,simpleTitleCaseMapping:0x17D1
 },
 { code:0x17D2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17D2
  ,simpleLowerCaseMapping:0x17D2
  ,simpleTitleCaseMapping:0x17D2
 },
 { code:0x17D3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17D3
  ,simpleLowerCaseMapping:0x17D3
  ,simpleTitleCaseMapping:0x17D3
 },
 { code:0x17D4
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x17D4
  ,simpleLowerCaseMapping:0x17D4
  ,simpleTitleCaseMapping:0x17D4
 },
 { code:0x17D5
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x17D5
  ,simpleLowerCaseMapping:0x17D5
  ,simpleTitleCaseMapping:0x17D5
 },
 { code:0x17D6
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x17D6
  ,simpleLowerCaseMapping:0x17D6
  ,simpleTitleCaseMapping:0x17D6
 },
 { code:0x17D7
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x17D7
  ,simpleLowerCaseMapping:0x17D7
  ,simpleTitleCaseMapping:0x17D7
 },
 { code:0x17D8
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x17D8
  ,simpleLowerCaseMapping:0x17D8
  ,simpleTitleCaseMapping:0x17D8
 },
 { code:0x17D9
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x17D9
  ,simpleLowerCaseMapping:0x17D9
  ,simpleTitleCaseMapping:0x17D9
 },
 { code:0x17DA
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x17DA
  ,simpleLowerCaseMapping:0x17DA
  ,simpleTitleCaseMapping:0x17DA
 },
 { code:0x17DB
  ,generalCategory:UnicodeData.GeneralCategory.Sc
  ,simpleUpperCaseMapping:0x17DB
  ,simpleLowerCaseMapping:0x17DB
  ,simpleTitleCaseMapping:0x17DB
 },
 { code:0x17DC
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x17DC
  ,simpleLowerCaseMapping:0x17DC
  ,simpleTitleCaseMapping:0x17DC
 },
 { code:0x17DD
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x17DD
  ,simpleLowerCaseMapping:0x17DD
  ,simpleTitleCaseMapping:0x17DD
 },
 { code:0x17E0
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x17E0
  ,simpleLowerCaseMapping:0x17E0
  ,simpleTitleCaseMapping:0x17E0
 },
 { code:0x17E1
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x17E1
  ,simpleLowerCaseMapping:0x17E1
  ,simpleTitleCaseMapping:0x17E1
 },
 { code:0x17E2
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x17E2
  ,simpleLowerCaseMapping:0x17E2
  ,simpleTitleCaseMapping:0x17E2
 },
 { code:0x17E3
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x17E3
  ,simpleLowerCaseMapping:0x17E3
  ,simpleTitleCaseMapping:0x17E3
 },
 { code:0x17E4
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x17E4
  ,simpleLowerCaseMapping:0x17E4
  ,simpleTitleCaseMapping:0x17E4
 },
 { code:0x17E5
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x17E5
  ,simpleLowerCaseMapping:0x17E5
  ,simpleTitleCaseMapping:0x17E5
 },
 { code:0x17E6
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x17E6
  ,simpleLowerCaseMapping:0x17E6
  ,simpleTitleCaseMapping:0x17E6
 },
 { code:0x17E7
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x17E7
  ,simpleLowerCaseMapping:0x17E7
  ,simpleTitleCaseMapping:0x17E7
 },
 { code:0x17E8
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x17E8
  ,simpleLowerCaseMapping:0x17E8
  ,simpleTitleCaseMapping:0x17E8
 },
 { code:0x17E9
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x17E9
  ,simpleLowerCaseMapping:0x17E9
  ,simpleTitleCaseMapping:0x17E9
 },
 { code:0x17F0
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x17F0
  ,simpleLowerCaseMapping:0x17F0
  ,simpleTitleCaseMapping:0x17F0
 },
 { code:0x17F1
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x17F1
  ,simpleLowerCaseMapping:0x17F1
  ,simpleTitleCaseMapping:0x17F1
 },
 { code:0x17F2
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x17F2
  ,simpleLowerCaseMapping:0x17F2
  ,simpleTitleCaseMapping:0x17F2
 },
 { code:0x17F3
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x17F3
  ,simpleLowerCaseMapping:0x17F3
  ,simpleTitleCaseMapping:0x17F3
 },
 { code:0x17F4
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x17F4
  ,simpleLowerCaseMapping:0x17F4
  ,simpleTitleCaseMapping:0x17F4
 },
 { code:0x17F5
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x17F5
  ,simpleLowerCaseMapping:0x17F5
  ,simpleTitleCaseMapping:0x17F5
 },
 { code:0x17F6
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x17F6
  ,simpleLowerCaseMapping:0x17F6
  ,simpleTitleCaseMapping:0x17F6
 },
 { code:0x17F7
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x17F7
  ,simpleLowerCaseMapping:0x17F7
  ,simpleTitleCaseMapping:0x17F7
 },
 { code:0x17F8
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x17F8
  ,simpleLowerCaseMapping:0x17F8
  ,simpleTitleCaseMapping:0x17F8
 },
 { code:0x17F9
  ,generalCategory:UnicodeData.GeneralCategory.No
  ,simpleUpperCaseMapping:0x17F9
  ,simpleLowerCaseMapping:0x17F9
  ,simpleTitleCaseMapping:0x17F9
 },
 { code:0x1800
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1800
  ,simpleLowerCaseMapping:0x1800
  ,simpleTitleCaseMapping:0x1800
 },
 { code:0x1801
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1801
  ,simpleLowerCaseMapping:0x1801
  ,simpleTitleCaseMapping:0x1801
 },
 { code:0x1802
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1802
  ,simpleLowerCaseMapping:0x1802
  ,simpleTitleCaseMapping:0x1802
 },
 { code:0x1803
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1803
  ,simpleLowerCaseMapping:0x1803
  ,simpleTitleCaseMapping:0x1803
 },
 { code:0x1804
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1804
  ,simpleLowerCaseMapping:0x1804
  ,simpleTitleCaseMapping:0x1804
 },
 { code:0x1805
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1805
  ,simpleLowerCaseMapping:0x1805
  ,simpleTitleCaseMapping:0x1805
 },
 { code:0x1806
  ,generalCategory:UnicodeData.GeneralCategory.Pd
  ,simpleUpperCaseMapping:0x1806
  ,simpleLowerCaseMapping:0x1806
  ,simpleTitleCaseMapping:0x1806
 },
 { code:0x1807
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1807
  ,simpleLowerCaseMapping:0x1807
  ,simpleTitleCaseMapping:0x1807
 },
 { code:0x1808
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1808
  ,simpleLowerCaseMapping:0x1808
  ,simpleTitleCaseMapping:0x1808
 },
 { code:0x1809
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1809
  ,simpleLowerCaseMapping:0x1809
  ,simpleTitleCaseMapping:0x1809
 },
 { code:0x180A
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x180A
  ,simpleLowerCaseMapping:0x180A
  ,simpleTitleCaseMapping:0x180A
 },
 { code:0x180B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x180B
  ,simpleLowerCaseMapping:0x180B
  ,simpleTitleCaseMapping:0x180B
 },
 { code:0x180C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x180C
  ,simpleLowerCaseMapping:0x180C
  ,simpleTitleCaseMapping:0x180C
 },
 { code:0x180D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x180D
  ,simpleLowerCaseMapping:0x180D
  ,simpleTitleCaseMapping:0x180D
 },
 { code:0x180E
  ,generalCategory:UnicodeData.GeneralCategory.Zs
  ,simpleUpperCaseMapping:0x180E
  ,simpleLowerCaseMapping:0x180E
  ,simpleTitleCaseMapping:0x180E
 },
 { code:0x1810
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1810
  ,simpleLowerCaseMapping:0x1810
  ,simpleTitleCaseMapping:0x1810
 },
 { code:0x1811
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1811
  ,simpleLowerCaseMapping:0x1811
  ,simpleTitleCaseMapping:0x1811
 },
 { code:0x1812
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1812
  ,simpleLowerCaseMapping:0x1812
  ,simpleTitleCaseMapping:0x1812
 },
 { code:0x1813
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1813
  ,simpleLowerCaseMapping:0x1813
  ,simpleTitleCaseMapping:0x1813
 },
 { code:0x1814
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1814
  ,simpleLowerCaseMapping:0x1814
  ,simpleTitleCaseMapping:0x1814
 },
 { code:0x1815
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1815
  ,simpleLowerCaseMapping:0x1815
  ,simpleTitleCaseMapping:0x1815
 },
 { code:0x1816
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1816
  ,simpleLowerCaseMapping:0x1816
  ,simpleTitleCaseMapping:0x1816
 },
 { code:0x1817
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1817
  ,simpleLowerCaseMapping:0x1817
  ,simpleTitleCaseMapping:0x1817
 },
 { code:0x1818
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1818
  ,simpleLowerCaseMapping:0x1818
  ,simpleTitleCaseMapping:0x1818
 },
 { code:0x1819
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1819
  ,simpleLowerCaseMapping:0x1819
  ,simpleTitleCaseMapping:0x1819
 },
 { code:0x1820
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1820
  ,simpleLowerCaseMapping:0x1820
  ,simpleTitleCaseMapping:0x1820
 },
 { code:0x1821
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1821
  ,simpleLowerCaseMapping:0x1821
  ,simpleTitleCaseMapping:0x1821
 },
 { code:0x1822
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1822
  ,simpleLowerCaseMapping:0x1822
  ,simpleTitleCaseMapping:0x1822
 },
 { code:0x1823
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1823
  ,simpleLowerCaseMapping:0x1823
  ,simpleTitleCaseMapping:0x1823
 },
 { code:0x1824
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1824
  ,simpleLowerCaseMapping:0x1824
  ,simpleTitleCaseMapping:0x1824
 },
 { code:0x1825
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1825
  ,simpleLowerCaseMapping:0x1825
  ,simpleTitleCaseMapping:0x1825
 },
 { code:0x1826
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1826
  ,simpleLowerCaseMapping:0x1826
  ,simpleTitleCaseMapping:0x1826
 },
 { code:0x1827
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1827
  ,simpleLowerCaseMapping:0x1827
  ,simpleTitleCaseMapping:0x1827
 },
 { code:0x1828
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1828
  ,simpleLowerCaseMapping:0x1828
  ,simpleTitleCaseMapping:0x1828
 },
 { code:0x1829
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1829
  ,simpleLowerCaseMapping:0x1829
  ,simpleTitleCaseMapping:0x1829
 },
 { code:0x182A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x182A
  ,simpleLowerCaseMapping:0x182A
  ,simpleTitleCaseMapping:0x182A
 },
 { code:0x182B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x182B
  ,simpleLowerCaseMapping:0x182B
  ,simpleTitleCaseMapping:0x182B
 },
 { code:0x182C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x182C
  ,simpleLowerCaseMapping:0x182C
  ,simpleTitleCaseMapping:0x182C
 },
 { code:0x182D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x182D
  ,simpleLowerCaseMapping:0x182D
  ,simpleTitleCaseMapping:0x182D
 },
 { code:0x182E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x182E
  ,simpleLowerCaseMapping:0x182E
  ,simpleTitleCaseMapping:0x182E
 },
 { code:0x182F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x182F
  ,simpleLowerCaseMapping:0x182F
  ,simpleTitleCaseMapping:0x182F
 },
 { code:0x1830
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1830
  ,simpleLowerCaseMapping:0x1830
  ,simpleTitleCaseMapping:0x1830
 },
 { code:0x1831
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1831
  ,simpleLowerCaseMapping:0x1831
  ,simpleTitleCaseMapping:0x1831
 },
 { code:0x1832
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1832
  ,simpleLowerCaseMapping:0x1832
  ,simpleTitleCaseMapping:0x1832
 },
 { code:0x1833
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1833
  ,simpleLowerCaseMapping:0x1833
  ,simpleTitleCaseMapping:0x1833
 },
 { code:0x1834
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1834
  ,simpleLowerCaseMapping:0x1834
  ,simpleTitleCaseMapping:0x1834
 },
 { code:0x1835
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1835
  ,simpleLowerCaseMapping:0x1835
  ,simpleTitleCaseMapping:0x1835
 },
 { code:0x1836
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1836
  ,simpleLowerCaseMapping:0x1836
  ,simpleTitleCaseMapping:0x1836
 },
 { code:0x1837
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1837
  ,simpleLowerCaseMapping:0x1837
  ,simpleTitleCaseMapping:0x1837
 },
 { code:0x1838
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1838
  ,simpleLowerCaseMapping:0x1838
  ,simpleTitleCaseMapping:0x1838
 },
 { code:0x1839
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1839
  ,simpleLowerCaseMapping:0x1839
  ,simpleTitleCaseMapping:0x1839
 },
 { code:0x183A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x183A
  ,simpleLowerCaseMapping:0x183A
  ,simpleTitleCaseMapping:0x183A
 },
 { code:0x183B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x183B
  ,simpleLowerCaseMapping:0x183B
  ,simpleTitleCaseMapping:0x183B
 },
 { code:0x183C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x183C
  ,simpleLowerCaseMapping:0x183C
  ,simpleTitleCaseMapping:0x183C
 },
 { code:0x183D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x183D
  ,simpleLowerCaseMapping:0x183D
  ,simpleTitleCaseMapping:0x183D
 },
 { code:0x183E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x183E
  ,simpleLowerCaseMapping:0x183E
  ,simpleTitleCaseMapping:0x183E
 },
 { code:0x183F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x183F
  ,simpleLowerCaseMapping:0x183F
  ,simpleTitleCaseMapping:0x183F
 },
 { code:0x1840
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1840
  ,simpleLowerCaseMapping:0x1840
  ,simpleTitleCaseMapping:0x1840
 },
 { code:0x1841
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1841
  ,simpleLowerCaseMapping:0x1841
  ,simpleTitleCaseMapping:0x1841
 },
 { code:0x1842
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1842
  ,simpleLowerCaseMapping:0x1842
  ,simpleTitleCaseMapping:0x1842
 },
 { code:0x1843
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1843
  ,simpleLowerCaseMapping:0x1843
  ,simpleTitleCaseMapping:0x1843
 },
 { code:0x1844
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1844
  ,simpleLowerCaseMapping:0x1844
  ,simpleTitleCaseMapping:0x1844
 },
 { code:0x1845
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1845
  ,simpleLowerCaseMapping:0x1845
  ,simpleTitleCaseMapping:0x1845
 },
 { code:0x1846
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1846
  ,simpleLowerCaseMapping:0x1846
  ,simpleTitleCaseMapping:0x1846
 },
 { code:0x1847
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1847
  ,simpleLowerCaseMapping:0x1847
  ,simpleTitleCaseMapping:0x1847
 },
 { code:0x1848
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1848
  ,simpleLowerCaseMapping:0x1848
  ,simpleTitleCaseMapping:0x1848
 },
 { code:0x1849
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1849
  ,simpleLowerCaseMapping:0x1849
  ,simpleTitleCaseMapping:0x1849
 },
 { code:0x184A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x184A
  ,simpleLowerCaseMapping:0x184A
  ,simpleTitleCaseMapping:0x184A
 },
 { code:0x184B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x184B
  ,simpleLowerCaseMapping:0x184B
  ,simpleTitleCaseMapping:0x184B
 },
 { code:0x184C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x184C
  ,simpleLowerCaseMapping:0x184C
  ,simpleTitleCaseMapping:0x184C
 },
 { code:0x184D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x184D
  ,simpleLowerCaseMapping:0x184D
  ,simpleTitleCaseMapping:0x184D
 },
 { code:0x184E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x184E
  ,simpleLowerCaseMapping:0x184E
  ,simpleTitleCaseMapping:0x184E
 },
 { code:0x184F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x184F
  ,simpleLowerCaseMapping:0x184F
  ,simpleTitleCaseMapping:0x184F
 },
 { code:0x1850
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1850
  ,simpleLowerCaseMapping:0x1850
  ,simpleTitleCaseMapping:0x1850
 },
 { code:0x1851
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1851
  ,simpleLowerCaseMapping:0x1851
  ,simpleTitleCaseMapping:0x1851
 },
 { code:0x1852
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1852
  ,simpleLowerCaseMapping:0x1852
  ,simpleTitleCaseMapping:0x1852
 },
 { code:0x1853
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1853
  ,simpleLowerCaseMapping:0x1853
  ,simpleTitleCaseMapping:0x1853
 },
 { code:0x1854
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1854
  ,simpleLowerCaseMapping:0x1854
  ,simpleTitleCaseMapping:0x1854
 },
 { code:0x1855
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1855
  ,simpleLowerCaseMapping:0x1855
  ,simpleTitleCaseMapping:0x1855
 },
 { code:0x1856
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1856
  ,simpleLowerCaseMapping:0x1856
  ,simpleTitleCaseMapping:0x1856
 },
 { code:0x1857
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1857
  ,simpleLowerCaseMapping:0x1857
  ,simpleTitleCaseMapping:0x1857
 },
 { code:0x1858
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1858
  ,simpleLowerCaseMapping:0x1858
  ,simpleTitleCaseMapping:0x1858
 },
 { code:0x1859
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1859
  ,simpleLowerCaseMapping:0x1859
  ,simpleTitleCaseMapping:0x1859
 },
 { code:0x185A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x185A
  ,simpleLowerCaseMapping:0x185A
  ,simpleTitleCaseMapping:0x185A
 },
 { code:0x185B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x185B
  ,simpleLowerCaseMapping:0x185B
  ,simpleTitleCaseMapping:0x185B
 },
 { code:0x185C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x185C
  ,simpleLowerCaseMapping:0x185C
  ,simpleTitleCaseMapping:0x185C
 },
 { code:0x185D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x185D
  ,simpleLowerCaseMapping:0x185D
  ,simpleTitleCaseMapping:0x185D
 },
 { code:0x185E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x185E
  ,simpleLowerCaseMapping:0x185E
  ,simpleTitleCaseMapping:0x185E
 },
 { code:0x185F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x185F
  ,simpleLowerCaseMapping:0x185F
  ,simpleTitleCaseMapping:0x185F
 },
 { code:0x1860
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1860
  ,simpleLowerCaseMapping:0x1860
  ,simpleTitleCaseMapping:0x1860
 },
 { code:0x1861
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1861
  ,simpleLowerCaseMapping:0x1861
  ,simpleTitleCaseMapping:0x1861
 },
 { code:0x1862
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1862
  ,simpleLowerCaseMapping:0x1862
  ,simpleTitleCaseMapping:0x1862
 },
 { code:0x1863
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1863
  ,simpleLowerCaseMapping:0x1863
  ,simpleTitleCaseMapping:0x1863
 },
 { code:0x1864
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1864
  ,simpleLowerCaseMapping:0x1864
  ,simpleTitleCaseMapping:0x1864
 },
 { code:0x1865
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1865
  ,simpleLowerCaseMapping:0x1865
  ,simpleTitleCaseMapping:0x1865
 },
 { code:0x1866
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1866
  ,simpleLowerCaseMapping:0x1866
  ,simpleTitleCaseMapping:0x1866
 },
 { code:0x1867
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1867
  ,simpleLowerCaseMapping:0x1867
  ,simpleTitleCaseMapping:0x1867
 },
 { code:0x1868
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1868
  ,simpleLowerCaseMapping:0x1868
  ,simpleTitleCaseMapping:0x1868
 },
 { code:0x1869
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1869
  ,simpleLowerCaseMapping:0x1869
  ,simpleTitleCaseMapping:0x1869
 },
 { code:0x186A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x186A
  ,simpleLowerCaseMapping:0x186A
  ,simpleTitleCaseMapping:0x186A
 },
 { code:0x186B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x186B
  ,simpleLowerCaseMapping:0x186B
  ,simpleTitleCaseMapping:0x186B
 },
 { code:0x186C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x186C
  ,simpleLowerCaseMapping:0x186C
  ,simpleTitleCaseMapping:0x186C
 },
 { code:0x186D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x186D
  ,simpleLowerCaseMapping:0x186D
  ,simpleTitleCaseMapping:0x186D
 },
 { code:0x186E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x186E
  ,simpleLowerCaseMapping:0x186E
  ,simpleTitleCaseMapping:0x186E
 },
 { code:0x186F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x186F
  ,simpleLowerCaseMapping:0x186F
  ,simpleTitleCaseMapping:0x186F
 },
 { code:0x1870
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1870
  ,simpleLowerCaseMapping:0x1870
  ,simpleTitleCaseMapping:0x1870
 },
 { code:0x1871
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1871
  ,simpleLowerCaseMapping:0x1871
  ,simpleTitleCaseMapping:0x1871
 },
 { code:0x1872
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1872
  ,simpleLowerCaseMapping:0x1872
  ,simpleTitleCaseMapping:0x1872
 },
 { code:0x1873
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1873
  ,simpleLowerCaseMapping:0x1873
  ,simpleTitleCaseMapping:0x1873
 },
 { code:0x1874
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1874
  ,simpleLowerCaseMapping:0x1874
  ,simpleTitleCaseMapping:0x1874
 },
 { code:0x1875
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1875
  ,simpleLowerCaseMapping:0x1875
  ,simpleTitleCaseMapping:0x1875
 },
 { code:0x1876
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1876
  ,simpleLowerCaseMapping:0x1876
  ,simpleTitleCaseMapping:0x1876
 },
 { code:0x1877
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1877
  ,simpleLowerCaseMapping:0x1877
  ,simpleTitleCaseMapping:0x1877
 },
 { code:0x1880
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1880
  ,simpleLowerCaseMapping:0x1880
  ,simpleTitleCaseMapping:0x1880
 },
 { code:0x1881
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1881
  ,simpleLowerCaseMapping:0x1881
  ,simpleTitleCaseMapping:0x1881
 },
 { code:0x1882
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1882
  ,simpleLowerCaseMapping:0x1882
  ,simpleTitleCaseMapping:0x1882
 },
 { code:0x1883
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1883
  ,simpleLowerCaseMapping:0x1883
  ,simpleTitleCaseMapping:0x1883
 },
 { code:0x1884
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1884
  ,simpleLowerCaseMapping:0x1884
  ,simpleTitleCaseMapping:0x1884
 },
 { code:0x1885
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1885
  ,simpleLowerCaseMapping:0x1885
  ,simpleTitleCaseMapping:0x1885
 },
 { code:0x1886
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1886
  ,simpleLowerCaseMapping:0x1886
  ,simpleTitleCaseMapping:0x1886
 },
 { code:0x1887
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1887
  ,simpleLowerCaseMapping:0x1887
  ,simpleTitleCaseMapping:0x1887
 },
 { code:0x1888
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1888
  ,simpleLowerCaseMapping:0x1888
  ,simpleTitleCaseMapping:0x1888
 },
 { code:0x1889
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1889
  ,simpleLowerCaseMapping:0x1889
  ,simpleTitleCaseMapping:0x1889
 },
 { code:0x188A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x188A
  ,simpleLowerCaseMapping:0x188A
  ,simpleTitleCaseMapping:0x188A
 },
 { code:0x188B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x188B
  ,simpleLowerCaseMapping:0x188B
  ,simpleTitleCaseMapping:0x188B
 },
 { code:0x188C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x188C
  ,simpleLowerCaseMapping:0x188C
  ,simpleTitleCaseMapping:0x188C
 },
 { code:0x188D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x188D
  ,simpleLowerCaseMapping:0x188D
  ,simpleTitleCaseMapping:0x188D
 },
 { code:0x188E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x188E
  ,simpleLowerCaseMapping:0x188E
  ,simpleTitleCaseMapping:0x188E
 },
 { code:0x188F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x188F
  ,simpleLowerCaseMapping:0x188F
  ,simpleTitleCaseMapping:0x188F
 },
 { code:0x1890
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1890
  ,simpleLowerCaseMapping:0x1890
  ,simpleTitleCaseMapping:0x1890
 },
 { code:0x1891
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1891
  ,simpleLowerCaseMapping:0x1891
  ,simpleTitleCaseMapping:0x1891
 },
 { code:0x1892
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1892
  ,simpleLowerCaseMapping:0x1892
  ,simpleTitleCaseMapping:0x1892
 },
 { code:0x1893
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1893
  ,simpleLowerCaseMapping:0x1893
  ,simpleTitleCaseMapping:0x1893
 },
 { code:0x1894
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1894
  ,simpleLowerCaseMapping:0x1894
  ,simpleTitleCaseMapping:0x1894
 },
 { code:0x1895
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1895
  ,simpleLowerCaseMapping:0x1895
  ,simpleTitleCaseMapping:0x1895
 },
 { code:0x1896
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1896
  ,simpleLowerCaseMapping:0x1896
  ,simpleTitleCaseMapping:0x1896
 },
 { code:0x1897
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1897
  ,simpleLowerCaseMapping:0x1897
  ,simpleTitleCaseMapping:0x1897
 },
 { code:0x1898
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1898
  ,simpleLowerCaseMapping:0x1898
  ,simpleTitleCaseMapping:0x1898
 },
 { code:0x1899
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1899
  ,simpleLowerCaseMapping:0x1899
  ,simpleTitleCaseMapping:0x1899
 },
 { code:0x189A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x189A
  ,simpleLowerCaseMapping:0x189A
  ,simpleTitleCaseMapping:0x189A
 },
 { code:0x189B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x189B
  ,simpleLowerCaseMapping:0x189B
  ,simpleTitleCaseMapping:0x189B
 },
 { code:0x189C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x189C
  ,simpleLowerCaseMapping:0x189C
  ,simpleTitleCaseMapping:0x189C
 },
 { code:0x189D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x189D
  ,simpleLowerCaseMapping:0x189D
  ,simpleTitleCaseMapping:0x189D
 },
 { code:0x189E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x189E
  ,simpleLowerCaseMapping:0x189E
  ,simpleTitleCaseMapping:0x189E
 },
 { code:0x189F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x189F
  ,simpleLowerCaseMapping:0x189F
  ,simpleTitleCaseMapping:0x189F
 },
 { code:0x18A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x18A0
  ,simpleLowerCaseMapping:0x18A0
  ,simpleTitleCaseMapping:0x18A0
 },
 { code:0x18A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x18A1
  ,simpleLowerCaseMapping:0x18A1
  ,simpleTitleCaseMapping:0x18A1
 },
 { code:0x18A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x18A2
  ,simpleLowerCaseMapping:0x18A2
  ,simpleTitleCaseMapping:0x18A2
 },
 { code:0x18A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x18A3
  ,simpleLowerCaseMapping:0x18A3
  ,simpleTitleCaseMapping:0x18A3
 },
 { code:0x18A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x18A4
  ,simpleLowerCaseMapping:0x18A4
  ,simpleTitleCaseMapping:0x18A4
 },
 { code:0x18A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x18A5
  ,simpleLowerCaseMapping:0x18A5
  ,simpleTitleCaseMapping:0x18A5
 },
 { code:0x18A6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x18A6
  ,simpleLowerCaseMapping:0x18A6
  ,simpleTitleCaseMapping:0x18A6
 },
 { code:0x18A7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x18A7
  ,simpleLowerCaseMapping:0x18A7
  ,simpleTitleCaseMapping:0x18A7
 },
 { code:0x18A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x18A8
  ,simpleLowerCaseMapping:0x18A8
  ,simpleTitleCaseMapping:0x18A8
 },
 { code:0x18A9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x18A9
  ,simpleLowerCaseMapping:0x18A9
  ,simpleTitleCaseMapping:0x18A9
 },
 { code:0x1900
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1900
  ,simpleLowerCaseMapping:0x1900
  ,simpleTitleCaseMapping:0x1900
 },
 { code:0x1901
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1901
  ,simpleLowerCaseMapping:0x1901
  ,simpleTitleCaseMapping:0x1901
 },
 { code:0x1902
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1902
  ,simpleLowerCaseMapping:0x1902
  ,simpleTitleCaseMapping:0x1902
 },
 { code:0x1903
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1903
  ,simpleLowerCaseMapping:0x1903
  ,simpleTitleCaseMapping:0x1903
 },
 { code:0x1904
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1904
  ,simpleLowerCaseMapping:0x1904
  ,simpleTitleCaseMapping:0x1904
 },
 { code:0x1905
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1905
  ,simpleLowerCaseMapping:0x1905
  ,simpleTitleCaseMapping:0x1905
 },
 { code:0x1906
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1906
  ,simpleLowerCaseMapping:0x1906
  ,simpleTitleCaseMapping:0x1906
 },
 { code:0x1907
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1907
  ,simpleLowerCaseMapping:0x1907
  ,simpleTitleCaseMapping:0x1907
 },
 { code:0x1908
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1908
  ,simpleLowerCaseMapping:0x1908
  ,simpleTitleCaseMapping:0x1908
 },
 { code:0x1909
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1909
  ,simpleLowerCaseMapping:0x1909
  ,simpleTitleCaseMapping:0x1909
 },
 { code:0x190A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x190A
  ,simpleLowerCaseMapping:0x190A
  ,simpleTitleCaseMapping:0x190A
 },
 { code:0x190B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x190B
  ,simpleLowerCaseMapping:0x190B
  ,simpleTitleCaseMapping:0x190B
 },
 { code:0x190C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x190C
  ,simpleLowerCaseMapping:0x190C
  ,simpleTitleCaseMapping:0x190C
 },
 { code:0x190D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x190D
  ,simpleLowerCaseMapping:0x190D
  ,simpleTitleCaseMapping:0x190D
 },
 { code:0x190E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x190E
  ,simpleLowerCaseMapping:0x190E
  ,simpleTitleCaseMapping:0x190E
 },
 { code:0x190F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x190F
  ,simpleLowerCaseMapping:0x190F
  ,simpleTitleCaseMapping:0x190F
 },
 { code:0x1910
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1910
  ,simpleLowerCaseMapping:0x1910
  ,simpleTitleCaseMapping:0x1910
 },
 { code:0x1911
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1911
  ,simpleLowerCaseMapping:0x1911
  ,simpleTitleCaseMapping:0x1911
 },
 { code:0x1912
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1912
  ,simpleLowerCaseMapping:0x1912
  ,simpleTitleCaseMapping:0x1912
 },
 { code:0x1913
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1913
  ,simpleLowerCaseMapping:0x1913
  ,simpleTitleCaseMapping:0x1913
 },
 { code:0x1914
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1914
  ,simpleLowerCaseMapping:0x1914
  ,simpleTitleCaseMapping:0x1914
 },
 { code:0x1915
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1915
  ,simpleLowerCaseMapping:0x1915
  ,simpleTitleCaseMapping:0x1915
 },
 { code:0x1916
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1916
  ,simpleLowerCaseMapping:0x1916
  ,simpleTitleCaseMapping:0x1916
 },
 { code:0x1917
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1917
  ,simpleLowerCaseMapping:0x1917
  ,simpleTitleCaseMapping:0x1917
 },
 { code:0x1918
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1918
  ,simpleLowerCaseMapping:0x1918
  ,simpleTitleCaseMapping:0x1918
 },
 { code:0x1919
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1919
  ,simpleLowerCaseMapping:0x1919
  ,simpleTitleCaseMapping:0x1919
 },
 { code:0x191A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x191A
  ,simpleLowerCaseMapping:0x191A
  ,simpleTitleCaseMapping:0x191A
 },
 { code:0x191B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x191B
  ,simpleLowerCaseMapping:0x191B
  ,simpleTitleCaseMapping:0x191B
 },
 { code:0x191C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x191C
  ,simpleLowerCaseMapping:0x191C
  ,simpleTitleCaseMapping:0x191C
 },
 { code:0x1920
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1920
  ,simpleLowerCaseMapping:0x1920
  ,simpleTitleCaseMapping:0x1920
 },
 { code:0x1921
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1921
  ,simpleLowerCaseMapping:0x1921
  ,simpleTitleCaseMapping:0x1921
 },
 { code:0x1922
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1922
  ,simpleLowerCaseMapping:0x1922
  ,simpleTitleCaseMapping:0x1922
 },
 { code:0x1923
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1923
  ,simpleLowerCaseMapping:0x1923
  ,simpleTitleCaseMapping:0x1923
 },
 { code:0x1924
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1924
  ,simpleLowerCaseMapping:0x1924
  ,simpleTitleCaseMapping:0x1924
 },
 { code:0x1925
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1925
  ,simpleLowerCaseMapping:0x1925
  ,simpleTitleCaseMapping:0x1925
 },
 { code:0x1926
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1926
  ,simpleLowerCaseMapping:0x1926
  ,simpleTitleCaseMapping:0x1926
 },
 { code:0x1927
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1927
  ,simpleLowerCaseMapping:0x1927
  ,simpleTitleCaseMapping:0x1927
 },
 { code:0x1928
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1928
  ,simpleLowerCaseMapping:0x1928
  ,simpleTitleCaseMapping:0x1928
 },
 { code:0x1929
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1929
  ,simpleLowerCaseMapping:0x1929
  ,simpleTitleCaseMapping:0x1929
 },
 { code:0x192A
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x192A
  ,simpleLowerCaseMapping:0x192A
  ,simpleTitleCaseMapping:0x192A
 },
 { code:0x192B
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x192B
  ,simpleLowerCaseMapping:0x192B
  ,simpleTitleCaseMapping:0x192B
 },
 { code:0x1930
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1930
  ,simpleLowerCaseMapping:0x1930
  ,simpleTitleCaseMapping:0x1930
 },
 { code:0x1931
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1931
  ,simpleLowerCaseMapping:0x1931
  ,simpleTitleCaseMapping:0x1931
 },
 { code:0x1932
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1932
  ,simpleLowerCaseMapping:0x1932
  ,simpleTitleCaseMapping:0x1932
 },
 { code:0x1933
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1933
  ,simpleLowerCaseMapping:0x1933
  ,simpleTitleCaseMapping:0x1933
 },
 { code:0x1934
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1934
  ,simpleLowerCaseMapping:0x1934
  ,simpleTitleCaseMapping:0x1934
 },
 { code:0x1935
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1935
  ,simpleLowerCaseMapping:0x1935
  ,simpleTitleCaseMapping:0x1935
 },
 { code:0x1936
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1936
  ,simpleLowerCaseMapping:0x1936
  ,simpleTitleCaseMapping:0x1936
 },
 { code:0x1937
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1937
  ,simpleLowerCaseMapping:0x1937
  ,simpleTitleCaseMapping:0x1937
 },
 { code:0x1938
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1938
  ,simpleLowerCaseMapping:0x1938
  ,simpleTitleCaseMapping:0x1938
 },
 { code:0x1939
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1939
  ,simpleLowerCaseMapping:0x1939
  ,simpleTitleCaseMapping:0x1939
 },
 { code:0x193A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x193A
  ,simpleLowerCaseMapping:0x193A
  ,simpleTitleCaseMapping:0x193A
 },
 { code:0x193B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x193B
  ,simpleLowerCaseMapping:0x193B
  ,simpleTitleCaseMapping:0x193B
 },
 { code:0x1940
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1940
  ,simpleLowerCaseMapping:0x1940
  ,simpleTitleCaseMapping:0x1940
 },
 { code:0x1944
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1944
  ,simpleLowerCaseMapping:0x1944
  ,simpleTitleCaseMapping:0x1944
 },
 { code:0x1945
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1945
  ,simpleLowerCaseMapping:0x1945
  ,simpleTitleCaseMapping:0x1945
 },
 { code:0x1946
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1946
  ,simpleLowerCaseMapping:0x1946
  ,simpleTitleCaseMapping:0x1946
 },
 { code:0x1947
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1947
  ,simpleLowerCaseMapping:0x1947
  ,simpleTitleCaseMapping:0x1947
 },
 { code:0x1948
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1948
  ,simpleLowerCaseMapping:0x1948
  ,simpleTitleCaseMapping:0x1948
 },
 { code:0x1949
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1949
  ,simpleLowerCaseMapping:0x1949
  ,simpleTitleCaseMapping:0x1949
 },
 { code:0x194A
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x194A
  ,simpleLowerCaseMapping:0x194A
  ,simpleTitleCaseMapping:0x194A
 },
 { code:0x194B
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x194B
  ,simpleLowerCaseMapping:0x194B
  ,simpleTitleCaseMapping:0x194B
 },
 { code:0x194C
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x194C
  ,simpleLowerCaseMapping:0x194C
  ,simpleTitleCaseMapping:0x194C
 },
 { code:0x194D
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x194D
  ,simpleLowerCaseMapping:0x194D
  ,simpleTitleCaseMapping:0x194D
 },
 { code:0x194E
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x194E
  ,simpleLowerCaseMapping:0x194E
  ,simpleTitleCaseMapping:0x194E
 },
 { code:0x194F
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x194F
  ,simpleLowerCaseMapping:0x194F
  ,simpleTitleCaseMapping:0x194F
 },
 { code:0x1950
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1950
  ,simpleLowerCaseMapping:0x1950
  ,simpleTitleCaseMapping:0x1950
 },
 { code:0x1951
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1951
  ,simpleLowerCaseMapping:0x1951
  ,simpleTitleCaseMapping:0x1951
 },
 { code:0x1952
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1952
  ,simpleLowerCaseMapping:0x1952
  ,simpleTitleCaseMapping:0x1952
 },
 { code:0x1953
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1953
  ,simpleLowerCaseMapping:0x1953
  ,simpleTitleCaseMapping:0x1953
 },
 { code:0x1954
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1954
  ,simpleLowerCaseMapping:0x1954
  ,simpleTitleCaseMapping:0x1954
 },
 { code:0x1955
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1955
  ,simpleLowerCaseMapping:0x1955
  ,simpleTitleCaseMapping:0x1955
 },
 { code:0x1956
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1956
  ,simpleLowerCaseMapping:0x1956
  ,simpleTitleCaseMapping:0x1956
 },
 { code:0x1957
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1957
  ,simpleLowerCaseMapping:0x1957
  ,simpleTitleCaseMapping:0x1957
 },
 { code:0x1958
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1958
  ,simpleLowerCaseMapping:0x1958
  ,simpleTitleCaseMapping:0x1958
 },
 { code:0x1959
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1959
  ,simpleLowerCaseMapping:0x1959
  ,simpleTitleCaseMapping:0x1959
 },
 { code:0x195A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x195A
  ,simpleLowerCaseMapping:0x195A
  ,simpleTitleCaseMapping:0x195A
 },
 { code:0x195B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x195B
  ,simpleLowerCaseMapping:0x195B
  ,simpleTitleCaseMapping:0x195B
 },
 { code:0x195C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x195C
  ,simpleLowerCaseMapping:0x195C
  ,simpleTitleCaseMapping:0x195C
 },
 { code:0x195D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x195D
  ,simpleLowerCaseMapping:0x195D
  ,simpleTitleCaseMapping:0x195D
 },
 { code:0x195E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x195E
  ,simpleLowerCaseMapping:0x195E
  ,simpleTitleCaseMapping:0x195E
 },
 { code:0x195F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x195F
  ,simpleLowerCaseMapping:0x195F
  ,simpleTitleCaseMapping:0x195F
 },
 { code:0x1960
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1960
  ,simpleLowerCaseMapping:0x1960
  ,simpleTitleCaseMapping:0x1960
 },
 { code:0x1961
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1961
  ,simpleLowerCaseMapping:0x1961
  ,simpleTitleCaseMapping:0x1961
 },
 { code:0x1962
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1962
  ,simpleLowerCaseMapping:0x1962
  ,simpleTitleCaseMapping:0x1962
 },
 { code:0x1963
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1963
  ,simpleLowerCaseMapping:0x1963
  ,simpleTitleCaseMapping:0x1963
 },
 { code:0x1964
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1964
  ,simpleLowerCaseMapping:0x1964
  ,simpleTitleCaseMapping:0x1964
 },
 { code:0x1965
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1965
  ,simpleLowerCaseMapping:0x1965
  ,simpleTitleCaseMapping:0x1965
 },
 { code:0x1966
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1966
  ,simpleLowerCaseMapping:0x1966
  ,simpleTitleCaseMapping:0x1966
 },
 { code:0x1967
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1967
  ,simpleLowerCaseMapping:0x1967
  ,simpleTitleCaseMapping:0x1967
 },
 { code:0x1968
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1968
  ,simpleLowerCaseMapping:0x1968
  ,simpleTitleCaseMapping:0x1968
 },
 { code:0x1969
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1969
  ,simpleLowerCaseMapping:0x1969
  ,simpleTitleCaseMapping:0x1969
 },
 { code:0x196A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x196A
  ,simpleLowerCaseMapping:0x196A
  ,simpleTitleCaseMapping:0x196A
 },
 { code:0x196B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x196B
  ,simpleLowerCaseMapping:0x196B
  ,simpleTitleCaseMapping:0x196B
 },
 { code:0x196C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x196C
  ,simpleLowerCaseMapping:0x196C
  ,simpleTitleCaseMapping:0x196C
 },
 { code:0x196D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x196D
  ,simpleLowerCaseMapping:0x196D
  ,simpleTitleCaseMapping:0x196D
 },
 { code:0x1970
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1970
  ,simpleLowerCaseMapping:0x1970
  ,simpleTitleCaseMapping:0x1970
 },
 { code:0x1971
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1971
  ,simpleLowerCaseMapping:0x1971
  ,simpleTitleCaseMapping:0x1971
 },
 { code:0x1972
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1972
  ,simpleLowerCaseMapping:0x1972
  ,simpleTitleCaseMapping:0x1972
 },
 { code:0x1973
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1973
  ,simpleLowerCaseMapping:0x1973
  ,simpleTitleCaseMapping:0x1973
 },
 { code:0x1974
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1974
  ,simpleLowerCaseMapping:0x1974
  ,simpleTitleCaseMapping:0x1974
 },
 { code:0x1980
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1980
  ,simpleLowerCaseMapping:0x1980
  ,simpleTitleCaseMapping:0x1980
 },
 { code:0x1981
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1981
  ,simpleLowerCaseMapping:0x1981
  ,simpleTitleCaseMapping:0x1981
 },
 { code:0x1982
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1982
  ,simpleLowerCaseMapping:0x1982
  ,simpleTitleCaseMapping:0x1982
 },
 { code:0x1983
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1983
  ,simpleLowerCaseMapping:0x1983
  ,simpleTitleCaseMapping:0x1983
 },
 { code:0x1984
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1984
  ,simpleLowerCaseMapping:0x1984
  ,simpleTitleCaseMapping:0x1984
 },
 { code:0x1985
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1985
  ,simpleLowerCaseMapping:0x1985
  ,simpleTitleCaseMapping:0x1985
 },
 { code:0x1986
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1986
  ,simpleLowerCaseMapping:0x1986
  ,simpleTitleCaseMapping:0x1986
 },
 { code:0x1987
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1987
  ,simpleLowerCaseMapping:0x1987
  ,simpleTitleCaseMapping:0x1987
 },
 { code:0x1988
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1988
  ,simpleLowerCaseMapping:0x1988
  ,simpleTitleCaseMapping:0x1988
 },
 { code:0x1989
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1989
  ,simpleLowerCaseMapping:0x1989
  ,simpleTitleCaseMapping:0x1989
 },
 { code:0x198A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x198A
  ,simpleLowerCaseMapping:0x198A
  ,simpleTitleCaseMapping:0x198A
 },
 { code:0x198B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x198B
  ,simpleLowerCaseMapping:0x198B
  ,simpleTitleCaseMapping:0x198B
 },
 { code:0x198C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x198C
  ,simpleLowerCaseMapping:0x198C
  ,simpleTitleCaseMapping:0x198C
 },
 { code:0x198D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x198D
  ,simpleLowerCaseMapping:0x198D
  ,simpleTitleCaseMapping:0x198D
 },
 { code:0x198E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x198E
  ,simpleLowerCaseMapping:0x198E
  ,simpleTitleCaseMapping:0x198E
 },
 { code:0x198F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x198F
  ,simpleLowerCaseMapping:0x198F
  ,simpleTitleCaseMapping:0x198F
 },
 { code:0x1990
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1990
  ,simpleLowerCaseMapping:0x1990
  ,simpleTitleCaseMapping:0x1990
 },
 { code:0x1991
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1991
  ,simpleLowerCaseMapping:0x1991
  ,simpleTitleCaseMapping:0x1991
 },
 { code:0x1992
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1992
  ,simpleLowerCaseMapping:0x1992
  ,simpleTitleCaseMapping:0x1992
 },
 { code:0x1993
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1993
  ,simpleLowerCaseMapping:0x1993
  ,simpleTitleCaseMapping:0x1993
 },
 { code:0x1994
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1994
  ,simpleLowerCaseMapping:0x1994
  ,simpleTitleCaseMapping:0x1994
 },
 { code:0x1995
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1995
  ,simpleLowerCaseMapping:0x1995
  ,simpleTitleCaseMapping:0x1995
 },
 { code:0x1996
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1996
  ,simpleLowerCaseMapping:0x1996
  ,simpleTitleCaseMapping:0x1996
 },
 { code:0x1997
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1997
  ,simpleLowerCaseMapping:0x1997
  ,simpleTitleCaseMapping:0x1997
 },
 { code:0x1998
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1998
  ,simpleLowerCaseMapping:0x1998
  ,simpleTitleCaseMapping:0x1998
 },
 { code:0x1999
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1999
  ,simpleLowerCaseMapping:0x1999
  ,simpleTitleCaseMapping:0x1999
 },
 { code:0x199A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x199A
  ,simpleLowerCaseMapping:0x199A
  ,simpleTitleCaseMapping:0x199A
 },
 { code:0x199B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x199B
  ,simpleLowerCaseMapping:0x199B
  ,simpleTitleCaseMapping:0x199B
 },
 { code:0x199C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x199C
  ,simpleLowerCaseMapping:0x199C
  ,simpleTitleCaseMapping:0x199C
 },
 { code:0x199D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x199D
  ,simpleLowerCaseMapping:0x199D
  ,simpleTitleCaseMapping:0x199D
 },
 { code:0x199E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x199E
  ,simpleLowerCaseMapping:0x199E
  ,simpleTitleCaseMapping:0x199E
 },
 { code:0x199F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x199F
  ,simpleLowerCaseMapping:0x199F
  ,simpleTitleCaseMapping:0x199F
 },
 { code:0x19A0
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19A0
  ,simpleLowerCaseMapping:0x19A0
  ,simpleTitleCaseMapping:0x19A0
 },
 { code:0x19A1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19A1
  ,simpleLowerCaseMapping:0x19A1
  ,simpleTitleCaseMapping:0x19A1
 },
 { code:0x19A2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19A2
  ,simpleLowerCaseMapping:0x19A2
  ,simpleTitleCaseMapping:0x19A2
 },
 { code:0x19A3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19A3
  ,simpleLowerCaseMapping:0x19A3
  ,simpleTitleCaseMapping:0x19A3
 },
 { code:0x19A4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19A4
  ,simpleLowerCaseMapping:0x19A4
  ,simpleTitleCaseMapping:0x19A4
 },
 { code:0x19A5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19A5
  ,simpleLowerCaseMapping:0x19A5
  ,simpleTitleCaseMapping:0x19A5
 },
 { code:0x19A6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19A6
  ,simpleLowerCaseMapping:0x19A6
  ,simpleTitleCaseMapping:0x19A6
 },
 { code:0x19A7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19A7
  ,simpleLowerCaseMapping:0x19A7
  ,simpleTitleCaseMapping:0x19A7
 },
 { code:0x19A8
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19A8
  ,simpleLowerCaseMapping:0x19A8
  ,simpleTitleCaseMapping:0x19A8
 },
 { code:0x19A9
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19A9
  ,simpleLowerCaseMapping:0x19A9
  ,simpleTitleCaseMapping:0x19A9
 },
 { code:0x19B0
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19B0
  ,simpleLowerCaseMapping:0x19B0
  ,simpleTitleCaseMapping:0x19B0
 },
 { code:0x19B1
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19B1
  ,simpleLowerCaseMapping:0x19B1
  ,simpleTitleCaseMapping:0x19B1
 },
 { code:0x19B2
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19B2
  ,simpleLowerCaseMapping:0x19B2
  ,simpleTitleCaseMapping:0x19B2
 },
 { code:0x19B3
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19B3
  ,simpleLowerCaseMapping:0x19B3
  ,simpleTitleCaseMapping:0x19B3
 },
 { code:0x19B4
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19B4
  ,simpleLowerCaseMapping:0x19B4
  ,simpleTitleCaseMapping:0x19B4
 },
 { code:0x19B5
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19B5
  ,simpleLowerCaseMapping:0x19B5
  ,simpleTitleCaseMapping:0x19B5
 },
 { code:0x19B6
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19B6
  ,simpleLowerCaseMapping:0x19B6
  ,simpleTitleCaseMapping:0x19B6
 },
 { code:0x19B7
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19B7
  ,simpleLowerCaseMapping:0x19B7
  ,simpleTitleCaseMapping:0x19B7
 },
 { code:0x19B8
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19B8
  ,simpleLowerCaseMapping:0x19B8
  ,simpleTitleCaseMapping:0x19B8
 },
 { code:0x19B9
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19B9
  ,simpleLowerCaseMapping:0x19B9
  ,simpleTitleCaseMapping:0x19B9
 },
 { code:0x19BA
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19BA
  ,simpleLowerCaseMapping:0x19BA
  ,simpleTitleCaseMapping:0x19BA
 },
 { code:0x19BB
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19BB
  ,simpleLowerCaseMapping:0x19BB
  ,simpleTitleCaseMapping:0x19BB
 },
 { code:0x19BC
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19BC
  ,simpleLowerCaseMapping:0x19BC
  ,simpleTitleCaseMapping:0x19BC
 },
 { code:0x19BD
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19BD
  ,simpleLowerCaseMapping:0x19BD
  ,simpleTitleCaseMapping:0x19BD
 },
 { code:0x19BE
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19BE
  ,simpleLowerCaseMapping:0x19BE
  ,simpleTitleCaseMapping:0x19BE
 },
 { code:0x19BF
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19BF
  ,simpleLowerCaseMapping:0x19BF
  ,simpleTitleCaseMapping:0x19BF
 },
 { code:0x19C0
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19C0
  ,simpleLowerCaseMapping:0x19C0
  ,simpleTitleCaseMapping:0x19C0
 },
 { code:0x19C1
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19C1
  ,simpleLowerCaseMapping:0x19C1
  ,simpleTitleCaseMapping:0x19C1
 },
 { code:0x19C2
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19C2
  ,simpleLowerCaseMapping:0x19C2
  ,simpleTitleCaseMapping:0x19C2
 },
 { code:0x19C3
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19C3
  ,simpleLowerCaseMapping:0x19C3
  ,simpleTitleCaseMapping:0x19C3
 },
 { code:0x19C4
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19C4
  ,simpleLowerCaseMapping:0x19C4
  ,simpleTitleCaseMapping:0x19C4
 },
 { code:0x19C5
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19C5
  ,simpleLowerCaseMapping:0x19C5
  ,simpleTitleCaseMapping:0x19C5
 },
 { code:0x19C6
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19C6
  ,simpleLowerCaseMapping:0x19C6
  ,simpleTitleCaseMapping:0x19C6
 },
 { code:0x19C7
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x19C7
  ,simpleLowerCaseMapping:0x19C7
  ,simpleTitleCaseMapping:0x19C7
 },
 { code:0x19C8
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19C8
  ,simpleLowerCaseMapping:0x19C8
  ,simpleTitleCaseMapping:0x19C8
 },
 { code:0x19C9
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x19C9
  ,simpleLowerCaseMapping:0x19C9
  ,simpleTitleCaseMapping:0x19C9
 },
 { code:0x19D0
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x19D0
  ,simpleLowerCaseMapping:0x19D0
  ,simpleTitleCaseMapping:0x19D0
 },
 { code:0x19D1
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x19D1
  ,simpleLowerCaseMapping:0x19D1
  ,simpleTitleCaseMapping:0x19D1
 },
 { code:0x19D2
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x19D2
  ,simpleLowerCaseMapping:0x19D2
  ,simpleTitleCaseMapping:0x19D2
 },
 { code:0x19D3
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x19D3
  ,simpleLowerCaseMapping:0x19D3
  ,simpleTitleCaseMapping:0x19D3
 },
 { code:0x19D4
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x19D4
  ,simpleLowerCaseMapping:0x19D4
  ,simpleTitleCaseMapping:0x19D4
 },
 { code:0x19D5
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x19D5
  ,simpleLowerCaseMapping:0x19D5
  ,simpleTitleCaseMapping:0x19D5
 },
 { code:0x19D6
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x19D6
  ,simpleLowerCaseMapping:0x19D6
  ,simpleTitleCaseMapping:0x19D6
 },
 { code:0x19D7
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x19D7
  ,simpleLowerCaseMapping:0x19D7
  ,simpleTitleCaseMapping:0x19D7
 },
 { code:0x19D8
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x19D8
  ,simpleLowerCaseMapping:0x19D8
  ,simpleTitleCaseMapping:0x19D8
 },
 { code:0x19D9
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x19D9
  ,simpleLowerCaseMapping:0x19D9
  ,simpleTitleCaseMapping:0x19D9
 },
 { code:0x19DE
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x19DE
  ,simpleLowerCaseMapping:0x19DE
  ,simpleTitleCaseMapping:0x19DE
 },
 { code:0x19DF
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x19DF
  ,simpleLowerCaseMapping:0x19DF
  ,simpleTitleCaseMapping:0x19DF
 },
 { code:0x19E0
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19E0
  ,simpleLowerCaseMapping:0x19E0
  ,simpleTitleCaseMapping:0x19E0
 },
 { code:0x19E1
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19E1
  ,simpleLowerCaseMapping:0x19E1
  ,simpleTitleCaseMapping:0x19E1
 },
 { code:0x19E2
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19E2
  ,simpleLowerCaseMapping:0x19E2
  ,simpleTitleCaseMapping:0x19E2
 },
 { code:0x19E3
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19E3
  ,simpleLowerCaseMapping:0x19E3
  ,simpleTitleCaseMapping:0x19E3
 },
 { code:0x19E4
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19E4
  ,simpleLowerCaseMapping:0x19E4
  ,simpleTitleCaseMapping:0x19E4
 },
 { code:0x19E5
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19E5
  ,simpleLowerCaseMapping:0x19E5
  ,simpleTitleCaseMapping:0x19E5
 },
 { code:0x19E6
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19E6
  ,simpleLowerCaseMapping:0x19E6
  ,simpleTitleCaseMapping:0x19E6
 },
 { code:0x19E7
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19E7
  ,simpleLowerCaseMapping:0x19E7
  ,simpleTitleCaseMapping:0x19E7
 },
 { code:0x19E8
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19E8
  ,simpleLowerCaseMapping:0x19E8
  ,simpleTitleCaseMapping:0x19E8
 },
 { code:0x19E9
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19E9
  ,simpleLowerCaseMapping:0x19E9
  ,simpleTitleCaseMapping:0x19E9
 },
 { code:0x19EA
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19EA
  ,simpleLowerCaseMapping:0x19EA
  ,simpleTitleCaseMapping:0x19EA
 },
 { code:0x19EB
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19EB
  ,simpleLowerCaseMapping:0x19EB
  ,simpleTitleCaseMapping:0x19EB
 },
 { code:0x19EC
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19EC
  ,simpleLowerCaseMapping:0x19EC
  ,simpleTitleCaseMapping:0x19EC
 },
 { code:0x19ED
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19ED
  ,simpleLowerCaseMapping:0x19ED
  ,simpleTitleCaseMapping:0x19ED
 },
 { code:0x19EE
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19EE
  ,simpleLowerCaseMapping:0x19EE
  ,simpleTitleCaseMapping:0x19EE
 },
 { code:0x19EF
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19EF
  ,simpleLowerCaseMapping:0x19EF
  ,simpleTitleCaseMapping:0x19EF
 },
 { code:0x19F0
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19F0
  ,simpleLowerCaseMapping:0x19F0
  ,simpleTitleCaseMapping:0x19F0
 },
 { code:0x19F1
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19F1
  ,simpleLowerCaseMapping:0x19F1
  ,simpleTitleCaseMapping:0x19F1
 },
 { code:0x19F2
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19F2
  ,simpleLowerCaseMapping:0x19F2
  ,simpleTitleCaseMapping:0x19F2
 },
 { code:0x19F3
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19F3
  ,simpleLowerCaseMapping:0x19F3
  ,simpleTitleCaseMapping:0x19F3
 },
 { code:0x19F4
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19F4
  ,simpleLowerCaseMapping:0x19F4
  ,simpleTitleCaseMapping:0x19F4
 },
 { code:0x19F5
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19F5
  ,simpleLowerCaseMapping:0x19F5
  ,simpleTitleCaseMapping:0x19F5
 },
 { code:0x19F6
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19F6
  ,simpleLowerCaseMapping:0x19F6
  ,simpleTitleCaseMapping:0x19F6
 },
 { code:0x19F7
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19F7
  ,simpleLowerCaseMapping:0x19F7
  ,simpleTitleCaseMapping:0x19F7
 },
 { code:0x19F8
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19F8
  ,simpleLowerCaseMapping:0x19F8
  ,simpleTitleCaseMapping:0x19F8
 },
 { code:0x19F9
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19F9
  ,simpleLowerCaseMapping:0x19F9
  ,simpleTitleCaseMapping:0x19F9
 },
 { code:0x19FA
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19FA
  ,simpleLowerCaseMapping:0x19FA
  ,simpleTitleCaseMapping:0x19FA
 },
 { code:0x19FB
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19FB
  ,simpleLowerCaseMapping:0x19FB
  ,simpleTitleCaseMapping:0x19FB
 },
 { code:0x19FC
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19FC
  ,simpleLowerCaseMapping:0x19FC
  ,simpleTitleCaseMapping:0x19FC
 },
 { code:0x19FD
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19FD
  ,simpleLowerCaseMapping:0x19FD
  ,simpleTitleCaseMapping:0x19FD
 },
 { code:0x19FE
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19FE
  ,simpleLowerCaseMapping:0x19FE
  ,simpleTitleCaseMapping:0x19FE
 },
 { code:0x19FF
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x19FF
  ,simpleLowerCaseMapping:0x19FF
  ,simpleTitleCaseMapping:0x19FF
 },
 { code:0x1A00
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A00
  ,simpleLowerCaseMapping:0x1A00
  ,simpleTitleCaseMapping:0x1A00
 },
 { code:0x1A01
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A01
  ,simpleLowerCaseMapping:0x1A01
  ,simpleTitleCaseMapping:0x1A01
 },
 { code:0x1A02
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A02
  ,simpleLowerCaseMapping:0x1A02
  ,simpleTitleCaseMapping:0x1A02
 },
 { code:0x1A03
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A03
  ,simpleLowerCaseMapping:0x1A03
  ,simpleTitleCaseMapping:0x1A03
 },
 { code:0x1A04
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A04
  ,simpleLowerCaseMapping:0x1A04
  ,simpleTitleCaseMapping:0x1A04
 },
 { code:0x1A05
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A05
  ,simpleLowerCaseMapping:0x1A05
  ,simpleTitleCaseMapping:0x1A05
 },
 { code:0x1A06
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A06
  ,simpleLowerCaseMapping:0x1A06
  ,simpleTitleCaseMapping:0x1A06
 },
 { code:0x1A07
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A07
  ,simpleLowerCaseMapping:0x1A07
  ,simpleTitleCaseMapping:0x1A07
 },
 { code:0x1A08
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A08
  ,simpleLowerCaseMapping:0x1A08
  ,simpleTitleCaseMapping:0x1A08
 },
 { code:0x1A09
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A09
  ,simpleLowerCaseMapping:0x1A09
  ,simpleTitleCaseMapping:0x1A09
 },
 { code:0x1A0A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A0A
  ,simpleLowerCaseMapping:0x1A0A
  ,simpleTitleCaseMapping:0x1A0A
 },
 { code:0x1A0B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A0B
  ,simpleLowerCaseMapping:0x1A0B
  ,simpleTitleCaseMapping:0x1A0B
 },
 { code:0x1A0C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A0C
  ,simpleLowerCaseMapping:0x1A0C
  ,simpleTitleCaseMapping:0x1A0C
 },
 { code:0x1A0D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A0D
  ,simpleLowerCaseMapping:0x1A0D
  ,simpleTitleCaseMapping:0x1A0D
 },
 { code:0x1A0E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A0E
  ,simpleLowerCaseMapping:0x1A0E
  ,simpleTitleCaseMapping:0x1A0E
 },
 { code:0x1A0F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A0F
  ,simpleLowerCaseMapping:0x1A0F
  ,simpleTitleCaseMapping:0x1A0F
 },
 { code:0x1A10
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A10
  ,simpleLowerCaseMapping:0x1A10
  ,simpleTitleCaseMapping:0x1A10
 },
 { code:0x1A11
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A11
  ,simpleLowerCaseMapping:0x1A11
  ,simpleTitleCaseMapping:0x1A11
 },
 { code:0x1A12
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A12
  ,simpleLowerCaseMapping:0x1A12
  ,simpleTitleCaseMapping:0x1A12
 },
 { code:0x1A13
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A13
  ,simpleLowerCaseMapping:0x1A13
  ,simpleTitleCaseMapping:0x1A13
 },
 { code:0x1A14
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A14
  ,simpleLowerCaseMapping:0x1A14
  ,simpleTitleCaseMapping:0x1A14
 },
 { code:0x1A15
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A15
  ,simpleLowerCaseMapping:0x1A15
  ,simpleTitleCaseMapping:0x1A15
 },
 { code:0x1A16
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1A16
  ,simpleLowerCaseMapping:0x1A16
  ,simpleTitleCaseMapping:0x1A16
 },
 { code:0x1A17
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1A17
  ,simpleLowerCaseMapping:0x1A17
  ,simpleTitleCaseMapping:0x1A17
 },
 { code:0x1A18
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1A18
  ,simpleLowerCaseMapping:0x1A18
  ,simpleTitleCaseMapping:0x1A18
 },
 { code:0x1A19
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1A19
  ,simpleLowerCaseMapping:0x1A19
  ,simpleTitleCaseMapping:0x1A19
 },
 { code:0x1A1A
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1A1A
  ,simpleLowerCaseMapping:0x1A1A
  ,simpleTitleCaseMapping:0x1A1A
 },
 { code:0x1A1B
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1A1B
  ,simpleLowerCaseMapping:0x1A1B
  ,simpleTitleCaseMapping:0x1A1B
 },
 { code:0x1A1E
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1A1E
  ,simpleLowerCaseMapping:0x1A1E
  ,simpleTitleCaseMapping:0x1A1E
 },
 { code:0x1A1F
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1A1F
  ,simpleLowerCaseMapping:0x1A1F
  ,simpleTitleCaseMapping:0x1A1F
 },
 { code:0x1B00
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B00
  ,simpleLowerCaseMapping:0x1B00
  ,simpleTitleCaseMapping:0x1B00
 },
 { code:0x1B01
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B01
  ,simpleLowerCaseMapping:0x1B01
  ,simpleTitleCaseMapping:0x1B01
 },
 { code:0x1B02
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B02
  ,simpleLowerCaseMapping:0x1B02
  ,simpleTitleCaseMapping:0x1B02
 },
 { code:0x1B03
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B03
  ,simpleLowerCaseMapping:0x1B03
  ,simpleTitleCaseMapping:0x1B03
 },
 { code:0x1B04
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1B04
  ,simpleLowerCaseMapping:0x1B04
  ,simpleTitleCaseMapping:0x1B04
 },
 { code:0x1B05
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B05
  ,simpleLowerCaseMapping:0x1B05
  ,simpleTitleCaseMapping:0x1B05
 },
 { code:0x1B06
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B06
  ,simpleLowerCaseMapping:0x1B06
  ,simpleTitleCaseMapping:0x1B06
 },
 { code:0x1B07
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B07
  ,simpleLowerCaseMapping:0x1B07
  ,simpleTitleCaseMapping:0x1B07
 },
 { code:0x1B08
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B08
  ,simpleLowerCaseMapping:0x1B08
  ,simpleTitleCaseMapping:0x1B08
 },
 { code:0x1B09
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B09
  ,simpleLowerCaseMapping:0x1B09
  ,simpleTitleCaseMapping:0x1B09
 },
 { code:0x1B0A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B0A
  ,simpleLowerCaseMapping:0x1B0A
  ,simpleTitleCaseMapping:0x1B0A
 },
 { code:0x1B0B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B0B
  ,simpleLowerCaseMapping:0x1B0B
  ,simpleTitleCaseMapping:0x1B0B
 },
 { code:0x1B0C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B0C
  ,simpleLowerCaseMapping:0x1B0C
  ,simpleTitleCaseMapping:0x1B0C
 },
 { code:0x1B0D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B0D
  ,simpleLowerCaseMapping:0x1B0D
  ,simpleTitleCaseMapping:0x1B0D
 },
 { code:0x1B0E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B0E
  ,simpleLowerCaseMapping:0x1B0E
  ,simpleTitleCaseMapping:0x1B0E
 },
 { code:0x1B0F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B0F
  ,simpleLowerCaseMapping:0x1B0F
  ,simpleTitleCaseMapping:0x1B0F
 },
 { code:0x1B10
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B10
  ,simpleLowerCaseMapping:0x1B10
  ,simpleTitleCaseMapping:0x1B10
 },
 { code:0x1B11
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B11
  ,simpleLowerCaseMapping:0x1B11
  ,simpleTitleCaseMapping:0x1B11
 },
 { code:0x1B12
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B12
  ,simpleLowerCaseMapping:0x1B12
  ,simpleTitleCaseMapping:0x1B12
 },
 { code:0x1B13
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B13
  ,simpleLowerCaseMapping:0x1B13
  ,simpleTitleCaseMapping:0x1B13
 },
 { code:0x1B14
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B14
  ,simpleLowerCaseMapping:0x1B14
  ,simpleTitleCaseMapping:0x1B14
 },
 { code:0x1B15
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B15
  ,simpleLowerCaseMapping:0x1B15
  ,simpleTitleCaseMapping:0x1B15
 },
 { code:0x1B16
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B16
  ,simpleLowerCaseMapping:0x1B16
  ,simpleTitleCaseMapping:0x1B16
 },
 { code:0x1B17
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B17
  ,simpleLowerCaseMapping:0x1B17
  ,simpleTitleCaseMapping:0x1B17
 },
 { code:0x1B18
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B18
  ,simpleLowerCaseMapping:0x1B18
  ,simpleTitleCaseMapping:0x1B18
 },
 { code:0x1B19
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B19
  ,simpleLowerCaseMapping:0x1B19
  ,simpleTitleCaseMapping:0x1B19
 },
 { code:0x1B1A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B1A
  ,simpleLowerCaseMapping:0x1B1A
  ,simpleTitleCaseMapping:0x1B1A
 },
 { code:0x1B1B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B1B
  ,simpleLowerCaseMapping:0x1B1B
  ,simpleTitleCaseMapping:0x1B1B
 },
 { code:0x1B1C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B1C
  ,simpleLowerCaseMapping:0x1B1C
  ,simpleTitleCaseMapping:0x1B1C
 },
 { code:0x1B1D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B1D
  ,simpleLowerCaseMapping:0x1B1D
  ,simpleTitleCaseMapping:0x1B1D
 },
 { code:0x1B1E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B1E
  ,simpleLowerCaseMapping:0x1B1E
  ,simpleTitleCaseMapping:0x1B1E
 },
 { code:0x1B1F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B1F
  ,simpleLowerCaseMapping:0x1B1F
  ,simpleTitleCaseMapping:0x1B1F
 },
 { code:0x1B20
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B20
  ,simpleLowerCaseMapping:0x1B20
  ,simpleTitleCaseMapping:0x1B20
 },
 { code:0x1B21
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B21
  ,simpleLowerCaseMapping:0x1B21
  ,simpleTitleCaseMapping:0x1B21
 },
 { code:0x1B22
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B22
  ,simpleLowerCaseMapping:0x1B22
  ,simpleTitleCaseMapping:0x1B22
 },
 { code:0x1B23
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B23
  ,simpleLowerCaseMapping:0x1B23
  ,simpleTitleCaseMapping:0x1B23
 },
 { code:0x1B24
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B24
  ,simpleLowerCaseMapping:0x1B24
  ,simpleTitleCaseMapping:0x1B24
 },
 { code:0x1B25
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B25
  ,simpleLowerCaseMapping:0x1B25
  ,simpleTitleCaseMapping:0x1B25
 },
 { code:0x1B26
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B26
  ,simpleLowerCaseMapping:0x1B26
  ,simpleTitleCaseMapping:0x1B26
 },
 { code:0x1B27
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B27
  ,simpleLowerCaseMapping:0x1B27
  ,simpleTitleCaseMapping:0x1B27
 },
 { code:0x1B28
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B28
  ,simpleLowerCaseMapping:0x1B28
  ,simpleTitleCaseMapping:0x1B28
 },
 { code:0x1B29
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B29
  ,simpleLowerCaseMapping:0x1B29
  ,simpleTitleCaseMapping:0x1B29
 },
 { code:0x1B2A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B2A
  ,simpleLowerCaseMapping:0x1B2A
  ,simpleTitleCaseMapping:0x1B2A
 },
 { code:0x1B2B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B2B
  ,simpleLowerCaseMapping:0x1B2B
  ,simpleTitleCaseMapping:0x1B2B
 },
 { code:0x1B2C
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B2C
  ,simpleLowerCaseMapping:0x1B2C
  ,simpleTitleCaseMapping:0x1B2C
 },
 { code:0x1B2D
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B2D
  ,simpleLowerCaseMapping:0x1B2D
  ,simpleTitleCaseMapping:0x1B2D
 },
 { code:0x1B2E
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B2E
  ,simpleLowerCaseMapping:0x1B2E
  ,simpleTitleCaseMapping:0x1B2E
 },
 { code:0x1B2F
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B2F
  ,simpleLowerCaseMapping:0x1B2F
  ,simpleTitleCaseMapping:0x1B2F
 },
 { code:0x1B30
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B30
  ,simpleLowerCaseMapping:0x1B30
  ,simpleTitleCaseMapping:0x1B30
 },
 { code:0x1B31
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B31
  ,simpleLowerCaseMapping:0x1B31
  ,simpleTitleCaseMapping:0x1B31
 },
 { code:0x1B32
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B32
  ,simpleLowerCaseMapping:0x1B32
  ,simpleTitleCaseMapping:0x1B32
 },
 { code:0x1B33
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B33
  ,simpleLowerCaseMapping:0x1B33
  ,simpleTitleCaseMapping:0x1B33
 },
 { code:0x1B34
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B34
  ,simpleLowerCaseMapping:0x1B34
  ,simpleTitleCaseMapping:0x1B34
 },
 { code:0x1B35
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1B35
  ,simpleLowerCaseMapping:0x1B35
  ,simpleTitleCaseMapping:0x1B35
 },
 { code:0x1B36
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B36
  ,simpleLowerCaseMapping:0x1B36
  ,simpleTitleCaseMapping:0x1B36
 },
 { code:0x1B37
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B37
  ,simpleLowerCaseMapping:0x1B37
  ,simpleTitleCaseMapping:0x1B37
 },
 { code:0x1B38
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B38
  ,simpleLowerCaseMapping:0x1B38
  ,simpleTitleCaseMapping:0x1B38
 },
 { code:0x1B39
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B39
  ,simpleLowerCaseMapping:0x1B39
  ,simpleTitleCaseMapping:0x1B39
 },
 { code:0x1B3A
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B3A
  ,simpleLowerCaseMapping:0x1B3A
  ,simpleTitleCaseMapping:0x1B3A
 },
 { code:0x1B3B
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1B3B
  ,simpleLowerCaseMapping:0x1B3B
  ,simpleTitleCaseMapping:0x1B3B
 },
 { code:0x1B3C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B3C
  ,simpleLowerCaseMapping:0x1B3C
  ,simpleTitleCaseMapping:0x1B3C
 },
 { code:0x1B3D
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1B3D
  ,simpleLowerCaseMapping:0x1B3D
  ,simpleTitleCaseMapping:0x1B3D
 },
 { code:0x1B3E
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1B3E
  ,simpleLowerCaseMapping:0x1B3E
  ,simpleTitleCaseMapping:0x1B3E
 },
 { code:0x1B3F
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1B3F
  ,simpleLowerCaseMapping:0x1B3F
  ,simpleTitleCaseMapping:0x1B3F
 },
 { code:0x1B40
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1B40
  ,simpleLowerCaseMapping:0x1B40
  ,simpleTitleCaseMapping:0x1B40
 },
 { code:0x1B41
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1B41
  ,simpleLowerCaseMapping:0x1B41
  ,simpleTitleCaseMapping:0x1B41
 },
 { code:0x1B42
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B42
  ,simpleLowerCaseMapping:0x1B42
  ,simpleTitleCaseMapping:0x1B42
 },
 { code:0x1B43
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1B43
  ,simpleLowerCaseMapping:0x1B43
  ,simpleTitleCaseMapping:0x1B43
 },
 { code:0x1B44
  ,generalCategory:UnicodeData.GeneralCategory.Mc
  ,simpleUpperCaseMapping:0x1B44
  ,simpleLowerCaseMapping:0x1B44
  ,simpleTitleCaseMapping:0x1B44
 },
 { code:0x1B45
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B45
  ,simpleLowerCaseMapping:0x1B45
  ,simpleTitleCaseMapping:0x1B45
 },
 { code:0x1B46
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B46
  ,simpleLowerCaseMapping:0x1B46
  ,simpleTitleCaseMapping:0x1B46
 },
 { code:0x1B47
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B47
  ,simpleLowerCaseMapping:0x1B47
  ,simpleTitleCaseMapping:0x1B47
 },
 { code:0x1B48
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B48
  ,simpleLowerCaseMapping:0x1B48
  ,simpleTitleCaseMapping:0x1B48
 },
 { code:0x1B49
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B49
  ,simpleLowerCaseMapping:0x1B49
  ,simpleTitleCaseMapping:0x1B49
 },
 { code:0x1B4A
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B4A
  ,simpleLowerCaseMapping:0x1B4A
  ,simpleTitleCaseMapping:0x1B4A
 },
 { code:0x1B4B
  ,generalCategory:UnicodeData.GeneralCategory.Lo
  ,simpleUpperCaseMapping:0x1B4B
  ,simpleLowerCaseMapping:0x1B4B
  ,simpleTitleCaseMapping:0x1B4B
 },
 { code:0x1B50
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1B50
  ,simpleLowerCaseMapping:0x1B50
  ,simpleTitleCaseMapping:0x1B50
 },
 { code:0x1B51
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1B51
  ,simpleLowerCaseMapping:0x1B51
  ,simpleTitleCaseMapping:0x1B51
 },
 { code:0x1B52
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1B52
  ,simpleLowerCaseMapping:0x1B52
  ,simpleTitleCaseMapping:0x1B52
 },
 { code:0x1B53
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1B53
  ,simpleLowerCaseMapping:0x1B53
  ,simpleTitleCaseMapping:0x1B53
 },
 { code:0x1B54
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1B54
  ,simpleLowerCaseMapping:0x1B54
  ,simpleTitleCaseMapping:0x1B54
 },
 { code:0x1B55
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1B55
  ,simpleLowerCaseMapping:0x1B55
  ,simpleTitleCaseMapping:0x1B55
 },
 { code:0x1B56
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1B56
  ,simpleLowerCaseMapping:0x1B56
  ,simpleTitleCaseMapping:0x1B56
 },
 { code:0x1B57
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1B57
  ,simpleLowerCaseMapping:0x1B57
  ,simpleTitleCaseMapping:0x1B57
 },
 { code:0x1B58
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1B58
  ,simpleLowerCaseMapping:0x1B58
  ,simpleTitleCaseMapping:0x1B58
 },
 { code:0x1B59
  ,generalCategory:UnicodeData.GeneralCategory.Nd
  ,simpleUpperCaseMapping:0x1B59
  ,simpleLowerCaseMapping:0x1B59
  ,simpleTitleCaseMapping:0x1B59
 },
 { code:0x1B5A
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1B5A
  ,simpleLowerCaseMapping:0x1B5A
  ,simpleTitleCaseMapping:0x1B5A
 },
 { code:0x1B5B
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1B5B
  ,simpleLowerCaseMapping:0x1B5B
  ,simpleTitleCaseMapping:0x1B5B
 },
 { code:0x1B5C
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1B5C
  ,simpleLowerCaseMapping:0x1B5C
  ,simpleTitleCaseMapping:0x1B5C
 },
 { code:0x1B5D
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1B5D
  ,simpleLowerCaseMapping:0x1B5D
  ,simpleTitleCaseMapping:0x1B5D
 },
 { code:0x1B5E
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1B5E
  ,simpleLowerCaseMapping:0x1B5E
  ,simpleTitleCaseMapping:0x1B5E
 },
 { code:0x1B5F
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1B5F
  ,simpleLowerCaseMapping:0x1B5F
  ,simpleTitleCaseMapping:0x1B5F
 },
 { code:0x1B60
  ,generalCategory:UnicodeData.GeneralCategory.Po
  ,simpleUpperCaseMapping:0x1B60
  ,simpleLowerCaseMapping:0x1B60
  ,simpleTitleCaseMapping:0x1B60
 },
 { code:0x1B61
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B61
  ,simpleLowerCaseMapping:0x1B61
  ,simpleTitleCaseMapping:0x1B61
 },
 { code:0x1B62
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B62
  ,simpleLowerCaseMapping:0x1B62
  ,simpleTitleCaseMapping:0x1B62
 },
 { code:0x1B63
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B63
  ,simpleLowerCaseMapping:0x1B63
  ,simpleTitleCaseMapping:0x1B63
 },
 { code:0x1B64
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B64
  ,simpleLowerCaseMapping:0x1B64
  ,simpleTitleCaseMapping:0x1B64
 },
 { code:0x1B65
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B65
  ,simpleLowerCaseMapping:0x1B65
  ,simpleTitleCaseMapping:0x1B65
 },
 { code:0x1B66
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B66
  ,simpleLowerCaseMapping:0x1B66
  ,simpleTitleCaseMapping:0x1B66
 },
 { code:0x1B67
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B67
  ,simpleLowerCaseMapping:0x1B67
  ,simpleTitleCaseMapping:0x1B67
 },
 { code:0x1B68
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B68
  ,simpleLowerCaseMapping:0x1B68
  ,simpleTitleCaseMapping:0x1B68
 },
 { code:0x1B69
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B69
  ,simpleLowerCaseMapping:0x1B69
  ,simpleTitleCaseMapping:0x1B69
 },
 { code:0x1B6A
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B6A
  ,simpleLowerCaseMapping:0x1B6A
  ,simpleTitleCaseMapping:0x1B6A
 },
 { code:0x1B6B
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B6B
  ,simpleLowerCaseMapping:0x1B6B
  ,simpleTitleCaseMapping:0x1B6B
 },
 { code:0x1B6C
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B6C
  ,simpleLowerCaseMapping:0x1B6C
  ,simpleTitleCaseMapping:0x1B6C
 },
 { code:0x1B6D
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B6D
  ,simpleLowerCaseMapping:0x1B6D
  ,simpleTitleCaseMapping:0x1B6D
 },
 { code:0x1B6E
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B6E
  ,simpleLowerCaseMapping:0x1B6E
  ,simpleTitleCaseMapping:0x1B6E
 },
 { code:0x1B6F
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B6F
  ,simpleLowerCaseMapping:0x1B6F
  ,simpleTitleCaseMapping:0x1B6F
 },
 { code:0x1B70
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B70
  ,simpleLowerCaseMapping:0x1B70
  ,simpleTitleCaseMapping:0x1B70
 },
 { code:0x1B71
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B71
  ,simpleLowerCaseMapping:0x1B71
  ,simpleTitleCaseMapping:0x1B71
 },
 { code:0x1B72
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B72
  ,simpleLowerCaseMapping:0x1B72
  ,simpleTitleCaseMapping:0x1B72
 },
 { code:0x1B73
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1B73
  ,simpleLowerCaseMapping:0x1B73
  ,simpleTitleCaseMapping:0x1B73
 },
 { code:0x1B74
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B74
  ,simpleLowerCaseMapping:0x1B74
  ,simpleTitleCaseMapping:0x1B74
 },
 { code:0x1B75
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B75
  ,simpleLowerCaseMapping:0x1B75
  ,simpleTitleCaseMapping:0x1B75
 },
 { code:0x1B76
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B76
  ,simpleLowerCaseMapping:0x1B76
  ,simpleTitleCaseMapping:0x1B76
 },
 { code:0x1B77
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B77
  ,simpleLowerCaseMapping:0x1B77
  ,simpleTitleCaseMapping:0x1B77
 },
 { code:0x1B78
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B78
  ,simpleLowerCaseMapping:0x1B78
  ,simpleTitleCaseMapping:0x1B78
 },
 { code:0x1B79
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B79
  ,simpleLowerCaseMapping:0x1B79
  ,simpleTitleCaseMapping:0x1B79
 },
 { code:0x1B7A
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B7A
  ,simpleLowerCaseMapping:0x1B7A
  ,simpleTitleCaseMapping:0x1B7A
 },
 { code:0x1B7B
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B7B
  ,simpleLowerCaseMapping:0x1B7B
  ,simpleTitleCaseMapping:0x1B7B
 },
 { code:0x1B7C
  ,generalCategory:UnicodeData.GeneralCategory.So
  ,simpleUpperCaseMapping:0x1B7C
  ,simpleLowerCaseMapping:0x1B7C
  ,simpleTitleCaseMapping:0x1B7C
 },
 { code:0x1D00
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D00
  ,simpleLowerCaseMapping:0x1D00
  ,simpleTitleCaseMapping:0x1D00
 },
 { code:0x1D01
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D01
  ,simpleLowerCaseMapping:0x1D01
  ,simpleTitleCaseMapping:0x1D01
 },
 { code:0x1D02
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D02
  ,simpleLowerCaseMapping:0x1D02
  ,simpleTitleCaseMapping:0x1D02
 },
 { code:0x1D03
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D03
  ,simpleLowerCaseMapping:0x1D03
  ,simpleTitleCaseMapping:0x1D03
 },
 { code:0x1D04
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D04
  ,simpleLowerCaseMapping:0x1D04
  ,simpleTitleCaseMapping:0x1D04
 },
 { code:0x1D05
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D05
  ,simpleLowerCaseMapping:0x1D05
  ,simpleTitleCaseMapping:0x1D05
 },
 { code:0x1D06
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D06
  ,simpleLowerCaseMapping:0x1D06
  ,simpleTitleCaseMapping:0x1D06
 },
 { code:0x1D07
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D07
  ,simpleLowerCaseMapping:0x1D07
  ,simpleTitleCaseMapping:0x1D07
 },
 { code:0x1D08
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D08
  ,simpleLowerCaseMapping:0x1D08
  ,simpleTitleCaseMapping:0x1D08
 },
 { code:0x1D09
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D09
  ,simpleLowerCaseMapping:0x1D09
  ,simpleTitleCaseMapping:0x1D09
 },
 { code:0x1D0A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D0A
  ,simpleLowerCaseMapping:0x1D0A
  ,simpleTitleCaseMapping:0x1D0A
 },
 { code:0x1D0B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D0B
  ,simpleLowerCaseMapping:0x1D0B
  ,simpleTitleCaseMapping:0x1D0B
 },
 { code:0x1D0C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D0C
  ,simpleLowerCaseMapping:0x1D0C
  ,simpleTitleCaseMapping:0x1D0C
 },
 { code:0x1D0D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D0D
  ,simpleLowerCaseMapping:0x1D0D
  ,simpleTitleCaseMapping:0x1D0D
 },
 { code:0x1D0E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D0E
  ,simpleLowerCaseMapping:0x1D0E
  ,simpleTitleCaseMapping:0x1D0E
 },
 { code:0x1D0F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D0F
  ,simpleLowerCaseMapping:0x1D0F
  ,simpleTitleCaseMapping:0x1D0F
 },
 { code:0x1D10
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D10
  ,simpleLowerCaseMapping:0x1D10
  ,simpleTitleCaseMapping:0x1D10
 },
 { code:0x1D11
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D11
  ,simpleLowerCaseMapping:0x1D11
  ,simpleTitleCaseMapping:0x1D11
 },
 { code:0x1D12
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D12
  ,simpleLowerCaseMapping:0x1D12
  ,simpleTitleCaseMapping:0x1D12
 },
 { code:0x1D13
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D13
  ,simpleLowerCaseMapping:0x1D13
  ,simpleTitleCaseMapping:0x1D13
 },
 { code:0x1D14
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D14
  ,simpleLowerCaseMapping:0x1D14
  ,simpleTitleCaseMapping:0x1D14
 },
 { code:0x1D15
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D15
  ,simpleLowerCaseMapping:0x1D15
  ,simpleTitleCaseMapping:0x1D15
 },
 { code:0x1D16
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D16
  ,simpleLowerCaseMapping:0x1D16
  ,simpleTitleCaseMapping:0x1D16
 },
 { code:0x1D17
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D17
  ,simpleLowerCaseMapping:0x1D17
  ,simpleTitleCaseMapping:0x1D17
 },
 { code:0x1D18
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D18
  ,simpleLowerCaseMapping:0x1D18
  ,simpleTitleCaseMapping:0x1D18
 },
 { code:0x1D19
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D19
  ,simpleLowerCaseMapping:0x1D19
  ,simpleTitleCaseMapping:0x1D19
 },
 { code:0x1D1A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D1A
  ,simpleLowerCaseMapping:0x1D1A
  ,simpleTitleCaseMapping:0x1D1A
 },
 { code:0x1D1B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D1B
  ,simpleLowerCaseMapping:0x1D1B
  ,simpleTitleCaseMapping:0x1D1B
 },
 { code:0x1D1C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D1C
  ,simpleLowerCaseMapping:0x1D1C
  ,simpleTitleCaseMapping:0x1D1C
 },
 { code:0x1D1D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D1D
  ,simpleLowerCaseMapping:0x1D1D
  ,simpleTitleCaseMapping:0x1D1D
 },
 { code:0x1D1E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D1E
  ,simpleLowerCaseMapping:0x1D1E
  ,simpleTitleCaseMapping:0x1D1E
 },
 { code:0x1D1F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D1F
  ,simpleLowerCaseMapping:0x1D1F
  ,simpleTitleCaseMapping:0x1D1F
 },
 { code:0x1D20
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D20
  ,simpleLowerCaseMapping:0x1D20
  ,simpleTitleCaseMapping:0x1D20
 },
 { code:0x1D21
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D21
  ,simpleLowerCaseMapping:0x1D21
  ,simpleTitleCaseMapping:0x1D21
 },
 { code:0x1D22
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D22
  ,simpleLowerCaseMapping:0x1D22
  ,simpleTitleCaseMapping:0x1D22
 },
 { code:0x1D23
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D23
  ,simpleLowerCaseMapping:0x1D23
  ,simpleTitleCaseMapping:0x1D23
 },
 { code:0x1D24
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D24
  ,simpleLowerCaseMapping:0x1D24
  ,simpleTitleCaseMapping:0x1D24
 },
 { code:0x1D25
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D25
  ,simpleLowerCaseMapping:0x1D25
  ,simpleTitleCaseMapping:0x1D25
 },
 { code:0x1D26
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D26
  ,simpleLowerCaseMapping:0x1D26
  ,simpleTitleCaseMapping:0x1D26
 },
 { code:0x1D27
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D27
  ,simpleLowerCaseMapping:0x1D27
  ,simpleTitleCaseMapping:0x1D27
 },
 { code:0x1D28
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D28
  ,simpleLowerCaseMapping:0x1D28
  ,simpleTitleCaseMapping:0x1D28
 },
 { code:0x1D29
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D29
  ,simpleLowerCaseMapping:0x1D29
  ,simpleTitleCaseMapping:0x1D29
 },
 { code:0x1D2A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D2A
  ,simpleLowerCaseMapping:0x1D2A
  ,simpleTitleCaseMapping:0x1D2A
 },
 { code:0x1D2B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D2B
  ,simpleLowerCaseMapping:0x1D2B
  ,simpleTitleCaseMapping:0x1D2B
 },
 { code:0x1D2C
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D2C
  ,simpleLowerCaseMapping:0x1D2C
  ,simpleTitleCaseMapping:0x1D2C
 },
 { code:0x1D2D
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D2D
  ,simpleLowerCaseMapping:0x1D2D
  ,simpleTitleCaseMapping:0x1D2D
 },
 { code:0x1D2E
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D2E
  ,simpleLowerCaseMapping:0x1D2E
  ,simpleTitleCaseMapping:0x1D2E
 },
 { code:0x1D2F
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D2F
  ,simpleLowerCaseMapping:0x1D2F
  ,simpleTitleCaseMapping:0x1D2F
 },
 { code:0x1D30
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D30
  ,simpleLowerCaseMapping:0x1D30
  ,simpleTitleCaseMapping:0x1D30
 },
 { code:0x1D31
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D31
  ,simpleLowerCaseMapping:0x1D31
  ,simpleTitleCaseMapping:0x1D31
 },
 { code:0x1D32
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D32
  ,simpleLowerCaseMapping:0x1D32
  ,simpleTitleCaseMapping:0x1D32
 },
 { code:0x1D33
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D33
  ,simpleLowerCaseMapping:0x1D33
  ,simpleTitleCaseMapping:0x1D33
 },
 { code:0x1D34
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D34
  ,simpleLowerCaseMapping:0x1D34
  ,simpleTitleCaseMapping:0x1D34
 },
 { code:0x1D35
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D35
  ,simpleLowerCaseMapping:0x1D35
  ,simpleTitleCaseMapping:0x1D35
 },
 { code:0x1D36
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D36
  ,simpleLowerCaseMapping:0x1D36
  ,simpleTitleCaseMapping:0x1D36
 },
 { code:0x1D37
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D37
  ,simpleLowerCaseMapping:0x1D37
  ,simpleTitleCaseMapping:0x1D37
 },
 { code:0x1D38
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D38
  ,simpleLowerCaseMapping:0x1D38
  ,simpleTitleCaseMapping:0x1D38
 },
 { code:0x1D39
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D39
  ,simpleLowerCaseMapping:0x1D39
  ,simpleTitleCaseMapping:0x1D39
 },
 { code:0x1D3A
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D3A
  ,simpleLowerCaseMapping:0x1D3A
  ,simpleTitleCaseMapping:0x1D3A
 },
 { code:0x1D3B
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D3B
  ,simpleLowerCaseMapping:0x1D3B
  ,simpleTitleCaseMapping:0x1D3B
 },
 { code:0x1D3C
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D3C
  ,simpleLowerCaseMapping:0x1D3C
  ,simpleTitleCaseMapping:0x1D3C
 },
 { code:0x1D3D
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D3D
  ,simpleLowerCaseMapping:0x1D3D
  ,simpleTitleCaseMapping:0x1D3D
 },
 { code:0x1D3E
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D3E
  ,simpleLowerCaseMapping:0x1D3E
  ,simpleTitleCaseMapping:0x1D3E
 },
 { code:0x1D3F
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D3F
  ,simpleLowerCaseMapping:0x1D3F
  ,simpleTitleCaseMapping:0x1D3F
 },
 { code:0x1D40
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D40
  ,simpleLowerCaseMapping:0x1D40
  ,simpleTitleCaseMapping:0x1D40
 },
 { code:0x1D41
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D41
  ,simpleLowerCaseMapping:0x1D41
  ,simpleTitleCaseMapping:0x1D41
 },
 { code:0x1D42
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D42
  ,simpleLowerCaseMapping:0x1D42
  ,simpleTitleCaseMapping:0x1D42
 },
 { code:0x1D43
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D43
  ,simpleLowerCaseMapping:0x1D43
  ,simpleTitleCaseMapping:0x1D43
 },
 { code:0x1D44
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D44
  ,simpleLowerCaseMapping:0x1D44
  ,simpleTitleCaseMapping:0x1D44
 },
 { code:0x1D45
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D45
  ,simpleLowerCaseMapping:0x1D45
  ,simpleTitleCaseMapping:0x1D45
 },
 { code:0x1D46
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D46
  ,simpleLowerCaseMapping:0x1D46
  ,simpleTitleCaseMapping:0x1D46
 },
 { code:0x1D47
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D47
  ,simpleLowerCaseMapping:0x1D47
  ,simpleTitleCaseMapping:0x1D47
 },
 { code:0x1D48
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D48
  ,simpleLowerCaseMapping:0x1D48
  ,simpleTitleCaseMapping:0x1D48
 },
 { code:0x1D49
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D49
  ,simpleLowerCaseMapping:0x1D49
  ,simpleTitleCaseMapping:0x1D49
 },
 { code:0x1D4A
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D4A
  ,simpleLowerCaseMapping:0x1D4A
  ,simpleTitleCaseMapping:0x1D4A
 },
 { code:0x1D4B
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D4B
  ,simpleLowerCaseMapping:0x1D4B
  ,simpleTitleCaseMapping:0x1D4B
 },
 { code:0x1D4C
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D4C
  ,simpleLowerCaseMapping:0x1D4C
  ,simpleTitleCaseMapping:0x1D4C
 },
 { code:0x1D4D
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D4D
  ,simpleLowerCaseMapping:0x1D4D
  ,simpleTitleCaseMapping:0x1D4D
 },
 { code:0x1D4E
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D4E
  ,simpleLowerCaseMapping:0x1D4E
  ,simpleTitleCaseMapping:0x1D4E
 },
 { code:0x1D4F
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D4F
  ,simpleLowerCaseMapping:0x1D4F
  ,simpleTitleCaseMapping:0x1D4F
 },
 { code:0x1D50
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D50
  ,simpleLowerCaseMapping:0x1D50
  ,simpleTitleCaseMapping:0x1D50
 },
 { code:0x1D51
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D51
  ,simpleLowerCaseMapping:0x1D51
  ,simpleTitleCaseMapping:0x1D51
 },
 { code:0x1D52
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D52
  ,simpleLowerCaseMapping:0x1D52
  ,simpleTitleCaseMapping:0x1D52
 },
 { code:0x1D53
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D53
  ,simpleLowerCaseMapping:0x1D53
  ,simpleTitleCaseMapping:0x1D53
 },
 { code:0x1D54
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D54
  ,simpleLowerCaseMapping:0x1D54
  ,simpleTitleCaseMapping:0x1D54
 },
 { code:0x1D55
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D55
  ,simpleLowerCaseMapping:0x1D55
  ,simpleTitleCaseMapping:0x1D55
 },
 { code:0x1D56
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D56
  ,simpleLowerCaseMapping:0x1D56
  ,simpleTitleCaseMapping:0x1D56
 },
 { code:0x1D57
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D57
  ,simpleLowerCaseMapping:0x1D57
  ,simpleTitleCaseMapping:0x1D57
 },
 { code:0x1D58
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D58
  ,simpleLowerCaseMapping:0x1D58
  ,simpleTitleCaseMapping:0x1D58
 },
 { code:0x1D59
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D59
  ,simpleLowerCaseMapping:0x1D59
  ,simpleTitleCaseMapping:0x1D59
 },
 { code:0x1D5A
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D5A
  ,simpleLowerCaseMapping:0x1D5A
  ,simpleTitleCaseMapping:0x1D5A
 },
 { code:0x1D5B
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D5B
  ,simpleLowerCaseMapping:0x1D5B
  ,simpleTitleCaseMapping:0x1D5B
 },
 { code:0x1D5C
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D5C
  ,simpleLowerCaseMapping:0x1D5C
  ,simpleTitleCaseMapping:0x1D5C
 },
 { code:0x1D5D
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D5D
  ,simpleLowerCaseMapping:0x1D5D
  ,simpleTitleCaseMapping:0x1D5D
 },
 { code:0x1D5E
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D5E
  ,simpleLowerCaseMapping:0x1D5E
  ,simpleTitleCaseMapping:0x1D5E
 },
 { code:0x1D5F
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D5F
  ,simpleLowerCaseMapping:0x1D5F
  ,simpleTitleCaseMapping:0x1D5F
 },
 { code:0x1D60
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D60
  ,simpleLowerCaseMapping:0x1D60
  ,simpleTitleCaseMapping:0x1D60
 },
 { code:0x1D61
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D61
  ,simpleLowerCaseMapping:0x1D61
  ,simpleTitleCaseMapping:0x1D61
 },
 { code:0x1D62
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D62
  ,simpleLowerCaseMapping:0x1D62
  ,simpleTitleCaseMapping:0x1D62
 },
 { code:0x1D63
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D63
  ,simpleLowerCaseMapping:0x1D63
  ,simpleTitleCaseMapping:0x1D63
 },
 { code:0x1D64
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D64
  ,simpleLowerCaseMapping:0x1D64
  ,simpleTitleCaseMapping:0x1D64
 },
 { code:0x1D65
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D65
  ,simpleLowerCaseMapping:0x1D65
  ,simpleTitleCaseMapping:0x1D65
 },
 { code:0x1D66
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D66
  ,simpleLowerCaseMapping:0x1D66
  ,simpleTitleCaseMapping:0x1D66
 },
 { code:0x1D67
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D67
  ,simpleLowerCaseMapping:0x1D67
  ,simpleTitleCaseMapping:0x1D67
 },
 { code:0x1D68
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D68
  ,simpleLowerCaseMapping:0x1D68
  ,simpleTitleCaseMapping:0x1D68
 },
 { code:0x1D69
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D69
  ,simpleLowerCaseMapping:0x1D69
  ,simpleTitleCaseMapping:0x1D69
 },
 { code:0x1D6A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D6A
  ,simpleLowerCaseMapping:0x1D6A
  ,simpleTitleCaseMapping:0x1D6A
 },
 { code:0x1D6B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D6B
  ,simpleLowerCaseMapping:0x1D6B
  ,simpleTitleCaseMapping:0x1D6B
 },
 { code:0x1D6C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D6C
  ,simpleLowerCaseMapping:0x1D6C
  ,simpleTitleCaseMapping:0x1D6C
 },
 { code:0x1D6D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D6D
  ,simpleLowerCaseMapping:0x1D6D
  ,simpleTitleCaseMapping:0x1D6D
 },
 { code:0x1D6E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D6E
  ,simpleLowerCaseMapping:0x1D6E
  ,simpleTitleCaseMapping:0x1D6E
 },
 { code:0x1D6F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D6F
  ,simpleLowerCaseMapping:0x1D6F
  ,simpleTitleCaseMapping:0x1D6F
 },
 { code:0x1D70
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D70
  ,simpleLowerCaseMapping:0x1D70
  ,simpleTitleCaseMapping:0x1D70
 },
 { code:0x1D71
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D71
  ,simpleLowerCaseMapping:0x1D71
  ,simpleTitleCaseMapping:0x1D71
 },
 { code:0x1D72
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D72
  ,simpleLowerCaseMapping:0x1D72
  ,simpleTitleCaseMapping:0x1D72
 },
 { code:0x1D73
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D73
  ,simpleLowerCaseMapping:0x1D73
  ,simpleTitleCaseMapping:0x1D73
 },
 { code:0x1D74
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D74
  ,simpleLowerCaseMapping:0x1D74
  ,simpleTitleCaseMapping:0x1D74
 },
 { code:0x1D75
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D75
  ,simpleLowerCaseMapping:0x1D75
  ,simpleTitleCaseMapping:0x1D75
 },
 { code:0x1D76
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D76
  ,simpleLowerCaseMapping:0x1D76
  ,simpleTitleCaseMapping:0x1D76
 },
 { code:0x1D77
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D77
  ,simpleLowerCaseMapping:0x1D77
  ,simpleTitleCaseMapping:0x1D77
 },
 { code:0x1D78
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D78
  ,simpleLowerCaseMapping:0x1D78
  ,simpleTitleCaseMapping:0x1D78
 },
 { code:0x1D79
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D79
  ,simpleLowerCaseMapping:0x1D79
  ,simpleTitleCaseMapping:0x1D79
 },
 { code:0x1D7A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D7A
  ,simpleLowerCaseMapping:0x1D7A
  ,simpleTitleCaseMapping:0x1D7A
 },
 { code:0x1D7B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D7B
  ,simpleLowerCaseMapping:0x1D7B
  ,simpleTitleCaseMapping:0x1D7B
 },
 { code:0x1D7C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D7C
  ,simpleLowerCaseMapping:0x1D7C
  ,simpleTitleCaseMapping:0x1D7C
 },
 { code:0x1D7D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x2C63
  ,simpleLowerCaseMapping:0x1D7D
  ,simpleTitleCaseMapping:0x2C63
 },
 { code:0x1D7E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D7E
  ,simpleLowerCaseMapping:0x1D7E
  ,simpleTitleCaseMapping:0x1D7E
 },
 { code:0x1D7F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D7F
  ,simpleLowerCaseMapping:0x1D7F
  ,simpleTitleCaseMapping:0x1D7F
 },
 { code:0x1D80
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D80
  ,simpleLowerCaseMapping:0x1D80
  ,simpleTitleCaseMapping:0x1D80
 },
 { code:0x1D81
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D81
  ,simpleLowerCaseMapping:0x1D81
  ,simpleTitleCaseMapping:0x1D81
 },
 { code:0x1D82
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D82
  ,simpleLowerCaseMapping:0x1D82
  ,simpleTitleCaseMapping:0x1D82
 },
 { code:0x1D83
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D83
  ,simpleLowerCaseMapping:0x1D83
  ,simpleTitleCaseMapping:0x1D83
 },
 { code:0x1D84
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D84
  ,simpleLowerCaseMapping:0x1D84
  ,simpleTitleCaseMapping:0x1D84
 },
 { code:0x1D85
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D85
  ,simpleLowerCaseMapping:0x1D85
  ,simpleTitleCaseMapping:0x1D85
 },
 { code:0x1D86
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D86
  ,simpleLowerCaseMapping:0x1D86
  ,simpleTitleCaseMapping:0x1D86
 },
 { code:0x1D87
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D87
  ,simpleLowerCaseMapping:0x1D87
  ,simpleTitleCaseMapping:0x1D87
 },
 { code:0x1D88
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D88
  ,simpleLowerCaseMapping:0x1D88
  ,simpleTitleCaseMapping:0x1D88
 },
 { code:0x1D89
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D89
  ,simpleLowerCaseMapping:0x1D89
  ,simpleTitleCaseMapping:0x1D89
 },
 { code:0x1D8A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D8A
  ,simpleLowerCaseMapping:0x1D8A
  ,simpleTitleCaseMapping:0x1D8A
 },
 { code:0x1D8B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D8B
  ,simpleLowerCaseMapping:0x1D8B
  ,simpleTitleCaseMapping:0x1D8B
 },
 { code:0x1D8C
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D8C
  ,simpleLowerCaseMapping:0x1D8C
  ,simpleTitleCaseMapping:0x1D8C
 },
 { code:0x1D8D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D8D
  ,simpleLowerCaseMapping:0x1D8D
  ,simpleTitleCaseMapping:0x1D8D
 },
 { code:0x1D8E
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D8E
  ,simpleLowerCaseMapping:0x1D8E
  ,simpleTitleCaseMapping:0x1D8E
 },
 { code:0x1D8F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D8F
  ,simpleLowerCaseMapping:0x1D8F
  ,simpleTitleCaseMapping:0x1D8F
 },
 { code:0x1D90
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D90
  ,simpleLowerCaseMapping:0x1D90
  ,simpleTitleCaseMapping:0x1D90
 },
 { code:0x1D91
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D91
  ,simpleLowerCaseMapping:0x1D91
  ,simpleTitleCaseMapping:0x1D91
 },
 { code:0x1D92
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D92
  ,simpleLowerCaseMapping:0x1D92
  ,simpleTitleCaseMapping:0x1D92
 },
 { code:0x1D93
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D93
  ,simpleLowerCaseMapping:0x1D93
  ,simpleTitleCaseMapping:0x1D93
 },
 { code:0x1D94
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D94
  ,simpleLowerCaseMapping:0x1D94
  ,simpleTitleCaseMapping:0x1D94
 },
 { code:0x1D95
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D95
  ,simpleLowerCaseMapping:0x1D95
  ,simpleTitleCaseMapping:0x1D95
 },
 { code:0x1D96
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D96
  ,simpleLowerCaseMapping:0x1D96
  ,simpleTitleCaseMapping:0x1D96
 },
 { code:0x1D97
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D97
  ,simpleLowerCaseMapping:0x1D97
  ,simpleTitleCaseMapping:0x1D97
 },
 { code:0x1D98
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D98
  ,simpleLowerCaseMapping:0x1D98
  ,simpleTitleCaseMapping:0x1D98
 },
 { code:0x1D99
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D99
  ,simpleLowerCaseMapping:0x1D99
  ,simpleTitleCaseMapping:0x1D99
 },
 { code:0x1D9A
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1D9A
  ,simpleLowerCaseMapping:0x1D9A
  ,simpleTitleCaseMapping:0x1D9A
 },
 { code:0x1D9B
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D9B
  ,simpleLowerCaseMapping:0x1D9B
  ,simpleTitleCaseMapping:0x1D9B
 },
 { code:0x1D9C
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D9C
  ,simpleLowerCaseMapping:0x1D9C
  ,simpleTitleCaseMapping:0x1D9C
 },
 { code:0x1D9D
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D9D
  ,simpleLowerCaseMapping:0x1D9D
  ,simpleTitleCaseMapping:0x1D9D
 },
 { code:0x1D9E
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D9E
  ,simpleLowerCaseMapping:0x1D9E
  ,simpleTitleCaseMapping:0x1D9E
 },
 { code:0x1D9F
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1D9F
  ,simpleLowerCaseMapping:0x1D9F
  ,simpleTitleCaseMapping:0x1D9F
 },
 { code:0x1DA0
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DA0
  ,simpleLowerCaseMapping:0x1DA0
  ,simpleTitleCaseMapping:0x1DA0
 },
 { code:0x1DA1
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DA1
  ,simpleLowerCaseMapping:0x1DA1
  ,simpleTitleCaseMapping:0x1DA1
 },
 { code:0x1DA2
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DA2
  ,simpleLowerCaseMapping:0x1DA2
  ,simpleTitleCaseMapping:0x1DA2
 },
 { code:0x1DA3
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DA3
  ,simpleLowerCaseMapping:0x1DA3
  ,simpleTitleCaseMapping:0x1DA3
 },
 { code:0x1DA4
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DA4
  ,simpleLowerCaseMapping:0x1DA4
  ,simpleTitleCaseMapping:0x1DA4
 },
 { code:0x1DA5
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DA5
  ,simpleLowerCaseMapping:0x1DA5
  ,simpleTitleCaseMapping:0x1DA5
 },
 { code:0x1DA6
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DA6
  ,simpleLowerCaseMapping:0x1DA6
  ,simpleTitleCaseMapping:0x1DA6
 },
 { code:0x1DA7
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DA7
  ,simpleLowerCaseMapping:0x1DA7
  ,simpleTitleCaseMapping:0x1DA7
 },
 { code:0x1DA8
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DA8
  ,simpleLowerCaseMapping:0x1DA8
  ,simpleTitleCaseMapping:0x1DA8
 },
 { code:0x1DA9
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DA9
  ,simpleLowerCaseMapping:0x1DA9
  ,simpleTitleCaseMapping:0x1DA9
 },
 { code:0x1DAA
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DAA
  ,simpleLowerCaseMapping:0x1DAA
  ,simpleTitleCaseMapping:0x1DAA
 },
 { code:0x1DAB
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DAB
  ,simpleLowerCaseMapping:0x1DAB
  ,simpleTitleCaseMapping:0x1DAB
 },
 { code:0x1DAC
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DAC
  ,simpleLowerCaseMapping:0x1DAC
  ,simpleTitleCaseMapping:0x1DAC
 },
 { code:0x1DAD
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DAD
  ,simpleLowerCaseMapping:0x1DAD
  ,simpleTitleCaseMapping:0x1DAD
 },
 { code:0x1DAE
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DAE
  ,simpleLowerCaseMapping:0x1DAE
  ,simpleTitleCaseMapping:0x1DAE
 },
 { code:0x1DAF
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DAF
  ,simpleLowerCaseMapping:0x1DAF
  ,simpleTitleCaseMapping:0x1DAF
 },
 { code:0x1DB0
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DB0
  ,simpleLowerCaseMapping:0x1DB0
  ,simpleTitleCaseMapping:0x1DB0
 },
 { code:0x1DB1
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DB1
  ,simpleLowerCaseMapping:0x1DB1
  ,simpleTitleCaseMapping:0x1DB1
 },
 { code:0x1DB2
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DB2
  ,simpleLowerCaseMapping:0x1DB2
  ,simpleTitleCaseMapping:0x1DB2
 },
 { code:0x1DB3
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DB3
  ,simpleLowerCaseMapping:0x1DB3
  ,simpleTitleCaseMapping:0x1DB3
 },
 { code:0x1DB4
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DB4
  ,simpleLowerCaseMapping:0x1DB4
  ,simpleTitleCaseMapping:0x1DB4
 },
 { code:0x1DB5
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DB5
  ,simpleLowerCaseMapping:0x1DB5
  ,simpleTitleCaseMapping:0x1DB5
 },
 { code:0x1DB6
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DB6
  ,simpleLowerCaseMapping:0x1DB6
  ,simpleTitleCaseMapping:0x1DB6
 },
 { code:0x1DB7
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DB7
  ,simpleLowerCaseMapping:0x1DB7
  ,simpleTitleCaseMapping:0x1DB7
 },
 { code:0x1DB8
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DB8
  ,simpleLowerCaseMapping:0x1DB8
  ,simpleTitleCaseMapping:0x1DB8
 },
 { code:0x1DB9
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DB9
  ,simpleLowerCaseMapping:0x1DB9
  ,simpleTitleCaseMapping:0x1DB9
 },
 { code:0x1DBA
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DBA
  ,simpleLowerCaseMapping:0x1DBA
  ,simpleTitleCaseMapping:0x1DBA
 },
 { code:0x1DBB
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DBB
  ,simpleLowerCaseMapping:0x1DBB
  ,simpleTitleCaseMapping:0x1DBB
 },
 { code:0x1DBC
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DBC
  ,simpleLowerCaseMapping:0x1DBC
  ,simpleTitleCaseMapping:0x1DBC
 },
 { code:0x1DBD
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DBD
  ,simpleLowerCaseMapping:0x1DBD
  ,simpleTitleCaseMapping:0x1DBD
 },
 { code:0x1DBE
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DBE
  ,simpleLowerCaseMapping:0x1DBE
  ,simpleTitleCaseMapping:0x1DBE
 },
 { code:0x1DBF
  ,generalCategory:UnicodeData.GeneralCategory.Lm
  ,simpleUpperCaseMapping:0x1DBF
  ,simpleLowerCaseMapping:0x1DBF
  ,simpleTitleCaseMapping:0x1DBF
 },
 { code:0x1DC0
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DC0
  ,simpleLowerCaseMapping:0x1DC0
  ,simpleTitleCaseMapping:0x1DC0
 },
 { code:0x1DC1
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DC1
  ,simpleLowerCaseMapping:0x1DC1
  ,simpleTitleCaseMapping:0x1DC1
 },
 { code:0x1DC2
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DC2
  ,simpleLowerCaseMapping:0x1DC2
  ,simpleTitleCaseMapping:0x1DC2
 },
 { code:0x1DC3
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DC3
  ,simpleLowerCaseMapping:0x1DC3
  ,simpleTitleCaseMapping:0x1DC3
 },
 { code:0x1DC4
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DC4
  ,simpleLowerCaseMapping:0x1DC4
  ,simpleTitleCaseMapping:0x1DC4
 },
 { code:0x1DC5
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DC5
  ,simpleLowerCaseMapping:0x1DC5
  ,simpleTitleCaseMapping:0x1DC5
 },
 { code:0x1DC6
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DC6
  ,simpleLowerCaseMapping:0x1DC6
  ,simpleTitleCaseMapping:0x1DC6
 },
 { code:0x1DC7
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DC7
  ,simpleLowerCaseMapping:0x1DC7
  ,simpleTitleCaseMapping:0x1DC7
 },
 { code:0x1DC8
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DC8
  ,simpleLowerCaseMapping:0x1DC8
  ,simpleTitleCaseMapping:0x1DC8
 },
 { code:0x1DC9
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DC9
  ,simpleLowerCaseMapping:0x1DC9
  ,simpleTitleCaseMapping:0x1DC9
 },
 { code:0x1DCA
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DCA
  ,simpleLowerCaseMapping:0x1DCA
  ,simpleTitleCaseMapping:0x1DCA
 },
 { code:0x1DFE
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DFE
  ,simpleLowerCaseMapping:0x1DFE
  ,simpleTitleCaseMapping:0x1DFE
 },
 { code:0x1DFF
  ,generalCategory:UnicodeData.GeneralCategory.Mn
  ,simpleUpperCaseMapping:0x1DFF
  ,simpleLowerCaseMapping:0x1DFF
  ,simpleTitleCaseMapping:0x1DFF
 },
 { code:0x1E00
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E00
  ,simpleLowerCaseMapping:0x1E01
  ,simpleTitleCaseMapping:0x1E00
 },
 { code:0x1E01
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E00
  ,simpleLowerCaseMapping:0x1E01
  ,simpleTitleCaseMapping:0x1E00
 },
 { code:0x1E02
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E02
  ,simpleLowerCaseMapping:0x1E03
  ,simpleTitleCaseMapping:0x1E02
 },
 { code:0x1E03
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E02
  ,simpleLowerCaseMapping:0x1E03
  ,simpleTitleCaseMapping:0x1E02
 },
 { code:0x1E04
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E04
  ,simpleLowerCaseMapping:0x1E05
  ,simpleTitleCaseMapping:0x1E04
 },
 { code:0x1E05
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E04
  ,simpleLowerCaseMapping:0x1E05
  ,simpleTitleCaseMapping:0x1E04
 },
 { code:0x1E06
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E06
  ,simpleLowerCaseMapping:0x1E07
  ,simpleTitleCaseMapping:0x1E06
 },
 { code:0x1E07
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E06
  ,simpleLowerCaseMapping:0x1E07
  ,simpleTitleCaseMapping:0x1E06
 },
 { code:0x1E08
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E08
  ,simpleLowerCaseMapping:0x1E09
  ,simpleTitleCaseMapping:0x1E08
 },
 { code:0x1E09
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E08
  ,simpleLowerCaseMapping:0x1E09
  ,simpleTitleCaseMapping:0x1E08
 },
 { code:0x1E0A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E0A
  ,simpleLowerCaseMapping:0x1E0B
  ,simpleTitleCaseMapping:0x1E0A
 },
 { code:0x1E0B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E0A
  ,simpleLowerCaseMapping:0x1E0B
  ,simpleTitleCaseMapping:0x1E0A
 },
 { code:0x1E0C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E0C
  ,simpleLowerCaseMapping:0x1E0D
  ,simpleTitleCaseMapping:0x1E0C
 },
 { code:0x1E0D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E0C
  ,simpleLowerCaseMapping:0x1E0D
  ,simpleTitleCaseMapping:0x1E0C
 },
 { code:0x1E0E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E0E
  ,simpleLowerCaseMapping:0x1E0F
  ,simpleTitleCaseMapping:0x1E0E
 },
 { code:0x1E0F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E0E
  ,simpleLowerCaseMapping:0x1E0F
  ,simpleTitleCaseMapping:0x1E0E
 },
 { code:0x1E10
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E10
  ,simpleLowerCaseMapping:0x1E11
  ,simpleTitleCaseMapping:0x1E10
 },
 { code:0x1E11
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E10
  ,simpleLowerCaseMapping:0x1E11
  ,simpleTitleCaseMapping:0x1E10
 },
 { code:0x1E12
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E12
  ,simpleLowerCaseMapping:0x1E13
  ,simpleTitleCaseMapping:0x1E12
 },
 { code:0x1E13
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E12
  ,simpleLowerCaseMapping:0x1E13
  ,simpleTitleCaseMapping:0x1E12
 },
 { code:0x1E14
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E14
  ,simpleLowerCaseMapping:0x1E15
  ,simpleTitleCaseMapping:0x1E14
 },
 { code:0x1E15
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E14
  ,simpleLowerCaseMapping:0x1E15
  ,simpleTitleCaseMapping:0x1E14
 },
 { code:0x1E16
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E16
  ,simpleLowerCaseMapping:0x1E17
  ,simpleTitleCaseMapping:0x1E16
 },
 { code:0x1E17
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E16
  ,simpleLowerCaseMapping:0x1E17
  ,simpleTitleCaseMapping:0x1E16
 },
 { code:0x1E18
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E18
  ,simpleLowerCaseMapping:0x1E19
  ,simpleTitleCaseMapping:0x1E18
 },
 { code:0x1E19
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E18
  ,simpleLowerCaseMapping:0x1E19
  ,simpleTitleCaseMapping:0x1E18
 },
 { code:0x1E1A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E1A
  ,simpleLowerCaseMapping:0x1E1B
  ,simpleTitleCaseMapping:0x1E1A
 },
 { code:0x1E1B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E1A
  ,simpleLowerCaseMapping:0x1E1B
  ,simpleTitleCaseMapping:0x1E1A
 },
 { code:0x1E1C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E1C
  ,simpleLowerCaseMapping:0x1E1D
  ,simpleTitleCaseMapping:0x1E1C
 },
 { code:0x1E1D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E1C
  ,simpleLowerCaseMapping:0x1E1D
  ,simpleTitleCaseMapping:0x1E1C
 },
 { code:0x1E1E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E1E
  ,simpleLowerCaseMapping:0x1E1F
  ,simpleTitleCaseMapping:0x1E1E
 },
 { code:0x1E1F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E1E
  ,simpleLowerCaseMapping:0x1E1F
  ,simpleTitleCaseMapping:0x1E1E
 },
 { code:0x1E20
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E20
  ,simpleLowerCaseMapping:0x1E21
  ,simpleTitleCaseMapping:0x1E20
 },
 { code:0x1E21
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E20
  ,simpleLowerCaseMapping:0x1E21
  ,simpleTitleCaseMapping:0x1E20
 },
 { code:0x1E22
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E22
  ,simpleLowerCaseMapping:0x1E23
  ,simpleTitleCaseMapping:0x1E22
 },
 { code:0x1E23
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E22
  ,simpleLowerCaseMapping:0x1E23
  ,simpleTitleCaseMapping:0x1E22
 },
 { code:0x1E24
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E24
  ,simpleLowerCaseMapping:0x1E25
  ,simpleTitleCaseMapping:0x1E24
 },
 { code:0x1E25
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E24
  ,simpleLowerCaseMapping:0x1E25
  ,simpleTitleCaseMapping:0x1E24
 },
 { code:0x1E26
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E26
  ,simpleLowerCaseMapping:0x1E27
  ,simpleTitleCaseMapping:0x1E26
 },
 { code:0x1E27
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E26
  ,simpleLowerCaseMapping:0x1E27
  ,simpleTitleCaseMapping:0x1E26
 },
 { code:0x1E28
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E28
  ,simpleLowerCaseMapping:0x1E29
  ,simpleTitleCaseMapping:0x1E28
 },
 { code:0x1E29
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E28
  ,simpleLowerCaseMapping:0x1E29
  ,simpleTitleCaseMapping:0x1E28
 },
 { code:0x1E2A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E2A
  ,simpleLowerCaseMapping:0x1E2B
  ,simpleTitleCaseMapping:0x1E2A
 },
 { code:0x1E2B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E2A
  ,simpleLowerCaseMapping:0x1E2B
  ,simpleTitleCaseMapping:0x1E2A
 },
 { code:0x1E2C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E2C
  ,simpleLowerCaseMapping:0x1E2D
  ,simpleTitleCaseMapping:0x1E2C
 },
 { code:0x1E2D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E2C
  ,simpleLowerCaseMapping:0x1E2D
  ,simpleTitleCaseMapping:0x1E2C
 },
 { code:0x1E2E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E2E
  ,simpleLowerCaseMapping:0x1E2F
  ,simpleTitleCaseMapping:0x1E2E
 },
 { code:0x1E2F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E2E
  ,simpleLowerCaseMapping:0x1E2F
  ,simpleTitleCaseMapping:0x1E2E
 },
 { code:0x1E30
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E30
  ,simpleLowerCaseMapping:0x1E31
  ,simpleTitleCaseMapping:0x1E30
 },
 { code:0x1E31
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E30
  ,simpleLowerCaseMapping:0x1E31
  ,simpleTitleCaseMapping:0x1E30
 },
 { code:0x1E32
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E32
  ,simpleLowerCaseMapping:0x1E33
  ,simpleTitleCaseMapping:0x1E32
 },
 { code:0x1E33
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E32
  ,simpleLowerCaseMapping:0x1E33
  ,simpleTitleCaseMapping:0x1E32
 },
 { code:0x1E34
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E34
  ,simpleLowerCaseMapping:0x1E35
  ,simpleTitleCaseMapping:0x1E34
 },
 { code:0x1E35
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E34
  ,simpleLowerCaseMapping:0x1E35
  ,simpleTitleCaseMapping:0x1E34
 },
 { code:0x1E36
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E36
  ,simpleLowerCaseMapping:0x1E37
  ,simpleTitleCaseMapping:0x1E36
 },
 { code:0x1E37
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E36
  ,simpleLowerCaseMapping:0x1E37
  ,simpleTitleCaseMapping:0x1E36
 },
 { code:0x1E38
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E38
  ,simpleLowerCaseMapping:0x1E39
  ,simpleTitleCaseMapping:0x1E38
 },
 { code:0x1E39
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E38
  ,simpleLowerCaseMapping:0x1E39
  ,simpleTitleCaseMapping:0x1E38
 },
 { code:0x1E3A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E3A
  ,simpleLowerCaseMapping:0x1E3B
  ,simpleTitleCaseMapping:0x1E3A
 },
 { code:0x1E3B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E3A
  ,simpleLowerCaseMapping:0x1E3B
  ,simpleTitleCaseMapping:0x1E3A
 },
 { code:0x1E3C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E3C
  ,simpleLowerCaseMapping:0x1E3D
  ,simpleTitleCaseMapping:0x1E3C
 },
 { code:0x1E3D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E3C
  ,simpleLowerCaseMapping:0x1E3D
  ,simpleTitleCaseMapping:0x1E3C
 },
 { code:0x1E3E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E3E
  ,simpleLowerCaseMapping:0x1E3F
  ,simpleTitleCaseMapping:0x1E3E
 },
 { code:0x1E3F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E3E
  ,simpleLowerCaseMapping:0x1E3F
  ,simpleTitleCaseMapping:0x1E3E
 },
 { code:0x1E40
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E40
  ,simpleLowerCaseMapping:0x1E41
  ,simpleTitleCaseMapping:0x1E40
 },
 { code:0x1E41
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E40
  ,simpleLowerCaseMapping:0x1E41
  ,simpleTitleCaseMapping:0x1E40
 },
 { code:0x1E42
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E42
  ,simpleLowerCaseMapping:0x1E43
  ,simpleTitleCaseMapping:0x1E42
 },
 { code:0x1E43
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E42
  ,simpleLowerCaseMapping:0x1E43
  ,simpleTitleCaseMapping:0x1E42
 },
 { code:0x1E44
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E44
  ,simpleLowerCaseMapping:0x1E45
  ,simpleTitleCaseMapping:0x1E44
 },
 { code:0x1E45
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E44
  ,simpleLowerCaseMapping:0x1E45
  ,simpleTitleCaseMapping:0x1E44
 },
 { code:0x1E46
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E46
  ,simpleLowerCaseMapping:0x1E47
  ,simpleTitleCaseMapping:0x1E46
 },
 { code:0x1E47
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E46
  ,simpleLowerCaseMapping:0x1E47
  ,simpleTitleCaseMapping:0x1E46
 },
 { code:0x1E48
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E48
  ,simpleLowerCaseMapping:0x1E49
  ,simpleTitleCaseMapping:0x1E48
 },
 { code:0x1E49
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E48
  ,simpleLowerCaseMapping:0x1E49
  ,simpleTitleCaseMapping:0x1E48
 },
 { code:0x1E4A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E4A
  ,simpleLowerCaseMapping:0x1E4B
  ,simpleTitleCaseMapping:0x1E4A
 },
 { code:0x1E4B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E4A
  ,simpleLowerCaseMapping:0x1E4B
  ,simpleTitleCaseMapping:0x1E4A
 },
 { code:0x1E4C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E4C
  ,simpleLowerCaseMapping:0x1E4D
  ,simpleTitleCaseMapping:0x1E4C
 },
 { code:0x1E4D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E4C
  ,simpleLowerCaseMapping:0x1E4D
  ,simpleTitleCaseMapping:0x1E4C
 },
 { code:0x1E4E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E4E
  ,simpleLowerCaseMapping:0x1E4F
  ,simpleTitleCaseMapping:0x1E4E
 },
 { code:0x1E4F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E4E
  ,simpleLowerCaseMapping:0x1E4F
  ,simpleTitleCaseMapping:0x1E4E
 },
 { code:0x1E50
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E50
  ,simpleLowerCaseMapping:0x1E51
  ,simpleTitleCaseMapping:0x1E50
 },
 { code:0x1E51
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E50
  ,simpleLowerCaseMapping:0x1E51
  ,simpleTitleCaseMapping:0x1E50
 },
 { code:0x1E52
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E52
  ,simpleLowerCaseMapping:0x1E53
  ,simpleTitleCaseMapping:0x1E52
 },
 { code:0x1E53
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E52
  ,simpleLowerCaseMapping:0x1E53
  ,simpleTitleCaseMapping:0x1E52
 },
 { code:0x1E54
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E54
  ,simpleLowerCaseMapping:0x1E55
  ,simpleTitleCaseMapping:0x1E54
 },
 { code:0x1E55
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E54
  ,simpleLowerCaseMapping:0x1E55
  ,simpleTitleCaseMapping:0x1E54
 },
 { code:0x1E56
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E56
  ,simpleLowerCaseMapping:0x1E57
  ,simpleTitleCaseMapping:0x1E56
 },
 { code:0x1E57
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E56
  ,simpleLowerCaseMapping:0x1E57
  ,simpleTitleCaseMapping:0x1E56
 },
 { code:0x1E58
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E58
  ,simpleLowerCaseMapping:0x1E59
  ,simpleTitleCaseMapping:0x1E58
 },
 { code:0x1E59
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E58
  ,simpleLowerCaseMapping:0x1E59
  ,simpleTitleCaseMapping:0x1E58
 },
 { code:0x1E5A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E5A
  ,simpleLowerCaseMapping:0x1E5B
  ,simpleTitleCaseMapping:0x1E5A
 },
 { code:0x1E5B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E5A
  ,simpleLowerCaseMapping:0x1E5B
  ,simpleTitleCaseMapping:0x1E5A
 },
 { code:0x1E5C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E5C
  ,simpleLowerCaseMapping:0x1E5D
  ,simpleTitleCaseMapping:0x1E5C
 },
 { code:0x1E5D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E5C
  ,simpleLowerCaseMapping:0x1E5D
  ,simpleTitleCaseMapping:0x1E5C
 },
 { code:0x1E5E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E5E
  ,simpleLowerCaseMapping:0x1E5F
  ,simpleTitleCaseMapping:0x1E5E
 },
 { code:0x1E5F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E5E
  ,simpleLowerCaseMapping:0x1E5F
  ,simpleTitleCaseMapping:0x1E5E
 },
 { code:0x1E60
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E60
  ,simpleLowerCaseMapping:0x1E61
  ,simpleTitleCaseMapping:0x1E60
 },
 { code:0x1E61
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E60
  ,simpleLowerCaseMapping:0x1E61
  ,simpleTitleCaseMapping:0x1E60
 },
 { code:0x1E62
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E62
  ,simpleLowerCaseMapping:0x1E63
  ,simpleTitleCaseMapping:0x1E62
 },
 { code:0x1E63
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E62
  ,simpleLowerCaseMapping:0x1E63
  ,simpleTitleCaseMapping:0x1E62
 },
 { code:0x1E64
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E64
  ,simpleLowerCaseMapping:0x1E65
  ,simpleTitleCaseMapping:0x1E64
 },
 { code:0x1E65
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E64
  ,simpleLowerCaseMapping:0x1E65
  ,simpleTitleCaseMapping:0x1E64
 },
 { code:0x1E66
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E66
  ,simpleLowerCaseMapping:0x1E67
  ,simpleTitleCaseMapping:0x1E66
 },
 { code:0x1E67
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E66
  ,simpleLowerCaseMapping:0x1E67
  ,simpleTitleCaseMapping:0x1E66
 },
 { code:0x1E68
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E68
  ,simpleLowerCaseMapping:0x1E69
  ,simpleTitleCaseMapping:0x1E68
 },
 { code:0x1E69
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E68
  ,simpleLowerCaseMapping:0x1E69
  ,simpleTitleCaseMapping:0x1E68
 },
 { code:0x1E6A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E6A
  ,simpleLowerCaseMapping:0x1E6B
  ,simpleTitleCaseMapping:0x1E6A
 },
 { code:0x1E6B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E6A
  ,simpleLowerCaseMapping:0x1E6B
  ,simpleTitleCaseMapping:0x1E6A
 },
 { code:0x1E6C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E6C
  ,simpleLowerCaseMapping:0x1E6D
  ,simpleTitleCaseMapping:0x1E6C
 },
 { code:0x1E6D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E6C
  ,simpleLowerCaseMapping:0x1E6D
  ,simpleTitleCaseMapping:0x1E6C
 },
 { code:0x1E6E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E6E
  ,simpleLowerCaseMapping:0x1E6F
  ,simpleTitleCaseMapping:0x1E6E
 },
 { code:0x1E6F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E6E
  ,simpleLowerCaseMapping:0x1E6F
  ,simpleTitleCaseMapping:0x1E6E
 },
 { code:0x1E70
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E70
  ,simpleLowerCaseMapping:0x1E71
  ,simpleTitleCaseMapping:0x1E70
 },
 { code:0x1E71
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E70
  ,simpleLowerCaseMapping:0x1E71
  ,simpleTitleCaseMapping:0x1E70
 },
 { code:0x1E72
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E72
  ,simpleLowerCaseMapping:0x1E73
  ,simpleTitleCaseMapping:0x1E72
 },
 { code:0x1E73
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E72
  ,simpleLowerCaseMapping:0x1E73
  ,simpleTitleCaseMapping:0x1E72
 },
 { code:0x1E74
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E74
  ,simpleLowerCaseMapping:0x1E75
  ,simpleTitleCaseMapping:0x1E74
 },
 { code:0x1E75
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E74
  ,simpleLowerCaseMapping:0x1E75
  ,simpleTitleCaseMapping:0x1E74
 },
 { code:0x1E76
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E76
  ,simpleLowerCaseMapping:0x1E77
  ,simpleTitleCaseMapping:0x1E76
 },
 { code:0x1E77
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E76
  ,simpleLowerCaseMapping:0x1E77
  ,simpleTitleCaseMapping:0x1E76
 },
 { code:0x1E78
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E78
  ,simpleLowerCaseMapping:0x1E79
  ,simpleTitleCaseMapping:0x1E78
 },
 { code:0x1E79
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E78
  ,simpleLowerCaseMapping:0x1E79
  ,simpleTitleCaseMapping:0x1E78
 },
 { code:0x1E7A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E7A
  ,simpleLowerCaseMapping:0x1E7B
  ,simpleTitleCaseMapping:0x1E7A
 },
 { code:0x1E7B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E7A
  ,simpleLowerCaseMapping:0x1E7B
  ,simpleTitleCaseMapping:0x1E7A
 },
 { code:0x1E7C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E7C
  ,simpleLowerCaseMapping:0x1E7D
  ,simpleTitleCaseMapping:0x1E7C
 },
 { code:0x1E7D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E7C
  ,simpleLowerCaseMapping:0x1E7D
  ,simpleTitleCaseMapping:0x1E7C
 },
 { code:0x1E7E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E7E
  ,simpleLowerCaseMapping:0x1E7F
  ,simpleTitleCaseMapping:0x1E7E
 },
 { code:0x1E7F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E7E
  ,simpleLowerCaseMapping:0x1E7F
  ,simpleTitleCaseMapping:0x1E7E
 },
 { code:0x1E80
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E80
  ,simpleLowerCaseMapping:0x1E81
  ,simpleTitleCaseMapping:0x1E80
 },
 { code:0x1E81
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E80
  ,simpleLowerCaseMapping:0x1E81
  ,simpleTitleCaseMapping:0x1E80
 },
 { code:0x1E82
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E82
  ,simpleLowerCaseMapping:0x1E83
  ,simpleTitleCaseMapping:0x1E82
 },
 { code:0x1E83
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E82
  ,simpleLowerCaseMapping:0x1E83
  ,simpleTitleCaseMapping:0x1E82
 },
 { code:0x1E84
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E84
  ,simpleLowerCaseMapping:0x1E85
  ,simpleTitleCaseMapping:0x1E84
 },
 { code:0x1E85
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E84
  ,simpleLowerCaseMapping:0x1E85
  ,simpleTitleCaseMapping:0x1E84
 },
 { code:0x1E86
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E86
  ,simpleLowerCaseMapping:0x1E87
  ,simpleTitleCaseMapping:0x1E86
 },
 { code:0x1E87
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E86
  ,simpleLowerCaseMapping:0x1E87
  ,simpleTitleCaseMapping:0x1E86
 },
 { code:0x1E88
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E88
  ,simpleLowerCaseMapping:0x1E89
  ,simpleTitleCaseMapping:0x1E88
 },
 { code:0x1E89
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E88
  ,simpleLowerCaseMapping:0x1E89
  ,simpleTitleCaseMapping:0x1E88
 },
 { code:0x1E8A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E8A
  ,simpleLowerCaseMapping:0x1E8B
  ,simpleTitleCaseMapping:0x1E8A
 },
 { code:0x1E8B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E8A
  ,simpleLowerCaseMapping:0x1E8B
  ,simpleTitleCaseMapping:0x1E8A
 },
 { code:0x1E8C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E8C
  ,simpleLowerCaseMapping:0x1E8D
  ,simpleTitleCaseMapping:0x1E8C
 },
 { code:0x1E8D
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E8C
  ,simpleLowerCaseMapping:0x1E8D
  ,simpleTitleCaseMapping:0x1E8C
 },
 { code:0x1E8E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E8E
  ,simpleLowerCaseMapping:0x1E8F
  ,simpleTitleCaseMapping:0x1E8E
 },
 { code:0x1E8F
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E8E
  ,simpleLowerCaseMapping:0x1E8F
  ,simpleTitleCaseMapping:0x1E8E
 },
 { code:0x1E90
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E90
  ,simpleLowerCaseMapping:0x1E91
  ,simpleTitleCaseMapping:0x1E90
 },
 { code:0x1E91
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E90
  ,simpleLowerCaseMapping:0x1E91
  ,simpleTitleCaseMapping:0x1E90
 },
 { code:0x1E92
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E92
  ,simpleLowerCaseMapping:0x1E93
  ,simpleTitleCaseMapping:0x1E92
 },
 { code:0x1E93
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E92
  ,simpleLowerCaseMapping:0x1E93
  ,simpleTitleCaseMapping:0x1E92
 },
 { code:0x1E94
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1E94
  ,simpleLowerCaseMapping:0x1E95
  ,simpleTitleCaseMapping:0x1E94
 },
 { code:0x1E95
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E94
  ,simpleLowerCaseMapping:0x1E95
  ,simpleTitleCaseMapping:0x1E94
 },
 { code:0x1E96
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x1E96
  ,simpleLowerCaseMapping:0x1E96
  ,simpleTitleCaseMapping:0x1E96
 },
 { code:0x1E97
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x1E97
  ,simpleLowerCaseMapping:0x1E97
  ,simpleTitleCaseMapping:0x1E97
 },
 { code:0x1E98
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x1E98
  ,simpleLowerCaseMapping:0x1E98
  ,simpleTitleCaseMapping:0x1E98
 },
 { code:0x1E99
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x1E99
  ,simpleLowerCaseMapping:0x1E99
  ,simpleTitleCaseMapping:0x1E99
 },
 { code:0x1E9A
  ,generalCategory:UnicodeData.GeneralCategory.Ll | UnicodeData.GeneralCategory.SpecialMapping
  ,simpleUpperCaseMapping:0x1E9A
  ,simpleLowerCaseMapping:0x1E9A
  ,simpleTitleCaseMapping:0x1E9A
 },
 { code:0x1E9B
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1E60
  ,simpleLowerCaseMapping:0x1E9B
  ,simpleTitleCaseMapping:0x1E60
 },
 { code:0x1EA0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EA0
  ,simpleLowerCaseMapping:0x1EA1
  ,simpleTitleCaseMapping:0x1EA0
 },
 { code:0x1EA1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EA0
  ,simpleLowerCaseMapping:0x1EA1
  ,simpleTitleCaseMapping:0x1EA0
 },
 { code:0x1EA2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EA2
  ,simpleLowerCaseMapping:0x1EA3
  ,simpleTitleCaseMapping:0x1EA2
 },
 { code:0x1EA3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EA2
  ,simpleLowerCaseMapping:0x1EA3
  ,simpleTitleCaseMapping:0x1EA2
 },
 { code:0x1EA4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EA4
  ,simpleLowerCaseMapping:0x1EA5
  ,simpleTitleCaseMapping:0x1EA4
 },
 { code:0x1EA5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EA4
  ,simpleLowerCaseMapping:0x1EA5
  ,simpleTitleCaseMapping:0x1EA4
 },
 { code:0x1EA6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EA6
  ,simpleLowerCaseMapping:0x1EA7
  ,simpleTitleCaseMapping:0x1EA6
 },
 { code:0x1EA7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EA6
  ,simpleLowerCaseMapping:0x1EA7
  ,simpleTitleCaseMapping:0x1EA6
 },
 { code:0x1EA8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EA8
  ,simpleLowerCaseMapping:0x1EA9
  ,simpleTitleCaseMapping:0x1EA8
 },
 { code:0x1EA9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EA8
  ,simpleLowerCaseMapping:0x1EA9
  ,simpleTitleCaseMapping:0x1EA8
 },
 { code:0x1EAA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EAA
  ,simpleLowerCaseMapping:0x1EAB
  ,simpleTitleCaseMapping:0x1EAA
 },
 { code:0x1EAB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EAA
  ,simpleLowerCaseMapping:0x1EAB
  ,simpleTitleCaseMapping:0x1EAA
 },
 { code:0x1EAC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EAC
  ,simpleLowerCaseMapping:0x1EAD
  ,simpleTitleCaseMapping:0x1EAC
 },
 { code:0x1EAD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EAC
  ,simpleLowerCaseMapping:0x1EAD
  ,simpleTitleCaseMapping:0x1EAC
 },
 { code:0x1EAE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EAE
  ,simpleLowerCaseMapping:0x1EAF
  ,simpleTitleCaseMapping:0x1EAE
 },
 { code:0x1EAF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EAE
  ,simpleLowerCaseMapping:0x1EAF
  ,simpleTitleCaseMapping:0x1EAE
 },
 { code:0x1EB0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EB0
  ,simpleLowerCaseMapping:0x1EB1
  ,simpleTitleCaseMapping:0x1EB0
 },
 { code:0x1EB1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EB0
  ,simpleLowerCaseMapping:0x1EB1
  ,simpleTitleCaseMapping:0x1EB0
 },
 { code:0x1EB2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EB2
  ,simpleLowerCaseMapping:0x1EB3
  ,simpleTitleCaseMapping:0x1EB2
 },
 { code:0x1EB3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EB2
  ,simpleLowerCaseMapping:0x1EB3
  ,simpleTitleCaseMapping:0x1EB2
 },
 { code:0x1EB4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EB4
  ,simpleLowerCaseMapping:0x1EB5
  ,simpleTitleCaseMapping:0x1EB4
 },
 { code:0x1EB5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EB4
  ,simpleLowerCaseMapping:0x1EB5
  ,simpleTitleCaseMapping:0x1EB4
 },
 { code:0x1EB6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EB6
  ,simpleLowerCaseMapping:0x1EB7
  ,simpleTitleCaseMapping:0x1EB6
 },
 { code:0x1EB7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EB6
  ,simpleLowerCaseMapping:0x1EB7
  ,simpleTitleCaseMapping:0x1EB6
 },
 { code:0x1EB8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EB8
  ,simpleLowerCaseMapping:0x1EB9
  ,simpleTitleCaseMapping:0x1EB8
 },
 { code:0x1EB9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EB8
  ,simpleLowerCaseMapping:0x1EB9
  ,simpleTitleCaseMapping:0x1EB8
 },
 { code:0x1EBA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EBA
  ,simpleLowerCaseMapping:0x1EBB
  ,simpleTitleCaseMapping:0x1EBA
 },
 { code:0x1EBB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EBA
  ,simpleLowerCaseMapping:0x1EBB
  ,simpleTitleCaseMapping:0x1EBA
 },
 { code:0x1EBC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EBC
  ,simpleLowerCaseMapping:0x1EBD
  ,simpleTitleCaseMapping:0x1EBC
 },
 { code:0x1EBD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EBC
  ,simpleLowerCaseMapping:0x1EBD
  ,simpleTitleCaseMapping:0x1EBC
 },
 { code:0x1EBE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EBE
  ,simpleLowerCaseMapping:0x1EBF
  ,simpleTitleCaseMapping:0x1EBE
 },
 { code:0x1EBF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EBE
  ,simpleLowerCaseMapping:0x1EBF
  ,simpleTitleCaseMapping:0x1EBE
 },
 { code:0x1EC0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EC0
  ,simpleLowerCaseMapping:0x1EC1
  ,simpleTitleCaseMapping:0x1EC0
 },
 { code:0x1EC1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EC0
  ,simpleLowerCaseMapping:0x1EC1
  ,simpleTitleCaseMapping:0x1EC0
 },
 { code:0x1EC2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EC2
  ,simpleLowerCaseMapping:0x1EC3
  ,simpleTitleCaseMapping:0x1EC2
 },
 { code:0x1EC3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EC2
  ,simpleLowerCaseMapping:0x1EC3
  ,simpleTitleCaseMapping:0x1EC2
 },
 { code:0x1EC4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EC4
  ,simpleLowerCaseMapping:0x1EC5
  ,simpleTitleCaseMapping:0x1EC4
 },
 { code:0x1EC5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EC4
  ,simpleLowerCaseMapping:0x1EC5
  ,simpleTitleCaseMapping:0x1EC4
 },
 { code:0x1EC6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EC6
  ,simpleLowerCaseMapping:0x1EC7
  ,simpleTitleCaseMapping:0x1EC6
 },
 { code:0x1EC7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EC6
  ,simpleLowerCaseMapping:0x1EC7
  ,simpleTitleCaseMapping:0x1EC6
 },
 { code:0x1EC8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EC8
  ,simpleLowerCaseMapping:0x1EC9
  ,simpleTitleCaseMapping:0x1EC8
 },
 { code:0x1EC9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EC8
  ,simpleLowerCaseMapping:0x1EC9
  ,simpleTitleCaseMapping:0x1EC8
 },
 { code:0x1ECA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1ECA
  ,simpleLowerCaseMapping:0x1ECB
  ,simpleTitleCaseMapping:0x1ECA
 },
 { code:0x1ECB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1ECA
  ,simpleLowerCaseMapping:0x1ECB
  ,simpleTitleCaseMapping:0x1ECA
 },
 { code:0x1ECC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1ECC
  ,simpleLowerCaseMapping:0x1ECD
  ,simpleTitleCaseMapping:0x1ECC
 },
 { code:0x1ECD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1ECC
  ,simpleLowerCaseMapping:0x1ECD
  ,simpleTitleCaseMapping:0x1ECC
 },
 { code:0x1ECE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1ECE
  ,simpleLowerCaseMapping:0x1ECF
  ,simpleTitleCaseMapping:0x1ECE
 },
 { code:0x1ECF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1ECE
  ,simpleLowerCaseMapping:0x1ECF
  ,simpleTitleCaseMapping:0x1ECE
 },
 { code:0x1ED0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1ED0
  ,simpleLowerCaseMapping:0x1ED1
  ,simpleTitleCaseMapping:0x1ED0
 },
 { code:0x1ED1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1ED0
  ,simpleLowerCaseMapping:0x1ED1
  ,simpleTitleCaseMapping:0x1ED0
 },
 { code:0x1ED2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1ED2
  ,simpleLowerCaseMapping:0x1ED3
  ,simpleTitleCaseMapping:0x1ED2
 },
 { code:0x1ED3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1ED2
  ,simpleLowerCaseMapping:0x1ED3
  ,simpleTitleCaseMapping:0x1ED2
 },
 { code:0x1ED4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1ED4
  ,simpleLowerCaseMapping:0x1ED5
  ,simpleTitleCaseMapping:0x1ED4
 },
 { code:0x1ED5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1ED4
  ,simpleLowerCaseMapping:0x1ED5
  ,simpleTitleCaseMapping:0x1ED4
 },
 { code:0x1ED6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1ED6
  ,simpleLowerCaseMapping:0x1ED7
  ,simpleTitleCaseMapping:0x1ED6
 },
 { code:0x1ED7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1ED6
  ,simpleLowerCaseMapping:0x1ED7
  ,simpleTitleCaseMapping:0x1ED6
 },
 { code:0x1ED8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1ED8
  ,simpleLowerCaseMapping:0x1ED9
  ,simpleTitleCaseMapping:0x1ED8
 },
 { code:0x1ED9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1ED8
  ,simpleLowerCaseMapping:0x1ED9
  ,simpleTitleCaseMapping:0x1ED8
 },
 { code:0x1EDA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EDA
  ,simpleLowerCaseMapping:0x1EDB
  ,simpleTitleCaseMapping:0x1EDA
 },
 { code:0x1EDB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EDA
  ,simpleLowerCaseMapping:0x1EDB
  ,simpleTitleCaseMapping:0x1EDA
 },
 { code:0x1EDC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EDC
  ,simpleLowerCaseMapping:0x1EDD
  ,simpleTitleCaseMapping:0x1EDC
 },
 { code:0x1EDD
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EDC
  ,simpleLowerCaseMapping:0x1EDD
  ,simpleTitleCaseMapping:0x1EDC
 },
 { code:0x1EDE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EDE
  ,simpleLowerCaseMapping:0x1EDF
  ,simpleTitleCaseMapping:0x1EDE
 },
 { code:0x1EDF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EDE
  ,simpleLowerCaseMapping:0x1EDF
  ,simpleTitleCaseMapping:0x1EDE
 },
 { code:0x1EE0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EE0
  ,simpleLowerCaseMapping:0x1EE1
  ,simpleTitleCaseMapping:0x1EE0
 },
 { code:0x1EE1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EE0
  ,simpleLowerCaseMapping:0x1EE1
  ,simpleTitleCaseMapping:0x1EE0
 },
 { code:0x1EE2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EE2
  ,simpleLowerCaseMapping:0x1EE3
  ,simpleTitleCaseMapping:0x1EE2
 },
 { code:0x1EE3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EE2
  ,simpleLowerCaseMapping:0x1EE3
  ,simpleTitleCaseMapping:0x1EE2
 },
 { code:0x1EE4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EE4
  ,simpleLowerCaseMapping:0x1EE5
  ,simpleTitleCaseMapping:0x1EE4
 },
 { code:0x1EE5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EE4
  ,simpleLowerCaseMapping:0x1EE5
  ,simpleTitleCaseMapping:0x1EE4
 },
 { code:0x1EE6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EE6
  ,simpleLowerCaseMapping:0x1EE7
  ,simpleTitleCaseMapping:0x1EE6
 },
 { code:0x1EE7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EE6
  ,simpleLowerCaseMapping:0x1EE7
  ,simpleTitleCaseMapping:0x1EE6
 },
 { code:0x1EE8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EE8
  ,simpleLowerCaseMapping:0x1EE9
  ,simpleTitleCaseMapping:0x1EE8
 },
 { code:0x1EE9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EE8
  ,simpleLowerCaseMapping:0x1EE9
  ,simpleTitleCaseMapping:0x1EE8
 },
 { code:0x1EEA
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EEA
  ,simpleLowerCaseMapping:0x1EEB
  ,simpleTitleCaseMapping:0x1EEA
 },
 { code:0x1EEB
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EEA
  ,simpleLowerCaseMapping:0x1EEB
  ,simpleTitleCaseMapping:0x1EEA
 },
 { code:0x1EEC
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EEC
  ,simpleLowerCaseMapping:0x1EED
  ,simpleTitleCaseMapping:0x1EEC
 },
 { code:0x1EED
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EEC
  ,simpleLowerCaseMapping:0x1EED
  ,simpleTitleCaseMapping:0x1EEC
 },
 { code:0x1EEE
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EEE
  ,simpleLowerCaseMapping:0x1EEF
  ,simpleTitleCaseMapping:0x1EEE
 },
 { code:0x1EEF
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EEE
  ,simpleLowerCaseMapping:0x1EEF
  ,simpleTitleCaseMapping:0x1EEE
 },
 { code:0x1EF0
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EF0
  ,simpleLowerCaseMapping:0x1EF1
  ,simpleTitleCaseMapping:0x1EF0
 },
 { code:0x1EF1
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EF0
  ,simpleLowerCaseMapping:0x1EF1
  ,simpleTitleCaseMapping:0x1EF0
 },
 { code:0x1EF2
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EF2
  ,simpleLowerCaseMapping:0x1EF3
  ,simpleTitleCaseMapping:0x1EF2
 },
 { code:0x1EF3
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EF2
  ,simpleLowerCaseMapping:0x1EF3
  ,simpleTitleCaseMapping:0x1EF2
 },
 { code:0x1EF4
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EF4
  ,simpleLowerCaseMapping:0x1EF5
  ,simpleTitleCaseMapping:0x1EF4
 },
 { code:0x1EF5
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EF4
  ,simpleLowerCaseMapping:0x1EF5
  ,simpleTitleCaseMapping:0x1EF4
 },
 { code:0x1EF6
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EF6
  ,simpleLowerCaseMapping:0x1EF7
  ,simpleTitleCaseMapping:0x1EF6
 },
 { code:0x1EF7
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EF6
  ,simpleLowerCaseMapping:0x1EF7
  ,simpleTitleCaseMapping:0x1EF6
 },
 { code:0x1EF8
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1EF8
  ,simpleLowerCaseMapping:0x1EF9
  ,simpleTitleCaseMapping:0x1EF8
 },
 { code:0x1EF9
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1EF8
  ,simpleLowerCaseMapping:0x1EF9
  ,simpleTitleCaseMapping:0x1EF8
 },
 { code:0x1F00
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F08
  ,simpleLowerCaseMapping:0x1F00
  ,simpleTitleCaseMapping:0x1F08
 },
 { code:0x1F01
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F09
  ,simpleLowerCaseMapping:0x1F01
  ,simpleTitleCaseMapping:0x1F09
 },
 { code:0x1F02
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F0A
  ,simpleLowerCaseMapping:0x1F02
  ,simpleTitleCaseMapping:0x1F0A
 },
 { code:0x1F03
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F0B
  ,simpleLowerCaseMapping:0x1F03
  ,simpleTitleCaseMapping:0x1F0B
 },
 { code:0x1F04
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F0C
  ,simpleLowerCaseMapping:0x1F04
  ,simpleTitleCaseMapping:0x1F0C
 },
 { code:0x1F05
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F0D
  ,simpleLowerCaseMapping:0x1F05
  ,simpleTitleCaseMapping:0x1F0D
 },
 { code:0x1F06
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F0E
  ,simpleLowerCaseMapping:0x1F06
  ,simpleTitleCaseMapping:0x1F0E
 },
 { code:0x1F07
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F0F
  ,simpleLowerCaseMapping:0x1F07
  ,simpleTitleCaseMapping:0x1F0F
 },
 { code:0x1F08
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F08
  ,simpleLowerCaseMapping:0x1F00
  ,simpleTitleCaseMapping:0x1F08
 },
 { code:0x1F09
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F09
  ,simpleLowerCaseMapping:0x1F01
  ,simpleTitleCaseMapping:0x1F09
 },
 { code:0x1F0A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F0A
  ,simpleLowerCaseMapping:0x1F02
  ,simpleTitleCaseMapping:0x1F0A
 },
 { code:0x1F0B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F0B
  ,simpleLowerCaseMapping:0x1F03
  ,simpleTitleCaseMapping:0x1F0B
 },
 { code:0x1F0C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F0C
  ,simpleLowerCaseMapping:0x1F04
  ,simpleTitleCaseMapping:0x1F0C
 },
 { code:0x1F0D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F0D
  ,simpleLowerCaseMapping:0x1F05
  ,simpleTitleCaseMapping:0x1F0D
 },
 { code:0x1F0E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F0E
  ,simpleLowerCaseMapping:0x1F06
  ,simpleTitleCaseMapping:0x1F0E
 },
 { code:0x1F0F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F0F
  ,simpleLowerCaseMapping:0x1F07
  ,simpleTitleCaseMapping:0x1F0F
 },
 { code:0x1F10
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F18
  ,simpleLowerCaseMapping:0x1F10
  ,simpleTitleCaseMapping:0x1F18
 },
 { code:0x1F11
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F19
  ,simpleLowerCaseMapping:0x1F11
  ,simpleTitleCaseMapping:0x1F19
 },
 { code:0x1F12
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F1A
  ,simpleLowerCaseMapping:0x1F12
  ,simpleTitleCaseMapping:0x1F1A
 },
 { code:0x1F13
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F1B
  ,simpleLowerCaseMapping:0x1F13
  ,simpleTitleCaseMapping:0x1F1B
 },
 { code:0x1F14
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F1C
  ,simpleLowerCaseMapping:0x1F14
  ,simpleTitleCaseMapping:0x1F1C
 },
 { code:0x1F15
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F1D
  ,simpleLowerCaseMapping:0x1F15
  ,simpleTitleCaseMapping:0x1F1D
 },
 { code:0x1F18
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F18
  ,simpleLowerCaseMapping:0x1F10
  ,simpleTitleCaseMapping:0x1F18
 },
 { code:0x1F19
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F19
  ,simpleLowerCaseMapping:0x1F11
  ,simpleTitleCaseMapping:0x1F19
 },
 { code:0x1F1A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F1A
  ,simpleLowerCaseMapping:0x1F12
  ,simpleTitleCaseMapping:0x1F1A
 },
 { code:0x1F1B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F1B
  ,simpleLowerCaseMapping:0x1F13
  ,simpleTitleCaseMapping:0x1F1B
 },
 { code:0x1F1C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F1C
  ,simpleLowerCaseMapping:0x1F14
  ,simpleTitleCaseMapping:0x1F1C
 },
 { code:0x1F1D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F1D
  ,simpleLowerCaseMapping:0x1F15
  ,simpleTitleCaseMapping:0x1F1D
 },
 { code:0x1F20
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F28
  ,simpleLowerCaseMapping:0x1F20
  ,simpleTitleCaseMapping:0x1F28
 },
 { code:0x1F21
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F29
  ,simpleLowerCaseMapping:0x1F21
  ,simpleTitleCaseMapping:0x1F29
 },
 { code:0x1F22
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F2A
  ,simpleLowerCaseMapping:0x1F22
  ,simpleTitleCaseMapping:0x1F2A
 },
 { code:0x1F23
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F2B
  ,simpleLowerCaseMapping:0x1F23
  ,simpleTitleCaseMapping:0x1F2B
 },
 { code:0x1F24
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F2C
  ,simpleLowerCaseMapping:0x1F24
  ,simpleTitleCaseMapping:0x1F2C
 },
 { code:0x1F25
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F2D
  ,simpleLowerCaseMapping:0x1F25
  ,simpleTitleCaseMapping:0x1F2D
 },
 { code:0x1F26
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F2E
  ,simpleLowerCaseMapping:0x1F26
  ,simpleTitleCaseMapping:0x1F2E
 },
 { code:0x1F27
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F2F
  ,simpleLowerCaseMapping:0x1F27
  ,simpleTitleCaseMapping:0x1F2F
 },
 { code:0x1F28
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F28
  ,simpleLowerCaseMapping:0x1F20
  ,simpleTitleCaseMapping:0x1F28
 },
 { code:0x1F29
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F29
  ,simpleLowerCaseMapping:0x1F21
  ,simpleTitleCaseMapping:0x1F29
 },
 { code:0x1F2A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F2A
  ,simpleLowerCaseMapping:0x1F22
  ,simpleTitleCaseMapping:0x1F2A
 },
 { code:0x1F2B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F2B
  ,simpleLowerCaseMapping:0x1F23
  ,simpleTitleCaseMapping:0x1F2B
 },
 { code:0x1F2C
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F2C
  ,simpleLowerCaseMapping:0x1F24
  ,simpleTitleCaseMapping:0x1F2C
 },
 { code:0x1F2D
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F2D
  ,simpleLowerCaseMapping:0x1F25
  ,simpleTitleCaseMapping:0x1F2D
 },
 { code:0x1F2E
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F2E
  ,simpleLowerCaseMapping:0x1F26
  ,simpleTitleCaseMapping:0x1F2E
 },
 { code:0x1F2F
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F2F
  ,simpleLowerCaseMapping:0x1F27
  ,simpleTitleCaseMapping:0x1F2F
 },
 { code:0x1F30
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F38
  ,simpleLowerCaseMapping:0x1F30
  ,simpleTitleCaseMapping:0x1F38
 },
 { code:0x1F31
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F39
  ,simpleLowerCaseMapping:0x1F31
  ,simpleTitleCaseMapping:0x1F39
 },
 { code:0x1F32
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F3A
  ,simpleLowerCaseMapping:0x1F32
  ,simpleTitleCaseMapping:0x1F3A
 },
 { code:0x1F33
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F3B
  ,simpleLowerCaseMapping:0x1F33
  ,simpleTitleCaseMapping:0x1F3B
 },
 { code:0x1F34
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F3C
  ,simpleLowerCaseMapping:0x1F34
  ,simpleTitleCaseMapping:0x1F3C
 },
 { code:0x1F35
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F3D
  ,simpleLowerCaseMapping:0x1F35
  ,simpleTitleCaseMapping:0x1F3D
 },
 { code:0x1F36
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F3E
  ,simpleLowerCaseMapping:0x1F36
  ,simpleTitleCaseMapping:0x1F3E
 },
 { code:0x1F37
  ,generalCategory:UnicodeData.GeneralCategory.Ll
  ,simpleUpperCaseMapping:0x1F3F
  ,simpleLowerCaseMapping:0x1F37
  ,simpleTitleCaseMapping:0x1F3F
 },
 { code:0x1F38
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F38
  ,simpleLowerCaseMapping:0x1F30
  ,simpleTitleCaseMapping:0x1F38
 },
 { code:0x1F39
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F39
  ,simpleLowerCaseMapping:0x1F31
  ,simpleTitleCaseMapping:0x1F39
 },
 { code:0x1F3A
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F3A
  ,simpleLowerCaseMapping:0x1F32
  ,simpleTitleCaseMapping:0x1F3A
 },
 { code:0x1F3B
  ,generalCategory:UnicodeData.GeneralCategory.Lu
  ,simpleUpperCaseMapping:0x1F3B
  ,simpleLowerCaseMapping:0x1F33
  ,simpleTitleCaseMapping:0x1F3