/* GenericSelectionModel.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl;

import javax.swing.event.ChangeListener;

/**
 * Model which keeps track of a single element selected from a group. The element
 * is represented by an object type {@code E}. Classes that satisfy this interface
 * can be used to implement a {@link GenericSelectionGroup}.<p>
 * Models of this type are used by the {@link be.ugent.caagt.swirl.menus.MenuBuilder}
 * to implement radio button groups.
 */
public interface GenericSelectionModel<E> {
    /**
     * Returns the current selection or null if nothing is currently
     * selected.
     */
    public E getSelection ();

    /**
     * Set the current selection and notify any listeners in case of changes.
     * @param element object which represents the selected
     * element, or null if the selection should be cleared
     */
    public void setSelection(E element);

    /**
     * Clears the selection. Short for
     * <pre>
     *    setSelection(null);
     * </pre>
     */
    public void clearSelection();

    /**
     * Check whether an element is currently  selected. Short for
     * <pre>
     *    getSelection() != null
     * </pre>
     */
    public boolean isSelected();

    /**
     * Adds a listener which should be notified of all changes in the model.
     */
    void addChangeListener(ChangeListener listener);

    /**
     * Removes a listener previously registered with {@link #addChangeListener}.
     */
    void removeChangeListener(ChangeListener listener);

}
