/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.persist;

import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.InstanceNotFoundException;

/**
 * Management interface for components able to persist information to a storage media.
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.4 $
 */
public interface PersisterMBean
{
	/**
	 * Loads the information persisted on the storage media.
	 * @see #store
	 */
	public Object load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException;

	/**
	 * Store the given information to the storage media.
	 * @see #load
	 */
	public void store(Object data) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException;
}
