/*
 * Copyright 2002-2012 Drew Noakes
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 *
 * More information about this project is available at:
 *
 *    http://drewnoakes.com/code/exif/
 *    http://code.google.com/p/metadata-extractor/
 */
package com.drew.metadata.jpeg;

import org.junit.Assert;
import org.junit.Test;

/**
 * @author Drew Noakes http://drewnoakes.com
 */
public class JpegComponentTest
{
    @Test
    public void testGetComponentCharacter() throws Exception
    {
        JpegComponent component;

        component = new JpegComponent(1,2,3);
        Assert.assertEquals("Y", component.getComponentName());

        component = new JpegComponent(2,2,3);
        Assert.assertEquals("Cb", component.getComponentName());

        component = new JpegComponent(3,2,3);
        Assert.assertEquals("Cr", component.getComponentName());

        component = new JpegComponent(4,2,3);
        Assert.assertEquals("I", component.getComponentName());

        component = new JpegComponent(5,2,3);
        Assert.assertEquals("Q", component.getComponentName());
    }
}
