/* gsd-utils.c generated by valac 0.34.2, the Vala compiler
 * generated from gsd-utils.vala, do not modify */

/* 
 * 
 * Copyright (C) 2009-2011 Colomban Wendling <ban@herbesfolles.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <glib.h>
#include <glib-object.h>
#include <sys/select.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

/**
   * Error domain for the FD namespace functions. It is mainly a wrapper around
   * some errnos to have exceptions for them.
   */
typedef enum  {
	GSD_FD_ERROR_KILL_ERROR,
	GSD_FD_ERROR_READ_ERROR,
	GSD_FD_ERROR_SELECT_ERROR,
	GSD_FD_ERROR_WAITPID_ERROR
} GsdFDError;
#define GSD_FD_ERROR gsd_fd_error_quark ()


GQuark gsd_fd_error_quark (void);
gboolean gsd_fd_read_ready (gint fd, GError** error);
gchar* gsd_fd_read_string (gint fd, gssize n_bytes, GError** error);
guint gsd_fd_count_ready_bytes (gint fd, gint byte, gsize bufsize, GError** error);


GQuark gsd_fd_error_quark (void) {
	return g_quark_from_static_string ("gsd_fd_error-quark");
}


/**
     * Gets whether a file descriptor is ready to be read or not.
     * 
     * Being ready means that reading data from it would not be blocking, as
     * there is data to be read.
     * 
     * @param fd a file descriptor
     * 
     * @return %TRUE if the file is read, %FALSE otherwise.
     */
gboolean gsd_fd_read_ready (gint fd, GError** error) {
	gboolean result = FALSE;
	gboolean ready = FALSE;
	gint _tmp0_ = 0;
	GError * _inner_error_ = NULL;
	ready = FALSE;
	_tmp0_ = fd;
	if (_tmp0_ > 0) {
		fd_set rfds = {0};
		fd_set _tmp1_ = {0};
		struct timeval tv = {0};
		struct timeval _tmp2_ = {0};
		fd_set _tmp3_ = {0};
		gint _tmp4_ = 0;
		gint rv = 0;
		gint _tmp5_ = 0;
		struct timeval _tmp6_ = {0};
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		rfds = _tmp1_;
		_tmp2_.tv_sec = (time_t) 0;
		_tmp2_.tv_usec = (glong) 0;
		tv = _tmp2_;
		FD_ZERO (&_tmp3_);
		rfds = _tmp3_;
		_tmp4_ = fd;
		FD_SET (_tmp4_, &rfds);
		_tmp5_ = fd;
		_tmp6_ = tv;
		_tmp7_ = select (_tmp5_ + 1, &rfds, NULL, NULL, &_tmp6_);
		rv = _tmp7_;
		_tmp8_ = rv;
		if (_tmp8_ == -1) {
			gint _tmp9_ = 0;
			const gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
			_tmp9_ = errno;
			_tmp10_ = g_strerror (_tmp9_);
			_tmp11_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_SELECT_ERROR, "select(): %s", _tmp10_);
			_inner_error_ = _tmp11_;
			if (_inner_error_->domain == GSD_FD_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		} else {
			gint _tmp12_ = 0;
			_tmp12_ = rv;
			if (_tmp12_ > 0) {
				ready = TRUE;
			}
		}
	}
	result = ready;
	return result;
}


/**
     * Reads content of a file as a string.
     * 
     * This function may only work with text data.
     * 
     * @param fd a file descriptor
     * @param n_bytes number of bytes to read from @fd, or -1 to read all @fd
     * 
     * @return a newly allocated string containing data in @fd.
     */
gchar* gsd_fd_read_string (gint fd, gssize n_bytes, GError** error) {
	gchar* result = NULL;
	gchar* buf = NULL;
	gssize _tmp0_ = 0L;
	gchar* _tmp46_ = NULL;
	GError * _inner_error_ = NULL;
	buf = NULL;
	_tmp0_ = n_bytes;
	if (_tmp0_ > ((gssize) 0)) {
		gssize n_read = 0L;
		gssize _tmp1_ = 0L;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gssize _tmp5_ = 0L;
		gssize _tmp6_ = 0L;
		gssize _tmp7_ = 0L;
		_tmp1_ = n_bytes;
		_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
		buf = _tmp2_;
		_tmp3_ = fd;
		_tmp4_ = buf;
		_tmp5_ = n_bytes;
		_tmp6_ = read (_tmp3_, _tmp4_, (gsize) _tmp5_);
		n_read = _tmp6_;
		_tmp7_ = n_read;
		if (_tmp7_ < ((gssize) 0)) {
			gint errn = 0;
			gint _tmp8_ = 0;
			gchar* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			const gchar* _tmp11_ = NULL;
			GError* _tmp12_ = NULL;
			_tmp8_ = errno;
			errn = _tmp8_;
			_tmp9_ = buf;
			g_free (_tmp9_);
			buf = NULL;
			_tmp10_ = errn;
			_tmp11_ = g_strerror (_tmp10_);
			_tmp12_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_READ_ERROR, "read(): %s", _tmp11_);
			_inner_error_ = _tmp12_;
			if (_inner_error_->domain == GSD_FD_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		} else {
			gchar* _tmp13_ = NULL;
			gssize _tmp14_ = 0L;
			gchar _tmp15_ = '\0';
			_tmp13_ = buf;
			_tmp14_ = n_read;
			_tmp13_[_tmp14_] = (gchar) 0;
			_tmp15_ = _tmp13_[_tmp14_];
		}
	} else {
		gsize packet_size = 0UL;
		gsize n_read = 0UL;
		gssize read_rv = 0L;
		gssize _tmp37_ = 0L;
		packet_size = (gsize) 64;
		n_read = (gsize) 0;
		read_rv = (gssize) 0;
		n_bytes = (gssize) 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gchar* _tmp23_ = NULL;
				gssize _tmp24_ = 0L;
				gsize _tmp25_ = 0UL;
				void* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				gchar* _tmp28_ = NULL;
				gssize _tmp29_ = 0L;
				gsize _tmp30_ = 0UL;
				gssize _tmp31_ = 0L;
				gssize _tmp32_ = 0L;
				gssize _tmp35_ = 0L;
				gsize _tmp36_ = 0UL;
				if (!_tmp16_) {
					gboolean _tmp17_ = FALSE;
					gboolean _tmp18_ = FALSE;
					gssize _tmp19_ = 0L;
					_tmp19_ = n_bytes;
					if (_tmp19_ > ((gssize) 0)) {
						gssize _tmp20_ = 0L;
						_tmp20_ = read_rv;
						_tmp18_ = _tmp20_ >= ((gssize) 0);
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						gssize _tmp21_ = 0L;
						gsize _tmp22_ = 0UL;
						_tmp21_ = read_rv;
						_tmp22_ = packet_size;
						_tmp17_ = ((gsize) _tmp21_) == _tmp22_;
					} else {
						_tmp17_ = FALSE;
					}
					if (!_tmp17_) {
						break;
					}
				}
				_tmp16_ = FALSE;
				_tmp23_ = buf;
				_tmp24_ = n_bytes;
				_tmp25_ = packet_size;
				_tmp26_ = g_realloc (_tmp23_, (_tmp24_ + _tmp25_) + 1);
				buf = _tmp26_;
				_tmp27_ = fd;
				_tmp28_ = buf;
				_tmp29_ = n_bytes;
				_tmp30_ = packet_size;
				_tmp31_ = read (_tmp27_, &_tmp28_[_tmp29_], _tmp30_);
				read_rv = _tmp31_;
				_tmp32_ = read_rv;
				if (_tmp32_ >= ((gssize) 0)) {
					gsize _tmp33_ = 0UL;
					gssize _tmp34_ = 0L;
					_tmp33_ = n_read;
					_tmp34_ = read_rv;
					n_read = _tmp33_ + _tmp34_;
				}
				_tmp35_ = n_bytes;
				_tmp36_ = packet_size;
				n_bytes = _tmp35_ + ((gssize) _tmp36_);
			}
		}
		_tmp37_ = read_rv;
		if (_tmp37_ < ((gssize) 0)) {
			gint errn = 0;
			gint _tmp38_ = 0;
			gchar* _tmp39_ = NULL;
			gint _tmp40_ = 0;
			const gchar* _tmp41_ = NULL;
			GError* _tmp42_ = NULL;
			_tmp38_ = errno;
			errn = _tmp38_;
			_tmp39_ = buf;
			g_free (_tmp39_);
			buf = NULL;
			_tmp40_ = errn;
			_tmp41_ = g_strerror (_tmp40_);
			_tmp42_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_READ_ERROR, "read(): %s", _tmp41_);
			_inner_error_ = _tmp42_;
			if (_inner_error_->domain == GSD_FD_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		} else {
			gchar* _tmp43_ = NULL;
			gsize _tmp44_ = 0UL;
			gchar _tmp45_ = '\0';
			_tmp43_ = buf;
			_tmp44_ = n_read;
			_tmp43_[_tmp44_] = (gchar) 0;
			_tmp45_ = _tmp43_[_tmp44_];
		}
	}
	_tmp46_ = buf;
	buf = NULL;
	result = (gchar*) _tmp46_;
	return result;
}


/**
     * Counts the number of occurrence of a given byte in a file descriptor.
     * 
     * This function is non-blocking and returns 0 if there is no data in the
     * buffer rather than blocking waiting for data.
     * 
     * @param fd a valid file descriptor
     * @param byte the byte to cont in @fd
     * @param bufsize the size of the buffer used to cache the file's content.
     *    Tweaking it may improve the performances with different amount of data
     *    in @fd: the better value is the closer to the total number of bytes
     *    that will be read (the size of the file's content) or a multiple of it
     *    if it is a too big value to be reasonably allocated at once.
     * 
     * @return the number of occurrences of @byte in @fd.
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


guint gsd_fd_count_ready_bytes (gint fd, gint byte, gsize bufsize, GError** error) {
	guint result = 0U;
	guint n_occur = 0U;
	GError * _inner_error_ = NULL;
	n_occur = (guint) 0;
	{
		gboolean _tmp0_ = FALSE;
		gint _tmp1_ = 0;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = fd;
		_tmp2_ = gsd_fd_read_ready (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == GSD_FD_ERROR) {
				goto __catch11_gsd_fd_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
		if (_tmp0_) {
			gchar* buf = NULL;
			gsize _tmp3_ = 0UL;
			gchar* _tmp4_ = NULL;
			gint buf_length1 = 0;
			gint _buf_size_ = 0;
			gssize read_rv = 0L;
			_tmp3_ = bufsize;
			_tmp4_ = g_new0 (gchar, _tmp3_);
			buf = _tmp4_;
			buf_length1 = _tmp3_;
			_buf_size_ = buf_length1;
			read_rv = (gssize) 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gint _tmp8_ = 0;
					gchar* _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gsize _tmp10_ = 0UL;
					gssize _tmp11_ = 0L;
					gssize _tmp12_ = 0L;
					if (!_tmp5_) {
						gssize _tmp6_ = 0L;
						gsize _tmp7_ = 0UL;
						_tmp6_ = read_rv;
						_tmp7_ = bufsize;
						if (!(((gsize) _tmp6_) == _tmp7_)) {
							break;
						}
					}
					_tmp5_ = FALSE;
					_tmp8_ = fd;
					_tmp9_ = buf;
					_tmp9__length1 = buf_length1;
					_tmp10_ = bufsize;
					_tmp11_ = read (_tmp8_, _tmp9_, _tmp10_);
					read_rv = _tmp11_;
					_tmp12_ = read_rv;
					if (_tmp12_ < ((gssize) 0)) {
						gint _tmp13_ = 0;
						const gchar* _tmp14_ = NULL;
						GError* _tmp15_ = NULL;
						_tmp13_ = errno;
						_tmp14_ = g_strerror (_tmp13_);
						_tmp15_ = g_error_new (GSD_FD_ERROR, GSD_FD_ERROR_READ_ERROR, "read(): %s", _tmp14_);
						_inner_error_ = _tmp15_;
						buf = (g_free (buf), NULL);
						if (_inner_error_->domain == GSD_FD_ERROR) {
							goto __catch11_gsd_fd_error;
						}
						buf = (g_free (buf), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0U;
					} else {
						{
							guint i = 0U;
							i = (guint) 0;
							{
								gboolean _tmp16_ = FALSE;
								_tmp16_ = TRUE;
								while (TRUE) {
									guint _tmp18_ = 0U;
									gssize _tmp19_ = 0L;
									gchar* _tmp20_ = NULL;
									gint _tmp20__length1 = 0;
									guint _tmp21_ = 0U;
									gchar _tmp22_ = '\0';
									gint _tmp23_ = 0;
									if (!_tmp16_) {
										guint _tmp17_ = 0U;
										_tmp17_ = i;
										i = _tmp17_ + 1;
									}
									_tmp16_ = FALSE;
									_tmp18_ = i;
									_tmp19_ = read_rv;
									if (!(((gssize) _tmp18_) < _tmp19_)) {
										break;
									}
									_tmp20_ = buf;
									_tmp20__length1 = buf_length1;
									_tmp21_ = i;
									_tmp22_ = _tmp20_[_tmp21_];
									_tmp23_ = byte;
									if (((gint) _tmp22_) == _tmp23_) {
										guint _tmp24_ = 0U;
										_tmp24_ = n_occur;
										n_occur = _tmp24_ + 1;
									}
								}
							}
						}
					}
				}
			}
			buf = (g_free (buf), NULL);
		}
	}
	goto __finally11;
	__catch11_gsd_fd_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _g_error_copy0 (_tmp25_);
		_inner_error_ = _tmp26_;
		_g_error_free0 (e);
		goto __finally11;
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GSD_FD_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0U;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	result = n_occur;
	return result;
}



