/* $Id: input.c,v 1.3 2002/02/22 21:51:05 soyt Exp $
******************************************************************************

   DirectX inputlib

   Copyright (C) 1999-2000 John Fortin		[fortinj@ibm.net]
   Copyright (C) 2000      Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include <dxinput.h>

#include "dxinputkb.h"


typedef struct digii
{
	HANDLE hWnd;
	HINSTANCE hInstance;
} DIGII, *lpDIGII;		/* End structure */


static gii_event_mask
GII_send_key(gii_input *inp, uint32 sym, uint8 press)
{
	gii_event ev;

	_giiEventBlank(&ev, sizeof(gii_key_event));

	if (press) {
		ev.any.size = sizeof(gii_key_event);
		ev.any.type = evKeyPress;
		ev.any.origin = inp->origin;
		ev.key.modifiers = DI_PRIV(inp)->modifiers;
		ev.key.sym = dx_kb[sym];
		ev.key.label = dx_kb[sym];
		ev.key.button = sym;
		_giiEvQueueAdd(inp, &ev);

		return emKeyPress;
	} else {
		ev.any.size = sizeof(gii_key_event);
		ev.any.type = evKeyRelease;
		ev.any.origin = inp->origin;
		ev.key.modifiers = DI_PRIV(inp)->modifiers;
		ev.key.sym = dx_kb[sym];
		ev.key.label = dx_kb[sym];
		ev.key.button = sym;
		_giiEvQueueAdd(inp, &ev);

		return emKeyRelease;
	}
}


static gii_event_mask
GII_send_ptr(gii_input * inp, uint32 type, LPPOINT CurPos, uint32 data)
{
	gii_event ev;

	_giiEventBlank(&ev, sizeof(gii_key_event));

	switch (type) {
	case DIMOFS_X:		/* Mouse X movement */
	case DIMOFS_Y:		/* Mouse Y Movement */
		{
			ev.any.size = sizeof(gii_pmove_event);
			ev.any.type = evPtrAbsolute;
			ev.any.origin = inp->origin;
			ev.pmove.x = CurPos->x;
			ev.pmove.y = CurPos->y;
			_giiEvQueueAdd(inp, &ev);
			return emPtrAbsolute;
		}
	case DIMOFS_BUTTON0:
		{		/* Key Release */
			ev.any.size = sizeof(gii_pmove_event);
			ev.any.type = evPtrAbsolute;
			ev.any.origin = inp->origin;
			ev.pmove.x = CurPos->x;
			ev.pmove.y = CurPos->y;
			_giiEvQueueAdd(inp, &ev);

			ev.any.size = sizeof(gii_pbutton_event);
			if (data) {
				ev.any.type = evPtrButtonPress;
			} else {
				ev.any.type = evPtrButtonRelease;
			}	/* End if */
			ev.any.origin = inp->origin;
			ev.pbutton.button = GII_PBUTTON_LEFT;
			_giiEvQueueAdd(inp, &ev);
			if (data) {
				return emPtrButtonPress | emPtrAbsolute;
			} else {
				return emPtrButtonRelease | emPtrAbsolute;
			}	/* End if */
		}

	case DIMOFS_BUTTON1:
		{		/* Key Release */
			ev.any.size = sizeof(gii_pmove_event);
			ev.any.type = evPtrAbsolute;
			ev.any.origin = inp->origin;
			ev.pmove.x = CurPos->x;
			ev.pmove.y = CurPos->y;
			_giiEvQueueAdd(inp, &ev);

			ev.any.size = sizeof(gii_pbutton_event);
			if (data) {
				ev.any.type = evPtrButtonPress;
			} else {
				ev.any.type = evPtrButtonRelease;
			}	/* End if */
			ev.any.origin = inp->origin;
			ev.pbutton.button = GII_PBUTTON_RIGHT;
			_giiEvQueueAdd(inp, &ev);
			if (data) {
				return emPtrButtonPress | emPtrAbsolute;
			} else {
				return emPtrButtonRelease | emPtrAbsolute;
			}	/* End if */
		}

	}			/* End switch */
	return 0;		/* Should never get here */
}


static gii_event_mask
GII_di_poll(gii_input *inp, void *arg)
{
	gii_di_priv *priv = inp->priv;
	DWORD KB_Elements;
	DWORD Ptr_Elements;
	POINT CurPos;
	RECT WinSize;
	uint32 i;
	uint8 KB_Buffer[2 * GII_DX_BUFFER_SIZE];
	sint8 Ptr_Buffer[2 * GII_DX_BUFFER_SIZE];
	gii_event_mask return_mask = 0;

	_gii_dx_GetKBInput(priv, &KB_Elements, (char *) KB_Buffer);
	for (i = 0; i < KB_Elements; i++) {
		if ((dx_kb[KB_Buffer[2 * i]] == GIIK_ShiftR) ||
		    (dx_kb[KB_Buffer[2 * i]] == GIIK_ShiftL)) {
			if (KB_Buffer[2 * i + 1] == 'D') {
				priv->modifiers |= GII_MOD_SHIFT;
				return_mask |= GII_send_key(inp,
							KB_Buffer[2 * i], 1);
			} else {
				priv->modifiers &= 0xE;
				return_mask |= GII_send_key(inp,
							KB_Buffer[2 * i], 0);
			}
		} else if (dx_kb[KB_Buffer[2 * i]] == GIIK_CtrlR ||
			   dx_kb[KB_Buffer[2 * i]] == GIIK_CtrlL) {
			if (KB_Buffer[2 * i + 1] == 'D') {
				priv->modifiers |= GII_MOD_CTRL;
				return_mask |= GII_send_key(inp,
							KB_Buffer[2 * i], 1);
			} else {
				priv->modifiers &= 0xD;
				return_mask |= GII_send_key(inp,
							KB_Buffer[2 * i], 0);
			}
		} else if (dx_kb[KB_Buffer[2 * i]] == GIIK_AltR ||
			   dx_kb[KB_Buffer[2 * i]] == GIIK_AltL) {
			if (KB_Buffer[2 * i + 1] == 'D') {
				priv->modifiers |= GII_MOD_ALT;
				return_mask |= GII_send_key(inp,
							KB_Buffer[2 * i], 1);
			} else {
				priv->modifiers &= 0xB;
				return_mask |= GII_send_key(inp,
							KB_Buffer[2 * i], 0);
			}
		} else if (KB_Buffer[2 * i + 1] == 'D') {
			GIIDPRINT("gii_send_key: poll(%p);\n", inp);
			return_mask |= GII_send_key(inp, KB_Buffer[2 * i], 1);
		} else {
			return_mask |= GII_send_key(inp, KB_Buffer[2 * i], 0);
		}
	}

	_gii_dx_GetPtrInput(priv, &Ptr_Elements, (char *) Ptr_Buffer);
	for (i = 0; i < Ptr_Elements; i++) {
		switch (Ptr_Buffer[2 * i]) {
		case DIMOFS_X:
		case DIMOFS_Y:
		case DIMOFS_BUTTON0:
		case DIMOFS_BUTTON1:
			GetCursorPos(&CurPos);
			ScreenToClient(priv->hWnd, &CurPos);
			GetClientRect(priv->hWnd, &WinSize);
			if (CurPos.x < 0)
				CurPos.x = 0;
			if (CurPos.y < 0)
				CurPos.y = 0;
			if (CurPos.x > WinSize.right)
				CurPos.x = WinSize.right;
			if (CurPos.y > WinSize.bottom)
				CurPos.y = WinSize.bottom;
			return_mask |= GII_send_ptr(inp, Ptr_Buffer[2 * i],
					&CurPos, Ptr_Buffer[2 * i + 1] & 0x80);
			break;
		}
	}

	return return_mask;
}


static int
GII_di_close(gii_input *inp)
{
	gii_di_priv *priv = inp->priv;

	free(priv);

	GIIDPRINT_MISC("input-directx: closed\n");

	return 0;
}


static gii_cmddata_getdevinfo devinfo =
{
	"MS Direct Input",	/* long device name */
	"di",			/* shorthand */
	emKeyPress | emKeyRelease |	/* can_generate */
	    emPtrButtonRelease | emPtrButtonPress |
	    emPtrRelative,
	256,			/* 256 pseudo buttons */
	0			/* no valuators */
};

static void
send_devinfo(gii_input * inp)
{
	gii_event ev;
	gii_cmddata_getdevinfo *dinfo;
	int size = sizeof(gii_cmd_nodata_event)
		+ sizeof(gii_cmddata_getdevinfo);

	_giiEventBlank(&ev, size);

	ev.any.size = size;
	ev.any.type = evCommand;
	ev.any.origin = inp->origin;
	ev.cmd.code = GII_CMDCODE_GETDEVINFO;

	dinfo = (gii_cmddata_getdevinfo *) & ev.cmd.data;
	*dinfo = devinfo;

	_giiEvQueueAdd(inp, &ev);
}


static int
GIIsendevent(gii_input * inp, gii_event * ev)
{
	if (ev->any.target != inp->origin &&
	    ev->any.target != GII_EV_TARGET_ALL) {
		/* not for us */
		return GGI_EEVNOTARGET;
	}
	if (ev->any.type != evCommand) {
		return GGI_EEVUNKNOWN;
	}
	if (ev->cmd.code == GII_CMDCODE_GETDEVINFO) {
		send_devinfo(inp);
		return 0;
	}
	return GGI_EEVUNKNOWN;	/* Unknown command */
}


int
GIIdlinit(gii_input * inp, const char *args, void *argptr)
{
	gii_di_priv *priv;
	lpDIGII digii = (lpDIGII) argptr;
	int ret;

	GIIDPRINT_LIBS("DXINPUT HWND=%ld hInstance=%ld\n",
		       (long)digii->hWnd, (long)digii->hInstance);

	priv = malloc(sizeof(gii_di_priv));
	if (priv == NULL) {
		return GGI_ENOMEM;
	}

	if(_giiRegisterDevice(inp,&devinfo,NULL)==0) {
		free(priv);
		return GGI_ENOMEM;
	}

	priv->hWnd = digii->hWnd;
	priv->pDI = NULL;
	priv->pKeyboard = NULL;
	priv->pMouse = NULL;
	priv->modifiers = 0;

	ret = _gii_dx_InitDirectInput(priv, digii->hWnd, digii->hInstance);
	if (ret != 0) {
		GIIDPRINT_LIBS("input-directx: Unable to grab keyboard\n");
		GIIDPRINT_LIBS("HWND=%ld rc=%d\n",
			       (long)digii->hWnd, ret);
		free(priv);
		return GGI_ENODEVICE;
	}

	inp->priv = priv;

	inp->GIIsendevent = GIIsendevent;
	inp->GIIeventpoll = GII_di_poll;
	inp->GIIclose = GII_di_close;

	inp->targetcan = emKeyPress | emKeyRelease |
	    emPtrRelative | emPtrButtonPress |
	    emPtrButtonRelease;

	inp->curreventmask = emKeyPress | emKeyRelease |
	    emPtrRelative | emPtrButtonPress |
	    emPtrButtonRelease;

	inp->flags = GII_FLAGS_HASPOLLED;
	inp->maxfd = 0;

	initkb();
	send_devinfo(inp);

	return 0;
}
