/* $Id: dxinputkb.h,v 1.1.1.1 2001/05/12 23:00:15 cegger Exp $
******************************************************************************

   DirectX inputlib keyboard mapping

   Copyright (C) 1999-2000 John Fortin		[fortinj@ibm.net]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <dinput.h>
#include <ggi/keyboard.h>

static uint16 dx_kb[256];

static void
initkb(void)
{
	dx_kb[DIK_1] = (uint16) GIIUC_1;
	dx_kb[DIK_2] = (uint16) GIIUC_2;
	dx_kb[DIK_3] = (uint16) GIIUC_3;
	dx_kb[DIK_4] = (uint16) GIIUC_4;
	dx_kb[DIK_5] = (uint16) GIIUC_5;
	dx_kb[DIK_6] = (uint16) GIIUC_6;
	dx_kb[DIK_7] = (uint16) GIIUC_7;
	dx_kb[DIK_8] = (uint16) GIIUC_8;
	dx_kb[DIK_9] = (uint16) GIIUC_9;
	dx_kb[DIK_0] = (uint16) GIIUC_0;
	dx_kb[DIK_A] = (uint16) GIIUC_A;
	dx_kb[DIK_B] = (uint16) GIIUC_B;
	dx_kb[DIK_C] = (uint16) GIIUC_C;
	dx_kb[DIK_D] = (uint16) GIIUC_D;
	dx_kb[DIK_E] = (uint16) GIIUC_E;
	dx_kb[DIK_F] = (uint16) GIIUC_F;
	dx_kb[DIK_G] = (uint16) GIIUC_G;
	dx_kb[DIK_H] = (uint16) GIIUC_H;
	dx_kb[DIK_I] = (uint16) GIIUC_I;
	dx_kb[DIK_J] = (uint16) GIIUC_J;
	dx_kb[DIK_K] = (uint16) GIIUC_K;
	dx_kb[DIK_L] = (uint16) GIIUC_L;
	dx_kb[DIK_M] = (uint16) GIIUC_M;
	dx_kb[DIK_N] = (uint16) GIIUC_N;
	dx_kb[DIK_O] = (uint16) GIIUC_O;
	dx_kb[DIK_P] = (uint16) GIIUC_P;
	dx_kb[DIK_Q] = (uint16) GIIUC_Q;
	dx_kb[DIK_R] = (uint16) GIIUC_R;
	dx_kb[DIK_S] = (uint16) GIIUC_S;
	dx_kb[DIK_T] = (uint16) GIIUC_T;
	dx_kb[DIK_U] = (uint16) GIIUC_U;
	dx_kb[DIK_V] = (uint16) GIIUC_V;
	dx_kb[DIK_W] = (uint16) GIIUC_W;
	dx_kb[DIK_X] = (uint16) GIIUC_X;
	dx_kb[DIK_Y] = (uint16) GIIUC_Y;
	dx_kb[DIK_Z] = (uint16) GIIUC_Z;
	dx_kb[DIK_ESCAPE] = (uint16) GIIUC_Escape;
	dx_kb[DIK_MINUS] = (uint16) GIIUC_Minus;
	dx_kb[DIK_EQUALS] = (uint16) GIIUC_Equal;
	dx_kb[DIK_BACK] = (uint16) GIIUC_BackSpace;
	dx_kb[DIK_TAB] = (uint16) GIIUC_Tab;
	dx_kb[DIK_LBRACKET] = (uint16) GIIUC_BracketLeft;
	dx_kb[DIK_RBRACKET] = (uint16) GIIUC_BracketRight;
	dx_kb[DIK_RETURN] = (uint16) GIIUC_Return;
	dx_kb[DIK_SEMICOLON] = (uint16) GIIUC_Semicolon;
	dx_kb[DIK_APOSTROPHE] = (uint16) GIIUC_Apostrophe;
	dx_kb[DIK_GRAVE] = (uint16) GIIUC_Grave;
	dx_kb[DIK_BACKSLASH] = (uint16) GIIUC_BackSlash;
	dx_kb[DIK_COMMA] = (uint16) GIIUC_Comma;
	dx_kb[DIK_PERIOD] = (uint16) GIIUC_Period;
	dx_kb[DIK_SLASH] = (uint16) GIIUC_Slash;
	dx_kb[DIK_SPACE] = (uint16) GIIUC_Space;
	dx_kb[DIK_AT] = (uint16) GIIUC_At;
	dx_kb[DIK_COLON] = (uint16) GIIUC_Colon;
	dx_kb[DIK_UNDERLINE] = (uint16) GIIUC_Underscore;

	dx_kb[DIK_LSHIFT] = (uint16) GIIK_ShiftL;
	dx_kb[DIK_RSHIFT] = (uint16) GIIK_ShiftR;
	dx_kb[DIK_LCONTROL] = (uint16) GIIK_CtrlL;
	dx_kb[DIK_RCONTROL] = (uint16) GIIK_CtrlR;
	dx_kb[DIK_LMENU] = (uint16) GIIK_AltL;
	dx_kb[DIK_RMENU] = (uint16) GIIK_AltR;
	dx_kb[DIK_CAPITAL] = (uint16) GIIK_Caps;
	dx_kb[DIK_NUMLOCK] = (uint16) GIIK_Num;
	dx_kb[DIK_SCROLL] = (uint16) GIIK_Scroll;
	dx_kb[DIK_SUBTRACT] = (uint16) GIIK_PMinus;
	dx_kb[DIK_ADD] = (uint16) GIIK_PPlus;
	dx_kb[DIK_MULTIPLY] = (uint16) GIIK_PAsterisk;
	dx_kb[DIK_DIVIDE] = (uint16) GIIK_PSlash;
	dx_kb[DIK_NUMPADEQUALS] = (uint16) GIIK_PEqual;
	dx_kb[DIK_NUMPADENTER] = (uint16) GIIK_PEnter;
	dx_kb[DIK_NUMPADCOMMA] = (uint16) GIIK_PSeparator;
	dx_kb[DIK_NUMPAD1] = (uint16) GIIK_P1;
	dx_kb[DIK_NUMPAD2] = (uint16) GIIK_P2;
	dx_kb[DIK_NUMPAD3] = (uint16) GIIK_P3;
	dx_kb[DIK_NUMPAD4] = (uint16) GIIK_P4;
	dx_kb[DIK_NUMPAD5] = (uint16) GIIK_P5;
	dx_kb[DIK_NUMPAD6] = (uint16) GIIK_P6;
	dx_kb[DIK_NUMPAD7] = (uint16) GIIK_P7;
	dx_kb[DIK_NUMPAD8] = (uint16) GIIK_P8;
	dx_kb[DIK_NUMPAD9] = (uint16) GIIK_P9;
	dx_kb[DIK_NUMPAD0] = (uint16) GIIK_P0;
	dx_kb[DIK_DECIMAL] = (uint16) GIIK_PDecimal;
	dx_kb[DIK_F1] = (uint16) GIIK_F1;
	dx_kb[DIK_F2] = (uint16) GIIK_F2;
	dx_kb[DIK_F3] = (uint16) GIIK_F3;
	dx_kb[DIK_F4] = (uint16) GIIK_F4;
	dx_kb[DIK_F5] = (uint16) GIIK_F5;
	dx_kb[DIK_F6] = (uint16) GIIK_F6;
	dx_kb[DIK_F7] = (uint16) GIIK_F7;
	dx_kb[DIK_F8] = (uint16) GIIK_F8;
	dx_kb[DIK_F9] = (uint16) GIIK_F9;
	dx_kb[DIK_F10] = (uint16) GIIK_F10;
	dx_kb[DIK_F11] = (uint16) GIIK_F11;
	dx_kb[DIK_F12] = (uint16) GIIK_F12;
	dx_kb[DIK_F13] = (uint16) GIIK_F13;
	dx_kb[DIK_F14] = (uint16) GIIK_F14;
	dx_kb[DIK_F15] = (uint16) GIIK_F15;
	dx_kb[DIK_SYSRQ] = (uint16) GIIK_SysRq;
	dx_kb[DIK_HOME] = (uint16) GIIK_Home;
	dx_kb[DIK_END] = (uint16) GIIK_End;
	dx_kb[DIK_PRIOR] = (uint16) GIIK_Prior;
	dx_kb[DIK_NEXT] = (uint16) GIIK_Next;
	dx_kb[DIK_UP] = (uint16) GIIK_Up;
	dx_kb[DIK_DOWN] = (uint16) GIIK_Down;
	dx_kb[DIK_LEFT] = (uint16) GIIK_Left;
	dx_kb[DIK_RIGHT] = (uint16) GIIK_Right;
	dx_kb[DIK_INSERT] = (uint16) GIIK_Insert;
	dx_kb[DIK_DELETE] = (uint16) GIIK_Delete;
}
