/*******************************************************************************************************************************************
 cmetaclass.c
*******************************************************************************************************************************************/

#include "cmetaclass.h"

static bool FirstScop = true;

CMetaClasses CMetaClass::MetaClasses (FirstScop ? CMetaClasses() : CMetaClasses (CMetaClass::MetaClasses));

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CMetaClass::CMetaClass 	     (const CMetaClass *inBaseMetaClass, const TMetaClass inMetaClassType, const UInt32 inClassTag,
			      const CString &inClassName, const UInt16 inClassSize, CClass * (*inClassInstanciate) ())
	   :BaseMetaClass    (inBaseMetaClass),
	    MetaClassType    (inMetaClassType),
	    ClassTag	     (inClassTag),
	    ClassName	     (inClassName),
	    ClassSize	     (inClassSize),
	    ClassInstanciate (inClassInstanciate)
{ 
	if (ClassTag > 0L && CMetaClass::GetMetaClass (ClassTag) == NULL) CMetaClass::MetaClasses += this;
	::FirstScop = false;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CMetaClass::~CMetaClass ()
{
	CMetaClass::MetaClasses -= this;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// search for class tag
//------------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CMetaClass::GetMetaClass (const UInt32 inClassTag)
{
	for (size_t i=CMetaClass::MetaClasses.GetLength(); i>0; i--)
		if ((*CMetaClass::MetaClasses[i-1]) -> ClassTag == inClassTag)
			return *CMetaClass::MetaClasses[i-1];
	return NULL;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// search for class name
//------------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CMetaClass::GetMetaClass (const CString &inClassName)
{
	for (size_t i=CMetaClass::MetaClasses.GetLength(); i>0; i--)
		if ((*CMetaClass::MetaClasses[i-1]) -> ClassName == inClassName)
			return *CMetaClass::MetaClasses[i-1];
	return NULL;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// derivation test
//------------------------------------------------------------------------------------------------------------------------------------------
bool CMetaClass::MetaClassIs (const CMetaClass *inBase, const CMetaClass *inCandidate)
{
	if (inBase == NULL) return true;
	CMetaClass *theMetaClass = const_cast <CMetaClass *> (inCandidate);
	while (theMetaClass != NULL)
	{
		if (theMetaClass -> ClassTag == inBase -> ClassTag) return true;
		theMetaClass = const_cast <CMetaClass *> (theMetaClass -> BaseMetaClass);
	}
	return false;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// derivation test
//------------------------------------------------------------------------------------------------------------------------------------------
bool CMetaClass::IsFinal (const CMetaClass *inMetaClass)
{
	if (inMetaClass == NULL) return true;
	for (size_t i=CMetaClass::MetaClasses.GetLength(); i>0; i--)
		if ((*CMetaClass::MetaClasses[i-1]) -> BaseMetaClass != NULL)
			if ((*CMetaClass::MetaClasses[i-1]) -> BaseMetaClass -> ClassTag == inMetaClass -> ClassTag)
				return false;
	return true;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// hierarchy build out
//------------------------------------------------------------------------------------------------------------------------------------------
CMetaClassNode CMetaClass::GetMetaClassTree ()
{
	CMetaClassNode outTree (NULL, NULL, false);
	for (size_t i=CMetaClass::MetaClasses.GetLength(), j=0; i>0; i--, j++)
	{
		CMetaClass *theMetaClass = const_cast <CMetaClass *> (*CMetaClass::MetaClasses[j]);
		if (theMetaClass -> BaseMetaClass == NULL)
		{
			outTree.SetValue (theMetaClass);
		}
		else
		{
			CMetaClassNode *theOwner = outTree.Find (const_cast <CMetaClass *> (theMetaClass -> BaseMetaClass));
			if (theOwner != NULL) new CMetaClassNode (theOwner, theMetaClass, false);
		}
	}
	return outTree;
}
