/*
 * Copyright (C) 2006,2007  Stefan Siegl <stesie@brokenpipe.de>, Germany
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <string.h>

#include <geier.h>
#include <geierversion.h>

void geier_check_version(const char *version)
{
	const char *myversion = LIBGEIER_DOTTED_VERSION;
	const char *ptr = strchr(myversion, '.');

	if(strncmp(myversion, version, ptr - myversion)) {
		fprintf(stderr, "Fatal: program compiled against libgeier %s "
			"using libgeier %s\n\n", version, myversion);
	}

	else if(strcmp(myversion, version)) {
		fprintf(stderr, "Warning: program compiled against libgeier "
			"%s using libgeier %s\n\n", version, myversion);
	}
}

void geier_check_crypto_module(const char *module_name)
{
	const char *mymodule_name = LIBGEIER_CRYPTO_MODULE;

	if(strcmp(mymodule_name, module_name)) {
		fprintf(stderr, "Warning: program compiled against libgeier "
		        "with crypto module `%s' using a libgeier based "
			"on `%s'.\n\n", module_name, mymodule_name);
	}
}
