/*
 * Galago Account API
 *
 * Copyright (C) 2004-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_ACCOUNT_H_
#define _GALAGO_ACCOUNT_H_

typedef struct _GalagoAccount        GalagoAccount;
typedef struct _GalagoAccountClass   GalagoAccountClass;
typedef struct _GalagoAccountPrivate GalagoAccountPrivate;

#include <libgalago/galago-image.h>
#include <libgalago/galago-object.h>
#include <libgalago/galago-person.h>
#include <libgalago/galago-presence.h>
#include <libgalago/galago-service.h>

struct _GalagoAccount
{
	GalagoObject parent_object;

	GalagoAccountPrivate *priv;

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

struct _GalagoAccountClass
{
	GalagoObjectClass parent_class;

	/* Signals */
	void (*connection_state_changed)(GalagoAccount *account);
	void (*display_name_changed)(GalagoAccount *account);
	void (*presence_created)(GalagoAccount *account, GalagoPresence *presence);
	void (*presence_deleted)(GalagoAccount *account);
	void (*avatar_set)(GalagoAccount *account, GalagoImage *image);
	void (*contact_added)(GalagoAccount *account, GalagoAccount *contact);
	void (*contact_removed)(GalagoAccount *account, GalagoAccount *contact);

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

#define GALAGO_TYPE_ACCOUNT (galago_account_get_type())
#define GALAGO_ACCOUNT(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_TYPE_ACCOUNT, \
									GalagoAccount))
#define GALAGO_ACCOUNT_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_TYPE_ACCOUNT, \
								 GalagoAccountClass))
#define GALAGO_IS_ACCOUNT(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_TYPE_ACCOUNT))
#define GALAGO_IS_ACCOUNT_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_TYPE_ACCOUNT))
#define GALAGO_ACCOUNT_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS((obj), GALAGO_TYPE_ACCOUNT, \
								   GalagoAccountClass))

#define GALAGO_DBUS_ACCOUNT_INTERFACE "org.freedesktop.Galago.Account"

G_BEGIN_DECLS

/**************************************************************************/
/** Account API                                                           */
/**************************************************************************/

GType galago_account_get_type(void);

void galago_account_set_connected(GalagoAccount *account,
								  gboolean connected);
gboolean galago_account_is_connected(const GalagoAccount *account);

GalagoService *galago_account_get_service(const GalagoAccount *account);
GalagoPerson *galago_account_get_person(const GalagoAccount *account);
const char *galago_account_get_username(const GalagoAccount *account);

void galago_account_set_display_name(GalagoAccount *account,
									 const char *display_name);
const char *galago_account_get_display_name(const GalagoAccount *account);
gboolean galago_account_is_display_name_set(const GalagoAccount *account);

void galago_account_add_contact(GalagoAccount *account,
								GalagoAccount *contact);
void galago_account_remove_contact(GalagoAccount *account,
								   GalagoAccount *contact);
GalagoAccount *galago_account_get_contact(const GalagoAccount *account,
										  const char *username,
										  gboolean query);
GList *galago_account_get_contacts(const GalagoAccount *account,
								   gboolean query);

GalagoPresence *galago_account_create_presence(GalagoAccount *account);
GalagoPresence *galago_account_get_presence(const GalagoAccount *account,
											gboolean query);

void galago_account_set_avatar(GalagoAccount *account, GalagoImage *avatar);
GalagoImage *galago_account_get_avatar(const GalagoAccount *account,
									   gboolean query);

G_END_DECLS

#endif /* _GALAGO_ACCOUNT_H_ */
