/* lda-desktop-entry-editor.c generated by valac, the Vala compiler
 * generated from lda-desktop-entry-editor.vala, do not modify */

/*
 * Desktop Agnostic Library: Desktop entry editor.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <libdesktop-agnostic/ui.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



gint _main (char** args, int args_length1);

static const GOptionEntry entries[] = {};


gint _main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	DesktopAgnosticVFSFile* file;
	DesktopAgnosticVFSFile* output;
	DesktopAgnosticUILauncherEditorDialog* editor;
	_inner_error_ = NULL;
	file = NULL;
	output = NULL;
	editor = NULL;
	if (args_length1 < 2) {
		g_critical ("lda-desktop-entry-editor.vala:39: Usage: %s FILE [OUTPUT FILE]", args[0]);
		result = 1;
		_g_object_unref0 (file);
		_g_object_unref0 (output);
		_g_object_unref0 (editor);
		return result;
	}
	{
		DesktopAgnosticVFSFile* _tmp0_;
		DesktopAgnosticVFSFile* _tmp1_;
		DesktopAgnosticUILauncherEditorDialog* _tmp4_;
		desktop_agnostic_vfs_init (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		gtk_init (&args_length1, &args);
		_tmp0_ = desktop_agnostic_vfs_file_new_for_path (args[1], &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		file = (_tmp1_ = _tmp0_, _g_object_unref0 (file), _tmp1_);
		if (args_length1 > 2) {
			DesktopAgnosticVFSFile* _tmp2_;
			DesktopAgnosticVFSFile* _tmp3_;
			_tmp2_ = desktop_agnostic_vfs_file_new_for_path (args[2], &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			output = (_tmp3_ = _tmp2_, _g_object_unref0 (output), _tmp3_);
		}
		editor = (_tmp4_ = g_object_ref_sink (desktop_agnostic_ui_launcher_editor_dialog_new (file, output, TRUE)), _g_object_unref0 (editor), _tmp4_);
		gtk_widget_show_all ((GtkWidget*) editor);
		gtk_main ();
		desktop_agnostic_vfs_shutdown (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("lda-desktop-entry-editor.vala:62: Error: %s", err->message);
			result = 1;
			_g_error_free0 (err);
			_g_object_unref0 (file);
			_g_object_unref0 (output);
			_g_object_unref0 (editor);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_object_unref0 (output);
		_g_object_unref0 (editor);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_object_unref0 (file);
	_g_object_unref0 (output);
	_g_object_unref0 (editor);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _main (argv, argc);
}




