/***************************************************************************
             ciconv-test.cpp  -  basic test for CIconv class
                             -------------------
    begin                : Thu Sep 11 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/**
 * CIconv is a new class introduced in 0.3.11 to handle character set
 * encoding. Previous versions did not handle encoding in dclib
 * (there was some for chat and filelists in valknut), and converted
 * ISO-8859-1 to UTF-8 for making XML.
 */

#include <dclib/core/cstring.h>
#include <dclib/core/ciconv.h>

#include <stdio.h>

#define TESTS 4;

int main( int, char*[] )
{
	int ret = 0;
	
	/* same string from case folding test */
	const unsigned char raw[26] = { 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x20, 0xC1, 0xC9, 0xCC, 0xD3, 0xD9, 0x20, 0xE1, 0xE9, 0xEC, 0xF3, 0xF9, 0x20, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x00 };
	
	CString somecp1252 = (const char*) raw;
	CString someutf8 = "ABCDEF ÁÉÌÓÙ áéìóù UVWXYZ";
	
	CIconv cp1252toutf8( "CP1252", "UTF-8" );
	CIconv utf8tocp1252( "UTF-8", "CP1252" );
	
	CString output = cp1252toutf8.encode( somecp1252 );
	if ( output != someutf8 )
	{
		printf("ciconv-test: failed CP1252 to UTF-8 1\n");
		printf("output='%s'\n",output.Data());
		ret = 1;
	}
	
	output = cp1252toutf8.encode( (const char*) raw );
	if ( output != someutf8 )
	{
		printf("ciconv-test: failed CP1252 to UTF-8 2\n");
		ret = 2;
	}
	
	output = utf8tocp1252.encode( someutf8 );
	if ( output != somecp1252 )
	{
		printf("ciconv-test: failed UTF-8 to CP1252 1\n");
		ret = 3;
	}
	
	output = utf8tocp1252.encode( someutf8.Data() );
	if ( output != somecp1252 )
	{
		printf("ciconv-test: failed UTF-8 to CP1252 2\n");
		ret = 4;
	}
	
	output = utf8tocp1252.encode( somecp1252 );
	if ( output != "ABCDEF _____ _____ UVWXYZ" )
	{
		printf("ciconv-test: failed invalid conversion test\n");
		ret = 5;
	}
	
	return ret;
}
