/***************************************************************************
                           casyncdns.h  -  description
                             -------------------
    begin                : Mon Jun 10 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CASYNCDNS_H
#define CASYNCDNS_H

/**
  *@author Mathias Kster
  */

#include <time.h>

#ifndef WIN32
#include <netinet/in.h>
#endif

#include <dclib/dcos.h>
#include <dclib/core/cstring.h>
#include <dclib/core/cobject.h>
#include <dclib/core/cthread.h>
#include <dclib/core/csingleton.h>

/** */
typedef enum eAsyncDns {
	eadSUCCESS,
	eadERROR,
	eadAGAIN
} eAsyncDns;

class DLL_EXPORT CAsyncDnsEntry : public CObject {
public:
	/** */
	CAsyncDnsEntry() {};
	/** */
	virtual ~CAsyncDnsEntry() {};

	/** */
	CString m_sHost;
	/** */
	bool m_bError;
	/** socket error code */
	int m_nError;
	/** query timeout */
	time_t m_tTimeout;
	/** */
	struct sockaddr_in m_sin;
};

class CStringList;
class CAsyncDns;

#ifdef WIN32
template class DLL_EXPORT CSingleton<CAsyncDns>;
#endif

class DLL_EXPORT CAsyncDns : public CSingleton<CAsyncDns>, public CThread {

public:
	/** */
	CAsyncDns();
	/** */
	virtual ~CAsyncDns();

	/** */
	eAsyncDns GetHostByName( CString stringHost, struct sockaddr_in * sin, int * numerr = 0 );

	/** */
	virtual void Thread( CObject * pObject );

private:
	/** */
	void UpdateEntry( CString stringHost );
	/** */
	CStringList * m_pHostCache;
	/** */
	CStringList * m_pHostList;
};

#endif
