/***************************************************************************
  dbinit.h  -  description
  -------------------
begin                : Wed Dec 19 2001
copyright            : (C) 2001 by Will DeRousse
email                : badhack@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DBINIT_H
#define DBINIT_H

#include "dbmusicglobals.h"
#include <libpq++.h>
#include <qstring.h>

/**
 * This class handles the connection to 'template1' to perform db functions like searching or creating a new database.
 *
 * Example:
 * <pre>
 * dbInit *init=new dbInit("template1");
 * init->find("music");
 * // if it finds it, open the db
 * delete init;
 * </pre>
 * @author Will DeRousse
 */

class dbInit : public PgDatabase  {
	public:
		/**  Constructor
		 *@param dbname (template1)
		 */
		dbInit(const QString &dbname);
		/**  Destructor
		 */
		~dbInit();
		/**
		 * Checks the connection to make sure the db didn't return a bad code.
		 */
		bool checkConnect();
		/** This function will create a database (as long as you are connected to template1).
		 * @param string Name of database to create.
		 */
		bool createDb( const QString &string);
		/** Returns the errorcode.
		 *@param string QString to be set to value of SELECT version()
		 */
		int dbVersion(QString &string);
		/** Use this function to search template1 for a particular database. Returns true if found, false otherwise.
		 *@param string dbname to search for
		 */
		bool findDb ( const QString &string);
		/**
		 * This function goes one step farther than checkConnect by sending data to the server first in an attempt to actually communicate with it. I added this function because I think it will add another layer of stability. In other words, some dummy data will get corrupted rather than some important data in the db.
		 */
		bool testConnect();
	protected: // Protected methods
		/**
		 * Use this function often to check the status of the server. The return value is the error code.
		 */
		int execCheck() const;
		ExecStatusType stat;
		QString sqlstring;
};

#endif
