/* 
 * $Id: ctkviewport.h,v 1.2 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKVIEWPORT_H__
#define __CTKVIEWPORT_H__

#include "ctkadjustment.h"

struct CtkViewport_S {
	CtkBin bin;
	
	CtkAdjustment *hadjustment;
	CtkAdjustment *vadjustment;
};

typedef struct CtkViewport_S CtkViewport;

void ctk_viewport_init(CtkViewport *viewport);

CtkWidget *ctk_viewport_new(CtkAdjustment *hadjustment,
			    CtkAdjustment *vadjustment);

#define CTK_VIEWPORT(obj)	CTK_CHECK_CAST((obj),CtkViewport,CtkTypeViewport)

#endif
