
--  Test availability of the Unchecked_Conversion between
--  Stream_Element_Array and String

with Ada.Unchecked_Conversion;
with Ada.Streams; use Ada.Streams;
with Ada.Text_IO;
with Ada.Command_Line;

procedure Uconv is

   Sample : constant String :=
      "$Author: obry $" & ASCII.LF &
      "$Date: 2005/12/17 16:39:46 $" & ASCII.LF &
      "$Name: release_2_2 $" & ASCII.LF &
      "$Locker:  $" & ASCII.LF &
      "$RCSfile: uconv.adb,v $" & ASCII.LF &
      "$Revision: 1.6 $" & ASCII.LF &
      "$Source: /anoncvs/AWS/workspace/uconv.adb,v $" & ASCII.LF &
      "$State: Exp $" & ASCII.LF;

   subtype Fixed_String is String (Sample'First .. Sample'Last);

   subtype Fixed_Array is Stream_Element_Array
     (Stream_Element_Offset (Sample'First)
      .. Stream_Element_Offset (Sample'Last));

   function To_Stream_Elements is
     new Ada.Unchecked_Conversion (Fixed_String, Fixed_Array);

   function To_String is
     new Ada.Unchecked_Conversion (Fixed_Array, Fixed_String);

begin
   if Fixed_Array'Size = Fixed_String'Size
   and then Fixed_Array'Alignment = Fixed_String'Alignment
   and then Sample = To_String (To_Stream_Elements (Sample)) then
      Ada.Text_IO.Put_Line ("Use fast.");
   else
      Ada.Text_IO.Put_Line ("Use portable.");
      declare
         use Ada.Command_Line;
      begin
         Set_Exit_Status (Failure);
      end;
   end if;
end Uconv;
