/* ======================================================================
 * Copyright (c) 1998-1999 The Johns Hopkins University.
 * All rights reserved.
 * The following code was written by Theo Schlossnagle for use in the
 * Backhand project at The Center for Networking and Distributed Systems
 * at The Johns Hopkins University.
 * Please refer to the LICENSE file before using this software.
 * ======================================================================
*/

#include "httpd.h"
#include "http_log.h"

#include "mod_backhand.h"

static char *lastarg = NULL;
static regex_t re_matching;

int byHostname(request_rec *r, ServerSlot *servers, int *n, char *arg) {
  int ret, i, mycount;
  if(!arg) return -1;
  if(!lastarg || strcmp(arg, lastarg)) {
    /* This will compile the regex only once per string of consecutive
       expressions */
    if ((ret = regcomp(&re_matching, arg, REG_EXTENDED))!=0) {
      char line[1024];
      ret = regerror(ret, &re_matching, line, sizeof line);
      ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_ERR, NULL,
		   "Internal error: regcomp(\"%s\") returned non-zero (%s) - "
		   "possibly due to broken regex lib! "
		   "Did you define WANTHSREGEX=yes?",
		   arg, line);
      return -1;
    }
    if(lastarg) free(lastarg);
    lastarg = strdup(arg);
  }
  mycount=0;
  for(i=0;i<*n;i++)
    if(!regexec(&re_matching, serverstats[servers[i].id].hostname, 0, NULL, 0))
      servers[mycount++] = servers[i];
  *n=mycount;
  return mycount;
}
