#!/usr/bin/perl

use strict;
use warnings;

# Wrapper function around the script db_get.sh
# We couldn't access debconf from inside the same script
# as debconf does not allow readonly (ie non-locking) access
# to its database, and we need to call debconf-set-selections
# further in the script.

sub db_get {
    my ($key) = @_;
    my $ret = `/usr/lib/localization-config/common/db_get.sh $key 2>&1 >/dev/null`;
    
    $ret =~ s/\n*$//;
    my @res;
    if ( $ret =~ /^\d\d / ) {
        $res[0] = 10;
    } else {
        $res[0] = 0;
        $res[1] = $ret;
    }
    return @res;
}

1;