/*
        linuxinfo_ppc.c

        Copyright (C) 1998-2000
        All Rights Reserved.

        Alex Buell <alex.buell@tahallah.demon.co.uk>

        Advanced Buell Software Engineering Ltd
        Hampshire, GU31 5DG
        United Kingdom

        Version Author  Date            Comments
        ----------------------------------------------------------------------
        1.0.0   AIB     199803??        Initial development
	1.0.1	AIB	20000405	Rewritten

        This is the PPC port of linuxinfo
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

#include "linuxinfo.h"

#ifdef system_ppc

void GetHardwareInfo(int fd, struct hw_stat *hw)
{
	LONGLONG memory = 0;
	int processors = 0; 
	int megahertz = 0;
	float tempbogo;

	char temp_string[BUFSIZ], temp_string2[BUFSIZ];
	char chip[BUFSIZ], vendor[BUFSIZ], model[BUFSIZ];

	struct stat st_buf;

	while (read_line(fd, temp_string, BUFSIZ) != 0)
	{
		splitstring(temp_string, temp_string2);

		if (!(strncmp(temp_string, "cpu", strlen("cpu"))) && (processors == 0))
			strcpy(chip, temp_string2);

		if (!(strncmp(temp_string, "model", strlen("model"))))
			strcpy(vendor, temp_string2);

		if (!(strncmp(temp_string, "machine", strlen("machine"))))
			strcpy(vendor, temp_string2);

		if (!(strncmp(temp_string, "clock", strlen("clock"))))
			megahertz = atoi(temp_string2);

		if (!(strncmp(temp_string, "bogomips", strlen("bogomips"))))
		{
			processors++;
			sscanf(temp_string2, "%f", &tempbogo);
		}
	}

	stat(MEMORY_FILE, &st_buf);
	memory = st_buf.st_size;
	memory /= 1024; memory /= 1024;
	sprintf(hw->hw_memory, "%ld", (long int)memory);

	hw->hw_processors = processors;

	if (megahertz > 0)
		sprintf(hw->hw_megahertz, "%d", megahertz);
	else
		strcpy(hw->hw_megahertz, "?");

	sprintf(hw->hw_cpuinfo, "%s %s", chip, vendor);
	sprintf(hw->hw_bogomips, "%0.2f", tempbogo * processors);
}
#endif /* system_ppc */
