#include <stdarg.h>
#include <stdio.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>
#include "internal.h"

/*
	Print an error message in a popup
	Stubs to avoid linking the world
*/
void xconf_error (const char *msg, ...)
{
	va_list list;
	va_start (list,msg);
	vfprintf (stderr,msg,list);
	va_end (list);
}


class TR_STRINGS_COMP{
public:
	TR_STRINGS ref;		// Reference dictionary
	TR_STRINGS trans;	// Translation
	/*~PROTOBEG~ TR_STRING_COMP */
	/*~PROTOEND~ TR_STRING_COMP */
};

int main (int _argc, char *_argv[])
{
	char *argv[200];
	int argc = anlparm (_argc,_argv,argv);
	int ret = -1;
	if (argc < 4){
		fprintf (stderr
			,"msgmove source-dic-file target-dic-file message-id ...\n"
			 "msgcopy source-dic-file target-dic-file message-id ...\n"
			 "\n"
			 "move (and delete) or just copy some messages from a source dic file\n"
			 "to another dic file\n");
	}else{
		bool move = strstr(argv[0],"move")!=NULL;
		TR_STRINGS src;
		if (src.read (argv[1])!=-1){
			TR_STRINGS dst;
			dst.read (argv[2]);	// We do not care about errors
			bool some_errors = false;
			for (int i=3; i<argc; i++){
				const char *msgid = argv[i];
				TR_STRING *t = src.getitem(msgid);
				if (t == NULL){
					fprintf (stderr,"*** Message %s not found\n",msgid);
					some_errors = true;
				}else if (dst.getitem(msgid)!=NULL){
					fprintf (stderr,"*** Message %s already exist in %s\n"
						,msgid,argv[2]);
					some_errors = true;
				}else{
					src.remove (t);
					dst.add (t);
					if (move){
						printf ("    Message %s moved\n",msgid);
					}else{
						printf ("    Message %s copied\n",msgid);
					}
				}
			}
			if (!some_errors){
				printf ("\n");
				if (dst.write (argv[2]) != -1){
					printf ("File %s was updated\n",argv[2]);
					if (move){
						if (src.write(argv[1]) != -1){
							printf ("File %s was updated\n",argv[1]);
							ret = 0;
						}
					}else{
						ret = 0;
					}
				}
			}else{
				fprintf (stderr,"\nThere were some error, no file were updated\n");
			}
		}
	}
	return ret;
}


