#!/bin/sh
# First we identify which distribution we are working on
OLDINSTALL=/usr/lib/linuxconf/help.eng/notices/01-oldinstall
GRABNOTICE=/usr/lib/linuxconf/help.eng/notices/02-grabinfo
INITTABREPLACE=/usr/lib/linuxconf/uninstall/inittab.replace

if [ -f /etc/rc.d/rc.boot ] ; then
	GRABINFO=/usr/lib/linuxconf/caldera/scripts/grabinfo.sh
	SETMODULES=/usr/lib/linuxconf/caldera/scripts/setmodules.sh
	CHECKDIST=caldera
	SPCCONF=conf.linuxconf-caldera
	RCSYSV=rcsysv-caldera
	RCINIT=rc.boot
	PATHRCINIT=/etc/rc.d/rc.boot
	PATHRC=/etc/rc.d/rc
elif [ -f /etc/verso-conectiva ] ; then
	SPCCONF=conf.linuxconf-conectiva
	GRABINFO=/usr/lib/linuxconf/conectiva/scripts/grabinfo.sh
	SETMODULES=/usr/lib/linuxconf/conectiva/scripts/setmodules.sh
	CHECKDIST=conectiva
	RCINIT=rc.sysinit
	PATHRCINIT=/etc/rc.d/rc.sysinit
	SYSVLINUXCONF=/usr/lib/linuxconf/conectiva/scripts
	RUNLEVELSPATH="/etc/rc.d/rc0.d /etc/rc.d/rc1.d /etc/rc.d/rc2.d /etc/rc.d/rc3.d /etc/rc.d/rc4.d /etc/rc.d/rc5.d /etc/rc.d/rc6.d"
	PATHINITD=/etc/rc.d/init.d
	CHKCONFIG=/sbin/chkconfig
elif [ -f /etc/rc.d/rc.sysinit ] ; then
	GRABINFO=/usr/lib/linuxconf/redhat/scripts/grabinfo.sh
	SETMODULES=/usr/lib/linuxconf/redhat/scripts/setmodules.sh
	CHECKDIST=redhat
	SPCCONF=conf.linuxconf-redhat-4.x
	ver=5.1
	if [ -f /etc/redhat-release ] ; then
		read a b c d e f </etc/redhat-release
		# Raw Hide is like 5.2
		if [ "$a" = "Raw" -a "$b" = "Hide" ] ; then
			ver=5.2
		elif [ "$b" = "Raw" -a "$c" = "Hide" ] ; then
			ver=5.2
		elif [ "$c" = "Raw" -a "$d" = "Hide" ] ; then
			ver=5.2
		elif [ "$d" = "Raw" -a "$e" = "Hide" ] ; then
			ver=5.2
		elif [ "$a" = "release" ] ; then
			ver=$b
		elif [ "$b" = "release" ] ; then
			ver=$c
		elif [ "$c" = "release" ] ; then
			ver=$d
		elif [ "$d" = "release" ] ; then
			ver=$e
		fi
	fi
	if [ "$ver" = "4.0" -o "$ver" = "4.1" -o "$ver" = "4.2" -o "$ver" = "5.0" ] ; then
		RCSYSV=rcsysv-redhat4.x
		RCINIT=rc.sysinit
		PATHRCINIT=/etc/rc.d/rc.sysinit
		PATHRC=/etc/rc.d/rc
		INITTAB=inittab.redhat-4.0
	else
		# Anything newer than 5.0 is linuxconf aware. No need
		# to replace the rc script and inittab
		RCINIT=rc.sysinit
		PATHRCINIT=/etc/rc.d/rc.sysinit
		SYSVLINUXCONF=/usr/lib/linuxconf/redhat/scripts
		RUNLEVELSPATH="/etc/rc.d/rc0.d /etc/rc.d/rc1.d /etc/rc.d/rc2.d /etc/rc.d/rc3.d /etc/rc.d/rc4.d /etc/rc.d/rc5.d /etc/rc.d/rc6.d"
		PATHINITD=/etc/rc.d/init.d
		CHKCONFIG=/sbin/chkconfig
	fi
elif [ -f /sbin/init.d/boot ] ; then
	SETMODULES=/usr/lib/linuxconf/suse/scripts/setmodules.sh
	CHECKDIST=suse
	SPCCONF=conf.linuxconf-suse

	if [ -f /etc/SuSE-release ]; then
		# we found a version >= 6.0
		RCSYSV=rcsysv-suse6.0
	else
		RCSYSV=rcsysv-suse5.x
	fi
	RCINIT=boot
	PATHRCINIT=/sbin/init.d/boot
	PATHRC=/sbin/init.d/rc
	USE_SED_ON_RCS=Y
fi
