#include <string.h>
#include "netconf.h"
#include <dialog.h>
#include "../paths.h"
#include "netconf.m"
#include "internal.h"

#ifdef TEST
	#undef ETC_NETWORKS
	#undef ETC_HOSTS
	#define ETC_HOSTS 		"/tmp/hosts"
	#define ETC_NETWORKS 	"/tmp/networks"
#endif

static NETCONF_HELP_FILE help_simple ("simple");

/*
	Check if there is not already some network configured.
	Return -1 if the installation can't be done.
*/
static int simple_check()
{
	int ret = -1;
	/* #todo: netconf / simple setup
		before doing a simple networking installation from
		scratch, we should check there is no valid configuration
		or at least do backup of the files which will be modified.
	*/
	char intro[1000];
	sprintf (intro,MSG_U(I_SIMPLEINST
		,"This option allows you to install\n"
		 "a complete network setup, including the names\n"
		 "of all machine.\n"
		 "\n"
		 "This will overwrite the following files:\n"
		 "      %s\n"
		 "      %s\n")
		,ETC_HOSTS,ETC_NETWORKS);
	if (dialog_yesno(MSG_U(Q_SIMPLEINST,"Installing network from scratch")
		,intro
		,help_simple)==MENU_YES){
		ret = 0;
	}
	return ret;
}
/* #Specification: netconf / simple setup / preselected host name
	When configuring a Linux workstation using the simple
	predefined network setup, all the name in the class C
	network are predefined. I have tried to use funny
	politically correct name :-)

	Also, each host has an alias which is simply its network
	node number with the "linux-" prefix. For example, the
	machine "orange" with IP number 192.168.1.5 has the
	alias "linux-5".

	The number 192.168.1 is an official number that will never
	be routed on the internet. So it is safe to use it even if you
	get hook to the internet one day. Off course, you local network
	won't be visible from the internet, but at least no internet
	site will clash with one of your local machine.
*/
/* #Specification: netconf / simple setup / preselected server
	The IP number 192.168.1.1 is allocated to the machine linux-serv.

	If one machine of the network is more important that others
	(supports printer, or NFS volume, or NIS, it is a good
	idea to use this IP and use "linux-serv" all around your
	net to refer to this server.	
*/
/* #Specification: netconf / simple setup / out of gas
	I was not able to produce 253 different funny/simple host
	name. Anyway a simple network with 200 or more machine
	in it, is not a simple network.
*/
// Let see if I do have some culture. The goal is to setup
// 253 funny names. I will start with fruits and vegetable
// and see how far I can go... For the record, I am french
// speaking.
// The names must be short and easy to type
static int nbname;
static const char **tb;
/*
	Select the name of your machine from a list
*/
static int simple_select ()
{
	// Because of a restriction with the translation system, _tb[]
	// which should be declared outside of this function is declared
	// here as _tb and tb is declared as a pointer.
	static const char *_tb[]={
		MSG_U(DUMMY_NAME_SERV,"linux-serv"),
		// Fruits section
		MSG_U(DUMMY_NAME_BANANA,"banana"),
		MSG_U(DUMMY_NAME_APPLE,"apple"),
		MSG_U(DUMMY_NAME_CHERRY,"cherry"),
		MSG_U(DUMMY_NAME_ORANGE,"orange"),
		// Animals section
		MSG_U(DUMMY_NAME_WOLF,"wolf"),
		MSG_U(DUMMY_NAME_LION,"lion"),
		MSG_U(DUMMY_NAME_MOUSE,"mouse"),
		MSG_U(DUMMY_NAME_EAGLE,"eagle"),
		MSG_U(DUMMY_NAME_COBRA,"cobra"),
		// Known persons (real or not) section
		MSG_U(DUMMY_NAME_ELVIS,"elvis"),
		MSG_U(DUMMY_NAME_BABE,"babe"),
		MSG_U(DUMMY_NAME_ALNOLD,"arnold"),
		MSG_U(DUMMY_NAME_ROCKY,"rocky"),
		MSG_U(DUMMY_NAME_BOND,"bond"),
		MSG_U(DUMMY_NAME_RINGO,"ringo"),
		MSG_U(DUMMY_NAME_PAUL,"paul"),
		MSG_U(DUMMY_NAME_JOHN,"john"),
		MSG_U(DUMMY_NAME_GEORGE,"george"),
		MSG_U(DUMMY_NAME_MADONA,"madona"),
		MSG_U(DUMMY_NAME_TARZAN,"tarzan"),
		MSG_U(DUMMY_NAME_LINUS,"linus"),
		// Some countries
		MSG_U(DUMMY_NAME_CANADA,"canada"),
		MSG_U(DUMMY_NAME_USA,"usa"),
		MSG_U(DUMMY_NAME_FINLAND,"finland"),
		MSG_U(DUMMY_NAME_FRANCE,"france"),
	};
	tb = _tb;
	nbname = sizeof(_tb)/sizeof(_tb[0]);
	DIALOG_LISTE dia;
	for (int i=0; i<nbname; i++){
		dia.new_menuitem ("",tb[i]);
	}
	int choice=0;
	MENU_STATUS code = dia.editmenu (MSG_U(T_YOURMACHINE,"Your machine name")
		,MSG_U(I_YOURMACHINE,"You must select a name for your machine\n"
		 "out of this list. Each of your co-networker\n"
		 "must select a different name\n")
		,help_simple
		,choice,0);
	if (code == MENU_ESCAPE || code == MENU_QUIT){
		choice = -1;
	}
	return choice;
}

static int simple_setup()
{
	int loghost = simple_select ();
	int ret = -1;
	if (loghost != -1){
		HOSTS hosts;
		NETWORKS networks;
		hosts.remove_all();
		networks.remove_all();
		for (int i=0; i<nbname; i++){
			char buf[100];
			sprintf (buf,"192.168.1.%d %s linux-%d",i+1,tb[i],i+1);
			if (i == loghost) strcat (buf," loghost");
			hosts.add (buf);
		}
		networks.add ("eth0_network 192.168.1.0");
		hosts.write ();
		networks.write ();
		ret = 0;
	}
	return ret;
}
void simple_install()
{
	/* #Spcification: netconf / install a simple network
		netconf can install a simple tcp/ip from scratch. After
		informing the user properly, it proceed and create all
		the entries for a class C network. After that, the user
		only select the name of his machine out of a predefined
		list.
	*/
	if (simple_check()!=-1
		&& simple_setup()!=-1){
	}	
}

#ifdef TEST

int main (int argc, char *argv[])
{
	init_dialog();
	simple_install();
	endwin();
	return 0;
}

#endif

