#pragma implementation
#include <limits.h>
#include <signal.h>
#include "daemoni.h"
#include "netconf.m"
#include <userconf.h>
#include "netconf.h"
#include <string.h>


PUBLIC DAEMON_INTERNAL::DAEMON_INTERNAL ()
{
	next = NULL;
	managed = override = 0;
}
/*
	Information on how to manage and start a daemon (generally network)
*/
PUBLIC void DAEMON_INTERNAL::init (
	int _managed,
	const char *_name,
	const char *buf,
	DAEMON_INTERNAL *_next)
{
	next = _next;
	managed = (char)_managed;
	char tmp[PATH_MAX];
	char *pttmp = tmp;
	while (*buf > ' ') *pttmp++ = *buf++;
	*pttmp = '\0';
	if (pttmp > tmp){
		name.setfrom (_name);
		cmd.path.setfrom (tmp);
		buf = str_skip(buf);
		setargs (buf);
	}
}

/*
	Record the arguments used to start the process/daemon
*/
PUBLIC void DAEMON_INTERNAL::setargs(const char *args)
{
	cmd.args.setfrom (args);
}

/*
	Return != 0 if this is a valid record.
*/
PUBLIC int DAEMON_INTERNAL::isok()
{
	return !name.is_empty();
}

/*
	Record the config file which holds the PID of the running server
*/
PUBLIC void DAEMON_INTERNAL::setpidfile (CONFIG_FILE *_pidfile)
{
	cmd.pidfile = _pidfile;
}

/*
	Return the next daemon in the link list or NULL.
*/
PUBLIC DAEMON_INTERNAL *DAEMON_INTERNAL::getnext()
{
	return next;
}
/*
	Return the path of a command or daemon.
*/
PUBLIC const char *DAEMON_INTERNAL::getpath()
{
	return cmd.path.is_empty() ? name.get() : cmd.path.get();
}

/*
	Execute a command using the shell with loging in /tmp/netconf.log
	The name of the command is used to located more info in /etc/conf.daemons.

	The command is conditionally executed if netconf is allowed to
	managed this command.
*/
EXPORT int netconf_system_if (
	const char *name,
	const char *args,
	int timeout)		// Timeout in seconds or -1 to use the default
{
	int ret = -1;
	if (simul_ishint())return 0;
	DAEMON_INTERNAL *dae = daemon_find (name);
	if (dae != NULL){
		ret = 0;
		char buf[PATH_MAX+strlen(args)+1];
		sprintf (buf,"%s %s",dae->getpath(),args);
		if (dae->is_managed()){
			if (dae->checkpath()!=-1){
				if (timeout == -1) timeout = dae->gettimeout();
				ret = netconf_system(timeout,buf);
			}else{
				ret = -1;
			}
		}else if (!simul_ison()){
			net_prtlog (NETLOG_VERB,MSG_U(X_WOULDEXEC,"Would have executed \"%s\" but not allowed\n"),buf);
		}
	}
	return ret;
}

EXPORT int netconf_system_if (const char *name, const char *args)
{
	return netconf_system_if (name,args,-1);
}

/*
	Record the recommend maximum activation time for a command.
	If the command takes more than this time, linuxconf will popup
	a dialog allowing the user to terminate the command
*/
PUBLIC void DAEMON_INTERNAL::settimeout(int nbsec)
{
	cmd.timeout = nbsec;
}
PUBLIC int DAEMON_INTERNAL::gettimeout()
{
	return cmd.timeout;
}

/*
	Set the specs of the daemon
*/
PUBLIC void DAEMON_INTERNAL::setspec(const char *_path, const char *_args)
{
	cmd.path.setfrom (_path);
	cmd.args.setfrom (_args);
}

/*
	Check if the path for a program is valid
	Return -1 if not.
	Signal an error and let the user fix the problem if this is the first
	time the error is signaled.
*/
PUBLIC int DAEMON_INTERNAL::checkpath()
{
	if (!cmd.path_checked){
		while (is_managed()){
			bool config_needed;
			if (cmd.checkpath(config_needed)==0){
				break;
			}else if (config_needed){
				if (perm_checkpass()){
					if (daemon_configone (name.get())==-1) break;
				}
			}else{
				break;
			}
		}
	}
	return cmd.path_ok ? 0 : -1;
}

/*
	Stop a daemon if it is running with a given signal number.
	Return -1 if any error, -2 if no process alive, 0 if signal sent
*/
PUBLIC int DAEMON_INTERNAL::signal(
	int signal_num,
	const char *msg)
{
	return cmd.signal(signal_num,msg,NULL);
}

/*
	Stop a daemon if it is running with a given signal number.
	Return -1 if any error, -2 if no process alive, 0 if signal sent
*/
PUBLIC int DAEMON_INTERNAL::signal(
	int signal_num,
	const char *msg,
	const char *sem_file)
{
	return cmd.signal(signal_num,msg,sem_file);
}

/*
	Stop a daemon if it is running.

	The default is to use signal SIGTERM. This function is virtual.
	Return -1 if any error.
*/
PUBLIC int DAEMON_INTERNAL::stop()
{
	return cmd.kill (SIGTERM);
}

/*
	Locate the running process associated with this command
*/
PUBLIC PROC *DAEMON_INTERNAL::findprocess(bool &problem)
{
	problem = false;
	return cmd.findprocess();
}

/*
	start the daemon without much questionning.
	Return -1 if any error.
*/
PUBLIC int DAEMON_INTERNAL::start()
{
	int ret = -1;
	if (checkpath()==0) ret = cmd.system ();
	return ret;
}

/*
	Return the standard args of a command or daemon.
*/
PUBLIC const char *DAEMON_INTERNAL::getargs()
{
	return cmd.args.get();
}


/*
	Return != 0 if the daemon or command is managed by netconf.
	The user may choose to manage some deamon with his own script.
*/
PUBLIC int DAEMON_INTERNAL::is_managed()
{
	return managed;
}
/*
	Return != 0 if the daemon or command has been modified by the admin
	(either the path of the command or the arguments)
*/
PUBLIC int DAEMON_INTERNAL::is_overriden()
{
	return override;
}

/*
	Set the managed flag.
*/
PUBLIC void DAEMON_INTERNAL::set_managed(int _managed)
{
	managed = (char)_managed;
}
/*
	Set the override flag.
*/
PUBLIC void DAEMON_INTERNAL::set_override(int _over)
{
	override = (char)_over;
}

