#pragma implementation
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <limits.h>
#include "daemoni.h"
#include "netconf.m"
#include "internal.h"
#include "netconf.h"
#include <dialog.h>

static NETCONF_HELP_FILE help_missing ("missing");


PRIVATE void COMMAND::init(const char *line)
{
	line = path.copyword(line);
	line = str_skip(line);
	args.setfrom (line);
	timeout = 15;
	pidfile = NULL;
	path_checked = 0;
	path_ok = 0;
}

PUBLIC COMMAND::COMMAND()
{
	init("");
}

PUBLIC COMMAND::COMMAND(const char *line)
{
	init(line);
}
PUBLIC void COMMAND::reinit(const SSTRING &line)
{
	init(line.get());
}

/*
	Check if the path for a program is valid
	Return -1 if not.
	Signal an error and let the user fix the problem if this is the first
	time the error is signaled.
*/
PUBLIC int COMMAND::checkpath(bool &config_needed)
{
	if (simul_ishint()) return 0;
	config_needed = false;
	if (!path_checked){
		path_checked = 1;
		path_ok = 0;
		struct stat st;
		if (stat(path.get(),&st)!=-1 && (st.st_mode & S_IXUSR)){
			path_ok = 1;
		}else{
			char buf[1000];
			sprintf (buf,MSG_U(I_MISSCMPN
				,"Linuxconf can't locate the command %s\n"
				 "on your system.\n"
				 "\n"
				 "The command is either missing (not installed)\n"
				 "or installed with a different name or path\n"
				 "\n"
				 "Do you want to change the configuration for this command ?")
				,path.get());
			if (dialog_yesno (MSG_U(Q_MISSCMPN,"Missing component ?")
				,buf,help_missing)==MENU_YES){
				config_needed = true;
				path_checked = 0;	// So we will check
							// again next time
			}else if (!simul_ison()){
				net_prtlog (NETLOG_ERR
					,MSG_U(E_CMDMISS
						,"Command %s missing\n")
					,path.get());
			}
		}
	}
	return path_ok ? 0 : -1;
}

/*
	Execute a command using the shell.
	Return 0 if ok, != 0 if any error.

	This function is there to allows extension such as loging, debugging
	etc.
*/
PUBLIC int COMMAND::system(const char *cmd)
{
	bool config_needed;
	int ret = checkpath(config_needed);
	if (ret != -1){
		ret = netconf_system (timeout,cmd);
	}
	return ret;
}

/*
	Execute a command using the shell.
	Return 0 if ok, != 0 if any error.

	This function is there to allows extension such as loging, debugging
	etc.
*/
PUBLIC int COMMAND::system()
{
	char buf[2000];
	sprintf (buf,"%s %s",path.get(),args.get());
	return system (buf);
}

/*
	Locate the running process associated with this command
*/
PUBLIC PROC *COMMAND::findprocess()
{
	return process_find (path.get(),pidfile);
}

/*
	Stop a daemon if it is running with a given signal number.
	Return -1 if any error, -2 if no process alive, 0 if signal sent
*/
PUBLIC int COMMAND::signal(
	int signal_num,
	const char *msg,
	const char *sem_file)	// File used to remember when we
							// did issued the last signal
							// Or NULL if we don't care
{
	int ret = -2;
	PROC *prc = findprocess ();
	if (prc != NULL){
		if (simul_ison()){
			ret = 0;
		}else{
			ret = prc->kill (signal_num);
			if (sem_file != NULL){
				int fd = creat (sem_file,0666);
				if (fd != -1) close (fd);
			}
		}
		net_prtlog (NETLOG_CMD
			,MSG_U(X_SIGNALING,"%s %s with signal %d return %d\n")
			,msg,path.get(),signal_num,ret);
	}
	return ret;
}

/*
	Stop a daemon if it is running with a given signal number.
	Return -1 if any error.
*/
PUBLIC int COMMAND::kill(int signal_num)
{
	int ret = 0;
	for (int i=1; i<=3; i++){
		if (findprocess()==NULL){
			break;
		}else if (i==1){
			ret = signal (signal_num,MSG_U(I_KILLING,"Killing"),NULL);
			if (ret == -2 || simul_ison()) break;
		}
		sleep(i);
		process_read();
	}
	return ret;
}

