/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include <usercomng.h>
#include "wuftpd.h"
#include "wuftpd.m"

MODULE_DEFINE_VERSION(wuftpd);

PUBLIC MODULE_wuftpd::MODULE_wuftpd()
	: LINUXCONF_MODULE ("wuftpd")
{
	linuxconf_loadmsg ("wuftpd",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_wuftpd::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_wuftpd,"Ftp server (wu-ftpd)");
		dia.new_menuitem ("wuftpd","",keymenu);
	}
}

PUBLIC int MODULE_wuftpd::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
			wuftpd_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_wuftpd::dohtml (const char *)
{
	int ret = LNCF_NOT_APPLICABLE;
	#if 0
		if (strcmp(key,"wuftpd")==0){
			wuftpd_edit();
			ret = 0;
		}
	#endif
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module wuftpd\n"
		 "linuxconf --modulemain wuftpd [ specific options ]\n"
		 "\n"
		 "    --help\n"
		 "    --addvhost vhost --root path\n"
		 "    --delvhost vhost\n"
		 "\n"
		 "    without argument, enter the module main menu\n"
		 "\n")
		);
}

PUBLIC void MODULE_wuftpd::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_wuftpd::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"wuftpd")==0){
		ret = -1;
		if (netconf_rootaccess()){
			if (argc == 1){
				wuftpd_edit();
				ret = 0;
			}else if (argc == 2 && strcmp(argv[1],"--help")==0){
				::usage();
			}else if (argc == 3 && strcmp(argv[1],"--delvhost")==0){
				wuftpd_del (argv[2]);
			}else if (argc > 2){
				if (strcmp(argv[1],"--addvhost")==0){
					wuftpd_add (argv[2],argc-3,(const char **)(argv+3));
				}else{
					::usage();
				}
			}else{
				::usage();
			}
		}
	}
	return ret;
}


static MODULE_wuftpd wuftpd;

