
/*
 routines used in several parts of wineconf module
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
// #include "wineconf.h"
// #include "wineconf.m"
#include <fviews.h>

#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>

#include "wineconf_global_defs.h"

int load_var_data(const char *groupname, const char *varname, VIEWITEMS &given_vitems, SSTRING &write_here, const char *what_if_empty);
int load_var_data(const char *groupname, const char *varname, VIEWITEMS &given_vitems, SSTRING &write_here);
int return_line_of_first_occurence_lowerlevel(const char *seeken_prefix, VIEWITEMS &given_vitems, const int from_this_line, const int to_this_line, const int locate_var);


/* creates a 'boolean' gadget for Y, N or \0 */
void create_triple_boolean_gadget(DIALOG &given_dialog, FIELD_LIST **given_field_list, const char *given_fieldname, SSTRING &given_sstring)
{
    *given_field_list=given_dialog.newf_list(given_fieldname, given_sstring);
    (*given_field_list)->addopt("", MSG_U(X_USEDEFAULT, "(use default)"), "");
    (*given_field_list)->addopt("Y", MSG_U(X_YES, "Yes"), "");
    (*given_field_list)->addopt("N", MSG_U(X_NO, "No"), "");
}


/* processed the given data returning Y, N or '\0' */
/*void load_boolean_sstring(const char *where_to_read_from, SSTRING &where_to_write)
{
    char tempbuf[2];
    char given_char;

    tempbuf[1]=0;
    if(where_to_read_from){
        given_char=*where_to_read_from;
        switch(given_char){
        case 'Y':
        case 'y':
        case 'T':
        case 't':
        case '1':
            tempbuf[0]='Y';
            break;
        case 'N':
        case 'n':
        case 'F':
        case 'f':
        case '0':
            tempbuf[0]='N';
            break;
        default:
            tempbuf[0]=0;
        }
    } else {
        tempbuf[0]=0;
    }

    where_to_write.setfrom(tempbuf);
}
*/

void load_boolean_to_sstring(const char *groupname, const char *varname, VIEWITEMS &given_vitems, SSTRING &write_here)
{
    SSTRING tempy;

    load_var_data(groupname, varname, given_vitems, tempy);
    tempy.to_upper();

    write_here.setfrom("");
    if(strchr(tempy.get(), 'Y'))
        write_here.setfrom("Y");
    if(strchr(tempy.get(), 'N'))
        write_here.setfrom("N");
}

/* convert given string to higher case, return the same given pointer */
/* applies only to ascii a-z */
char *convert_string_to_highercase(char *given_string)
{
    char *my_counter;
    char my_data;

    my_counter=given_string;
    while((my_data=*my_counter)){
        if((my_data>96)&&(my_data<123))
            *my_counter=my_data-32;
        my_counter++;
    }
    return(given_string);
}

/* convert given string to lowercase, return the same given pointer */
/* applies only to ascii A-Z */
char *convert_string_to_lowercase(char *given_string)
{
    char *my_counter;
    char my_data;

    my_counter=given_string;
    while((my_data=*my_counter)){
        if((my_data>64)&&(my_data<91))
            *my_counter=my_data+32;
        my_counter++;
    }
    return(given_string);
}

/* returns line number of first occurence of the given prefix in a line,
 given the delimiters, including the lines they point to.
 (they also can be defined to the first and last
 lines so it'll seek the whole file) */
/* will return -1 if not found (0 is the first line) */
/* if locate_var==TRUE makes sure the provided prefix is the whole var name,
   otherwise if just a normal prefix search */
int return_line_of_first_occurence(const char *seeken_prefix, VIEWITEMS &given_vitems, const int from_this_line, const int to_this_line, const int locate_var)
{
    int returned_code;
    SSTRING quoted_prefix;

    /* this routine will call return_line_of_first_occurence_lowerlevel()
     twice: once querying for prefix,
            then (if prefix not found and locate_var!=0) querying
            for prefix between quotes */

    returned_code=return_line_of_first_occurence_lowerlevel(seeken_prefix, given_vitems, from_this_line, to_this_line, locate_var);
    if((returned_code!=-1)||(!locate_var)){
        return(returned_code);
    }

    /* look for quoted prefix (a var name) */
    quoted_prefix.setfromf("\"%s\"", seeken_prefix);
    return(return_line_of_first_occurence_lowerlevel(quoted_prefix.get(), given_vitems, from_this_line, to_this_line, locate_var));
}

/* used by return_line_of_first_occurence() _only_ */
int return_line_of_first_occurence_lowerlevel(const char *seeken_prefix, VIEWITEMS &given_vitems, const int from_this_line, const int to_this_line, const int locate_var)
{
    VIEWITEM *specific_item;
    int where_i_am;
    int size_of_given_prefix;
    int value_to_return=-1;

    where_i_am=from_this_line;
    size_of_given_prefix=strlen(seeken_prefix);

    while(where_i_am<(to_this_line+1)){
        char seeken_prefix2[size_of_given_prefix+1];
        char readen_prefix[size_of_given_prefix+2]; // + next char + \0
        int  size_for_copied_line; // the readen line is not fully copied

        specific_item=given_vitems.getitem(where_i_am);

        /* converts both to lower case */
        size_for_copied_line=strlen(specific_item->line.get());
        if(size_for_copied_line>size_of_given_prefix)
            size_for_copied_line=size_of_given_prefix+1;
        strcpy(seeken_prefix2, seeken_prefix);
        strncpy(readen_prefix, specific_item->line.get(), size_for_copied_line);
        convert_string_to_lowercase(seeken_prefix2);
        convert_string_to_lowercase(readen_prefix);

//        if(!(strncmp(specific_item->line.get(), seeken_prefix, size_of_given_prefix))){
        if(!(strncmp(readen_prefix, seeken_prefix2, size_of_given_prefix))){
            if(!locate_var){
                // normal prefix search
                value_to_return=where_i_am;
                where_i_am=to_this_line; /* so it'll exit the loop */
            } else {
                // search a variable, let's make some more tests..
                if(size_for_copied_line>=size_of_given_prefix){
                    if(size_for_copied_line==size_of_given_prefix){
                        value_to_return=where_i_am;
                        where_i_am=to_this_line; /* so it'll exit the loop */
                    } else {
                        char pseudo_last_char;

                        pseudo_last_char=*(readen_prefix+size_of_given_prefix);
                        if((pseudo_last_char==' ')||(pseudo_last_char=='=')){
                            value_to_return=where_i_am;
                            where_i_am=to_this_line; /* so it'll exit the loop */
                        }
                    }
                }
            }
        }
        where_i_am++;
    }

    return(value_to_return);
}


/* fill those two variables with the lines where the group is contained
 (both lines pointed are also part of this group, its_first_line returns
 the group identificator tag) */
/* returns TRUE if ok, FALSE if group not found */
int locate_group_limits(const char *groupname, int *its_first_line, int *its_last_line, VIEWITEMS &given_vitems)
{
    int total_items;
    char *my_buff; // groupname plus brackets []
    int group_begins_at=0;
    int group_ends_at=0;

    if((my_buff=(char *)malloc(strlen(groupname)+3))){
        sprintf(my_buff, "[%s]", groupname);
        total_items=given_vitems.getnb();

        group_begins_at=return_line_of_first_occurence(my_buff, given_vitems, 0, total_items-1, 0);
        if(group_begins_at==-1) // oh, group not found
            return(0);

        if(group_begins_at==(total_items-1)){
            group_ends_at=group_begins_at;
        } else {
            group_ends_at=(return_line_of_first_occurence("[", given_vitems, group_begins_at+1, total_items-1, 0)-1);
            if(group_ends_at==-2)
                group_ends_at=total_items-1;
        }

        free(my_buff);
    }

    *its_first_line=group_begins_at;
    *its_last_line=group_ends_at;
    return(1); // ok, things were fine
}

/* return data from a variable from a group */
/* returns null if variable/group not found */
/* NOTE: look at /etc/wine.conf structure to understand wine's concept of
   group on its config file */
/* you usually will NOT to use this function but load_var_data() (higher level)
   as this one does not filter the surrounding quotes */
const char *return_var_data_location(const char *groupname, const char *varname, VIEWITEMS &given_vitems)
{
    int group_begins_here;
    int group_ends_here;
    int where_is_that_var;
    VIEWITEM *my_viewitem;
    const char *return_this_data;

    if(!locate_group_limits(groupname, &group_begins_here, &group_ends_here, given_vitems))
        return(NULL);  // group not present
    where_is_that_var=return_line_of_first_occurence(varname, given_vitems, group_begins_here, group_ends_here, 1);
    if(where_is_that_var==-1)
        return(NULL);  // group present but the variable isn't
    my_viewitem=given_vitems.getitem(where_is_that_var);
    return_this_data=my_viewitem->line.get();

    /* get the first data character (after varname and '=') */
    if(!(return_this_data=strchr(return_this_data, '=')))
    {
        // '=' not found, returns empty string
        return_this_data+=strlen(return_this_data);
        return(return_this_data);
    }
    return_this_data++;
    while((*return_this_data)&&(*return_this_data<33)){
        return_this_data++;
    }
    return(return_this_data);
}

/* loads data from a variable from a group to a specified variable (SSTRING) */
/* returns zero if variable/group not found */
/* NOTE: look at /etc/wine.conf structure to understand wine's concept of
   group on its config file */
int load_var_data(const char *groupname, const char *varname, VIEWITEMS &given_vitems, SSTRING &write_here, const char *what_if_empty)
{
    const char *returned_data;

    if((returned_data=return_var_data_location(groupname, varname, given_vitems))){
        if(*returned_data!='\"'){
            write_here.setfrom(returned_data);
        }else{ // oh, quotes detected.. let's wipe them out
            int how_long;

            write_here.setfrom(returned_data+1);
            if((how_long=strlen(write_here.get())))
                write_here.truncate(how_long-1);
        }
        // converts '\\' to single reversed-slash
        {
            SSTRING tempy;
            const char *read_from;
            char current_char[2];

            read_from=write_here.get();
            current_char[1]='\0';
            while((current_char[0]=*read_from)){
                if((current_char[0]=='\\')&&(*(read_from+1)=='\\'))
                    read_from++;
                tempy.append(current_char);
                read_from++;
            }
            write_here.setfrom(tempy);
        }
        return(1);
    }

    write_here.setfrom(what_if_empty);
    return(0);
}

/* same as load_var_data() above but puts a empty strings if the var wasn't found */
int load_var_data(const char *groupname, const char *varname, VIEWITEMS &given_vitems, SSTRING &write_here)
{
    return(load_var_data(groupname, varname, given_vitems, write_here, ""));
}

void insert_a_line_at(int where_to_insert, const char *given_data, VIEWITEMS &given_vitems)
{
    VIEWITEM *temporary_line=new VIEWITEM(given_data,VIEWITEM_VARIABLE);

    temporary_line->line.setfrom(given_data);
    //temporary_line->type = VIEWITEM_VARIABLE;
    if(where_to_insert>=given_vitems.getnb()){
        given_vitems.add(temporary_line);
    } else {
        given_vitems.insert(where_to_insert, temporary_line);
    }
    //xconf_notice("%x",given_vitems.getitem(0));
//    given_vitems.insert(where_to_insert,temporary_line);
}

/* update/create variable given group and varname (creates group and/or variable if needed) */
/* if remove_if_empty==TRUE removes the variable if its value is "" */
void write_var_data(const char *groupname, const char *varname, const char *given_data, VIEWITEMS &given_vitems, int remove_if_empty)
{
    int where_is_that_var;
    int group_begins_here;
    int group_ends_here;
    int total_items;

    total_items=given_vitems.getnb();

    if(!locate_group_limits(groupname, &group_begins_here, &group_ends_here, given_vitems)){
        // group not found
        {
            char *corrected_groupname;
            if((corrected_groupname=(char *)malloc(strlen(groupname)+3))){
                strcpy(corrected_groupname, "[");
                strcat(corrected_groupname, groupname);
                strcat(corrected_groupname, "]");
                insert_a_line_at(total_items, corrected_groupname, given_vitems);
                free(corrected_groupname);
            }
        }
//        insert_a_line_at(total_items, groupname, given_vitems);
        locate_group_limits(groupname, &group_begins_here, &group_ends_here, given_vitems);
    }

    where_is_that_var=return_line_of_first_occurence(varname, given_vitems, group_begins_here, group_ends_here, 1);
    if(where_is_that_var==-1){
        // var not found
        insert_a_line_at(group_begins_here+1, varname, given_vitems);
        where_is_that_var=group_begins_here+1;
    }

    {
        VIEWITEM *my_viewitem;


        if(remove_if_empty&&(!*given_data)){
            given_vitems.remove_del(where_is_that_var);
        } else {
            // convert single reversed-slash to '\\'
            SSTRING adjusted_given_data;
            {
                const char *read_from;
                char current_char[2];

                read_from=given_data;
                current_char[1]='\0';
                while((current_char[0]=*read_from)){
                    if(current_char[0]=='\\'){
                        adjusted_given_data.append("\\\\");
                    }else{
                        adjusted_given_data.append(current_char);
                    }
                    read_from++;
                }
            }

            my_viewitem=given_vitems.getitem(where_is_that_var);
            my_viewitem->line.setfromf("\"%s\" = \"%s\"", varname, adjusted_given_data.get());
        }
    }
}

void strgname(SSTRING &givenstr)
{
    if(!(strcmp(givenstr.get(), "wineconfcredits"))){
        int nothing=0;
        DIALOG uhoh_dialog;
        uhoh_dialog.editmenu("lame easter egg", "this module was created by\nDaniel Mealha Cabrita\n(dancab@conectiva.com)\nAugust, 2000", help_nil, nothing, 0);
    }
    if(!(strcmp(givenstr.get(), "wineconfcredits2"))){
        int nothing=0;
        DIALOG uhoh_dialog;
        uhoh_dialog.editmenu("more easter egg", "btw who said brazilians do nothing? ;)\n\nja zrobe, i dobrze, ale zle mi placa tu w KOHEKTIBE.\n", help_nil, nothing, 0);
    }

}

/* puts the first value from the provided 'array' to variable
 if the value is present in this array (see win95/vfat case
 of /etc/wine.conf file */
/* example: "fat\0msdos\0dos\0\0vfat\0win95\0\0\0" */
void adjust_multialiased_string(SSTRING &string_to_adjust, char * array_of_aliases)
{
    const char *provided_string;
    const char *array_reader;
    const char *first_of_group;

    provided_string=string_to_adjust.get();
    array_reader=array_of_aliases;

    while(*array_reader){
        first_of_group=array_reader;
        while(*array_reader){
            if(!(strcmp(array_reader, provided_string)))
                string_to_adjust.setfrom(first_of_group);
            array_reader=strchr(array_reader, 0)+1;
//            array_reader+=strlen(array_reader)+1;
        }
        array_reader++;
    }
}

/* remove an entire group from file (used in drives management section) */
void remove_group(char *given_groupname, VIEWITEMS &given_vitems)
{
    int its_first_line=0;
    int its_last_line=0;
    int my_counter=0;

    if(locate_group_limits(given_groupname, &its_first_line, &its_last_line, given_vitems)){
        my_counter=its_last_line;

        while(my_counter>=its_first_line){
            given_vitems.remove_del(my_counter--);
        }
    }
}



/* return all usernames and their home directories.
   return the number of entries or 0 if none */
/* note: usernames and homedirs are not automatically cleaned */
int return_userlist_homedir(SSTRINGS &usernames, SSTRINGS &homedirs)
{
    int my_counter=0;
    struct passwd *my_user;

    setpwent();
    while((my_user=getpwent())){
        usernames.add(new SSTRING(my_user->pw_name));
        homedirs.add(new SSTRING(my_user->pw_dir));
        my_counter++;
    }
    endpwent();

    return(my_counter);
}

/* the label says all.. */
void dump_sstrings_to_fieldlist(SSTRINGS &given_sstrings, FIELD_LIST *dump_here)
{
    int my_counter=0;
    int total_to_go;

    total_to_go=given_sstrings.getnb();
    while(total_to_go--)
        dump_here->addopt(given_sstrings.getitem(my_counter++)->get());
}

/* here the label says all too.. */
/* returns 0 if ok, !=0 if some error happened */
int copy_configfile_into_another(CONFIG_FILE &read_from, CONFIG_FILE &write_to)
{
    FILE_CFG *my_file, *my_file2;
    int myfilesize;
    char *my_buff;
    int return_code=1;

    if((my_file=read_from.fopen("r"))){
        fseek(my_file, 0, SEEK_END);
        myfilesize=ftell(my_file);
        fseek(my_file, 0, SEEK_SET);
        if((my_buff=(char *)malloc(myfilesize+1))){
            *my_buff=0;
            *(my_buff+myfilesize)=0;
            fread(my_buff, myfilesize, 1, my_file);
            /* ok, whole file readen.. let's write somewhere else */

            if((my_file2=write_to.fopen("w"))){
                fwrite(my_buff, myfilesize, 1, my_file2);
                write_to.fclose(my_file2);
                return_code=0;
            }
        }
        read_from.fclose(my_file);
    }

    return(return_code);
}

void get_current_user_homepath(SSTRING &my_username, SSTRING &my_homepath)
{
    uid_t my_uid;
    struct passwd *my_user;

    my_uid=getuid();

    setpwent();
    while((my_user=getpwent())){
        if(my_user->pw_uid==my_uid){
            my_username.setfrom(my_user->pw_name);
            my_homepath.setfrom(my_user->pw_dir);
        }
    }
    endpwent();
}

