
#include <stdio.h>
#include <string.h>
#include "wineconf.h"
#include "wineconf.m"
#include <fviews.h>
#include "wineconf_global_defs.h"
#include "wineconf_tools.h"

/* edit the selected drive */
void edit_drive_properties(char drive_letter, VIEWITEMS &vitems_wineconf, CONFIG_FILE &cf_wineconf)
{
    struct {
        SSTRING label, path, type, device, filesystem, serial;
    } my_drive;

    char        dg_name[TYPICAL_STRING_SIZE]; // drivegroup name
    DIALOG      dia_editdrive;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    //    FIELD_COMBO *co_type;
    FIELD_LIST *pop_type;
    //    FIELD_COMBO *co_filesystem;
    FIELD_LIST *pop_filesystem;

    sprintf(dg_name, "Drive %c", drive_letter);

    /* loads local vars with data from file */
    load_var_data(dg_name, "Label", vitems_wineconf, my_drive.label);
    load_var_data(dg_name, "Path", vitems_wineconf, my_drive.path);
    load_var_data(dg_name, "Type", vitems_wineconf, my_drive.type);
    load_var_data(dg_name, "Device", vitems_wineconf, my_drive.device);
    load_var_data(dg_name, "Filesystem", vitems_wineconf, my_drive.filesystem);
    load_var_data(dg_name, "Serial", vitems_wineconf, my_drive.serial);

    /* adjust variables, if needed */
    adjust_multialiased_string(my_drive.filesystem, "fat\0msdos\0dos\0\0vfat\0win95\0\0\0");

    /* builds window */
    dia_editdrive.newf_str(MSG_U(F_LABEL, "Label:"), my_drive.label, 11);
    dia_editdrive.newf_str(MSG_U(F_DRIVEPATH, "Path:"), my_drive.path);
    pop_type=dia_editdrive.newf_list(MSG_U(F_TYPE, "Type:"), my_drive.type);
        pop_type->addopt("", MSG_U(X_NOTSPECIFIED, "NOT SPECIFIED"), "");
        pop_type->addopt("floppy", MSG_U(X_FLOPPYDISK, "Floppy Disk"), "");
        pop_type->addopt("hd", MSG_U(X_HARDDISK, "Hard Disk"), "");
        pop_type->addopt("cdrom", MSG_U(X_CDROM, "CD-ROM"), "");
        pop_type->addopt("network", MSG_U(X_NETWORK, "Network"), "");
    dia_editdrive.newf_str(MSG_U(F_DEVICE, "Device (opt.):"), my_drive.device);
    pop_filesystem=dia_editdrive.newf_list(MSG_U(F_FILESYSTEM, "Filesystem:"), my_drive.filesystem);
        pop_filesystem->addopt("", MSG_R(X_NOTSPECIFIED), "");
        pop_filesystem->addopt("fat", MSG_U(X_FAT, "FAT"), "");
        pop_filesystem->addopt("vfat", MSG_U(X_VFAT, "VFAT (recommended)"), "");
        pop_filesystem->addopt("unix", MSG_U(X_UNIX, "Unix"), "");
    dia_editdrive.newf_str(MSG_U(F_SERIAL, "Serial (opt.):"), my_drive.serial, 8);

    /* opens window.. */
    {
        char my_dialog_title[TYPICAL_STRING_SIZE];

        sprintf(my_dialog_title, MSG_U(T_EDITINGDRIVE, "Editing Drive %c"), drive_letter);
        my_selection=0;
        my_button=dia_editdrive.editmenu(my_dialog_title, "", help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);
        strgname(my_drive.label);
    }
    /* now user pressed some button, let's have some processing.. */

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_DEL:
        remove_group(dg_name, vitems_wineconf);
        vitems_wineconf.write(cf_wineconf, NULL);
        break;
    case MENU_ACCEPT:
        {
            /* update file with data from local vars */
            write_var_data(dg_name, "Label", my_drive.label.get(), vitems_wineconf, 1);
            write_var_data(dg_name, "Path", my_drive.path.get(), vitems_wineconf, 1);
            write_var_data(dg_name, "Type", my_drive.type.get(), vitems_wineconf, 1);
            write_var_data(dg_name, "Device", my_drive.device.get(), vitems_wineconf, 1);
            write_var_data(dg_name, "Filesystem", my_drive.filesystem.get(), vitems_wineconf, 1);
            write_var_data(dg_name, "Serial", my_drive.serial.get(), vitems_wineconf, 1);

            vitems_wineconf.write(cf_wineconf, NULL);
        }
    default:
        break;
    }
}

/* shows the drives list */
void manage_drives_settings(VIEWITEMS &vitems_wineconf, CONFIG_FILE &cf_wineconf)
{
//    VIEWITEMS   vitems_wineconf;     // used with linuxconf's parser
    DIALOG_RECORDS dia_drives;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

//    vitems_wineconf.read(cf_wineconf);// load variables with data from file

    dia_drives.newf_head("", MSG_U(T_ASSIGNLOCATION, "assignment\treal location"));

    while(1)
    {
        char        selected_drive=0;
        int         line_counter=0;

        int useless_var1, useless_var2;
        char my_count='A';
        char my_temp[TYPICAL_STRING_SIZE];

        while(my_count<='Z'){
            SSTRING use_this_one;

            sprintf(my_temp, "Drive %c", my_count);
            if(locate_group_limits(my_temp, &useless_var1, &useless_var2, vitems_wineconf)){
                load_var_data(my_temp, "Path", vitems_wineconf, use_this_one);
                dia_drives.set_menuitem(line_counter++, my_temp, use_this_one.get());
            }
            my_count++;
        }

        // remove entries below (they're the previous ones and useless now)
        dia_drives.remove_last(line_counter+1);

        my_button=dia_drives.editmenu(MSG_U(T_VIRTUALDRIVES, "Virtual drives"), MSG_U(I_VIRTUALDRIVES, "Here you may define the drives\nwhich will be seen by applications\nrunning under Wine."), virtual_drives_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            {
                MENU_STATUS my_button2=(MENU_STATUS)0;
                int         my_selection2=0;
                SSTRING     new_drive_selected;
                char        new_drive_selected2;

                {
                    DIALOG      dia_adddrive;
                    FIELD_LIST *pop_newdrive;

                    char my_data[]="A\0";
                    char *my_count;
                    char newgroup_name[TYPICAL_STRING_SIZE];
                    char string_for_addopt[TYPICAL_STRING_SIZE];
                    int trashvar1, trashvar2;

                    pop_newdrive=dia_adddrive.newf_list(MSG_U(F_NEWDRVWILLBEKNOWNAS, "The new drive will be known as:"), new_drive_selected);
                    my_count=my_data;

                    while(*my_count<='Z'){
                        sprintf(newgroup_name, "Drive %c", *my_count);
                        if(!locate_group_limits(newgroup_name, &trashvar1, &trashvar2, vitems_wineconf)){
                            pop_newdrive->addopt(my_data);
                        } else {
                            sprintf(string_for_addopt, MSG_U(X_ALREADYASSIGNED, "%s (already assigned)"), my_data);
                            pop_newdrive->addopt("", string_for_addopt, "");
                        }
                        (*my_count)++;
                    }
                    my_button2=dia_adddrive.editmenu(MSG_U(T_ADDINGNEWDRIVE, "Adding a new drive for Wine..."), "", help_nil, my_selection2, MENUBUT_QUIT|MENUBUT_ACCEPT);
                }

                if(my_button2==MENU_ACCEPT){
                    char newgroup_name[TYPICAL_STRING_SIZE];

                    new_drive_selected2=*new_drive_selected.get();

                    sprintf(newgroup_name, "Drive %c", new_drive_selected2);

                    /* if selected drive letter is not an existing one.. */
                    if(new_drive_selected2){
                        write_var_data(newgroup_name, "Label", MSG_U(X_UNNAMED, "Unnamed"), vitems_wineconf, 1);
                        write_var_data(newgroup_name, "Path", MSG_U(X_SOMEDIRECTORY, "/some/directory"), vitems_wineconf, 1);
                        write_var_data(newgroup_name, "Filesystem", "vfat", vitems_wineconf, 1);
                        edit_drive_properties(new_drive_selected2, vitems_wineconf, cf_wineconf);
                    }
                }
            }
            break;
        default:
            {
                {
                    int my_secondary_counter=0;

                    my_count='A';
                    while(my_count<='Z'){
                        sprintf(my_temp, "Drive %c", my_count);
                        if(locate_group_limits(my_temp, &useless_var1, &useless_var2, vitems_wineconf)){
                            if(my_secondary_counter==my_selection)
                                selected_drive=my_count;
                            my_secondary_counter++;
                        }
                        my_count++;
                    }
                }
                edit_drive_properties(selected_drive, vitems_wineconf, cf_wineconf);
            }
            break;
        }


//        vitems_wineconf.write(cf_wineconf, NULL);
    }
}

