
#include <stdio.h>
#include <string.h>
#include "wineconf.h"
#include "wineconf.m"
#include <fviews.h>
#include "wineconf_global_defs.h"
#include "wineconf_tools.h"


void manage_advanced_options(VIEWITEMS &vitems_wineconf, CONFIG_FILE &cf_wineconf)
{
    struct {
        /* registry */
        SSTRING PeriodicSave;
        SSTRING LoadGlobalRegistryFiles,
        LoadHomeRegistryFiles,
        LoadAltRegistryFiles,
        WritetoHomeRegistryFiles,
        WritetoAltRegistryFiles,
        LoadWinRegistryFiles;
        /* log and debug */
        SSTRING File,
        Include,
        Exclude,
        SymbolTableFile;
        /* misc */
        SSTRING EXTRA_LD_LIBRARY_PATH,
        DefaultLoadOrder,
        read,
        write;
        /* graphic driver */
        SSTRING AllocSystemColors,
        ScreenDepth,
        Display,
        TextCP;
        SSTRING PrivateColorMap,
        PerfectGraphics,
        Managed,
        UseDGA,
        UseXShm,
        DXGrab,
        DesktopDoubleBuffered,
        GraphicsDriver;
    } my_intdir;

    FIELD_LIST *fl_LoadGlobalRegistryFiles,
               *fl_LoadHomeRegistryFiles,
               *fl_LoadAltRegistryFiles,
               *fl_WritetoHomeRegistryFiles,
               *fl_WritetoAltRegistryFiles,
               *fl_LoadWinRegistryFiles;
    FIELD_LIST *fl_PrivateColorMap,
               *fl_PerfectGraphics,
               *fl_Managed,
               *fl_UseDGA,
               *fl_UseXShm,
               *fl_DXGrab,
               *fl_DesktopDoubleBuffered;
    FIELD_COMBO *co_GraphicsDriver;
    DIALOG      my_dialog;
    char        registrygroup_name[]="registry";
    char        spygroup_name[]="spy";
    char        winegroup_name[]="wine";
    char        dlldef_name[]="DllDefaults";
    char        portsgroup_name[]="ports";
    char        x11drvgroup_name[]="x11drv";
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    /* loads local vars with data from file */
    /* registry */
    load_var_data(registrygroup_name, "PeriodicSave", vitems_wineconf, my_intdir.PeriodicSave);
    load_boolean_to_sstring(registrygroup_name, "LoadGlobalRegistryFiles", vitems_wineconf, my_intdir.LoadGlobalRegistryFiles);
    load_boolean_to_sstring(registrygroup_name, "LoadHomeRegistryFiles", vitems_wineconf, my_intdir.LoadHomeRegistryFiles);
    load_boolean_to_sstring(registrygroup_name, "LoadAltRegistryFiles", vitems_wineconf, my_intdir.LoadAltRegistryFiles);
    load_boolean_to_sstring(registrygroup_name, "WritetoHomeRegistryFiles", vitems_wineconf, my_intdir.WritetoHomeRegistryFiles);
    load_boolean_to_sstring(registrygroup_name, "WritetoAltRegistryFiles", vitems_wineconf, my_intdir.WritetoAltRegistryFiles);
    load_boolean_to_sstring(registrygroup_name, "LoadWindowsRegistryFiles", vitems_wineconf, my_intdir.LoadWinRegistryFiles);
    /* log and debug */
    load_var_data(spygroup_name, "File", vitems_wineconf, my_intdir.File);
    load_var_data(spygroup_name, "Include", vitems_wineconf, my_intdir.Include);
    load_var_data(spygroup_name, "Exclude", vitems_wineconf, my_intdir.Exclude);
    load_var_data(winegroup_name, "SymbolTableFile", vitems_wineconf, my_intdir.SymbolTableFile);
    /* misc */
    load_var_data(dlldef_name, "EXTRA_LD_LIBRARY_PATH", vitems_wineconf, my_intdir.EXTRA_LD_LIBRARY_PATH);
    load_var_data(dlldef_name, "DefaultLoadOrder", vitems_wineconf, my_intdir.DefaultLoadOrder);
    load_var_data(portsgroup_name, "read", vitems_wineconf, my_intdir.read);
    load_var_data(portsgroup_name, "write", vitems_wineconf, my_intdir.write);
    /* graphics driver */
    load_var_data(x11drvgroup_name, "AllocSystemColors", vitems_wineconf, my_intdir.AllocSystemColors);
    load_boolean_to_sstring(x11drvgroup_name, "PrivateColorMap", vitems_wineconf, my_intdir.PrivateColorMap);
    load_boolean_to_sstring(x11drvgroup_name, "PerfectGraphics", vitems_wineconf, my_intdir.PerfectGraphics);
    load_var_data(x11drvgroup_name, "ScreenDepth", vitems_wineconf, my_intdir.ScreenDepth);
    load_var_data(x11drvgroup_name, "Display", vitems_wineconf, my_intdir.Display);
    load_boolean_to_sstring(x11drvgroup_name, "Managed", vitems_wineconf, my_intdir.Managed);
    load_boolean_to_sstring(x11drvgroup_name, "UseDGA", vitems_wineconf, my_intdir.UseDGA);
    load_boolean_to_sstring(x11drvgroup_name, "UseXShm", vitems_wineconf, my_intdir.UseXShm);
    load_boolean_to_sstring(x11drvgroup_name, "DXGrab", vitems_wineconf, my_intdir.DXGrab);
    load_boolean_to_sstring(x11drvgroup_name, "DesktopDoubleBuffered", vitems_wineconf, my_intdir.DesktopDoubleBuffered);
    load_var_data(x11drvgroup_name, "DesktopDoubleBuffered", vitems_wineconf, my_intdir.DesktopDoubleBuffered);
    load_var_data(x11drvgroup_name, "TextCP", vitems_wineconf, my_intdir.TextCP);
    load_var_data("wine", "GraphicsDriver", vitems_wineconf, my_intdir.GraphicsDriver);
    /* builds window */
    /* registry */
    my_dialog.newf_title(MSG_U(T_REGISTRY, "Registry"), 1, "", MSG_R(T_REGISTRY));
    my_dialog.newf_str(MSG_U(F_PERIODICSAVE, "Periodic Save (s):"), my_intdir.PeriodicSave);
    create_triple_boolean_gadget(my_dialog, &fl_LoadGlobalRegistryFiles, MSG_U(F_LOCGLOBREGFILES, "Load global registry files:"), my_intdir.LoadGlobalRegistryFiles);
    create_triple_boolean_gadget(my_dialog, &fl_LoadHomeRegistryFiles, MSG_U(F_LOCHOMEREFFILES, "Load home registry files:"), my_intdir.LoadHomeRegistryFiles);
    create_triple_boolean_gadget(my_dialog, &fl_LoadAltRegistryFiles, MSG_U(F_LOCALTREGFILES, "Load alt. registry files:"), my_intdir.LoadAltRegistryFiles);
    create_triple_boolean_gadget(my_dialog, &fl_LoadWinRegistryFiles, MSG_U(F_LOCWINREGFILES, "Load Windows registry files:"), my_intdir.LoadWinRegistryFiles);
    create_triple_boolean_gadget(my_dialog, &fl_WritetoHomeRegistryFiles, MSG_U(F_WRITE2HOMEREGFILES, "Write to home registry files:"), my_intdir.WritetoHomeRegistryFiles);
    create_triple_boolean_gadget(my_dialog, &fl_WritetoAltRegistryFiles, MSG_U(F_WRITE2ALTREGFILES, "Write to alt. registry files:"), my_intdir.WritetoAltRegistryFiles);
    /* log and debug */
    my_dialog.newf_title(MSG_U(T_LOGDEBUG, "Log/Debug"), 1, "", MSG_R(T_LOGDEBUG));
    my_dialog.newf_title("", MSG_U(T_LOGGING, "Logging"));
    my_dialog.newf_str(MSG_U(F_NAMEFORLOGFILE, "Name for logfile:"), my_intdir.File);
    my_dialog.newf_str(MSG_U(F_INCLUDE2LOG, "Include to log:"), my_intdir.Include);
    my_dialog.newf_str(MSG_U(F_EXCLUDEFROMLOG, "Exclude from log:"), my_intdir.Exclude);
    my_dialog.newf_title("", MSG_U(T_DEBUGGING, "Debugging"));
    my_dialog.newf_str(MSG_U(F_SYMBOLTABLEFILE, "Symboltable file:"), my_intdir.SymbolTableFile);
    /* graphics driver */
    my_dialog.newf_title(MSG_U(T_GRAPHICSDRIVER, "Graphics Driver"), 1, "", MSG_R(T_GRAPHICSDRIVER));
    co_GraphicsDriver=my_dialog.newf_combo(MSG_U(F_GRAPHICSDRIVER, "Graphics Driver:"), my_intdir.GraphicsDriver);
    co_GraphicsDriver->addopt("x11drv");
    my_dialog.newf_title("", MSG_U(T_X11DRIVER, "X11 driver"));
    my_dialog.newf_str(MSG_U(F_ALLOCSYSTEMCOLORS, "System colors to allocate:"), my_intdir.AllocSystemColors);
    create_triple_boolean_gadget(my_dialog, &fl_PrivateColorMap, MSG_U(F_PRIVATECOLORMAP, "Private color map:"), my_intdir.PrivateColorMap);
    create_triple_boolean_gadget(my_dialog, &fl_PerfectGraphics, MSG_U(F_PERFECTGRAPHICS, "Perfect graphics:"), my_intdir.PerfectGraphics);
    my_dialog.newf_str(MSG_U(F_SCREENDEPTH, "Screen depth:"), my_intdir.ScreenDepth);
    my_dialog.newf_str(MSG_U(F_DISPLAY, "X11 display:"), my_intdir.Display);
    create_triple_boolean_gadget(my_dialog, &fl_Managed, MSG_U(F_MANAGED, "Managed windows:"), my_intdir.Managed);
    create_triple_boolean_gadget(my_dialog, &fl_UseDGA, MSG_U(F_USEDGA, "Use XFree86 DGA:"), my_intdir.UseDGA);
    create_triple_boolean_gadget(my_dialog, &fl_UseXShm, MSG_U(F_USEXSHM, "Use XShm:"), my_intdir.UseXShm);
    create_triple_boolean_gadget(my_dialog, &fl_DXGrab, MSG_U(F_DXGRAB, "DirectX mouse grab:"), my_intdir.DXGrab);
    create_triple_boolean_gadget(my_dialog, &fl_DesktopDoubleBuffered, MSG_U(F_DESKTOPDOUBLBUFF, "Desktop double buffered:"), my_intdir.DesktopDoubleBuffered);
    my_dialog.newf_str(MSG_U(F_TEXTCP, "Text codepage:"), my_intdir.TextCP);
    /* misc */
    my_dialog.newf_title(MSG_U(T_MISC, "Misc"), 1, "", MSG_R(T_MISC));
    my_dialog.newf_title("", MSG_U(T_DLLLOADING, "DLL loading"));
    my_dialog.newf_str(MSG_U(F_PATHFOREXTRALIBS, "Path for extra libraries:"), my_intdir.EXTRA_LD_LIBRARY_PATH);
    my_dialog.newf_str(MSG_U(F_LIBRARYLOADORDER, "Library load order:"), my_intdir.DefaultLoadOrder);
    my_dialog.newf_title("", MSG_U(T_HARDWAREPORTS, "Hardware ports"));
    my_dialog.newf_str(MSG_U(F_READ, "Read:"), my_intdir.read);
    my_dialog.newf_str(MSG_U(F_WRITE, "Write:"), my_intdir.write);

    /* opens window.. */
    my_selection=0;
    my_button=my_dialog.editmenu(MSG_U(T_ADVANCEDSETTINGS, "Advanced settings"), MSG_U(I_CANT_TOUCH_THIS_TOO_DOO_DOO_DOO, "Don't touch these unless you\nreally know what you're doing."), adv_opts_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT);

    /* now user pressed some button, let's have some processing.. */

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_ACCEPT:
        {
            /* update file with data from local vars */
            /* registry */
            write_var_data(registrygroup_name, "PeriodicSave", my_intdir.PeriodicSave.get(), vitems_wineconf, 1);
            write_var_data(registrygroup_name, "LoadGlobalRegistryFiles", my_intdir.LoadGlobalRegistryFiles.get(), vitems_wineconf, 1);
            write_var_data(registrygroup_name, "LoadHomeRegistryFiles", my_intdir.LoadHomeRegistryFiles.get(), vitems_wineconf, 1);
            write_var_data(registrygroup_name, "LoadAltRegistryFiles", my_intdir.LoadAltRegistryFiles.get(), vitems_wineconf, 1);
            write_var_data(registrygroup_name, "LoadWinRegistryFiles", my_intdir.LoadWinRegistryFiles.get(), vitems_wineconf, 1);
            write_var_data(registrygroup_name, "WritetoHomeRegistryFiles", my_intdir.WritetoHomeRegistryFiles.get(), vitems_wineconf, 1);
            write_var_data(registrygroup_name, "WritetoAltRegistryFiles", my_intdir.WritetoAltRegistryFiles.get(), vitems_wineconf, 1);
            /* log and debug */
            write_var_data(spygroup_name, "File", my_intdir.File.get(), vitems_wineconf, 1);
            write_var_data(spygroup_name, "Include", my_intdir.Include.get(), vitems_wineconf, 1);
            write_var_data(spygroup_name, "Exclude", my_intdir.Exclude.get(), vitems_wineconf, 1);
            write_var_data(winegroup_name, "SymbolTableFile", my_intdir.SymbolTableFile.get(), vitems_wineconf, 1);
            /* misc */
            write_var_data(dlldef_name, "EXTRA_LD_LIBRARY_PATH", my_intdir.EXTRA_LD_LIBRARY_PATH.get(), vitems_wineconf, 1);
            write_var_data(dlldef_name, "DefaultLoadOrder", my_intdir.DefaultLoadOrder.get(), vitems_wineconf, 1);
            write_var_data(portsgroup_name, "read", my_intdir.read.get(), vitems_wineconf, 1);
            write_var_data(portsgroup_name, "write", my_intdir.write.get(), vitems_wineconf, 1);
            /* graphics driver */
            write_var_data(x11drvgroup_name, "AllocSystemColors", my_intdir.AllocSystemColors.get(), vitems_wineconf, 1);
            write_var_data(x11drvgroup_name, "PrivateColorMap", my_intdir.PrivateColorMap.get(), vitems_wineconf, 1);
            write_var_data(x11drvgroup_name, "PerfectGraphics", my_intdir.PerfectGraphics.get(), vitems_wineconf, 1);
            write_var_data(x11drvgroup_name, "ScreenDepth", my_intdir.ScreenDepth.get(), vitems_wineconf, 1);
            write_var_data(x11drvgroup_name, "Display", my_intdir.Display.get(), vitems_wineconf, 1);
            write_var_data(x11drvgroup_name, "Managed", my_intdir.Managed.get(), vitems_wineconf, 1);
            write_var_data(x11drvgroup_name, "UseDGA", my_intdir.UseDGA.get(), vitems_wineconf, 1);
            write_var_data(x11drvgroup_name, "UseXShm", my_intdir.UseXShm.get(), vitems_wineconf, 1);
            write_var_data(x11drvgroup_name, "DXGrab", my_intdir.DXGrab.get(), vitems_wineconf, 1);
            write_var_data(x11drvgroup_name, "DesktopDoubleBuffered", my_intdir.DesktopDoubleBuffered.get(), vitems_wineconf, 1);
            write_var_data(x11drvgroup_name, "TextCP", my_intdir.TextCP.get(), vitems_wineconf, 1);
            write_var_data("wine", "GraphicsDriver", my_intdir.GraphicsDriver.get(), vitems_wineconf, 1);

            vitems_wineconf.write(cf_wineconf, NULL);
        }
    default:
        break;
    }
}

