#!/usr/bin/shellmod
# This script allows one to edit the right of a given user of the
# mysql database. If is a simple front-end of the user database
# It manages the local mysql server
# It could certainly do much more...

# This is both a standalone utility and linuxconf module
# Do
#	linuxconf --modulemain shellmod --setmod editmysqlrights.sh
# to register this as a linuxconf module
#DBGSHELLMOD=on

. /usr/lib/linuxconf/lib/shellmod-lib.sh
register(){
	echo regmenu main MENU_MISCSERV \"Manage MySQL user rights\"
}

edituser(){
	echo DIALOG
	qecho newf_str host "Host name" $1
	qecho newf_str user "User name" $2
	if [ "$1" != "" -o "$2" != "" ] ; then
		mysql mysql -B -e "select select_priv,create_priv
			,delete_priv,insert_priv,update_priv,shutdown_priv
			,drop_priv,reload_priv,process_priv,file_priv
			from user where host='$1' and user='$2'" | \
		(
			read line 
			read selectpriv createpriv deletepriv insertpriv \
				updatepriv shutdownpriv \
				droppriv reloadpriv processpriv filepriv
			qecho newf_chk selectpriv "May select" $selectpriv:Y:N
			qecho newf_chk updatepriv "May update" $updatepriv:Y:N
			qecho newf_chk insertpriv "May insert new records" $insertpriv:Y:N
			qecho newf_chk deletepriv "May delete" $deletepriv:Y:N
			qecho newf_chk shutdownpriv "May stop the server" $shutdownpriv:Y:N
			qecho newf_chk createpriv   "May create tables" $createpriv:Y:N
			qecho newf_chk droppriv     "May delete tables" $droppriv:Y:N
			qecho newf_chk reloadpriv     "Enable access right" $reloadpriv:Y:N
			qecho newf_chk processpriv     "May stop the server" $processpriv:Y:N
			qecho newf_chk filepriv     "May read/write from/to file" $filepriv:Y:N
		)
	else
		# New record
		qecho newf_chk selectpriv "May select" N:Y:N
		qecho newf_chk updatepriv "May update" N:Y:N
		qecho newf_chk insertpriv "May insert new records" N:Y:N
		qecho newf_chk deletepriv "May delete" N:Y:N
		qecho newf_chk shutdownpriv "May stop the server" N:Y:N
		qecho newf_chk createpriv   "May create tables" N:Y:N
		qecho newf_chk droppriv     "May delete tables"	N:Y:N
		qecho newf_chk reloadpriv     "Enable access right" N:Y:N
		qecho newf_chk processpriv     "May stop the server" N:Y:N
		qecho newf_chk filepriv     "May read/write from/to file" N:Y:N
	fi
	qecho edit "Set user rights" "Current righs of user $2"

	dispatch
	echo end
	if [ "$CODE" = "accept" ] ; then
		MODIF=on
		if [ "$1" != "" -o "$2" != "" ] ; then
			mysql mysql -e "update user set host='$host'
				,user='$user'
				,select_priv='$selectpriv'
				,update_priv='$updatepriv'
				,insert_priv='$insertpriv'
				,delete_priv='$deletepriv'
				,shutdown_priv='$shutdownpriv'
				,create_priv='$createpriv'
				,drop_priv='$droppriv'
				,reload_priv='$reloadpriv'
				,process_priv='$processpriv'
				,file_priv='$filepriv'
				where host='$1' and user='$2'"
		else
			mysql mysql -e "insert into user 
				(
					host
					,user
					,select_priv
					,update_priv
					,insert_priv
					,delete_priv
					,shutdown_priv
					,create_priv
					,drop_priv
					,reload_priv
					,process_priv
					,file_priv
				)
				values
				(
					'$host'
					,'$user'
					,'$selectpriv'
					,'$updatepriv'
					,'$insertpriv'
					,'$deletepriv'
					,'$shutdownpriv'
					,'$createpriv'
					,'$droppriv'
					,'$reloadpriv'
					,'$processpriv'
					,'$filepriv'
				)"
		fi
	fi
}


main(){
	echo DIALOG_LIST
	echo newf_head Host User
	mysql mysql -B -e "select host,user from user" | \
	(read skip; while read a b
		do
			echo new_menuitem \"edituser $a $b\" $a $b
		done
	)
	echo button Add Add
	while true
	do
		echo editmenu \"Mysql users rights\" \
			\"Pick one record to edit its associated rights and password\"
		dispatch
		if [ "$CODE" = "Add" ] ; then
			edituser
		else
			break
		fi
	done
	echo end
	if [ "$MODIF" = "on" ] ; then
		yesno "Confirm" "Do you want to reload the access rights"
		if [ "$CODE" = "yes" ] ; then
			mysqladmin reload
		fi
	fi
}
dispatch



