#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "report.h"
#include "report.m"

MODULE_DEFINE_VERSION(report);

PUBLIC MODULE_report::MODULE_report()
	: LINUXCONF_MODULE("report")
{
	linuxconf_loadmsg ("report",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_report::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_SYS_STATUS){
		keymenu = MSG_U(M_report,"Reports");
		dia.new_menuitem ("report","",keymenu);
	}
}

PUBLIC int MODULE_report::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_SYS_STATUS){
		if (key == keymenu){
			report_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_report::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"report")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain report usage\n"
		 "\n"
		 "    report --option ...\n")
		);
}

PUBLIC void MODULE_report::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_report::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"report")==0){
		ret = -1;
		if (argc == 1){
			report_edit();
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_report report;
