
#include <stdio.h>
#include <string.h>

#include <fviews.h>
#include <dialog.h>

#ifndef RC_TOOLS_DEFINED


// given: field description
#define EASY_TITLE(a) SSTRING my_group_title;\
    read_group_title(given_vitems, which_group, my_group_title);\
    my_dialog.newf_str(a, my_group_title, 31)

#define EASY_TITLE_WRITE \
    write_group_title(given_vitems, which_group, my_group_title.get())

// varname in config file, var_level(0 or 1), sstring_id, description
#define EASY_TEXT(a,b,c,d) SSTRING c;\
    load_multiline_var_data(given_vitems, which_group, a, b, c);\
    my_dialog.newf_textarea(d, c, 30, 4)

// loads var from configfile and builds field_combo
// combo_var_id, varname_in_configfile, var_level(0 or 1), sstring_id, description
#define EASY_FC(a,b,e,c,d) FIELD_COMBO *a;\
    SSTRING c;\
    load_var_data(given_vitems, which_group, b, e, c);\
    a=my_dialog.newf_combo(d, c);\
    if(e) level_one_vars.add(&c)

// loads var from configfile and builds field_combo
// combo_var_id, varname_in_configfile, var_level(0 or 1), sstring_id, description
#define EASY_FC_QUOTED(a,b,e,c,d) FIELD_COMBO *a;\
    SSTRING c;\
    load_var_data(given_vitems, which_group, b, e, c);\
    cuts_quotes_off(c);\
    a=my_dialog.newf_combo(d, c);\
    if(e) level_one_vars.add(&c)

// combo_var_id, sstring_id, position in line (starts from 0), description
#define EASY_FC2(a,b,c,d) FIELD_COMBO *a;\
    SSTRING b;\
    gimme_word_from_string(given_vitems.getitem(which_one)->line.get(), b, c);\
    a=my_dialog.newf_combo(d, b)

// adds items in field_combo
// field_combo varname, item to add
#define EASY_ADD_FC(a,b) a->addopt(b)

// loads var from configfile and builds newf_str
// sstring_id, varname_in_configfile, var_level(0 or 1), description
#define EASY_STR(a,b,c,d) SSTRING a;\
    load_var_data(given_vitems, which_group, b, c, a);\
    my_dialog.newf_str(d, a);\
    if(c) level_one_vars.add(&a)

// loads var from configfile and builds newf_str
// sstring_id, varname_in_configfile, var_level(0 or 1), description
#define EASY_STR_QUOTED(a,b,c,d) SSTRING a;\
    load_var_data_quoted(given_vitems, which_group, b, c, a);\
    my_dialog.newf_str(d, a);\
    if(c) level_one_vars.add(&a)

// loads var from configfile and builds newf_str
// sstring_id, varname_in_configfile, var_level(0 or 1), description, field_list varname
#define EASY_BOOL(a,b,c,d,e) SSTRING a;\
    FIELD_LIST *e;\
    load_var_data(given_vitems, which_group, b, c, a);\
    if(*(a.get())=='1') \
       a.setfrom("Yes");\
    if(*(a.get())=='0') \
       a.setfrom("No");\
    e=my_dialog.newf_list(d, a);\
    e->addopt("Yes", MSG_R(X_YES), "");\
    e->addopt("No", MSG_R(X_NO), "");\
    e->addopt("", MSG_R(X_NOTDEFINED), "");\
    if(c) level_one_vars.add(&a)

/* var identificator, position in line (starts from 0), description */
#define EASY_STR2(a,b,c) SSTRING a;\
    gimme_word_from_string(given_vitems.getitem(which_one)->line.get(), a, b);\
    my_dialog.newf_str(c, a)

// used for string, field_combo and yes/no/undefined gadgets */
// sstring_id, varname_in_configfile, var_level(0 or 1)
#define EASY_SSTRING_WRITE(a,b,c)\
    write_var_data(given_vitems, which_group, b, c, a.get())

// used for texfield gadget */
// sstring_id, varname_in_configfile, var_level(0 or 1)
#define EASY_TEXT_WRITE(a,b,c)\
    write_multiline_var_data(given_vitems, which_group, b, c, a.get())

// sstring_id, varname_in_configfile, var_level(0 or 1)
#define EASY_SSTRING_QUOTED_WRITE(a,b,c)\
    write_var_data_quoted(given_vitems, which_group, b, c, a.get())

/* removes the surrounding quotes from string */
void cuts_quotes_off(SSTRING &sstring_to_adjust);

/* strcmp non-sensitive to case */
int ci_strcmp(const char *given_string_1, const char *given_string_2);

/* returns !=0 if the provided string is empty or has spaces/etc (<31 ascii) */
int invalid_entry(const char *given_string);

int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number);

/* picks a 'word' (string-particle between spaces) from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 if non-empty string returned */
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number, int to_eol);

/* gives the 'real' beginning of a given string (skips the heading spaces, tabs, etc) */
const char *skip_spaces(const char *given_string);

/* returns string length except the tailing spaces */
unsigned int strlen_except_useless_tail(const char *given_string);

/* cuts the heading and trailing spaces (anything < ' ')
 in the provided string and writes the new string in the provided
 SSTRING */
void cut_surrounding_spaces(const char *adjust_this, SSTRING &write_here);

/* returns !=0 if string is empty, or has only spaces */
int is_empty_string(const char *given_string);

/* returns !=0 is all strings inside given_sstrings are empty,
   ==0 at least one of these has some data */
int are_all_empty(SSTRINGS &given_sstrings);

void informative_window(const char *my_title, const char *my_text);

/* returns 0 to N or -1 (-1 means 'selection cancelled')
 if items' total is N and N is returned means the object is going
 to be the last one. (0 means 'to the first position') */
/* this is used when moving a group from a position to another */
int select_new_position(VIEWITEMS &given_vitems, const char *window_title, const char *table_title, const char *last_position);

int gimme_word_from_string_bchar(const char *given_string, SSTRING &write_here, int word_number, const char given_separator);

#define RC_TOOLS_DEFINED
#endif
