
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "radiusconf.h"
#include "radiusconf.m"

#include "rc_parser.h"
#include "rc_vars.h"

#include "rc_users.cc"
#include "rc_clients.cc"
#include "rc_naslist.cc"
#include "rc_naspasswd.cc"
#include "rc_realms.cc"
#include "rc_hints.cc"
#include "rc_huntgroups.cc"

// (needed for the script which creates the dictionaries,
// this should be in rc_tools.h but the script ignores that
// file so that's why these strings are here)
// MSG_U(X_YES,"Yes")
// MSG_U(X_NO,"No")
// MSG_U(X_NOTDEFINED,"(not defined)")

/* returns !=0 if stored checksum is different from the stored one */
/* given: config_file and identificator string (for checksum table) */
int was_this_changed(CONFIG_FILE &given_configfile, const char *given_identificator, bool simul)
{
    char current_sum[500];
    const char *saved_sum;
    const char my_nothing[]="";
    int return_code=0;

    if(given_configfile.exist()){
        given_configfile.md5sum(current_sum);
        if(!(saved_sum=linuxconf_getval("radiusconf", given_identificator)))
            saved_sum=my_nothing;
        if(strcmp(saved_sum, current_sum)){
            return_code=1;
            if(simul==false){
                linuxconf_replace("radiusconf", given_identificator, current_sum);
                linuxconf_save();
            }
        }
    }
    return(return_code);
}

void show_mainmenu(void)
{
    MENU_STATUS my_button=MENU_STATUS(0);
    int    my_selection=0;
    DIALOG_MENU dia_mymenu;

    dia_mymenu.new_menuitem("", MSG_U(M_CLIENTS,"Clients"));
    dia_mymenu.new_menuitem("", MSG_U(M_HINTS,"Hints"));
    dia_mymenu.new_menuitem("", MSG_U(M_HUNTGROUPS,"Hunt groups"));
    dia_mymenu.new_menuitem("", MSG_U(M_NASLIST,"NAS list"));
    dia_mymenu.new_menuitem("", MSG_U(M_NASPASSWORDS,"NAS passwords")); // ni
    dia_mymenu.new_menuitem("", MSG_U(M_REALMS,"Realms")); // ni
    dia_mymenu.new_menuitem("", MSG_U(M_USERS,"Users"));

    while(1){
        my_button=dia_mymenu.editmenu(MSG_U(T_RADIUSCONFIGURATOR,"Radius configurator"), "", help_nil, my_selection, MENUBUT_QUIT);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        default:
            switch(my_selection){
            case 0:
                if(perm_rootaccess(""))
                    show_clients_list();
                break;
            case 1:
                if(perm_rootaccess(""))
                    show_hints_list();
                break;
            case 2:
                if(perm_rootaccess(""))
                    show_huntgroups_list();
                break;
            case 3:
                if(perm_rootaccess(""))
                    show_nas_list();
                break;
            case 4:
                if(perm_rootaccess(""))
                    show_naspasswd_list();
                break;
            case 5:
                if(perm_rootaccess(""))
                    show_realms_list();
                break;
            case 6:
                if(perm_rootaccess(""))
                    show_users_list();
            default:
                break;
            }
        }

    }

//    test();


}

