#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;

static struct PyMethodDef LCString_methods[] = {
	{NULL, NULL}
};

static void
LCString_dealloc(LCStringObject *self)
{
	if (self->owner)
		delete self->s;
	PyMem_DEL(self);
}

static PyObject *
LCString_getattr(LCStringObject *self, char *name)
{
	return Py_FindMethod(LCString_methods, (PyObject*) self, name);
}

static PyObject *
LCString_repr(LCStringObject *self)
{
	return PyString_FromString(self->s->get());
}

PyTypeObject LCString_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCString",
	sizeof(LCStringObject),
	0,
	(destructor) LCString_dealloc,
	(printfunc) 0,
	(getattrfunc) LCString_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) LCString_repr,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCString_New(char *s)
{
	LCStringObject *self;
	self = PyObject_NEW(LCStringObject, &LCString_Type);
	if (self == NULL)
		return NULL;
	self->s = new SSTRING(s);
	self->owner = 1;
	return (PyObject*) self;
}

PyObject *
LCString_FromString(SSTRING *s)
{
	LCStringObject *self;
	self = PyObject_NEW(LCStringObject, &LCString_Type);
	if (self == NULL)
		return NULL;
	self->s = s;
	self->owner = 0;
	return (PyObject*) self;
}

PyObject *
LCString_FromStringDealloc(SSTRING *s)
{
	LCStringObject *self;
	self = PyObject_NEW(LCStringObject, &LCString_Type);
	if (self == NULL)
		return NULL;
	self->s = s;
	self->owner = 1;
	return (PyObject*) self;
}

SSTRING *
LCString_AsString(PyObject *self)
{
	return ((LCStringObject*)self)->s;
}

static PyObject *
lcstring_LCString(PyObject *self, PyObject *args)
{
	char *s = "";
	if (!PyArg_ParseTuple(args, "|s", &s))
		return NULL;
	return LCString_New(s);
}

static struct PyMethodDef lcstring_methods[] = {
	{"LCString", lcstring_LCString, 1},
	{NULL,NULL}
};

extern "C" void
initlcstring()
{
	PyObject *m, *d;
	m = Py_InitModule("lcstring", lcstring_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "lcstring.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lcstring");
}
