/* the defines' table resides here, so the routines considered generic */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/stat.h>
#include <popen.h>

#include <dialog.h>

/* needed for change_owner_and_group(...) */
#include <grp.h>
#include <pwd.h>

#include <modapi.h>

#include "printer.h"

int kind_of_lpr_system_installed;

//t_dataprintcap my_printcap[MAX_PRINTERS];
t_dataprintcap *my_printcap;

/* total of block allocated for my_printcap array */
int total_printer_entries;

t_general_printer_index *general_printer_index;

/* picks a 'word between given_chars' from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 is non-empty string returned */
int gimme_word_from_string_bchar(const char *given_string, SSTRING &write_here, int word_number, const char given_separator)
{
    const char *read_from,
               *copy_from;
    int  my_counter;

    read_from=given_string;

    /* finds the beginning of word */
    my_counter=word_number;
    while(my_counter--){
        if(read_from){
            if((read_from=strchr(read_from, given_separator)))
                read_from++;
        }
    }

    /* finds the length of the word and copies string */
    if((copy_from=read_from)){
        my_counter=0;
        while((*read_from)&&(*read_from!=given_separator)){
            read_from++;
            my_counter++;
        }

        write_here.setfrom(copy_from);
        write_here.truncate(my_counter);
    }else{
        write_here.setfrom("");
    }

    if(!*write_here.get()) /* if empty string returned.. */
        return(0);
    return(1);
}

int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number)
{
    return(gimme_word_from_string(given_string, write_here, word_number, 0));
}

/* picks a 'word' (string-particle between spaces) from a string */
/* if to_eol!=0 copy from word beginning to end of line (not only the word itself */
/* returns !=0 if non-empty string returned */
int gimme_word_from_string(const char *given_string, SSTRING &write_here, int word_number, int to_eol)
{
    const char *read_from,
               *copy_from;
    int  my_counter;

    read_from=given_string;

    /* ignores heading spaces */
    while((*read_from)&&(*read_from<=' '))
        read_from++;

    /* finds the beginning of word */
    my_counter=word_number;
    while(my_counter--){
        while((*read_from)&&(*read_from>' '))
            read_from++;
        while((*read_from)&&(*read_from<=' '))
            read_from++;
    }

    /* finds the length of the word and copies string */
    if((copy_from=read_from)){
        my_counter=0;
        if(!to_eol){
            while((*read_from)&&(*read_from>' ')){
                read_from++;
                my_counter++;
            }
        }else{
            while(*read_from++)
                my_counter++;
        }

        write_here.setfrom(copy_from);
        write_here.truncate(my_counter);
    }else{
        write_here.setfrom("");
    }

    if(!*write_here.get()) /* if empty string returned.. */
        return(0);
    return(1);
}

/* change owner and group of a given file/directory */
void change_owner_and_group(char *given_path, char *given_owner, char *given_group)
{
    gid_t         my_group_code=0;
    uid_t         my_user_code=0;
    struct group  *my_current_group;
    struct passwd *my_current_user;

    setgrent();
    while((my_current_group=getgrent())){
        if(!strcmp(my_current_group->gr_name, given_group)){
            my_group_code=my_current_group->gr_gid;
        }
    }
    endgrent();
    setpwent();
    while((my_current_user=getpwent())){
        if(!strcmp(my_current_user->pw_name, given_owner)){
            my_user_code=my_current_user->pw_uid;
        }
    }
    endpwent();

    chown(given_path, my_user_code, my_group_code);
}

int invalid_string_provided(char *given_string, char *corrected_version)
{
    return(invalid_string_provided(given_string, corrected_version, " !@#$%^&*()=+/?\\|<>,[]{}~`'\0"));
}

/* analyses if given string has characters <32 or >127 or |*` and such things */
/* returns true is provided string is invalid (illegal characters present) */
/* if (corrected_version!=NULL), provides the same string but having the illegal characters substituted by _ */
int invalid_string_provided(char *given_string, char *corrected_version, const char *the_invalid_ones)
{
//    char the_invalid_ones[]=" !@#$%^&*()=+/?\\|<>,[]{}~`'\0";
    char current_data;
    char *current_pointer;
    int  is_there_illegal_characters=0;

    if(corrected_version){
        strcpy(corrected_version, given_string);
        current_pointer=corrected_version;
    } else {
        current_pointer=given_string;
    }

    while((current_data=*current_pointer++)){
        if((current_data<32)|(current_data>126)){
            is_there_illegal_characters=1;
            if(corrected_version)
                *(current_pointer-1)='_';
        } else {
            if(strchr(the_invalid_ones, current_data)){
                is_there_illegal_characters=1;
                if(corrected_version)
                    *(current_pointer-1)='_';
            }
        }
    }

    return(is_there_illegal_characters);
}

/* dump given text to specified file, returns 0 if successful */
int dump_this_string_to_given_file(char *given_string, char *given_filename, char *given_path)
{
    char full_pathname[500];
    FILE *my_file;


    sprintf(full_pathname, "%s/%s", given_path, given_filename);

    if((my_file=fopen(full_pathname, "w"))){
        fputs(given_string, my_file);
        fclose(my_file);
        chmod(full_pathname, 511); /* -rwxrwxrwx */
        return(0);
    }
    return(1);
}

int strgname(char *givenstr)
{
    if(!(strcmp(givenstr, "quemfezisso"))){
        int nothing=0;
        DIALOG uhoh_dialog;
        uhoh_dialog.editmenu("Ta-daa..", "the Printer configurator was created by\nDaniel Mealha Cabrita\n(dancab@conectiva.com)\nFirst version developed in 2nd quarter of 2000.", help_nil, nothing, 0);
        return(1);
    }
    return(0);
}

/* returns true is given filename exists */
int this_file_exists(char *which_file)
{
    FILE *my_file;

    if((my_file=fopen(which_file, "r"))){
        fclose(my_file);
        return(1);
    }
    return(0);
}

int just_executes_the_proggy(const char *given_command_line)
{
    char my_command[500];
    char my_args[500];
    char *where_to_cut;

    my_command[0]=0;
    my_args[0]=0;
    strcpy(my_command, given_command_line);
    if((where_to_cut=strchr(my_command, ' '))){
        *where_to_cut=0;
        where_to_cut++;
        strcpy(my_args, where_to_cut);
    }

    return(netconf_system_if(my_command, my_args));
}

/* execute command line and gets the string output.
   returns the command returncode, or -1 if failure */
int execute_proggy_and_get_stdout(const char *given_command_line, char *output_buffer, int output_buffer_size)
{

/*    FILE *my_pseudo_file;
    int  myretcod;
    char mytrash[1000];
    int  my_space_left;
    char *where_to_write;

    my_space_left=output_buffer_size;
    if(my_space_left)     // for safety purposes
        my_space_left--;
    where_to_write=output_buffer;
    myretcod=-1;
    if(output_buffer)
        *output_buffer=0;

    if((my_pseudo_file=popen(given_command_line, "r"))){
        while(my_space_left){
            if(!fgets(where_to_write, my_space_left, my_pseudo_file)){
                my_space_left=0;
            } else {
                my_space_left-=strlen(where_to_write);
                where_to_write+=strlen(where_to_write);
            }
        }
        while(fgets(mytrash, 800, my_pseudo_file));
        myretcod=pclose(my_pseudo_file);
    }
    return(myretcod);
    */

    char my_command[500];
    char my_args[500];
    char *where_to_cut;

    *output_buffer=0;

    my_command[0]=0;
    my_args[0]=0;
    strcpy(my_command, given_command_line);
    if((where_to_cut=strchr(my_command, ' '))){
        *where_to_cut=0;
        where_to_cut++;
        strcpy(my_args, where_to_cut);
    }

    POPEN my_popen(my_command, my_args);
    while(!my_popen.wait(5000, 0));

    {
        int my_rem_bytes=output_buffer_size;
        int my_step;

        while((my_step=my_popen.readoutraw((output_buffer+strlen(output_buffer)), my_rem_bytes))){
            my_rem_bytes-=my_step;
            my_popen.wait(5000, 0);
        }
    }

    return(my_popen.close());
}

/* erase all directory's files and, then, the directory itself */
/* (does not remove internal subdirectories) */
/* returns zero if ok, nonzero if unsuccessful */
int zaapboom_directory(char *which_one)
{
    DIR *my_dir;
    struct dirent *ent;
    char tempy[2048];

    if((my_dir=opendir(which_one))){
        while((ent=readdir(my_dir))){
            if(strcmp(ent->d_name, ".")&&strcmp(ent->d_name, "..")){
                sprintf(tempy, "%s/%s", which_one, ent->d_name);
                unlink(tempy);
            }
        }
        closedir(my_dir);
    }
    return(rmdir(which_one));
}

void informational_window(const char *my_title, const char *my_text)
{
    dialog_msgbox (my_title, my_text, "");
}

/* loads the pointed .config (if it exists) file and returns the printer type
0- local or remote
PRT_SMBWIN 2
PRT_NETWARE 3
 used because the return_printer_type(N) is not absolutely
 correct while determining SMB or NCP printers */
int return_printer_type_from_generalcfg(char *given_filename)
{
    FILE *dotconfigfile;
    int  myfilesize;
    char *my_buff;
    int  my_prt_type=0;

    if((dotconfigfile=fopen(given_filename, "r"))){
        fseek(dotconfigfile, 0, SEEK_END);
        myfilesize=ftell(dotconfigfile);
        fseek(dotconfigfile, 0, SEEK_SET);

        if((my_buff=(char *)malloc(myfilesize+1))){
            if(fread(my_buff, myfilesize, 1, dotconfigfile)){
                *(my_buff+myfilesize)=0;
                if(strstr(my_buff, "share=")||
                   strstr(my_buff, "hostip=")||
                   strstr(my_buff, "workgroup="))
                    my_prt_type=PRT_SMBWIN; /* smb */
                if(strstr(my_buff, "server=")||
                   strstr(my_buff, "queue="))
                    my_prt_type=PRT_NETWARE; /* ncp */
                if(strstr(my_buff, "printer_ip=")||
                   strstr(my_buff, "port="))
                    my_prt_type=PRT_DIRECT; /* direct */
            }
            free(my_buff);
        }
        fclose(dotconfigfile);
    }
    return(my_prt_type);
}

/* looks at variables and returns the printer type analysing the context */
/* from printcap file */
int return_printer_type(int which_printer)
{
    if(strlen(my_printcap[which_printer].rm))
        return(PRT_REMOTE);


    /* determines if printer is SMB or NCP */
    if(!strcmp(my_printcap[which_printer].lp, "/dev/null")){
        char dotconfig_fullpath[500];
        int my_prt_type;

        sprintf(dotconfig_fullpath, "%s/%s", my_printcap[which_printer].sd, DOTCONFIG_FILENAME);

        /* .config file analysis result takes priority over printcap's */
        if((my_prt_type=return_printer_type_from_generalcfg(dotconfig_fullpath))){
            return(my_prt_type);
        } else {
            if(strstr(my_printcap[which_printer].if_, "smb"))
                return(PRT_SMBWIN);
            return(PRT_NETWARE);
        }
    }
    return(PRT_LOCAL);
}

/* return true if yes, false if no */
int confirm_yesno_window(const char *my_title, const char *my_text)
{
    if(dialog_yesno(my_title, my_text, help_nil)==MENU_YES){
        return(1);
    } else {
        return(0);
    }
}
