// vim: nowrap

#include "postfixconf.h"
#include "postfixconf.m"
#include <string.h>

/*
DESCRIPTION: Edit basic configurations of postfix. Some variables can't left be empty. Some variables can be a path for directory
RETURN: 0 - if the user cancel
        1 - if the user accept
*/
PUBLIC int MODULE_postfixconf::basic_edit(DATAMAIN &data)
{	
	int ret = 0;
	int nof = 0;
	DIALOG dia;
	SSTRING *st;

	// - - - Local path information - - -
	dia.newf_title (MSG_U(T_LOCALPATH,"Local path information"),1,"",MSG_R(T_LOCALPATH));
	// queue_directory	nof=1
	dia.newf_str(MSG_U(F_DIRPATH,"Queue directory"),*(data.getvarvariable(V_QUEUE_DIRECTORY)));
	
	// command_directory	nof=2
	dia.newf_str (MSG_U(F_COMMDIR,"Command directory"),*(data.getvarvariable(V_COMMAND_DIRECTORY)));
	
	// daemon_directory	nof=3
	dia.newf_str(MSG_U(F_DAEMDIR,"Daemon directory"),*(data.getvarvariable(V_DAEMON_DIRECTORY))); 
	
	// - - - Queue and process ownership - - -
	dia.newf_title (MSG_U(T_QUEUEPROCOWN,"Queue and process ownership"),1,"",MSG_R(T_QUEUEPROCOWN));
	// mail_owner		nof=5
	dia.newf_str(MSG_U(F_MAILOWNER,"Mail owner"),*(data.getvarvariable(V_MAIL_OWNER)));
	
	// default_privs	nof=6
	dia.newf_str(MSG_U(F_DEFPRIVI,"Default privileges"),*(data.getvarvariable(V_DEFAULT_PRIVS)));
	
	// - - - Internet host and domain names - - -
	dia.newf_title (MSG_U(T_NETHOSTDOMNAMES,"Internet host and domain names"),1,"",MSG_R(T_NETHOSTDOMNAMES));
	// myhostname		nof=8
	st = data.getvarvariable(V_MYHOSTNAME);
	dia.newf_str(MSG_U(F_HOSTNAME,"Hostname"),*(st));

	//mydomain		nof=9
	st = data.getvarvariable(V_MYDOMAIN);
	dia.newf_str(MSG_U(F_DOMAIN,"Domain"),*(st));
	
	// - - - Sending mail - - -
	dia.newf_title (MSG_U(T_SENDINGMAIL,"Sending mail"),1,"",MSG_R(T_SENDINGMAIL));
	// myorigin		nof=11
	st = data.getvarvariable(V_MYORIGIN);
	int val_myorigin = 0;
	const int str_myorigin[] = {0,1,2};
	const char *title_myorigin[] = {MSG_U(X_HOSTNAME,"hostname"),MSG_U(X_DOMAIN,"domain"),NULL};
	if (st->cmp("$myhostname")==0)		val_myorigin = 0;
	else if (st->cmp("$mydomain")==0)	val_myorigin = 1;
	else val_myorigin = 2;
	
	dia.newf_chkm_str(MSG_U(F_MYORIGIN,"Origin"), val_myorigin, *(st), str_myorigin, title_myorigin);

	// - - - Receiving mail - - -
	dia.newf_title (MSG_U(T_RECEIVINGMAIL,"Receiving mail"),1,"",MSG_R(T_SENDINGMAIL));
	// inet_interfaces	nof=13
	st = data.getvarvariable(V_INET_INTERFACES);
	char var_inet;
	if (st->strstr("all"))
		var_inet = 0;
	else if (st->strstr("$myhostname")){
		if (st->strstr("localhost"))
			var_inet = 2;
		else	var_inet = 1;
	}
	static const char *opt_inet[] = {
		MSG_U(X_ALL,"all"),
		MSG_R(X_HOSTNAME),
		MSG_U(X_HOSTNAMELOCALHOST,"hostname, localhost"),
		NULL
	};
	
	for (int i=0; opt_inet[i]!=NULL; i++){
		if (i==0)
			dia.newf_radio (MSG_U(F_INETINETRFACES,"Network interfaces"),var_inet,i,opt_inet[i]);
		else	dia.newf_radio ("",var_inet,i,opt_inet[i]);
	}

	// mydestination		nof=14
	st = data.getvarvariable(V_MYDESTINATION);
	dia.newf_str(MSG_U(F_MYDESTINATION,"Destination"),*(st));
		
	// - - - Rejecting unknown local users - - -
	dia.newf_title (MSG_U(T_REJUNKLOCUSER,"Rejecting unknown local users"),1,"",MSG_R(T_REJUNKLOCUSER));
	// local_recipient_maps		nof=16
	dia.newf_str(MSG_U(F_LOCRECMAPS,"Local recipient maps"),*(data.getvarvariable(V_LOCAL_RECIPIENT_MAPS)));
	
	// - - - Debugging control - - -
	dia.newf_title (MSG_U(T_DEBUGGINGCTRL,"Debugging control"),1,"",MSG_R(T_DEBUGGINGCTRL));

	// debug_peer_level		nof=18
	int val_debug_peer_level = data.getvarvariable(V_DEBUG_PEER_LEVEL)->getval();
	dia.newf_num (MSG_U(F_DEBUGPEERLEVEL,"Debug peer level"), val_debug_peer_level);

	// debug_peer_list		nof=19
	dia.newf_str(MSG_U(F_DEBUGPEERLST,"Debug peer list"),*(data.getvarvariable(V_DEBUG_PEER_LIST)));
	
	// debugger_command		nof=20
	dia.newf_str(MSG_U(F_DEBUGGERCMD,"Debugger command"),*(data.getvarvariable(V_DEBUGGER_COMMAND)));

	dia.setbutinfo (MENU_USR1, MSG_U(B_SETTODEFAULT,"Set to default"), MSG_R(B_SETTODEFAULT));
	
	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_BASIC,"Basic Postfix configuration")
			,""
			,help_postfix_basic
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1);	
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			// validations

			// queue_directory
			if (data.is_varempty(V_QUEUE_DIRECTORY) ){
				nof=1;
				xconf_notice (MSG_R(N_NOTEMPTY));
				continue;
			}

			// command_directory
			if (data.is_varempty(V_COMMAND_DIRECTORY) ){
				nof=2;
				xconf_notice (MSG_R(N_NOTEMPTY));
				continue;
			}
			
			// daemon_directory
			if (data.is_varempty(V_DAEMON_DIRECTORY) ){
				nof=3;
				xconf_notice (MSG_R(N_NOTEMPTY));
				continue;
			}

			// mail_owner
			if (data.is_varempty(V_MAIL_OWNER)){
				nof=5;
				xconf_notice (MSG_U(N_NOTEMPTY,"This option can't be left empty!"));
				continue;
			}
	
			// myhostname
			if (data.is_varempty(V_MYHOSTNAME)){
				nof=8;
				xconf_notice (MSG_R(N_NOTEMPTY));
				continue;
			}

			// mydomain
			if (data.is_varempty(V_MYDOMAIN)){
				nof=9;
				xconf_notice (MSG_R(N_NOTEMPTY));
				continue;
			}

			// myorigin
			st = data.getvarvariable(V_MYORIGIN);
			switch (val_myorigin){
				case 0:
					st->setfrom("$myhostname");
					break;
				case 1:
					st->setfrom("$mydomain");
			}
			
			if (val_myorigin == 2 && data.is_varempty(V_MYORIGIN)){
				nof=11;
				xconf_notice (MSG_R(N_NOTEMPTY));
				continue;
			}

			// inet_interfaces
			st = data.getvarvariable(V_INET_INTERFACES);
			switch (var_inet){
				case 0:
					st->setfrom("all");
					break;
				case 1:
					st->setfrom("$myhostname");
					break;
				case 2:
					st->setfrom("$myhostname, localhost");
					break;
			}
		
			// debug_peer_level
			data.getvarvariable(V_DEBUG_PEER_LEVEL)->setfrom(val_debug_peer_level);

			ret = 1;
			break;
		}else if (code == MENU_USR1){
			if ( dialog_yesno(MSG_U(T_RESTORETODEFAULT,"Default values")
					 ,MSG_U(N_RESTORETODEFAULT,"Are you sure you want to restore the default values?\n\n"
						                   "Note that you won't be able to undo these changes.")
					 ,help_postfix_basic) == MENU_YES ){
				int values[]={
						V_QUEUE_DIRECTORY,
						V_COMMAND_DIRECTORY,
						V_DAEMON_DIRECTORY,
						V_MAIL_OWNER,
						V_DEFAULT_PRIVS,
						V_MYHOSTNAME,
						V_MYDOMAIN,
						V_MYORIGIN,
						V_INET_INTERFACES,
						V_MYDESTINATION,
						V_LOCAL_RECIPIENT_MAPS,
						V_DEBUG_PEER_LEVEL,
						V_DEBUG_PEER_LIST,
						V_DEBUGGER_COMMAND,
						-1
				};
				data.setdefaultvarvalues(values); // switch to default values
		
				// inet_interfaces
				st = data.getvarvariable(V_INET_INTERFACES);
				if (st->strstr("all"))
					var_inet = 0;
				else if (st->strstr("$myhostname")){
					if (st->strstr("localhost"))
						var_inet = 2;
					else	var_inet = 1;
				}

				// myorigin
				st = data.getvarvariable(V_MYORIGIN);
				if (st->cmp("$myhostname")==0)		val_myorigin = 0;
				else if (st->cmp("$mydomain")==0)	val_myorigin = 1;
				else val_myorigin = 2;
		
				val_debug_peer_level=data.getvarvariable(V_DEBUG_PEER_LEVEL)->getval();
				
				dia.reload();
			}
		}
	}
	return ret;
}
