/* manages the /etc/securetty file */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "pamconf.h"
#include "pamconf.m"
#include "pamconf_tools.h"
#include "fviews.h"

void securetty_window(void)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    VIEWITEMS_PARSER pre_my_vitems;

    while(1){
        VIEWITEMS my_vitems(pre_my_vitems);
        my_vitems.read(cf_securetty); // load file data

        my_dialog.remove_all(); // cleans window
        my_dialog.newf_head("", MSG_U(F_STAUTHPORTS, "authorized ports"));
        dump_viewitems_to_list(my_dialog, my_vitems, 1);

        /* opens dialog.. */
        my_selection=0;
        my_button=my_dialog.editmenu(MSG_U(T_STAUTHPORTS, "Authorized ports (pam_securetty.so)"), MSG_U(I_STAUTHPORTS, "These are the terminals the root user\nmay use to login."), hf_list_edit, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            {
                SSTRING newentry_name;
                int please_loop=1;

                while(please_loop){
                    if(ask_a_name(MSG_U(T_STNEWAUTHENTRY, "New authorization entry"), "", MSG_U(F_STNEWAUTHENTRY, "Name for this new entry:"), newentry_name, 1)){
                        if(!my_vitems.locate(newentry_name.get(), 0, my_vitems.getnb())){
                            /* insert entry.. */
                            /* puts at the end of list, does not order */
                            my_vitems.add(new VIEWITEM(newentry_name.get()));

                            my_vitems.write(cf_securetty, NULL);
                            please_loop=0;
                        }else{
                            informational_window(MSG_U(T_STREPEATEDNAME, "Repeated name given"), MSG_U(I_STREPEATEDNAME, "You must provide an unique name\nfor this item."));
                        }
                    }else{
                        please_loop=0;
                    }
                }
            }
            break;
        default:
            {
                DIALOG mini_dialog;
                MENU_STATUS mini_button=MENU_NULL;
                int         mini_selection=0;
                SSTRING mini_title;

                mini_title.setfromf(MSG_U(T_STAUTHENTRY, "Auth entry \"%s\""), my_vitems.getitem(my_selection)->line.get());

                mini_button=mini_dialog.edit(mini_title.get(), MSG_U(I_STAUTHENTRYDEL, "Do you want to delete this entry?"), help_nil, mini_selection, MENUBUT_QUIT|MENUBUT_DEL);
                if(mini_button==MENU_DEL){
                    my_vitems.remove_del(my_selection);

                    my_vitems.write(cf_securetty, NULL);
                }
            }
            break;
        }

    }


}

