#!/bin/sh
# This script try to setup a minimal admin tree so linuxconf
# can start administrating it without complaing too much

# Copy a file if it exists, create it empty if not
# cpif dir file
cpif(){
	if [ -f /$1/$2 ] ; then
		cp /$1/$2 $1/$2
	else
		touch $1/$2
	fi
}

if [ $# != 1 ] ; then
	echo admin sub-dir must be specified
else
	DIR=/etc/linuxconf/admtrees/$1
	mkdir -p $DIR
	cd $DIR
	mkdir etc etc/linuxconf var var/named etc/ppp
	touch etc/passwd etc/group etc/fstab etc/mtab
	touch etc/hosts etc/networks etc/conf.linuxconf
	touch etc/aliases

	for f in host.conf resolv.conf shells syslog.conf yp.conf \
		services inetd.conf protocols
	do
		cpif etc $f
	done
fi	


