
/*
 this program here has two purposes:
 - reset the mouse in XFree86 after Kudzu usage
 (kudzu messes the mouse so it doesn't work in X after probing)
 - set new parameters for XFree mouse on-the-fly
 */

// #include "X11/extensions/xf86misc.h"
// #include <X11/Xlib.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/extensions/xf86misc.h>
// #include <dlfcn.h>

#define m_device argv[1]
#define m_protocol argv[2]
#define m_samplerate return_former_if_no_newer_int(argv[3], mouse.samplerate)
#define m_resolution return_former_if_no_newer_int(argv[4], mouse.resolution)
#define m_buttons return_former_if_no_newer_int(argv[5], mouse.buttons)
#define m_emulate3buttons return_former_if_no_newer_Bool(argv[6], mouse.emulate3buttons)
#define m_emulate3timeout return_former_if_no_newer_int(argv[7], mouse.emulate3timeout)

#define KEEP_THE_SAME_FOR_THIS_ONE "default"
#define STR_BOOL_TRUE "1"
#define STR_BOOL_FALSE "0"

int return_mouse_type(const char *given_protocol)
{
    if (strcasecmp(given_protocol, "BusMouse") == 0)
	return(MTYPE_BUSMOUSE);
    else if (strcasecmp(given_protocol, "GlidePoint") == 0)
	return(MTYPE_GLIDEPOINT);
    else if (strcasecmp(given_protocol, "IntelliMouse") == 0)
	return(MTYPE_IMSERIAL);
    else if (strcasecmp(given_protocol, "Logitech") == 0)
	return(MTYPE_LOGITECH);
    else if (strcasecmp(given_protocol, "Microsoft") == 0)
	return(MTYPE_MICROSOFT);
    else if (strcasecmp(given_protocol, "MMHitTab") == 0)
	return(MTYPE_MMHIT);
    else if (strcasecmp(given_protocol, "MMSeries") == 0)
	return(MTYPE_MMSERIES);
    else if (strcasecmp(given_protocol, "MouseMan") == 0)
	return(MTYPE_LOGIMAN);
    else if (strcasecmp(given_protocol, "MouseSystems") == 0)
	return(MTYPE_MOUSESYS);
    else if (strcasecmp(given_protocol, "PS/2") == 0)
	return(MTYPE_PS_2);
    else if (strcasecmp(given_protocol, "SysMouse") == 0)
	return(MTYPE_SYSMOUSE);
    else if (strcasecmp(given_protocol, "ThinkingMouse") == 0)
	return(MTYPE_THINKING);
    else
	return(MTYPE_AUTOMOUSE);
}

/* return one of these two: the newer value or the older one if
 the newer one is undefined */
int return_former_if_no_newer_int(const char *newer_one, int older_one)
{
    if(!strcmp(newer_one, KEEP_THE_SAME_FOR_THIS_ONE))
        return(older_one);
    return(atoi(newer_one));
}

Bool return_former_if_no_newer_Bool(const char *newer_one, Bool older_one)
{
    if(!strcmp(newer_one, KEEP_THE_SAME_FOR_THIS_ONE))
        return(older_one);

    if(!strcmp(newer_one, STR_BOOL_TRUE))
        return(True);
    return(False);
}

/* returns 0 if ok, !=0 if error */
// int restart_Xmouse(int argc, char *argv[])
int main(int argc, char *argv[])
{
    Display *dpy;
    XF86MiscMouseSettings mouse;
    char *device;

    void *lib_handle;

    if (!(dpy = XOpenDisplay (""))){
        printf("XF ST LINK OK\nXF NOT RUNNING HERE!\n(nothing to do)");
        return 1;
    }

    /* if XF86 version is requested.. act differently */
    if(!strcmp(argv[1], "which_xf86_version")){
        printf("release: %d\n", VendorRelease(dpy)/1000);
        exit(0);
    }

    /*
     * Reopen the mouse as /dev/null to free the previous
     * file descriptor
     */
    XF86MiscGetMouseSettings (dpy, &mouse);
    device = mouse.device;
    mouse.device = "/dev/null";
    mouse.flags |= MF_REOPEN;
    XF86MiscSetMouseSettings (dpy, &mouse);
    XFlush (dpy);

    /*
     * Now reopen the mouse device
     */
    XF86MiscGetMouseSettings (dpy, &mouse);
    mouse.device = device;
    mouse.flags = MF_REOPEN;

    /* now redefines the data
       (except for the fields set as 'default') */
    if(strcmp(mouse.device, KEEP_THE_SAME_FOR_THIS_ONE))
        strcpy(mouse.device, m_device);

    if(strcmp(m_protocol, KEEP_THE_SAME_FOR_THIS_ONE))
        mouse.type=return_mouse_type(m_protocol);

    mouse.samplerate=m_samplerate;
    mouse.resolution=m_resolution;
    mouse.buttons=m_buttons;
    mouse.emulate3buttons=m_emulate3buttons;
    mouse.emulate3timeout=m_emulate3timeout;

    XF86MiscSetMouseSettings (dpy, &mouse);
    XFlush (dpy);

    printf("XF ST LINK OK\nXF MOUSE RST OK\nhave a nice day.\n");
    return 0;
}

