/* ***********
	To create this module, I ran the setupmod.sh script while in the
	modules/ sub-directory. I answered the few question and end up with
	this source file, a Makefile and a _dict.c.

	After I have stuffed the code needed for the module, I ran

	make msg

		to create the message dictionnary

	by hand	

		update motd.h and stuffed the various prototype

	make

		to compile it

	make install

		as root, to install the module.
		Then I ran linuxconf, visit the "control files and systems"
		menu and then the "linuxconf modules" menu and add the "motd"
		module there. Imediatly, I was able to

			-change the /etc/motd from the user account menu at the end
			-assign co-administrator for that task

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "motd.h"
#include "motd.m"
#include <translat.h>
#include <subsys.h>
#include <userconf.h>
#include <stdlib.h>

static HELP_FILE help_motd ("motd","motd");
static const char subsys_motd[]="motd";
static LINUXCONF_SUBSYS subb (subsys_motd,P_MSG_U(M_motd,"Message of the day"));
static PRIVILEGE p_motd ("motd",P_MSG_R(M_motd)
	,P_MSG_U(T_PMISC,"9-Miscellaneous"));


static CONFIG_FILE f_motd ("/etc/motd",help_motd
		,CONFIGF_OPTIONNAL|CONFIGF_MANAGED
		,subsys_motd);


MODULE_DEFINE_VERSION(motd);

PUBLIC MODULE_motd::MODULE_motd()
	: LINUXCONF_MODULE("motd")
{
	linuxconf_loadmsg ("motd",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_motd::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_USER_POLICIES){
		keymenu = MSG_R(M_motd);
		dia.new_menuitem ("",keymenu);
	}
}

static void motd_edit()
{
    FILE_CFG *my_file;
    char *my_buff=NULL; // where the readen file is dumped to
    int my_filesize;
    SSTRING motd_text;

    /* reads file to memory */
    if ((my_file=f_motd.fopen("r"))){
        fseek(my_file, 0, SEEK_END);
        my_filesize=ftell(my_file);
        fseek(my_file, 0, SEEK_SET);

        if((my_buff=(char *)malloc(my_filesize+1))){
            *my_buff=0;
            fread(my_buff, my_filesize, 1, my_file);
            *(my_buff+my_filesize)=0;
            motd_text.setfrom(my_buff);
            free(my_buff);
        }
        fclose(my_file);
    }

    {
        DIALOG my_dialog;
        MENU_STATUS my_button=MENU_NULL;
        int         my_selection=0;

        my_dialog.newf_textarea(MSG_U(F_MOTD,"Text of the message"), motd_text, 30, 10);
        my_selection=0;
        my_button=my_dialog.edit(MSG_R(M_motd), MSG_U(I_MOTD,"The following message is shown each time\na user is login in"),
                                 help_motd, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT);
        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ACCEPT:
            if ((my_file=f_motd.fopen("w"))){
                fwrite(motd_text.get(),  motd_text.getlen(), 1, my_file);
                fclose(my_file);
            }
            return;
        default:
            break;
        }
    }
}


PUBLIC int MODULE_motd::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_USER_POLICIES){
		if (key == keymenu){
			motd_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_motd::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"motd")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module motd\n"
		 "linuxconf --modulemain motd [ specific options ]\n"
		 "\n"
		 "    No command line option\n"
		 "\n")
		);
}

PUBLIC int MODULE_motd::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"motd")==0){
		ret = -1;
		if (argc == 1){
                    // ### Place call to main menu of the module
                    motd_edit();
                }else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_motd motd;

#include "modregister.h"
static REGISTER_VARIABLE_LOOKUP_MSG motd_var_list1[]={
	{ "text", NULL, P_MSG_R(F_MOTD), &motd_edit, NULL},
	{ NULL, NULL, NULL, NULL }
};

static REGISTER_VARIABLES motd_registry1("motd",motd_var_list1);

