#ifndef INETDCONF_APIDEF_H
#define INETDCONF_APIDEF_H

/*
 * server_path_check:	Read /etc/inetd.conf and log services where server
 *			path is invalid.
 * server_path_check_update: Read /etc/inetd.conf and disable services where
 *			server path is invalid.
 * enable_service:	Enable/disable (enable) named services (argc, service)
 * firewall_enable:	Enable internet firewall (with daemon monitor) and
 *			optionally accept named services (argc, service).
 * firewall_disable:	Disable firewall (remove rules, leave masquerading
 *			in place).
 * firewall_edit:	Accept/deny services in firewall.
 */
struct INETDCONF_API{
	void (*server_path_check) ( void );
	void (*server_path_check_update) ( void );
	void (*enable_service) ( int argc, char *service[], int enable );
	void (*firewall_enable) ( int argc, char *service[] );
	void (*firewall_disable) ( void );
	void (*firewall_edit) ( void );
};

#endif

