/*

 Marsconf 1.0 - the MARS configurator
 by Daniel Mealha Cabrita (dancab@conectiva.com)

 1.0 - first version (march 22th, 2001)


 */



#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "marsconf.h"
#include "marsconf.m"

#include "mc_main.cc"


MODULE_DEFINE_VERSION(marsconf);

PUBLIC MODULE_marsconf::MODULE_marsconf()
	: LINUXCONF_MODULE("marsconf")
{
	linuxconf_loadmsg ("marsconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_marsconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_marsconf,"Mars configurator");
		dia.new_menuitem ("marsconf","",keymenu);
	}
}

PUBLIC int MODULE_marsconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
                    main_window();
                    // ### Place the call to the edit function here
		}
	}
	return 0;
}


PUBLIC int MODULE_marsconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"marsconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain marsconf usage\n"
		 "\n"
		 "    marsconf --option ...\n")
		);
}

PUBLIC void MODULE_marsconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_marsconf::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"marsconf")==0){
		ret = -1;
		if (argc == 1){
                    main_window();
                    // ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_marsconf marsconf;

