#include <stdlib.h>
#include <netconf.h>
#include "kernelconf.h"
#include "kernelconf.m"

#define FS_FILE_MAX "fs.file-max"
#define FS_INODE_MAX "fs.inode-max"
#define FS_DQUOT_MAX "fs.dquot-max"
#define FS_SUPER_MAX "fs.super-max"
#define KERNEL_CTRL_ALT_DEL "kernel.ctrl-alt-del"
#define KERNEL_FAIRSCHED "kernel.fairsched"
#define KERNEL_SHMMAX "kernel.shmmax"

static HELP_FILE help_kernelconf("kernelconf","kernelconf");

int kernelconf_edit()
{
	int ret = -1;
	const char *chk[] = {"enable","disable","default",NULL};
	const char *num[] = {"default",NULL};
	const int num_vals[] = {-1};
	DIALOG dia;
	SYSCTL sysctl;
	dia.newf_title(MSG_U(F_FS,"File System"),1,"",MSG_R(F_FS));

	/* file_max */
	const char *file_max = sysctl.get_from_file(FS_FILE_MAX);
	int i_file_max;
	if (file_max == NULL){
		file_max = sysctl.get_from_sys(FS_FILE_MAX);
		if (file_max != NULL){
			i_file_max = -1;
			dia.newf_chkm_num(MSG_U(F_MAXFILE,"Max. file handles"),i_file_max,atoi(file_max),num_vals,num);
		}
	}else{
		i_file_max = atoi(file_max);
		dia.newf_chkm_num(MSG_R(F_MAXFILE),i_file_max,num_vals,num);
	}
			
	/* inode_max */
	const char *inode_max = sysctl.get_from_file(FS_INODE_MAX);
	int i_inode_max;
	if (inode_max == NULL){
		inode_max = sysctl.get_from_sys(FS_INODE_MAX);
		if (inode_max != NULL){
			i_inode_max = -1;
			dia.newf_chkm_num(MSG_U(F_MAXINODE,"Max. inode handles"),i_inode_max,atoi(inode_max),num_vals,num);
		}
	}else{
		i_inode_max = atoi(inode_max);
		dia.newf_chkm_num(MSG_R(F_MAXINODE),i_inode_max,num_vals,num);
	}
	
	/* dquot_max */
	const char *dquot_max = sysctl.get_from_file(FS_DQUOT_MAX);
	int i_dquot_max;
	if (dquot_max == NULL){
		dquot_max = sysctl.get_from_sys(FS_DQUOT_MAX);
		if (dquot_max != NULL){
			i_dquot_max = -1;
			dia.newf_chkm_num(MSG_U(F_MAXDQUOT,"Max. num. cached disk quota"),i_dquot_max,atoi(dquot_max),num_vals,num);
		}
	}else{
		i_dquot_max = atoi(dquot_max);
		dia.newf_chkm_num(MSG_R(F_MAXDQUOT),i_dquot_max,num_vals,num);
	}
	
	/* super_max */
	const char *super_max = sysctl.get_from_file(FS_SUPER_MAX);
	int i_super_max;
	if (super_max == NULL){
		super_max = sysctl.get_from_sys(FS_SUPER_MAX);
		if (super_max != NULL){
			i_super_max = -1;
			dia.newf_chkm_num(MSG_U(F_MAXSUPER,"Max. super block handlers"),i_super_max,atoi(super_max),num_vals,num);
		}
	}else{
		i_super_max = atoi(super_max);
		dia.newf_chkm_num(MSG_R(F_MAXSUPER),i_super_max,num_vals,num);
	}
	
	dia.newf_title(MSG_U(T_GENERAL,"General"),1,"",MSG_R(T_GENERAL));
	
	/* ctrl_alt_del */
	const char *ctrl_alt_del = sysctl.get_from_file(KERNEL_CTRL_ALT_DEL);
	char i_ctrl_alt_del;
	if (ctrl_alt_del == NULL){
		ctrl_alt_del = sysctl.get_from_sys(KERNEL_CTRL_ALT_DEL);
		if (ctrl_alt_del != NULL){
			i_ctrl_alt_del = 2;
			dia.newf_chkm(MSG_U(F_CTRLALTDEL,"Ctrl-alt-del"),i_ctrl_alt_del,chk);
		}
	}else{
		i_ctrl_alt_del = !atoi(ctrl_alt_del);
		dia.newf_chkm(MSG_R(F_CTRLALTDEL),i_ctrl_alt_del,chk);
	}
	
	/* fairsched */
	const char *fairsched = sysctl.get_from_file(KERNEL_FAIRSCHED);
	char i_fairsched;
	if (fairsched == NULL){
		fairsched = sysctl.get_from_sys(KERNEL_FAIRSCHED);
		if (fairsched != NULL){
			i_fairsched = 2;
			dia.newf_chkm(MSG_U(F_FAIRSCHED,"Fair scheduler"),i_fairsched,chk);
		}
	}else{
		i_fairsched = !atoi(fairsched);
		dia.newf_chkm(MSG_R(F_FAIRSCHED),i_fairsched,chk);
	}

	/* shmmax */
	const char *shmmax = sysctl.get_from_file(KERNEL_SHMMAX);
	int i_shmmax = -1;
	if (shmmax == NULL){
		shmmax = sysctl.get_from_sys(KERNEL_SHMMAX);
		if (shmmax != NULL){
			dia.newf_chkm_num(MSG_U(F_SHMMAX,"Shared memory size (meg.)")
				,i_shmmax,32,num_vals,num);
		}
	}else{
		i_shmmax = atoi(shmmax)/(1024*1024);
		dia.newf_chkm_num(MSG_R(F_SHMMAX),i_shmmax,32,num_vals,num);
	}
	int nof=0;
	while(1){
		MENU_STATUS code = dia.edit(
				MSG_U(T_KERNELCONF,"Kernel Configuration"),
				MSG_U(I_KERNELCONF, "This dialog allows you to change kernel options. BE CAREFUL!"),
				help_kernelconf,nof,
				MENUBUT_ACCEPT|MENUBUT_CANCEL);
		
		if (code == MENU_ESCAPE || code == MENU_QUIT || code == MENU_CANCEL){
			break;
		}else if (code == MENU_ACCEPT){
			/* file_max */
			if (file_max != NULL) {
				if (i_file_max == -1){
					sysctl.erase(FS_FILE_MAX);
				}else{
					sysctl.set_to_file(FS_FILE_MAX, i_file_max);
				}
			}
			
			/* inode_max */
			if (inode_max != NULL) {
				if (i_inode_max == -1){
					sysctl.erase(FS_INODE_MAX);
				}else{
					sysctl.set_to_file(FS_INODE_MAX, i_inode_max);
				}
			}
			
			/* dquot_max */
			if (dquot_max != NULL) {
				if (i_dquot_max == -1){
					sysctl.erase(FS_DQUOT_MAX);
				}else{
					sysctl.set_to_file(FS_DQUOT_MAX, i_dquot_max);
				}
			}
			
			/* super_max */
			if (super_max != NULL) {
				if (i_super_max == -1){
					sysctl.erase(FS_SUPER_MAX);
				}else{
					sysctl.set_to_file(FS_SUPER_MAX, i_super_max);
				}
			}
			
			/* ctrl_alt_del */
			if (ctrl_alt_del != NULL) {
				if (i_ctrl_alt_del == 2){
					sysctl.erase(KERNEL_CTRL_ALT_DEL);
				}else{
					sysctl.set_to_file(KERNEL_CTRL_ALT_DEL, !((int)i_ctrl_alt_del));
				}
			}
			
			/* fairsched */
			if (fairsched != NULL) {
				if (i_fairsched == 2){
					sysctl.erase(KERNEL_FAIRSCHED);
				}else{
					sysctl.set_to_file(KERNEL_FAIRSCHED, !((int)i_fairsched));
				}
			}
			/* shmmax */
			if (shmmax != NULL) {
				if (i_shmmax == -1){
					sysctl.erase(KERNEL_SHMMAX);
				}else{
					sysctl.set_to_file(KERNEL_SHMMAX, i_shmmax*1024*1024);
				}
			}
			
			ret = 0;
			break;
		}	
	}
	return ret;
}

#define PROBE_OPT(x) \
	do { \
		if (sysctl.probe(x)){ \
			const char *fromfile = sysctl.get_from_file(x); \
			net_prtlog (NETLOG_CMD,"Executing: sysctl -w " x "=%s\n", fromfile); \
			if (!sim){ \
				sysctl.set_to_sys(x, fromfile); \
			} \
		} \
	} while (0)

int kernelconf_probe(bool sim)
{
	SYSCTL sysctl;
	if (!sim){
		net_title(MSG_U(S_CHECKKERNEL,"Checking kernel configuration"));
	}
	PROBE_OPT(FS_FILE_MAX);
	PROBE_OPT(FS_INODE_MAX);
	PROBE_OPT(FS_DQUOT_MAX);
	PROBE_OPT(FS_SUPER_MAX);
	PROBE_OPT(KERNEL_CTRL_ALT_DEL);
	PROBE_OPT(KERNEL_FAIRSCHED);
	PROBE_OPT(KERNEL_SHMMAX);
	return 0;
}

static void kernelconf_edit0()
{
	kernelconf_edit();
}


#include <modregister.h>

static REGISTER_VARIABLE_LOOKUP_MSG kernel_var_list[]={
	{"maxfile",NULL,P_MSG_R(F_MAXFILE),kernelconf_edit0,NULL},
	{"maxinode",NULL,P_MSG_R(F_MAXINODE),kernelconf_edit0,NULL},
	{"dquotmax",NULL,P_MSG_R(F_MAXDQUOT),kernelconf_edit0,NULL},
	{"maxsuper",NULL,P_MSG_R(F_MAXSUPER),kernelconf_edit0,NULL},
	{"ctrlaltdel",NULL,P_MSG_R(F_CTRLALTDEL),kernelconf_edit0,NULL},
	{"fairsched",NULL,P_MSG_R(F_FAIRSCHED),kernelconf_edit0,NULL},
	{"maxshm",NULL,P_MSG_R(F_SHMMAX),kernelconf_edit0,NULL},
	{ NULL, NULL, NULL, NULL }
};
static REGISTER_VARIABLES kernel_registry1("kernel",kernel_var_list);

// vim: nowrap
