#include <string.h>
#include <limits.h>
#include <misc.h>
#include <dialog.h>
#include "main.h"
#include "../paths.h"

/* #Specification: notices / strategy
	Linuxconf use a way to tell important messages to users. Any
	file in /usr/lib/linuxconf/help.lang/notices will be shown to the user
	once. Once read, a line will be stored in /etc/conf.linuxconf.
	This line tells which file was read and tells what was the
	revision date of that file.

	If a language is lacking a notice, the english version is shown.

	So if a file was never shown or its revision date has changed
	since the user has read it, it will be shown again.

	(well, this idea was annoying, so if a file was shown once, even
	 if it was changed, it won't be shown. If it is important, a new
	 notice should be written).

	Those file should be very small and to the point. If they are too
	long, they won't be read.

	It is expected that various notice files will be shipped with
	linuxconf and that the install procedure will write some
	messages in there too.

	Each file name has a numerical 2 digit prefix and a minus sign
	to control the ordering. The first notice is called 00-welcome.
*/

static const char K_NOTICE[]="notice";


void notice_show ()
{
	if (!context_isroot()) return;
	bool change_one = false;
	char path_eng[PATH_MAX], path_lang[PATH_MAX];
	sprintf (path_eng,"%s/help.eng/notices",USR_LIB_LINUXCONF);
	sprintf (path_lang,"%s/help.%s/notices",USR_LIB_LINUXCONF,linuxconf_getlang());
	SSTRINGS tb;
	int nb = dir_getlist (path_eng,tb);
	for (int i=0; i<nb; i++){
		const char *fname = tb.getitem(i)->get();
		if (strstr(fname,".html")==NULL){
			long date_read = linuxconf_getvalnum (K_NOTICE,fname,-1);
			char path[PATH_MAX];
			sprintf (path,"%s/%s",path_eng,fname);
			long fdate = file_date(path);
			if (date_read == -1){
				char path2[PATH_MAX];
				sprintf (path2,"%s/%s",path_lang,fname);
				if (file_exist(path2)){
					dialog_textbox (fname+3,path2);
				}else{
					dialog_textbox (fname+3,path);
				}
				linuxconf_replace (K_NOTICE,fname,fdate);
				change_one = true;
			}
		}
	}
	if (change_one) linuxconf_save();
}

