# Standard rules for building libmodules
# CURDIR must be defined
proto:
	tlproto -m0+ -b$(CURDIR).h+$(CURDIR).pm $(PROTOUPDHEAD) \
		`find . -maxdepth 1 -name \*.cc -o -name \*.tlcc`

ifdef OLDGCC
$(CURDIR).so: $(OBJS)
	@echo Linuxconf can\'t handle a.out module, sorry
else
lib$(CURDIR).so: $(OBJS)
	$(GPPLINK) -g -shared -Wl,-soname,lib$(CURDIR).so.1 -o \
		$(SOPATH) \
		$(OBJS) $(EXTRAMODLIBS)
endif

std_local_clean:
	rm -f lib$(CURDIR).so.* `find . -name \*.bak`

# Check if we are in linuxconf source tree
# If not, we are using resources in linuxconf-devel package
ifeq "$(shell test -x $(LINUXCONF_PATH)/translate/msgcomp && echo ok)" "ok"
MSGCOMP=$(LINUXCONF_PATH)/translate/msgcomp
COPYDIR=../copydir.sh
RPMSPEC=../../builder/module.rpmspec
FILTERSPEC=../../builder/filterspec.sh
else
MSGCOMP=/usr/lib/linuxconf-devel/msgcomp
COPYDIR=/usr/lib/linuxconf-devel/copydir.sh
ifeq "$(shell test -f module.rpmspec && echo ok)" "ok"
RPMSPEC=module.rpmspec
else
RPMSPEC=/usr/lib/linuxconf-devel/module.rpmspec
endif
FILTERSPEC=/usr/lib/linuxconf-devel/filterspec.sh
endif
ifeq ($(shell id -u),0)
ISROOT=1
INSTROOT=-o root -g root
endif

std_local_install:
	mkdir -p $(LIB_LINUXCONF)/libmodules
	mkdir -p $(LIB_LINUXCONF)/images
	mkdir -p $(LIB_LINUXCONF)/help.eng
	install $(INSTROOT) -m 755 $(SOPATH) $(LIB_LINUXCONF)/libmodules
	test ! -f _dict.cc || $(MSGCOMP) -p./ -p$(LINUXCONF_HELP)/ \
		$(LIB_LINUXCONF)/help.eng/$(CURDIR)-msg-$(PACKAGE_REV).eng eE \
		$(CURDIR)
	@if [ -d messages ] ; then \
		for file in messages/*.dic; do \
			if [ -f "$$file" ] ; then \
				LANGID=`basename $$file .dic`; \
				mkdir -p $(LIB_LINUXCONF)/help.$$LANGID; \
				ln -sf $$LANGID.dic messages/$(CURDIR).dic; \
				$(MSGCOMP) -p./ -pmessages/ \
					$(LIB_LINUXCONF)/help.$$LANGID/$(CURDIR)-msg-$(PACKAGE_REV).$$LANGID TE \
					$(CURDIR); \
				rm -f messages/$(CURDIR).dic; \
				fi; \
			done; \
		fi
	@if [ -d descriptions ] ; then \
		for file in descriptions/*; do \
			if [ -f "$$file" ] ; then \
				LANGID=`basename $$file`; \
				mkdir -p $(LIB_LINUXCONF)/descriptions/$$LANGID; \
				install $(INSTROOT) -m 644 $$file $(LIB_LINUXCONF)/descriptions/$$LANGID/$(CURDIR); \
				fi; \
			done; \
		fi
	@if [ -f $(CURDIR).xpm ]; then \
		echo installing $(LIB_LINUXCONF)/images/$(CURDIR).xpm; \
		install $(INSTROOT) -m 644 $(CURDIR).xpm $(LIB_LINUXCONF)/images; \
		fi
	@if [ -f $(CURDIR).gif ]; then \
		echo installing $(LIB_LINUXCONF)/images/$(CURDIR).gif; \
		install $(INSTROOT) -m 644 $(CURDIR).gif $(LIB_LINUXCONF)/images; \
		fi


install_daemons:
	mkdir -p $(LIB_LINUXCONF)/redhat $(LIB_LINUXCONF)/caldera $(LIB_LINUXCONF)/suse \
		$(LIB_LINUXCONF)/conectiva $(LIB_LINUXCONF)/debian $(LIB_LINUXCONF)/std
	$(COPYDIR) redhat	$(LIB_LINUXCONF)
	$(COPYDIR) conectiva	$(LIB_LINUXCONF)
	$(COPYDIR) suse		$(LIB_LINUXCONF)
	$(COPYDIR) caldera	$(LIB_LINUXCONF)
	$(COPYDIR) debian	$(LIB_LINUXCONF)
	$(COPYDIR) std		$(LIB_LINUXCONF)

install_helps:
	for p in help.files/*/Makefile; do cd `dirname $$p`; make install; cd ../..; done

# Rules to build RPM, for module developped outside of the linuxconf source tree

MODULE_REV=$(VERSION)
SOURCEDIR=$(CURDIR)-$(MODULE_REV)
RPMTOPDIR=/usr/src/redhat
RPM=rpm


buildrpm: buildspec buildsrc
	unset LD_PRELOAD ; $(RPM) -ba $(RPMTOPDIR)/SPECS/$(CURDIR)-$(MODULE_REV).spec

buildmyrpm:
	$(MAKE) RPM=myrpm RPMTOPDIR=/tmp/myrpm buildrpm


buildspec:
		sed s/MODULENAME/$(CURDIR)/ $(RPMSPEC) \
			| sed s/PACKAGEREV/$(MODULE_REV)/ \
			| sed s/SOURCE/$(SOURCEDIR).src.tar.gz/ \
			| $(FILTERSPEC) >$(RPMTOPDIR)/SPECS/$(SOURCEDIR).spec

#		)

#grep MODULE_API_VERSION /usr/include/linuxconf/module.h | \
#		( read a b MODULEREV && \
#			| sed s/LINUXCONFAPIREV/LINUXCONFAPIREV$$MODULEREV/ \
#

buildsrc:
	rm -fr /tmp/$(SOURCEDIR)
	mkdir /tmp/$(SOURCEDIR)
	cp -a . /tmp/$(SOURCEDIR)/.
	(cd /tmp/$(SOURCEDIR) && make clean)
	(cd /tmp && tar zcvf $(RPMTOPDIR)/SOURCES/$(SOURCEDIR).src.tar.gz $(SOURCEDIR) )
	rm -fr /tmp/$(SOURCEDIR)


