#pragma interface
#ifndef PARSERS_H
#define PARSERS_H

#ifndef MISC_H
	#include <misc.h>
#endif
#ifndef MODULE_H
	#include <module.h>
#endif

#include <modapi_def.h>
#include <modapi.h>
#include <fviews.h>

class ISC_PARSER: public VIEWITEMS_PARSER{
	SSTRINGS tb;
	char tmp[10000];
	/*~PROTOBEG~ ISC_PARSER */
public:
	ISC_PARSER (void);
	void addline (const char *line);
private:
	void splittmp (void);
public:
	/*~PROTOEND~ ISC_PARSER */
};

class SSTRING_IDX: public SSTRING{
	int index;		// Original index (sequence) of the record
	/*~PROTOBEG~ SSTRING_IDX */
public:
	SSTRING_IDX (const char *val, int idx);
	int getidx (void)const;
	/*~PROTOEND~ SSTRING_IDX */
};

class SSTRING_IDXS: public SSTRINGS{
	/*~PROTOBEG~ SSTRING_IDXS */
public:
	SSTRING_IDX *getitem (int no)const;
	/*~PROTOEND~ SSTRING_IDXS */
};


/*
	Manage multiple VIEWITEMS (generally one and others for
	include files)
*/
class VIEWITEMS_S: public ARRAY{
	VIEWITEMS_PARSER vip_default;
	VIEWITEMS_PARSER &vip;
public:
	int nofile;
	int positer;
	SSTRINGS includes;	// Path of the include files
	/*~PROTOBEG~ VIEWITEMS_S */
public:
	VIEWITEMS_S (VIEWITEMS_PARSER&_vip);
	VIEWITEMS_S (void);
protected:
	virtual int getincludes (VIEWITEMS *items,
		 SSTRINGS&tb);
public:
	VIEWITEMS *getitem (int no)const;
	VIEWITEM *getnext (void);
	VIEWITEM *locate (const char *key);
	int locate_all (const char *key, SSTRING_IDXS&tb);
	int locatesection (const char *keyword,
		 SSTRING_IDXS&tb);
	int read (CONFIG_FILE&conf, bool extract);
	void reset_iter (void);
	int write (CONFIG_FILE&conf)const;
	/*~PROTOEND~ VIEWITEMS_S */
};

class VIEWITEMS_SUB{
protected:
	VIEWITEMS_S &itemss;
public:
	virtual VIEWITEM *locate (const char *key) const = 0;
	virtual void add (VIEWITEM *it) = 0;
	/*~PROTOBEG~ VIEWITEMS_SUB */
public:
	VIEWITEMS_SUB (VIEWITEMS_S&_itemss);
	void remove_del (VIEWITEM *it);
	virtual ~VIEWITEMS_SUB (void);
	/*~PROTOEND~ VIEWITEMS_SUB */
};


// Control edition in an area of a configuration file
class VIEWITEMS_RANGE: public VIEWITEMS_SUB{
protected:
	VIEWITEMS *items;
	int start;
	int end;
	/*~PROTOBEG~ VIEWITEMS_RANGE */
public:
	VIEWITEMS_RANGE (VIEWITEMS_S&_itemss);
	void add (VIEWITEM *it);
	void delall (void);
	VIEWITEM *locate (const char *key)const;
	void resetview (void);
	/*~PROTOEND~ VIEWITEMS_RANGE */
};

// Control edition between <verb value> and </verb>
class VIEW_SECTION: public VIEWITEMS_RANGE{
	SSTRING key;	// Keyword of the section <key value> ... </key>
	/*~PROTOBEG~ VIEW_SECTION */
public:
	VIEW_SECTION (const char *keyword,
		 VIEWITEMS_S&_itemss);
	int setview (const char *value);
private:
	int setview (const char *value, int index);
public:
	int setview (int index);
	void updatehead (const char *val);
	/*~PROTOEND~ VIEW_SECTION */
};


// Control edition of the global features, outside the <verb value> and </verb>
class VIEW_MAIN: public VIEWITEMS_SUB{
	/*~PROTOBEG~ VIEW_MAIN */
public:
	VIEW_MAIN (VIEWITEMS_S&_itemss);
	void add (VIEWITEM *it);
	VIEWITEM *locate (const char *key)const;
	int locate_all (const char *key,
		 SSTRING_IDXS&tb)const;
	int locate_all (const char *key,
		 VIEWITEMS&its)const;
	/*~PROTOEND~ VIEW_MAIN */
};

// Control edition of a set of configuration lines (like load_module)
class VIEW_AREA{
	VIEWITEMS_SUB &sub;
	SSTRING keyword;
	int insert_pos;
	/*~PROTOBEG~ VIEW_AREA */
public:
	VIEW_AREA (const char *_keyword,
		 VIEWITEMS_SUB&_sub);
	int locate (VIEWITEMS&items);
	/*~PROTOEND~ VIEW_AREA */
};

class VIEWEDIT{
public:
	VIEWITEMS_SUB &sub;
	DIALOG &dia;
	class VIEWEDIT_FIELDS *tbf;
	/*~PROTOBEG~ VIEWEDIT */
public:
	VIEWEDIT (VIEWITEMS_SUB&_sub, DIALOG&_dia);
	void newf_chk (const char *title,
		 const char *keyword,
		 const char *intro);
	void newf_chk (const char *title,
		 const char *keyword,
		 const char *intro,
		 int defval);
	FIELD_COMBO *newf_combo (const char *title,
		 const char *keyword);
	void newf_num (const char *title,
		 const char *keyword);
	void newf_num (const char *title,
		 const char *keyword,
		 int defval);
	void newf_str (const char *title,
		 const char *keyword);
	void newf_title (const char *s1,
		 int level,
		 const char *s2,
		 const char *s3);
	void newf_title (const char *s1, const char *s2);
	void update (const char *prefix);
	/*~PROTOEND~ VIEWEDIT */
};



#include "parsers.p"

#endif

