#!/bin/sh
process(){
	while read a b
	do
		if [ "$a" = "***" ] ; then
			a=$b
		fi
		name=`basename $a .help`
		dir=`dirname $a`
		dir=`basename $dir`
		# Make sure this module/directory is part of linuxconf
		# not an externally built module
		if [ -d ../modules/$dir -o -d ../$dir ] ; then
			echo $dir $name
			mkdir -p sources/$dir
			echo $name >>sources/$dir/FILE_LIST
		fi
	done
	cd sources/notices
	for fi in *.sgml
	do
		basename $fi .sgml >>FILE_LIST
	done
	cd ../..
}
if [ $# != 1 ] ; then
	echo
	echo Build the list of help files for each subdirectory
	echo
	echo Called from help.files/Makefile with the command
	echo make list
	echo
elif [ ! -f scripts/build_list.sh ] ; then
	echo
	echo Must be executed from the help.files directory
	echo
elif [ ! -f /bin/linuxconf ] ; then
	echo
	echo Linuxconf must be installed before using this script
	echo
elif [ "$1" = "ok" ] ; then
	rm -f sources/*/FILE_LIST
	for d in sources/*
	do
		if [ -d $d ] ; then
			touch $d/FILE_LIST
		fi
	done
	process
	# This strategy has a flaw. All modules must be enable so the
	# FILE_LIST is properly computed
	# Warn about empty FILE_LIST
	# (do not remove the script if there are no missing module
	FIRST=1
	for d in sources/*
	do
		if [ ! -s $d/FILE_LIST ] ; then
			if [ "$FIRST" = "1" ] ; then
				rm -f /tmp/addmodules.sh /tmp/delmodules.sh
				FIRST=0
			fi
			module=`basename $d`
			echo Module $module not updated
			echo linuxconf --setmod $module >>/tmp/addmodules.sh
			echo linuxconf --unsetmod $module >>/tmp/delmodules.sh
		fi
	done
	if [ "$FIRST" = "0" ] ; then
		echo Do the following sequence to make a complete list
		echo su
		echo \# The following step will add the missing modules
		echo sh /tmp/addmodules.sh
		echo exit
		echo make list
		echo su
		echo \# Get back to the original list
		echo sh /tmp/delmodules.sh
		echo exit
	fi
fi

