#include "diawxxt.h"
/*
	Get the width of a notebook tab
*/
PRIVATE int BOOK::getpadwidth(int no)
{
	dc->SetFont (font_prop);
	float fw,fh;
	dc->GetTextExtent (pads[no]->title,&fw,&fh);
	return (int)(fw + 2 * GetCharWidth());
}

PUBLIC void BOOK::fitstrategie(int left, int top, bool use_cur_dim)
{
	int n = nbc;
	int max_page_width = 0;
	int max_page_height = 0;
	int padswidth = 0;
	int tbw[nbc],tbh[nbc];

	dc->SetFont (font_prop);

	for (int i=0; i<n; i++){
		MFORM_C *item = tbc[i];
		int pagew,pageh;
		if (use_cur_dim){
			item->c->GetSize(&pagew,&pageh);
		}else{
			if (item->pref_width == -1){
				item->c->GetSize(&item->pref_width
					,&item->pref_height);
			}
			pagew = item->pref_width;
			pageh = item->pref_height;
		}
		if (pagew > max_page_width) max_page_width = pagew;
		if (pageh > max_page_height) max_page_height = pageh;
		tbw[i] = pagew;
		tbh[i] = pageh;
		int padwidth = getpadwidth(i);
		pads[i]->start = padswidth;
		padswidth += padwidth;
		pads[i]->stop = padswidth;
	}
	scrollpad = false;
	if (padswidth > max_page_width){
		scrollpad = true;
	}else{
		offpad = 0;
	}
	int padsh = n > 0 ? 20 : 0;
	int bkwidth = max_page_width + left;
	int bkheight = max_page_height + top + padsh;
	b_offsety = bkheight;
	offsetx = left;
	offsety = top + padsh;
	for (int i=0; i<n; i++){
		MFORM_C *item = tbc[i];
		wxWindow *c = item->c;
		FORMBASE *b = (FORMBASE*)c;
		#if 0
			c->SetSize (offsetx,offsety,tbw[i],tbh[i]);
			if (b->may_stretch()){
				b->stretch (bkwidth,tbh[i]);
			}
		#else
			// fprintf (stderr,"layoutbook %d %d %d %d\n",max_page_width,tbw[i],max_page_height,tbh[i]);
			int diffx = max_page_width - tbw[i];
			int diffy = max_page_height - tbh[i];
			b->resizeitems (diffx,diffy);
			b->SetSize (offsetx,offsety,-1,-1);
		#endif
		if (i==nopage){
			c->Show(TRUE);
		}else{
			c->Show(FALSE);
		}
	}
	if (n > 0){
		int minwidth = pads[0]->stop + 25;
		if (bkwidth < minwidth) bkwidth = minwidth;
		SetClientSize (bkwidth+3,bkheight+3);
	}else{
		SetClientSize (0,0);
	}
	setpadvisible (nopage);
}

PUBLIC void BOOK::dolayout(int, int, bool)
{
	fitstrategie (3,0,true);
}


PUBLIC bool BOOK::doalllayout()
{
	bool ret = false;
	int maxw=0,maxh=0;
	for (int i=0; i<nbc; i++){
		MFORM_C *c = tbc[i];
		FORMBASE *b = (FORMBASE*)c->c;
		b->doalllayout();
		if (c->weightx ==0 && c->weighty == 0){
			b->getweight(c->weightx,c->weighty);
		}
		int w,h;
		b->GetSize(&w,&h);
		if (w > maxw) maxw = w;
		if (h > maxh) maxh = h;
	}
	{
		int w,h;
		GetSize(&w,&h);
		if (w < maxw || h < maxh){
			// fprintf (stderr,"BOOK::doalllayout %d %d <> %d %d\n",w,h,maxw,maxh);
			ret = true;
		}
	}
	if (!gettop()->was_resized() || !layout_once || ret){
		fitstrategie (3,0,true);
	}
	if (pref_width == -1) GetSize (&pref_width,&pref_height);
	return ret;
}

